/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.Constants;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ParamVElement;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.CobolRecordAccept;
import com.iscobol.gui.server.DisplayMessageBox;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.StopRunException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class CobolAcceptStack
implements Constants,
RuntimeErrorsNumbers {
    private MyVector stack = new MyVector();

    CobolAcceptStack() {
    }

    static void copy(DisplayWindow dw, MyVector dst, MyVector src) {
        int size = src.size();
        int monId = Factory.getCurrentMonitor().getId();
        for (int i = 0; i < size; ++i) {
            CobolRecordAccept cra = (CobolRecordAccept)src.elementAt(i);
            if (cra == null) continue;
            if (cra.getWindowId() == dw.getTheObjectId() || cra.getWindow() != null && cra.getWindow().getCurrThread() == dw.getCurrThread() && !cra.getWindow().isDestroyed()) {
                dst.add(cra);
                continue;
            }
            if (cra.getKeyStatus() != 95 && cra.getRecordType() != 25 || cra.getEventData2() != monId) continue;
            dst.add(cra);
        }
    }

    public void enableKeyboard(DisplayWindow dw) {
        this.enableKeyboard(dw, null);
    }

    public void enableKeyboard(DisplayWindow dw, ParamVector param) {
        GuiFactory gf = ScreenUtility.getGuiFactory();
        if (dw != null) {
            try {
                if (param != null) {
                    param.addElement(new ParamVElement(2056));
                    dw.startTimer(param);
                    dw.sendParams(param);
                } else {
                    gf.enableKeyboard(dw.getTheObjectId());
                    dw.startTimer(param);
                }
            }
            catch (IOException _ex) {
                ScreenUtility.handleIOException(_ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(CobolRecordAccept cra) {
        CobolAcceptStack cobolAcceptStack = this;
        synchronized (cobolAcceptStack) {
            if (cra == null) {
                System.out.println("OHOHOH!");
            }
            this.stack.add(cra);
            this.notifyAll();
        }
    }

    public CobolRecordAccept pop(DisplayWindow dw) {
        return this.pop(dw, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CobolRecordAccept pop(DisplayWindow dw, ParamVector param) {
        CobolRecordAccept Return2 = null;
        this.enableKeyboard(dw, param);
        try {
            CobolAcceptStack cobolAcceptStack = this;
            synchronized (cobolAcceptStack) {
                MyVector ls = this.stack;
                Return2 = ls.getFirst(dw);
                while (Return2 == null) {
                    if (dw.isThreadWaiting()) {
                        int c = dw.getExecutingExceptionProc() ? 23 : 17;
                        throw new IscobolRuntimeException(c, "" + dw.getWaitingEvent());
                    }
                    if (dw != null && dw.isMDIChild()) {
                        this.enableKeyboard(dw, null);
                        dw.restoreFocusOwner();
                    }
                    this.wait();
                    Return2 = ls.getFirst(dw);
                    if (Return2 != null) continue;
                    ls = this.stack;
                    Return2 = ls.getFirst(dw);
                }
                if (ls == this.stack && ls.size() > 0) {
                    this.stack = new MyVector();
                }
                if (ls.size() > 0) {
                    CobolAcceptStack.copy(dw, this.stack, ls);
                }
            }
        }
        catch (InterruptedException _ex) {
            throw new StopRunException();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CobolRecordAccept popAnswerAction(DisplayWindow dw, BaseGUIControl bgc) {
        CobolRecordAccept Return2 = null;
        try {
            CobolAcceptStack cobolAcceptStack = this;
            synchronized (cobolAcceptStack) {
                while (Return2 == null) {
                    Return2 = this.stack.getAnswerAction(dw, bgc);
                    if (Return2 != null || this.stack.size() != 0) continue;
                    this.wait();
                }
            }
        }
        catch (InterruptedException _ex) {
            throw new StopRunException();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CobolRecordAccept popAnswerMsgBox(DisplayMessageBox dmb) {
        CobolRecordAccept Return2 = null;
        try {
            CobolAcceptStack cobolAcceptStack = this;
            synchronized (cobolAcceptStack) {
                while (Return2 == null) {
                    Return2 = this.stack.getAnswerMsgBox(dmb);
                    if (Return2 != null || this.stack.size() != 0) continue;
                    this.wait();
                }
            }
        }
        catch (InterruptedException _ex) {
            throw new StopRunException();
        }
        return Return2;
    }

    public void debug() {
        System.out.println("DEBUG===========>Stack [" + this.stack.size() + "] numelem");
    }

    public int size() {
        return this.stack.size();
    }

    private class MyVector
    extends Vector {
        private MyVector() {
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        CobolRecordAccept getAnswerMsgBox(DisplayMessageBox dmb) {
            CobolRecordAccept Return2 = null;
            Vector<CobolRecordAccept> removed = null;
            boolean response = false;
            Return2 = dmb.getEvent();
            if (Return2 == null) {
                for (int numelem = 0; numelem < this.size(); ++numelem) {
                    Return2 = (CobolRecordAccept)this.elementAt(numelem);
                    if (Return2.getMsgBox() == dmb) {
                        this.remove(Return2);
                        --numelem;
                        break;
                    }
                    if (Return2.getControl() != null && !Return2.getControl().isValid()) {
                        this.remove(Return2);
                        --numelem;
                        if (Return2.getResponse()) {
                            Return2.responseClient();
                        }
                    } else {
                        if (removed == null) {
                            removed = new Vector<CobolRecordAccept>();
                        }
                        removed.add(Return2);
                        response = false;
                        if (Return2.getResponse()) {
                            response = true;
                            if (Return2.getControl() != null && Return2.getControl().hasClickOverrideFocusChange() && Return2.getRecordType() == 16 && Return2.getEventType() == 17) {
                                response = false;
                            }
                        }
                        if (response) {
                            Return2.responseClient();
                        }
                        if (Return2.getWindow() != null && !Return2.getWindow().isDestroyed()) {
                            Return2.getWindow().setEvent(Return2);
                        } else if (Return2.getMsgBox() != null) {
                            Return2.getMsgBox().setEvent(Return2);
                        }
                    }
                    Return2 = null;
                }
            }
            if (removed != null && removed.size() > 0) {
                Enumeration params = removed.elements();
                CobolRecordAccept rr = null;
                while (params.hasMoreElements()) {
                    rr = (CobolRecordAccept)params.nextElement();
                    this.remove(rr);
                }
                removed.removeAllElements();
            }
            return Return2;
        }

        CobolRecordAccept getAnswerAction(DisplayWindow dw, BaseGUIControl dc) {
            CobolRecordAccept Return2 = null;
            Vector<CobolRecordAccept> removed = new Vector<CobolRecordAccept>();
            Return2 = dw.getEventAnswerAction(dc);
            if (Return2 == null) {
                for (int numelem = 0; numelem < this.size(); ++numelem) {
                    Return2 = (CobolRecordAccept)this.elementAt(numelem);
                    if (Return2.getControl() == dc) {
                        this.remove(Return2);
                        --numelem;
                        if (Return2.isAnswerEvent(dc)) break;
                        if (Return2.getResponse()) {
                            Return2.responseClient();
                        }
                    } else if (Return2.getControl() != null && !Return2.getControl().isValid()) {
                        this.remove(Return2);
                        --numelem;
                        if (Return2.getResponse()) {
                            Return2.responseClient();
                        }
                    } else {
                        removed.add(Return2);
                        if (Return2.getResponse()) {
                            Return2.responseClient();
                        }
                        if (Return2.getWindow() != null && !Return2.getWindow().isDestroyed()) {
                            Return2.getWindow().setEvent(Return2);
                        }
                    }
                    Return2 = null;
                }
            }
            if (removed.size() > 0) {
                Enumeration params = removed.elements();
                CobolRecordAccept rr = null;
                while (params.hasMoreElements()) {
                    rr = (CobolRecordAccept)params.nextElement();
                    this.remove(rr);
                }
                removed.removeAllElements();
            }
            return Return2;
        }

        CobolRecordAccept getFirst(DisplayWindow dw) {
            CobolRecordAccept Return2 = dw.getEvent();
            if (Return2 == null) {
                int size = this.size();
                for (int i = 0; i < size; ++i) {
                    BaseGUIControl wa;
                    Return2 = (CobolRecordAccept)this.elementAt(i);
                    if (Return2.getWindowId() == dw.getTheObjectId()) {
                        wa = dw.getWaitAction();
                        if (wa != null && Return2.isAnswerEvent(wa)) continue;
                        this.remove(i);
                        return Return2;
                    }
                    if (Return2.getKeyStatus() == 95 || Return2.getRecordType() == 25) {
                        if (Return2.getEventData2() != Factory.getCurrentMonitor().getId()) continue;
                        this.remove(i);
                        return Return2;
                    }
                    if (Return2.getWindow() != null && (wa = Return2.getWindow().getWaitAction()) != null && Return2.isAnswerEvent(wa)) continue;
                    this.remove(i);
                    --i;
                    --size;
                    if (Return2.getWindow() == null) {
                        if (Return2.getMsgBox() == null) continue;
                        Return2.getMsgBox().setEvent(Return2);
                        continue;
                    }
                    if (Return2.getWindow().getCurrThread() == dw.getCurrThread() && !Return2.getWindow().isDestroyed()) {
                        return Return2;
                    }
                    Return2.getWindow().setEvent(Return2);
                }
                Return2 = null;
            }
            return Return2;
        }

        @Override
        public String toString() {
            return "" + this.hashCode();
        }
    }
}

