/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.JavaBeanInitException;
import com.iscobol.gui.ParamElementArrayFloat;
import com.iscobol.gui.ParamElementArrayInt;
import com.iscobol.gui.ParamElementBoolean;
import com.iscobol.gui.ParamElementFloat;
import com.iscobol.gui.ParamElementFont;
import com.iscobol.gui.ParamElementInquire;
import com.iscobol.gui.ParamElementInt;
import com.iscobol.gui.ParamElementIntArrayInt;
import com.iscobol.gui.ParamElementIntInt;
import com.iscobol.gui.ParamElementIntString;
import com.iscobol.gui.ParamElementMenu;
import com.iscobol.gui.ParamElementString;
import com.iscobol.gui.ParamElementVector;
import com.iscobol.gui.ParamElementVectorTD;
import com.iscobol.gui.ParamElementVectorToolB;
import com.iscobol.gui.ParamElementWindowCell;
import com.iscobol.gui.ParamVElement;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.RemoteContainer;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.CobolAcceptEvent;
import com.iscobol.gui.server.CobolGUIEnvironment;
import com.iscobol.gui.server.CobolGUIJavaBean;
import com.iscobol.gui.server.CobolGUIMenu;
import com.iscobol.gui.server.CobolRecordAccept;
import com.iscobol.gui.server.DisplayToolBar;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.EventsImpl;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.gui.server.NullWindow;
import com.iscobol.gui.server.ProcedureObject;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.gui.server.ServerMenuManager;
import com.iscobol.gui.server.ServerPalette;
import com.iscobol.gui.server.TerminalEmulation;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.FileImage;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IObjectVar;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolModule;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.ModifyException;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.ObjectVar;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;

public abstract class BaseGUIWindow
implements Constants,
Handle {
    public static final int CELL_IN_UNITS = 0;
    public static final int CELL_AS_LABEL = 1;
    public static final int CELL_AS_ENTRY_FIELD = 2;
    public static final int SEPARATE = 3;
    public static final int OVERLAPPED = -1;
    protected RemoteContainer controlPeer;
    private int controlPeerId;
    protected Events events;
    protected DisplayWindow parentWnd;
    INumericVar popupMenuCV;
    CobolGUIMenu popupMenu;
    INumericVar iconCV;
    ICobolVar backgroundbitmaphandleCV;
    private boolean graphical;
    boolean visible = true;
    boolean enabled = true;
    private float atLine = -99999.0f;
    private float atColumn = -99999.0f;
    protected float screenLine = -99999.0f;
    protected float screenColumn = -99999.0f;
    protected float addLines;
    protected float addColumns;
    protected float subLines;
    protected float subColumns;
    protected boolean changeScreenLC;
    float toolBarLines;
    protected boolean sizeChange = true;
    private float sizeLines = 25.0f;
    private float sizeColumns = 80.0f;
    String title;
    int titlePosition = 2;
    boolean boxed;
    boolean shadow;
    boolean scroll;
    boolean wrap;
    IObjectVar fontCV;
    private FontCmp font = FontCmp.getDefaultWindowFont();
    private int cellTypeWidth;
    private int cellTypeHeight;
    private boolean cellChangeWidth;
    private boolean cellChangeHeight;
    protected FontCmp cellFontWidth;
    protected FontCmp cellFontHeight;
    private int cellSepOver;
    private float cellWidth;
    private float cellHeight;
    float labelOffset;
    CobolGUIEnvironment env;
    private ProcedureObject eventProc;
    private ColorCmp color;
    protected ColorCmp colorinitial;
    private int colorint;
    int erase;
    private int controlValue;
    protected int theObject;
    private Thread currThread;
    protected float currAction = 22.0f;
    private boolean linkToThread;
    private boolean bindToThread;
    protected boolean resizable;
    protected ParamVector paramCSWindow;
    protected ParamVector queueParamCSWindow;
    protected int queuePCSWbytes;
    protected int terminalDisplayGateID;
    protected boolean isdefaultsubwindow;
    protected int cursorValue;
    private boolean isincriticalregion;
    protected ParamVector alldata;
    protected Dimension clientCharDim;
    protected ArrayList currChildsActiveAccept;
    protected int type = -1;
    protected String typeStr = "";
    private float bufferedwincmd = -1.0f;
    private boolean inquirebuffered;
    private boolean activeAccept;
    protected GuiFactory gf;
    protected boolean debug;
    protected Vector delserveridvect = new Vector();
    protected boolean destroyed;
    protected int screenindex = 0;
    private String customData;
    protected ParamVElement elemscreenindex = null;
    protected int foregroundIntensity = 0;
    private int iconid = -1;
    private boolean massUpdate;
    public static final int STYLE_BOXED = 1;
    public static final int STYLE_SHADOW = 2;
    public static final int STYLE_NO_SCROLL = 4;
    public static final int STYLE_NO_WRAP = 8;
    public static final int STYLE_REVERSE = 16;
    public static final int STYLE_TITLE_BAR = 32;
    public static final int STYLE_SYSTEM_MENU = 64;
    public static final int STYLE_USER_GRAY = 128;
    public static final int STYLE_USER_WHITE = 256;
    private Vector childvect = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.controlPeer = null;
        this.events = null;
        this.parentWnd = null;
        this.popupMenuCV = null;
        this.popupMenu = null;
        this.fontCV = null;
        this.font = null;
        this.cellFontWidth = null;
        this.cellFontHeight = null;
        this.env = null;
        this.eventProc = null;
        this.color = null;
        this.currThread = null;
        this.paramCSWindow = null;
        UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
        if (uh != null) {
            UserHandles.free(this);
        }
        this.currChildsActiveAccept = null;
        this.activeAccept = false;
        this.gf = null;
        this.delserveridvect.removeAllElements();
        if (this.queueParamCSWindow != null) {
            ParamVector paramVector = this.queueParamCSWindow;
            synchronized (paramVector) {
                this.queueParamCSWindow.removeAllElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVectors() {
        ParamVector paramVector;
        if (this.paramCSWindow != null) {
            paramVector = this.paramCSWindow;
            synchronized (paramVector) {
                this.paramCSWindow.removeAllElements();
            }
        }
        if (this.queueParamCSWindow != null) {
            paramVector = this.queueParamCSWindow;
            synchronized (paramVector) {
                this.queueParamCSWindow.removeAllElements();
            }
        }
        this.paramCSWindow = null;
    }

    public BaseGUIWindow() {
        if (this instanceof ServerMenuManager || !(this instanceof NullWindow)) {
            try {
                this.events = new EventsImpl(this);
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
        this.color = new ColorCmp(false);
        this.currThread = Thread.currentThread();
        this.queueParamCSWindow = new ParamVector(IscobolSystem.isAS());
    }

    abstract void componentsetSize(float var1, float var2);

    public void setParentWnd(DisplayWindow dw) {
        this.parentWnd = dw;
    }

    public DisplayWindow getParentWnd() {
        return this.parentWnd;
    }

    public BaseGUIWindow setLinesInCell(boolean b) {
        return this;
    }

    public BaseGUIWindow setSizesInCell(boolean b) {
        return this;
    }

    public RemoteContainer getComponent() {
        return this.controlPeer;
    }

    public float getLines() {
        return this.sizeLines;
    }

    public float getSizes() {
        return this.sizeColumns;
    }

    protected float getColumns() {
        return this.getSizes();
    }

    public BaseGUIWindow getLines(CobolVar nc) {
        return this.getLines((ICobolVar)nc);
    }

    public BaseGUIWindow getLines(ICobolVar nc) {
        nc.set(this.sizeLines);
        return this;
    }

    public BaseGUIWindow getColumns(CobolVar nc) {
        return this.getColumns((ICobolVar)nc);
    }

    public BaseGUIWindow getColumns(ICobolVar nc) {
        nc.set(this.sizeColumns);
        return this;
    }

    public BaseGUIWindow setLines(float nl) {
        if (nl > 0.0f && nl != this.sizeLines) {
            this.sizeChange = true;
            this.sizeLines = nl;
        }
        return this;
    }

    public BaseGUIWindow setLines(CobolVar cv) {
        return this.setLines((ICobolVar)cv);
    }

    public BaseGUIWindow setLines(ICobolVar cv) {
        this.setLines(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setSizes(CobolVar cv) {
        return this.setSizes((ICobolVar)cv);
    }

    public BaseGUIWindow setSizes(ICobolVar cv) {
        this.setSizes(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setSizes(float w) {
        if (w > 0.0f && w != this.sizeColumns) {
            this.sizeChange = true;
            this.sizeColumns = w;
        }
        return this;
    }

    public BaseGUIWindow setSize(float height, float width) {
        this.setLines(height);
        this.setSizes(width);
        return this;
    }

    public void setSizeNTFChanged(float height, float width) {
        this.setSize(height, width);
        this.sizeChange = true;
    }

    public BaseGUIWindow setColumns(float w) {
        return this.setSizes(w);
    }

    public void displaysetSize() {
        if (this.sizeChange || this.toolBarLines > 0.0f) {
            this.componentsetSize(this.sizeLines, this.sizeColumns);
        }
        this.sizeChange = false;
    }

    public int getTheObjectId() {
        return this.controlPeerId;
    }

    public void setTheObjectId(int cpi) {
        this.controlPeerId = cpi;
    }

    public boolean getForeHighlight() {
        if (this.foregroundIntensity == 2 && this.getForeground() == 0) {
            return false;
        }
        if (this.color.isForeIntensitySet() || this.parentWnd == null || this.parentWnd.isDestroyed()) {
            return this.color.getForeHighIntensity();
        }
        return this.parentWnd.getForeHighlight();
    }

    public boolean getBackHighlight() {
        if (this.color.isBackIntensitySet() || this.parentWnd == null || this.parentWnd.isDestroyed()) {
            return this.color.getBackHighIntensity();
        }
        return this.parentWnd.getBackHighlight();
    }

    private int myGetForeground() {
        if (this.color.isForegroundSet() || this.parentWnd == null || this.parentWnd.isDestroyed()) {
            return this.color.getForeground();
        }
        return this.parentWnd.getForeground();
    }

    private int myGetBackground() {
        if (this.color.isBackgroundSet() || this.parentWnd == null || this.parentWnd.isDestroyed()) {
            return this.color.getBackground();
        }
        return this.parentWnd.getBackground();
    }

    public int getForeground() {
        if (this.color.getReverse()) {
            return this.myGetBackground();
        }
        return this.myGetForeground();
    }

    public int getBackground() {
        if (this.color.getReverse()) {
            return this.myGetForeground();
        }
        return this.myGetBackground();
    }

    public BaseGUIWindow setBoxed(boolean b) {
        this.boxed = b;
        try {
            this.controlPeersetStyle("BOXED");
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public boolean getBoxed() {
        return this.boxed;
    }

    public BaseGUIWindow setReverse(boolean r) {
        this.color.setReverse(r);
        return this;
    }

    public BaseGUIWindow setShadow(boolean s) {
        this.shadow = s;
        try {
            this.controlPeersetStyle("SHADOW");
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public boolean getShadow() {
        return this.shadow;
    }

    public String getTitle() {
        return this.title;
    }

    public BaseGUIWindow setTitlePosition(int tp) {
        this.titlePosition = tp;
        try {
            this.controlPeersetTitlePosition(tp);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public BaseGUIWindow setScroll(boolean s) {
        this.scroll = s;
        return this;
    }

    public boolean getScroll() {
        return this.scroll;
    }

    public BaseGUIWindow setWrap(boolean w) {
        this.wrap = w;
        return this;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    abstract void componentsetAcceptDisplayFont(FontCmp var1);

    public BaseGUIWindow setAcceptDisplayFont(FontCmp f) {
        this.componentsetAcceptDisplayFont(f);
        return this;
    }

    abstract void componentsetControlFont(FontCmp var1);

    protected BaseGUIWindow setControlFont(FontCmp f) {
        this.componentsetControlFont(f);
        return this;
    }

    public BaseGUIWindow setControlFont(CobolVar ov) {
        return this.setControlFont((ICobolVar)ov);
    }

    public BaseGUIWindow setControlFont(ICobolVar ov) {
        if (ov != null && ov instanceof IObjectVar) {
            this.setControlFont((IObjectVar)ov);
        }
        return this;
    }

    public BaseGUIWindow setControlFont(ObjectVar ov) {
        return this.setControlFont((IObjectVar)ov);
    }

    public BaseGUIWindow setControlFont(IObjectVar ov) {
        FontCmp fc;
        if (ov.getOId() != null && ov.getOId() instanceof FontCmp && (fc = (FontCmp)ov.getOId()) != null) {
            this.setControlFont(fc);
        }
        return this;
    }

    abstract FontCmp componentgetControlFont();

    public FontCmp getControlFont() {
        return this.componentgetControlFont();
    }

    abstract void componentsetFont();

    protected BaseGUIWindow setFont(FontCmp f) {
        this.font = f;
        this.componentsetFont();
        return this;
    }

    public BaseGUIWindow setFont(CobolVar cv) {
        return this.setFont((ICobolVar)cv);
    }

    public BaseGUIWindow setFont(ICobolVar cv) {
        FontCmp fc;
        if (cv != null && cv instanceof IObjectVar && ((IObjectVar)cv).getOId() != null && ((IObjectVar)cv).getOId() instanceof FontCmp && (fc = (FontCmp)((IObjectVar)cv).getOId()) != null) {
            this.setFont(fc);
        }
        return this;
    }

    public BaseGUIWindow setFont(String stridxfont) {
        int idxfont = 5;
        if (stridxfont.equalsIgnoreCase("SMALL-FONT")) {
            idxfont = 3;
        } else if (stridxfont.equalsIgnoreCase("TRADITIONAL-FONT")) {
            idxfont = 0;
        } else if (stridxfont.equalsIgnoreCase("DEFAULT-FONT")) {
            idxfont = 5;
        } else if (stridxfont.equalsIgnoreCase("MEDIUM-FONT")) {
            idxfont = 4;
        } else if (stridxfont.equalsIgnoreCase("LARGE-FONT")) {
            idxfont = 2;
        } else if (stridxfont.equalsIgnoreCase("FIXED-FONT")) {
            idxfont = 1;
        }
        this.setFont(idxfont);
        return this;
    }

    public BaseGUIWindow setFont(int idxfont) {
        FontCmp tmpf = FontCmp.getFont(idxfont);
        this.setFont(tmpf);
        return this;
    }

    public void displaysetFont() {
        if (this.fontCV != null) {
            this.getFont();
            this.componentsetFont();
        }
    }

    public FontCmp getFont() {
        if (this.fontCV != null) {
            if (this.fontCV.getOId() instanceof FontCmp) {
                this.font = (FontCmp)this.fontCV.getOId();
            } else if (this.fontCV.getOId() instanceof Font) {
                throw new IscobolRuntimeException(3, "UserHandles.getId() returns Font");
            }
        }
        if (this.isOptNew() && this.paramCSWindow != null && this.font != null && !this.font.isInitialized()) {
            return this.font;
        }
        if (this.font != null && this.font.getFontId(false) == 0) {
            this.font = null;
        }
        this.setDefaultFont();
        return this.font;
    }

    private void setDefaultFont() {
        if (this.font == null && this.parentWnd != null && !this.parentWnd.isDestroyed()) {
            this.font = this.parentWnd.getFont();
        } else if (this.font == null && this.env.getCurrentWindow() != null && this.env.getCurrentWindow() != this) {
            this.font = this.env.getCurrentWindow().getFont();
        }
        if (this.isOptNew() && this.paramCSWindow != null && this.font != null && !this.font.isInitialized()) {
            this.paramCSWindow.add(new ParamElementFont(2071, 0, this.font.getName(), this.font.getStyle(), this.font.getSize(), this.font.getCellWidth(), this.font.getCellHeight(), false));
        } else if (this.font != null && this.font.getFontId(false) == 0) {
            this.font = null;
        }
        if (this.font == null) {
            this.font = this.env.getDefaultFont();
        }
    }

    public BaseGUIWindow setCellSize(float ch) {
        this.setCellWidth(ch);
        this.setCellHeight(ch);
        return this;
    }

    public FontCmp getControlFont(FontCmp f) {
        FontCmp Return2 = f;
        if (Return2 == null) {
            Return2 = this.getControlFont();
        }
        if (Return2 == null) {
            Return2 = FontCmp.getFont("DEFAULT-FONT");
        }
        return Return2;
    }

    public void displaysetCell() {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.add(this.paramdisplaysetCellWidth());
            this.paramCSWindow.add(this.paramdisplaysetCellHeight());
        } else {
            this.origdisplaysetCell();
        }
    }

    private void origdisplaysetCell() {
        try {
            if (this.cellChangeHeight || this.cellChangeWidth) {
                FontCmp f;
                switch (this.cellTypeWidth) {
                    case 1: {
                        if (!this.cellChangeWidth) break;
                        f = this.getControlFont(this.cellFontWidth);
                        this.controlPeer.setCellWidth(f.getFontId(false));
                        this.sizeChange = true;
                        break;
                    }
                    case 2: {
                        if (!this.cellChangeWidth) break;
                        f = this.getControlFont(this.cellFontWidth);
                        this.controlPeer.setCellWidth(f.getFontId(false));
                        this.sizeChange = true;
                        break;
                    }
                    default: {
                        if (!this.cellChangeWidth) break;
                        this.controlPeer.setCellWidth(this.cellWidth);
                        this.sizeChange = true;
                    }
                }
                switch (this.cellTypeHeight) {
                    case 1: {
                        if (!this.cellChangeHeight) break;
                        f = this.getControlFont(this.cellFontHeight);
                        this.controlPeer.setCellHeight(f.getFontId(false));
                        float fl = this.controlPeer.getCellHeight();
                        this.controlPeer.setCellHeight(fl += (float)this.cellSepOver);
                        this.sizeChange = true;
                        break;
                    }
                    case 2: {
                        if (!this.cellChangeHeight) break;
                        f = this.getControlFont(this.cellFontHeight);
                        this.controlPeer.setCellHeight(f.getFontId(false));
                        float fl = this.controlPeer.getCellHeight();
                        fl = (float)((double)fl + (double)fl * 0.6);
                        this.controlPeer.setCellHeight(fl += (float)this.cellSepOver);
                        this.sizeChange = true;
                        break;
                    }
                    default: {
                        if (!this.cellChangeHeight) break;
                        this.controlPeer.setCellHeight(this.cellHeight);
                        this.sizeChange = true;
                    }
                }
                this.cellChangeWidth = false;
                this.cellChangeHeight = false;
            }
            this.cellWidth = this.controlPeer.getCellWidth();
            this.cellHeight = this.controlPeer.getCellHeight();
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
    }

    public ParamElementWindowCell paramdisplaysetCellWidth() {
        ParamElementWindowCell pwc = new ParamElementWindowCell(2031);
        if (this.cellChangeWidth) {
            switch (this.cellTypeWidth) {
                case 1: {
                    pwc.typeop = 1;
                    this.sizeChange = true;
                    break;
                }
                case 2: {
                    pwc.typeop = (byte)2;
                    this.sizeChange = true;
                    break;
                }
                default: {
                    pwc.typeop = (byte)3;
                    this.sizeChange = true;
                }
            }
            pwc.cellwh = this.cellWidth;
            FontCmp f = this.getControlFont(this.cellFontWidth);
            if (this.isOptNew() && f != null && !f.isInitialized()) {
                pwc.pef = new ParamElementFont(2071, 0, f.getName(), f.getStyle(), f.getSize(), f.getCellWidth(), f.getCellHeight(), false);
                pwc.fontid = -1;
            } else {
                pwc.fontid = f.getFontId(false);
            }
            pwc.cellsepover = this.cellSepOver;
        }
        this.cellChangeWidth = false;
        return pwc;
    }

    public ParamElementWindowCell paramdisplaysetCellHeight() {
        ParamElementWindowCell pwc = new ParamElementWindowCell(2032);
        if (this.cellChangeHeight) {
            switch (this.cellTypeHeight) {
                case 1: {
                    pwc.typeop = (byte)4;
                    this.sizeChange = true;
                    break;
                }
                case 2: {
                    pwc.typeop = (byte)5;
                    this.sizeChange = true;
                    break;
                }
                default: {
                    pwc.typeop = (byte)6;
                    this.sizeChange = true;
                }
            }
            pwc.cellwh = this.cellHeight;
            FontCmp f = this.getControlFont(this.cellFontHeight);
            if (this.isOptNew() && f != null && !f.isInitialized()) {
                pwc.pef = new ParamElementFont(2071, 0, f.getName(), f.getStyle(), f.getSize(), f.getCellWidth(), f.getCellHeight(), false);
                pwc.fontid = -1;
            } else {
                pwc.fontid = f.getFontId(false);
            }
            pwc.cellsepover = this.cellSepOver;
        }
        this.cellChangeHeight = false;
        return pwc;
    }

    private void setControlCellH(String controlType, int sep_over) {
        this.cellTypeHeight = "ENTRY_FIELD".equals(controlType) ? 2 : 1;
        this.cellSepOver = sep_over;
        if (this.cellTypeWidth == 0) {
            this.setControlCellW(controlType, sep_over);
        }
    }

    private void setControlCellW(String controlType, int sep_over) {
        this.cellTypeWidth = "ENTRY_FIELD".equals(controlType) ? 2 : 1;
        if (this.cellTypeHeight == 0) {
            this.setControlCellH(controlType, sep_over);
        }
    }

    public BaseGUIWindow setCellSize(String controlType, NumericVar f, int sep_over) {
        return this.setCellSize(controlType, (INumericVar)f, sep_over);
    }

    public BaseGUIWindow setCellSize(String controlType, INumericVar f, int sep_over) {
        this.setCellWidth(controlType, f, sep_over);
        this.setCellHeight(controlType, f, sep_over);
        return this;
    }

    public BaseGUIWindow setCellSize(String controlType, NumericVar f) {
        return this.setCellSize(controlType, (INumericVar)f);
    }

    public BaseGUIWindow setCellSize(String controlType, INumericVar f) {
        this.setCellSize(controlType, f, 0);
        return this;
    }

    public BaseGUIWindow setCellSize(String controlType, NumericVar f, String option) {
        return this.setCellSize(controlType, (INumericVar)f, option);
    }

    public BaseGUIWindow setCellSize(String controlType, INumericVar f, String option) {
        int sep_over = 0;
        if (option.equalsIgnoreCase("SEPARATE")) {
            sep_over = 3;
        } else if (option.equalsIgnoreCase("OVERLAPPED")) {
            sep_over = -1;
        }
        this.setCellSize(controlType, f, sep_over);
        return this;
    }

    public BaseGUIWindow setCellSize(CobolVar cv) {
        return this.setCellSize((ICobolVar)cv);
    }

    public BaseGUIWindow setCellSize(ICobolVar cv) {
        this.setCellSize(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setCellHeight(float ch) {
        if ((double)ch >= 1.0) {
            if (ch != this.cellHeight || this.cellTypeHeight != 0) {
                this.cellHeight = ch;
                this.cellChangeHeight = true;
            }
            this.cellTypeHeight = 0;
        }
        return this;
    }

    public BaseGUIWindow setCellHeight(String controlType, NumericVar f) {
        return this.setCellHeight(controlType, (INumericVar)f);
    }

    public BaseGUIWindow setCellHeight(String controlType, INumericVar f) {
        this.setCellHeight(controlType, f, 0);
        return this;
    }

    public BaseGUIWindow setCellHeight(String controlType, NumericVar f, int sep_over) {
        return this.setCellHeight(controlType, (INumericVar)f, sep_over);
    }

    public BaseGUIWindow setCellHeight(String controlType, INumericVar f, int sep_over) {
        FontCmp fc;
        this.cellChangeHeight = true;
        this.cellFontHeight = null;
        if (f != null && f instanceof IObjectVar && f.getOId() != null && f.getOId() instanceof FontCmp && (fc = (FontCmp)f.getOId()) != null) {
            this.cellFontHeight = fc;
        }
        this.setControlCellH(controlType, sep_over);
        return this;
    }

    public BaseGUIWindow setCellHeight(String controlType, NumericVar f, String option) {
        return this.setCellHeight(controlType, (INumericVar)f, option);
    }

    public BaseGUIWindow setCellHeight(String controlType, INumericVar f, String option) {
        int sep_over = 0;
        if (option.equalsIgnoreCase("SEPARATE")) {
            sep_over = 3;
        } else if (option.equalsIgnoreCase("OVERLAPPED")) {
            sep_over = -1;
        }
        this.setCellHeight(controlType, f, sep_over);
        return this;
    }

    public BaseGUIWindow setCellHeight(CobolVar cv) {
        return this.setCellHeight((ICobolVar)cv);
    }

    public BaseGUIWindow setCellHeight(ICobolVar cv) {
        this.setCellHeight(cv.tofloat());
        return this;
    }

    public float getCellHeight() {
        if (this.isBufferedWindowType() && this.cellHeight == 0.0f && this.events != null && this.env != null) {
            this.env.dequeueWindow(this);
        }
        return this.cellHeight;
    }

    public BaseGUIWindow setCellWidth(float cw) {
        if ((double)cw >= 1.0) {
            if (cw != this.cellWidth || this.cellTypeWidth != 0) {
                this.cellWidth = cw;
                this.cellChangeWidth = true;
            }
            this.cellTypeWidth = 0;
        }
        return this;
    }

    public BaseGUIWindow setCellWidth(String controlType, NumericVar f) {
        return this.setCellWidth(controlType, (INumericVar)f);
    }

    public BaseGUIWindow setCellWidth(String controlType, INumericVar f) {
        this.setCellWidth(controlType, f, 0);
        return this;
    }

    public BaseGUIWindow setCellWidth(String controlType, NumericVar f, int sep_over) {
        return this.setCellWidth(controlType, (INumericVar)f, sep_over);
    }

    public BaseGUIWindow setCellWidth(String controlType, INumericVar f, int sep_over) {
        FontCmp fc;
        this.cellChangeWidth = true;
        this.cellFontWidth = null;
        if (f != null && f instanceof IObjectVar && f.getOId() != null && f.getOId() instanceof FontCmp && (fc = (FontCmp)f.getOId()) != null) {
            this.cellFontWidth = fc;
        }
        this.setControlCellW(controlType, sep_over);
        return this;
    }

    public BaseGUIWindow setCellWidth(String controlType, NumericVar f, String option) {
        return this.setCellWidth(controlType, (INumericVar)f, option);
    }

    public BaseGUIWindow setCellWidth(String controlType, INumericVar f, String option) {
        int sep_over = 0;
        if (option.equalsIgnoreCase("SEPARATE")) {
            sep_over = 3;
        } else if (option.equalsIgnoreCase("OVERLAPPED")) {
            sep_over = -1;
        }
        this.setCellWidth(controlType, f, sep_over);
        return this;
    }

    public BaseGUIWindow setCellWidth(CobolVar cv) {
        return this.setCellWidth((ICobolVar)cv);
    }

    public BaseGUIWindow setCellWidth(ICobolVar cv) {
        this.setCellWidth(cv.tofloat());
        return this;
    }

    public float getCellWidth() {
        if (this.isBufferedWindowType() && this.cellWidth == 0.0f && this.events != null && this.env != null) {
            this.env.dequeueWindow(this);
        }
        return this.cellWidth;
    }

    public BaseGUIWindow setLocation(float al, float ac) {
        this.setAtLine(al);
        this.setAtColumn(ac);
        return this;
    }

    public BaseGUIWindow setLocationAt(float rowCol) {
        this.setAtLine((int)(rowCol / 100.0f));
        this.setAtColumn((int)(rowCol % 100.0f));
        return this;
    }

    public BaseGUIWindow setLocationAt(CobolVar rowCol) {
        return this.setLocationAt((ICobolVar)rowCol);
    }

    public BaseGUIWindow setLocationAt(ICobolVar rowCol) {
        int div = 0;
        float frowcol = 0.0f;
        boolean error = false;
        try {
            frowcol = (int)Float.parseFloat(rowCol.toString());
        }
        catch (NumberFormatException e) {
            error = true;
        }
        if (!error) {
            if (rowCol.getLength() <= 4) {
                div = 100;
            } else if (rowCol.getLength() <= 6) {
                div = 1000;
            }
            if (div > 0) {
                this.setAtLine((int)(frowcol / (float)div));
                this.setAtColumn((int)(frowcol % (float)div));
            }
        }
        return this;
    }

    public BaseGUIWindow setLocationAt(String rowcol, boolean inpixel, boolean incell) {
        int div = 0;
        float frowcol = 0.0f;
        boolean error = false;
        try {
            frowcol = (int)Float.parseFloat(rowcol);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        if (!error) {
            if (rowcol.length() <= 4) {
                div = 100;
            } else if (rowcol.length() <= 6) {
                div = 1000;
            }
            if (div > 0) {
                this.setAtLine((int)(frowcol / (float)div));
                this.setAtColumn((int)(frowcol % (float)div));
            }
        }
        return this;
    }

    abstract void componentsetAtLine(float var1);

    public BaseGUIWindow getAtLine(CobolVar al) {
        return this.getAtLine((ICobolVar)al);
    }

    public BaseGUIWindow getAtLine(ICobolVar al) {
        try {
            if (this.parentWnd != null && this.parentWnd.getComponent() != null && this.getComponent() != null) {
                Rectangle pp = new Rectangle(0, 0, 0, 0);
                Insets i = new Insets(0, 0, 0, 0);
                Rectangle p = this.getComponent().getMainBounds();
                if (this.parentWnd.getScreenIndex() == this.screenindex) {
                    pp = this.parentWnd.getComponent().getMainBounds();
                    i = this.parentWnd.getComponent().getInsets();
                    p.y = p.y - (pp.y + (i != null ? i.top : 0) + this.parentWnd.getToolBarsHeight(true));
                }
                float poscy = (float)p.y / this.cellHeight;
                al.set(poscy += 1.0f);
            } else {
                al.set(this.atLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public BaseGUIWindow getAtColumn(CobolVar al) {
        return this.getAtColumn((ICobolVar)al);
    }

    public BaseGUIWindow getAtColumn(ICobolVar al) {
        try {
            if (this.parentWnd != null && this.parentWnd.getComponent() != null && this.getComponent() != null) {
                Rectangle pp = new Rectangle(0, 0, 0, 0);
                Insets i = new Insets(0, 0, 0, 0);
                Rectangle p = this.getComponent().getMainBounds();
                if (this.parentWnd.getScreenIndex() == this.screenindex) {
                    pp = this.parentWnd.getComponent().getMainBounds();
                    i = this.parentWnd.getComponent().getInsets();
                    p.x = p.x - (pp.x + (i != null ? i.left : 0));
                }
                float poscx = (float)p.x / this.cellWidth;
                al.set(poscx += 1.0f);
            } else {
                al.set(this.atColumn);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public BaseGUIWindow setAtLine(float al) {
        this.atLine = al;
        this.componentsetAtLine(al);
        return this;
    }

    abstract void componentsetAtColumn(float var1);

    public BaseGUIWindow setAtColumn(float ac) {
        this.atColumn = ac;
        this.componentsetAtColumn(ac);
        return this;
    }

    public BaseGUIWindow setAtLine(CobolVar cv) {
        return this.setAtLine((ICobolVar)cv);
    }

    public BaseGUIWindow setAtLine(ICobolVar cv) {
        this.setAtLine(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setAtColumn(CobolVar cv) {
        return this.setAtColumn((ICobolVar)cv);
    }

    public BaseGUIWindow setAtColumn(ICobolVar cv) {
        this.setAtColumn(cv.tofloat());
        return this;
    }

    public float getAtLine() {
        return this.atLine;
    }

    public float getAtColumn() {
        return this.atColumn;
    }

    abstract float getSubAtLine();

    abstract float getSubAtColumn();

    abstract void componentsetAtLocation();

    public void displaysetLocation() {
        this.componentsetAtLocation();
    }

    abstract void componentsetBackground(int var1);

    void setBackground(int bg) {
        this.color.setBackground(bg);
    }

    public BaseGUIWindow setColorBackground(int bg) {
        if (ColorCmp.isRGB(bg)) {
            this.setColorBackRGB(bg);
        } else {
            this.setBackground(bg);
        }
        return this;
    }

    public BaseGUIWindow setColorBackRGB(int bg) {
        this.color.setBackRGB(bg);
        return this;
    }

    public BaseGUIWindow setColorBackRGB(CobolVar cv) {
        return this.setColorBackRGB((ICobolVar)cv);
    }

    public BaseGUIWindow setColorBackRGB(ICobolVar cv) {
        this.setColorBackRGB(cv.toint());
        return this;
    }

    abstract void componentsetForeground(int var1);

    void setForeground(int fg) {
        this.color.setForeground(fg);
    }

    public BaseGUIWindow setColorForeground(int fg) {
        if (ColorCmp.isRGB(fg)) {
            this.setColorForeRGB(fg);
        } else {
            this.setForeground(fg);
        }
        return this;
    }

    public BaseGUIWindow setColorForeRGB(int bg) {
        this.color.setForeRGB(bg);
        return this;
    }

    public BaseGUIWindow setColorForeRGB(CobolVar cv) {
        return this.setColorForeRGB((ICobolVar)cv);
    }

    public BaseGUIWindow setColorForeRGB(ICobolVar cv) {
        this.setColorForeRGB(cv.toint());
        return this;
    }

    abstract void componentsetTitle(String var1);

    public BaseGUIWindow setTitle(String t) {
        this.title = t;
        this.componentsetTitle(t);
        return this;
    }

    public BaseGUIWindow getTitle(CobolVar t) {
        return this.getTitle((ICobolVar)t);
    }

    public BaseGUIWindow getTitle(ICobolVar t) {
        if (this.title != null) {
            t.set(this.title);
        }
        return this;
    }

    public BaseGUIWindow setTitle(CobolVar t) {
        return this.setTitle((ICobolVar)t);
    }

    public BaseGUIWindow setTitle(ICobolVar t) {
        this.setTitle(t.toString());
        return this;
    }

    public BaseGUIWindow setDockInfo(CobolVar d) {
        return this.setDockInfo((ICobolVar)d);
    }

    public BaseGUIWindow setDockInfo(ICobolVar d) {
        try {
            this.controlPeersetDockInfo(d.toString().trim());
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow getDockInfo(ICobolVar d) {
        try {
            String info;
            if (this.controlPeer != null && (info = this.controlPeer.getDockInfo()) != null) {
                d.set(info);
            } else {
                d.set("");
            }
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setResizable(boolean r) {
        this.resizable = r;
        if (this.title == null) {
            this.setTitle("");
        }
        try {
            this.controlPeersetResizable(r);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setLabelOffset(float r) {
        this.labelOffset = r;
        try {
            this.controlPeersetLabelOffset((int)this.labelOffset);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setLabelOffset(CobolVar r) {
        return this.setLabelOffset((ICobolVar)r);
    }

    public BaseGUIWindow setLabelOffset(ICobolVar r) {
        this.setLabelOffset(r.tofloat());
        return this;
    }

    public BaseGUIWindow setAt(float cv) {
        return this;
    }

    public BaseGUIWindow setLinkToThread() {
        this.linkToThread = true;
        return this;
    }

    public BaseGUIWindow setBindToThread() {
        this.linkToThread = true;
        this.bindToThread = true;
        return this;
    }

    boolean isLinkToThread() {
        return this.linkToThread;
    }

    boolean isBindToThread() {
        return this.bindToThread;
    }

    public BaseGUIWindow setColor(float c) {
        this.colorint = (int)c;
        this.color.setColor(this.colorint);
        this.colorinitial = this.color;
        return this;
    }

    public void setColor(ColorCmp c) {
        if (c.isBackgroundSet()) {
            this.color.setBackground(c.getBackground());
        }
        if (c.isForegroundSet()) {
            this.color.setForeground(c.getForeground());
        }
        this.colorinitial = this.color;
        this.displaysetColor();
    }

    public ColorCmp getColor() {
        return this.color;
    }

    public int getColorInt() {
        return this.colorint;
    }

    public ColorCmp getColorInitial() {
        if (this.colorinitial != null) {
            return this.colorinitial;
        }
        return this.getColor();
    }

    public BaseGUIWindow setEraseEol() {
        this.erase = 2;
        return this;
    }

    public BaseGUIWindow setEraseEos() {
        this.erase = 1;
        return this;
    }

    public BaseGUIWindow setEraseScreen() {
        this.erase = 3;
        return this;
    }

    public BaseGUIWindow setErase(int flag) {
        this.erase = flag;
        return this;
    }

    public int getErase() {
        return this.erase;
    }

    public BaseGUIWindow setControlValue(String s) {
        int v = -1;
        boolean error = false;
        try {
            v = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        if (!error) {
            this.controlValue = v;
            if ((this.controlValue & 1) == 1) {
                this.setBoxed(true);
            }
            if ((this.controlValue & 2) == 2) {
                this.setShadow(true);
            }
            if ((this.controlValue & 4) == 4) {
                this.setWithNoScroll(true);
            }
            if ((this.controlValue & 8) == 8) {
                this.setWithNoWrap(true);
            }
            if ((this.controlValue & 0x10) == 16) {
                this.setReverse(true);
            }
            if ((this.controlValue & 0x20) == 32) {
                this.setTitleBar(true);
            }
            if ((this.controlValue & 0x40) == 64) {
                this.setWithSystemMenu(true);
            }
            if ((this.controlValue & 0x80) == 128) {
                this.setUserGray(true);
            }
            if ((this.controlValue & 0x100) == 256) {
                this.setUserWhite(true);
            }
        }
        return this;
    }

    public BaseGUIWindow modifyMenu(CobolGUIMenu m) {
        return this;
    }

    public BaseGUIWindow modifyMenu(CobolVar cv) {
        return this.modifyMenu((ICobolVar)cv);
    }

    public BaseGUIWindow modifyMenu(ICobolVar cv) {
        return this;
    }

    public void displaysetPopupMenu() {
        this.modifyMenu(this.popupMenuCV);
        if (this.isBufferedWindowType()) {
            this.getParamCSWindow();
        }
    }

    public BaseGUIWindow setPopupMenu(CobolGUIMenu menu) {
        this.popupMenu = menu;
        return this;
    }

    public BaseGUIWindow setPopupMenu(CobolVar cv) {
        return this.setPopupMenu((ICobolVar)cv);
    }

    public BaseGUIWindow setPopupMenu(ICobolVar cv) {
        if (cv instanceof INumericVar) {
            this.popupMenuCV = (INumericVar)cv;
        }
        return this;
    }

    public BaseGUIWindow getPopupMenu(CobolVar dest) {
        return this.getPopupMenu((ICobolVar)dest);
    }

    public BaseGUIWindow getPopupMenu(ICobolVar dest) {
        if (this.popupMenuCV != null) {
            this.popupMenuCV.moveTo(dest);
        } else {
            dest.set(0);
        }
        return this;
    }

    public void displaysetToolTipText() {
    }

    public BaseGUIWindow setToolTipText(CobolVar cv) {
        return this.setToolTipText((ICobolVar)cv);
    }

    public BaseGUIWindow setToolTipText(ICobolVar cv) {
        return this;
    }

    public BaseGUIWindow setToolTipText(String ttt) {
        return this;
    }

    public BaseGUIWindow modifyToolTipText(CobolVar cv) {
        return this.modifyToolTipText((ICobolVar)cv);
    }

    public BaseGUIWindow modifyToolTipText(ICobolVar cv) {
        return this;
    }

    public BaseGUIWindow modifyToolTipText(String ttt) {
        return this;
    }

    public BaseGUIWindow getToolTipText(CobolVar dest) {
        return this.getToolTipText((ICobolVar)dest);
    }

    public BaseGUIWindow getToolTipText(ICobolVar dest) {
        if (dest != null) {
            dest.set("");
        }
        return this;
    }

    public BaseGUIWindow setPopupArea() {
        return this;
    }

    abstract void componentsetTitleBar(boolean var1);

    public BaseGUIWindow setTitleBar(boolean b) {
        this.componentsetTitleBar(b);
        return this;
    }

    public BaseGUIWindow setEraseBlankScreen(boolean b) {
        return this;
    }

    public BaseGUIWindow setHighlight(boolean b) {
        this.color.setForeHighIntensity(b);
        return this;
    }

    public BaseGUIWindow setLowlight(boolean b) {
        this.color.setForeHighIntensity(!b);
        return this;
    }

    public BaseGUIWindow setStandard(boolean b) {
        this.color.setStandard(b);
        return this;
    }

    public BaseGUIWindow setBackHigh(boolean b) {
        this.color.setBackHighIntensity(b);
        return this;
    }

    public BaseGUIWindow setBackLow(boolean b) {
        this.color.setBackHighIntensity(!b);
        return this;
    }

    public BaseGUIWindow setBackStandard(boolean b) {
        return this;
    }

    protected void copyColor(ColorCmp c) {
        this.color.copyColor(c);
    }

    public BaseGUIWindow setUserGray(boolean b) {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2054, b));
        } else {
            ServerPalette.setUserGray(b);
        }
        return this;
    }

    public BaseGUIWindow setUserWhite(boolean b) {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2055, b));
        } else {
            ServerPalette.setUserWhite(b);
        }
        return this;
    }

    public BaseGUIWindow setUserColors(boolean b) {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2053, b));
        } else {
            ServerPalette.setUserWhite(b);
            ServerPalette.setUserGray(b);
        }
        return this;
    }

    public BaseGUIWindow setWithSystemMenu(boolean b) {
        try {
            this.controlPeersetWithSystemMenu(b);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setWithNoWrap(boolean b) {
        return this;
    }

    public BaseGUIWindow setWithNoScroll(boolean b) {
        return this;
    }

    public BaseGUIWindow setControlsUncropped(boolean b) {
        return this;
    }

    public final boolean hasEventProc() {
        return this.eventProc != null;
    }

    public BaseGUIWindow setEventProc(IscobolModule prog, int start, int end) {
        return this.setEventProc(prog, start, end, null);
    }

    public BaseGUIWindow setEventProc(IscobolModule prog, int start, int end, CobolVar eS) {
        return this.setEventProc(prog, start, end, (ICobolVar)eS);
    }

    public BaseGUIWindow setEventProc(IscobolModule prog, int start, int end, ICobolVar eS) {
        this.eventProc = start >= 0 ? new ProcedureObject(prog, start, end, eS) : null;
        return this;
    }

    abstract void componentsetAutoMinimize(boolean var1);

    public BaseGUIWindow setAutoMinimize(boolean sam) {
        this.componentsetAutoMinimize(sam);
        return this;
    }

    abstract void componentsetAutoResize(boolean var1);

    public BaseGUIWindow setAutoResize(boolean sam) {
        if (this.title == null) {
            this.setTitle("");
        }
        this.componentsetAutoResize(sam);
        return this;
    }

    public BaseGUIWindow setMinSize(float ms) {
        try {
            this.controlPeersetMinSize((int)ms);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setMinSize(CobolVar ms) {
        return this.setMinSize((ICobolVar)ms);
    }

    public BaseGUIWindow setMinSize(ICobolVar ms) {
        this.setMinSize(ms.toint());
        return this;
    }

    public BaseGUIWindow setMaxSize(float ms) {
        try {
            this.controlPeersetMaxSize((int)ms);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setMaxSize(CobolVar ms) {
        return this.setMaxSize((ICobolVar)ms);
    }

    public BaseGUIWindow setMaxSize(ICobolVar ms) {
        this.setMaxSize(ms.toint());
        return this;
    }

    public BaseGUIWindow setMinLines(float ml) {
        try {
            this.controlPeersetMinLines((int)ml);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setMinLines(CobolVar ml) {
        return this.setMinLines((ICobolVar)ml);
    }

    public BaseGUIWindow setMinLines(ICobolVar ml) {
        this.setMinLines(ml.toint());
        return this;
    }

    public BaseGUIWindow setMaxLines(float ml) {
        try {
            this.controlPeersetMaxLines((int)ml);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setMaxLines(CobolVar ml) {
        return this.setMaxLines((ICobolVar)ml);
    }

    public BaseGUIWindow setMaxLines(ICobolVar ml) {
        this.setMaxLines(ml.toint());
        return this;
    }

    public BaseGUIWindow getWindowProperty(String propName, ICobolVar dest) {
        if ("CUSTOM-DATA".equalsIgnoreCase(propName)) {
            dest.set(this.customData != null ? this.customData : "");
            return this;
        }
        try {
            String propValue;
            if (this.controlPeer != null && (propValue = this.controlPeer.getWindowProperty(propName)) != null) {
                dest.set(propValue);
            } else {
                dest.set("");
            }
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setWindowProperty(String propName, ICobolVar propValue) {
        Integer propId = ParamsValues.getParamValue(propName.toUpperCase());
        if (propId != null) {
            switch (propId) {
                case 2080: {
                    this.screenindex = propValue.toint();
                    this.elemscreenindex = new ParamElementInt(propId.shortValue(), propValue.toint());
                    return this;
                }
                case 321: {
                    this.customData = propValue.toString();
                    return this;
                }
            }
        }
        if (this.paramCSWindow != null) {
            if (propId != null) {
                ParamVElement elem;
                switch (propId) {
                    case 2075: 
                    case 2077: 
                    case 2079: 
                    case 2083: 
                    case 2087: {
                        elem = new ParamElementInt(propId.shortValue(), propValue.toint());
                        break;
                    }
                    case 2076: {
                        int gradient = propValue.toint();
                        if (gradient >= 0) {
                            elem = new ParamElementInt(2076, gradient);
                            break;
                        }
                        elem = new ParamElementInt(2077, -gradient);
                        break;
                    }
                    case 2078: {
                        int gradient = propValue.toint();
                        if (gradient >= 0) {
                            elem = new ParamElementInt(2078, gradient);
                            break;
                        }
                        elem = new ParamElementInt(2079, -gradient);
                        break;
                    }
                    case 2086: {
                        elem = new ParamElementInt(propId.shortValue(), this.getFileImageId(propValue));
                        break;
                    }
                    default: {
                        elem = new ParamElementString(propId.shortValue(), propValue.toString());
                    }
                }
                this.paramCSWindow.addElement(elem);
            }
        } else {
            try {
                this.controlPeer.setWindowProperty(propName, propValue.toString());
            }
            catch (IOException e) {
                ScreenUtility.handleIOException(e);
            }
        }
        return this;
    }

    protected int getFileImageId(ICobolVar propValue) {
        int Return2 = -1;
        this.backgroundbitmaphandleCV = propValue;
        Object id = null;
        if (propValue instanceof IObjectVar) {
            id = propValue.getOId();
        } else if (propValue instanceof INumericVar) {
            id = UserHandles.getId(propValue.toint());
        }
        if (id instanceof FileImage) {
            Return2 = ((FileImage)id).getImageId();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyWindowProperty(String propName, ICobolVar propValue) {
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.setWindowProperty(propName, propValue);
                    if (this.elemscreenindex != null && this.paramCSWindow != null) {
                        this.paramCSWindow.addElement(this.elemscreenindex);
                    }
                    this.elemscreenindex = null;
                    this.env.enqueueParams(this);
                }
            }
        }
        try {
            this.controlPeer.setWindowProperty(propName, propValue.toString());
        }
        catch (IOException e) {
            ScreenUtility.handleIOException(e);
        }
        return this;
    }

    public ProcedureObject getProc(CobolRecordAccept cra) {
        ProcedureObject Return2 = null;
        if (cra.isEvent()) {
            Return2 = this.eventProc;
        }
        return Return2;
    }

    public ProcedureObject getProc(CobolAcceptEvent evt) {
        CobolRecordAccept cra = evt.getAcceptStatus();
        return this.getProc(cra);
    }

    public boolean hasProc(CobolRecordAccept cra) {
        if (cra.getControl() != null) {
            return false;
        }
        boolean Return2 = false;
        if (cra.isEvent() && this.eventProc != null) {
            Return2 = true;
        }
        return Return2;
    }

    public boolean hasProc(CobolAcceptEvent evt) {
        CobolRecordAccept cra = evt.getAcceptStatus();
        return this.hasProc(cra);
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
    }

    public BaseGUIWindow getScreenLine(CobolVar cv) {
        return this.getScreenLine((ICobolVar)cv);
    }

    public BaseGUIWindow getScreenLine(ICobolVar cv) {
        cv.set(this.getScreenLine());
        return this;
    }

    public float getScreenLine() {
        if (this.controlPeer != null) {
            try {
                return this.controlPeer.getMainBounds().getLocation().y;
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
                return -1.0f;
            }
        }
        return this.screenLine;
    }

    public float getScreenColumn() {
        if (this.controlPeer != null) {
            try {
                return this.controlPeer.getMainBounds().getLocation().x;
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
                return -1.0f;
            }
        }
        return this.screenColumn;
    }

    public BaseGUIWindow getScreenColumn(CobolVar cv) {
        return this.getScreenColumn((ICobolVar)cv);
    }

    public BaseGUIWindow getScreenColumn(ICobolVar cv) {
        cv.set(this.getScreenColumn());
        return this;
    }

    public BaseGUIWindow setScreenLineColumn(float fl, float fc) {
        this.screenLine = fl;
        this.screenColumn = fc;
        this.changeScreenLC = true;
        return this;
    }

    public BaseGUIWindow setScreenLineColumn(CobolVar fl, float fc) {
        return this.setScreenLineColumn((ICobolVar)fl, fc);
    }

    public BaseGUIWindow setScreenLineColumn(ICobolVar fl, float fc) {
        this.setScreenLineColumn(fl.tofloat(), fc);
        return this;
    }

    public BaseGUIWindow setScreenLineColumn(float fl, CobolVar fc) {
        return this.setScreenLineColumn(fl, (ICobolVar)fc);
    }

    public BaseGUIWindow setScreenLineColumn(float fl, ICobolVar fc) {
        this.setScreenLineColumn(fl, fc.tofloat());
        return this;
    }

    public BaseGUIWindow setScreenLineColumn(CobolVar fl, CobolVar fc) {
        return this.setScreenLineColumn((ICobolVar)fl, (ICobolVar)fc);
    }

    public BaseGUIWindow setScreenLineColumn(ICobolVar fl, ICobolVar fc) {
        this.setScreenLineColumn(fl.tofloat(), fc.tofloat());
        return this;
    }

    public BaseGUIWindow setScreenLine(float cv) {
        this.screenLine = cv;
        return this;
    }

    public BaseGUIWindow setScreenLine(CobolVar cv) {
        return this.setScreenLine((ICobolVar)cv);
    }

    public BaseGUIWindow setScreenLine(ICobolVar cv) {
        this.setScreenLine(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setScreenColumn(float cv) {
        this.screenColumn = cv;
        return this;
    }

    public BaseGUIWindow setScreenColumn(CobolVar cv) {
        return this.setScreenColumn((ICobolVar)cv);
    }

    public BaseGUIWindow setScreenColumn(ICobolVar cv) {
        this.setScreenColumn(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setAt(CobolVar cv) {
        return this.setAt((ICobolVar)cv);
    }

    public BaseGUIWindow setAt(ICobolVar cv) {
        this.setAt(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setColor(CobolVar cv) {
        return this.setColor((ICobolVar)cv);
    }

    public BaseGUIWindow setColor(ICobolVar cv) {
        this.setColor(cv.tofloat());
        return this;
    }

    public BaseGUIWindow getColor(ICobolVar cv) {
        if (cv != null) {
            if (this.color != null) {
                cv.set(this.colorint);
            } else {
                cv.set(0);
            }
        }
        return this;
    }

    public BaseGUIWindow getColorBackground(ICobolVar cv) {
        if (cv != null) {
            cv.set(this.getBackground());
        }
        return this;
    }

    public BaseGUIWindow getColorForeground(ICobolVar cv) {
        if (cv != null) {
            cv.set(this.getForeground());
        }
        return this;
    }

    public void destroy() {
    }

    public void destroy(BaseGUIWindow w) {
    }

    public void destroy(BaseGUIControl bgc, ParamVector v) {
    }

    public BaseGUIWindow setColorBackground(CobolVar cv) {
        return this.setColorBackground((ICobolVar)cv);
    }

    public BaseGUIWindow setColorBackground(ICobolVar cv) {
        this.setColorBackground(cv.toint());
        return this;
    }

    public BaseGUIWindow setColorForeground(CobolVar cv) {
        return this.setColorForeground((ICobolVar)cv);
    }

    public BaseGUIWindow setColorForeground(ICobolVar cv) {
        this.setColorForeground(cv.toint());
        return this;
    }

    public BaseGUIWindow setControlValue(CobolVar cv) {
        return this.setControlValue((ICobolVar)cv);
    }

    public BaseGUIWindow setControlValue(ICobolVar cv) {
        this.setControlValue(cv.toString());
        return this;
    }

    public BaseGUIWindow getVisible(CobolVar vis) {
        return this.getVisible((ICobolVar)vis);
    }

    public BaseGUIWindow getVisible(ICobolVar vis) {
        if (this.visible) {
            vis.set(1);
        } else {
            vis.set(0);
        }
        return this;
    }

    public BaseGUIWindow displaysetVisible() {
        try {
            this.controlPeersetVisible(this.visible);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public BaseGUIWindow setVisible(boolean b) {
        this.visible = b;
        return this;
    }

    public BaseGUIWindow setVisible(float visibled) {
        this.visible = visibled != 0.0f;
        this.setVisible(this.visible);
        return this;
    }

    public BaseGUIWindow setVisible(CobolVar cv) {
        return this.setVisible((ICobolVar)cv);
    }

    public BaseGUIWindow setVisible(ICobolVar cv) {
        this.setVisible(cv.tofloat());
        return this;
    }

    public BaseGUIWindow setEnabled(boolean e) {
        this.enabled = e;
        try {
            this.controlPeersetEnabled(e);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow setEnabled(float e) {
        this.enabled = e != 0.0f;
        this.setEnabled(this.enabled);
        return this;
    }

    public BaseGUIWindow setEnabled(CobolVar cv) {
        return this.setEnabled((ICobolVar)cv);
    }

    public BaseGUIWindow setEnabled(ICobolVar cv) {
        this.setEnabled(cv.tofloat());
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BaseGUIWindow setPopupArea(CobolVar cv) {
        return this.setPopupArea((ICobolVar)cv);
    }

    public BaseGUIWindow setPopupArea(ICobolVar cv) {
        try {
            this.controlPeersetPopupArea();
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this.setHandle(cv);
    }

    public BaseGUIWindow setAction(float cv) {
        this.currAction = cv;
        return this;
    }

    public BaseGUIWindow setAction(CobolVar cv) {
        return this.setAction((ICobolVar)cv);
    }

    public BaseGUIWindow setAction(ICobolVar cv) {
        this.setAction(cv.tofloat());
        return this;
    }

    public int getAction() {
        return (int)this.currAction;
    }

    public static void setHandle(CobolVar cv, BaseGUIWindow w) {
        BaseGUIWindow.setHandle((ICobolVar)cv, w);
    }

    public static void setHandle(ICobolVar cv, BaseGUIWindow w) {
        if (cv != null) {
            cv.set(UserHandles.ssetId(w));
        }
    }

    public BaseGUIWindow setHandle(CobolVar cv) {
        return this.setHandle((ICobolVar)cv);
    }

    public abstract BaseGUIWindow setHandle(ICobolVar var1);

    abstract BaseGUIWindow componentendDisplay();

    public BaseGUIWindow endDisplay() {
        int iconfileid = -1;
        if (this.env != null && this.iconid == -1 && (iconfileid = this.env.getIconFileId()) > 0) {
            try {
                this.controlPeersetIcon(iconfileid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.componentendDisplay();
        return this;
    }

    abstract BaseGUIWindow componentcheck();

    public BaseGUIWindow check() {
        return this.componentcheck();
    }

    public void displaysetColor() {
        this.componentsetForeground(ColorCmp.getRealColor(this.getForeground(), this.getForeHighlight()));
        this.componentsetBackground(ColorCmp.getRealColorBack(this.getBackground(), this.getBackHighlight()));
    }

    public BaseGUIWindow setGraphical(boolean b) {
        this.graphical = b;
        if (b) {
            this.cellTypeHeight = 1;
            this.cellTypeWidth = 1;
            this.cellChangeHeight = true;
            this.cellChangeWidth = true;
        }
        return this;
    }

    public boolean isGraphical() {
        return this.graphical;
    }

    public void close() {
    }

    public CobolGUIEnvironment getEnv() {
        return this.env;
    }

    public BaseGUIWindow modifyControlFont(FontCmp f) {
        this.componentsetControlFont(f);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyAction(float cv) throws ModifyException {
        if ((int)cv != 21 && (int)cv != 20 && (int)cv != 22 && (int)cv != 23) {
            throw new ModifyException();
        }
        this.setAction(cv);
        try {
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.controlPeersetAction(cv);
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.controlPeersetAction(cv);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow modifyAction(CobolVar cv) {
        return this.modifyAction((ICobolVar)cv);
    }

    public BaseGUIWindow modifyAction(ICobolVar cv) {
        this.modifyAction(cv.tofloat());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyScreenLineColumn(float fl, float fc) {
        this.screenLine = fl;
        this.screenColumn = fc;
        try {
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.controlPeersetLocation((int)fc, (int)fl);
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.controlPeer.setLocation((int)fc, (int)fl);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow modifyScreenLineColumn(CobolVar fl, float fc) {
        return this.modifyScreenLineColumn((ICobolVar)fl, fc);
    }

    public BaseGUIWindow modifyScreenLineColumn(ICobolVar fl, float fc) {
        this.modifyScreenLineColumn(fl.tofloat(), fc);
        return this;
    }

    public BaseGUIWindow modifyScreenLineColumn(float fl, CobolVar fc) {
        return this.modifyScreenLineColumn(fl, (ICobolVar)fc);
    }

    public BaseGUIWindow modifyScreenLineColumn(float fl, ICobolVar fc) {
        this.modifyScreenLineColumn(fl, fc.tofloat());
        return this;
    }

    public BaseGUIWindow modifyScreenLineColumn(CobolVar fl, CobolVar fc) {
        return this.modifyScreenLineColumn((ICobolVar)fl, (ICobolVar)fc);
    }

    public BaseGUIWindow modifyScreenLineColumn(ICobolVar fl, ICobolVar fc) {
        this.modifyScreenLineColumn(fl.tofloat(), fc.tofloat());
        return this;
    }

    public BaseGUIWindow modifyScreenLine(float cv) {
        return this;
    }

    public BaseGUIWindow modifyScreenLine(CobolVar cv) {
        return this.modifyScreenLine((ICobolVar)cv);
    }

    public BaseGUIWindow modifyScreenLine(ICobolVar cv) {
        this.modifyScreenLine(cv.tofloat());
        return this;
    }

    public BaseGUIWindow modifyScreenColumn(float cv) {
        return this;
    }

    public BaseGUIWindow modifyScreenColumn(CobolVar cv) {
        return this.modifyScreenColumn((ICobolVar)cv);
    }

    public BaseGUIWindow modifyScreenColumn(ICobolVar cv) {
        this.modifyScreenColumn(cv.tofloat());
        return this;
    }

    public BaseGUIWindow modifyEventProc(IscobolModule prog, int start, int end) {
        return this.setEventProc(prog, start, end, null);
    }

    public BaseGUIWindow modifyEventProc(IscobolCall prog, int start, int end, CobolVar eS) {
        return this.modifyEventProc(prog, start, end, (ICobolVar)eS);
    }

    public BaseGUIWindow modifyEventProc(IscobolCall prog, int start, int end, ICobolVar eS) {
        this.setEventProc((IscobolModule)prog, start, end, eS);
        return this;
    }

    public BaseGUIWindow modifyTitle(CobolVar t) {
        return this.modifyTitle((ICobolVar)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyTitle(ICobolVar t) {
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.setTitle(t);
                    this.env.enqueueParams(this);
                }
            }
        }
        this.setTitle(t);
        return this;
    }

    public BaseGUIWindow modifyTitle(String t) {
        this.setTitle(t);
        return this;
    }

    public BaseGUIWindow modifyColor(CobolVar c) {
        return this.modifyColor((ICobolVar)c);
    }

    public BaseGUIWindow modifyColor(ICobolVar c) {
        this.setColor(c);
        return this;
    }

    public BaseGUIWindow modifyColor(int c) {
        this.setColor(c);
        return this;
    }

    public BaseGUIWindow modifyColorForeground(CobolVar c) {
        return this.modifyColorForeground((ICobolVar)c);
    }

    public BaseGUIWindow modifyColorForeground(ICobolVar c) {
        this.setColorForeground(c);
        return this;
    }

    public BaseGUIWindow modifyColorForeground(int c) {
        this.setColorForeground(c);
        return this;
    }

    public BaseGUIWindow modifyColorBackground(CobolVar c) {
        return this.modifyColorBackground((ICobolVar)c);
    }

    public BaseGUIWindow modifyColorBackground(ICobolVar c) {
        this.setColorBackground(c);
        return this;
    }

    public BaseGUIWindow modifyColorBackground(int c) {
        this.setColorBackground(c);
        return this;
    }

    private void sendUpdateIfIsNotSameSW() {
        BaseGUIWindow bgw = ScrFactory.getGUISubWindow().check();
        if (bgw != this) {
            bgw.endDisplay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifySizes(float w) {
        this.setSizes(w);
        if (this.sizeChange) {
            if (this.isBufferedWindowType() && this.sizeChange) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.displaysetSize();
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.displaysetSize();
            this.sendUpdateIfIsNotSameSW();
        }
        return this;
    }

    public BaseGUIWindow modifySizes(CobolVar nl) {
        return this.modifySizes((ICobolVar)nl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifySizes(ICobolVar nl) {
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.setSizes(nl);
                    this.displaysetSize();
                    this.env.enqueueParams(this);
                }
            }
        }
        this.setSizes(nl);
        this.displaysetSize();
        this.sendUpdateIfIsNotSameSW();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyLines(float h) {
        this.setLines(h);
        if (this.sizeChange) {
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.displaysetSize();
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.displaysetSize();
            this.sendUpdateIfIsNotSameSW();
        }
        return this;
    }

    public BaseGUIWindow modifyLines(CobolVar nl) {
        return this.modifyLines((ICobolVar)nl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyLines(ICobolVar nl) {
        this.setLines(nl);
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.displaysetSize();
                    this.env.enqueueParams(this);
                }
            }
        }
        this.displaysetSize();
        this.sendUpdateIfIsNotSameSW();
        return this;
    }

    public BaseGUIWindow modifySize(CobolVar h, CobolVar w) {
        return this.modifySize((ICobolVar)h, (ICobolVar)w);
    }

    public BaseGUIWindow modifySize(ICobolVar h, ICobolVar w) {
        return this.modifySize(h.tofloat(), w.tofloat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifySize(float h, float w) {
        this.setSize(h, w);
        if (this.sizeChange) {
            if (this.isBufferedWindowType() && this.sizeChange) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.displaysetSize();
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.displaysetSize();
        }
        return this;
    }

    public BaseGUIWindow modifyAtLine(CobolVar al) {
        return this.modifyAtLine((ICobolVar)al);
    }

    public BaseGUIWindow modifyAtLine(ICobolVar al) {
        this.setAtLine(al);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyAtLine(float fac) {
        this.setAtLine(fac);
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.componentsetAtLocation();
                    this.env.enqueueParams(this);
                }
            }
        }
        this.componentsetAtLocation();
        return this;
    }

    public BaseGUIWindow modifyAtColumn(CobolVar al) {
        return this.modifyAtColumn((ICobolVar)al);
    }

    public BaseGUIWindow modifyAtColumn(ICobolVar al) {
        this.setAtColumn(al);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyAtColumn(float fac) {
        this.setAtColumn(fac);
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.componentsetAtLocation();
                    this.env.enqueueParams(this);
                }
            }
        }
        this.componentsetAtLocation();
        return this;
    }

    public BaseGUIWindow modifyAt(CobolVar cv) {
        return this.modifyAt((ICobolVar)cv);
    }

    public BaseGUIWindow modifyAt(ICobolVar cv) {
        int col;
        int row;
        int atval = cv.toint();
        if (cv.length() <= 4) {
            row = atval / 100;
            col = atval % 100;
        } else {
            row = atval / 1000;
            col = atval % 1000;
        }
        this.modifyAtLine(row);
        this.modifyAtColumn(col);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyLocation(float row, float col) {
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.setLocation(row, col);
                    this.env.enqueueParams(this);
                }
            }
        }
        this.setLocation(row, col);
        return this;
    }

    public BaseGUIWindow modifyFont(String stridxfont) {
        this.setFont(stridxfont);
        return this;
    }

    public BaseGUIWindow modifyFont(int idxfont) {
        this.setFont(idxfont);
        return this;
    }

    public BaseGUIWindow modifyFont(CobolVar cv) {
        return this.modifyFont((ICobolVar)cv);
    }

    public BaseGUIWindow modifyFont(ICobolVar cv) {
        this.setFont(cv);
        return this;
    }

    public BaseGUIWindow modifyEnabled(float e) {
        this.setEnabled(e);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyEnabled(boolean e) {
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.setEnabled(e);
                    this.env.enqueueParams(this, this.getParamCSWindow());
                    this.env.dequeueWindow(this);
                }
            }
        }
        this.setEnabled(e);
        return this;
    }

    public BaseGUIWindow modifyEnabled(CobolVar e) {
        return this.modifyEnabled((ICobolVar)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyEnabled(ICobolVar e) {
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.setEnabled(e);
                    this.env.enqueueParams(this, this.getParamCSWindow());
                    this.env.dequeueWindow(this);
                }
            }
        }
        this.setEnabled(e);
        return this;
    }

    public BaseGUIWindow modifyVisible(float e) {
        this.setVisible(e);
        this.displaysetVisible();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyVisible(boolean e) {
        this.setVisible(e);
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.displaysetVisible();
                    this.env.enqueueParams(this, this.getParamCSWindow());
                    this.env.dequeueWindow(this);
                }
            }
        }
        this.displaysetVisible();
        return this;
    }

    public BaseGUIWindow modifyVisible(CobolVar e) {
        return this.modifyVisible((ICobolVar)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyVisible(ICobolVar e) {
        this.setVisible(e);
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.displaysetVisible();
                    this.env.enqueueParams(this, this.getParamCSWindow());
                    this.env.dequeueWindow(this);
                }
            }
        }
        this.displaysetVisible();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyMinSize(float ms) {
        try {
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.controlPeersetMinSize((int)ms);
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.controlPeer.setMinSize((int)ms);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow modifyMinSize(CobolVar ms) {
        return this.modifyMinSize((ICobolVar)ms);
    }

    public BaseGUIWindow modifyMinSize(ICobolVar ms) {
        this.modifyMinSize(ms.toint());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyMaxSize(float ms) {
        try {
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.controlPeersetMaxSize((int)ms);
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.controlPeer.setMaxSize((int)ms);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow modifyMaxSize(CobolVar ms) {
        return this.modifyMaxSize((ICobolVar)ms);
    }

    public BaseGUIWindow modifyMaxSize(ICobolVar ms) {
        this.modifyMaxSize(ms.toint());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyMinLines(float ml) {
        try {
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.controlPeersetMinLines((int)ml);
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.controlPeer.setMinLines((int)ml);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow modifyMinLines(CobolVar ml) {
        return this.modifyMinLines((ICobolVar)ml);
    }

    public BaseGUIWindow modifyMinLines(ICobolVar ml) {
        this.modifyMinLines(ml.toint());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyMaxLines(float ml) {
        try {
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        this.getParamCSWindow();
                        this.controlPeersetMaxLines((int)ml);
                        this.env.enqueueParams(this);
                    }
                }
            }
            this.controlPeer.setMaxLines((int)ml);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return this;
    }

    public BaseGUIWindow modifyMaxLines(CobolVar ml) {
        return this.modifyMaxLines((ICobolVar)ml);
    }

    public BaseGUIWindow modifyMaxLines(ICobolVar ml) {
        this.modifyMaxLines(ml.toint());
        return this;
    }

    public BaseGUIWindow endModify() {
        if (!this.isBufferedWindowType()) {
            this.sendParams(this.paramCSWindow);
        }
        return this;
    }

    public BaseGUIWindow endInquire() {
        return this;
    }

    public abstract BaseGUIWindow setStyle(String var1);

    public abstract BaseGUIWindow unsetStyle(String var1);

    public abstract BaseGUIWindow setModal(boolean var1);

    public abstract int fireevent(RemoteRecordAccept var1);

    public abstract int[] loadEraseField(BaseGUIControl var1);

    protected abstract void deleteChildGraphics(BaseGUIControl var1) throws IOException;

    @Override
    public int type() {
        return 1;
    }

    public BaseGUIWindow addLine(float al) {
        this.addLines = al;
        return this;
    }

    public BaseGUIWindow addLine(CobolVar al) {
        return this.addLine((ICobolVar)al);
    }

    public BaseGUIWindow addLine(ICobolVar al) {
        return this.addLine(al.tofloat());
    }

    public BaseGUIWindow subLine(float al) {
        this.addLines = al;
        return this;
    }

    public BaseGUIWindow subLine(CobolVar al) {
        return this.subLine((ICobolVar)al);
    }

    public BaseGUIWindow subLine(ICobolVar al) {
        return this.subLine(al.tofloat());
    }

    public BaseGUIWindow addColumn(float al) {
        this.addColumns = al;
        return this;
    }

    public BaseGUIWindow addColumn(CobolVar al) {
        return this.addColumn((ICobolVar)al);
    }

    public BaseGUIWindow addColumn(ICobolVar al) {
        return this.addColumn(al.tofloat());
    }

    public BaseGUIWindow subColumn(float al) {
        this.addColumns = al;
        return this;
    }

    public BaseGUIWindow subColumn(CobolVar al) {
        return this.subColumn((ICobolVar)al);
    }

    public BaseGUIWindow subColumn(ICobolVar al) {
        return this.subColumn(al.tofloat());
    }

    Thread getCurrThread() {
        return this.currThread;
    }

    public BaseGUIWindow setIcon(NumericVar cv) {
        return this.setIcon((INumericVar)cv);
    }

    public BaseGUIWindow setIcon(INumericVar cv) {
        Object obj;
        this.iconCV = cv;
        if (cv != null && (obj = cv.getOId()) instanceof FileImage) {
            try {
                this.controlPeersetIcon(((FileImage)obj).getImageId());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this;
    }

    public void setCurrentLC(BaseGUIControl bgc, ParamVector param) {
        float currline = -1.0f;
        float currcol = -1.0f;
        boolean loadoffset = false;
        Vector srvids = null;
        if (bgc.getAtLine() == 0.0f) {
            currline = 0.0f;
            currcol = 0.0f;
        } else {
            srvids = new Vector();
            float[] ofsLC = bgc.loadOffset(this, srvids);
            float ofsl = ofsLC[0];
            float ofsc = ofsLC[1];
            if (ofsl >= 0.0f || bgc.childGraphics != null && bgc.childGraphics.size() > 0 || bgc.getParentControl() != null) {
                if (ofsl == -1.0f) {
                    ofsl = 1.0f;
                }
                currline = ofsl;
                currcol = ofsc;
                loadoffset = true;
            }
        }
        if (param != null) {
            if (currline >= 0.0f) {
                param.addElement(new ParamElementFloat(2033, currline));
            }
            if (currcol == 0.0f || loadoffset) {
                param.addElement(new ParamElementFloat(2034, currcol));
            }
            if (loadoffset) {
                int srvid = bgc.getControlPeerServerId();
                if (bgc.getClassType() == 0) {
                    srvid = bgc.getControlPeerServerIdHG();
                }
                int i = 0;
                int[] arrayint = null;
                if (srvids != null && srvids.size() > 0) {
                    arrayint = new int[srvids.size() + 1];
                    Enumeration childs = srvids.elements();
                    arrayint[i++] = srvid;
                    while (childs.hasMoreElements()) {
                        arrayint[i++] = (Integer)childs.nextElement();
                    }
                } else {
                    arrayint = new int[1];
                    arrayint[i++] = srvid;
                }
                param.addElement(new ParamElementArrayInt(1043, arrayint));
            }
        }
    }

    protected void returnpwsize(float ret) {
    }

    public void enqueueParams(ParamVector pv) {
        ParamVElement pe = null;
        if (pv == null) {
            return;
        }
        if (pv.size() == 0) {
            if (pv == this.paramCSWindow) {
                this.paramCSWindow = null;
            }
            return;
        }
        this.queuePCSWbytes += this.getPVsize(pv);
        Enumeration items = pv.elements();
        ParamElementVector pev = null;
        ParamElementVectorTD pevtd = null;
        ParamElementVectorToolB pevtb = null;
        ParamVector pcv = null;
        while (items.hasMoreElements()) {
            pe = (ParamVElement)items.nextElement();
            if (pe instanceof ParamElementVector) {
                pev = (ParamElementVector)pe;
                pcv = pev.getValueVector();
                pev.setValueVector((ParamVector)pcv.clone());
            } else if (pe instanceof ParamElementVectorTD) {
                pevtd = (ParamElementVectorTD)pe;
                pcv = pevtd.getValueVector();
                pevtd.setValueVector((ParamVector)pcv.clone());
            } else if (pe instanceof ParamElementVectorToolB) {
                pevtb = (ParamElementVectorToolB)pe;
                pcv = pevtb.getValueVector();
                pevtb.setValueVector((ParamVector)pcv.clone());
                Enumeration itemstb = pcv.elements();
                ParamVElement petb = null;
                while (itemstb.hasMoreElements()) {
                    petb = (ParamVElement)itemstb.nextElement();
                    if (petb instanceof ParamElementVector) {
                        pev = (ParamElementVector)petb;
                        pcv = pev.getValueVector();
                        pev.setValueVector((ParamVector)pcv.clone());
                        continue;
                    }
                    if (!(petb instanceof ParamElementVectorTD)) continue;
                    pevtd = (ParamElementVectorTD)petb;
                    pcv = pevtd.getValueVector();
                    pevtd.setValueVector((ParamVector)pcv.clone());
                }
            }
            this.queueParamCSWindow.addElement(pe);
        }
        this.clearandinitializeControl(pv, false);
        if (pv == this.paramCSWindow) {
            this.paramCSWindow.removeAllElements();
            this.paramCSWindow = null;
        }
    }

    public void dequeueParamsSend(boolean stoptimer) {
        this.dequeueParamsSend(stoptimer, false);
    }

    public void dequeueParamsSend(boolean stoptimer, boolean skipfirstanchor) {
        if (this.queueParamCSWindow.size() > 0) {
            this.env.sendParams(this, this.queueParamCSWindow, stoptimer, skipfirstanchor);
        }
    }

    public int getQueueSize() {
        return this.queuePCSWbytes;
    }

    private int getPVsize(ParamVector pv) {
        int Return2 = 0;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(pv);
            oos.flush();
            oos.close();
            bos.close();
            if (bos != null) {
                Return2 = bos.toByteArray().length;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendParams(ParamVector p) {
        if (this.queueParamCSWindow.size() > 0) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.env.enqueueParams(this, p);
                }
                this.env.sendParams(this, this.queueParamCSWindow, true);
            }
        }
        if (this.env != null) {
            this.env.sendParams(this, p, false);
        }
        this.paramCSWindow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendParamsWindow(ParamVector p) {
        boolean isvectorwindow;
        boolean bl = isvectorwindow = p == this.paramCSWindow;
        if (this.events == null) {
            return;
        }
        if (p == null) {
            return;
        }
        if (p.size() == 0) {
            if (isvectorwindow && p == this.paramCSWindow) {
                this.paramCSWindow = null;
            }
            return;
        }
        try {
            ParamVector Return2 = null;
            Return2 = this.controlPeer.sendParams(p);
            this.analyzeReturnWin(Return2, p == this.queueParamCSWindow);
            if (isvectorwindow) {
                this.clearandinitializeControl(p);
            }
            this.cleardelserveridvect();
        }
        catch (IOException _re) {
            if (_re.getMessage() != null && _re.getMessage().indexOf(JavaBeanInitException.class.getName()) >= 0) {
                throw new IscobolRuntimeException(3, _re.getMessage());
            }
            ScreenUtility.handleIOException(_re);
        }
        catch (JavaBeanInitException _re) {
            throw _re;
        }
        catch (Exception _re) {
            _re.printStackTrace();
        }
        finally {
            if (p != null) {
                p.removeAllElements();
                if (p == this.queueParamCSWindow) {
                    this.queuePCSWbytes = 0;
                }
            }
        }
    }

    protected void analyzeReturnWin(ParamVector Return2) {
        this.analyzeReturnWin(Return2, false);
    }

    protected void analyzeReturnWin(ParamVector Return2, boolean isqueuevector) {
        ParamVElement pe = null;
        ParamElementIntString peiS = null;
        ParamElementVector pev = null;
        ParamElementVectorTD pevtd = null;
        ParamElementInquire peq = null;
        ParamElementFont pef = null;
        BaseGUIControl bgc = null;
        DisplayWindow dw = null;
        Object obj = null;
        if (Return2 != null && Return2.size() > 0) {
            Enumeration params = Return2.elements();
            block28: while (params.hasMoreElements()) {
                pe = (ParamVElement)params.nextElement();
                switch (pe.getType()) {
                    case 2085: {
                        pev = (ParamElementVector)pe;
                        obj = this.env.searchWindow(pev.getSrvId());
                        if (obj == null || !(obj instanceof BaseGUIWindow)) break;
                        dw = (DisplayWindow)obj;
                        dw.analyzeReturnWin(pev.getValueVector(), isqueuevector);
                        break;
                    }
                    case 1070: {
                        peq = (ParamElementInquire)pe;
                        obj = this.getServerId(peq.getInqSrvid());
                        if (obj == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) break;
                        bgc.setInquireValue(peq.getInqOp(), peq.getInqValue(), peq.getInqValueBytea(), peq.getInqX(), peq.getInqY(), peq.getInqLen());
                        break;
                    }
                    case 2029: {
                        this.returnpwsize(((ParamElementFloat)pe).getValueFloat());
                        break;
                    }
                    case 2045: {
                        this.screenLine = ((ParamElementFloat)pe).getValueFloat();
                        break;
                    }
                    case 2046: {
                        this.screenColumn = ((ParamElementFloat)pe).getValueFloat();
                        break;
                    }
                    case 2031: {
                        if (pe instanceof ParamElementFloat) {
                            this.cellWidth = ((ParamElementFloat)pe).getValueFloat();
                            break;
                        }
                        if (!(pe instanceof ParamElementFont) || (pef = (ParamElementFont)pe).getFontPeer() == null || pef.getFontPeerId() < 0) break;
                        if (this.cellFontWidth != null) {
                            this.cellFontWidth.setFontPeer(pef.getFontPeer(), pef.getFontPeerId());
                            break;
                        }
                        if (this.componentgetControlFont() != null) {
                            this.componentgetControlFont().setFontPeer(pef.getFontPeer(), pef.getFontPeerId());
                            break;
                        }
                        FontCmp deff = FontCmp.getFont("DEFAULT-FONT");
                        deff.setFontPeer(pef.getFontPeer(), pef.getFontPeerId());
                        break;
                    }
                    case 2032: {
                        if (pe instanceof ParamElementFloat) {
                            this.cellHeight = ((ParamElementFloat)pe).getValueFloat();
                            break;
                        }
                        if (!(pe instanceof ParamElementFont) || (pef = (ParamElementFont)pe).getFontPeer() == null || pef.getFontPeerId() < 0) break;
                        if (this.cellFontHeight != null) {
                            this.cellFontHeight.setFontPeer(pef.getFontPeer(), pef.getFontPeerId());
                            break;
                        }
                        if (this.componentgetControlFont() != null) {
                            this.componentgetControlFont().setFontPeer(pef.getFontPeer(), pef.getFontPeerId());
                            break;
                        }
                        FontCmp deff = FontCmp.getFont("DEFAULT-FONT");
                        deff.setFontPeer(pef.getFontPeer(), pef.getFontPeerId());
                        break;
                    }
                    case 2063: {
                        if (this.clientCharDim == null) {
                            this.clientCharDim = new Dimension(0, 0);
                        }
                        this.clientCharDim.width = ((ParamElementInt)pe).getValueInt();
                        break;
                    }
                    case 2064: {
                        if (this.clientCharDim == null) {
                            this.clientCharDim = new Dimension(0, 0);
                        }
                        this.clientCharDim.height = ((ParamElementInt)pe).getValueInt();
                        break;
                    }
                    case 1026: {
                        pev = (ParamElementVector)pe;
                        obj = this.getServerId(pev.getSrvId());
                        if (obj == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed() || pev.getValueVector() == null) break;
                        bgc.analyzeReturnSendParams(pev.getValueVector(), isqueuevector);
                        break;
                    }
                    case 1030: {
                        pevtd = (ParamElementVectorTD)pe;
                        obj = this.getServerId(pevtd.getSrvIdTd());
                        if (obj == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed() || pevtd.getValueVector() == null) break;
                        bgc.analyzeReturnSendParams(pevtd.getValueVector());
                        break;
                    }
                    case 1029: {
                        pev = (ParamElementVector)pe;
                        if (pev.getSrvId() <= 0 || (obj = this.getServerId(pev.getSrvId())) == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed() || pev.getValueVector() == null) break;
                        bgc.analyzeReturnSendParams(pev.getValueVector());
                        break;
                    }
                    case 2035: {
                        ParamElementIntInt peii = (ParamElementIntInt)pe;
                        obj = this.getServerId(peii.getValueInt());
                        BaseGUIControl newbgc = null;
                        if (obj != null && obj instanceof BaseGUIControl) {
                            newbgc = (BaseGUIControl)obj;
                        }
                        if ((obj = this.getServerId(peii.getValuePar1())) == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) break;
                        this.removeDestroy(bgc, newbgc);
                        break;
                    }
                    case 2001: {
                        int oo = ((ParamElementInt)pe).getValueInt();
                        obj = this.getServerId(oo);
                        if (obj == null || !(obj instanceof BaseGUIControl)) break;
                        bgc = (BaseGUIControl)obj;
                        this.delServerId(((ParamElementInt)pe).getValueInt());
                        break;
                    }
                    case 1042: {
                        peiS = (ParamElementIntString)pe;
                        obj = this.getServerId(peiS.getValuePar1());
                        if (obj == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) break;
                        bgc.printvalue(peiS.getValueString());
                        bgc.setStrValue(peiS.getValueString());
                        bgc.analyzeData(null);
                        break;
                    }
                    case 2037: {
                        int[] iarray = ((ParamElementArrayInt)pe).getValueArrayInt();
                        if (iarray.length <= 0) break;
                        try {
                            this.eraseFields(iarray);
                        }
                        catch (IOException _re) {
                            ScreenUtility.handleIOException(_re);
                        }
                        break;
                    }
                    case 2036: {
                        ParamElementIntArrayInt peiai = (ParamElementIntArrayInt)pe;
                        int flgerase = peiai.getValuePar1();
                        int[] fieldserase = peiai.getValueArrayInt();
                        if (fieldserase == null || fieldserase.length <= 0) break;
                        try {
                            this.eraseFields(flgerase, fieldserase);
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    case 2044: {
                        obj = this.getServerId(((ParamElementInt)pe).getValueInt());
                        if (obj == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) break;
                        this.setFirstControlCursor(bgc);
                        break;
                    }
                    case 2057: {
                        this.cursorValue = ((ParamElementInt)pe).getValueInt();
                        break;
                    }
                    case 2067: {
                        if (!(this instanceof DisplayToolBar)) break;
                        ParamElementIntInt peiitb = (ParamElementIntInt)pe;
                        obj = this.getServerId(peiitb.getValuePar1());
                        if (obj == null || !(obj instanceof DisplayToolBar)) continue block28;
                        DisplayToolBar dtb = (DisplayToolBar)obj;
                        dtb.intdestroydtb();
                        break;
                    }
                    case 1051: {
                        DisplayToolBar dtb;
                        if (!(pe instanceof ParamElementVectorToolB)) break;
                        ParamElementVectorToolB pevtb = (ParamElementVectorToolB)pe;
                        obj = this.getServerId(pevtb.getSrvId());
                        if (obj == null || !(obj instanceof DisplayToolBar) || (dtb = (DisplayToolBar)obj) == null || dtb.isDestroyed() || pevtb.getValueVector() == null) continue block28;
                        dtb.analyzeReturnWin(pevtb.getValueVector());
                        break;
                    }
                    case 2071: {
                        pef = (ParamElementFont)pe;
                        if (pef.getFontPeer() == null || pef.getFontPeerId() < 0 || this.font == null || this.font.isInitialized()) break;
                        this.font.setFontPeer(pef.getFontPeer(), pef.getFontPeerId());
                    }
                }
            }
            if (Return2 != null) {
                Return2.removeAllElements();
            }
        }
    }

    public void clearandinitializeControl(ParamVector p) {
        this.clearandinitializeControl(p, true);
    }

    public void clearandinitializeControl(ParamVector p, boolean clearGiving) {
        ParamVElement pe = null;
        ParamElementVector pev = null;
        BaseGUIControl bgc = null;
        Enumeration paramsout = p.elements();
        Object obj = null;
        block7: while (paramsout.hasMoreElements()) {
            pe = (ParamVElement)paramsout.nextElement();
            switch (pe.getType()) {
                case 2085: {
                    pev = (ParamElementVector)pe;
                    obj = this.env.searchWindow(pev.getSrvId());
                    if (obj == null || !(obj instanceof BaseGUIWindow)) break;
                    DisplayWindow dw = null;
                    dw = (DisplayWindow)obj;
                    if (pev.getValueVector() == dw.getParamCSWindow()) {
                        dw.clearandinitializeControl(pev.getValueVector());
                    }
                    dw.cleardelserveridvect();
                    dw.getQueued().removeAllElements();
                    pev.getValueVector().removeAllElements();
                    if (pev.getValueVector() != dw.getQueued()) continue block7;
                    dw.queuePCSWbytes = 0;
                    break;
                }
                case 1029: {
                    if (!(pe instanceof ParamElementVector) || (pev = (ParamElementVector)pe).getSrvId() <= 0 || (obj = this.getServerId(pev.getSrvId())) == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) break;
                    bgc.clearandinitialize(clearGiving);
                    break;
                }
                case 1026: {
                    if (!(pe instanceof ParamElementVector) || (obj = this.getServerId((pev = (ParamElementVector)pe).getSrvId())) == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) break;
                    bgc.clearandinitialize(clearGiving);
                    break;
                }
                case 1030: {
                    if (!(pe instanceof ParamElementVectorTD)) break;
                    ParamElementVectorTD petd = (ParamElementVectorTD)pe;
                    obj = this.getServerId(petd.getSrvIdTd());
                    if (obj == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) continue block7;
                    bgc.clearandinitialize(clearGiving);
                    break;
                }
                case 1051: {
                    DisplayToolBar dtb;
                    ParamElementVectorToolB pevtb;
                    if (!(pe instanceof ParamElementVectorToolB) || (obj = this.getServerId((pevtb = (ParamElementVectorToolB)pe).getSrvId())) == null || !(obj instanceof DisplayToolBar) || (dtb = (DisplayToolBar)obj) == null || dtb.isDestroyed() || pevtb == null || pevtb.getValueVector() == null) break;
                    dtb.clearandinitializeControl(pevtb.getValueVector(), clearGiving);
                }
            }
        }
    }

    void controlPeersetFont(int fontId) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2003, fontId));
        } else {
            this.controlPeer.setFont(fontId);
        }
    }

    void controlPeersetTitleBar(boolean tb) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2004, tb));
        } else {
            this.controlPeer.setTitleBar(tb);
        }
    }

    void controlPeersetTitle(String t) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementString(2005, new String(t)));
        } else {
            this.controlPeer.setTitle(t);
        }
    }

    void controlPeersetDockInfo(String t) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementString(2060, t));
        } else {
            this.controlPeer.setDockInfo(t);
        }
    }

    void controlPeersetTitlePosition(int a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2006, a));
        } else {
            this.controlPeer.setTitlePosition(a);
        }
    }

    void controlPeersetActiveWindow(boolean a) throws IOException {
        this.controlPeersetActiveWindow(a, false, false);
    }

    void controlPeersetActiveWindow(boolean a, boolean useparams) throws IOException {
        this.controlPeersetActiveWindow(a, useparams, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void controlPeersetActiveWindow(boolean a, boolean useparams, boolean iscmdactive) throws IOException {
        ParamElementBoolean peb = new ParamElementBoolean(2007, a);
        Vector vector = this.env.getWindowWait();
        synchronized (vector) {
            ParamVector paramVector = this.queueParamCSWindow;
            synchronized (paramVector) {
                if (this.isBufferedWindowType() && this.queueParamCSWindow.size() > 0) {
                    if (iscmdactive) {
                        this.queueParamCSWindow.insertElementAt(peb, 0);
                    } else {
                        this.queueParamCSWindow.add(peb);
                    }
                    if (!a && !useparams) {
                        this.env.sendParams(this, this.queueParamCSWindow, false);
                    }
                } else if (this.paramCSWindow != null) {
                    if (iscmdactive) {
                        this.paramCSWindow.insertElementAt(peb, 0);
                    } else {
                        this.paramCSWindow.addElement(peb);
                    }
                    if (!a && !useparams) {
                        this.env.sendParams(this, this.paramCSWindow, false);
                    }
                } else if (this.controlPeer != null) {
                    this.controlPeer.setActiveWindow(a);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void controlPeertoFront() throws IOException {
        ParamVElement pve = new ParamVElement(2008);
        Vector vector = this.env.getWindowWait();
        synchronized (vector) {
            ParamVector paramVector = this.queueParamCSWindow;
            synchronized (paramVector) {
                if (this.isBufferedWindowType() && this.queueParamCSWindow.size() > 0) {
                    this.queueParamCSWindow.add(pve);
                } else if (this.paramCSWindow != null) {
                    this.paramCSWindow.addElement(pve);
                } else {
                    this.controlPeer.toFront();
                }
            }
        }
    }

    void controlPeersetResizable(boolean a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2009, a));
        } else {
            this.controlPeer.setResizable(a);
        }
    }

    void controlPeersetLabelOffset(int a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2010, a));
        } else {
            this.controlPeer.setLabelOffset(a);
        }
    }

    void controlPeersetWithSystemMenu(boolean a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2011, a));
        } else {
            this.controlPeer.setWithSystemMenu(a);
        }
    }

    void controlPeersetMinSize(int a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2012, a));
        } else {
            this.controlPeer.setMinSize(a);
        }
    }

    void controlPeersetMaxSize(int a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2013, a));
        } else {
            this.controlPeer.setMaxSize(a);
        }
    }

    void controlPeersetMinLines(int a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2014, a));
        } else {
            this.controlPeer.setMinLines(a);
        }
    }

    void controlPeersetMaxLines(int a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2015, a));
        } else {
            this.controlPeer.setMaxLines(a);
        }
    }

    void controlPeersetVisible(boolean a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2016, a));
        } else {
            this.controlPeer.setVisible(a);
        }
    }

    void controlPeersetEnabled(boolean a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2017, a));
        } else if (this.controlPeer != null) {
            this.controlPeer.setEnabled(a);
        }
    }

    void controlPeersetPopupArea() throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamVElement(2018));
        } else {
            this.controlPeer.setPopupArea();
        }
    }

    void controlPeersetAction(float a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementFloat(2019, a));
        } else {
            this.controlPeer.setAction(a);
        }
    }

    void controlPeersetIcon(int a) throws IOException {
        this.iconid = a;
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2020, a));
        } else {
            this.controlPeer.setIcon(a);
        }
    }

    void controlPeersetStyle(String s) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2021, ParamsValues.getParamValue(s)));
        }
    }

    void controlPeerunsetStyle(String s) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementInt(2022, ParamsValues.getParamValue(s)));
        }
    }

    void controlPeersetBackgroundIdx(int a) throws IOException {
        if (this.paramCSWindow != null) {
            if (this.isdefaultsubwindow) {
                this.paramCSWindow.addElement(new ParamElementInt(2041, a));
            } else {
                this.paramCSWindow.addElement(new ParamElementInt(2023, a));
            }
        } else {
            this.controlPeer.setBackgroundIdx(a);
        }
    }

    void controlPeersetForegroundIdx(int a) throws IOException {
        if (this.paramCSWindow != null) {
            if (this.isdefaultsubwindow) {
                this.paramCSWindow.addElement(new ParamElementInt(2042, a));
            } else {
                this.paramCSWindow.addElement(new ParamElementInt(2024, a));
            }
        } else {
            this.controlPeer.setForegroundIdx(a);
        }
    }

    void controlPeersetAutoResize(boolean a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2025, a));
        } else {
            this.controlPeer.setAutoResize(a);
        }
    }

    void controlPeersetModal(boolean a) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementBoolean(2026, a));
        } else {
            this.controlPeer.setModal(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void controlPeersetPopupMenu(int menuServerId) throws IOException {
        ServerMenuManager smm = (ServerMenuManager)IscobolSystem.getIfExists(ServerMenuManager.class, Thread.currentThread());
        if (smm != null) {
            ServerMenuManager.getDefault().getParamCSWindow().addElement(ParamElementMenu.ShowPopup(menuServerId, this.getTheObjectId()));
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    this.getParamCSWindow();
                    this.paramCSWindow.addElement(new ParamElementVector(2028, menuServerId, (ParamVector)ServerMenuManager.getDefault().getParamCSWindow().clone()));
                    this.enqueueParams(this.paramCSWindow);
                    ServerMenuManager.getDefault().paramCSWindow = null;
                }
            } else {
                ServerMenuManager.getDefault().sendParams(ServerMenuManager.getDefault().getParamCSWindow());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void controlPeersetMenu(int menuServerId) throws IOException {
        ServerMenuManager smm = (ServerMenuManager)IscobolSystem.getIfExists(ServerMenuManager.class, Thread.currentThread());
        if (smm != null) {
            ServerMenuManager.getDefault().getParamCSWindow().addElement(ParamElementMenu.Show(menuServerId, this.getTheObjectId()));
            if (this.isBufferedWindowType()) {
                Vector vector = this.env.getWindowWait();
                synchronized (vector) {
                    ParamVector paramVector = this.queueParamCSWindow;
                    synchronized (paramVector) {
                        Vector vector2 = this.env.getWindowWait();
                        synchronized (vector2) {
                            this.queueParamCSWindow.add(new ParamElementVector(2027, menuServerId, (ParamVector)ServerMenuManager.getDefault().getParamCSWindow().clone()));
                            ServerMenuManager.getDefault().paramCSWindow = null;
                        }
                    }
                }
            }
            ServerMenuManager.getDefault().sendParams(ServerMenuManager.getDefault().getParamCSWindow());
        }
    }

    protected void controlPeersetSize(float w, float h) throws IOException {
        float[] farray = new float[]{w, h};
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementArrayFloat(2029, farray));
        } else {
            this.controlPeer.setSize(w, h);
        }
    }

    protected void controlPeersetLocation(int x, int y) throws IOException {
        if (this.paramCSWindow != null) {
            this.paramCSWindow.addElement(new ParamElementIntInt(2039, x, y));
        } else {
            this.controlPeer.setLocation(x, y);
        }
    }

    protected void removeDestroy(BaseGUIControl bgcrem, BaseGUIControl bgcnew) {
    }

    protected void eraseFields(int[] arrayf) throws IOException {
    }

    protected void eraseFields(int flgerase, int[] arrayf) throws IOException {
    }

    public int getTerminalDisplayGateId() {
        return this.terminalDisplayGateID;
    }

    public void setTerminalDisplayGateId(int i) {
        this.terminalDisplayGateID = i;
    }

    public int setServerId(Object obj) {
        return this.env.setServerId(obj);
    }

    public Object getServerId(int oi) {
        return this.env.getServerId(oi);
    }

    public void delServerId(int oi) {
        if (this.env != null) {
            this.env.delServerId(oi);
        }
        if (oi == this.terminalDisplayGateID) {
            this.terminalDisplayGateID = 0;
        }
    }

    public void debugId() {
        this.env.debugId();
    }

    public ParamVector getParamCSWindow() {
        if (this.paramCSWindow == null) {
            this.paramCSWindow = new ParamVector(IscobolSystem.isAS());
        }
        return this.paramCSWindow;
    }

    public void controlrequestFocus(int srvid, int lastfocusid) throws IOException {
        this.controlPeer.controlrequestFocus(srvid, lastfocusid);
    }

    public void controlrestoreFocus(int srvid, int lastfocusid) throws IOException {
        this.controlPeer.controlrestoreFocus(srvid, lastfocusid);
    }

    public String controlsetValue(int srvid, String val) throws IOException {
        String Return2 = null;
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlsetValue(srvid, val);
        }
        return Return2;
    }

    public String controlgetValue(int srvid) throws IOException {
        String Return2 = "";
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlgetValue(srvid);
        }
        return Return2;
    }

    public String controlgetProp(int srvid, int key) throws IOException {
        String Return2 = "";
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlgetProp(srvid, key);
        }
        return Return2;
    }

    public String controlsetProp(int srvid, String key, String value, int len) throws IOException {
        String Return2 = "";
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlsetProp(srvid, key, value, len);
        }
        return Return2;
    }

    public String controlgetTitle(int srvid) throws IOException {
        String Return2 = "";
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlgetTitle(srvid);
        }
        return Return2;
    }

    public void controlsetElementAt(int srvid, int[] idxs) throws IOException {
        if (this.controlPeer != null) {
            this.controlPeer.controlsetElementAt(srvid, idxs);
        }
    }

    public void controlsetElementAt(int srvid, int idx) throws IOException {
        if (this.controlPeer != null) {
            this.controlPeer.controlsetElementAt(srvid, idx);
        }
    }

    public void controldestroyControlEditor(int srvid, int ceid) throws IOException {
        if (this.controlPeer != null) {
            this.controlPeer.controldestroyControlEditor(srvid, ceid);
        }
    }

    public float controlgetLine(int srvid) throws IOException {
        float Return2 = 0.0f;
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlgetLine(srvid);
        }
        return Return2;
    }

    public float controlgetColumn(int srvid) throws IOException {
        float Return2 = 0.0f;
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlgetColumn(srvid);
        }
        return Return2;
    }

    public float controlgetLines(int srvid) throws IOException {
        float Return2 = 0.0f;
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlgetLines(srvid);
        }
        return Return2;
    }

    public float controlgetSizes(int srvid) throws IOException {
        float Return2 = 0.0f;
        if (this.controlPeer != null) {
            Return2 = this.controlPeer.controlgetSizes(srvid);
        }
        return Return2;
    }

    public BaseGUIControl controlPeergetControl(int rowpix, int colpix) throws IOException {
        Object obj;
        BaseGUIControl Return2 = null;
        int srvid = 0;
        if (this.controlPeer != null) {
            srvid = this.controlPeer.getControl(rowpix, colpix);
        }
        if ((obj = this.getServerId(srvid)) != null && obj instanceof BaseGUIControl) {
            Return2 = (BaseGUIControl)obj;
        }
        return Return2;
    }

    public int controlfireevent(int srvid, RemoteRecordAccept rra) {
        BaseGUIControl bgc;
        if (this.env == null) {
            return 4;
        }
        Object obj = this.getServerId(srvid);
        if (obj != null && obj instanceof BaseGUIControl && (bgc = (BaseGUIControl)obj) != null) {
            return bgc.fireevent(rra);
        }
        return 4;
    }

    public int javaBeanfireevent(int srvid, RemoteRecordAccept rra) {
        CobolGUIJavaBean jb;
        Object obj = this.getServerId(srvid);
        if (obj != null && obj instanceof CobolGUIJavaBean && (jb = (CobolGUIJavaBean)obj) != null) {
            return jb.fireJavaBeanEvent(rra);
        }
        return 4;
    }

    void throwVetoException(int srvid, String excName, Object[] args) throws IOException {
        if (this.controlPeer != null) {
            this.controlPeer.throwVetoException(srvid, excName, args);
        }
    }

    public int setProperty(int srvid, String propName, Object propVal) throws IOException {
        if (this.controlPeer != null) {
            return this.controlPeer.setProperty(srvid, propName, propVal);
        }
        return -1;
    }

    public Object callMethod(int srvid, String methodName, String signature, Object[] parameters) throws IOException {
        if (this.controlPeer != null) {
            return this.controlPeer.callMethod(srvid, methodName, signature, parameters);
        }
        return null;
    }

    public Object getProperty(int srvid, String propName) throws IOException {
        if (this.controlPeer != null) {
            return this.controlPeer.getProperty(srvid, propName);
        }
        return null;
    }

    public void setSearchPanelSetting(int srvid, short settingIdx, boolean setting) throws IOException {
        if (this.controlPeer != null) {
            if (this instanceof DisplayWindow) {
                this.env.refreshWin((DisplayWindow)this);
            }
            this.controlPeer.setSearchPanelSetting(srvid, settingIdx, setting);
        }
    }

    public boolean[] getSearchPanelSettings(int srvid) throws IOException {
        if (this.controlPeer != null) {
            return this.controlPeer.getSearchPanelSettings(srvid);
        }
        return null;
    }

    public void debugChild(String msg) {
    }

    public void removeServerObjectO() {
    }

    private boolean loadChildVect(BaseGUIControl bgc, BaseGUIControl end) {
        BaseGUIControl tmp = null;
        boolean Return2 = false;
        if (bgc.getComponentType() == 0) {
            this.childvect.add(bgc);
            if (bgc.childGraphics == null) {
                return Return2;
            }
            ListIterator ctlLI = bgc.childGraphics.listIterator(0);
            while (ctlLI.hasNext() && !Return2) {
                tmp = (BaseGUIControl)ctlLI.next();
                if (tmp == end) {
                    Return2 = true;
                    continue;
                }
                Return2 = this.loadChildVect(tmp, end);
            }
        } else if (bgc != end) {
            this.childvect.add(bgc);
        }
        return Return2;
    }

    public float getWidthPrec(BaseGUIControl bgc, int startidx, int endidx, Vector srvids) {
        float Return2 = 0.0f;
        BaseGUIControl[] childs = null;
        BaseGUIControl anchor = bgc.getCloneSource();
        if (bgc instanceof TerminalEmulation) {
            anchor = bgc;
        }
        while (anchor.getParentTerminalControl() != null) {
            anchor = anchor.getParentTerminalControl();
        }
        this.childvect = new Vector();
        if (bgc instanceof TerminalEmulation) {
            this.loadChildVect(anchor, bgc);
        } else {
            this.loadChildVect(anchor, bgc.getCloneSource());
        }
        if (this.childvect != null && startidx <= endidx && this.childvect.size() > startidx && this.childvect.size() > endidx) {
            childs = new BaseGUIControl[this.childvect.size()];
            this.childvect.toArray(childs);
            BaseGUIControl tmp = null;
            float widthincell = 0.0f;
            for (int i = startidx; i <= endidx; ++i) {
                tmp = childs[i];
                if (tmp.getComponentType() == 0) continue;
                if (tmp.getLastClone() != null) {
                    tmp = tmp.getLastClone();
                }
                if ((widthincell = tmp.getWidthDimensionInCell()) > 0.0f) {
                    Return2 += widthincell;
                }
                if (tmp.getClassType() == 0 || tmp instanceof TerminalEmulation) continue;
                srvids.add(new Integer(tmp.getControlPeerServerId()));
            }
        }
        if (this.childvect != null) {
            this.childvect.removeAllElements();
        }
        return Return2;
    }

    public void setDefaultSubWindow(boolean s) {
        this.isdefaultsubwindow = s;
    }

    public boolean getDefaultSubWindow() {
        return this.isdefaultsubwindow;
    }

    public boolean haveAnchor(BaseGUIWindow bgw) {
        BaseGUIWindow anchor = this;
        while (anchor.getParentWnd() != null) {
            if ((anchor = anchor.getParentWnd()) != bgw) continue;
            return true;
        }
        return false;
    }

    public int getCursorValue() {
        return this.cursorValue;
    }

    public void setCursorValue(int c) {
        this.cursorValue = c;
    }

    public void setFirstControlCursor(BaseGUIControl bgc) {
    }

    public void writeObject(String filename, Object object) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public BaseGUIWindow setLayoutManager(CobolVar cv) {
        return this.setLayoutManager((ICobolVar)cv);
    }

    public BaseGUIWindow setLayoutManager(ICobolVar cv) {
        return this;
    }

    public void setInCriticalRegion(boolean b) {
        this.isincriticalregion = b;
    }

    public boolean isInCriticalRegion() {
        return this.isincriticalregion;
    }

    protected void evalColorMap() {
        this.color.evalColorMap(null);
    }

    protected boolean loadGetValueControls(ParamVector pv, BaseGUIControl bgccheck) {
        return this.loadGetValueControls(pv, null, null, bgccheck);
    }

    protected boolean loadGetValueControls(ParamVector pv, BaseGUIControl bb, BaseGUIControl.MyString[] ms, BaseGUIControl bgccheck) {
        boolean Return2 = false;
        if (pv != null && pv.size() > 0 && this.env != null) {
            Enumeration params = pv.elements();
            ParamVElement pe = null;
            ParamElementIntString peiS = null;
            BaseGUIControl bgc = null;
            boolean end = false;
            Object obj = null;
            while (!end && params.hasMoreElements()) {
                pe = (ParamVElement)params.nextElement();
                if (pe.getType() == 1042) {
                    peiS = (ParamElementIntString)pe;
                    obj = this.env.getServerId(peiS.getValuePar1());
                    if (obj == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) continue;
                    if (bb == null || bb == bgc) {
                        bgc.printvalue(peiS.getValueString());
                        bgc.setStrValue(peiS.getValueString());
                        if (bgc == bgccheck) {
                            Return2 = true;
                        }
                    }
                    if (bb == null) {
                        bgc.analyzeData(null);
                        continue;
                    }
                    if (bb != bgc) continue;
                    end = true;
                    bgc.analyzeData(ms);
                    continue;
                }
                if (pe.getType() != 1012 || (obj = this.env.getServerId((peiS = (ParamElementIntString)pe).getValuePar1())) == null || !(obj instanceof BaseGUIControl) || (bgc = (BaseGUIControl)obj) == null || bgc.isDestroyed()) continue;
                bgc.setStrValue(peiS.getValueString());
            }
        }
        return Return2;
    }

    public ParamVector getQueued() {
        return this.queueParamCSWindow;
    }

    public Dimension getCharDim() {
        return this.clientCharDim;
    }

    public ArrayList getCurrChildsActiveAccept() {
        return this.currChildsActiveAccept;
    }

    public BaseGUIWindow setBufferizable(float r) {
        this.bufferedwincmd = r;
        return this;
    }

    public BaseGUIWindow setBufferizable(CobolVar r) {
        return this.setBufferizable((ICobolVar)r);
    }

    public BaseGUIWindow setBufferizable(ICobolVar r) {
        this.setBufferizable(r.tofloat());
        return this;
    }

    protected boolean isBufferedWindowType() {
        switch (this.type) {
            case 7: 
            case 8: 
            case 11: {
                return false;
            }
        }
        if (this.bufferedwincmd == 0.0f) {
            return false;
        }
        if (this.bufferedwincmd == 1.0f) {
            return true;
        }
        return this.env != null && this.env.isBufferedWindowType(this, this.type);
    }

    public void putInquireData(ParamVElement pve) {
        this.putInquireData(pve, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInquireData(ParamVElement pve, boolean send) {
        Vector vector = this.env.getWindowWait();
        synchronized (vector) {
            if (!this.destroyed) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.paramCSWindow.addElement(pve);
                    if (!send || this.hasInquireBuffered()) {
                        this.enqueueParams(this.paramCSWindow);
                    } else if (this.queueParamCSWindow.size() > 0) {
                        this.enqueueParams(this.paramCSWindow);
                        if (!this.hasInquireBuffered()) {
                            this.dequeueParamsSend(false);
                        }
                    } else {
                        this.sendParamsWindow(this.paramCSWindow);
                    }
                }
            }
        }
    }

    public void setInquireBuffered(boolean b) {
        this.inquirebuffered = b;
    }

    public boolean hasInquireBuffered() {
        return this.inquirebuffered;
    }

    public BaseGUIWindow setControlString(CobValue s) {
        return this;
    }

    public BaseGUIWindow setControlStringCR(CobValue s) {
        return this;
    }

    public BaseGUIWindow setWCB(ICobolVar wcb) {
        return this;
    }

    public void setActiveAccept(boolean b) {
        this.activeAccept = b;
    }

    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    public GuiFactory getGuiFactory() {
        return this.gf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleardelserveridvect() {
        Vector vector = this.delserveridvect;
        synchronized (vector) {
            Enumeration elid = this.delserveridvect.elements();
            int tmp = -1;
            Integer tmpI = null;
            while (elid.hasMoreElements()) {
                tmpI = (Integer)elid.nextElement();
                if (tmpI == null || (tmp = tmpI.intValue()) <= 0) continue;
                this.delServerId(tmp);
            }
            this.delserveridvect.removeAllElements();
        }
    }

    public boolean isOptNew() {
        return (this.type == 6 || this.type == 2 || this.type == 5 || this.type == 3 || this.type == 9 || this.type == 10) && this.controlPeer == null && !this.destroyed;
    }

    public int getScreenIndex() {
        return this.screenindex;
    }

    public BaseGUIWindow setBeep(boolean b) {
        return this;
    }

    public BaseGUIWindow setBlink(boolean b) {
        return this;
    }

    public int getForegroundIntensity() {
        return this.foregroundIntensity;
    }

    public CobolGUIMenu getPopupMenu() {
        return this.popupMenu;
    }

    void controlPeersetMassUpdate(boolean ma) {
    }

    public BaseGUIWindow setMassUpdate(String ma) {
        this.controlPeersetMassUpdate(ma != null && ma.equals("1"));
        return this;
    }

    public BaseGUIWindow setMassUpdate(CobolVar ma) {
        return this.setMassUpdate(ma);
    }

    public BaseGUIWindow setMassUpdate(ICobolVar ma) {
        this.setMassUpdate(ma);
        return this;
    }

    public BaseGUIWindow modifyMassUpdate(CobolVar ma) {
        return this.modifyMassUpdate((ICobolVar)ma);
    }

    public BaseGUIWindow modifyMassUpdate(ICobolVar ma) {
        this.modifyMassUpdate(ma.toString());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseGUIWindow modifyMassUpdate(String ma) {
        if (this.isBufferedWindowType()) {
            Vector vector = this.env.getWindowWait();
            synchronized (vector) {
                ParamVector paramVector = this.queueParamCSWindow;
                synchronized (paramVector) {
                    this.getParamCSWindow();
                    this.controlPeersetMassUpdate(ma != null && ma.equals("1"));
                    this.env.enqueueParams(this);
                }
            }
        }
        this.controlPeersetMassUpdate(ma != null && ma.equals("1"));
        return this;
    }

    public BaseGUIWindow getMassUpdate(CobolVar dest) {
        return this.getMassUpdate((ICobolVar)dest);
    }

    public BaseGUIWindow getMassUpdate(ICobolVar dest) {
        return this;
    }

    public void setCustomData(String s) {
        this.customData = s;
    }

    public String getCustomData() {
        if (this.customData == null) {
            return "";
        }
        return this.customData;
    }
}

