/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.export;

import com.iscobol.gui.export.ExportDataProvider;
import com.iscobol.gui.export.ExportFileChooser;
import com.iscobol.gui.export.ExportMonitor;
import com.iscobol.gui.export.Exporter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ExportUtilities {
    public static void exportExcel(boolean showDialog, Component component, String exportFileName, String exportFileFormat, String defaultName, String xlsExporterClassName, String xlsxExporterClassName, String controlType, ExportDataProvider dataProvider, boolean exportFileopen, Image progressDialogIcon) {
        try {
            String defExt;
            String[] extensions;
            String[] filterDescriptions;
            File defaultSelection = exportFileName != null && exportFileName.length() > 0 ? new File(exportFileName) : ("xlsx".equalsIgnoreCase(exportFileFormat) ? new File(defaultName + ".xlsx") : new File(defaultName + ".xls"));
            File dir = defaultSelection.getParentFile();
            if (dir == null) {
                dir = new File(".");
            }
            if ("xlsx".equalsIgnoreCase(exportFileFormat)) {
                filterDescriptions = new String[]{"Excel Workbook (*.xlsx)"};
                extensions = new String[]{"xlsx"};
                defExt = "xlsx";
            } else if ("xls".equalsIgnoreCase(exportFileFormat)) {
                filterDescriptions = new String[]{"Excel 97 - Excel 2003 Workbook (*.xls)"};
                extensions = new String[]{"xls"};
                defExt = "xls";
            } else {
                filterDescriptions = new String[]{"Excel Workbook (*.xlsx)", "Excel 97 - Excel 2003 Workbook (*.xls)"};
                extensions = new String[]{"xlsx", "xls"};
                defExt = null;
            }
            String fileName = null;
            fileName = !showDialog ? defaultSelection.getPath() : ExportFileChooser.openSaveDialog(defaultSelection.getPath(), extensions, filterDescriptions, defExt, true);
            if (fileName != null) {
                class ExportMonitor
                extends JDialog
                implements com.iscobol.gui.export.ExportMonitor {
                    private static final long serialVersionUID = 1L;
                    JLabel label;
                    JProgressBar progress;
                    final /* synthetic */ String val$controlType;

                    ExportMonitor(JDialog fileName, String string) {
                        this.val$controlType = string;
                        super(owner, "Export", true);
                        this.init(owner, (String)((Object)fileName));
                    }

                    ExportMonitor(JFrame fileName, String string) {
                        this.val$controlType = string;
                        super(owner, "Export", true);
                        this.init(owner, (String)((Object)fileName));
                    }

                    void init(Window owner, String fileName) {
                        this.setDefaultCloseOperation(0);
                        this.getContentPane().setLayout(new BorderLayout());
                        this.label = new JLabel("Export " + this.val$controlType + " content to '" + fileName + "'.");
                        this.getContentPane().add((Component)this.label, "North");
                        this.progress = new JProgressBar(0, 0, 10);
                        this.progress.setPreferredSize(new Dimension(300, 25));
                        this.progress.setStringPainted(true);
                        this.getContentPane().add((Component)this.progress, "Center");
                        this.pack();
                        this.setLocationRelativeTo(owner);
                    }

                    @Override
                    public void worked(int work) {
                        this.progress.setValue(work);
                    }

                    void error(String msg) {
                        this.label.setText(msg);
                        this.pack();
                        this.disposeDelayed();
                    }

                    void disposeDelayed() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.dispose();
                    }

                    @Override
                    public void done() {
                        this.label.setText("Export completed.");
                        this.disposeDelayed();
                    }
                }
                String ext = null;
                for (int i = 0; i < extensions.length && ext == null; ++i) {
                    if (!fileName.toLowerCase().endsWith("." + extensions[i])) continue;
                    ext = extensions[i];
                }
                if (ext == null) {
                    ext = extensions[0];
                    fileName = fileName.endsWith(".") ? fileName + ext : fileName + "." + ext;
                }
                String className = "xlsx".equalsIgnoreCase(ext) ? xlsxExporterClassName : xlsExporterClassName;
                final Exporter exporter = (Exporter)Class.forName(className).newInstance();
                exporter.setOutputFile(fileName);
                exporter.setDataProvider(dataProvider);
                Window monitor = null;
                for (Container cnt = component.getParent(); cnt != null && monitor == null; cnt = cnt.getParent()) {
                    if (cnt instanceof JFrame) {
                        monitor = new ExportMonitor((JFrame)cnt, fileName, controlType);
                        continue;
                    }
                    if (!(cnt instanceof JDialog)) continue;
                    monitor = new ExportMonitor((JDialog)cnt, fileName, controlType);
                }
                monitor.setIconImage(progressDialogIcon);
                exporter.setMonitor((com.iscobol.gui.export.ExportMonitor)((Object)monitor), 10);
                Window m = monitor;
                new Thread((ExportMonitor)m){
                    final /* synthetic */ ExportMonitor val$m;
                    {
                        this.val$m = exportMonitor;
                    }

                    @Override
                    public void run() {
                        block2: {
                            try {
                                exporter.export();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (this.val$m == null) break block2;
                                this.val$m.error(e.toString());
                            }
                        }
                    }
                }.start();
                ((Dialog)monitor).setVisible(true);
            }
            if (exportFileopen) {
                Desktop.getDesktop().open(new File(fileName));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

