/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.WebClientEvent;
import com.iscobol.gui.client.swing.WebClientListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JPanel;

public class WebClientUtility {
    private static final Character char_0 = new Character('\u0000');
    private static final Byte byte_0 = new Byte(0);
    private static final boolean initSucceeded;
    private static final Class webActionListenerCls;
    private static final Object webSwingApi;
    private static final Method sendActionEventMth;
    private static final Method sendActionEventWWMth;
    private static final Method createHtmlPanelMth;
    private static final Class webWindowActionListenerCls;
    private static final Method addWebWindowActionListenerMth;
    private static final Method removeWebWindowActionListenerMth;
    private static final Method getActionNameMth;
    private static final Method getDataMth;
    private static final Method getBinaryDataMth;
    private static int communicationStatusValue;
    private final ArrayList<WebClientListener> listeners = new ArrayList();
    private final LinkedList<WebClientEvent> events = new LinkedList();
    private final Object webActionListener;

    public WebClientUtility() throws Throwable {
        MyInvocationHandler hdl = new MyInvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("actionPerformed".equals(method.getName())) {
                    return WebClientUtility.this.fireWebActionEvent(args[0]);
                }
                return super.invoke(proxy, method, args);
            }
        };
        this.webActionListener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{webActionListenerCls}, (InvocationHandler)hdl);
        webSwingApi.getClass().getMethod("addBrowserActionListener", webActionListenerCls).invoke(webSwingApi, this.webActionListener);
    }

    private static Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    private static Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    private static Object nullValueOf(Class rt) {
        if (!rt.isPrimitive()) {
            return null;
        }
        if (rt == Void.TYPE) {
            return null;
        }
        if (rt == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (rt == Character.TYPE) {
            return char_0;
        }
        return byte_0;
    }

    private Object fireWebActionEvent(Object event) {
        if (WebClientUtility.getCommunicationStatusValue() > 0) {
            try {
                this.fireWebActionEvent(new WebClientEvent((String)getActionNameMth.invoke(event, new Object[0]), (String)getDataMth.invoke(event, new Object[0]), (byte[])getBinaryDataMth.invoke(event, new Object[0])));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWebActionEvent(WebClientEvent event) {
        AbstractList abstractList = this.events;
        synchronized (abstractList) {
            this.events.addLast(event);
            this.events.notify();
        }
        abstractList = this.listeners;
        synchronized (abstractList) {
            for (WebClientListener l : this.listeners) {
                l.messageReceived(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebClientListener(WebClientListener l) {
        ArrayList<WebClientListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebClientListener(WebClientListener l) {
        ArrayList<WebClientListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    public static boolean sendActionEvent(String actionName, String data, byte[] binaryData) {
        if (communicationStatusValue > 0) {
            try {
                sendActionEventMth.invoke(webSwingApi, actionName, data, binaryData);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    public static boolean sendActionEvent(Object htmlPanel, String actionName, String data, byte[] binaryData) {
        try {
            sendActionEventWWMth.invoke(webSwingApi, htmlPanel, actionName, data, binaryData);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebClientEvent getActionEvent(int timeout, String[] errCode) {
        if (communicationStatusValue <= 0) {
            errCode[0] = "-1";
            return null;
        }
        LinkedList<WebClientEvent> linkedList = this.events;
        synchronized (linkedList) {
            if (this.events.isEmpty()) {
                if (timeout > 0) {
                    errCode[0] = "99";
                    try {
                        this.events.wait(timeout);
                    }
                    catch (InterruptedException ex) {
                        errCode[0] = "-1";
                    }
                } else {
                    errCode[0] = "-1";
                    try {
                        this.events.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.events.isEmpty()) {
                    return null;
                }
                return this.events.removeFirst();
            }
            return this.events.removeFirst();
        }
    }

    public static int getCommunicationStatusValue() {
        return communicationStatusValue;
    }

    public static void setCommunicationStatusValue(int communicationStatusValue) {
        WebClientUtility.communicationStatusValue = communicationStatusValue;
    }

    public static JPanel createHtmlPanel() {
        try {
            return (JPanel)createHtmlPanelMth.invoke(webSwingApi, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object addWebClientListener(JPanel htmlPanel, final WebClientListener listener) {
        try {
            MyInvocationHandler hdl = new MyInvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("actionPerformed".equals(method.getName())) {
                        try {
                            WebClientEvent evt = new WebClientEvent((String)getActionNameMth.invoke(args[0], new Object[0]), (String)getDataMth.invoke(args[0], new Object[0]), (byte[])getBinaryDataMth.invoke(args[0], new Object[0]));
                            listener.messageReceived(evt);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                    if ("windowInitialized".equals(method.getName())) {
                        return null;
                    }
                    return super.invoke(proxy, method, args);
                }
            };
            Object proxy = Proxy.newProxyInstance(WebClientUtility.class.getClassLoader(), new Class[]{webWindowActionListenerCls}, (InvocationHandler)hdl);
            addWebWindowActionListenerMth.invoke((Object)htmlPanel, proxy);
            return proxy;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void removeWebWindowActionListener(JPanel htmlPanel, Object listener) {
        try {
            removeWebWindowActionListenerMth.invoke((Object)htmlPanel, listener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static WebClientUtility getInstance() {
        if (initSucceeded) {
            try {
                return new WebClientUtility();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void dispose() {
        try {
            webSwingApi.getClass().getMethod("removeBrowserActionListener", webActionListenerCls).invoke(webSwingApi, this.webActionListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Class<?> webActionListenerCls0 = null;
        Object webSwingApi0 = null;
        Method sendActionEventMth0 = null;
        Method sendActionEventWWMth0 = null;
        Method createHtmlPanelMth0 = null;
        Class<?> webWindowActionListenerCls0 = null;
        Class<?> htmlPanelCls0 = null;
        Method addWebWindowActionListenerMth0 = null;
        Method removeWebWindowActionListenerMth0 = null;
        Method getActionNameMth0 = null;
        Method getDataMth0 = null;
        Method getBinaryDataMth0 = null;
        boolean ok = false;
        try {
            webActionListenerCls0 = Class.forName("org.webswing.toolkit.api.action.WebActionListener");
            Class<?> webswingutil = Class.forName("org.webswing.toolkit.api.WebswingUtil");
            webSwingApi0 = webswingutil.getMethod("getWebswingApi", new Class[0]).invoke(null, new Object[0]);
            sendActionEventMth0 = webSwingApi0.getClass().getMethod("sendActionEvent", String.class, String.class, byte[].class);
            Class<?> webwindow = Class.forName("org.webswing.toolkit.api.action.WebWindow");
            sendActionEventWWMth0 = webSwingApi0.getClass().getMethod("sendActionEvent", webwindow, String.class, String.class, byte[].class);
            createHtmlPanelMth0 = webSwingApi0.getClass().getMethod("createHtmlPanel", new Class[0]);
            webWindowActionListenerCls0 = Class.forName("org.webswing.toolkit.api.action.WebWindowActionListener");
            htmlPanelCls0 = Class.forName("org.webswing.toolkit.api.component.HtmlPanel");
            addWebWindowActionListenerMth0 = htmlPanelCls0.getMethod("addWebWindowActionListener", webWindowActionListenerCls0);
            removeWebWindowActionListenerMth0 = htmlPanelCls0.getMethod("removeWebWindowActionListener", webWindowActionListenerCls0);
            Class<?> webactionevent = Class.forName("org.webswing.toolkit.api.action.WebActionEvent");
            getActionNameMth0 = webactionevent.getMethod("getActionName", new Class[0]);
            getDataMth0 = webactionevent.getMethod("getData", new Class[0]);
            getBinaryDataMth0 = webactionevent.getMethod("getBinaryData", new Class[0]);
            ok = true;
        }
        catch (Throwable t) {
            ok = false;
        }
        webSwingApi = webSwingApi0;
        sendActionEventMth = sendActionEventMth0;
        sendActionEventWWMth = sendActionEventWWMth0;
        createHtmlPanelMth = createHtmlPanelMth0;
        webWindowActionListenerCls = webWindowActionListenerCls0;
        addWebWindowActionListenerMth = addWebWindowActionListenerMth0;
        removeWebWindowActionListenerMth = removeWebWindowActionListenerMth0;
        getActionNameMth = getActionNameMth0;
        getDataMth = getDataMth0;
        getBinaryDataMth = getBinaryDataMth0;
        webActionListenerCls = webActionListenerCls0;
        initSucceeded = ok;
    }

    private static abstract class MyInvocationHandler
    implements InvocationHandler {
        private MyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("hashCode".equals(method.getName())) {
                return WebClientUtility.proxyHashCode(proxy);
            }
            if ("equals".equals(method.getName())) {
                return WebClientUtility.proxyEquals(proxy, args[0]);
            }
            if ("toString".equals(method.getName())) {
                return WebClientUtility.proxyToString(proxy);
            }
            return WebClientUtility.nullValueOf(method.getReturnType());
        }
    }
}

