/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.TabClosableListener;
import com.iscobol.gui.client.TabWillChangeListener;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.PicobolTabNative;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteTab;
import com.iscobol.gui.client.swing.TabClosableComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class Tab
extends JPanel {
    private static final long serialVersionUID = 0L;
    private PicobolTabNative tabPane = null;
    private JPanel borderedPane;
    private Color tabbg;
    private Color tabfg;
    private Color activetabbg;
    private Color activetabfg;
    private int[] borderwidth;
    private int[] activeborderwidth;
    private Color tabborderforegroundcolor;
    private Color activetabborderforegroundcolor;
    private boolean istabbuttons;
    private GradientManager gradientMgr;
    private boolean textnorotate;
    private boolean istabclosebutton;
    private Image imagemouseentered;
    private Image imagemouseexited;

    public Tab(boolean multiline, boolean relativeoffset, boolean istabflat, boolean istabbuttons, boolean istabclosebutton, boolean nativestyle, RemoteTab parentRbgc) {
        this.istabbuttons = istabbuttons;
        this.istabclosebutton = istabclosebutton;
        this.gradientMgr = parentRbgc.gradientMgr;
        this.tabPane = new PicobolTabNative(multiline, false, false, relativeoffset, istabflat, istabbuttons, istabclosebutton, null, null, parentRbgc);
        this.setLayout(new BorderLayout(0, 0));
        this.borderedPane = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Tab.this.gradientMgr.paint((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
        };
        if (this.tabbg != null) {
            this.tabPane.setTabBackgroundColor(this.tabbg);
        }
        if (this.tabfg != null) {
            this.tabPane.setTabForegroundColor(this.tabfg);
        }
        if (this.activetabbg != null) {
            this.tabPane.setActiveTabBackgroundColor(this.activetabbg);
        }
        if (this.activetabfg != null) {
            this.tabPane.setActiveTabForegroundColor(this.activetabfg);
        }
        if (!nativestyle && !istabbuttons) {
            if (istabflat) {
                this.borderedPane.setBorder(BorderFactory.createEtchedBorder(1));
            } else {
                this.borderedPane.setBorder(BorderFactory.createRaisedBevelBorder());
            }
        }
        this.tabPane.setBorderWidth(this.borderwidth);
        this.tabPane.setActiveBorderWidth(this.borderwidth);
        this.tabPane.setBorderForegroundColor(this.tabborderforegroundcolor);
        this.tabPane.setActiveBorderForegroundColor(this.activetabborderforegroundcolor);
        this.borderedPane.setLayout(null);
        this.borderedPane.setOpaque(false);
        this.setOpaque(false);
        this.gradientMgr.addPropertyChangeListener(e -> {
            this.borderedPane.setOpaque(this.gradientMgr.isPaintGradient());
            this.setOpaque(this.gradientMgr.isPaintGradient());
            this.borderedPane.repaint();
        });
    }

    public JPanel getBorderedPane() {
        return this.borderedPane;
    }

    public void addTabWillChangeListener(TabWillChangeListener l) {
        this.tabPane.addTabWillChangeListener(l);
    }

    public void removeTabWillChangeListener(TabWillChangeListener l) {
        this.tabPane.removeTabWillChangeListener(l);
    }

    public void addTabClosableListener(TabClosableListener l) {
        this.tabPane.addTabClosableListener(l);
    }

    public void removeTabClosableListener(TabClosableListener l) {
        this.tabPane.removeTabClosableListener(l);
    }

    public void setImage(Image img) {
        this.tabPane.setImage(img);
    }

    public Image getImage() {
        return this.tabPane.getImage();
    }

    public void setBitmapWidth(int w) {
        this.tabPane.setBitmapWidth(w);
    }

    public int getBitmapWidth() {
        return this.tabPane.getBitmapWidth();
    }

    public int addTab(RemoteTab rt, String label, int insertionIndex, JTabbedPane jtp, int tabw, int tabh) {
        int Return2 = -1;
        MyPanel mp = null;
        mp = insertionIndex >= 0 && insertionIndex < this.tabPane.getTabCount() ? new MyPanel(insertionIndex) : new MyPanel(this.tabPane.getTabCount());
        if (!this.istabbuttons) {
            mp.setBorder(BorderFactory.createEtchedBorder(1));
        }
        Return2 = this.tabPane.addTab(label, insertionIndex, mp, jtp);
        if (this.istabclosebutton) {
            if (insertionIndex >= 0) {
                jtp.setTabComponentAt(insertionIndex, new TabClosableComponent(jtp, this.textnorotate, this.imagemouseentered, this.imagemouseexited));
            } else {
                jtp.setTabComponentAt(jtp.getTabCount() - 1, new TabClosableComponent(jtp, this.textnorotate, this.imagemouseentered, this.imagemouseexited));
            }
        }
        return Return2;
    }

    public int myremoveTabAt(int idx) {
        MyPanel mp = (MyPanel)this.tabPane.getComponentAt(idx);
        this.tabPane.removeTabAt(idx);
        return mp.getPosition();
    }

    @Override
    public void setFont(Font f) {
        if (this.tabPane != null) {
            this.tabPane.setFont(f);
        } else {
            super.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        if (this.tabPane == null) {
            return super.getFont();
        }
        return this.tabPane.getFont();
    }

    public int getSelectedIndex() {
        return this.tabPane.getSelectedIndex();
    }

    public void setBitmapNumberAt(int idx, int bn) {
        this.tabPane.setBitmapNumberAt(idx, bn);
    }

    public void setIconAt(int idx, ImageIcon newIcon) {
        this.tabPane.setIconAt(idx, newIcon);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabPane;
    }

    public String mygetTitleAt(int idx) {
        return this.tabPane.mygetTitleAt(idx);
    }

    public void setEnabledAt(int idx, boolean en) {
        this.tabPane.setEnabledAt(idx, en);
    }

    public boolean isEnabledAt(int idx) {
        return this.tabPane.isEnabledAt(idx);
    }

    public void mysetTitleAt(int idx, String title, JTabbedPane jtp) {
        this.tabPane.mysetTitleAt(idx, title, jtp);
    }

    public int getTabCount() {
        return this.tabPane.getTabCount();
    }

    @Override
    public void setBackground(Color bg) {
        if (this.tabPane == null) {
            super.setBackground(bg);
        } else {
            super.setBackground(bg);
            this.tabPane.setBackground(bg);
            for (int i = 0; i < this.getTabCount(); ++i) {
                this.tabPane.getComponentAt(i).setBackground(bg);
            }
            this.borderedPane.setBackground(bg);
        }
    }

    @Override
    public Color getBackground() {
        if (this.tabPane == null) {
            return super.getBackground();
        }
        return this.tabPane.getBackground();
    }

    @Override
    public void setForeground(Color fg) {
        if (this.tabPane == null) {
            super.setForeground(fg);
        } else {
            this.tabPane.setForeground(fg);
            for (int i = 0; i < this.getTabCount(); ++i) {
                this.tabPane.getComponentAt(i).setForeground(fg);
            }
        }
    }

    @Override
    public Color getForeground() {
        if (this.tabPane == null) {
            return super.getForeground();
        }
        return this.tabPane.getForeground();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.tabPane.setEnabled(b);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.tabPane.setVisible(b);
        this.borderedPane.setVisible(b);
    }

    public void setTabPlacement(int tp) {
        this.tabPane.setTabPlacement(tp);
        this.removeAll();
        switch (tp) {
            case 1: {
                this.add((Component)this.tabPane, "North");
                break;
            }
            case 3: {
                this.add((Component)this.tabPane, "South");
                break;
            }
            case 2: {
                this.add((Component)this.tabPane, "West");
                break;
            }
            case 4: {
                this.add((Component)this.tabPane, "East");
            }
        }
        this.add((Component)this.borderedPane, "Center");
    }

    public void removeAllTabs() {
        this.tabPane.removeAll();
    }

    public void setMnemonicAt(int idx, int c) {
        this.tabPane.setMnemonicAt(idx, c);
    }

    public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex) {
        this.tabPane.setDisplayedMnemonicIndexAt(tabIndex, mnemonicIndex);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.tabPane != null) {
            this.tabPane.addMouseListener(l);
        } else {
            super.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.tabPane != null) {
            this.tabPane.removeMouseListener(l);
        } else {
            super.removeMouseListener(l);
        }
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        this.tabPane.addKeyListener(kl);
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        this.tabPane.removeKeyListener(kl);
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        if (this.tabPane == null) {
            super.addFocusListener(fl);
        } else {
            this.tabPane.addFocusListener(fl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        this.tabPane.removeFocusListener(fl);
    }

    @Override
    public void requestFocus() {
        this.tabPane.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tabPane.requestFocusInWindow();
    }

    @Override
    public void setFocusable(boolean f) {
        this.tabPane.setFocusable(f);
    }

    public void selectIndex(int idx) {
        this.tabPane.selectIndex(idx);
    }

    public Rectangle getButtonsBounds() {
        Rectangle r = this.getBounds();
        r.height = this.tabPane.getButtonsHeight();
        return r;
    }

    public JTabbedPane getJTabbedPane() {
        return this.tabPane;
    }

    public Integer getPosition(Integer idx) {
        for (int i = 0; i < this.tabPane.getTabCount() && this.tabPane.getComponentAt(i) != null; ++i) {
            if (idx.intValue() != ((MyPanel)this.tabPane.getComponentAt(i)).getPosition()) continue;
            return new Integer(i);
        }
        return new Integer(-1);
    }

    public void setTextNoRotate(boolean tnr) {
        this.textnorotate = tnr;
        this.tabPane.setTextNoRotate(tnr);
    }

    @Override
    public void setToolTipText(String text) {
        this.tabPane.setToolTipText(text);
        this.borderedPane.setToolTipText(text);
    }

    public ImageIcon toGray(Icon icon) {
        return this.tabPane.toGray(icon);
    }

    public void destroy() {
    }

    public void mydoLayout() {
        this.tabPane.mydoLayout();
    }

    public void add(RemoteBaseGUIControl rbgc, int index, int tabindex, Hashtable childGraphics) {
    }

    public boolean modifypanels() {
        return false;
    }

    public void setActiveAccept(boolean b) {
        this.tabPane.setActiveAccept(b);
    }

    @Override
    public void setName(String s) {
        if (this.tabPane != null) {
            this.tabPane.setName(s);
        }
    }

    public void setTabBackgroundColor(Color c) {
        this.tabbg = c;
        if (this.tabPane != null) {
            this.tabPane.setTabBackgroundColor(c);
        }
    }

    public void setTabForegroundColor(Color c) {
        this.tabfg = c;
        if (this.tabPane != null) {
            this.tabPane.setTabForegroundColor(c);
        }
    }

    public void setActiveTabBackgroundColor(Color c) {
        this.activetabbg = c;
        if (this.tabPane != null) {
            this.tabPane.setActiveTabBackgroundColor(c);
        }
    }

    public void setActiveTabForegroundColor(Color c) {
        this.activetabfg = c;
        if (this.tabPane != null) {
            this.tabPane.setActiveTabForegroundColor(c);
        }
    }

    public void setBorderWidth(int[] bw) {
        this.borderwidth = bw;
        if (this.tabPane != null) {
            this.tabPane.setBorderWidth(bw);
        }
    }

    public void setActiveBorderWidth(int[] bw) {
        this.activeborderwidth = bw;
        if (this.tabPane != null) {
            this.tabPane.setActiveBorderWidth(bw);
        }
    }

    public void setBorderForegroundColor(Color c) {
        this.tabborderforegroundcolor = c;
        if (this.tabPane != null) {
            this.tabPane.setBorderForegroundColor(this.tabborderforegroundcolor);
        }
    }

    public void setActiveBorderForegroundColor(Color c) {
        this.activetabborderforegroundcolor = c;
        if (this.tabPane != null) {
            this.tabPane.setActiveBorderForegroundColor(this.activetabborderforegroundcolor);
        }
    }

    public void addTabWidths(int insertionIndex, int fontw, int fonth, Integer w) {
        if (this.tabPane != null) {
            this.tabPane.addTabWidths(insertionIndex, fontw, fonth, w);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.tabPane != null) {
            this.tabPane.setSize(w, h);
        }
    }

    public void setImageMouseEntered(Image me) {
        this.imagemouseentered = me;
    }

    public void setImageMouseExited(Image me) {
        this.imagemouseexited = me;
    }

    private class MyPanel
    extends JPanel {
        int position;

        public MyPanel(int p) {
            this.position = p;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension Return2 = new Dimension();
            switch (Tab.this.tabPane.getTabPlacement()) {
                case 1: 
                case 3: {
                    Return2.height = 1;
                    Return2.width = ((Tab)Tab.this).tabPane.getSize().width;
                    break;
                }
                case 2: 
                case 4: {
                    Return2.width = 1;
                    Return2.height = ((Tab)Tab.this).tabPane.getSize().height;
                }
            }
            return Return2;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

