/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.rts.Config;
import com.iscobol.rts.ErrorBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SwingErrorBox
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static int defaultFontSize = 12;
    private static int MIN_BUTTON_WIDTH = 77;
    private String trace;
    private boolean showDetails;
    private boolean nullIcon;
    private Color cBack;
    private Color cFore;
    private Integer configBcolor;
    private Integer configFcolor;
    private String configFont;
    private Hashtable attrs;
    private LocalFontCmp font;
    private GuiFactoryImpl gf;
    private int timeout;

    public SwingErrorBox(GuiFactoryImpl gf, String msg, String trace) {
        this.initialize(gf, msg, trace);
    }

    public SwingErrorBox(GuiFactoryImpl gf, String msg, String trace, Frame owner) {
        super(owner);
        this.nullIcon = true;
        this.initialize(gf, msg, trace);
    }

    public SwingErrorBox(GuiFactoryImpl gf, String msg, String trace, Dialog owner) {
        super(owner);
        this.nullIcon = true;
        this.initialize(gf, msg, trace);
    }

    private SwingErrorBox(String msg, String trace, String title, String imageName, Frame owner) {
        super(owner);
        this.initialize(null, msg, trace, title, imageName);
    }

    private SwingErrorBox(String msg, String trace, String title, String imageName, Dialog owner) {
        super(owner);
        this.initialize(null, msg, trace, title, imageName);
    }

    private SwingErrorBox(String msg, String trace, String title, String imageName) {
        this.initialize(null, msg, trace, title, imageName);
    }

    private void initialize(GuiFactoryImpl gf, String msg, String trace) {
        this.initialize(gf, msg, trace, "Exception caught!", "Error.gif");
    }

    private void initialize(GuiFactoryImpl gf, String msg, String trace, String title, String imageName) {
        boolean multilines;
        this.trace = trace;
        this.gf = gf;
        int backidx = -1;
        int foreidx = -1;
        Font fontset = null;
        if (this.getOwner() instanceof Frame && !this.nullIcon) {
            ((Frame)this.getOwner()).setIconImage(SwingErrorBox.createImage("iscobol.png"));
        }
        title = title != null ? ScreenUtility.rightTrim(title) : gf.getMessages().getMessage("Error");
        this.setTitle(title);
        String newline = System.getProperty("line.separator");
        boolean bl = multilines = msg != null && msg.indexOf(newline) > 0;
        if (newline.length() == 2 && !multilines) {
            multilines = msg != null && msg.indexOf(10) > 0;
        }
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                SwingErrorBox swingErrorBox = SwingErrorBox.this;
                synchronized (swingErrorBox) {
                    SwingErrorBox.this.notify();
                }
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                SwingErrorBox.this.dispose();
            }
        });
        try {
            this.configFont = gf.getCsProperty().get("iscobol.gui.messagebox.font", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.configFont != null && this.font != null) {
            this.font = this.myGetFont(this.configFont, this.font.getFont().getName(), this.font.getFont().getStyle(), this.font.getFont().getSize());
        }
        fontset = this.font == null ? this.getFont() : this.font.getFont();
        JLabel lbl = new JLabel(msg);
        if (fontset == null) {
            fontset = lbl.getFont();
        }
        if (fontset != null && fontset.getSize() < defaultFontSize) {
            fontset = new Font(fontset.getFamily(), fontset.getStyle(), defaultFontSize);
        }
        if (multilines) {
            lbl.setAlignmentY(0.0f);
        } else {
            lbl.setAlignmentY(0.5f);
        }
        lbl.setAlignmentX(0.0f);
        ImageIcon icon = imageName != null ? new ImageIcon(SwingErrorBox.createImage(imageName)) : null;
        JPanel messagePanel = new JPanel();
        messagePanel.setAlignmentX(0.0f);
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        JLabel lblicon = null;
        if (icon != null) {
            lblicon = new JLabel();
            if (multilines) {
                lblicon.setAlignmentY(0.0f);
            } else {
                lblicon.setAlignmentY(0.5f);
            }
            lblicon.setAlignmentX(0.0f);
            lblicon.setIcon(icon);
            messagePanel.add(lblicon);
            messagePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        messagePanel.add(lbl);
        JTextArea t = new JTextArea(trace);
        t.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        t.setEditable(false);
        JScrollPane sp = new JScrollPane(t, 22, 32);
        t.setAlignmentX(0.0f);
        sp.setAlignmentX(0.0f);
        JPanel messageLabelPanel = new JPanel();
        messageLabelPanel.setLayout(new BoxLayout(messageLabelPanel, 1));
        messageLabelPanel.setBorder(BorderFactory.createEmptyBorder(20, 23, 16, 23));
        messageLabelPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        messageLabelPanel.add(messagePanel);
        messageLabelPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        messageLabelPanel.add(sp);
        sp.setVisible(false);
        JPanel pb = new JPanel();
        pb.setLayout(new BoxLayout(pb, 0));
        pb.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 7));
        pb.add(Box.createHorizontalGlue());
        pb.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton p = new JButton(">>");
        p.addActionListener(e -> {
            if (this.showDetails) {
                p.setText(">>");
                this.showDetails = false;
                sp.setVisible(false);
                this.pack();
            } else {
                p.setText("<<");
                this.showDetails = true;
                sp.setVisible(true);
                this.pack();
            }
            Dimension d = this.getSize();
            Dimension screen = this.getToolkit().getScreenSize();
            int x = (screen.width - d.width) / 2;
            int y = (screen.height - d.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
        });
        pb.add(p);
        pb.add(Box.createRigidArea(new Dimension(7, 0)));
        JButton b = new JButton("OK");
        b.addActionListener(e -> this.dispose());
        pb.add(b);
        pb.add(Box.createRigidArea(new Dimension(7, 0)));
        this.getContentPane().add("Center", messageLabelPanel);
        this.getContentPane().add("South", pb);
        if (fontset != null) {
            Insets is;
            int w;
            FontMetrics fm;
            lbl.setFont(fontset);
            if (p != null) {
                p.setFont(fontset);
                fm = p.getFontMetrics(p.getFont());
                w = fm.stringWidth(p.getText());
                is = p.getInsets();
                if (is != null) {
                    w += is.left + is.right;
                }
                if (w < MIN_BUTTON_WIDTH) {
                    p.setMinimumSize(new Dimension(MIN_BUTTON_WIDTH, p.getMinimumSize().height));
                    p.setPreferredSize(new Dimension(MIN_BUTTON_WIDTH, p.getPreferredSize().height));
                }
            }
            if (b != null) {
                b.setFont(fontset);
                fm = b.getFontMetrics(b.getFont());
                w = fm.stringWidth(b.getText());
                is = b.getInsets();
                if (is != null) {
                    w += is.left + is.right;
                }
                if (w < MIN_BUTTON_WIDTH) {
                    b.setMinimumSize(new Dimension(MIN_BUTTON_WIDTH, b.getMinimumSize().height));
                    b.setPreferredSize(new Dimension(MIN_BUTTON_WIDTH, b.getPreferredSize().height));
                }
            }
        }
        if (backidx == -1) {
            try {
                this.configBcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.messagebox.bcolor", null));
            }
            catch (Exception fm) {
                // empty catch block
            }
            if (this.configBcolor != null) {
                backidx = this.configBcolor;
            }
        }
        if (backidx != -1) {
            this.cBack = gf.getRemotePalette().getDefaultColor(backidx);
        }
        if (foreidx == -1) {
            try {
                this.configFcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.messagebox.fcolor", null));
            }
            catch (Exception fm) {
                // empty catch block
            }
            if (this.configFcolor != null) {
                foreidx = this.configFcolor;
            }
        }
        if (foreidx != -1) {
            this.cFore = gf.getRemotePalette().getDefaultColor(foreidx);
        }
        if (this.cBack != null) {
            this.getContentPane().setBackground(this.cBack);
            messagePanel.setBackground(this.cBack);
            messageLabelPanel.setBackground(this.cBack);
            pb.setBackground(this.cBack);
            if (p != null) {
                p.setBackground(this.cBack);
            }
            if (b != null) {
                b.setBackground(this.cBack);
            }
        } else {
            this.getContentPane().setBackground(Color.white);
            messagePanel.setBackground(Color.white);
            messageLabelPanel.setBackground(Color.white);
        }
        if (this.cFore != null) {
            this.getContentPane().setForeground(this.cFore);
            messagePanel.setForeground(this.cFore);
            messageLabelPanel.setForeground(this.cFore);
            pb.setForeground(this.cFore);
            lbl.setForeground(this.cFore);
            if (p != null) {
                p.setForeground(this.cFore);
            }
            if (b != null) {
                b.setForeground(this.cFore);
            }
        }
        this.rootPane.setDefaultButton(b);
        this.pack();
        b.setSize(b.getPreferredSize());
        b.requestFocusInWindow();
        Dimension d = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        int x = (screen.width - d.width) / 2;
        int y = (screen.height - d.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            KeyboardBuffer.enable(null);
            SwingErrorBox swingErrorBox = this;
            synchronized (swingErrorBox) {
                try {
                    this.wait(this.timeout);
                }
                catch (InterruptedException _e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isDisplayable()) {
                this.dispose();
            }
            System.out.println(this.trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void optionPaneMessage(String title, String msg) {
        int timeout = Config.getProperty("iscobol.display_message_timeout", 0);
        KeyboardBuffer.enable(null);
        try {
            if (timeout > 0) {
                JOptionPane pane = new JOptionPane(msg, 0);
                JDialog dialog = pane.createDialog(title);
                boolean[] lock = new boolean[1];
                new Thread(() -> {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    boolean[] blArray = lock;
                    synchronized (lock) {
                        if (!lock[0]) {
                            try {
                                lock.wait(timeout);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        if (dialog.isDisplayable()) {
                            dialog.dispose();
                        }
                        return;
                    }
                }).start();
                dialog.setVisible(true);
                boolean[] blArray = lock;
                synchronized (lock) {
                    lock[0] = true;
                    lock.notify();
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return;
                }
            }
            JOptionPane.showMessageDialog(null, msg, title, 0);
            return;
        }
        catch (Throwable e) {
            System.err.println(SwingErrorBox.buildMessage(title, msg));
        }
    }

    public static void message(String shMsg, Exception ex) {
        SwingErrorBox.message(shMsg, (Throwable)ex);
    }

    public static void message(String shMsg, Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        SwingErrorBox.message(shMsg, sw.toString(), false);
    }

    public static void message(String shMsg, String lnMsg, boolean info) {
        SwingErrorBox.message(shMsg, lnMsg, info ? "Information" : "Exception caught!", info ? "Inform.gif" : "Error.gif");
    }

    public static void message(String shMsg, String lnMsg, String title, String imageName) {
        SwingErrorBox.message(shMsg, lnMsg, title, imageName, Config.getProperty(".display_message", 0), Config.getProperty(".display_message_timeout", 0));
    }

    public static void message(String shMsg, String lnMsg, String title, String imageName, int dispMessage) {
        SwingErrorBox.message(shMsg, lnMsg, title, imageName, dispMessage, Config.getProperty(".display_message_timeout", 0));
    }

    private static void message(String shMsg, String lnMsg, String title, String imageName, int dispMessage, int dispMessageTmt) {
        if (!SwingErrorBox.printMessage(shMsg, lnMsg, dispMessage)) {
            try {
                Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                Container focusedWindow = null;
                if (permanentFocusOwner != null) {
                    for (Container cnt = permanentFocusOwner.getParent(); cnt != null; cnt = cnt.getParent()) {
                        if (!(cnt instanceof Window)) continue;
                        focusedWindow = cnt;
                        break;
                    }
                }
                SwingErrorBox seb = focusedWindow instanceof Frame ? new SwingErrorBox(shMsg, lnMsg, title, imageName, (Frame)focusedWindow) : (focusedWindow instanceof Dialog ? new SwingErrorBox(shMsg, lnMsg, title, imageName, (Dialog)focusedWindow) : new SwingErrorBox(shMsg, lnMsg, title, imageName));
                seb.timeout = dispMessageTmt;
                seb.setVisible(true);
            }
            catch (Throwable _ex) {
                System.err.print(SwingErrorBox.buildMessage(shMsg, lnMsg));
            }
        }
    }

    public static boolean printMessage(String shMsg, String lnMsg) {
        return SwingErrorBox.printMessage(shMsg, lnMsg, Config.getProperty(".display_message", 0));
    }

    private static boolean printMessage(String shMsg, String lnMsg, int dispMessage) {
        switch (dispMessage) {
            default: {
                return false;
            }
            case 1: {
                System.out.print(SwingErrorBox.buildMessage(shMsg, lnMsg));
                break;
            }
            case 2: {
                System.err.print(SwingErrorBox.buildMessage(shMsg, lnMsg));
                break;
            }
            case 3: {
                ErrorBox.dumpfile("", SwingErrorBox.buildMessage(shMsg, lnMsg));
            }
        }
        return true;
    }

    public static String buildMessage(String shMsg, String lnMsg) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (shMsg != null) {
            String dashes = "";
            for (int i = shMsg.length(); i >= 0; --i) {
                dashes = dashes + '-';
            }
            pw.println(shMsg);
            pw.println(dashes);
        }
        if (lnMsg != null) {
            pw.println(lnMsg);
        }
        pw.close();
        return sw.toString();
    }

    private static Image createImage(String name) {
        return Toolkit.getDefaultToolkit().createImage(SwingErrorBox.class.getResource(name));
    }

    private SwingFontCmp callFontCmp(String name, int style, float size) {
        SwingFontCmp sfc;
        SwingFontCmp Return2 = null;
        this.attrs = new Hashtable();
        this.attrs.put(FontAttribute.FAMILY, name);
        this.attrs.put(FontAttribute.SIZE, new Float(size));
        if ((style & 1) != 0) {
            this.attrs.put(FontAttribute.WEIGHT, FontAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) != 0) {
            this.attrs.put(FontAttribute.POSTURE, FontAttribute.POSTURE_OBLIQUE);
        }
        if ((sfc = new SwingFontCmp(this.gf, this.attrs, false)).getFont() != null) {
            Return2 = sfc;
        }
        return Return2;
    }

    private SwingFontCmp myGetFont(String str, String nm, int st, float sz) {
        String fontName = nm;
        float fontSize = sz;
        int fontStyle = st;
        if (str != null) {
            fontName = str;
            fontSize = defaultFontSize;
            fontStyle = 0;
            int i = str.indexOf(45);
            if (i >= 0) {
                fontName = str.substring(0, i);
                if (i < str.length()) {
                    if ((str = str.substring(i + 1).toLowerCase()).startsWith("bolditalic")) {
                        fontStyle = 3;
                        if (str.length() > 11) {
                            str = str.substring(11);
                        }
                    } else if (str.startsWith("bold")) {
                        fontStyle = 1;
                        if (str.length() > 5) {
                            str = str.substring(5);
                        }
                    } else if (str.startsWith("italic")) {
                        fontStyle = 2;
                        if (str.length() > 7) {
                            str = str.substring(7);
                        }
                    }
                    if (str.length() > 0) {
                        try {
                            fontSize = Float.valueOf(str).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (fontSize == 0.0f) {
                        fontSize = defaultFontSize;
                    }
                }
            }
        }
        return this.callFontCmp(fontName, fontStyle, fontSize);
    }

    public void setTimeout(int to) {
        this.timeout = to;
    }
}

