/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteScrollPaneOrig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ScrollPaneOrig
extends JPanel {
    private JPanel panel;
    private MyScrollPane scrollpane;
    private int scw;
    private int sch;
    private int w;
    private int h;
    private RemoteScrollPaneOrig parentRbgc;
    private boolean transparent;

    public ScrollPaneOrig(boolean relativeoffset, String layoutType, String layoutDefaults, RemoteScrollPaneOrig p) {
        this.parentRbgc = p;
        this.panel = new JPanel();
        this.panel.setLayout(null);
        this.scrollpane = new MyScrollPane(this.panel, 20, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        super.setFocusable(false);
        this.scrollpane.setBorder(null);
        this.panel.setBorder(null);
        this.parentRbgc.gradientMgr.addPropertyChangeListener(e -> {
            this.setOpaque();
            this.scrollpane.getViewport().repaint();
        });
        AdjustmentListener adjl = adjustmentEvent -> {
            this.panel.repaint();
            this.scrollpane.repaint();
            this.repaint();
        };
        this.scrollpane.getVerticalScrollBar().addAdjustmentListener(adjl);
        this.scrollpane.getHorizontalScrollBar().addAdjustmentListener(adjl);
        this.setOpaque();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        float percentualew = ((float)w - (float)this.scw) / (float)this.scw * 100.0f;
        float percentualeh = ((float)h - (float)this.sch) / (float)this.sch * 100.0f;
        Rectangle d = this.panel.getBounds();
        if (this.scw == 0) {
            this.scw = w;
        }
        if (this.sch == 0) {
            this.sch = h;
        }
        super.setBounds(x, y, w, h);
        if (this.scrollpane != null) {
            this.scrollpane.setBounds(0, 0, w, h);
        }
        if (this.panel != null) {
            float wnew = (float)this.w + (float)this.w * percentualew / 100.0f;
            float hnew = (float)this.h + (float)this.h * percentualeh / 100.0f;
            this.panel.setPreferredSize(new Dimension((int)wnew, (int)hnew));
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.panel != null) {
            this.panel.setBackground(bg);
        }
    }

    @Override
    public Color getBackground() {
        if (this.panel == null) {
            return super.getBackground();
        }
        return this.panel.getBackground();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.panel != null) {
            this.panel.setForeground(fg);
        }
    }

    @Override
    public Color getForeground() {
        if (this.panel == null) {
            return super.getForeground();
        }
        return this.panel.getForeground();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.panel != null) {
            this.panel.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        if (this.panel == null) {
            return super.getFont();
        }
        return this.panel.getFont();
    }

    @Override
    public void setEnabled(boolean e) {
        if (this.panel != null) {
            Component[] components = this.panel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i].setEnabled(e);
            }
            this.panel.setEnabled(e);
        }
        if (this.scrollpane != null) {
            JScrollBar hs;
            this.scrollpane.setEnabled(e);
            JScrollBar vs = this.scrollpane.getVerticalScrollBar();
            if (vs != null) {
                vs.setEnabled(e);
            }
            if ((hs = this.scrollpane.getHorizontalScrollBar()) != null) {
                hs.setEnabled(e);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.panel == null) {
            return super.isEnabled();
        }
        return this.panel.isEnabled();
    }

    @Override
    public void setOpaque(boolean op) {
        super.setOpaque(op);
        if (this.scrollpane != null) {
            this.scrollpane.setOpaque(op);
            this.scrollpane.getViewport().setOpaque(op);
        }
        if (this.panel != null) {
            this.panel.setOpaque(op);
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.setOpaque();
    }

    private void setOpaque() {
        this.setOpaque(!this.transparent && !this.parentRbgc.gradientMgr.isPaintGradient());
    }

    public void destroy(Hashtable childGraphics) {
        super.removeAll();
        if (this.panel != null) {
            this.panel.removeAll();
        }
    }

    @Override
    public void setFocusable(boolean b) {
        if (this.panel == null) {
            super.setFocusable(b);
        } else {
            this.panel.setFocusable(b);
        }
    }

    @Override
    public void requestFocus() {
        if (this.panel == null) {
            super.requestFocus();
        } else {
            this.panel.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.panel == null) {
            return super.requestFocusInWindow();
        }
        return this.panel.requestFocusInWindow();
    }

    @Override
    public void setToolTipText(String tt) {
        if (this.panel != null) {
            this.panel.setToolTipText(tt);
        }
    }

    protected void resetLayoutManager() {
        LayoutManager lm = this.getLayout();
        if (lm instanceof IscobolLayout) {
            ((IscobolLayout)lm).setOriginalContainerSize(null);
        }
    }

    public Point convertXY(String name, Point pc, Rectangle origBoundsLayout) {
        Point p = this.getLocation();
        if (origBoundsLayout != null) {
            p = new Point(origBoundsLayout.x, origBoundsLayout.y);
        }
        pc.y -= p.y;
        pc.x -= p.x;
        pc.y += 5;
        return pc;
    }

    public void add(RemoteBaseGUIControl rbgc, int index, Hashtable childGraphics) {
        LayoutManager lm = null;
        Component c = (Component)((Object)rbgc.getComponent());
        RemoteBaseGUIControl crbgc = null;
        Component[] controls = this.panel.getComponents();
        for (index = 0; index < controls.length; ++index) {
            if (controls[index] == rbgc.getComponent()) {
                return;
            }
            crbgc = (RemoteBaseGUIControl)childGraphics.get(controls[index]);
            if (RemoteDisplayWindow.shouldInsertBefore(rbgc, crbgc)) break;
        }
        Point pc = c.getLocation();
        Dimension dc = c.getSize();
        if (pc.x + dc.width > this.w || pc.y + dc.height > this.h) {
            if (pc.x + dc.width > this.w) {
                this.w = pc.x + dc.width;
            }
            if (pc.y + dc.height > this.h) {
                this.h = pc.y + dc.height;
            }
            this.panel.setPreferredSize(new Dimension(this.w, this.h));
        }
        this.panel.add(c, index);
        if (rbgc.getParentWindow() != null && (lm = this.panel.getLayout()) instanceof IscobolLayout) {
            rbgc.getParentWindow().addtolayout(rbgc, lm);
        }
        if (rbgc != null && !this.isEnabled()) {
            rbgc.setEnabled(false);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void scrollRectToVisible(Rectangle rec) {
        if (this.panel != null) {
            this.panel.scrollRectToVisible(rec);
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (this.scrollpane != null) {
            this.scrollpane.addMouseListener(ml);
        } else {
            super.addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        if (this.scrollpane != null) {
            this.scrollpane.removeMouseListener(ml);
        } else {
            super.removeMouseListener(ml);
        }
    }

    private class MyScrollPane
    extends JScrollPane {
        MyScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
            super(view, vsbPolicy, hsbPolicy);
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public void paintComponent(Graphics g) {
                    if (((ScrollPaneOrig)ScrollPaneOrig.this).parentRbgc.gradientMgr.isPaintGradient()) {
                        JScrollBar hs;
                        Dimension d = this.getSize();
                        JScrollBar vs = MyScrollPane.this.getVerticalScrollBar();
                        if (vs.isVisible()) {
                            d.width += vs.getSize().width;
                        }
                        if ((hs = MyScrollPane.this.getHorizontalScrollBar()).isVisible()) {
                            d.height += hs.getSize().height;
                        }
                        ((ScrollPaneOrig)ScrollPaneOrig.this).parentRbgc.gradientMgr.paint((Graphics2D)g, new Rectangle(new Point(0, 0), d));
                    }
                    super.paintComponent(g);
                }
            };
        }
    }
}

