/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.TerminalModel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class RemoteTerminalDisplay
extends RemoteBaseGUIControl {
    protected boolean isNumeric;
    protected boolean isUnderline;
    protected boolean isBlink;
    protected boolean isBold;
    private boolean isAll;
    protected Justification just = Justification.None;
    private boolean graphics;
    private String value;
    protected int linet = -1;
    protected int colt = -1;
    protected int lent = -1;
    private static final String HLINE = new String(new char[]{'\u0003'});
    private static final String VLINE = new String(new char[]{'\f'});
    private static final String ULCORNER = new String(new char[]{'\u0006'});
    private static final String URCORNER = new String(new char[]{'\u0005'});
    private static final String LLCORNER = new String(new char[]{'\n'});
    private static final String LRCORNER = new String(new char[]{'\t'});
    private static final String BTEE = new String(new char[]{'\u000b'});
    private static final String TTEE = new String(new char[]{'\u0007'});
    private static final String LTEE = new String(new char[]{'\u000e'});
    private static final String RTEE = new String(new char[]{'\r'});
    private static final String PLUS = new String(new char[]{'\u000f'});

    public RemoteTerminalDisplay(GuiFactoryImpl gf) {
        super(gf);
        this.temporary = true;
    }

    @Override
    public void initialize() {
        if (this.getComponent() == null) {
            this.setComponent(new MyComponent());
        }
        this.intInitialize();
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public void displayProp() {
    }

    @Override
    public int getGUIControlHeight(float height) {
        return 1;
    }

    @Override
    public int getGUIControlWidth(float width) {
        return (int)width;
    }

    @Override
    public float getDefaultWidth() {
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 0.0f;
    }

    @Override
    public String getTitle() {
        return this.getValue();
    }

    private static String justRight(String v, int mlen) {
        StringBuffer Return2 = new StringBuffer();
        String value = "";
        if (v != null) {
            value = v.trim();
        }
        for (int vlen = value.length(); vlen < mlen; ++vlen) {
            Return2.append(' ');
        }
        Return2.append(value);
        return Return2.toString();
    }

    private String justCentered(String v, int mlen) {
        StringBuffer Return2 = new StringBuffer();
        String value = "";
        if (v != null) {
            value = v.trim();
        }
        mlen /= 2;
        for (int vlen = value.length() / 2; vlen < mlen; ++vlen) {
            Return2.append(' ');
        }
        Return2.append(value);
        return Return2.toString();
    }

    private static String fillAll(String v, int mlen) {
        StringBuffer Return2 = new StringBuffer();
        if (v != null) {
            do {
                Return2.append(v);
            } while (Return2.length() < mlen);
        }
        Return2.setLength(mlen);
        return Return2.toString();
    }

    @Override
    public String getValue() {
        if (this.isAll) {
            this.value = RemoteTerminalDisplay.fillAll(this.value, this.getLength());
            this.isAll = false;
        }
        return this.value;
    }

    @Override
    public void setTitle(String t) {
        this.setValue(t);
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public String setValue(String v) {
        this.value = v;
        return null;
    }

    @Override
    public void setRowsCols(float rows, float cols) {
    }

    @Override
    public void setRows(float rows) {
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    private static void displayGraphics(RemoteDisplayWindow rdw, int col, int line, String val, int len, Color fore, int attr, Color back, Justification j) {
        len = Math.min(len, val.length());
        for (int i = 0; i < len; ++i) {
            int grattr = 0x20000000;
            String ch = val.substring(i, i + 1);
            switch (ch.charAt(0)) {
                case 'J': 
                case 'j': {
                    ch = LRCORNER;
                    break;
                }
                case 'K': 
                case 'k': {
                    ch = URCORNER;
                    break;
                }
                case 'L': 
                case 'l': {
                    ch = ULCORNER;
                    break;
                }
                case 'M': 
                case 'm': {
                    ch = LLCORNER;
                    break;
                }
                case 'N': 
                case 'n': {
                    ch = PLUS;
                    break;
                }
                case 'Q': 
                case 'q': {
                    ch = HLINE;
                    break;
                }
                case 'T': 
                case 't': {
                    ch = LTEE;
                    break;
                }
                case 'U': 
                case 'u': {
                    ch = RTEE;
                    break;
                }
                case 'V': 
                case 'v': {
                    ch = BTEE;
                    break;
                }
                case 'W': 
                case 'w': {
                    ch = TTEE;
                    break;
                }
                case 'X': 
                case 'x': {
                    ch = VLINE;
                    break;
                }
                default: {
                    grattr = 0;
                }
            }
            Rectangle repArea = rdw.mainWindow.display(col + i, line, ch, 1, fore, attr + grattr, back, j);
            rdw.setDoRepaint(repArea);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            int attr;
            RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
            String val = this.getNoecho() ? "" : this.getValue();
            int n = attr = this.isUnderline ? 0x2000000 : 0;
            if (this.beep) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.graphics) {
                RemoteTerminalDisplay.displayGraphics(rdw, this.getColumn(), this.getLine(), val, this.getLength(), this.getColorForeground(), attr, this.getColorBackground(), this.just);
            } else if (this.getLength() > 0 || val != null && val.length() > 0) {
                Rectangle repArea = rdw.mainWindow.display(this.getColumn(), this.getLine(), val, this.getLength(), this.getColorForeground(), attr, this.getColorBackground(), this.just, this.isNational);
                rdw.setDoRepaint(repArea);
            }
        }
    }

    @Override
    public void setStyle(int s, boolean set) {
        if ((s & 0x100) == 256) {
            this.setIsNumeric(set);
        }
        if ((s & 0x1000) == 4096) {
            this.setUnderline(set);
        }
        if ((s & 8) == 8) {
            this.setBlink(set);
        }
        if ((s & 0x80000) == 524288) {
            this.setAll(set);
        }
        if ((s & 0x80) == 128) {
            this.setNoecho(set);
        }
        if ((s & 0x400) == 1024) {
            this.setJust(1024);
        }
        if ((s & 0x20) == 32) {
            this.setJust(32);
        }
        if ((s & 0x10) == 16) {
            this.setJust(16);
        }
        if ((s & 2) == 2) {
            this.setBeep(set);
        }
        if ((s & 0x800) == 2048) {
            this.graphics = true;
        }
    }

    public void setIsNumeric(boolean b) {
        this.isNumeric = b;
    }

    @Override
    public void setNoecho(boolean b) {
        super.setNoecho(b);
    }

    public void setUnderline(boolean b) {
        this.isUnderline = b;
    }

    public void setBold(boolean b) {
        this.isBold = b;
    }

    public void setBlink(boolean b) {
        this.isBlink = b;
    }

    public void setAll(boolean b) {
        this.isAll = b;
    }

    public void setJust(int j) {
        switch (j) {
            case 1024: {
                this.just = Justification.Right;
                break;
            }
            case 16: {
                this.just = Justification.Center;
                break;
            }
            case 32: {
                this.just = Justification.Left;
                break;
            }
            default: {
                this.just = Justification.None;
            }
        }
    }

    @Override
    public void focusGained(CobolFocusEvent cfe) {
        super.focusGained(cfe);
    }

    @Override
    public void focusLost(CobolFocusEvent cfe) {
        super.focusLost(cfe);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize ps, int origHeight) {
        return super.paramgetDefaultHeight(ps, origHeight);
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f || !ps.sizesInCells) {
            return ps.sizes;
        }
        if (ps.title != null) {
            int len = ps.title.length();
            if (!this.isNational) {
                try {
                    TerminalModel tm = this.getParentWindow().getMainWindow().getCharTerminal().getTerminalModel();
                    if (tm.isDoubleByteCompat()) {
                        char[] c = ps.title.toCharArray();
                        for (int i = 0; i < c.length; ++i) {
                            if (!tm.dblWidth(c[i])) continue;
                            ++len;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return len;
        }
        if (ps.ccPIClen != -1) {
            return ps.ccPIClen;
        }
        if (ps.ccOlen != -1) {
            return ps.ccOlen;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public Dimension loadDimension0() {
        return null;
    }

    @Override
    public Dimension loadDimension0(Dimension Return2) {
        return null;
    }

    @Override
    protected void clear() {
        super.clear();
        this.isNumeric = false;
        this.isUnderline = false;
        this.isBlink = false;
        this.isBold = false;
        this.isAll = false;
        this.just = Justification.None;
        this.value = null;
        this.graphics = false;
        this.linet = -1;
        this.colt = -1;
        this.lent = -1;
    }

    @Override
    protected String getLayoutData(IscobolLayout l) {
        return null;
    }

    @Override
    public String getType() {
        return "terminaldisplay";
    }

    @Override
    public void setLocation(int xx, int yy, boolean setOnComp) {
        if (this.y != yy) {
            this.linet = -1;
        }
        if (this.x != xx) {
            this.colt = -1;
        }
        super.setLocation(xx, yy, setOnComp);
    }

    @Override
    public void setControlInfo(int info) {
        super.setControlInfo(info);
        this.isNational = (info & 0x800) == 2048;
    }

    @Override
    int getLine() {
        if (this.linet == -1) {
            this.linet = super.getLine();
        }
        return this.linet;
    }

    @Override
    protected int getColumn() {
        if (this.colt == -1) {
            this.colt = super.getColumn();
        }
        return this.colt;
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        if (this.width != w) {
            this.lent = -1;
        }
        super.setSize(w, h, setOnComp);
    }

    @Override
    protected int getLength() {
        if (this.lent == -1) {
            this.lent = super.getLength();
        }
        return this.lent;
    }

    @Override
    public boolean isTerminalEmulation() {
        return true;
    }

    static class MyComponent
    extends Component
    implements PicobolWidget {
        MyComponent() {
        }

        @Override
        public void setActiveAccept(boolean b) {
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public boolean getActiveAccept() {
            return false;
        }

        @Override
        public void setSelfAct(boolean b) {
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void setSize(int w, int h) {
        }

        @Override
        public void setLocation(int x, int y) {
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
        }
    }
}

