/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolButton;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class RemotePushButton
extends RemoteBaseGUIControl
implements Constants {
    public static final int BORDER_SZ_PX = 8;
    public static final int BORDER_LN_PX = 8;
    public static final int DEFAULT_TEXTBUTTON_WIDTH = 8;
    private static final int DEFAULT_ALIGNMENT = 0;
    private boolean noAutoDef;
    private boolean defaultButton;
    private boolean escapeButton;
    private boolean selfAct;
    private boolean flat;
    private boolean transparent;
    private String title;
    private float rows;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapPressed;
    private int bitmapRollover;
    private int bitmapWidth;
    private boolean multiline;
    private int titlePosition;
    private ActionListener al;
    private Image image;
    private int imageId = -1;
    private Dimension scalebitmaptosize;
    private RemoteBaseGUIControl thisonribbonheader;
    private int alignmentH = 0;
    private int alignmentV = 0;
    private boolean bitmapScaleBestQuality;
    private PropertyChangeListener pcListener;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private Color rolloverBorderColor;
    private ColorCmp rolloverBorderColorCmp;
    private int rolloverBorderColorIdx;
    private Integer disabledColor;
    private Integer disabledBackgroundColor;
    private Integer disabledForegroundColor;
    private boolean disabledBackgroundRgb;
    private boolean disabledForegroundRgb;
    private Integer rolloverColor;
    private Integer rolloverBackgroundColor;
    private Integer rolloverForegroundColor;
    private boolean rolloverBackgroundRgb;
    private boolean rolloverForegroundRgb;
    private int transparentColor = -1;
    private int bitmapScale;
    private final boolean m25647;

    public RemotePushButton(GuiFactoryImpl gf) {
        super(gf);
        this.m25647 = gf.getCsProperty().get("iscobol.m25647", false);
        this.bitmapScaleBestQuality = gf.getCsProperty().get("iscobol.bitmap_scale.best_quality", false);
        this.pcListener = evt -> {
            String key;
            if (gf != null && (key = evt.getPropertyName()).equals("iscobol.bitmap_scale.best_quality")) {
                this.bitmapScaleBestQuality = gf.getCsProperty().get("iscobol.bitmap_scale.best_quality", false);
            }
        };
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public void setRowsCols(float r, float c) {
        this.rows = r;
    }

    @Override
    public void setTitle(String t) {
        this.title = t;
        if (this.guiComponent != null && t != null) {
            PicobolButton pb = (PicobolButton)this.guiComponent;
            pb.setTitle(t);
            if (pb.getMnemonicChar() > '\u0000' && this.parentWindow != null) {
                this.parentWindow.removeMnemonic(this);
                this.parentWindow.addMnemonic(pb.getMnemonicChar(), this);
            }
        }
    }

    @Override
    public void setBorder(boolean v) {
    }

    @Override
    public int getGUIControlHeight(float h) {
        int Return2 = 0;
        if (this.bitmapStyle) {
            Return2 = (int)h;
        } else if (this.font != null) {
            Return2 = (int)((float)this.font.getHeight() * h) + 8;
        }
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float w) {
        int Return2 = 0;
        if (this.bitmapStyle) {
            Return2 = (int)w;
        } else if (this.font != null) {
            Return2 = (int)((float)this.font.getWidth() * w) + 8;
        }
        return Return2;
    }

    @Override
    public float getDefaultWidth() {
        if (this.bitmapStyle) {
            return 16.0f;
        }
        return 8.0f;
    }

    @Override
    public float getDefaultHeight() {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return 1.0f;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getValue() {
        return this.title;
    }

    private void setDefaultButton(boolean t) {
        this.defaultButton = t;
        if (t && this.parentWindow != null) {
            this.parentWindow.setDefaultButton(this);
        }
    }

    private void setEscapeButton(boolean t) {
        this.escapeButton = t;
        if (t && this.parentWindow != null) {
            this.parentWindow.setEscapeButton(this);
        }
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolButton pb = (PicobolButton)this.guiComponent;
        if ((s & 4) == 4) {
            if (set && (this.title == null || this.title.length() == 0)) {
                this.setTitle("OK");
            }
            this.setStyle(1, set);
        }
        if ((s & 8) == 8) {
            if (set && (this.title == null || this.title.length() == 0)) {
                this.setTitle("CANCEL");
            }
            this.setStyle(2, set);
        }
        if ((s & 1) == 1) {
            this.setDefaultButton(set);
        }
        if ((s & 2) == 2) {
            this.setEscapeButton(set);
        }
        if ((s & 0x10) == 16) {
            this.noAutoDef = set;
        }
        if ((s & 0x400) == 1024) {
            this.multiline = set;
            if (pb != null) {
                pb.setMultiline(set);
            }
        }
        if ((s & 0x400000) == 0x400000) {
            this.selfAct = set;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(set);
            }
        }
        if ((s & 0x8000) == 32768) {
            this.bitmapStyle = set;
            if (pb != null) {
                pb.setHasBitmap(set);
            }
        }
        if ((s & 0x800000) == 0x800000) {
            this.transparent = set;
            if (pb != null) {
                pb.setTransparent(set);
            }
        }
        if ((s & 0x800) == 2048) {
            this.flat = set;
            if (pb != null) {
                pb.setFlat(set);
            }
        }
        if ((s & 0x10000) == 65536) {
            RemoteBaseGUIControl rbgcupon = null;
            this.onheader = set;
            if (pb != null && (this.uponCtrlsrvid >= 0 || this.tabGroup >= 0) && this.parentWindow != null && ((rbgcupon = this.parentWindow.getBGC(this.uponCtrlsrvid)) != null || (rbgcupon = this.parentWindow.getBGC(this.tabGroup)) != null) && rbgcupon instanceof RemoteTab && ((RemoteTab)rbgcupon).isRibbon()) {
                if (this.onheader) {
                    this.thisonribbonheader = ((RemoteTab)rbgcupon).addOnHeader(this);
                } else if (this.thisonribbonheader != null) {
                    ((RemoteTab)rbgcupon).removeOnHeader(this.thisonribbonheader);
                    this.thisonribbonheader = null;
                }
            }
        }
        if ((s & 0x20000) == 131072 && !this.multiline) {
            this.alignmentH = set ? 0 : 0;
            if (pb != null && !this.multiline) {
                pb.setHorizontalAlignment(this.alignmentH);
            }
        }
        if ((s & 0x40000) == 262144 && !this.multiline) {
            this.alignmentH = set ? 4 : 0;
            if (pb != null && !this.multiline) {
                pb.setHorizontalAlignment(this.alignmentH);
            }
        }
        if ((s & 0x80000) == 524288 && !this.multiline) {
            this.alignmentH = set ? 2 : 0;
            if (pb != null) {
                pb.setHorizontalAlignment(this.alignmentH);
            }
        }
        if ((s & 0x100000) == 0x100000 && !this.multiline) {
            this.alignmentV = set ? 1 : 0;
            if (pb != null) {
                pb.setVerticalAlignment(this.alignmentV);
            }
        }
        if ((s & 0x200000) == 0x200000 && !this.multiline) {
            this.alignmentV = set ? 3 : 0;
            if (pb != null) {
                pb.setVerticalAlignment(this.alignmentV);
            }
        }
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        boolean isrgb = false;
        try {
            intValue = (int)Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        PicobolButton pb = (PicobolButton)this.guiComponent;
        switch (key) {
            case 295: {
                if (error) break;
                this.bitmapScale = intValue;
                if (pb == null) break;
                pb.setBitmapScale(this.bitmapScale);
                break;
            }
            case 242: {
                if (error) break;
                this.transparentColor = intValue;
                if (pb == null) break;
                pb.setTransparentColor(this.transparentColor);
                break;
            }
            case 409: {
                if (error) break;
                this.disabledColor = intValue;
                if (pb != null) {
                    Color[] cs = this.getColors(intValue);
                    pb.setDisabledBackground(cs[0]);
                    pb.setDisabledForeground(cs[1]);
                }
                Return2 = "1";
                break;
            }
            case 411: {
                isrgb = true;
            }
            case 410: {
                if (error) break;
                this.disabledBackgroundColor = intValue;
                this.disabledBackgroundRgb = isrgb;
                if (pb != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    pb.setDisabledBackground(bg);
                }
                Return2 = "1";
                break;
            }
            case 413: {
                isrgb = true;
            }
            case 412: {
                if (error) break;
                this.disabledForegroundColor = intValue;
                this.disabledForegroundRgb = isrgb;
                if (pb != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    pb.setDisabledForeground(fg);
                }
                Return2 = "1";
                break;
            }
            case 414: {
                if (error) break;
                this.rolloverColor = intValue;
                if (pb != null) {
                    Color[] cs = this.getColors(intValue);
                    pb.setRolloverBackground(cs[0]);
                    pb.setRolloverForeground(cs[1]);
                }
                Return2 = "1";
                break;
            }
            case 416: {
                isrgb = true;
            }
            case 415: {
                if (error) break;
                this.rolloverBackgroundColor = intValue;
                this.rolloverBackgroundRgb = isrgb;
                if (pb != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    pb.setRolloverBackground(bg);
                }
                Return2 = "1";
                break;
            }
            case 418: {
                isrgb = true;
            }
            case 417: {
                if (error) break;
                this.rolloverForegroundColor = intValue;
                this.rolloverForegroundRgb = isrgb;
                if (pb != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    pb.setRolloverForeground(fg);
                }
                Return2 = "1";
                break;
            }
            case 7: 
            case 12: {
                if (error) break;
                this.bitmapNumber = intValue;
                if (pb != null) {
                    pb.setBitmapNumber(this.bitmapNumber);
                }
                Return2 = "1";
                break;
            }
            case 8: {
                if (error) break;
                this.bitmapDisabled = intValue;
                if (pb != null) {
                    pb.setBitmapDisabled(this.bitmapDisabled);
                }
                Return2 = "1";
                break;
            }
            case 13: {
                if (error) break;
                this.bitmapPressed = intValue;
                if (pb != null) {
                    pb.setBitmapPressed(this.bitmapPressed);
                }
                Return2 = "1";
                break;
            }
            case 14: {
                if (error) break;
                this.bitmapRollover = intValue;
                if (pb != null) {
                    pb.setBitmapRollover(this.bitmapRollover);
                }
                Return2 = "1";
                break;
            }
            case 240: {
                if (error) break;
                this.titlePosition = intValue;
                if (pb != null) {
                    pb.setTitlePosition(this.titlePosition);
                }
                Return2 = "1";
                break;
            }
            case 20: {
                if (error) break;
                this.bitmapWidth = intValue;
                if (pb != null) {
                    pb.setBitmapWidth(this.bitmapWidth);
                }
                Return2 = "1";
                break;
            }
            case 325: 
            case 326: {
                isrgb = key.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (intValue < 0 || isrgb) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(intValue);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(intValue);
                    this.borderColorIdx = intValue;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                this.setBoxedStyle();
                break;
            }
            case 374: {
                this.handleBorderWidths(value);
                this.setBoxedStyle();
                break;
            }
            case 427: 
            case 428: {
                isrgb = key.equals(ParamsValues.getParamValue("ROLLOVER-BORDER-COLOR-RGB"));
                if (intValue < 0 || isrgb) {
                    this.rolloverBorderColorCmp = new ColorCmp(true);
                    this.rolloverBorderColorIdx = -1;
                    this.rolloverBorderColorCmp.setForeRGB(intValue);
                    this.rolloverBorderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.rolloverBorderColorCmp.getForeground(), false));
                } else {
                    this.rolloverBorderColorCmp = new ColorCmp(intValue);
                    this.rolloverBorderColorIdx = intValue;
                    this.rolloverBorderColor = this.gf.getRemotePalette().getDefaultColor(this.rolloverBorderColorCmp.getForeground());
                }
                this.setRolloverBorderColor();
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    @Override
    public void displayProp() {
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public boolean isSelfAct() {
        if (this.guiComponent != null) {
            return this.guiComponent.getSelfAct();
        }
        return this.selfAct;
    }

    @Override
    public String getProp(int key) {
        PicobolButton pb = (PicobolButton)this.guiComponent;
        switch (key) {
            case 242: {
                return "" + this.transparentColor;
            }
            case 325: {
                if (this.borderColorCmp == null) break;
                return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
            }
            case 427: {
                if (this.rolloverBorderColorCmp == null) break;
                return Integer.toString(this.rolloverBorderColorIdx >= 0 ? this.rolloverBorderColorIdx : this.rolloverBorderColorCmp.getForeground());
            }
            case 410: {
                if (!this.disabledBackgroundRgb && this.disabledBackgroundColor != null) {
                    return this.disabledBackgroundColor.toString();
                }
                if (pb == null || pb.getDisabledBackground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setBackRGB(pb.getDisabledBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 412: {
                if (!this.disabledForegroundRgb && this.disabledForegroundColor != null) {
                    return this.disabledForegroundColor.toString();
                }
                if (pb == null || pb.getDisabledForeground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setForeRGB(pb.getDisabledForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 409: {
                if (this.disabledColor != null) {
                    return this.disabledColor.toString();
                }
                return "0";
            }
            case 415: {
                if (!this.rolloverBackgroundRgb && this.rolloverBackgroundColor != null) {
                    return this.rolloverBackgroundColor.toString();
                }
                if (pb == null || pb.getRolloverBackground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setBackRGB(pb.getRolloverBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 417: {
                if (!this.rolloverForegroundRgb && this.rolloverForegroundColor != null) {
                    return this.rolloverForegroundColor.toString();
                }
                if (pb == null || pb.getRolloverForeground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setForeRGB(pb.getRolloverForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 414: {
                if (this.rolloverColor != null) {
                    return this.rolloverColor.toString();
                }
                return "0";
            }
        }
        return super.getProp(key);
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public String setValue(String v) {
        this.setTitle(v);
        return null;
    }

    @Override
    public void focusGained(CobolFocusEvent cfe) {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (!(rdw == null || cfe.isGoto() || this.noAutoDef || this.defaultButton)) {
            rdw.setTemporaryDefaultButton(this);
        }
        super.focusGained(cfe);
    }

    @Override
    public void focusLost(CobolFocusEvent cfe) {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (rdw != null && rdw.getTemporaryDefaultButton() == this) {
            rdw.setTemporaryDefaultButton(null);
        }
        super.focusLost(cfe);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.isMenuKeyPressed(e)) {
            this.skipNextEvent = true;
            return;
        }
        switch (e.getKeyCode()) {
            case 10: {
                if (!this.gf.getRemoteVirtualKeyboard().isPushButtonActivatedByEnter() || !this.defaultButton && (this.parentWindow == null || this.parentWindow.getTemporaryDefaultButton() != this)) break;
                this.skipNextEvent = false;
                return;
            }
        }
        super.keyPressed(e);
    }

    private void responseOnAction(int id) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        RemoteRecordAccept rra = new RemoteRecordAccept(16, 17, id);
        CobolEventCouple cc = new CobolEventCouple(this, rra);
        if (this.hasClickOverrideFocusChange()) {
            cc.getRemoteRecordAccept().setResponse(true);
            cc.getRemoteRecordAccept().setWait(true);
        }
        this.pushEvent(cc, 4);
    }

    @Override
    public void initialize() {
        Color fg;
        Color bg;
        Color[] cs;
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolButton();
        PicobolButton pb = (PicobolButton)this.guiComponent;
        this.al = e -> {
            if (!this.skipNextEvent) {
                this.responseOnAction(e.getID());
            }
            this.skipNextEvent = false;
        };
        pb.addActionListener(this.al);
        super.intInitialize();
        pb.setScaleBitmapToSize(this.scalebitmaptosize, this.bitmapScaleBestQuality);
        pb.setMultiline(this.multiline || this.m25647 && this.rows >= 2.0f);
        pb.setHasBitmap(this.bitmapStyle);
        if (this.image == null && this.imageId >= 0) {
            this.setImage(1, 1, this.imageId, 1);
        }
        if (this.titlePosition > 0) {
            pb.setTitlePosition(this.titlePosition);
        }
        if (this.title != null) {
            this.setTitle(this.title);
        }
        pb.setBitmapWidth(this.bitmapWidth);
        pb.setBitmapNumber(this.bitmapNumber);
        pb.setBitmapDisabled(this.bitmapDisabled);
        pb.setBitmapRollover(this.bitmapRollover);
        pb.setBitmapPressed(this.bitmapPressed);
        pb.setBitmapScale(this.bitmapScale);
        if (this.disabledColor != null) {
            cs = this.getColors(this.disabledColor);
            pb.setDisabledBackground(cs[0]);
            pb.setDisabledForeground(cs[1]);
        } else {
            if (this.disabledBackgroundColor != null) {
                bg = this.getBackgroundColor(this.disabledBackgroundColor, this.disabledBackgroundRgb);
                pb.setDisabledBackground(bg);
            }
            if (this.disabledForegroundColor != null) {
                fg = this.getForegroundColor(this.disabledForegroundColor, this.disabledForegroundRgb);
                pb.setDisabledForeground(fg);
            }
        }
        if (this.rolloverColor != null) {
            cs = this.getColors(this.rolloverColor);
            pb.setRolloverBackground(cs[0]);
            pb.setRolloverForeground(cs[1]);
        } else {
            if (this.rolloverBackgroundColor != null) {
                bg = this.getBackgroundColor(this.rolloverBackgroundColor, this.rolloverBackgroundRgb);
                pb.setRolloverBackground(bg);
            }
            if (this.rolloverForegroundColor != null) {
                fg = this.getForegroundColor(this.rolloverForegroundColor, this.rolloverForegroundRgb);
                pb.setRolloverForeground(fg);
            }
        }
        this.setRolloverBorderColor();
        this.guiComponent.addKeyListener(this);
        this.guiComponent.setSelfAct(this.selfAct);
        if (this.defaultButton) {
            this.parentWindow.setDefaultButton(this);
        }
        pb.setTransparent(this.transparent);
        pb.setFlat(this.flat);
        this.usedtorender = true;
        if (this.alignmentH != 0) {
            pb.setHorizontalAlignment(this.alignmentH);
        }
        if (this.alignmentV != 0) {
            pb.setVerticalAlignment(this.alignmentV);
        }
        this.setBoxedStyle();
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imid, int strip) {
        Rectangle r = this.getBounds();
        viewWidth = r.width;
        viewHeight = r.height;
        this.imageId = imid;
        if (viewWidth == 0 || !this.bitmapStyle) {
            return;
        }
        this.image = this.getLocalImage(this.imageId);
        if (this.bitmapWidth == 0) {
            this.bitmapWidth = viewWidth;
        }
        PicobolButton pb = (PicobolButton)this.guiComponent;
        if (this.guiComponent != null) {
            pb.setImage(this.image, this.bitmapWidth, viewHeight, this.transparentColor);
            if (this.image != null && this.title != null) {
                pb.setHasBitmap(this.bitmapStyle);
                pb.setTitle(this.title);
            }
        }
    }

    @Override
    protected void processMnemonic(char c) {
        super.processMnemonic(c);
        PicobolButton pb = (PicobolButton)this.guiComponent;
        if (pb != null) {
            new Thread(() -> pb.doClick(100)).start();
        }
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        this.pcListener = null;
        PicobolButton cb = (PicobolButton)this.guiComponent;
        if (cb != null) {
            cb.removeActionListener(this.al);
            this.al = null;
        }
        if (this.parentWindow != null) {
            if (this.defaultButton) {
                this.parentWindow.removeDefaultButton(this);
            }
            if (this.escapeButton) {
                this.parentWindow.removeEscapeButton(this);
            }
        }
        RemoteBaseGUIControl rbgcupon = null;
        if (cb != null && (this.uponCtrlsrvid >= 0 || this.tabGroup >= 0) && this.parentWindow != null && ((rbgcupon = this.parentWindow.getBGC(this.uponCtrlsrvid)) != null || (rbgcupon = this.parentWindow.getBGC(this.tabGroup)) != null) && rbgcupon instanceof RemoteTab && ((RemoteTab)rbgcupon).isRibbon()) {
            ((RemoteTab)rbgcupon).removeOnHeader(this.thisonribbonheader);
        }
        this.thisonribbonheader = null;
        super.destroy();
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        if (this.parentWindow != null) {
            if (this.defaultButton) {
                this.parentWindow.updateDefaultButton();
            }
            if (this.escapeButton) {
                this.parentWindow.updateEscapeButton();
            }
        }
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        if (rra.getEventType() == 17042 && eventAction == 4) {
            this.parentWindow.setDragFailed(true);
        } else if (rra.getEventType() == 17043) {
            this.parentWindow.setDragFailed(false);
        }
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        int widthsave = this.width;
        int heightsave = this.height;
        this.width = w;
        this.height = h;
        if (this.guiComponent != null && setOnComp) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        } else if (!(this.isVisible() || this.guiComponent == null || setOnComp || widthsave == w && heightsave == h)) {
            this.addLayoutManager();
        }
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle Return2 = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return Return2;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle Return2 = this.getRealBounds();
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                Return2.width -= 8;
            }
            if (!this.linesInPixel) {
                Return2.height -= 7;
            }
        }
        return Return2;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle Return2 = this.getBounds();
        if (!this.bitmapStyle && Return2 != null && Return2.width > 0) {
            Return2.width -= 8;
        }
        return Return2;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        if (this.bitmapStyle) {
            return 16.0f;
        }
        return 8.0f;
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize ps, int origHeight) {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return super.paramgetDefaultHeight(ps, origHeight);
    }

    @Override
    public String getType() {
        return "pushbutton";
    }

    @Override
    public boolean canBecomeDefaultButton() {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        return rdw != null && (!this.noAutoDef && !this.defaultButton || this.defaultButton);
    }

    @Override
    public void startCellEditing() {
        RemoteRecordAccept rra = new RemoteRecordAccept(16, 17, 1001);
        CobolEventCouple cc = new CobolEventCouple(this, rra);
        this.pushEvent(cc, 4);
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(true, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean removelistener, Dimension scalebitmaptosize) {
        PicobolButton pb = (PicobolButton)this.guiComponent;
        this.scalebitmaptosize = scalebitmaptosize;
        if (removelistener) {
            pb.removeActionListener(this.al);
        }
        this.image = null;
        RemotePushButton clone = null;
        try {
            clone = (RemotePushButton)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setComponent(null);
        if (this.bitmapNumber == 0 && this.imageId >= 0) {
            clone.setProp(new Integer(12), "1", 0);
        }
        if (scalebitmaptosize != null) {
            clone.setProp(new Integer(240), "0", 0);
        }
        clone.initialize();
        if (this.popupMenu != null) {
            clone.popupMenu = null;
            clone.setPopupMenu(this.popupMenu);
        }
        return clone;
    }

    @Override
    protected void putOnHeader() {
        this.setStyle(65536, true);
    }

    public void fireactionevent() {
        PicobolButton pb = (PicobolButton)this.guiComponent;
        ActionListener[] listeners = pb.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (this.skipNextEvent || pb.getModel().isPressed() || pb.getModel().isArmed()) continue;
            listeners[i].actionPerformed(new ActionEvent(pb, 1001, pb.getActionCommand()));
        }
    }

    public String getTitle(String gctxt) {
        String Return2 = gctxt;
        if (!(this.bitmapStyle && this.titlePosition <= 0 || this.title == null)) {
            Return2 = this.title;
        }
        return Return2;
    }

    @Override
    public void adjustBounds(Rectangle Return2) {
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                Return2.width -= 8;
            }
            if (!this.linesInPixel) {
                Return2.height -= 7;
            }
        }
    }

    protected void setBoxedStyle() {
        PicobolButton pb = (PicobolButton)this.guiComponent;
        if (pb != null && this.borderWidths != null && this.borderWidths.size() > 0) {
            pb.setCustomBorder(this.borderWidths, this.borderColor);
        }
    }

    private void setRolloverBorderColor() {
        PicobolButton pb = (PicobolButton)this.guiComponent;
        if (pb != null) {
            pb.setRolloverBorderColor(this.rolloverBorderColor);
        }
    }

    @Override
    public JComponent getDragDropComponent() {
        return (PicobolButton)this.guiComponent;
    }

    static {
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
    }
}

