/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.CobolFocusable;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.ParamElementString;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.PicobolTextEvent;
import com.iscobol.gui.PicobolTextListener;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.spellchecker.SpellChecker;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.EntryField;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MsgBoxEvent;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.PicobolEntryField;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteGrid;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeListener;

public class RemoteEntryField
extends RemoteBaseGUIControl {
    private static final int DEFAULT_WIDTH_INSETS = 10;
    private static final int DEFAULT_HEIGHT_INSETS = 6;
    private static final int DEFAULT_SCROLLBAR_INSETS = 3;
    private static final int DEFAULT_ALIGNMENT = 2;
    public static final int ORIENTATION_NONE = 0;
    public static final int ORIENTATION_LEFT_TO_RIGHT = 1;
    public static final int ORIENTATION_RIGHT_TO_LEFT = 2;
    private static Comparator<String> ignoreCaseComparator = (s1, s2) -> s1.compareToIgnoreCase((String)s2);
    private boolean noWrap;
    private boolean multiline;
    private int textWrapping;
    private boolean isNumeric;
    private int autoDecimal;
    private boolean autoTermination;
    private boolean notifyChange;
    private boolean lower;
    private boolean upper;
    private boolean useReturn;
    private boolean useTab;
    private boolean readOnly;
    private boolean secure;
    private boolean noautosel;
    private boolean spinner;
    private boolean autoSpin;
    private boolean boxed;
    private boolean noBox;
    private boolean _3d;
    private boolean required;
    private boolean valueMultiple;
    private PicobolTextListener textListener;
    protected int maxText = -1;
    private int maxLines;
    private int cursorPos;
    private int cursorRowPos;
    private int cursorColPos;
    private int selStart;
    private int selStartRow;
    private int selStartCol;
    private int textOrientation = 0;
    private String selectionText = "";
    private float rows;
    private float cols;
    private boolean hasVScrollbar;
    private String textValue = "";
    private int action;
    private int alignment = 2;
    private int maxValue;
    private int minValue;
    private String formatString;
    private char fillChar = (char)32;
    private int formatType;
    protected int widthInset;
    protected int heightInset;
    private String placeholder;
    private Color placeholderColor;
    private int bitmapNumber;
    private int bitmapRollover;
    private int bitmapTrailingRollover;
    private int bitmapTrailing;
    private int bitmapDisabled;
    private int bitmapTrailingDisabled;
    private int bitmapWidth;
    private int bitmapHeight;
    private String bitmapHint;
    private String bitmapTrailingHint;
    private Image image;
    private boolean proposalsEnabled = true;
    private Vector proposals = new Vector();
    private int proposalIndex;
    private int visibleProposalCount = 5;
    private boolean proposalsUnsorted;
    private JPopupMenu proposalPopup;
    private JList proposalList;
    private int proposalAfterDigits;
    private String currText;
    private DefaultListModel matchingProposals;
    private Timer proposalTimer;
    private NotifyChangeTimer notifyChangeTimer;
    private PropertyChangeListener pcListener;
    private Integer configBcolor;
    private Integer configFcolor;
    private String disabledFieldColor;
    private String readOnlyFieldColor;
    private boolean useDefaultBorderWithBoxedStyle;
    private Color defaultBackground;
    private Color defaultForeground;
    private String validationRegexp;
    private int validationOpts;
    private String validationErrmsg;
    private boolean backgroundSet;
    private boolean foregroundSet;
    private String lineSeparator;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private String spellChecking;
    private boolean readOnlyCursor;
    private ChangeListener caretListener;
    private boolean caretListenerEnabled = true;
    private boolean defaultShortcutsEnabled;
    private String acceptedControlCharacters;
    private Integer iConfigFocusBorderColor;
    private String sConfigFocusBorder;
    private Color configFocusBorderColor;
    protected Border configFocusBorder;
    protected Border origBorder;
    private Vector<Integer> marginWidths = new Vector();
    private String fvalSW;
    private boolean checkSW;
    private String inputFilter;
    private int proposalFilterType = 1;
    private Pattern regex = null;
    private FastCellRenderer renderer;
    private String matchingTextColor;
    private Color defaultMatchingTextColorBackground;
    private Color matchingTextColorBackground = this.defaultMatchingTextColorBackground = new Color(255, 215, 50);
    private Color matchingTextColorForeground = null;
    private boolean styleDPC;
    private RolloverBorderManager borderManager;
    private boolean maxTextBytes = true;
    private int initialDelay;

    public RemoteEntryField(GuiFactoryImpl gf) {
        super(gf);
        this.proposalTimer = new Timer(500, e -> this.showProposalPopup(((EntryField)((Object)this.guiComponent)).getText()));
        this.proposalTimer.setRepeats(false);
        try {
            this.configBcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.curr_bcolor", null));
        }
        catch (Exception ex) {
            try {
                this.configBcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.curr_ef_bcolor", null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.configFcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.curr_fcolor", null));
        }
        catch (Exception ex) {
            try {
                this.configFcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.curr_ef_fcolor", null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.iConfigFocusBorderColor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.curr_border_color", null));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.sConfigFocusBorder = gf.getCsProperty().get("iscobol.gui.curr_border_width", null);
        this.configFocusBorderColor = this.iConfigFocusBorderColor != null ? gf.getRemotePalette().getDefaultColor(this.iConfigFocusBorderColor) : (this.borderColor != null ? this.borderColor : Color.darkGray);
        this.setRolloverBorder();
        this.useDefaultBorderWithBoxedStyle = gf.getCsProperty().get("iscobol.gui.native_style", false);
        this.disabledFieldColor = gf.getCsProperty().get("iscobol.gui.disabled_field_color", null);
        this.readOnlyFieldColor = gf.getCsProperty().get("iscobol.gui.entryfield.read_only_color", null);
        this.lineSeparator = gf.getCsProperty().get("iscobol.gui.ef_lineseparator", null);
        this.readOnlyCursor = gf.getCsProperty().get("iscobol.gui.entryfield.read_only_cursor_arrow", false);
        this.defaultShortcutsEnabled = gf.getCsProperty().get("iscobol.key.default_shortcuts_enabled", true);
        this.acceptedControlCharacters = gf.getCsProperty().get("iscobol.key.accepted_control_characters", null);
        this.maxTextBytes = gf.getCsProperty().get("iscobol.gui.max_text_in_bytes", true);
        this.matchingTextColor = gf.getCsProperty().get("iscobol.gui.matching_text_color", null);
        int notifyChangeDelay = gf.getCsProperty().get("iscobol.gui.entryfield.notify_change_delay", 0);
        if (notifyChangeDelay > 0) {
            this.notifyChangeTimer = new NotifyChangeTimer(notifyChangeDelay);
        }
        this.setPlaceholderColor();
        this.pcListener = evt -> {
            if (gf != null) {
                String key = evt.getPropertyName();
                if (key.equals("iscobol.gui.curr_ef_bcolor") || key.equals("iscobol.gui.curr_bcolor")) {
                    try {
                        this.configBcolor = Integer.valueOf(gf.getCsProperty().get(key, null));
                    }
                    catch (Exception exception) {}
                } else if (key.equals("iscobol.gui.curr_ef_fcolor") || key.equals("iscobol.gui.curr_fcolor")) {
                    try {
                        this.configFcolor = Integer.valueOf(gf.getCsProperty().get(key, null));
                    }
                    catch (Exception exception) {}
                } else if (key.equals("iscobol.gui.rollover_border_color") || key.equals("iscobol.gui.rollover_border_width")) {
                    this.setRolloverBorder();
                } else if (key.equals("iscobol.gui.disabled_field_color")) {
                    this.setDisabledFieldColor(gf.getCsProperty().get(key, null));
                } else if (key.equals("iscobol.gui.entryfield.read_only_color")) {
                    this.setReadOnlyFieldColor(gf.getCsProperty().get(key, null));
                } else if (key.equals("iscobol.gui.placeholder_color")) {
                    this.setPlaceholderColor();
                } else if (key.equals("iscobol.key.accepted_control_characters")) {
                    this.acceptedControlCharacters = gf.getCsProperty().get("iscobol.key.accepted_control_characters", null);
                    if (this.guiComponent != null) {
                        ((PicobolEntryField)this.guiComponent).setAcceptedControlCharacters(this.acceptedControlCharacters);
                    }
                } else if (key.equals("iscobol.gui.max_text_in_bytes")) {
                    this.maxTextBytes = gf.getCsProperty().get("iscobol.gui.max_text_in_bytes", true);
                    if (this.guiComponent != null) {
                        ((PicobolEntryField)this.guiComponent).setMaxTextBytes(this.maxTextBytes);
                    }
                } else if (key.equals("iscobol.gui.entryfield.spell_checking_delay")) {
                    if (this.guiComponent != null) {
                        ((PicobolEntryField)this.guiComponent).setSpellCheckingDelay(gf.getCsProperty().get("iscobol.gui.entryfield.spell_checking_delay", 500));
                    }
                } else if (key.equals("iscobol.gui.matching_text_color")) {
                    this.setMatchingTextColor(gf.getCsProperty().get(key, null));
                }
            }
        };
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    private void setRolloverBorder() {
        Integer rollBColorVal = null;
        try {
            rollBColorVal = Integer.valueOf(this.gf.getCsProperty().get("iscobol.gui.rollover_border_color", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String rollBWidths = this.gf.getCsProperty().get("iscobol.gui.rollover_border_width", null);
        if (rollBWidths != null && rollBColorVal == null) {
            rollBColorVal = -(Color.darkGray.getRGB() & 0xFFFFFF);
        }
        if (rollBColorVal != null) {
            Color rollBColor = this.gf.getRemotePalette().getDefaultColor(rollBColorVal);
            int top = 1;
            int bottom = 1;
            int left = 1;
            int right = 1;
            if (rollBWidths != null) {
                Vector<Integer> v = new Vector<Integer>();
                try {
                    this.handleBorderWidths(rollBWidths, v);
                    if (v.size() > 0) {
                        top = v.elementAt(0);
                    }
                    if (v.size() > 1) {
                        left = v.elementAt(1);
                    }
                    if (v.size() > 2) {
                        bottom = v.elementAt(2);
                    }
                    if (v.size() > 3) {
                        right = v.elementAt(3);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MatteBorder brd = new MatteBorder(top, left, bottom, right, rollBColor);
            if (this.borderManager != null) {
                this.borderManager.mouseEnterBorder = brd;
            } else {
                this.borderManager = new RolloverBorderManager(brd);
            }
        }
    }

    private void setPlaceholderColor() {
        try {
            int colorNum = Integer.parseInt(this.gf.getCsProperty().get("iscobol.gui.placeholder_color", null));
            this.placeholderColor = this.getForegroundColor(colorNum, false);
        }
        catch (Exception e) {
            this.placeholderColor = null;
        }
        if (this.guiComponent != null) {
            ((PicobolEntryField)this.guiComponent).setPlaceholderColor(this.placeholderColor);
        }
    }

    private void setDisabledFieldColor(String value) {
        this.disabledFieldColor = value;
        if (this.guiComponent != null) {
            boolean[] applyAlways = new boolean[1];
            Color[] fieldColors = this.getFieldColors(this.disabledFieldColor, applyAlways);
            EntryField ef = (EntryField)((Object)this.guiComponent);
            if (applyAlways[0] || !this.backgroundSet) {
                ef.setDisabledBackground(fieldColors[0]);
            } else {
                ef.setDisabledBackground(null);
            }
            if (applyAlways[0] || !this.foregroundSet) {
                ef.setDisabledForeground(fieldColors[1]);
            } else {
                ef.setDisabledForeground(null);
            }
        }
    }

    private void setReadOnlyFieldColor(String value) {
        this.readOnlyFieldColor = value;
        if (this.guiComponent != null) {
            boolean[] applyAlways = new boolean[1];
            Color[] fieldColors = this.getFieldColors(this.readOnlyFieldColor, applyAlways);
            EntryField ef = (EntryField)((Object)this.guiComponent);
            if (applyAlways[0] || !this.backgroundSet) {
                ef.setReadOnlyBackground(fieldColors[0]);
            } else {
                ef.setReadOnlyBackground(null);
            }
            if (applyAlways[0] || !this.foregroundSet) {
                ef.setReadOnlyForeground(fieldColors[1]);
            } else {
                ef.setReadOnlyForeground(null);
            }
        }
    }

    private void setMatchingTextColor(String value) {
        this.matchingTextColor = value;
        if (this.matchingTextColor != null) {
            boolean[] applyAlways = new boolean[1];
            Color[] fieldColors = this.getFieldColors(this.matchingTextColor, applyAlways);
            this.matchingTextColorBackground = applyAlways[0] && fieldColors[0] != null ? fieldColors[0] : this.defaultMatchingTextColorBackground;
            this.matchingTextColorForeground = applyAlways[0] ? fieldColors[1] : null;
        }
        if (this.matchingTextColorForeground == null) {
            this.matchingTextColorForeground = this.getForeground();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        switch (e.getKeyCode()) {
            case 8: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 127: {
                return;
            }
            case 38: {
                if (this.allowProposals()) {
                    if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                        this.selectItemUp();
                    } else {
                        this.showProposalPopup(((EntryField)((Object)this.guiComponent)).getText());
                    }
                    return;
                }
                if (!this.multiline) break;
                return;
            }
            case 40: {
                if (this.allowProposals()) {
                    if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                        this.selectItemDown();
                    } else {
                        this.showProposalPopup(((EntryField)((Object)this.guiComponent)).getText());
                    }
                    return;
                }
                if (!this.multiline) break;
                return;
            }
            case 33: 
            case 34: {
                if (!this.multiline) break;
                return;
            }
            case 10: {
                if (this.multiline && this.useReturn) {
                    return;
                }
                if (this.multiline && ((PicobolEntryField)this.guiComponent).getUseReturn()) {
                    return;
                }
                if (this.proposalPopup == null || !this.proposalPopup.isVisible()) break;
                this.proposalPopup.setVisible(false);
                break;
            }
            case 9: {
                if (this.useTab) {
                    return;
                }
                if (this.proposalPopup == null || !this.proposalPopup.isVisible()) break;
                this.proposalPopup.setVisible(false);
                break;
            }
            case 67: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                if (!e.isControlDown() || !this.defaultShortcutsEnabled) break;
                return;
            }
        }
        super.keyPressed(e);
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl opposite, MouseEvent me, RemoteRecordAccept rra) {
        if (!(opposite != null && opposite.isSelfAct() || this.check(opposite))) {
            return false;
        }
        if (opposite != this) {
            this.restoreBF();
        }
        return true;
    }

    private boolean check(RemoteBaseGUIControl opposite) {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf == null) {
            return true;
        }
        String errorMessage = null;
        String text = tf.getText();
        if (this.isNumeric) {
            if (!this.checkMinMax(text)) {
                if (opposite != null) {
                    opposite.skipNextEvent();
                }
                return false;
            }
            if (this.autoDecimal > 0) {
                int idx = text.indexOf(46);
                if (idx == -1) {
                    idx = text.indexOf(44);
                }
                if (idx > -1) {
                    int diff = text.length() - 1 - idx - this.autoDecimal;
                    if (diff < 0) {
                        tf.setAllText(text + ScreenUtility.getAll('0', -diff));
                    }
                } else if (this.styleDPC) {
                    tf.setAllText(text + "," + ScreenUtility.getAll('0', this.autoDecimal));
                } else {
                    tf.setAllText(text + "." + ScreenUtility.getAll('0', this.autoDecimal));
                }
            }
        } else {
            if (this.required && tf.getText().length() == 0) {
                errorMessage = Factory.getSysMsg("ef_input_required_msg");
                if (opposite != null) {
                    opposite.skipNextEvent();
                }
                if (this.msgboxlistener != null) {
                    this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this.guiComponent, errorMessage, Factory.getSysMsg("ef_error_msg_title")));
                }
                return false;
            }
            if (this.validationRegexp != null) {
                String txt = tf.getText();
                int flags = 0;
                if ((this.validationOpts & 1) == 1) {
                    flags = 66;
                }
                if ((this.validationOpts & 2) == 2) {
                    txt = Factory.leftTrim(txt);
                }
                if ((this.validationOpts & 4) == 4) {
                    txt = Factory.rightTrim(txt);
                }
                if (!Pattern.compile(this.validationRegexp, flags).matcher(txt).matches()) {
                    errorMessage = this.validationErrmsg != null ? this.validationErrmsg : Factory.getSysMsg("ef_invalid_input");
                    if (opposite != null) {
                        opposite.skipNextEvent();
                    }
                    if (this.msgboxlistener != null) {
                        this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this.guiComponent, errorMessage, Factory.getSysMsg("ef_error_msg_title")));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public float getDefaultWidth() {
        return 8.0f;
    }

    @Override
    public float getDefaultHeight() {
        float Return2 = 1.0f;
        return Return2;
    }

    @Override
    public void focusGained(CobolFocusEvent cfe) {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (cfe.isGoto()) {
            this.setconfigBF();
        }
        if (!(cfe.isGoto() && !cfe.isAltKey() || rdw == null || this.guiComponent == null || this.noautosel && this.cursorPos != -1 || rdw.getPreviousFocusOwner() == this)) {
            new SwingWorker(false, () -> {
                boolean b = this.caretListenerEnabled;
                this.caretListenerEnabled = false;
                ((PicobolEntryField)this.guiComponent).selectAll();
                this.caretListenerEnabled = b;
            }).start();
        }
        if (this.sConfigFocusBorder != null || this.iConfigFocusBorderColor != null) {
            PicobolEntryField ef = (PicobolEntryField)this.guiComponent;
            if (this.sConfigFocusBorder != null) {
                if (this.borderWidths != null) {
                    this.borderWidths.clear();
                }
                this.handleBorderWidths(this.sConfigFocusBorder);
                this.configFocusBorder = new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.configFocusBorderColor);
                this.borderWidths.clear();
                this.borderWidths = null;
                if (this.borderManager != null && this.borderManager.mouseExitBorder != null) {
                    this.borderManager.mouseExitBorder = this.configFocusBorder;
                } else {
                    ef.setBorder(this.configFocusBorder);
                }
            } else {
                Border brd = this.borderWidths == null ? BorderFactory.createLineBorder(this.configFocusBorderColor) : new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.configFocusBorderColor);
                if (this.borderManager != null && this.borderManager.mouseExitBorder != null) {
                    this.borderManager.mouseExitBorder = brd;
                } else {
                    ef.setBorder(brd);
                }
            }
        }
        super.focusGained(cfe);
    }

    @Override
    public void focusLost(CobolFocusEvent cfe) {
        PicobolEntryField ef;
        this.restoreBF();
        if (!cfe.isGoto() && this.guiComponent != null && this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getFocusOwner() != this) {
            ef = (PicobolEntryField)this.guiComponent;
            new IsguiWorker(false, () -> {
                if (ef.getSelectedText().length() > 0) {
                    boolean b = this.caretListenerEnabled;
                    this.caretListenerEnabled = false;
                    ef.select(0, 0);
                    this.caretListenerEnabled = b;
                }
            }).start();
        }
        super.focusLost(cfe);
        if (this.configFocusBorder != null || this.iConfigFocusBorderColor != null) {
            ef = (PicobolEntryField)this.guiComponent;
            if (this.borderManager != null && this.borderManager.mouseExitBorder != null) {
                this.borderManager.mouseExitBorder = this.origBorder;
            } else {
                ef.setBorder(this.origBorder);
            }
        }
    }

    @Override
    protected void intFocusGained(boolean restore) {
        if (!restore) {
            this.setconfigBF();
        }
    }

    @Override
    public void displayProp() {
    }

    @Override
    public int getGUIControlHeight(float h) {
        int Return2 = (int)((float)this.font.getHeight() * h);
        if (!this.noBox) {
            this.heightInset = 6;
            Return2 += this.heightInset;
        }
        if (this.hasVScrollbar) {
            this.heightInset += 3;
            Return2 += 3;
        }
        if (h >= 2.0f) {
            this.multiline = true;
        }
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float width) {
        int Return2 = 0;
        Return2 = (int)((float)this.font.getWidth() * width);
        this.widthInset = 10;
        Return2 += this.widthInset;
        if (this.hasVScrollbar) {
            Return2 += 15;
        }
        if (this.spinner) {
            Return2 += 15;
        }
        return Return2;
    }

    @Override
    public String getProp(int key) {
        PicobolEntryField tc = (PicobolEntryField)this.guiComponent;
        switch (key) {
            case 360: {
                return this.spellChecking;
            }
            case 299: {
                return this.validationErrmsg;
            }
            case 300: {
                return this.validationRegexp;
            }
            case 301: {
                return "" + this.validationOpts;
            }
            case 59: {
                this.updateCursorProps();
                return "" + this.cursorPos;
            }
            case 60: {
                this.updateCursorProps();
                return "" + this.cursorRowPos;
            }
            case 54: {
                this.updateCursorProps();
                return "" + this.cursorColPos;
            }
            case 214: {
                this.updateSelectionStartProps();
                return "" + this.selStart;
            }
            case 215: {
                this.updateSelectionStartProps();
                return "" + this.selStartRow;
            }
            case 213: {
                this.updateSelectionStartProps();
                return "" + this.selStartCol;
            }
            case 147: {
                return "" + (this.maxText == -1 ? 0 : this.maxText);
            }
            case 216: {
                return tc.getSelectedText();
            }
            case 266: {
                if (this.proposalIndex > 0 && this.proposalIndex <= this.proposals.size()) {
                    return this.proposals.elementAt(this.proposalIndex - 1).toString();
                }
                return "";
            }
            case 269: {
                return "" + this.proposalIndex;
            }
            case 272: {
                return "" + this.proposalTimer.getInitialDelay();
            }
            case 271: {
                return "" + this.visibleProposalCount;
            }
            case 304: {
                return "" + this.textOrientation;
            }
            case 323: {
                return "" + this.proposalAfterDigits;
            }
            case 471: {
                return "" + this.proposalFilterType;
            }
            case 325: {
                if (this.borderColorCmp != null) {
                    return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
                }
                return null;
            }
            case 12: {
                return "" + this.bitmapNumber;
            }
            case 14: {
                return "" + this.bitmapRollover;
            }
            case 364: {
                return "" + this.bitmapTrailingRollover;
            }
            case 362: {
                return this.bitmapHint;
            }
            case 363: {
                return this.bitmapTrailingHint;
            }
            case 8: {
                return "" + this.bitmapDisabled;
            }
            case 358: {
                return "" + this.bitmapTrailing;
            }
            case 359: {
                return "" + this.bitmapTrailingDisabled;
            }
            case 96: {
                return this.formatString;
            }
            case 324: {
                return this.placeholder;
            }
            case 366: {
                return this.notifyChangeTimer != null ? Integer.toString(this.notifyChangeTimer.getInitialDelay()) : "0";
            }
            case 422: {
                return this.borderToString(this.marginWidths);
            }
        }
        return super.getProp(key);
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolEntryField ef = (PicobolEntryField)this.guiComponent;
        String[] txt = new String[1];
        new SwingWorker(true, () -> {
            String text = this.getText();
            if (this.multiline && this.valueMultiple && text.length() > 0) {
                int[][] offs = ef.getLineOffsets();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < offs.length; ++i) {
                    if (offs[i][0] >= text.length()) continue;
                    buf.append(text.substring(offs[i][0], Math.min(text.length(), offs[i][1] + 1)));
                    if (buf.charAt(buf.length() - 1) == '\n' || i >= offs.length - 1) continue;
                    buf.append('\n');
                }
                text = buf.toString();
            }
            txt[0] = text;
        }).start();
        if (this.lineSeparator != null && this.lineSeparator.length() > 0) {
            return txt[0].replaceAll("(\r)?\n", this.lineSeparator);
        }
        return txt[0];
    }

    public String getValuenoSW() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolEntryField ef = (PicobolEntryField)this.guiComponent;
        String[] txt = new String[1];
        String text = this.getText();
        if (this.multiline && this.valueMultiple && text.length() > 0) {
            int[][] offs = ef.getLineOffsets();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < offs.length; ++i) {
                if (offs[i][0] >= text.length()) continue;
                buf.append(text.substring(offs[i][0], Math.min(text.length(), offs[i][1] + 1)));
                if (buf.charAt(buf.length() - 1) == '\n' || i >= offs.length - 1) continue;
                buf.append('\n');
            }
            text = buf.toString();
        }
        txt[0] = text;
        if (this.lineSeparator != null && this.lineSeparator.length() > 0) {
            return txt[0].replaceAll("(\r)?\n", this.lineSeparator);
        }
        return txt[0];
    }

    private String getText() {
        if (this.guiComponent == null) {
            return "";
        }
        return ((PicobolEntryField)this.guiComponent).getText();
    }

    @Override
    public void initialize() {
        PicobolEntryField tf;
        if (this.guiComponent != null) {
            return;
        }
        String v = ScreenUtility.rightTrim(this.textValue);
        if (this.multiline) {
            this.guiComponent = new PicobolEntryField(this.gf, v, (int)this.rows, (int)this.cols);
            tf = (PicobolEntryField)this.guiComponent;
            if (this.hasVScrollbar) {
                tf.addVerticalScrollBar();
            }
        } else {
            this.guiComponent = this.spinner ? new PicobolEntryField(this.gf, this.autoSpin) : (this.formatString != null ? new PicobolEntryField(this.gf, this.formatType, this.formatString, this.fillChar) : (this.secure ? new PicobolEntryField(this.gf, '*') : new PicobolEntryField(this.gf)));
            tf = (PicobolEntryField)this.guiComponent;
            tf.setHorizontalAlignment(this.alignment);
        }
        if (!this.isNational) {
            tf.setEncoding(this.gf.getIscobolEncoding());
        }
        tf.setMaxTextBytes(this.maxTextBytes);
        tf.setDefaultShortcutsEnabled(this.defaultShortcutsEnabled);
        tf.setUpperLowerMethod(this.gf.getUpperLowerMethod());
        tf.setAcceptedControlCharacters(this.acceptedControlCharacters);
        this.defaultBackground = this.guiComponent.getBackground();
        this.defaultForeground = this.guiComponent.getForeground();
        this.setTextWrapping(tf, this.textWrapping);
        switch (this.textOrientation) {
            default: {
                break;
            }
            case 1: {
                tf.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                break;
            }
            case 2: {
                tf.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
        }
        if (this.popupListener == null) {
            this.popupListener = new PopupListener(tf);
        }
        this.guiComponent.addKeyListener(this);
        tf.setNumeric(this.isNumeric);
        tf.setMaxText(this.maxText < 0 ? 0 : this.maxText);
        if (this.upper) {
            tf.setUpper(this.upper);
        } else if (this.lower) {
            tf.setLower(this.lower);
        } else {
            tf.setLower(this.gf.getGuiKdbLower());
            tf.setUpper(this.gf.getGuiKdbUpper());
        }
        tf.setReadOnly(this.readOnly, this.readOnlyCursor);
        tf.setAuto(this.autoTermination);
        tf.setMaxLines(this.maxLines);
        tf.setUseTab(this.useTab);
        tf.setUseReturn(this.useReturn);
        tf.setPlaceholder(this.placeholder);
        tf.setPlaceholderColor(this.placeholderColor);
        tf.setSpellChecking(this.spellChecking);
        tf.setSpellCheckingDelay(this.gf.getCsProperty().get("iscobol.gui.entryfield.spell_checking_delay", 500));
        tf.setIconHint(this.bitmapHint);
        tf.setIconTrailingHint(this.bitmapTrailingHint);
        if (this.maxValue != 0 || this.minValue != 0) {
            tf.setMaxValue(this.maxValue);
            tf.setMinValue(this.minValue);
        }
        tf.setNoWrap(this.noWrap);
        this.setMargins(false);
        if (this._3d) {
            this.set3DStyle();
        } else if (this.gf.getFieldsUnboxed()) {
            if (this.boxed) {
                this.setBoxedStyle();
            } else {
                this.setNoboxStyle();
            }
        } else if (this.noBox) {
            this.setNoboxStyle();
        } else {
            this.setBoxedStyle();
        }
        this.textListener = new PicobolTextListener(){

            @Override
            public void textChanged(PicobolTextEvent e) {
                if (RemoteEntryField.this.proposalsEnabled && RemoteEntryField.this.allowProposals()) {
                    if (RemoteEntryField.this.proposalPopup != null && RemoteEntryField.this.proposalPopup.isVisible()) {
                        RemoteEntryField.this.showProposalPopup(((EntryField)((Object)RemoteEntryField.this.guiComponent)).getText());
                    } else {
                        RemoteEntryField.this.proposalTimer.restart();
                    }
                }
                if (RemoteEntryField.this.notifyChange) {
                    short ed1 = (short)(e.getDetail() + 1);
                    if (RemoteEntryField.this.notifyChangeTimer != null) {
                        RemoteEntryField.this.notifyChangeTimer.setEd1(ed1);
                        RemoteEntryField.this.notifyChangeTimer.restart();
                    } else {
                        RemoteEntryField.this.sendNtfChangeEvent(ed1);
                    }
                }
                if (RemoteEntryField.this.autoDecimal > 0) {
                    int diff;
                    PicobolEntryField ef = (PicobolEntryField)RemoteEntryField.this.guiComponent;
                    String t = ef.getText();
                    if (!RemoteEntryField.this.checkMinMax(t)) {
                        return;
                    }
                    int idx = t.indexOf(46);
                    if (idx == -1) {
                        idx = t.indexOf(44);
                    }
                    if (idx > -1 && (diff = t.length() - 1 - idx - RemoteEntryField.this.autoDecimal) >= 0) {
                        RemoteEntryField.this.intKeyPressed(VirtualKeyboard.getStandardNext(), true, null);
                    }
                }
            }

            @Override
            public void valueIncrementing(PicobolTextEvent e) {
                CobolEventCouple cc = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(6, 96, 16416, false, false, true));
                RemoteEntryField.this.pushEvent(cc);
                if (RemoteEntryField.this.spinner) {
                    RemoteEntryField.this.handleMouseClicked(false);
                }
            }

            @Override
            public void valueDecrementing(PicobolTextEvent e) {
                CobolEventCouple cc = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(6, 96, 16417, false, false, true));
                RemoteEntryField.this.pushEvent(cc);
                if (RemoteEntryField.this.spinner) {
                    RemoteEntryField.this.handleMouseClicked(false);
                }
            }

            @Override
            public void inputTerminated(PicobolTextEvent e) {
                RemoteEntryField.this.intKeyPressed(RemoteEntryField.this.gf.getRemoteVirtualKeyboard().getAutoTerminated(), true, null);
            }

            @Override
            public void inputTerminated(KeyEvent e) {
                RemoteEntryField.this.intKeyPressed(RemoteEntryField.this.gf.getRemoteVirtualKeyboard().mapKey(e), false, null);
            }

            @Override
            public void iconClicked(PicobolTextEvent evt) {
                CobolEventCouple cc = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(7, 96, 16400, (short)(evt.getDetail() + 1), 0, false, false, true));
                RemoteEntryField.this.pushEvent(cc);
            }

            @Override
            public void iconDoubleClicked(PicobolTextEvent evt) {
                CobolEventCouple cc = new CobolEventCouple(RemoteEntryField.this, new RemoteRecordAccept(7, 96, 16401, (short)(evt.getDetail() + 1), 0, false, false, true));
                RemoteEntryField.this.pushEvent(cc);
            }
        };
        tf.addTextListener(this.textListener);
        this.caretListener = e -> {
            if (this.caretListenerEnabled && this.cursorPos < 0) {
                this.cursorPos = 0;
            }
        };
        tf.getTextComponent().getCaret().addChangeListener(this.caretListener);
        if (this.borderManager != null) {
            tf.addMouseListener(this.borderManager);
        }
        super.intInitialize();
        if (this.inputFilter != null) {
            tf.setInputFilter(this.inputFilter);
        }
        if (this.fvalSW == null && v.length() > 0) {
            this.setValue(v);
        }
        this.setDisabledFieldColor(this.disabledFieldColor);
        this.setReadOnlyFieldColor(this.readOnlyFieldColor);
        this.setMatchingTextColor(this.matchingTextColor);
        tf.setMsgBoxListener(this.msgboxlistener);
    }

    private void sendNtfChangeEvent(short ed1) {
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4100, ed1, 0, true, true, true));
        if (this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).setPreviousFocusOwner(this);
        }
        this.pushEvent(cc);
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    private boolean allowProposals() {
        return this.proposals.size() > 0 && !this.multiline && this.autoDecimal == 0 && !this.readOnly && !this.secure && !this.spinner && !this.autoSpin && this.formatString == null;
    }

    private void selectItemDown() {
        EntryField ef = (EntryField)((Object)this.guiComponent);
        ef.removeTextListener(this.textListener);
        int selIdx = this.proposalList.getSelectedIndex();
        if (selIdx < this.matchingProposals.getSize() - 1) {
            this.selectItemAt(selIdx + 1);
        } else {
            this.selectItemAt(-1);
        }
        ef.addTextListener(this.textListener);
    }

    private void selectItemUp() {
        EntryField ef = (EntryField)((Object)this.guiComponent);
        ef.removeTextListener(this.textListener);
        int selIdx = this.proposalList.getSelectedIndex();
        if (selIdx < 0) {
            this.selectItemAt(this.matchingProposals.getSize() - 1);
        } else if (selIdx > 0) {
            this.selectItemAt(selIdx - 1);
        } else {
            this.selectItemAt(-1);
        }
        ef.addTextListener(this.textListener);
    }

    private void selectItemAt(int selIdx) {
        EntryField ef = (EntryField)((Object)this.guiComponent);
        if (selIdx >= 0) {
            this.proposalList.setSelectedIndex(selIdx);
            this.proposalList.ensureIndexIsVisible(selIdx);
            ef.setText(this.matchingProposals.elementAt(selIdx).toString());
        } else {
            this.proposalList.getSelectionModel().clearSelection();
            ef.setText(this.currText);
        }
    }

    private void showProposalPopup(String text) {
        if (text.length() == 0) {
            if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                this.proposalPopup.setVisible(false);
            }
            return;
        }
        EntryField ef = (EntryField)((Object)this.guiComponent);
        this.currText = text;
        try {
            this.regex = Pattern.compile("(?i)" + this.currText);
        }
        catch (PatternSyntaxException pse) {
            return;
        }
        this.matchingProposals = new DefaultListModel();
        int s = this.proposals.size();
        text = text.toLowerCase();
        if (this.proposalAfterDigits <= 1 || text.length() >= this.proposalAfterDigits) {
            for (int i = 0; i < s; ++i) {
                String p = this.proposals.elementAt(i).toString();
                if (this.proposalFilterType != 0 && (this.proposalFilterType != 1 || !p.toLowerCase().contains(text)) && (this.proposalFilterType != 2 || !p.toLowerCase().startsWith(text))) continue;
                this.matchingProposals.addElement(p);
            }
        }
        if (this.matchingProposals.size() == 0) {
            if (this.proposalPopup != null && this.proposalPopup.isVisible()) {
                this.proposalPopup.setVisible(false);
            }
            return;
        }
        this.proposalPopup = new JPopupMenu();
        this.proposalPopup.setLightWeightPopupEnabled(false);
        this.proposalPopup.setLayout(new GridLayout(1, 0));
        this.proposalList = new JList(this.matchingProposals);
        this.proposalList.enableInputMethods(false);
        this.proposalList.setForeground(ef.getForeground());
        this.proposalList.setBackground(ef.getBackground());
        Font font = ef.getFont();
        this.proposalList.setFont(font);
        int fontHeight = this.proposalList.getFontMetrics(font).getHeight();
        this.proposalList.addMouseListener(IsguiUtility.mousePressedAdapter(e -> {
            int idx = this.proposalList.locationToIndex(e.getPoint());
            if (idx >= 0) {
                boolean en = this.proposalsEnabled;
                this.proposalsEnabled = false;
                ef.setText(this.matchingProposals.elementAt(idx).toString());
                this.proposalsEnabled = en;
            }
            this.proposalPopup.setVisible(false);
        }));
        int rowCount = Math.min(this.matchingProposals.size(), this.visibleProposalCount);
        this.proposalList.setVisibleRowCount(rowCount);
        this.proposalList.setFixedCellHeight(fontHeight);
        JScrollPane sp = new JScrollPane(this.proposalList);
        this.proposalPopup.add(sp);
        Border b = ef.getBorder();
        this.proposalPopup.setBorder(b);
        sp.setBorder(null);
        this.proposalList.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) == 4L && this.proposalList.isShowing()) {
                SwingUtilities.invokeLater(() -> {
                    Dimension d = new Dimension(ef.getWidth(), rowCount * fontHeight);
                    if (sp.getHorizontalScrollBar().isVisible()) {
                        d.height += sp.getHorizontalScrollBar().getSize().height;
                    }
                    sp.setPreferredSize(d);
                    Insets spIns = sp.getInsets();
                    Insets pins = this.proposalPopup.getInsets();
                    d.width = this.guiComponent.getWidth();
                    d.height += spIns.top + spIns.bottom + pins.top + pins.bottom;
                    this.proposalPopup.setPopupSize(d);
                    ef.requestFocus();
                });
            }
        });
        this.renderer = new FastCellRenderer();
        this.renderer.setFont(font);
        this.proposalList.setCellRenderer(this.renderer);
        this.proposalPopup.show(ef, 0, ef.getHeight() - 1);
    }

    private void setOrigBorder(PicobolEntryField ef, Border border) {
        this.origBorder = border;
        ef.setBorder(border);
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
        Rectangle r = this.getBounds();
        viewWidth = r.width;
        viewHeight = r.height;
        PicobolEntryField ef = (PicobolEntryField)this.guiComponent;
        if (viewWidth != 0) {
            this.image = this.getLocalImage(imageId);
            this.bitmapHeight = viewHeight;
        } else {
            this.image = null;
        }
        if (ef != null) {
            ef.setIcon(this.getIcon(this.bitmapNumber));
            ef.setIconDisabled(this.getIcon(this.bitmapDisabled));
            ef.setIconTrailing(this.getIcon(this.bitmapTrailing));
            ef.setIconTrailingDisabled(this.getIcon(this.bitmapTrailingDisabled));
            ef.setIconRollover(this.getIcon(this.bitmapRollover));
            ef.setIconTrailingRollover(this.getIcon(this.bitmapTrailingRollover));
        }
    }

    @Override
    public String setProp(Integer key, String[] values) {
        String Return2 = "0";
        if (values == null) {
            return "0";
        }
        if (key == 266) {
            this.resetProposals();
            for (int i = 0; i < values.length; ++i) {
                this.addProposal(values[i]);
            }
            Return2 = "1";
        }
        return Return2;
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        try {
            intValue = (int)Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        boolean isrgb = false;
        switch (key) {
            case 419: {
                if (error) break;
                this.setTextWrapping(tf, intValue);
                Return2 = "1";
                break;
            }
            case 366: {
                if (error) break;
                if (this.notifyChangeTimer != null) {
                    this.notifyChangeTimer.stop();
                    this.notifyChangeTimer = null;
                }
                if (intValue > 0) {
                    this.notifyChangeTimer = new NotifyChangeTimer(intValue);
                }
                Return2 = "1";
                break;
            }
            case 360: {
                this.spellChecking = value;
                if (tf != null) {
                    tf.setSpellChecking(this.spellChecking);
                }
                Return2 = SpellChecker.isSupported() ? "1" : "0";
                break;
            }
            case 20: {
                if (error) break;
                this.bitmapWidth = intValue;
                Return2 = "1";
                break;
            }
            case 12: {
                if (error) break;
                this.bitmapNumber = intValue;
                if (tf != null) {
                    tf.setIcon(this.getIcon(this.bitmapNumber));
                }
                Return2 = "1";
                break;
            }
            case 14: {
                if (error) break;
                this.bitmapRollover = intValue;
                if (tf != null) {
                    tf.setIconRollover(this.getIcon(this.bitmapRollover));
                }
                Return2 = "1";
                break;
            }
            case 364: {
                if (error) break;
                this.bitmapTrailingRollover = intValue;
                if (tf != null) {
                    tf.setIconTrailingRollover(this.getIcon(this.bitmapTrailingRollover));
                }
                Return2 = "1";
                break;
            }
            case 362: {
                this.bitmapHint = value;
                if (tf != null) {
                    tf.setIconHint(this.bitmapHint);
                }
                Return2 = "1";
                break;
            }
            case 363: {
                this.bitmapTrailingHint = value;
                if (tf != null) {
                    tf.setIconTrailingHint(this.bitmapTrailingHint);
                }
                Return2 = "1";
                break;
            }
            case 358: {
                if (error) break;
                this.bitmapTrailing = intValue;
                if (tf != null) {
                    tf.setIconTrailing(this.getIcon(this.bitmapTrailing));
                }
                Return2 = "1";
                break;
            }
            case 8: {
                if (error) break;
                this.bitmapDisabled = intValue;
                if (tf != null) {
                    tf.setIconDisabled(this.getIcon(this.bitmapDisabled));
                }
                Return2 = "1";
                break;
            }
            case 359: {
                if (error) break;
                this.bitmapTrailingDisabled = intValue;
                if (tf != null) {
                    tf.setIconTrailingDisabled(this.getIcon(this.bitmapTrailingDisabled));
                }
                Return2 = "1";
                break;
            }
            case 325: 
            case 326: {
                isrgb = key.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (intValue < 0 || isrgb) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(intValue);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(intValue);
                    this.borderColorIdx = intValue;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                if (!this.isBoxed()) break;
                this.setBoxedStyle();
                break;
            }
            case 299: {
                String trim;
                this.validationErrmsg = value != null && (trim = value.trim()).length() > 0 ? trim : null;
                Return2 = "1";
                break;
            }
            case 300: {
                String trim;
                this.validationRegexp = value != null && (trim = value.trim()).length() > 0 ? trim : null;
                Return2 = "1";
                break;
            }
            case 301: {
                if (intValue < 0) break;
                this.validationOpts = intValue;
                Return2 = "1";
                break;
            }
            case 266: {
                this.addProposal(value);
                Return2 = "1";
                break;
            }
            case 268: {
                if (intValue <= 0 || error || !this.removeProposal(intValue - 1)) break;
                Return2 = "1";
                break;
            }
            case 323: {
                if (intValue == 0 || error) break;
                this.proposalAfterDigits = intValue;
                Return2 = "1";
                break;
            }
            case 267: {
                if (intValue == 0 || error) break;
                this.resetProposals();
                Return2 = "1";
                break;
            }
            case 271: {
                if (intValue == 0 || error) break;
                this.visibleProposalCount = Math.max(1, intValue);
                Return2 = "1";
                break;
            }
            case 269: {
                if (intValue == 0 || error) break;
                this.proposalIndex = Math.max(0, intValue);
                Return2 = "1";
                break;
            }
            case 471: {
                if (intValue == this.proposalFilterType || error) break;
                this.proposalFilterType = intValue;
                Return2 = "1";
                break;
            }
            case 272: {
                if (intValue == 0 || error) break;
                intValue = Math.max(0, intValue);
                this.proposalTimer.setInitialDelay(intValue);
                if (intValue != this.initialDelay) {
                    this.initialDelay = intValue;
                    this.proposalTimer.restart();
                }
                Return2 = "1";
                break;
            }
            case 304: {
                if (intValue == 0 || error) break;
                this.textOrientation = Math.max(0, intValue);
                if (tf != null) {
                    switch (this.textOrientation) {
                        default: {
                            tf.setComponentOrientation(ComponentOrientation.UNKNOWN);
                            break;
                        }
                        case 1: {
                            tf.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                            break;
                        }
                        case 2: {
                            tf.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                        }
                    }
                }
                Return2 = "1";
                break;
            }
            case 145: {
                this.maxLines = intValue;
                if (tf != null) {
                    tf.setMaxLines(this.maxLines);
                }
                Return2 = "1";
                break;
            }
            case 147: {
                if (error) break;
                this.maxText = intValue;
                if (tf != null) {
                    tf.setMaxText(this.maxText);
                }
                Return2 = "1";
                break;
            }
            case 216: {
                this.selectionText = value;
                if (tf != null) {
                    boolean b = this.caretListenerEnabled;
                    this.caretListenerEnabled = false;
                    tf.replaceSelection(this.selectionText);
                    this.caretListenerEnabled = b;
                }
                Return2 = "1";
                break;
            }
            case 59: {
                if (error) break;
                this.cursorPos = intValue;
                boolean b = this.caretListenerEnabled;
                this.caretListenerEnabled = false;
                if (this.cursorPos == -1 && tf != null) {
                    tf.selectAll();
                } else {
                    this.setCursorPos();
                }
                this.caretListenerEnabled = b;
                Return2 = "1";
                break;
            }
            case 60: {
                if (error) break;
                this.cursorRowPos = intValue;
                Return2 = "1";
                break;
            }
            case 54: {
                if (error) break;
                this.cursorColPos = intValue;
                this.setCursorRowColPos();
                Return2 = "1";
                break;
            }
            case 3: {
                if (error) break;
                this.setStyle(147456, true);
                this.autoDecimal = intValue;
                Return2 = "1";
                break;
            }
            case 1: {
                if (error) break;
                this.setAction(intValue);
                Return2 = "1";
                break;
            }
            case 148: {
                if (error) break;
                this.maxValue = intValue;
                if (tf != null) {
                    tf.setMaxValue(this.maxValue);
                }
                Return2 = "1";
                break;
            }
            case 152: {
                if (error) break;
                this.minValue = intValue;
                if (tf != null) {
                    tf.setMinValue(this.minValue);
                }
                Return2 = "1";
                break;
            }
            case 96: {
                this.formatString = value;
                if (tf != null) {
                    tf.setFormatString(ScreenUtility.rightTrim(this.formatString));
                }
                Return2 = "1";
                break;
            }
            case 89: {
                if (value.length() <= 0) break;
                this.fillChar = value.charAt(0);
                if (tf != null) {
                    tf.setFillChar(this.fillChar);
                }
                Return2 = "1";
                break;
            }
            case 97: {
                value = value.trim();
                this.formatType = value.equals("NUMERIC") ? 1 : (value.equals("DATE") ? 2 : 0);
                if (tf != null) {
                    tf.setFormatType(this.formatType);
                }
                Return2 = "1";
                break;
            }
            case 257: {
                this.valueMultiple = Boolean.valueOf(value);
                break;
            }
            case 324: {
                this.placeholder = value.trim();
                if (tf != null) {
                    tf.setPlaceholder(this.placeholder);
                }
                Return2 = "1";
                break;
            }
            case 374: {
                this.handleBorderWidths(value);
                if (!this.isBoxed() || this._3d) break;
                this.setBoxedStyle();
                break;
            }
            case 422: {
                try {
                    this.handleBorderWidths(value, this.marginWidths);
                }
                catch (NumberFormatException ex) {
                    this.marginWidths.clear();
                }
                this.setMargins(true);
                break;
            }
            case 436: {
                this.setInputFilter(value);
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    private void setMargins(boolean update) {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            tf.setMargins(new Insets(this.getBorder(this.marginWidths, 0), this.getBorder(this.marginWidths, 1), this.getBorder(this.marginWidths, 2), this.getBorder(this.marginWidths, 3)), update);
        }
    }

    private void setTextWrapping(EntryField tf, int tw) {
        this.textWrapping = tw;
        if (tf != null && tf.getTextComponent() instanceof JTextArea) {
            JTextArea ta = (JTextArea)tf.getTextComponent();
            switch (this.textWrapping) {
                default: {
                    ta.setWrapStyleWord(!this.isNational);
                    break;
                }
                case 1: {
                    ta.setWrapStyleWord(true);
                    break;
                }
                case 2: {
                    ta.setWrapStyleWord(false);
                }
            }
        }
    }

    private ImageIcon getIcon(int strip) {
        if (strip > 0) {
            Image imageStrip = ScreenUtility.getImage(this.bitmapWidth, this.bitmapHeight, this.image, strip);
            if (imageStrip != null) {
                return new ImageIcon(imageStrip);
            }
            return null;
        }
        return null;
    }

    @Override
    protected void setAction(int actionValue) {
        this.action = actionValue;
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            switch (this.action) {
                case 2: {
                    if (!tf.hasSelection()) break;
                    tf.copy();
                    break;
                }
                case 3: {
                    if (!ScreenUtility.canPaste(EntryField.class)) break;
                    tf.paste();
                    break;
                }
                case 1: {
                    if (!tf.hasSelection()) break;
                    tf.cut();
                    break;
                }
                case 4: {
                    tf.replaceSelection("");
                    break;
                }
                case 5: {
                    if (!tf.canUndo()) break;
                    tf.undo();
                    break;
                }
                case 6: {
                    if (!tf.canRedo()) break;
                    tf.redo();
                    break;
                }
                case 7: {
                    boolean b = this.caretListenerEnabled;
                    this.caretListenerEnabled = false;
                    tf.selectAll();
                    this.caretListenerEnabled = b;
                    break;
                }
                default: {
                    super.setAction(actionValue);
                }
            }
        }
    }

    @Override
    public void setRowsCols(float r, float c) {
        this.rows = r < 1.0f ? 1.0f : r;
        this.cols = c < 1.0f ? 1.0f : c;
        if (this.maxText == -1 && r > 0.0f && c > 0.0f) {
            this.maxText = (int)r * (int)c;
        }
    }

    @Override
    public void setCols(float c) {
        this.setRowsCols(this.rows, c);
    }

    @Override
    public void setRows(float r) {
        this.setRowsCols(r, this.cols);
    }

    @Override
    public void setnewStyle(long s) {
        PicobolEntryField tc = (PicobolEntryField)this.guiComponent;
        if ((s & 0x200000L) == 0x200000L) {
            if (!this.noWrap) {
                this.noWrap = true;
                if (tc != null) {
                    tc.setNoWrap(this.noWrap);
                }
            }
        } else if (this.noWrap) {
            this.noWrap = false;
            if (tc != null) {
                tc.setNoWrap(this.noWrap);
            }
        }
        this.hasVScrollbar = (s & 0xE0L) == 224L;
        if ((s & 0x20000L) == 131072L) {
            if (!this.isNumeric) {
                this.isNumeric = true;
                if (tc != null) {
                    tc.setNumeric(this.isNumeric);
                }
            }
        } else if (this.isNumeric) {
            this.isNumeric = false;
            if (tc != null) {
                tc.setNumeric(this.isNumeric);
            }
        }
        this.notifyChange = (s & 0x8000L) == 32768L;
        if ((s & 0x800L) == 2048L) {
            if (!this.lower) {
                this.lower = true;
                if (tc != null) {
                    tc.setLower(this.lower);
                }
            }
        } else if (this.lower) {
            this.lower = false;
            if (tc != null) {
                tc.setLower(this.lower);
            }
        }
        if ((s & 0x400L) == 1024L) {
            if (!this.upper) {
                this.upper = true;
                if (tc != null) {
                    tc.setUpper(this.upper);
                }
            }
        } else if (this.upper) {
            this.upper = false;
            if (tc != null) {
                tc.setUpper(this.upper);
            }
        }
        if ((s & 0x100L) == 256L) {
            if (!this.useReturn) {
                this.useReturn = true;
                if (tc != null) {
                    tc.setUseReturn(this.useReturn);
                }
            }
        } else if (this.useReturn) {
            this.useReturn = false;
            if (tc != null) {
                tc.setUseReturn(this.useReturn);
            }
        }
        if ((s & 0x200L) == 512L) {
            if (!this.useTab) {
                this.useTab = true;
                if (tc != null) {
                    tc.setUseTab(this.useTab);
                }
            }
        } else if (this.useTab) {
            this.useTab = false;
            if (tc != null) {
                tc.setUseTab(this.useTab);
            }
        }
        if ((s & 0x2000L) == 8192L) {
            if (!this.readOnly) {
                this.readOnly = true;
                if (tc != null) {
                    tc.setReadOnly(this.readOnly, this.readOnlyCursor);
                }
            }
        } else if (this.readOnly) {
            this.readOnly = false;
            if (tc != null) {
                tc.setReadOnly(this.readOnly, this.readOnlyCursor);
            }
        }
        this.multiline = (s & 0x20L) == 32L;
        if ((s & 0x10000L) == 65536L) {
            if (!this.secure) {
                this.secure = true;
                if (tc != null && !this.multiline) {
                    tc.setSecure(this.secure, '*');
                }
            }
        } else if (this.secure) {
            this.secure = false;
            if (tc != null && !this.multiline) {
                tc.setSecure(this.secure, '*');
            }
        }
        this.proposalsUnsorted = (s & 0x100000L) == 0x100000L;
        this.noautosel = (s & 0x1000L) == 4096L;
        if ((s & 0x4000L) == 16384L) {
            if (!this.autoTermination) {
                this.autoTermination = true;
                if (tc != null) {
                    tc.setAuto(this.autoTermination);
                }
            }
        } else if (this.autoTermination) {
            this.autoTermination = false;
            if (tc != null) {
                tc.setAuto(this.autoTermination);
            }
        }
        if (!this.multiline) {
            if ((s & 4L) == 4L) {
                if (this.alignment != 0) {
                    this.alignment = 0;
                    if (tc != null && !this.multiline) {
                        tc.setHorizontalAlignment(this.alignment);
                    }
                }
            } else if (this.alignment == 0) {
                this.alignment = 2;
                if (tc != null) {
                    tc.setHorizontalAlignment(this.alignment);
                }
            }
            if ((s & 2L) == 2L) {
                if (this.alignment != 4) {
                    this.alignment = 4;
                    if (tc != null) {
                        tc.setHorizontalAlignment(this.alignment);
                    }
                }
            } else if (this.alignment == 4) {
                this.alignment = 2;
                if (tc != null) {
                    tc.setHorizontalAlignment(this.alignment);
                }
            }
            if ((s & 1L) == 1L) {
                if (this.alignment != 2) {
                    this.alignment = 2;
                    if (tc != null) {
                        tc.setHorizontalAlignment(this.alignment);
                    }
                }
            } else if (this.alignment == 2) {
                this.alignment = 2;
                if (tc != null) {
                    tc.setHorizontalAlignment(this.alignment);
                }
            }
            if ((s & 0x40040L) == 262208L) {
                if (!this.autoSpin) {
                    this.autoSpin = true;
                    if (tc != null) {
                        tc.setAutoSpin(this.autoSpin);
                    }
                }
            } else if (this.autoSpin) {
                this.autoSpin = false;
                if (tc != null) {
                    tc.setAutoSpin(this.autoSpin);
                }
            }
        }
        this.spinner = (s & 0x40000L) == 262144L;
        if ((s & 8L) == 8L) {
            if (!this.boxed) {
                this.boxed = true;
                this.setBoxedStyle();
            }
        } else if (this.boxed) {
            this.boxed = false;
        }
        if ((s & 0x10L) == 16L) {
            if (!this.noBox) {
                this.noBox = true;
                this.setNoboxStyle();
            }
        } else if (this.noBox) {
            this.noBox = false;
        }
        if ((s & 0x2000000L) == 0x2000000L) {
            if (!this._3d) {
                this._3d = true;
                this.set3DStyle();
            }
        } else if (this._3d) {
            this._3d = false;
        }
        this.required = (s & 0x80000L) == 524288L;
        if ((s & 0x400000L) == 0x400000L) {
            this.setStyleDPC(true);
        }
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolEntryField tc = (PicobolEntryField)this.guiComponent;
        if ((s & 0x200000) == 0x200000) {
            this.noWrap = set;
            if (tc != null) {
                tc.setNoWrap(this.noWrap);
            }
        }
        if ((s & 0xE0) == 224) {
            this.hasVScrollbar = set;
        }
        if ((s & 0x20000) == 131072) {
            this.isNumeric = set;
            if (tc != null) {
                tc.setNumeric(this.isNumeric);
            }
        }
        if ((s & 0x8000) == 32768) {
            this.notifyChange = set;
        }
        if ((s & 0x800) == 2048) {
            this.lower = set;
            if (tc != null) {
                tc.setLower(this.lower);
            }
        }
        if ((s & 0x400) == 1024) {
            this.upper = set;
            if (tc != null) {
                tc.setUpper(this.upper);
            }
        }
        if ((s & 0x100) == 256) {
            this.useReturn = set;
            if (tc != null) {
                tc.setUseReturn(this.useReturn);
            }
        }
        if ((s & 0x200) == 512) {
            this.useTab = set;
            if (tc != null) {
                tc.setUseTab(this.useTab);
            }
        }
        if ((s & 0x2000) == 8192) {
            this.readOnly = set;
            if (tc != null) {
                tc.setReadOnly(this.readOnly, this.readOnlyCursor);
            }
        }
        if ((s & 0x10000) == 65536) {
            this.secure = set;
            if (tc != null && !this.multiline) {
                tc.setSecure(this.secure, '*');
            }
        }
        if ((s & 0x100000) == 0x100000) {
            this.proposalsUnsorted = set;
        }
        if ((s & 0x4000) == 16384) {
            this.autoTermination = set;
            if (tc != null && !this.multiline) {
                tc.setAuto(this.autoTermination);
            }
        }
        if ((s & 0x1000) == 4096) {
            this.noautosel = set;
        }
        if ((s & 4) == 4 && !this.multiline) {
            this.alignment = set ? 0 : 2;
            if (tc != null && !this.multiline) {
                tc.setHorizontalAlignment(this.alignment);
            }
        }
        if ((s & 2) == 2 && !this.multiline) {
            this.alignment = set ? 4 : 2;
            if (tc != null && !this.multiline) {
                tc.setHorizontalAlignment(this.alignment);
            }
        }
        if ((s & 1) == 1 && !this.multiline) {
            this.alignment = set ? 2 : 2;
            if (tc != null) {
                tc.setHorizontalAlignment(this.alignment);
            }
        }
        if ((s & 0x20) == 32) {
            this.multiline = set;
        }
        if ((s & 0x40000) == 262144) {
            this.spinner = set;
        }
        if ((s & 0x40040) == 262208) {
            this.autoSpin = set;
            if (tc != null && !this.multiline) {
                tc.setAutoSpin(set);
            }
        }
        if ((s & 8) == 8) {
            this.boxed = set;
            if (set) {
                this.setBoxedStyle();
            }
        }
        if ((s & 0x10) == 16) {
            this.noBox = set;
            if (set) {
                this.setNoboxStyle();
            }
        }
        if ((s & 0x2000000) == 0x2000000) {
            this._3d = set;
            if (set) {
                this.set3DStyle();
            }
        }
        if ((s & 0x80000) == 524288) {
            this.required = set;
        }
    }

    @Override
    public void setTitle(String v) {
    }

    protected void setBoxedStyle() {
        PicobolEntryField ef = (PicobolEntryField)this.guiComponent;
        if (ef != null) {
            Border border = this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : (this.useDefaultBorderWithBoxedStyle ? ef.getDefaultBorder() : BorderFactory.createLineBorder(Color.darkGray));
            if (this.borderWidths != null && this.borderWidths.size() > 0) {
                this.setOrigBorder(ef, new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray));
            } else {
                this.setOrigBorder(ef, border);
            }
        }
    }

    protected void setNoboxStyle() {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            this.setOrigBorder(tf, null);
        }
    }

    private void set3DStyle() {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            this.setOrigBorder(tf, BorderFactory.createLoweredBevelBorder());
        }
    }

    @Override
    public String refreshValue(String v) {
        return this.intsetValue(v, false);
    }

    @Override
    public String setValue(String val) {
        return this.intsetValue(val, true);
    }

    @Override
    protected void intsetValue(ParamVector Return2, String val) {
        this.textValue = val;
        val = ScreenUtility.truncAtFirstLowValue(ScreenUtility.rightTrim(val));
        if (this.parentWindow != null) {
            this.fvalSW = val;
            this.checkSW = true;
            this.parentWindow.initializecontrolSW.add(this);
            if (val != null) {
                Return2.addElement(new ParamElementString(1012, val));
            }
        } else {
            super.intsetValue(Return2, val);
        }
    }

    private String intsetValue(String val, boolean check) {
        boolean same;
        this.textValue = val;
        val = ScreenUtility.truncAtFirstLowValue(ScreenUtility.rightTrim(val));
        if (check && this.guiComponent != null) {
            String oldVal = this.getValue();
            same = ScreenUtility.rightTrim(oldVal).equals(val);
            if (same) {
                val = oldVal;
            }
        } else {
            same = false;
        }
        String fval = val;
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (this.guiComponent != null) {
            int savepos = tf.getCaretPosition();
            new SwingWorker(true, () -> {
                boolean b = this.caretListenerEnabled;
                this.caretListenerEnabled = false;
                tf.setAllText(fval);
                if (!same || savepos < 0) {
                    this.loadcursor();
                } else {
                    tf.setCaretPosition(savepos);
                }
                this.caretListenerEnabled = b;
            }).start();
        }
        return fval;
    }

    @Override
    public void initializecontrolSW() {
        if (this.fvalSW != null) {
            boolean same;
            if (this.checkSW && this.guiComponent != null) {
                String oldVal = this.getValuenoSW();
                same = ScreenUtility.rightTrim(oldVal).equals(this.fvalSW);
                if (same) {
                    this.fvalSW = oldVal;
                }
            } else {
                same = false;
            }
            PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
            int savepos = tf.getCaretPosition();
            boolean b = this.caretListenerEnabled;
            this.caretListenerEnabled = false;
            tf.setAllText(this.fvalSW);
            if (!same || savepos < 0) {
                this.loadcursor(true);
            } else {
                tf.setCaretPosition(savepos);
            }
            this.caretListenerEnabled = b;
            this.fvalSW = null;
        }
    }

    private void addProposal(String prop) {
        if (prop == null) {
            return;
        }
        if ((prop = ScreenUtility.rightTrim(prop)).length() == 0) {
            return;
        }
        if (this.proposalIndex > 0) {
            if (this.proposalIndex <= this.proposals.size()) {
                this.proposals.add(this.proposalIndex - 1, prop);
            } else {
                this.proposals.addElement(prop);
            }
        } else if (this.proposalsUnsorted) {
            this.proposals.addElement(prop);
        } else {
            this.proposals.add(ScreenUtility.getInsertionIndex(this.proposals, prop, ignoreCaseComparator), prop);
        }
    }

    private boolean removeProposal(int idx) {
        if (idx >= 0 && idx < this.proposals.size()) {
            this.proposals.removeElementAt(idx);
            return true;
        }
        return false;
    }

    private void resetProposals() {
        this.proposals.clear();
    }

    @Override
    public void destroy() {
        PicobolEntryField tf;
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        if ((tf = (PicobolEntryField)this.guiComponent) != null && this.borderManager != null) {
            tf.removeMouseListener(this.borderManager);
        }
        this.pcListener = null;
        if (tf != null) {
            tf.removeTextListener(this.textListener);
        }
        if (tf != null && this.caretListener != null) {
            tf.getTextComponent().getCaret().removeChangeListener(this.caretListener);
        }
        this.textListener = null;
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        super.handleResponse(eventAction, rra);
        if ((rra.getEventType() == 16416 || rra.getEventType() == 16417) && this.autoSpin && eventAction != 4) {
            PicobolEntryField ef = (PicobolEntryField)this.guiComponent;
            new IsguiWorker(false, () -> ef.updateValue()).start();
        }
    }

    private void setCursorRowColPos() {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            if (this.cursorRowPos == 0) {
                this.cursorPos = 0;
                this.setCursorPos();
                return;
            }
            int[][] rowIdxs = tf.getLineOffsets();
            if (rowIdxs.length == 0) {
                return;
            }
            this.cursorPos = 1;
            int currLine = 0;
            if (this.cursorRowPos > rowIdxs.length) {
                currLine = rowIdxs.length - 1;
                this.cursorPos = rowIdxs[currLine][1] + 1;
            } else {
                int currLineLen;
                if (this.cursorRowPos > 0) {
                    currLine = this.cursorRowPos - 1;
                    this.cursorPos = rowIdxs[currLine][0];
                }
                this.cursorPos = this.cursorColPos > (currLineLen = rowIdxs[currLine][1] - rowIdxs[currLine][0]) ? (this.cursorPos += currLineLen + 1) : (this.cursorColPos > 0 ? (this.cursorPos += this.cursorColPos) : ++this.cursorPos);
            }
            this.setCursorPos();
        }
    }

    private void setCursorPos() {
        PicobolEntryField tf;
        if (this.cursorPos == 0) {
            this.cursorPos = 1;
        }
        if ((tf = (PicobolEntryField)this.guiComponent) != null) {
            boolean b = this.caretListenerEnabled;
            this.caretListenerEnabled = false;
            try {
                tf.setCaretPosition(this.cursorPos - 1);
            }
            catch (IllegalArgumentException e) {
                tf.setCaretPosition(tf.getText().length());
            }
            this.caretListenerEnabled = b;
        }
    }

    private void updateCursorProps() {
        new SwingWorker(true, () -> {
            PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
            if (tf != null) {
                int cp = tf.getCaretPosition();
                this.cursorPos = cp + 1;
                int[][] rowIdxs = tf.getLineOffsets();
                int curLine = 0;
                int i = 0;
                while (i < rowIdxs.length && cp > rowIdxs[i][1]) {
                    ++i;
                    ++curLine;
                }
                this.cursorRowPos = curLine + 1;
                this.cursorColPos = cp;
                this.cursorColPos = curLine > 0 ? (this.cursorColPos -= rowIdxs[curLine - 1][1]) : ++this.cursorColPos;
            }
        }).start();
    }

    private void updateSelectionStartProps() {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            if (tf.hasSelection()) {
                int st = tf.getSelectionStart();
                if (st == tf.getCaretPosition()) {
                    st = tf.getSelectionEnd() - 1;
                }
                this.selStart = st + 1;
                int[][] rowIdxs = tf.getLineOffsets();
                int curLine = 0;
                int i = 0;
                while (i < rowIdxs.length && st > rowIdxs[i][1]) {
                    ++i;
                    ++curLine;
                }
                this.selStartRow = curLine + 1;
                this.selStartCol = st;
                this.selStartCol = curLine > 0 ? (this.selStartCol -= rowIdxs[curLine - 1][1]) : ++this.selStartCol;
            } else {
                this.selStartRow = 0;
                this.selStartCol = 0;
                this.selStart = 0;
            }
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v) {
            boolean b = this.caretListenerEnabled;
            this.caretListenerEnabled = false;
            this.loadcursor();
            this.caretListenerEnabled = b;
        }
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        super.setSize(w, h, setOnComp);
        if (this.maxText == -1) {
            int lines = (h - this.heightInset) / this.font.getHeight();
            if (lines == 0) {
                lines = 1;
            }
            this.maxText = (w - this.widthInset) / this.font.getWidth() * lines;
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    protected boolean isBoxed() {
        return this.boxed || !this._3d && !this.noBox && !this.gf.getFieldsUnboxed();
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        if (ps.ccPIClen != -1) {
            return ps.ccPIClen;
        }
        if (ps.ccOlen != -1) {
            return ps.ccOlen;
        }
        if (ps.ccIlen != -1) {
            return ps.ccIlen;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    private void loadcursor() {
        this.loadcursor(false);
    }

    private void loadcursor(boolean alreadyinqueueevent) {
        if (this.guiComponent != null) {
            if (this.cursorRowPos > 0 || this.cursorColPos > 0) {
                this.guiComponent.validate();
                this.setCursorRowColPos();
            } else if (this.cursorPos > 0) {
                this.guiComponent.validate();
                this.setCursorPos();
            } else if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getPreviousFocusOwner() != this) {
                if (alreadyinqueueevent) {
                    ((PicobolEntryField)this.guiComponent).setCaretPosition(0);
                } else {
                    new SwingWorker(true, () -> ((PicobolEntryField)this.guiComponent).setCaretPosition(0)).start();
                }
            }
        }
    }

    @Override
    public String getType() {
        if (this.multiline) {
            return "textarea";
        }
        if (this.spinner) {
            return "spinner";
        }
        return "entryfield";
    }

    private void setconfigBF() {
        if (this.guiComponent != null && !this.readOnly) {
            if (this.configBcolor != null) {
                this.guiComponent.setBackground(this.gf.getRemotePalette().getDefaultColor(this.configBcolor));
            }
            if (this.configFcolor != null) {
                this.guiComponent.setForeground(this.gf.getRemotePalette().getDefaultColor(this.configFcolor));
            }
            if (this.configFocusBorder != null) {
                // empty if block
            }
        }
    }

    private void restoreBF() {
        if (this.guiComponent != null && !this.readOnly) {
            Color c;
            if (this.configBcolor != null && (c = this.getOriginalBackground()) != null) {
                this.guiComponent.setBackground(c);
            }
            if (this.configFcolor != null && (c = this.getOriginalForeground()) != null) {
                this.guiComponent.setForeground(c);
            }
        }
    }

    private Color getOriginalBackground() {
        Color Return2 = this.getBackground();
        if (Return2 == null) {
            Return2 = this.defaultBackground;
        }
        return Return2;
    }

    private Color getOriginalForeground() {
        Color Return2 = this.getForeground();
        if (Return2 == null) {
            Return2 = this.defaultForeground;
        }
        return Return2;
    }

    @Override
    public boolean bufferedOutAcceptEvent(OutAcceptEvent e) {
        return this.bufferedOutAcceptEvent(e, false);
    }

    @Override
    public void setColorBackgroundIdx(int idx) {
        boolean oldVal = this.backgroundSet;
        super.setColorBackgroundIdx(idx);
        boolean bl = this.backgroundSet = this.getBackground() != null;
        if (oldVal != this.backgroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorBackground(int r, int g, int b) {
        boolean oldVal = this.backgroundSet;
        super.setColorBackground(r, g, b);
        boolean bl = this.backgroundSet = this.getBackground() != null;
        if (oldVal != this.backgroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForegroundIdx(int idx) {
        boolean oldVal = this.foregroundSet;
        super.setColorForegroundIdx(idx);
        boolean bl = this.foregroundSet = this.getForeground() != null;
        if (oldVal != this.foregroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForeground(int r, int g, int b) {
        boolean oldVal = this.foregroundSet;
        super.setColorForeground(r, g, b);
        boolean bl = this.foregroundSet = this.getForeground() != null;
        if (oldVal != this.foregroundSet) {
            this.setReadOnlyFieldColor(this.readOnlyFieldColor);
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void startCellEditing(boolean columnisalwaysshow, MouseEvent me) {
        PicobolEntryField ef = (PicobolEntryField)this.guiComponent;
        if (ef != null && ef.getTextComponent() != null) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(SwingUtilities.convertMouseEvent((Component)me.getSource(), me, ef.getTextComponent()));
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean removelistener, Dimension scalebitmaptosize) {
        RemoteEntryField clone = null;
        try {
            clone = (RemoteEntryField)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setComponent(null);
        clone.initialize();
        return clone;
    }

    @Override
    public void intKeyPressed(int cobFun, boolean auto, String hotKeyStr) {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (rdw == null || (cobFun & 0x300000) == 0x300000) {
            return;
        }
        if (VirtualKeyboard.isScreenEditing(cobFun) && this.isControlEditor() && auto && this.guiComponent != null) {
            if (((PicobolEntryField)this.guiComponent).getTextComponent() != null && ((PicobolEntryField)this.guiComponent).getTextComponent().getListeners(KeyListener.class) != null && ((KeyListener[])((PicobolEntryField)this.guiComponent).getTextComponent().getListeners(KeyListener.class)).length > 0) {
                KeyListener[] earray = (KeyListener[])((PicobolEntryField)this.guiComponent).getTextComponent().getListeners(KeyListener.class);
                if (earray != null) {
                    for (int i = 0; i < earray.length; ++i) {
                        earray[i].keyPressed(new KeyEvent((Component)((Object)this.guiComponent), 401, 0L, 0, 9, '\t'));
                    }
                    CobolFocusable grd = rdw.getFocusOwner();
                    if (grd != null && grd instanceof RemoteGrid) {
                        ((RemoteGrid)grd).stopCellEditing();
                    }
                }
                return;
            }
        } else {
            super.intKeyPressed(cobFun, auto, hotKeyStr);
        }
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle Return2 = super.getBounds();
        if (Return2 != null && Return2.width > 0) {
            Return2.width -= 10;
        }
        return Return2;
    }

    @Override
    public RemoteRecordAccept getDragRRA() {
        return new RemoteRecordAccept(7, 0, 17042, (short)this.cursorPos, 0, false, false, true);
    }

    @Override
    public RemoteRecordAccept getDropRRA(Point p) {
        return new RemoteRecordAccept(7, 0, 17043, (short)p.x, 0, false, false, true);
    }

    @Override
    public JComponent getDragDropComponent() {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            return tf.getDragDropComponent();
        }
        return null;
    }

    @Override
    public boolean isDnDStandard() {
        return true;
    }

    @Override
    public void initializeDnDStandard() {
        PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
        if (tf != null) {
            if (this.dragmode > 0) {
                tf.setDragComponent(this);
            } else {
                tf.setDragComponent(null);
            }
        }
    }

    private void setInputFilter(String ifstr) {
        if (this.inputFilter == null || !this.inputFilter.equals(ifstr)) {
            PicobolEntryField tf = (PicobolEntryField)this.guiComponent;
            this.inputFilter = ifstr;
            if (tf != null) {
                tf.setInputFilter(this.inputFilter);
            }
        }
    }

    private boolean checkMinMax(String txt) {
        if (this.minValue != 0 || this.maxValue != 0) {
            String errorMessage = null;
            double n = 0.0;
            try {
                n = Double.parseDouble(txt.replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n < (double)this.minValue || n > (double)this.maxValue) {
                errorMessage = Factory.getSysMsg("ef_out_of_range_msg_part1") + " " + this.minValue + " " + Factory.getSysMsg("ef_out_of_range_msg_part2") + " " + this.maxValue;
                if (this.msgboxlistener != null) {
                    this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this.guiComponent, errorMessage, Factory.getSysMsg("ef_error_msg_title")));
                }
                return false;
            }
        }
        return true;
    }

    protected LocalFontCmp getFontCmp() {
        EntryField ef = (EntryField)((Object)this.guiComponent);
        Font font = ef.getFont();
        if (font != null) {
            return new SwingFontCmp(this.gf, font);
        }
        return null;
    }

    private void setStyleDPC(boolean b) {
        this.styleDPC = b;
    }

    private class FastCellRenderer
    extends JLabel
    implements ListCellRenderer {
        String tmatcher;
        Matcher matcher;
        LocalFontCmp fcmp;

        private FastCellRenderer() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (RemoteEntryField.this.proposalFilterType > 0) {
                this.fcmp = RemoteEntryField.this.getFontCmp();
                this.tmatcher = null;
                this.matcher = RemoteEntryField.this.regex.matcher("");
                this.printMatcher(g, this.getText(), this.getWidth(), 0, this.fcmp.getAscent(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }

        private void printMatcher(Graphics g, String tk, int cwidth, int textX, int textY, int height) {
            int ofsmatchstart = -1;
            int ofsmatchend = -1;
            String t = tk;
            if (t != null && t.length() > 0) {
                boolean go = false;
                int matcherstart = -1;
                int matcherend = -1;
                if (this.matcher != null) {
                    this.matcher.reset(t);
                    if (this.matcher.find()) {
                        matcherstart = this.matcher.start();
                        matcherend = this.matcher.end();
                        this.tmatcher = this.matcher.group();
                        go = true;
                    }
                }
                if (go) {
                    String t0 = "";
                    String t1 = "";
                    String t2 = "";
                    try {
                        t0 = t.substring(0, matcherstart);
                        t1 = t.substring(matcherstart, matcherend);
                        t2 = t.substring(matcherend, t.length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    FontMetrics fm = this.fcmp.getFontMetrics();
                    ofsmatchstart = SwingUtilities.computeStringWidth(fm, t0);
                    ofsmatchend = SwingUtilities.computeStringWidth(fm, this.tmatcher);
                    int textX2 = textX + ofsmatchstart;
                    if (textX2 > 0) {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, textX2, height);
                    }
                    g.setColor(this.getForeground());
                    g.drawString(t0, textX, textY);
                    g.setColor(RemoteEntryField.this.matchingTextColorBackground);
                    g.fillRect(textX + ofsmatchstart, 0, ofsmatchend, height);
                    textX2 = textX + ofsmatchstart + ofsmatchend;
                    if (textX2 < cwidth) {
                        g.setColor(this.getBackground());
                        g.fillRect(textX2, 0, cwidth - textX2, height);
                    }
                    if (RemoteEntryField.this.matchingTextColorForeground != null) {
                        g.setColor(RemoteEntryField.this.matchingTextColorForeground);
                    } else {
                        g.setColor(this.getForeground());
                    }
                    g.drawString(t1, textX + ofsmatchstart, textY);
                    g.setColor(this.getForeground());
                    g.drawString(t2, textX + ofsmatchstart + ofsmatchend, textY);
                } else {
                    g.drawString(t, textX, textY);
                }
            } else {
                g.drawString(t, textX, textY);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color fg;
            Color bg;
            if (isSelected) {
                bg = list.getSelectionBackground();
                fg = list.getSelectionForeground();
            } else {
                bg = list.getBackground();
                fg = list.getForeground();
            }
            if (!list.isEnabled()) {
                bg = bg.darker();
                fg = fg.darker();
            }
            this.setBackground(bg);
            this.setForeground(fg);
            this.setText((String)value);
            return this;
        }
    }

    private class RolloverBorderManager
    extends MouseAdapter {
        Border mouseEnterBorder;
        Border mouseExitBorder;

        RolloverBorderManager(Border mouseEnterBorder) {
            this.mouseEnterBorder = mouseEnterBorder;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (RemoteEntryField.this.guiComponent != null) {
                EntryField ef = (EntryField)((Object)RemoteEntryField.this.guiComponent);
                this.mouseExitBorder = ef.getBorder();
                ef.setBorder(this.mouseEnterBorder);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (RemoteEntryField.this.guiComponent != null) {
                EntryField ef = (EntryField)((Object)RemoteEntryField.this.guiComponent);
                ef.setBorder(this.mouseExitBorder);
                this.mouseExitBorder = null;
            }
        }
    }

    private class NotifyChangeTimer
    extends Timer
    implements ActionListener {
        short ed1;

        public NotifyChangeTimer(int delay) {
            super(delay, null);
            this.setRepeats(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RemoteEntryField.this.sendNtfChangeEvent(this.ed1);
        }

        synchronized void setEd1(short ed1) {
            this.ed1 = ed1;
        }
    }
}

