/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.swing.BmpLabel;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.PicobolBmpLabel;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class RemoteBitmap
extends RemoteBaseGUIControl {
    BmpTimer timer;
    int bitmapNumber = 1;
    int bitmapStart = 1;
    int bitmapEnd = 1;
    int bitmapTimer;
    int transparentColor = -1;
    int bitmapScale = 0;
    private int imageId;
    Image image;
    Image imageOrig;
    boolean hasEvents;
    private boolean bitmapScaleBestQuality;
    private PropertyChangeListener pcListener;
    private boolean usenotifymouse;
    private int bitmapWidth = -1;
    private boolean bitmapNumberSet;
    private boolean changesizevisible0 = false;

    public RemoteBitmap(final GuiFactoryImpl gf) {
        super(gf);
        this.bitmapScaleBestQuality = gf.getCsProperty().get("iscobol.bitmap_scale.best_quality", false);
        this.pcListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String key;
                if (gf != null && (key = evt.getPropertyName()).equals("iscobol.bitmap_scale.best_quality")) {
                    RemoteBitmap.this.bitmapScaleBestQuality = gf.getCsProperty().get("iscobol.bitmap_scale.best_quality", false);
                }
            }
        };
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    @Override
    public void displayProp() {
        if (this.guiComponent != null && this.image != null) {
            Image currimage = null;
            PicobolBmpLabel bmp = (PicobolBmpLabel)this.guiComponent;
            if (this.bitmapTimer > 0) {
                this.timer = new BmpTimer(this.bitmapTimer);
                this.timer.start();
            } else {
                if ((this.bitmapNumberSet && this.bitmapNumber > 0 || this.bitmapNumber == 1) && this.bitmapScale > 0) {
                    if (this.bitmapWidth > 0) {
                        currimage = ScreenUtility.getImage(this.bitmapWidth, this.imageOrig.getHeight(null), this.imageOrig, this.bitmapNumber);
                    } else {
                        currimage = this.image;
                        currimage = ScreenUtility.getImage(this.imageOrig.getWidth(null), this.imageOrig.getHeight(null), this.imageOrig, this.bitmapNumber);
                    }
                }
                if (currimage == null) {
                    currimage = ScreenUtility.getImage(bmp.getWidth(), bmp.getHeight(), this.imageOrig, this.bitmapNumber);
                }
                if (this.bitmapScale > 0) {
                    if ((currimage = this.scaleImage(currimage)) != null) {
                        ((PicobolBmpLabel)this.guiComponent).setImage(currimage, currimage, this.bitmapNumber);
                        ((PicobolBmpLabel)this.guiComponent).setBitmapScale(this.bitmapScale, this.bitmapScaleBestQuality, currimage);
                    }
                } else if (currimage != null) {
                    ((PicobolBmpLabel)this.guiComponent).setImage(currimage, this.imageOrig, this.bitmapNumber);
                }
            }
        }
    }

    @Override
    public float getDefaultHeight() {
        return -1.0f;
    }

    @Override
    public float getDefaultWidth() {
        return -1.0f;
    }

    @Override
    public int getGUIControlHeight(float h) {
        return (int)h;
    }

    @Override
    public int getGUIControlWidth(float w) {
        return (int)w;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getValue() {
        return null;
    }

    public boolean hasStyle(String style) {
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.parentWindow != null) {
            if (this.usenotifymouse) {
                super.mouseEntered(e);
            } else {
                RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
                if (rdw.getMouseFlags() > 0 && this.parentToolbar == null) {
                    rdw.handleMouseEvents(e);
                } else if (this.hasEvents && rdw.getMainWindow() != null && rdw.getMainWindow().isActiveAccept() && rdw.getMainWindow().isActive()) {
                    CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 96, 17023, 0, 0, false, false, true));
                    this.pushEvent(cc);
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.parentWindow != null) {
            if (this.usenotifymouse) {
                super.mouseExited(e);
            } else {
                RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
                if (rdw.getMouseFlags() > 0 && this.parentToolbar == null) {
                    rdw.handleMouseEvents(e);
                } else if (this.hasEvents && rdw.getMainWindow() != null && rdw.getMainWindow().isActiveAccept() && rdw.getMainWindow().isActive()) {
                    CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 96, 17024, 0, 0, false, false, true));
                    this.pushEvent(cc);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.parentWindow != null) {
            if (this.usenotifymouse) {
                super.mousePressed(e);
            } else {
                RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
                if (rdw.getMouseFlags() > 0 && this.parentToolbar == null) {
                    rdw.handleMouseEvents(e);
                } else if (this.hasEvents) {
                    CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 96, 17021, 0, 0, false, false, true));
                    this.pushEvent(cc);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.parentWindow != null && this.parentToolbar == null) {
            ((RemoteDisplayWindow)this.parentWindow).handleMouseEvents(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.parentWindow != null && this.parentToolbar == null) {
            ((RemoteDisplayWindow)this.parentWindow).handleMouseEvents(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e) && this.parentWindow != null) {
            if (this.usenotifymouse) {
                super.mouseClicked(e);
            } else {
                RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
                if (rdw.getMouseFlags() > 0 && this.parentToolbar == null) {
                    rdw.handleMouseEvents(e);
                } else if (this.hasEvents && e.getClickCount() >= 2) {
                    CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 96, 17022, 0, 0, false, false, true));
                    this.pushEvent(cc);
                }
            }
        }
    }

    public boolean hasEvents() {
        return this.hasEvents;
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolBmpLabel();
        super.intInitialize();
        ((PicobolBmpLabel)this.guiComponent).setBitmapScale(this.bitmapScale, this.bitmapScaleBestQuality, this.image);
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
        this.imageId = imageId;
        this.image = this.getLocalImage(imageId);
        if (this.image != null) {
            if (this.transparentColor >= 0) {
                this.image = ScreenUtility.makeColorTransparent(this.image, this.transparentColor);
            }
            this.imageOrig = this.image;
            if (this.width <= 0 || this.height <= 0) {
                if (this.width <= 0) {
                    this.width = this.image.getWidth(null);
                }
                if (this.height <= 0) {
                    this.height = this.image.getHeight(null);
                }
                if (this.guiComponent != null) {
                    this.guiComponent.setSize(this.width, this.height);
                }
            }
            if (this.bitmapScale > 0) {
                this.image = this.scaleImage(this.image);
                ((PicobolBmpLabel)this.guiComponent).setBitmapScale(this.bitmapScale, this.bitmapScaleBestQuality, this.image);
            } else {
                ((PicobolBmpLabel)this.guiComponent).setBitmapScale(this.bitmapScale, this.bitmapScaleBestQuality, this.image);
            }
            this.updateLayoutManager();
        } else if (this.dragmode > 0) {
            ((JLabel)((Object)this.guiComponent)).setIcon(null);
        }
    }

    @Override
    public String getProp(int key) {
        switch (key) {
            case 429: {
                Object id = this.gf.getClient().getId(this.imageId);
                if (id instanceof LocalImage) {
                    return "" + ((LocalImage)id).getHeight();
                }
                return "0";
            }
            case 430: {
                Object id = this.gf.getClient().getId(this.imageId);
                if (id instanceof LocalImage) {
                    return "" + ((LocalImage)id).getWidth();
                }
                return "0";
            }
        }
        return super.getProp(key);
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        String Return2 = "0";
        int intValue = 0;
        boolean error = false;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        switch (key) {
            case 12: {
                if (error) break;
                this.bitmapNumber = intValue;
                this.bitmapNumberSet = true;
                Return2 = "1";
                break;
            }
            case 17: {
                if (error) break;
                this.bitmapStart = intValue;
                Return2 = "1";
                break;
            }
            case 9: {
                if (error) break;
                this.bitmapEnd = intValue;
                Return2 = "1";
                break;
            }
            case 18: {
                if (error) break;
                this.bitmapTimer = intValue * 10;
                if (this.guiComponent != null) {
                    this.timer = new BmpTimer(this.bitmapTimer);
                    this.timer.start();
                }
                Return2 = "1";
                break;
            }
            case 242: {
                if (error) break;
                this.transparentColor = intValue;
                if (this.image != null) {
                    this.image = ScreenUtility.makeColorTransparent(this.image, this.transparentColor);
                    if (this.guiComponent != null) {
                        ((PicobolBmpLabel)this.guiComponent).setImage(this.image, this.image, this.bitmapNumber);
                    }
                }
                Return2 = "1";
                break;
            }
            case 295: {
                if (error) break;
                this.bitmapScale = intValue;
                if (this.guiComponent != null) {
                    ((PicobolBmpLabel)this.guiComponent).setBitmapScale(this.bitmapScale, this.bitmapScaleBestQuality, this.image);
                }
                if (this.image != null && this.bitmapScale > 0) {
                    this.image = this.scaleImage(this.image);
                    if (this.guiComponent != null) {
                        ((PicobolBmpLabel)this.guiComponent).setImage(this.image, this.image, this.bitmapNumber);
                    }
                }
                Return2 = "1";
                break;
            }
            case 256: {
                this.hasEvents = Boolean.valueOf(value);
                break;
            }
            case 20: {
                if (error) break;
                this.bitmapWidth = intValue;
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    private Image scaleImage(Image img) {
        int scaleAlign;
        int scaleType;
        switch (this.bitmapScale) {
            case 1: {
                scaleType = 0;
                scaleAlign = 5;
                break;
            }
            case 2: {
                scaleType = 1;
                scaleAlign = 7;
                break;
            }
            default: {
                scaleType = -1;
                scaleAlign = -1;
            }
        }
        if (scaleType >= 0) {
            this.changesizevisible0 = false;
            img = ScreenUtility.scale(img, this.width, this.height, scaleType, scaleAlign, this.bitmapScaleBestQuality);
            if (this.transparentColor >= 0) {
                img = ScreenUtility.makeColorTransparent(img, this.transparentColor);
            }
        }
        return img;
    }

    @Override
    public void setRowsCols(float rows, float cols) {
    }

    @Override
    public void setTitle(String v) {
    }

    @Override
    public String setValue(String v) {
        return v;
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        this.pcListener = null;
        if (this.timer != null) {
            this.timer.goImage = false;
        }
        this.image = null;
        this.imageOrig = null;
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        super.handleResponse(eventAction, rra);
    }

    @Override
    public void setCols(float c) {
    }

    @Override
    public void setRows(float r) {
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public String getType() {
        return "bitmap";
    }

    @Override
    public void setStyle(int s, boolean set) {
        if ((s & 1) == 1) {
            this.overlap = set;
        }
        if ((s & 2) == 2) {
            this.usenotifymouse = set;
        }
    }

    @Override
    public void setSize(int w, int h, boolean b) {
        int oldWidth = this.width;
        int oldHeight = this.height;
        super.setSize(w, h, b);
        if (this.guiComponent != null && (oldWidth != w || oldHeight != h)) {
            boolean bl = this.changesizevisible0 = !this.isVisible();
            if (this.bitmapScale > 0) {
                this.displayProp();
            }
            if (this.guiComponent.getParent() instanceof MainPanel && this.parentWindow instanceof RemoteDisplayWindow) {
                ((RemoteDisplayWindow)this.parentWindow).reorderComponents(new String[]{"tab", "frame"});
            }
        }
    }

    @Override
    public void setLocation(int xx, int yy, boolean setOnComp) {
        int oldX = this.x;
        int oldY = this.y;
        super.setLocation(xx, yy, setOnComp);
        if (this.guiComponent != null && this.parentWindow instanceof RemoteDisplayWindow && this.guiComponent.getParent() instanceof MainPanel && (oldX != 0 || oldY != 0) && (oldX != xx || oldY != yy)) {
            ((RemoteDisplayWindow)this.parentWindow).reorderComponents(new String[]{"tab", "frame"});
        }
    }

    @Override
    public void setVisible(boolean v) {
        if (this.changesizevisible0 && !this.isVisible() && v && this.bitmapScale > 0) {
            this.displayProp();
        }
        super.setVisible(v);
        this.changesizevisible0 = false;
    }

    @Override
    public JComponent getDragDropComponent() {
        if (this.guiComponent != null) {
            return (BmpLabel)((Object)this.guiComponent);
        }
        return null;
    }

    @Override
    public void setDragMode(int dm) {
        super.setDragMode(dm);
        if (dm > 0 && this.guiComponent != null) {
            ((BmpLabel)((Object)this.guiComponent)).setTransferHandler(new TransferHandler("text"));
            DragMouseAdapter listener = new DragMouseAdapter();
            ((BmpLabel)((Object)this.guiComponent)).addMouseListener(listener);
        }
    }

    private class DragMouseAdapter
    extends MouseAdapter {
        private DragMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            BmpLabel pl = (BmpLabel)((Object)RemoteBitmap.this.guiComponent);
            TransferHandler handler = pl.getTransferHandler();
            handler.exportAsDrag(pl, e, 1);
        }
    }

    private class BmpTimer
    extends Thread {
        long timet;
        volatile boolean goImage = true;

        BmpTimer(long t) {
            this.timet = t;
        }

        @Override
        public void run() {
            while (this.goImage) {
                try {
                    BmpTimer.sleep(this.timet);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                if (RemoteBitmap.this.guiComponent == null) continue;
                int current = RemoteBitmap.this.bitmapNumber;
                if (RemoteBitmap.this.bitmapStart > RemoteBitmap.this.bitmapEnd) {
                    RemoteBitmap.this.bitmapStart = RemoteBitmap.this.bitmapEnd;
                }
                if (++current > RemoteBitmap.this.bitmapEnd) {
                    current = RemoteBitmap.this.bitmapStart;
                }
                RemoteBitmap.this.bitmapNumber = current;
                Image currImage = ScreenUtility.getImage(RemoteBitmap.this.guiComponent.getWidth(), RemoteBitmap.this.guiComponent.getHeight(), RemoteBitmap.this.image, RemoteBitmap.this.bitmapNumber);
                if (currImage == null || RemoteBitmap.this.guiComponent == null) continue;
                ((PicobolBmpLabel)RemoteBitmap.this.guiComponent).setImage(currImage, RemoteBitmap.this.image, RemoteBitmap.this.bitmapNumber);
            }
        }
    }
}

