/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.PicobolWidget;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MassUpdatePanel
extends JPanel
implements PicobolWidget {
    private final JComponent component;
    private boolean massUpdate;
    private Layout layout;
    private boolean selfAct;
    private boolean activeAccept;
    private final Preview preview = new Preview();
    private Listener listener;

    public MassUpdatePanel(JComponent c) {
        this.component = c;
        this.preview.setFocusable(true);
        this.layout = new Layout(this, this.component, this.preview);
        this.setLayout(this.layout);
    }

    public boolean isMassUpdate() {
        return this.massUpdate;
    }

    public void setMassUpdate(boolean massUpdate) {
        if (this.massUpdate != massUpdate) {
            this.massUpdate = massUpdate;
            if (this.massUpdate) {
                Dimension d = this.component.getSize();
                if (d.width > 0 && d.height > 0) {
                    Image previewImage = this.component.isShowing() ? MassUpdatePanel.takeScreenshot(this.component) : IsguiUtility.takeScreenshot(this.component);
                    this.preview.setImage(previewImage);
                }
                this.layout.show2();
            } else {
                this.layout.show1();
            }
            if (this.listener != null) {
                this.listener.massUpdateChanged(this.massUpdate);
            }
        }
    }

    Listener getListener() {
        return this.listener;
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    private static Image takeScreenshot(JComponent c) {
        BufferedImage im = new BufferedImage(c.getWidth(), c.getHeight(), 1);
        Graphics2D g = im.createGraphics();
        c.paintAll(g);
        g.dispose();
        return im;
    }

    @Override
    public void setActiveAccept(boolean b) {
        this.activeAccept = b;
        if (this.component instanceof PicobolWidget) {
            ((PicobolWidget)((Object)this.component)).setActiveAccept(b);
        }
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean b) {
        this.selfAct = b;
        if (this.component instanceof PicobolWidget) {
            ((PicobolWidget)((Object)this.component)).setSelfAct(b);
        }
    }

    @Override
    public boolean getSelfAct() {
        return this.selfAct;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
        if (this.component instanceof PicobolWidget) {
            ((PicobolWidget)((Object)this.component)).asyncProcessEvent(e);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void setFont(Font f) {
        if (this.component != null) {
            this.component.setFont(f);
        } else {
            super.setFont(f);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.component != null) {
            this.component.setEnabled(b);
        }
    }

    @Override
    public Font getFont() {
        if (this.component != null) {
            return this.component.getFont();
        }
        return super.getFont();
    }

    @Override
    public void setBackground(Color bg) {
        if (this.component != null) {
            this.component.setBackground(bg);
        } else {
            super.setBackground(bg);
        }
    }

    @Override
    public Color getBackground() {
        if (this.component != null) {
            return this.component.getBackground();
        }
        return super.getBackground();
    }

    @Override
    public void setForeground(Color bg) {
        if (this.component != null) {
            this.component.setForeground(bg);
        } else {
            super.setForeground(bg);
        }
    }

    @Override
    public Color getForeground() {
        if (this.component != null) {
            return this.component.getForeground();
        }
        return super.getForeground();
    }

    @Override
    public void setToolTipText(String ttt) {
        if (this.component != null) {
            this.component.setToolTipText(ttt);
            this.preview.setToolTipText(ttt);
        } else {
            super.setToolTipText(ttt);
        }
    }

    @Override
    public String getToolTipText() {
        if (this.component != null) {
            return this.component.getToolTipText();
        }
        return super.getToolTipText();
    }

    @Override
    public void addKeyListener(KeyListener l) {
        if (this.component != null) {
            this.component.addKeyListener(l);
        } else {
            super.addKeyListener(l);
        }
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        if (this.component != null) {
            this.component.removeKeyListener(l);
        } else {
            super.removeKeyListener(l);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (this.component != null) {
            this.component.addFocusListener(l);
        } else {
            super.addFocusListener(l);
        }
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        if (this.component != null) {
            this.component.removeFocusListener(l);
        } else {
            super.removeFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.component != null) {
            this.component.addMouseListener(l);
        } else {
            super.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.component != null) {
            this.component.removeMouseListener(l);
        } else {
            super.removeMouseListener(l);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.component != null) {
            this.component.addMouseMotionListener(l);
        } else {
            super.addMouseMotionListener(l);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        if (this.component != null) {
            this.component.removeMouseMotionListener(l);
        } else {
            super.removeMouseMotionListener(l);
        }
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener l) {
        if (this.component != null) {
            this.component.addMouseWheelListener(l);
        } else {
            super.addMouseWheelListener(l);
        }
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener l) {
        if (this.component != null) {
            this.component.removeMouseWheelListener(l);
        } else {
            super.removeMouseWheelListener(l);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.component != null) {
            this.component.addPropertyChangeListener(l);
        } else {
            super.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.component != null) {
            this.component.removePropertyChangeListener(l);
        } else {
            super.removePropertyChangeListener(l);
        }
    }

    @Override
    public void requestFocus() {
        if (this.component != null) {
            if (this.layout.showed == this.component) {
                this.component.requestFocus();
            } else {
                this.preview.requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.component != null) {
            if (this.layout.showed == this.component) {
                return this.component.requestFocusInWindow();
            }
            return this.preview.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private static class Layout
    implements LayoutManager {
        final Component comp1;
        final Component comp2;
        final Container parent;
        Component showed;

        Layout(Container p, Component c1, Component c2) {
            this.parent = p;
            this.comp1 = c1;
            this.comp2 = c2;
            this.parent.add(this.comp1);
            this.parent.add(this.comp2);
            this.show1();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.comp1 != null ? this.comp1.getSize() : new Dimension(0, 0);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets ins = parent.getInsets();
            Rectangle bds = new Rectangle(ins.left, ins.top, parent.getSize().width - ins.left - ins.right, parent.getSize().height - ins.top - ins.bottom);
            this.comp1.setBounds(bds);
            this.comp2.setBounds(bds);
        }

        void show1() {
            this.show(this.comp1);
        }

        void show2() {
            this.show(this.comp2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void show(Component c) {
            Object object = this.parent.getTreeLock();
            synchronized (object) {
                this.showed = c;
                if (this.showed == this.comp1) {
                    this.comp2.setVisible(false);
                    this.comp1.setVisible(true);
                } else {
                    this.comp1.setVisible(false);
                    this.comp2.setVisible(true);
                }
                this.parent.validate();
            }
        }
    }

    private static class Preview
    extends JComponent {
        Image image;

        private Preview() {
        }

        void setImage(Image im) {
            this.image = im;
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, null);
        }
    }

    public static interface Listener {
        public void massUpdateChanged(boolean var1);
    }
}

