/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.PagedListBoxEvent;
import com.iscobol.gui.PagedListBoxListener;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.CsProperty;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.FindJPanel;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.NotifyMouseEvent;
import com.iscobol.gui.client.swing.NotifyMouseListener;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import com.iscobol.types.CobolVar;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ListBox
extends JPanel
implements Constants,
ItemSelectable,
FindJPanel.FindListener {
    private static final long serialVersionUID = 1L;
    private NotifyMouseListener nmListener = null;
    private Color defaultMatchingTextColorBackground;
    private Color matchingTextColorBackground = this.defaultMatchingTextColorBackground = new Color(255, 215, 50);
    private Color matchingTextColorForeground = null;
    private Color matchingTextColor2Background = new Color(-16711936);
    private Color matchingTextColor2Foreground = new Color(-13487566);
    private boolean[] searchPanelSettings = null;
    private Vector<CoordinateMatchFind> matchRows;
    private int currentmatchrowidx = -1;
    private ListItem currentmatchrowli = null;
    private CoordinateMatchFind currentmatchrowelem = null;
    private int prop_ACTION = -1;
    private static Comparator<ListItem> ignoreCaseComparator = (item1, item2) -> item1.text.compareToIgnoreCase(item2.text);
    protected static final int BUTTON_PANEL_WIDTH = new JScrollBar((int)1).getPreferredSize().width;
    public static final int UNALIGNED = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    private SearchDocumentListener searchDocumentListener = new SearchDocumentListener();
    private FocusListener searchFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            Component opp = e.getOppositeComponent();
            if (!ListBox.this.checkMenuSelected(opp)) {
                ListBox.this.hideSearchBox(opp == null || !(opp instanceof PicobolWidget) || opp instanceof JComponent && (JComponent)opp == ListBox.this.list);
            }
        }
    };
    private boolean fireNtfChange = true;
    private JPanel checkPanel;
    private ItemListener checkListItemListener = e -> {
        if (this.fireNtfChange && (e.getStateChange() == 1 || this.getSelectionMode() != 0)) {
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                if (this.checkPanel.getComponent(i) != e.getSource()) continue;
                this.lastMouseSelectedIndex = i;
                this.dispatchListSelectionEvent(this.lastMouseSelectedIndex);
                break;
            }
        }
    };
    private FocusListener checkListFocusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            if (ListBox.this.focusListener != null) {
                ListBox.this.focusListener.focusLost(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            ListBox.this.focusedButton = (JToggleButton)e.getComponent();
            ListBox.this.checkPanel.scrollRectToVisible(e.getComponent().getBounds());
            if (ListBox.this.focusListener != null) {
                ListBox.this.focusListener.focusGained(e);
            }
        }
    };
    private MouseListener checkListMouseListener = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseReleased(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mousePressed(e);
            }
            if (e.getComponent() instanceof JToggleButton) {
                ListBox.this.focusedButton = (JToggleButton)e.getComponent();
            }
            ListBox.this.requestFocus();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ListBox.this.check(e);
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseExited(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component[] array = ListBox.this.checkPanel.getComponents();
            int idx = -1;
            for (int i = 0; idx == -1 && i < array.length; ++i) {
                if (array[i] != e.getSource()) continue;
                idx = i;
            }
            if (ListBox.this.nmListener != null && idx >= 0) {
                ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(e.getSource(), 17023, idx + 1, 1));
            } else if (ListBox.this.nmListener != null && idx == -1) {
                ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(e.getSource(), 17024, 0, 0));
            }
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseEntered(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ListBox.this.mouseListener != null) {
                ListBox.this.mouseListener.mouseClicked(e);
            }
        }
    };
    private KeyListener checkListKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
            if (ListBox.this.keyListener != null) {
                ListBox.this.keyListener.keyTyped(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (ListBox.this.keyListener != null) {
                ListBox.this.keyListener.keyReleased(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (ListBox.this.keyListener != null) {
                ListBox.this.keyListener.keyPressed(e);
                if (ListBox.this.showFindPanel(e)) {
                    return;
                }
            }
        }
    };
    private boolean checkList;
    private HashSet<JToggleButton> opaqueButtons = new HashSet();
    private MyScrollPane checkScrollPane;
    private JToggleButton focusedButton;
    private JPanel listPanel;
    private JTextField searchBox;
    private JPanel buttonPanel;
    private JListWithDividers list;
    private PagedEventDispatcher ped;
    private KeyEventDispatcher ked;
    private PagedListButton[] buttons;
    private CardLayout firstCardLayout;
    private CardLayout lastCardLayout;
    private JPanel firstCardPanel;
    private JPanel lastCardPanel;
    private MyScrollPane listScrollPane;
    private LocalFontCmp fontCmp;
    private GuiFactoryImpl gf;
    private boolean lmOnColumns;
    private int selectionMode;
    private ItemListener itemListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private FilteredListModel model = new FilteredListModel();
    private FastCellRenderer renderer;
    private Vector dataColumns;
    private Vector displayColumns;
    private Vector dividers;
    private Vector separators;
    private Vector alignments;
    private boolean upper;
    private boolean lower;
    private boolean unsorted;
    private int sortOrder;
    private float cellWidth;
    private int fontHeight;
    private Column[] column;
    private boolean paged;
    private boolean isNoSearch;
    private int thumbPosition;
    private Vector pListeners = new Vector();
    private int rows = 5;
    private int origWidth;
    private int origHeight;
    private int XPos;
    private int YPos;
    private int mousewheellinestoscroll = 1;
    private Vector rowColorPatterns;
    private Font font;
    private Color background;
    private Color foreground;
    private MyButtonGroup radioGroup;
    private SearchKeyListener searchKeyListener = new SearchKeyListener();
    private int upperLowerMethod;
    private boolean f4ShowsSearchBox = true;
    private int lastMouseSelectedIndex = -2;
    private GradientManager gradientMgr;
    private FindTimer findTimer;
    private int findtimerdelay;
    private FindJPanel panelfind = null;
    private ImageIcon closeIcon;
    private ImageIcon findIcon;
    private ImageIcon clearIcon;
    private ImageIcon casesensitiveIcon;
    private ImageIcon casenotsensitiveIcon;
    private boolean casesensitiveState;
    private Border syntaxborderok;
    private Border syntaxbordererr;
    private Window parentwindow;
    private Cursor lastCursor;
    private static final Cursor BUSY_CURSOR = new Cursor(3);
    private int prop_SEARCH_PANEL;
    private JList dragcomponent;

    public ListBox(GuiFactoryImpl gf, boolean pgd, boolean noSrch, boolean cl, boolean useDefaultBorderWithBoxedStyle, GradientManager gradientMgr) {
        if (useDefaultBorderWithBoxedStyle) {
            super.setName("IscobolListBoxPanel");
        }
        this.gf = gf;
        this.setLayout(new BorderLayout(0, 0));
        this.paged = pgd;
        this.isNoSearch = noSrch;
        this.intSetCheckList(cl);
        this.gradientMgr = gradientMgr;
        this.gradientMgr.addPropertyChangeListener(e -> {
            this.setOpaque();
            if (this.checkList) {
                this.checkScrollPane.getViewport().repaint();
            } else if (this.paged) {
                this.list.repaint();
            } else {
                this.listScrollPane.getViewport().repaint();
            }
        });
        this.setOpaque();
        this.closeIcon = new ImageIcon(this.getClass().getResource("cancelfind.png"), "close");
        this.findIcon = new ImageIcon(this.getClass().getResource("searchfind.png"), "find");
        this.clearIcon = new ImageIcon(this.getClass().getResource("cleanfind.png"), "clear");
        this.casesensitiveIcon = new ImageIcon(this.getClass().getResource("vV.png"), "casesensitive");
        this.casenotsensitiveIcon = new ImageIcon(this.getClass().getResource("vV2.png"), "casenotsensitive");
        CsProperty csp = gf.getCsProperty();
        this.findtimerdelay = csp.get("iscobol.gui.search_delay", csp.get("iscobol.gui.grid.find_delay", 500));
        if (this.findtimerdelay > 0) {
            this.findTimer = new FindTimer(this.findtimerdelay);
        }
    }

    public void setPaged(boolean p) {
        if (this.paged != p) {
            this.intSetPaged(p);
        }
    }

    private void intSetPaged(boolean p) {
        this.paged = p;
        if (this.paged) {
            if (this.listScrollPane != null) {
                this.listPanel.remove(this.listScrollPane);
                this.listPanel.remove(this.searchBox);
                this.listScrollPane = null;
            }
            this.add((Component)this.createButtonPanel(), "East");
            this.listPanel.add(this.createSearchBox());
            this.listPanel.add(this.list);
        } else {
            if (this.buttonPanel != null) {
                this.remove(this.buttonPanel);
                this.listPanel.remove(this.list);
                this.listPanel.remove(this.searchBox);
            }
            this.listPanel.add(this.createSearchBox());
            this.listPanel.add(this.createListScrollPane());
        }
        this.doLayout();
    }

    public void setNoSearch(boolean ns) {
        if (this.isNoSearch != ns) {
            this.intSetNoSearch(ns);
        }
    }

    private void intSetNoSearch(boolean ns) {
        this.isNoSearch = ns;
        if (this.isNoSearch) {
            this.list.removeKeyListener(this.searchKeyListener);
        } else {
            this.createSearchBox();
            this.list.addKeyListener(this.searchKeyListener);
        }
    }

    private void dispatchListSelectionEvent(int idx) {
        if (this.itemListener == null) {
            return;
        }
        try {
            if (idx >= 0 && idx < this.getItemCount()) {
                ItemEvent ie = new ItemEvent(this, 701, this.model.getElementAt(idx), 1);
                this.itemListener.itemStateChanged(ie);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private JScrollPane createListScrollPane() {
        if (this.listScrollPane != null) {
            return this.listScrollPane;
        }
        this.listScrollPane = new MyScrollPane(this.list, 20, 31);
        this.listScrollPane.setBorder(null);
        JScrollBar vsb = this.listScrollPane.getVerticalScrollBar();
        vsb.setFocusable(false);
        vsb.setPreferredSize(new Dimension(BUTTON_PANEL_WIDTH, vsb.getPreferredSize().height));
        this.listScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.listScrollPane.getHorizontalScrollBar().addAdjustmentListener(adjustmentEvent -> {
            this.XPos = adjustmentEvent.getValue();
        });
        this.listScrollPane.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ListBox.this.repaint();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ListBox.this.repaint();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ListBox.this.repaint();
            }
        });
        this.listScrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentEvent -> {
            this.YPos = adjustmentEvent.getValue();
        });
        return this.listScrollPane;
    }

    private JPanel createButtonPanel() {
        if (this.buttonPanel != null) {
            return this.buttonPanel;
        }
        this.buttonPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(BUTTON_PANEL_WIDTH, super.getPreferredSize().height);
            }
        };
        this.buttonPanel.setLayout(new GridLayout(4, 1));
        this.buttons = new PagedListButton[6];
        this.buttons[0] = this.createButton("first.gif", 2099);
        this.buttons[1] = this.createButton("prev.gif", 2100);
        this.firstCardLayout = new CardLayout();
        this.firstCardPanel = new JPanel(this.firstCardLayout);
        this.firstCardPanel.add((Component)this.buttons[1], "prev.gif");
        this.firstCardPanel.add((Component)this.buttons[0], "first.gif");
        this.buttonPanel.add(this.firstCardPanel);
        this.buttons[2] = this.createButton("pageprev.gif", 2101);
        this.buttonPanel.add(this.buttons[2]);
        this.buttons[3] = this.createButton("pagesucc.gif", 2102);
        this.buttonPanel.add(this.buttons[3]);
        this.buttons[4] = this.createButton("succ.gif", 2103);
        this.buttons[5] = this.createButton("last.gif", 2104);
        this.lastCardLayout = new CardLayout();
        this.lastCardPanel = new JPanel(this.lastCardLayout);
        this.lastCardPanel.add((Component)this.buttons[4], "succ.gif");
        this.lastCardPanel.add((Component)this.buttons[5], "last.gif");
        this.buttonPanel.add(this.lastCardPanel);
        return this.buttonPanel;
    }

    private PagedListButton createButton(String imageicon, final int eventId) {
        MediaTracker mt = new MediaTracker(this);
        Image img = this.getToolkit().createImage(this.getClass().getResource(imageicon));
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ImageIcon ii = new ImageIcon(img);
        PagedListButton btn = new PagedListButton(ii);
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (!ListBox.this.isEnabled()) {
                    return;
                }
                if (ListBox.this.mouseListener != null) {
                    ListBox.this.mouseListener.mousePressed(evt);
                }
                PagedListBoxEvent ple = new PagedListBoxEvent((Object)ListBox.this.list, eventId, 2);
                switch (eventId) {
                    case 2100: 
                    case 2101: 
                    case 2102: 
                    case 2103: {
                        (ListBox.this.ped = new PagedEventDispatcher(ListBox.this.pListeners, ple)).start();
                        break;
                    }
                    case 2099: 
                    case 2104: {
                        new PagedEventDispatcher(ListBox.this.pListeners, ple);
                    }
                }
            }
        });
        btn.setFocusable(false);
        return btn;
    }

    protected boolean isSearchBoxVisible() {
        return this.searchBox != null && this.searchBox.isVisible();
    }

    public void showSearchBox() {
        if (this.searchBox != null && !this.searchBox.isVisible()) {
            this.intShowSearchBox();
        }
    }

    private void intShowSearchBox() {
        this.searchBox.setVisible(true);
        this.searchBox.requestFocusInWindow();
        this.listPanel.doLayout();
        this.buttonPanel.doLayout();
        this.firstCardLayout.first(this.firstCardPanel);
        this.lastCardLayout.first(this.lastCardPanel);
        this.addSearchBoxListeners();
    }

    private void addSearchBoxListeners() {
        this.searchBox.addKeyListener(this.searchKeyListener);
        this.searchBox.getDocument().addDocumentListener(this.searchDocumentListener);
        this.searchBox.addFocusListener(this.searchFocusListener);
    }

    public void hideSearchBox() {
        this.hideSearchBox(false);
    }

    private void hideSearchBox(boolean listRequestFocus) {
        if (this.searchBox != null && this.searchBox.isVisible()) {
            this.intHideSearchBox(listRequestFocus);
        }
    }

    private void intHideSearchBox(boolean listRequestFocus) {
        this.removeSearchBoxListeners();
        this.searchBox.setVisible(false);
        if (listRequestFocus) {
            this.list.requestFocusInWindow();
        }
        this.listPanel.doLayout();
        this.buttonPanel.doLayout();
    }

    private void removeSearchBoxListeners() {
        this.searchBox.removeKeyListener(this.searchKeyListener);
        this.searchBox.getDocument().removeDocumentListener(this.searchDocumentListener);
        this.searchBox.removeFocusListener(this.searchFocusListener);
    }

    private JTextField createSearchBox() {
        if (this.searchBox != null) {
            return this.searchBox;
        }
        this.searchBox = new JTextField(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Math.max(50, ((ListBox)ListBox.this).listPanel.getSize().width - 20), ((ListBox)ListBox.this).searchBox.getPreferredSize().height);
            }
        };
        this.searchBox.setVisible(false);
        this.searchBox.setAlignmentX(1.0f);
        this.searchBox.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char c;
                if (str.length() > 0 && (c = str.charAt(0)) != '\t' && c != '\n') {
                    if (ListBox.this.upper) {
                        str = Factory.toUpperCase(str, ListBox.this.upperLowerMethod);
                    } else if (ListBox.this.lower) {
                        str = Factory.toLowerCase(str, ListBox.this.upperLowerMethod);
                    }
                    super.insertString(offs, str, a);
                }
            }

            @Override
            public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                ListBox.this.searchDocumentListener.notifyRemove = false;
                super.replace(offset, length, text, attrs);
                ListBox.this.searchDocumentListener.notifyRemove = true;
            }
        });
        return this.searchBox;
    }

    protected boolean findAndSelectSearchedText(boolean fireEvents) {
        return this.findAndSelect(this.searchBox.getText(), fireEvents);
    }

    protected boolean findAndSelect(String text, boolean fireEvents) {
        boolean found = false;
        if (text.length() > 0 && this.sortOrder != 1) {
            int selIdx;
            int count = this.model.getSize();
            for (selIdx = 0; !found && selIdx < count; ++selIdx) {
                String comp = this.getItemAt(selIdx).trim();
                if (this.upper || this.lower || this.sortOrder != 2) {
                    if (!comp.toLowerCase().startsWith(text.toLowerCase())) continue;
                    found = true;
                    break;
                }
                if (!comp.startsWith(text)) continue;
                found = true;
                break;
            }
            if (found) {
                int idx = selIdx;
                SwingUtilities.invokeLater(() -> {
                    boolean b = this.fireNtfChange;
                    if (!fireEvents) {
                        this.fireNtfChange = false;
                    }
                    this.list.setSelectedIndex(idx);
                    this.fireNtfChange = b;
                });
            }
        }
        return found;
    }

    private void dispatchSearchEvent(boolean remove) {
        boolean fireEvent;
        String text = this.searchBox.getText();
        boolean found = this.findAndSelect(text, true);
        boolean bl = fireEvent = remove || !found || this.sortOrder == 1;
        if (fireEvent) {
            Enumeration en = this.pListeners.elements();
            while (en.hasMoreElements()) {
                PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                PagedListBoxEvent ple = new PagedListBoxEvent((Object)this.searchBox, 2105, text);
                l.search(ple);
            }
        }
    }

    public void addItem(ListItem item, int index) {
        this.fireNtfChange = false;
        if (index < 0 || index >= this.model.getSize()) {
            if (!this.isPaged() && !this.unsorted && (index = ScreenUtility.getInsertionIndex(this.model.delegate, item, ignoreCaseComparator)) < this.model.getSize()) {
                this.model.add(index, item);
                if (this.checkList) {
                    this.addCheckItem(item, index);
                }
                this.fireNtfChange = true;
                return;
            }
            if (this.isPaged() && this.model.getSize() == this.rows) {
                this.model.removeElementAt(0);
            }
            this.model.addElement(item);
            if (this.checkList) {
                this.addCheckItem(item, -1);
            }
        } else {
            if (this.isPaged() && this.model.getSize() == this.rows) {
                if (index > 0) {
                    this.model.removeElementAt(0);
                } else {
                    this.model.removeElementAt(this.model.getSize() - 1);
                }
            }
            this.model.add(index, item);
            if (this.checkList) {
                this.addCheckItem(item, index);
            }
        }
        this.fireNtfChange = true;
    }

    private void addCheckItem(ListItem item, int index) {
        JToggleButton btn = this.addCheckItem(item.text, item.getBackground(), item.getForeground(), index);
        if (btn instanceof MyJCheckBox) {
            ((MyJCheckBox)btn).item = item;
        } else {
            ((MyJRadioButton)btn).item = item;
        }
        if (item.getBackground() != null) {
            this.opaqueButtons.add(btn);
            btn.setOpaque(true);
        } else {
            btn.setOpaque(!this.gradientMgr.isPaintGradient());
        }
        if (this.checkPanel.getComponentCount() == 1) {
            this.checkScrollPane.getVerticalScrollBar().setUnitIncrement(btn.getPreferredSize().height + btn.getMargin().top + btn.getMargin().bottom);
        }
        this.checkScrollPane.doLayout();
    }

    private JToggleButton addCheckItem(String text, Color bg, Color fg, int index) {
        JToggleButton btn;
        MyJRadioButton radio = null;
        if (this.getSelectionMode() == 0) {
            radio = new MyJRadioButton(text);
            btn = radio;
            this.radioGroup.add(radio);
        } else {
            btn = new MyJCheckBox(text);
        }
        btn.setForeground(fg != null ? fg : this.getForeground());
        btn.setBackground(bg != null ? bg : this.getBackground());
        btn.setFont(this.getFont());
        btn.setToolTipText(this.checkPanel.getToolTipText());
        btn.addItemListener(this.checkListItemListener);
        btn.addFocusListener(this.checkListFocusListener);
        btn.addMouseListener(this.checkListMouseListener);
        btn.addKeyListener(this.checkListKeyListener);
        if (index >= 0 && index < this.checkPanel.getComponentCount()) {
            this.checkPanel.add((Component)btn, index);
            if (radio != null) {
                Vector<AbstractButton> buttons = this.radioGroup.getButtons();
                buttons.remove(buttons.size() - 1);
                buttons.add(index, radio);
            }
        } else {
            this.checkPanel.add(btn);
        }
        this.checkPanel.doLayout();
        return btn;
    }

    public void removeItem(int idx) {
        this.fireNtfChange = false;
        this.model.removeElementAt(idx);
        if (this.checkList) {
            this.removeCheckItem(idx);
        }
        this.fireNtfChange = true;
    }

    private void removeCheckItem(int idx) {
        if (idx < this.checkPanel.getComponentCount()) {
            this.removeCheckItem0(idx);
            this.checkScrollPane.doLayout();
        }
    }

    private JToggleButton removeCheckItem0(int idx) {
        JToggleButton btn = (JToggleButton)this.checkPanel.getComponent(idx);
        this.opaqueButtons.remove(btn);
        btn.removeItemListener(this.checkListItemListener);
        btn.removeFocusListener(this.checkListFocusListener);
        btn.removeKeyListener(this.checkListKeyListener);
        btn.removeMouseListener(this.checkListMouseListener);
        if (this.getSelectionMode() == 0) {
            this.radioGroup.remove(btn);
        }
        this.checkPanel.remove(idx);
        this.checkPanel.doLayout();
        return btn;
    }

    public void removeAllItems() {
        this.fireNtfChange = false;
        this.model.removeAllElements();
        if (this.checkList) {
            this.removeAllCheckItems();
        }
        this.fireNtfChange = true;
    }

    private void removeAllCheckItems() {
        this.checkPanel.removeAll();
        if (this.getSelectionMode() == 0) {
            Vector<AbstractButton> tmp = new Vector<AbstractButton>(this.radioGroup.getButtons());
            for (AbstractButton btn : tmp) {
                this.radioGroup.remove(btn);
            }
        }
        this.opaqueButtons.clear();
        this.checkPanel.doLayout();
        this.checkPanel.repaint();
        this.checkScrollPane.doLayout();
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.ked);
    }

    public void addAlignment(String al) {
        if (this.alignments == null) {
            this.alignments = new Vector();
        }
        this.alignments.addElement(al);
    }

    public void resetAlignments() {
        this.alignments = null;
    }

    public void addDivider(int d) {
        if (this.dividers == null) {
            this.dividers = new Vector();
        }
        this.dividers.addElement(d);
        this.repaint();
    }

    public void resetDividers() {
        this.dividers = null;
        this.repaint();
    }

    public void addSeparator(int s) {
        if (this.separators == null) {
            this.separators = new Vector();
        }
        this.separators.addElement(s);
    }

    public void resetSeparators() {
        this.separators = null;
    }

    public void addDataColumn(int dtCol) {
        if (dtCol > 1) {
            if (this.dataColumns == null) {
                this.dataColumns = new Vector();
            }
            Integer I2 = dtCol;
            Enumeration e = this.dataColumns.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                Integer dt = (Integer)e.nextElement();
                if (I2.compareTo(dt) == 0) {
                    return;
                }
                if (I2.compareTo(dt) < 0) {
                    this.dataColumns.add(i, I2);
                    return;
                }
                ++i;
            }
            this.dataColumns.addElement(I2);
        }
    }

    public void resetDataColumns() {
        this.dataColumns = null;
    }

    public void addDisplayColumn(int dsCol) {
        if (dsCol > 1) {
            if (this.displayColumns == null) {
                this.displayColumns = new Vector();
            }
            Integer I2 = dsCol;
            Enumeration e = this.displayColumns.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                Integer ds = (Integer)e.nextElement();
                if (I2.compareTo(ds) == 0) {
                    return;
                }
                if (I2.compareTo(ds) < 0) {
                    this.displayColumns.add(i, I2);
                    return;
                }
                ++i;
            }
            this.displayColumns.addElement(I2);
        }
    }

    public void resetDisplayColumns() {
        this.displayColumns = null;
    }

    @Override
    public void setToolTipText(String tt) {
        if (this.list != null || this.checkPanel != null) {
            if (this.checkList) {
                this.checkPanel.setToolTipText(tt);
                for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                    ((JToggleButton)this.checkPanel.getComponent(i)).setToolTipText(tt);
                }
            } else {
                this.list.setToolTipText(tt);
            }
        } else {
            super.setToolTipText(tt);
        }
    }

    public void setUpper(boolean u) {
        this.upper = u;
    }

    public void setLower(boolean l) {
        this.lower = l;
    }

    private void setOpaque() {
        boolean opaque;
        boolean bl = opaque = !this.gradientMgr.isPaintGradient();
        if (this.checkList) {
            this.checkPanel.setOpaque(opaque);
            this.checkScrollPane.getViewport().setOpaque(opaque);
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                JToggleButton btn = (JToggleButton)this.checkPanel.getComponent(i);
                if (this.opaqueButtons.contains(btn)) {
                    btn.setOpaque(true);
                    continue;
                }
                btn.setOpaque(opaque);
            }
        } else {
            this.list.setOpaque(opaque);
            if (this.listScrollPane != null) {
                this.listScrollPane.getViewport().setOpaque(opaque);
            }
        }
    }

    public void setThumbPosition(int tp) {
        this.thumbPosition = tp;
        if (this.checkList) {
            if (this.checkPanel.getComponentCount() > 0) {
                int visRectHeight = this.checkScrollPane.getViewport().getViewRect().height;
                JToggleButton c = (JToggleButton)this.checkPanel.getComponent(0);
                int rowHeight = c.getSize().height + c.getMargin().top + c.getMargin().bottom;
                int rowVisibleInterval = visRectHeight / rowHeight;
                int makeVisibleIdx = 0;
                if (tp > 0) {
                    makeVisibleIdx = tp <= this.getFirstVisibleIndex() ? tp : (tp <= this.getItemCount() - rowVisibleInterval ? tp + rowVisibleInterval : this.getItemCount());
                }
                if (makeVisibleIdx > 0) {
                    this.checkPanel.scrollRectToVisible(this.checkPanel.getComponent(makeVisibleIdx - 1).getBounds());
                }
            }
        } else {
            int rowVisibleInterval = this.getRows() - 1;
            int makeVisibleIdx = 0;
            if (tp > 0) {
                makeVisibleIdx = tp <= this.getFirstVisibleIndex() ? tp : (tp <= this.getItemCount() - rowVisibleInterval ? tp + rowVisibleInterval : this.getItemCount());
            }
            if (makeVisibleIdx > 0) {
                this.list.ensureIndexIsVisible(makeVisibleIdx - 1);
                this.list.repaint();
            }
        }
    }

    public int getThumbPosition() {
        return this.getFirstVisibleIndex() + 1;
    }

    public void setUnsorted(boolean us) {
        this.unsorted = us;
    }

    private boolean isPaged() {
        return this.paged && !this.checkList;
    }

    public boolean isLower() {
        return this.lower;
    }

    public boolean isUpper() {
        return this.upper;
    }

    @Override
    public void setFont(Font f) {
        if (this.list == null && this.checkPanel == null) {
            super.setFont(f);
        } else if (this.font == null || !this.font.equals(f)) {
            this.font = f;
            if (this.checkList) {
                for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                    this.checkPanel.getComponent(i).setFont(f);
                }
            } else {
                this.list.setFont(f);
                this.fontCmp = this.getFontCmp();
                if (this.fontCmp != null) {
                    IscobolLayout isl = this.getIscobolLayout();
                    if (!(isl instanceof ZoomLayout) || !isl.isLayingOut()) {
                        this.cellWidth = this.fontCmp.computeScreenWidth("0");
                    }
                    this.fontHeight = this.fontCmp.getHeight();
                    this.renderer.updateRenderer();
                }
                this.rows = this.origHeight / this.fontHeight;
                this.buildColumns(this.getCellWidth());
            }
        }
    }

    private IscobolLayout getIscobolLayout() {
        for (Container cnt = this.getParent(); cnt != null; cnt = cnt.getParent()) {
            if (!(cnt.getLayout() instanceof IscobolLayout)) continue;
            return (IscobolLayout)cnt.getLayout();
        }
        return null;
    }

    private IscobolLayout.LayoutData getIscobolLayoutData() {
        Container c = this;
        for (Container cnt = c.getParent(); cnt != null; cnt = cnt.getParent()) {
            if (cnt.getLayout() instanceof IscobolLayout) {
                return ((IscobolLayout)cnt.getLayout()).getLayoutData(c);
            }
            c = cnt;
        }
        return null;
    }

    @Override
    public Font getFont() {
        return this.font != null ? this.font : super.getFont();
    }

    @Override
    public void setForeground(Color fg) {
        this.intSetForeground(fg);
    }

    private void intSetForeground(Color fg) {
        if (this.list != null || this.checkPanel != null) {
            this.foreground = fg;
            if (this.checkList) {
                for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                    this.checkPanel.getComponent(i).setForeground(fg);
                }
            } else {
                this.list.setForeground(fg);
            }
        } else {
            super.setForeground(fg);
        }
    }

    @Override
    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (!this.checkList && this.list != null) {
            return this.list.getForeground();
        }
        return super.getForeground();
    }

    @Override
    public void setBackground(Color bg) {
        this.intSetBackground(bg);
    }

    private void intSetBackground(Color bg) {
        if (this.list != null || this.checkPanel != null) {
            this.background = bg;
            if (this.checkList) {
                this.checkPanel.setBackground(bg);
                for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                    this.checkPanel.getComponent(i).setBackground(bg);
                }
            } else {
                this.list.setBackground(bg);
            }
        }
    }

    @Override
    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (!this.checkList && this.list != null) {
            return this.list.getBackground();
        }
        return super.getBackground();
    }

    public void clearSelection() {
        if (this.checkList) {
            boolean b = this.fireNtfChange;
            this.fireNtfChange = false;
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                ((JToggleButton)this.checkPanel.getComponent(i)).setSelected(false);
            }
            this.fireNtfChange = b;
        } else {
            this.list.clearSelection();
            this.list.getSelectionModel().setAnchorSelectionIndex(-1);
            this.list.getSelectionModel().setLeadSelectionIndex(-1);
        }
    }

    void select(int idx) {
        this.select(new int[]{idx});
    }

    void select(int[] idxs) {
        this.fireNtfChange = false;
        if (this.checkList) {
            for (int i = 0; i < idxs.length; ++i) {
                ((JToggleButton)this.checkPanel.getComponent(idxs[i])).setSelected(true);
            }
        } else if (idxs.length > 1) {
            this.list.setSelectedIndices(idxs);
            this.list.ensureIndexIsVisible(idxs[idxs.length - 1]);
        } else {
            this.list.setSelectedIndex(idxs[0]);
            this.list.ensureIndexIsVisible(idxs[0]);
        }
        this.fireNtfChange = true;
    }

    public int getSelectedIndex() {
        if (this.checkList) {
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                if (!((JToggleButton)this.checkPanel.getComponent(i)).isSelected()) continue;
                return i;
            }
            return -1;
        }
        return this.list.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        if (this.checkList) {
            ArrayList<Integer> selIdxs = new ArrayList<Integer>();
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                if (!((JToggleButton)this.checkPanel.getComponent(i)).isSelected()) continue;
                selIdxs.add(i);
            }
            int[] ret = new int[selIdxs.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)selIdxs.get(i);
            }
            return ret;
        }
        return this.list.getSelectedIndices();
    }

    public void setRowColorPattern(Vector rcp) {
        this.rowColorPatterns = rcp;
        if (!this.checkList) {
            this.list.repaint();
        }
    }

    public int setSelectedValue(String item) {
        int i = this.indexOf(item);
        if (i >= 0) {
            new SwingWorker(true, () -> this.select(i)).start();
        }
        return i;
    }

    public String getSelectedValue() {
        int idx = this.getSelectedIndex();
        if (idx >= 0) {
            return this.getItemAt(idx);
        }
        return null;
    }

    private int indexOf(String item) {
        int i;
        int size = this.model.getSize();
        for (i = 0; i < size; ++i) {
            if (!this.model.getElementAt(i).toString().equals(item)) continue;
            return i;
        }
        for (i = 0; i < size; ++i) {
            if (!this.model.getElementAt(i).toString().equalsIgnoreCase(item)) continue;
            return i;
        }
        item = item.toLowerCase();
        for (i = 0; i < size; ++i) {
            if (!this.model.getElementAt(i).toString().toLowerCase().startsWith(item)) continue;
            return i;
        }
        return -1;
    }

    public String getItemAt(int idx) {
        ListItem li = (ListItem)this.model.getElementAt(idx);
        return li != null ? li.toString() : "";
    }

    @Override
    public void addKeyListener(KeyListener l) {
        if (!this.checkList) {
            this.list.addKeyListener(l);
            if (this.searchBox != null) {
                this.searchBox.addKeyListener(l);
            }
        }
        this.keyListener = AWTEventMulticaster.add(this.keyListener, l);
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        if (!this.checkList) {
            this.list.removeKeyListener(l);
            if (this.searchBox != null) {
                this.searchBox.removeKeyListener(l);
            }
        }
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, l);
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (this.list == null && this.checkPanel == null) {
            super.addFocusListener(l);
        } else if (!this.checkList) {
            this.list.addFocusListener(l);
        }
        this.focusListener = AWTEventMulticaster.add(this.focusListener, l);
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        if (!this.checkList) {
            this.list.removeFocusListener(l);
        }
        this.focusListener = AWTEventMulticaster.remove(l, this.focusListener);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (!this.checkList) {
            this.list.addMouseListener(l);
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (!this.checkList) {
            this.list.removeMouseListener(l);
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, l);
    }

    public void addPagedListBoxListener(PagedListBoxListener l) {
        this.pListeners.addElement(l);
    }

    public void removePagedListBoxListener(PagedListBoxListener l) {
        this.pListeners.removeElement(l);
    }

    public void setSortOrder(int so) {
        this.sortOrder = so;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void buildColumns() {
        this.buildColumns(this.getCellWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildColumns(float cellWidth) {
        if (this.isCheckList()) {
            return;
        }
        ListBox listBox = this;
        synchronized (listBox) {
            int fillWidth = this.origWidth;
            int columnCount = Math.round((float)fillWidth / cellWidth);
            int nColumns = 0;
            if (this.displayColumns != null) {
                Integer[] dcs = new Integer[this.displayColumns.size()];
                Integer[] seps = null;
                if (this.separators != null) {
                    seps = new Integer[this.separators.size()];
                    this.separators.toArray(seps);
                }
                String[] als = null;
                if (this.alignments != null) {
                    als = new String[this.alignments.size()];
                    this.alignments.toArray(als);
                }
                Integer[] divs = null;
                if (this.dividers != null) {
                    divs = new Integer[this.dividers.size()];
                    this.dividers.toArray(divs);
                }
                this.displayColumns.toArray(dcs);
                this.column = new Column[dcs.length + 1];
                int previousIdx = 1;
                int i = 0;
                while (i < dcs.length) {
                    this.column[i] = new Column();
                    int dc = dcs[i];
                    if (dc > columnCount) break;
                    this.column[i].width = Math.round((float)(dc - previousIdx) * cellWidth);
                    if (seps != null) {
                        if (i < seps.length) {
                            this.column[i].separator = this.getSepWidth(seps[i]);
                        }
                    } else {
                        this.column[i].separator = this.getSepWidth(this.gf.getColumnSeparation());
                    }
                    this.column[i].alignment = als != null && i < als.length ? this.getAlignValue(als[i]) : 0;
                    if (divs != null && i < divs.length) {
                        this.column[i].divider = divs[i];
                    }
                    previousIdx = dc;
                    fillWidth -= this.column[i].width;
                    ++i;
                    ++nColumns;
                }
                if (previousIdx <= columnCount) {
                    ++nColumns;
                    this.column[i] = new Column();
                    this.column[i].width = fillWidth;
                    if (seps != null) {
                        if (i < seps.length) {
                            this.column[i].separator = this.getSepWidth(seps[i]);
                        }
                    } else {
                        this.column[i].separator = this.getSepWidth(this.gf.getColumnSeparation());
                    }
                    if (this.alignments != null && i < als.length) {
                        this.column[i].alignment = this.getAlignValue(als[i]);
                    }
                }
            } else {
                this.column = new Column[]{new Column()};
                this.column[0].width = fillWidth;
                nColumns = 1;
            }
            if (nColumns < this.column.length) {
                Column[] tmp = this.column;
                this.column = new Column[nColumns];
                System.arraycopy(tmp, 0, this.column, 0, nColumns);
            }
        }
        this.renderer.updateRenderer();
        this.doLayout();
    }

    private int getSepWidth(int s) {
        return (int)(this.cellWidth / 10.0f * (float)s);
    }

    private int getAlignValue(String a) {
        if ((a = a.toUpperCase()).startsWith("C")) {
            return 1;
        }
        if (a.startsWith("R")) {
            return 2;
        }
        if (a.startsWith("L")) {
            return 3;
        }
        return 0;
    }

    protected LocalFontCmp getFontCmp() {
        if (this.font != null) {
            return new SwingFontCmp(this.gf, this.font);
        }
        return null;
    }

    public int getRows() {
        return this.rows;
    }

    private int getFirstVisibleIndex() {
        if (this.checkList) {
            Rectangle visRect = this.checkScrollPane.getViewport().getViewRect();
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                if (!visRect.contains(this.checkPanel.getComponent(i).getBounds())) continue;
                return i;
            }
            return -1;
        }
        return this.list.getFirstVisibleIndex();
    }

    private void setPrototypeCellValue(Object o) {
        if (!this.checkList) {
            this.list.setPrototypeCellValue(o);
        }
    }

    private void setFixedCellWidth(int fcw) {
        if (!this.checkList) {
            this.list.setFixedCellWidth(fcw);
        }
    }

    private void setFixedCellHeight(int fch) {
        if (!this.checkList) {
            this.list.setFixedCellHeight(fch);
        }
    }

    public int getFixedCellHeight() {
        return this.list.getFixedCellHeight();
    }

    String[] buildTokens(ListItem item) {
        String[] tokens;
        if (!this.isCheckList() && this.dataColumns != null) {
            int dtc;
            int len;
            Integer[] dtcs = new Integer[this.dataColumns.size()];
            char[] cStream = null;
            byte[] bStream = null;
            if (item.bytes != null) {
                bStream = item.bytes;
                len = bStream.length;
            } else {
                cStream = item.text.toCharArray();
                len = cStream.length;
            }
            this.dataColumns.toArray(dtcs);
            tokens = new String[dtcs.length + 1];
            int previousIdx = 0;
            for (int i = 0; i < dtcs.length && (dtc = dtcs[i] - 1) <= len; ++i) {
                if (bStream != null) {
                    try {
                        tokens[i] = new String(bStream, previousIdx, dtc - previousIdx, ListItem.encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        tokens[i] = "";
                    }
                } else {
                    tokens[i] = new String(cStream, previousIdx, dtc - previousIdx);
                }
                previousIdx = dtc;
            }
            if (previousIdx < len) {
                if (bStream != null) {
                    try {
                        tokens[i] = new String(bStream, previousIdx, bStream.length - previousIdx, ListItem.encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        tokens[i] = "";
                    }
                } else {
                    tokens[i] = new String(cStream, previousIdx, cStream.length - previousIdx);
                }
            }
        } else {
            tokens = new String[]{item.text};
        }
        return tokens;
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    int getModelItemCount() {
        return this.model.model.getSize();
    }

    JList getList() {
        return this.list;
    }

    protected PicobolWidget[] getButtons() {
        return this.buttons;
    }

    @Override
    public void setVisible(boolean v) {
        boolean old = this.isVisible();
        super.setVisible(v);
        if (!this.checkList && v != old) {
            if (v) {
                this.doLayout();
                if (this.searchBox != null && this.searchBox.isVisible()) {
                    this.addSearchBoxListeners();
                }
                if (this.paged) {
                    this.firstCardLayout.first(this.firstCardPanel);
                    this.lastCardLayout.first(this.lastCardPanel);
                }
            } else if (this.getParent() != null) {
                Rectangle r = super.getBounds();
                this.getParent().repaint(r.x, r.y, r.width, r.height);
                if (this.searchBox != null) {
                    this.removeSearchBoxListeners();
                }
            }
        }
    }

    @Override
    public void doLayout() {
        new IsguiWorker(false, () -> {
            ListBox.super.doLayout();
            if (this.checkList) {
                if (this.checkScrollPane != null) {
                    this.checkScrollPane.doLayout();
                }
            } else {
                if (this.listScrollPane != null) {
                    this.listScrollPane.doLayout();
                }
                if (this.paged) {
                    this.buttonPanel.doLayout();
                }
            }
        }).start();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.checkList) {
            this.checkScrollPane.setEnabled(b);
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                this.checkPanel.getComponent(i).setEnabled(b);
            }
        } else {
            this.list.setEnabled(b);
            if (this.listScrollPane != null) {
                this.listScrollPane.setEnabled(b);
                this.listScrollPane.getHorizontalScrollBar().setEnabled(b);
                this.listScrollPane.getVerticalScrollBar().setEnabled(b);
                this.listScrollPane.setWheelScrollingEnabled(b);
            }
            if (this.buttons != null) {
                for (int i = 0; i < this.buttons.length; ++i) {
                    this.buttons[i].setEnabled(b);
                }
            }
            if (this.buttonPanel != null) {
                this.buttonPanel.setEnabled(b);
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.checkList) {
            if (this.focusedButton != null) {
                this.focusedButton.requestFocus();
            } else if (this.checkPanel.getComponentCount() > 0) {
                int idx;
                if (this.getSelectionMode() == 0) {
                    idx = this.getSelectedIndex();
                    if (idx < 0) {
                        idx = 0;
                    }
                } else {
                    idx = 0;
                }
                this.checkPanel.getComponent(idx).requestFocus();
            } else {
                this.checkPanel.requestFocus();
            }
        } else if (this.searchBox != null && this.searchBox.isVisible()) {
            this.searchBox.requestFocus();
            this.searchBox.repaint();
        } else {
            this.list.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean b;
        if (this.checkList) {
            if (this.focusedButton != null) {
                b = this.focusedButton.requestFocusInWindow();
            } else if (this.checkPanel.getComponentCount() > 0) {
                int idx;
                if (this.getSelectionMode() == 0) {
                    idx = this.getSelectedIndex();
                    if (idx < 0) {
                        idx = 0;
                    }
                } else {
                    idx = 0;
                }
                b = this.checkPanel.getComponent(idx).requestFocusInWindow();
            } else {
                b = this.checkPanel.requestFocusInWindow();
            }
        } else if (this.searchBox != null && this.searchBox.isVisible()) {
            b = this.searchBox.requestFocusInWindow();
            this.searchBox.repaint();
        } else {
            b = this.list.requestFocusInWindow();
        }
        return b;
    }

    @Override
    public void setFocusable(boolean b) {
        if (this.checkList) {
            for (int i = 0; i < this.checkPanel.getComponentCount(); ++i) {
                this.checkPanel.getComponent(i).setFocusable(b);
            }
        } else if (this.list != null) {
            this.list.setFocusable(b);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.origWidth > 0 && this.origHeight > 0 && this.fontHeight > 0) {
            return new Rectangle(this.getX(), this.getY(), this.origWidth, this.origHeight);
        }
        return super.getBounds();
    }

    @Override
    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.origWidth, this.origHeight);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (!(this.checkList || w == this.origWidth && h == this.origHeight || this.fontHeight <= 0)) {
            this.origWidth = w;
            this.origHeight = h;
            super.setBounds(x, y, this.origWidth, this.origHeight);
            this.rows = this.origHeight / this.fontHeight;
            this.buildColumns(this.getCellWidth());
            this.revalidate();
        } else {
            super.setBounds(x, y, w, h);
        }
    }

    private float getCellWidth() {
        IscobolLayout.LayoutData lData;
        if (this.isLmOnColumns() && (lData = this.getIscobolLayoutData()) != null) {
            int w = this.getSize().width;
            if (this.cellWidth > 0.0f && w != lData.getOrigBounds().width) {
                return this.cellWidth * (float)w / (float)lData.getOrigBounds().width;
            }
        }
        return this.cellWidth;
    }

    @Override
    public void setSize(int w, int h) {
        this.setBounds(this.getX(), this.getY(), w, h);
    }

    public Point getReferencedPopupLocation(MouseEvent event) {
        return new Point(event.getX() - this.XPos, event.getY() - this.YPos);
    }

    public void setMouseWheelLinesToScroll(int l) {
        if (l > 0) {
            this.mousewheellinestoscroll = l;
        }
    }

    public Object getHiddenDataItemAt(int idx) {
        ListItem lItem;
        this.fireNtfChange = false;
        Object Return2 = null;
        if (idx >= 0 && idx < this.getItemCount() && (lItem = (ListItem)this.model.getElementAt(idx)) != null && lItem.getHiddenData() != null) {
            Return2 = lItem.getHiddenData();
        }
        this.fireNtfChange = true;
        return Return2;
    }

    public ListItem getListItemAt(int idx) {
        if (idx >= 0 && idx < this.getItemCount()) {
            return (ListItem)this.model.getElementAt(idx);
        }
        return null;
    }

    ListItem getModelListItemAt(int idx) {
        if (idx >= 0 && idx < this.getModelItemCount()) {
            return (ListItem)this.model.model.getElementAt(idx);
        }
        return null;
    }

    Color getBackgroundColor(ListItem item, int index) {
        if (item != null && item.getBackground() != null) {
            return item.getBackground();
        }
        if (this.rowColorPatterns != null) {
            if (this.rowColorPatterns.size() > 1) {
                int size = this.rowColorPatterns.size();
                return ((Color[])this.rowColorPatterns.elementAt(index % size))[0];
            }
            if (this.rowColorPatterns.size() > 0) {
                return ((Color[])this.rowColorPatterns.elementAt(0))[0];
            }
        }
        return null;
    }

    Color getForegroundColor(ListItem item, int index) {
        if (item != null && item.getForeground() != null) {
            return item.getForeground();
        }
        if (this.rowColorPatterns != null) {
            if (this.rowColorPatterns.size() > 1) {
                int size = this.rowColorPatterns.size();
                return ((Color[])this.rowColorPatterns.elementAt(index % size))[1];
            }
            if (this.rowColorPatterns.size() > 0) {
                return ((Color[])this.rowColorPatterns.elementAt(0))[1];
            }
        }
        return null;
    }

    boolean hasButtonsOrScrollBar() {
        if (this.checkList) {
            return false;
        }
        boolean r = this.paged || this.listScrollPane != null && this.listScrollPane.getVerticalScrollBar() != null && this.listScrollPane.getVerticalScrollBar().isVisible() && this.listScrollPane.getVerticalScrollBar().getSize().width > 0;
        return r;
    }

    private boolean checkMenuSelected(Component c) {
        Component[] controls;
        boolean Return2 = false;
        if (c == null) {
            return Return2;
        }
        if (c instanceof JMenu && ((JMenu)c).isSelected()) {
            return true;
        }
        if (c instanceof Container && (controls = ((Container)c).getComponents()) != null) {
            for (int j = 0; !Return2 && j < controls.length; ++j) {
                if (controls[j] instanceof JMenu && ((JMenu)controls[j]).isSelected()) {
                    return true;
                }
                Return2 = this.checkMenuSelected(controls[j]);
            }
        }
        return Return2;
    }

    public void copyItems(ListBox source) {
        int itemCount = source.getItemCount();
        ListItem newit = null;
        String tmp = null;
        for (int i = 0; i < itemCount; ++i) {
            tmp = source.getItemAt(i);
            newit = new ListItem(tmp);
            this.addItem(newit, i);
        }
    }

    public boolean isLmOnColumns() {
        return this.lmOnColumns;
    }

    public void setLmOnColumns(boolean lmOnColumns) {
        this.lmOnColumns = lmOnColumns;
    }

    @Override
    public void setName(String s) {
        if (this.list != null) {
            this.list.setName(s);
        }
    }

    public void setSelectionMode(int mode) {
        int oldMode = this.selectionMode;
        this.selectionMode = mode;
        if (this.checkList) {
            if (oldMode != mode) {
                boolean ss2;
                boolean ss1 = oldMode == 0;
                boolean bl = ss2 = mode == 0;
                if (ss1 != ss2) {
                    this.fireNtfChange = false;
                    Vector<JToggleButton> tmp = new Vector<JToggleButton>();
                    while (this.checkPanel.getComponentCount() > 0) {
                        tmp.add(this.removeCheckItem0(0));
                    }
                    boolean o = !this.gradientMgr.isPaintGradient();
                    for (int i = 0; i < tmp.size(); ++i) {
                        JToggleButton btn1 = (JToggleButton)tmp.elementAt(i);
                        JToggleButton btn2 = this.addCheckItem(btn1.getText(), btn1.getBackground(), btn1.getForeground(), -1);
                        if (this.opaqueButtons.contains(btn1)) {
                            this.opaqueButtons.remove(btn1);
                            this.opaqueButtons.add(btn2);
                            btn2.setOpaque(true);
                        } else {
                            btn2.setOpaque(o);
                        }
                        if (btn1 == this.focusedButton) {
                            this.focusedButton = btn2;
                        }
                        if (btn1.isSelected()) {
                            btn2.setSelected(true);
                        }
                        if (i != 0) continue;
                        this.checkScrollPane.getVerticalScrollBar().setUnitIncrement(btn2.getPreferredSize().height + btn2.getMargin().top + btn2.getMargin().bottom);
                    }
                    this.checkPanel.doLayout();
                    this.checkScrollPane.doLayout();
                    this.fireNtfChange = true;
                }
            }
        } else {
            int[] idxs;
            this.list.setSelectionMode(mode);
            if (oldMode != mode && mode == 0 && (idxs = this.list.getSelectedIndices()).length > 0) {
                this.list.setSelectedIndex(idxs[idxs.length - 1]);
            }
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public String getSearchText() {
        return this.searchBox != null ? this.searchBox.getText() : "";
    }

    Column[] getColumns() {
        return this.column;
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
        if (this.list != null) {
            this.list.setBorder(null);
        }
    }

    public void setCheckList(boolean checkList) {
        if (this.checkList != checkList) {
            this.intSetCheckList(checkList);
        }
    }

    private void intSetCheckList(boolean checkList) {
        this.checkList = checkList;
        this.removeAll();
        if (this.checkList) {
            this.buildCheckList();
        } else {
            this.buildStandardList();
        }
    }

    private void buildCheckList() {
        this.radioGroup = new MyButtonGroup();
        this.checkPanel = new JPanel(){
            Insets insets = new Insets(0, 4, 0, 0);

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.checkPanel.setOpaque(false);
        this.checkPanel.setLayout(new BoxLayout(this.checkPanel, 1));
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(40, 0));
        this.checkPanel.setFocusTraversalKeys(0, set);
        set = new HashSet();
        set.add(KeyStroke.getKeyStroke(38, 0));
        this.checkPanel.setFocusTraversalKeys(1, set);
        this.checkPanel.setFocusCycleRoot(true);
        this.checkScrollPane = new MyScrollPane(this.checkPanel);
        this.checkScrollPane.setFocusable(false);
        this.checkScrollPane.getVerticalScrollBar().setFocusable(false);
        this.checkScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.checkPanel.addMouseListener(this.checkListMouseListener);
        this.checkScrollPane.getVerticalScrollBar().addMouseListener(this.checkListMouseListener);
        this.checkScrollPane.getHorizontalScrollBar().addMouseListener(this.checkListMouseListener);
        this.add((Component)this.checkScrollPane, "Center");
        JList target = new JList();
        this.setBackground(new Color(target.getBackground().getRGB()));
        this.setForeground(new Color(target.getForeground().getRGB()));
        this.setFont(target.getFont());
        this.dragcomponent = target;
    }

    private void buildStandardList() {
        this.listPanel = new JPanel();
        OverlayLayout ol = new OverlayLayout(this.listPanel);
        this.listPanel.setLayout(ol);
        this.add((Component)this.listPanel, "Center");
        this.list = new JListWithDividers(this.model.model);
        if (this.ked == null) {
            this.ked = new KeyEventDispatcher(){
                boolean skip;

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getSource() == ListBox.this.list) {
                        if (e.getID() == 401) {
                            this.skip = ListBox.this.paged && ListBox.this.isNoSearch && e.getKeyChar() >= ' ' && e.getKeyChar() <= '~' && e.getModifiers() == 0;
                            return this.skip;
                        }
                        if (e.getID() == 400 && this.skip) {
                            this.skip = false;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.ked);
        this.renderer = new FastCellRenderer();
        this.list.setCellRenderer(this.renderer);
        this.list.setAlignmentX(1.0f);
        this.intSetPaged(this.paged);
        if (this.paged) {
            this.intSetNoSearch(this.isNoSearch);
        }
        MouseInputAdapter ma = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ListBox.this.nmListener != null) {
                    int idx = ListBox.this.list.locationToIndex(e.getPoint());
                    Rectangle rect = ListBox.this.list.getCellBounds(idx, idx);
                    if (rect != null) {
                        if (rect.y + rect.height >= e.getY()) {
                            if (ListBox.this.list.locationToIndex(e.getPoint()) >= 0) {
                                ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(e.getSource(), 17023, ListBox.this.list.locationToIndex(e.getPoint()) + 1, 1));
                            }
                        } else {
                            ListBox.this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(e.getSource(), 17024, 0, 0));
                        }
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ListBox.this.searchBox.isVisible()) {
                    ListBox.this.intHideSearchBox(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                PagedListBoxEvent ple;
                if (ListBox.this.list.getSelectedIndex() == ListBox.this.list.getLastVisibleIndex() && ListBox.this.ped == null) {
                    ple = new PagedListBoxEvent((Object)ListBox.this.pListeners, 2103, 1);
                    (ListBox.this.ped = new PagedEventDispatcher(ListBox.this.pListeners, ple)).start();
                }
                if (ListBox.this.list.getSelectedIndex() == ListBox.this.list.getFirstVisibleIndex() && ListBox.this.ped == null) {
                    ple = new PagedListBoxEvent((Object)ListBox.this.pListeners, 2100, 1);
                    (ListBox.this.ped = new PagedEventDispatcher(ListBox.this.pListeners, ple)).start();
                }
            }
        };
        this.list.addMouseListener(ma);
        this.list.addMouseMotionListener(ma);
        WindowFocusListener wfl = new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (ListBox.this.ped != null) {
                    ListBox.this.ped.stop();
                    ListBox.this.ped = null;
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        };
        Window[] pw = new Window[1];
        this.list.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 1L) == 1L) {
                if (this.list.getParent() != null) {
                    for (Container cnt = this.list.getParent(); cnt != null; cnt = cnt.getParent()) {
                        if (!(cnt instanceof Window)) continue;
                        pw[0] = (Window)cnt;
                        pw[0].addWindowFocusListener(wfl);
                        break;
                    }
                } else if (pw[0] != null) {
                    pw[0].removeWindowFocusListener(wfl);
                }
            }
        });
        this.dragcomponent = this.list;
    }

    public boolean isCheckList() {
        return this.checkList;
    }

    public Color getSelectionForeground() {
        if (this.checkList) {
            return this.getForeground();
        }
        return this.list.getSelectionForeground();
    }

    public Color getSelectionBackground() {
        if (this.checkList) {
            return this.getBackground();
        }
        return this.list.getSelectionBackground();
    }

    public void setSelectionForeground(Color c) {
        if (!this.checkList) {
            this.list.setSelectionForeground(c);
        }
    }

    public void setSelectionBackground(Color c) {
        if (!this.checkList) {
            this.list.setSelectionBackground(c);
        }
    }

    public boolean getActiveAccept() {
        if (this.checkList) {
            return true;
        }
        return this.list.getActiveAccept();
    }

    public void setActiveAccept(boolean b) {
        if (!this.checkList) {
            this.list.setActiveAccept(b);
        }
    }

    public int getUpperLowerMethod() {
        return this.upperLowerMethod;
    }

    public void setUpperLowerMethod(int upperLowerMethod) {
        this.upperLowerMethod = upperLowerMethod;
    }

    public boolean isF4ShowsSearchBox() {
        return this.f4ShowsSearchBox;
    }

    public void setF4ShowsSearchBox(boolean f4ShowsSearchBox) {
        this.f4ShowsSearchBox = f4ShowsSearchBox;
    }

    public void refreshItem(ListItem item) {
        if (this.checkList) {
            int idx = this.model.delegate.indexOf(item);
            if (idx >= 0 && idx < this.checkPanel.getComponentCount()) {
                JToggleButton btn = (JToggleButton)this.checkPanel.getComponent(idx);
                if (item.getBackground() != null) {
                    btn.setBackground(item.getBackground());
                    btn.setOpaque(true);
                    this.opaqueButtons.add(btn);
                } else {
                    btn.setOpaque(!this.gradientMgr.isPaintGradient());
                    this.opaqueButtons.remove(btn);
                }
                if (item.getForeground() != null) {
                    btn.setForeground(item.getForeground());
                }
            }
        } else {
            this.list.repaint();
        }
    }

    public int getLastMouseSelectedIndex() {
        return this.lastMouseSelectedIndex;
    }

    public void setSearchPanel(int v) {
        this.setSearchPanel(v, false);
    }

    private void setSearchPanel(int v, boolean force) {
        boolean changed = this.prop_SEARCH_PANEL != v;
        this.prop_SEARCH_PANEL = v;
        if (this.panelfind != null && changed) {
            this.panelfind.closeperformed();
            this.panelfind = null;
        }
        if ((force || changed) && v == 1) {
            this.Find();
        }
    }

    public int getSearchPanel() {
        return this.prop_SEARCH_PANEL;
    }

    private boolean showFindPanel(KeyEvent ke) {
        if (this.gf.getRemoteVirtualKeyboard().isSearchKey(ke.getKeyCode(), ke.isShiftDown(), ke.isControlDown(), ke.isAltDown(), "list-box")) {
            if (this.prop_SEARCH_PANEL == 0) {
                this.Find();
                return true;
            }
            if (this.prop_SEARCH_PANEL == 1 && this.panelfind != null) {
                this.panelfind.findfieldrequestFocus();
                return true;
            }
            return false;
        }
        return false;
    }

    public void Find(int action) {
        this.prop_ACTION = action;
        this.Find();
    }

    private void Find() {
        if (this.panelfind == null) {
            this.panelfind = new FindJPanel(this.getFont(), this.closeIcon, this.findIcon, this.clearIcon, this.casesensitiveIcon, this.casenotsensitiveIcon, this.prop_SEARCH_PANEL, this.findtimerdelay, this.searchPanelSettings[4], this.searchPanelSettings[0], this.searchPanelSettings[1], this.searchPanelSettings[5], this.searchPanelSettings[3], this.searchPanelSettings[2], true){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(this.getSize().width, 32);
                }

                @Override
                public Insets getInsets() {
                    return new Insets(3, 3, 3, 3);
                }
            };
            this.panelfind.setFindListener(this);
            this.add((Component)this.panelfind, "North");
            this.revalidate();
            this.doLayout();
        } else {
            this.panelfind.setVisible(true);
        }
        this.panelfind.findfieldrequestFocus();
    }

    public void findText(String regexptxt, boolean starttimer, boolean casesensitive) {
        this.findText(regexptxt, starttimer, casesensitive, false);
    }

    @Override
    public void findText(String regexptxt, boolean starttimer, boolean casesensitive, boolean isfilteritems) {
        if (starttimer && this.findTimer != null) {
            this.findTimer.setFindText(regexptxt, casesensitive, isfilteritems);
            this.findTimer.restart();
        } else {
            if (this.findTimer != null) {
                this.findTimer.stop();
            }
            EventQueue.invokeLater(() -> this.model.intfindText(regexptxt, casesensitive, isfilteritems));
        }
        if (this.renderer != null) {
            this.renderer.updateRenderer();
        }
    }

    @Override
    public void findTextClear(boolean all) {
        this.findTextClear();
    }

    public void findTextClear() {
        this.model.findTextClear();
    }

    @Override
    public boolean isFindKeyPressed(KeyEvent evt) {
        int cobFun = this.gf.getRemoteVirtualKeyboard().mapKey(evt);
        return this.gf.getRemoteVirtualKeyboard().isSearchKey(cobFun, evt.isShiftDown(), evt.isControlDown(), evt.isAltDown(), "lsitbox");
    }

    @Override
    public void refreshSelection() {
    }

    @Override
    public void sendfinishfiltermsg() {
        if (this.findTimer != null) {
            this.findTimer.stop();
        }
    }

    public void setPW(Window parentwindow) {
        this.parentwindow = parentwindow;
        this.lastCursor = parentwindow != null ? parentwindow.getCursor() : null;
    }

    public int[] getSelectedIndicesModel() {
        if (this.checkList || this.isClosePanelFind()) {
            return this.getSelectedIndices();
        }
        int[] selIdxs = this.getSelectedIndices();
        if (selIdxs != null && selIdxs.length > 0) {
            ListItem li = null;
            int[] ret = new int[selIdxs.length];
            for (int i = 0; i < selIdxs.length; ++i) {
                li = (ListItem)this.model.getElementAt(this.model.convertRowIndexToModel(selIdxs[i]));
                if (li == null) continue;
                ret[i] = this.model.delegate.indexOf(li);
            }
            return ret;
        }
        return new int[0];
    }

    public int convertRowIndexToModel(int idx) {
        if (this.checkList || this.isClosePanelFind()) {
            return idx;
        }
        return this.model.convertRowIndexToModel(idx);
    }

    public int getSelectedIndexModel() {
        if (this.checkList || this.isClosePanelFind()) {
            return this.getSelectedIndex();
        }
        int selidx = this.list.getSelectedIndex();
        return selidx >= 0 ? this.model.convertRowIndexToModel(selidx) : selidx;
    }

    public String getSelectedValueModel() {
        if (this.checkList || this.isClosePanelFind()) {
            return this.getSelectedValue();
        }
        int idx = this.getSelectedIndex();
        ListItem li = null;
        if (idx >= 0) {
            li = (ListItem)this.model.getElementAt(this.model.convertRowIndexToModel(idx));
        }
        return li != null ? li.toString() : null;
    }

    private boolean isClosePanelFind() {
        return this.panelfind == null || !this.panelfind.isVisible();
    }

    private String cutString(LocalFontCmp fcmp, String orig, int maxWidth) {
        int i;
        FontMetrics fm = fcmp.getFontMetrics();
        int origWidth = fm.stringWidth(orig);
        if (origWidth <= maxWidth) {
            return orig;
        }
        for (i = orig.length() - 1; i >= 0 && origWidth > maxWidth; origWidth -= fm.charWidth(orig.charAt(i)), --i) {
        }
        if (i < 0) {
            return "";
        }
        return orig.substring(0, i + 1);
    }

    private void printMatcher(Graphics g, String tk, int cwidth, int textX, int textY, int height, LocalFontCmp fcmp, ListItem item, AbstractButton ab) {
        int ofsmatchstart = -1;
        int ofsmatchend = -1;
        String t = this.cutString(fcmp, tk, cwidth);
        if (t != null && t.length() > 0) {
            boolean go = false;
            int matcherstart = -1;
            int matcherend = -1;
            String tmatcher = null;
            if (item.matcher != null) {
                item.matcher.reset(t);
                if (item.matcher.find()) {
                    int idx = 0;
                    int numbermatch = 0;
                    while (item.matcher.find(idx)) {
                        matcherstart = item.matcher.start();
                        matcherend = item.matcher.end();
                        tmatcher = item.matcher.group();
                        this.printMatcherElem(g, t, textX, textY, height, matcherstart, matcherend, numbermatch++, tmatcher, ab, item);
                        idx = matcherend;
                    }
                    go = true;
                }
            } else if (item.getmatchercoordinate() != null && item.getmatchercoordinate().size() > 0) {
                Point tmppoint = null;
                for (int i = 0; i < item.matchercoordinate.size(); ++i) {
                    tmppoint = (Point)item.matchercoordinate.elementAt(i);
                    this.printMatcherElem(g, t, textX, textY, height, tmppoint.x, tmppoint.y, i, tk, ab, item);
                }
                go = true;
            }
            if (!go) {
                g.drawString(t, textX, textY);
            }
        } else {
            g.drawString(t, textX, textY);
        }
    }

    private void printMatcherElem(Graphics g, String t, int textX, int textY, int height, int matcherstart, int matcherend, int idx, String tmatcher, AbstractButton ab, ListItem item) {
        int ofsmatchstart = -1;
        int ofsmatchend = -1;
        if (matcherstart >= 0 && matcherend > 0 && matcherend > matcherstart && matcherend <= t.length() && matcherend - matcherstart > 0) {
            Color savec = g.getColor();
            String t0 = "";
            String t1 = "";
            String t2 = "";
            try {
                t0 = t.substring(0, matcherstart);
                t1 = t.substring(matcherstart, matcherend);
                t2 = t.substring(matcherend, t.length());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            FontMetrics fm = this.getFontMetrics(g.getFont());
            ofsmatchstart = SwingUtilities.computeStringWidth(fm, t0);
            ofsmatchend = SwingUtilities.computeStringWidth(fm, tmatcher);
            textY = fm.getMaxAscent() + (ab.getHeight() - (fm.getAscent() + fm.getMaxDecent())) / 2;
            g.drawString(t0, textX += ab.getIconTextGap() + ab.getMargin().right + ab.getMargin().left + 2, textY);
            boolean ismatchcurrent = this.isCurrentMatchPoint(item, idx);
            if (ismatchcurrent) {
                g.setColor(this.matchingTextColor2Background);
            } else {
                g.setColor(this.matchingTextColorBackground);
            }
            g.fillRect(textX + ofsmatchstart, 0, ofsmatchend, height);
            if (ismatchcurrent) {
                g.setColor(this.matchingTextColor2Foreground);
            } else if (this.matchingTextColorForeground != null) {
                g.setColor(this.matchingTextColorForeground);
            } else {
                g.setColor(savec);
            }
            g.drawString(t1, textX + ofsmatchstart, textY);
            g.setColor(savec);
            g.drawString(t2, textX + ofsmatchstart + ofsmatchend, textY);
        }
    }

    public FindJPanel getFindPanel() {
        return this.panelfind;
    }

    public void setFontFindComponents(Font f) {
        if (this.panelfind != null) {
            this.panelfind.setFontFindComponents(f);
        }
    }

    public Font getFontFindComponents() {
        if (this.panelfind != null) {
            this.panelfind.getFontFindComponents();
        }
        return this.getFont();
    }

    public JComponent getDragDropComponent() {
        return this.dragcomponent;
    }

    public int getDropRow(Point p) {
        return this.dragcomponent.locationToIndex(p);
    }

    public void addNotifyMouseListener(NotifyMouseListener nmListener) {
        this.nmListener = nmListener;
    }

    public void removeNotifyMouseListener() {
        this.nmListener = null;
    }

    public void check(MouseEvent e) {
        Point pevt = e.getLocationOnScreen();
        Point pthis = this.getLocationOnScreen();
        Rectangle rect = new Rectangle(pthis.x, pthis.y, this.getBounds().width, this.getBounds().height);
        Insets its = this.getInsets();
        if (its != null) {
            rect.width -= its.left + its.right;
            rect.height -= its.top + its.bottom;
            pthis.x += its.left;
            pthis.y += its.top;
        }
        if ((pevt.x < pthis.x || pevt.x > pthis.x + rect.width || pevt.y < pthis.y || pevt.y > pthis.y + rect.height) && this.nmListener != null) {
            this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(e.getSource(), 17024, 0, 0));
        }
    }

    public void setMatchingTextColorBackground(Color matchingTextColorBackground) {
        this.matchingTextColorBackground = matchingTextColorBackground;
        if (matchingTextColorBackground == null) {
            matchingTextColorBackground = this.defaultMatchingTextColorBackground;
        }
    }

    public void setMatchingTextColorForeground(Color matchingTextColorForeground) {
        this.matchingTextColorForeground = matchingTextColorForeground;
    }

    public Color getMatchingTextColorBackground() {
        return this.matchingTextColorBackground;
    }

    public Color getMatchingTextColorForeground() {
        return this.matchingTextColorForeground;
    }

    public Color getMatchingTextColor2Background() {
        return this.matchingTextColor2Background;
    }

    public void setMatchingTextColor2Background(Color matchingTextColor2Background) {
        this.matchingTextColor2Background = matchingTextColor2Background;
    }

    public Color getMatchingTextColor2Foreground() {
        return this.matchingTextColor2Foreground;
    }

    public void setMatchingTextColor2Foreground(Color matchingTextColor2Foreground) {
        this.matchingTextColor2Foreground = matchingTextColor2Foreground;
    }

    public static boolean[] setSettings(String s, FindJPanel sp) {
        boolean[] b = new boolean[]{true, false, false, true, false, true};
        block0 : switch (s.length()) {
            case 4: {
                switch (s.charAt(3)) {
                    default: {
                        b[4] = false;
                        b[5] = false;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(false);
                        sp.setShowCaseSensitiveButton(false);
                        break;
                    }
                    case '1': {
                        b[4] = true;
                        b[5] = false;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(true);
                        sp.setShowCaseSensitiveButton(false);
                        break;
                    }
                    case '2': {
                        b[4] = false;
                        b[5] = true;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(false);
                        sp.setShowCaseSensitiveButton(true);
                        break;
                    }
                    case '3': {
                        b[4] = true;
                        b[5] = true;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(true);
                        sp.setShowCaseSensitiveButton(true);
                    }
                }
            }
            case 3: {
                switch (s.charAt(2)) {
                    default: {
                        b[3] = false;
                        if (sp == null) break;
                        sp.setShowCleanButton(false);
                        break;
                    }
                    case '1': {
                        b[3] = true;
                        if (sp == null) break;
                        sp.setShowCleanButton(true);
                    }
                }
            }
            case 2: {
                switch (s.charAt(1)) {
                    default: {
                        b[2] = false;
                        if (sp == null) break;
                        sp.setShowNavigationButtons(false);
                        break;
                    }
                    case '1': {
                        b[2] = true;
                        if (sp == null) break;
                        sp.setShowNavigationButtons(true);
                    }
                }
            }
            case 1: {
                switch (s.charAt(0)) {
                    default: {
                        b[0] = false;
                        b[1] = false;
                        if (sp == null) break block0;
                        sp.setFilterItems(false);
                        sp.setShowFilterButton(false);
                        break block0;
                    }
                    case '1': {
                        b[0] = true;
                        b[1] = false;
                        if (sp == null) break block0;
                        sp.setFilterItems(true);
                        sp.setShowFilterButton(false);
                        break block0;
                    }
                    case '2': {
                        b[0] = false;
                        b[1] = true;
                        if (sp == null) break block0;
                        sp.setFilterItems(false);
                        sp.setShowFilterButton(true);
                        break block0;
                    }
                    case '3': 
                }
                b[0] = true;
                b[1] = true;
                if (sp == null) break;
                sp.setFilterItems(true);
                sp.setShowFilterButton(true);
            }
        }
        return b;
    }

    public void setSearchPanelSetting(short sIdx, boolean s) {
        this.searchPanelSettings[sIdx] = s;
        if (this.panelfind != null) {
            switch (sIdx) {
                case 0: {
                    this.panelfind.setFilterItems(s);
                    break;
                }
                case 1: {
                    this.panelfind.setShowFilterButton(s);
                    break;
                }
                case 2: {
                    this.panelfind.setShowNavigationButtons(s);
                    break;
                }
                case 3: {
                    this.panelfind.setShowCleanButton(s);
                    break;
                }
                case 4: {
                    this.panelfind.setFilterCaseSensitive(s);
                    break;
                }
                case 5: {
                    this.panelfind.setShowCaseSensitiveButton(s);
                }
            }
        }
    }

    public void setSettings(boolean[] s) {
        if (this.panelfind != null) {
            this.panelfind.setSettings(s);
        } else {
            this.searchPanelSettings = s;
        }
    }

    @Override
    public void findNextText() {
        if (this.matchRows == null || this.matchRows.size() == 0) {
            return;
        }
        if (this.currentmatchrowidx == -1) {
            this.currentmatchrowidx = 0;
        } else if (this.currentmatchrowidx + 1 < this.matchRows.size()) {
            ++this.currentmatchrowidx;
        }
        this.currentmatchrowelem = this.matchRows.elementAt(this.currentmatchrowidx);
        if (this.checkList) {
            this.checkScrollPane.getViewport().repaint();
        } else if (this.paged) {
            this.list.repaint();
        } else {
            this.listScrollPane.getViewport().repaint();
        }
        this.repaintCurrentMatchRowElem();
    }

    @Override
    public void findPrevText() {
        if (this.matchRows == null || this.matchRows.size() == 0) {
            return;
        }
        if (this.currentmatchrowidx == -1) {
            this.currentmatchrowidx = 0;
        } else if (this.currentmatchrowidx - 1 >= 0) {
            --this.currentmatchrowidx;
        }
        this.currentmatchrowelem = this.matchRows.elementAt(this.currentmatchrowidx);
        if (this.checkList) {
            this.checkScrollPane.getViewport().repaint();
        } else if (this.paged) {
            this.list.repaint();
        } else {
            this.listScrollPane.getViewport().repaint();
        }
        this.repaintCurrentMatchRowElem();
    }

    private void repaintCurrentMatchRowElem() {
        int makeVisibleIdx = this.currentmatchrowelem.row;
        if (this.checkList && this.checkPanel != null) {
            if (makeVisibleIdx < this.checkPanel.getComponentCount()) {
                this.checkPanel.scrollRectToVisible(this.checkPanel.getComponent(makeVisibleIdx).getBounds());
                if (this.listScrollPane != null) {
                    this.listScrollPane.getViewport().scrollRectToVisible(this.checkPanel.getComponent(makeVisibleIdx).getBounds());
                } else if (this.checkScrollPane != null) {
                    this.checkScrollPane.getViewport().scrollRectToVisible(this.checkPanel.getComponent(makeVisibleIdx).getBounds());
                }
            }
        } else if (this.list != null) {
            this.list.ensureIndexIsVisible(makeVisibleIdx);
        }
    }

    public boolean isCurrentMatchPoint(ListItem li, int idx) {
        return this.currentmatchrowelem != null && this.currentmatchrowelem.li == li && idx == this.currentmatchrowelem.offset;
    }

    public int getcurrentmatchrowidx() {
        return this.currentmatchrowidx;
    }

    public CoordinateMatchFind getcurrentmatchrowelem() {
        return this.currentmatchrowelem;
    }

    public void intFocusGained() {
        if (this.prop_ACTION == 8 && this.panelfind != null) {
            this.panelfind.findfieldrequestFocus();
        }
        this.prop_ACTION = -1;
    }

    private class MyJRadioButton
    extends JRadioButton {
        public ListItem item;
        private LocalFontCmp fcmp;
        private int baseline;

        public MyJRadioButton(String text) {
            super(text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            ListBox listBox = ListBox.this;
            synchronized (listBox) {
                if (this.item != null && this.item.getmatcher() != null) {
                    this.fcmp = ListBox.this.getFontCmp();
                    super.paintComponent(g);
                    ListBox.this.printMatcher(g, this.getText(), this.getWidth(), this.getHorizontalTextPosition(), this.baseline, this.getHeight(), this.fcmp, this.item, this);
                } else {
                    super.paintComponent(g);
                }
            }
        }
    }

    private class MyJCheckBox
    extends JCheckBox {
        public ListItem item;
        private int height;
        private LocalFontCmp fcmp;
        private int baseline;

        public MyJCheckBox(String text) {
            super(text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            ListBox listBox = ListBox.this;
            synchronized (listBox) {
                if (this.item != null && this.item.getmatcher() != null) {
                    this.fcmp = ListBox.this.getFontCmp();
                    this.height = this.fcmp.getHeight();
                    super.paintComponent(g);
                    ListBox.this.printMatcher(g, this.getText(), this.getWidth(), this.getHorizontalTextPosition(), this.baseline, this.getHeight(), this.fcmp, this.item, this);
                } else {
                    super.paintComponent(g);
                }
            }
        }
    }

    private class FindTimer
    extends Timer
    implements ActionListener {
        String findtext;
        boolean casesensitive;
        boolean isfilteritems;

        public FindTimer(int delay) {
            super(delay, null);
            this.setRepeats(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ListBox.this.panelfind != null) {
                ListBox.this.findText(this.findtext, false, this.casesensitive, this.isfilteritems);
                ListBox.this.sendfinishfiltermsg();
            }
        }

        synchronized void setFindText(String findtext, boolean casesensitive, boolean isfilteritems) {
            this.findtext = findtext;
            this.casesensitive = casesensitive;
            this.isfilteritems = isfilteritems;
        }

        public String getFindText() {
            return this.findtext;
        }
    }

    private static class PagedListButton
    extends JButton
    implements PicobolWidget {
        private static final long serialVersionUID = 1L;
        private boolean activeAccept;

        public PagedListButton(ImageIcon icon) {
            super(icon);
        }

        @Override
        public boolean getActiveAccept() {
            return this.activeAccept;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean b) {
            this.activeAccept = b;
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public void setSelfAct(boolean b) {
        }
    }

    private class JListWithDividers
    extends JList
    implements PicobolWidget,
    KeyListener,
    ListSelectionListener,
    MouseWheelListener {
        private static final long serialVersionUID = 1L;
        private boolean activated;

        public JListWithDividers(ListModel model) {
            super(model);
            super.setSelectionMode(0);
            this.addListSelectionListener(this);
            this.addKeyListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (ListBox.this.paged && ListBox.this.gradientMgr.isPaintGradient()) {
                ListBox.this.gradientMgr.paint((Graphics2D)g, new Rectangle(new Point(0, 0), this.getSize()));
            }
            super.paintComponent(g);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            char ch = Character.toLowerCase(e.getKeyChar());
            if (!Character.isLetterOrDigit(ch)) {
                return;
            }
            for (int k = 0; k < ListBox.this.model.getSize(); ++k) {
                ListItem lItem = (ListItem)ListBox.this.model.getElementAt(k);
                if (lItem.text.length() <= 0 || lItem.text.charAt(0) != ch) continue;
                super.setSelectedIndex(k);
                super.ensureIndexIsVisible(k);
                break;
            }
        }

        @Override
        public Dimension getMaximumSize() {
            return ListBox.this.listPanel.getSize();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ListBox.this.fireNtfChange && this.activated && this.isEnabled() && !e.getValueIsAdjusting()) {
                ListBox.this.dispatchListSelectionEvent(e.getFirstIndex());
            }
        }

        void handleKeyPressed(int keyCode) {
            Enumeration en = ListBox.this.pListeners.elements();
            switch (keyCode) {
                case 38: {
                    if (this.getSelectedIndex() != 0) break;
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2100, 0);
                    while (en.hasMoreElements()) {
                        PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                        l.prevItem(evt);
                    }
                    return;
                }
                case 40: {
                    if (this.getSelectedIndex() != ListBox.this.model.getSize() - 1) break;
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2103, 0);
                    while (en.hasMoreElements()) {
                        PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                        l.nextItem(evt);
                    }
                    return;
                }
                case 33: {
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2101, 0);
                    while (en.hasMoreElements()) {
                        PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                        l.prevPage(evt);
                    }
                    return;
                }
                case 34: {
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2102, 0);
                    while (en.hasMoreElements()) {
                        PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                        l.nextPage(evt);
                    }
                    return;
                }
                case 36: {
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2099, 0);
                    while (en.hasMoreElements()) {
                        PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                        l.firstItem(evt);
                    }
                    return;
                }
                case 35: {
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2104, 0);
                    while (en.hasMoreElements()) {
                        PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                        l.lastItem(evt);
                    }
                    return;
                }
                case 16: {
                    ListBox.this.firstCardLayout.last(ListBox.this.firstCardPanel);
                    ListBox.this.lastCardLayout.last(ListBox.this.lastCardPanel);
                }
            }
        }

        @Override
        public void processEvent(AWTEvent e) {
            if (ListBox.this.paged) {
                switch (e.getID()) {
                    case 501: {
                        ListBox.this.lastMouseSelectedIndex = this.locationToIndex(((MouseEvent)e).getPoint());
                        break;
                    }
                    case 401: {
                        KeyEvent ke = (KeyEvent)e;
                        if (ListBox.this.showFindPanel(ke)) {
                            return;
                        }
                        if (ke.getKeyCode() != 16 && ke.getKeyCode() != 17) {
                            ListBox.this.lastMouseSelectedIndex = -2;
                        }
                        this.handleKeyPressed(ke.getKeyCode());
                        if (ke.getKeyCode() != 34 && ke.getKeyCode() != 33) break;
                        return;
                    }
                    case 402: {
                        KeyEvent ke = (KeyEvent)e;
                        if (ke.getKeyCode() != 16) break;
                        ListBox.this.firstCardLayout.first(ListBox.this.firstCardPanel);
                        ListBox.this.lastCardLayout.first(ListBox.this.lastCardPanel);
                    }
                }
            } else {
                switch (e.getID()) {
                    case 501: {
                        ListBox.this.lastMouseSelectedIndex = this.locationToIndex(((MouseEvent)e).getPoint());
                        break;
                    }
                    case 401: {
                        KeyEvent ke = (KeyEvent)e;
                        if (ListBox.this.showFindPanel(ke)) {
                            return;
                        }
                        if (ke.getKeyCode() == 16 || ke.getKeyCode() == 17) break;
                        ListBox.this.lastMouseSelectedIndex = -2;
                    }
                }
            }
            super.processEvent(e);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (ListBox.this.dividers != null) {
                this.drawDividers(g);
            }
        }

        private void drawDividers(Graphics g) {
            int x = 0;
            int boundsH = Math.max(this.getBounds().height, g.getClipBounds() != null ? g.getClipBounds().height : this.getBounds().height);
            for (int i = 0; i < ListBox.this.column.length; ++i) {
                g.setColor(Color.black);
                g.fillRect(x += ((ListBox)ListBox.this).column[i].width - ((ListBox)ListBox.this).column[i].divider, 0, ((ListBox)ListBox.this).column[i].divider, boundsH);
                x += ((ListBox)ListBox.this).column[i].divider;
            }
        }

        @Override
        public void setActiveAccept(boolean b) {
            this.activated = b;
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public boolean getActiveAccept() {
            return this.activated;
        }

        @Override
        public void setSelfAct(boolean b) {
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() != 0) {
                return;
            }
            if (!ListBox.this.paged) {
                JScrollBar vsb = ListBox.this.listScrollPane.getVerticalScrollBar();
                if (vsb != null) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(SwingUtilities.convertMouseEvent(this, e, vsb));
                }
                return;
            }
            int wheelRotation = e.getWheelRotation();
            int selIdx = -1;
            if (wheelRotation < 0) {
                selIdx = ListBox.this.mousewheellinestoscroll > 1 ? -ListBox.this.mousewheellinestoscroll : this.getSelectedIndex() + wheelRotation;
                if (selIdx < 0) {
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2100, 1);
                    for (int i = 0; i < -selIdx; ++i) {
                        Enumeration en = ListBox.this.pListeners.elements();
                        while (en.hasMoreElements()) {
                            PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                            l.prevItem(evt);
                        }
                    }
                } else {
                    this.setSelectedIndex(selIdx);
                }
            } else if (wheelRotation > 0) {
                selIdx = ListBox.this.mousewheellinestoscroll > 1 ? -ListBox.this.mousewheellinestoscroll : ListBox.this.model.getSize() - 1 - this.getSelectedIndex() - wheelRotation;
                if (selIdx < 0) {
                    PagedListBoxEvent evt = new PagedListBoxEvent((Object)this, 2103, 1);
                    for (int i = 0; i < -selIdx; ++i) {
                        Enumeration en = ListBox.this.pListeners.elements();
                        while (en.hasMoreElements()) {
                            PagedListBoxListener l = (PagedListBoxListener)en.nextElement();
                            l.nextItem(evt);
                        }
                    }
                } else {
                    this.setSelectedIndex(ListBox.this.model.getSize() - 1 - selIdx);
                }
            }
        }
    }

    private class SearchDocumentListener
    implements DocumentListener {
        private boolean notifyRemove = true;

        private SearchDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            ListBox.this.dispatchSearchEvent(false);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (this.notifyRemove) {
                ListBox.this.dispatchSearchEvent(true);
            }
        }
    }

    private class SearchKeyListener
    extends KeyAdapter {
        private SearchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!e.isControlDown() && !e.isAltDown() && e.getKeyChar() >= ' ' && e.getKeyChar() <= '~') {
                if (!ListBox.this.searchBox.isVisible()) {
                    SwingUtilities.invokeLater(() -> {
                        ListBox.this.intShowSearchBox();
                        ListBox.this.searchBox.setText("" + e.getKeyChar());
                    });
                }
            } else {
                int edit = VirtualKeyboard.editing(ListBox.this.gf.getRemoteVirtualKeyboard().mapKey(e));
                switch (edit) {
                    case 196608: 
                    case 262144: {
                        if (!ListBox.this.searchBox.isVisible()) break;
                        ListBox.this.intHideSearchBox(true);
                        e.setSource(ListBox.this.list);
                        ListBox.this.list.processEvent(e);
                    }
                }
                switch (e.getKeyCode()) {
                    case 115: {
                        if (!ListBox.this.f4ShowsSearchBox) break;
                        if (!ListBox.this.searchBox.isVisible()) {
                            ListBox.this.intShowSearchBox();
                            break;
                        }
                        ListBox.this.intHideSearchBox(true);
                        break;
                    }
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 38: 
                    case 40: {
                        if (!ListBox.this.searchBox.isVisible()) break;
                        ListBox.this.intHideSearchBox(true);
                        e.setSource(ListBox.this.list);
                        ListBox.this.list.processEvent(e);
                    }
                }
            }
        }
    }

    private static class MyButtonGroup
    extends ButtonGroup {
        private MyButtonGroup() {
        }

        public Vector<AbstractButton> getButtons() {
            return this.buttons;
        }
    }

    static class ListItem {
        static final String encoding = CobolVar.encoding;
        byte[] bytes;
        String text;
        Object hiddendata;
        private int color;
        private int backgroundColor;
        private int foregroundColor;
        private Color foreground;
        private Color background;
        private Vector matchercoordinate = null;
        int matcherstart = -1;
        int matcherend = -1;
        String tmatcher = null;
        Matcher matcher = null;

        ListItem(String text) {
            this.text = text;
        }

        ListItem(byte[] bytes) {
            this.bytes = bytes;
            try {
                this.text = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException e) {
                this.text = "";
            }
        }

        public String toString() {
            return this.text;
        }

        public void setHiddenData(Object text) {
            this.hiddendata = text;
        }

        public Object getHiddenData() {
            return this.hiddendata;
        }

        public int getColor() {
            return this.color;
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }

        public int getForegroundColor() {
            return this.foregroundColor;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public void setBackgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public void setForegroundColor(int foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }

        public void setBackground(Color background) {
            this.background = background;
        }

        public void setmatcheridx(Matcher matcher, int matcherstart, int matcherend, String tmatcher) {
            this.setmatcheridx(matcher, matcherstart, matcherend, tmatcher, -1);
        }

        public void setmatcheridx(Matcher matcher, int matcherstart, int matcherend, String tmatcher, int idx) {
            this.matcher = matcher;
            if (matcher == null) {
                if (matcherstart == -1 && matcherend == -1) {
                    if (this.matchercoordinate != null) {
                        this.matchercoordinate.removeAllElements();
                    }
                    this.matchercoordinate = null;
                } else {
                    if (this.matchercoordinate == null) {
                        this.matchercoordinate = new Vector();
                    }
                    this.matchercoordinate.add(new Point(matcherstart, matcherend));
                }
                this.tmatcher = tmatcher;
            }
        }

        public void setmatcheridx(int matcherstart, int matcherend, String tmatcher) {
            this.setmatcheridx(null, matcherstart, matcherend, tmatcher);
        }

        public void clearmatcher() {
            this.matcher = null;
            if (this.matchercoordinate != null) {
                this.matchercoordinate.removeAllElements();
            }
            this.matchercoordinate = null;
            this.tmatcher = null;
        }

        public Vector getmatchercoordinate() {
            return this.matchercoordinate;
        }

        public String getmatchert() {
            return this.tmatcher;
        }

        public Matcher getmatcher() {
            return this.matcher;
        }
    }

    static class Column {
        int alignment;
        int divider;
        int separator;
        int width;

        Column() {
        }
    }

    private class FastCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private ListItem item;
        private int height;
        private LocalFontCmp fcmp;
        private int baseline;
        private boolean firstPaint = true;
        private boolean showBackground;

        private FastCellRenderer() {
        }

        public void updateRenderer() {
            this.fcmp = ListBox.this.getFontCmp();
            this.baseline = this.fcmp.getAscent();
            this.height = this.fcmp.getHeight();
            ListBox.this.setFixedCellWidth(0);
            ListBox.this.setFixedCellHeight(this.height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, this.height);
        }

        private String cutString(String orig, int maxWidth) {
            int i;
            FontMetrics fm = this.fcmp.getFontMetrics();
            int origWidth = fm.stringWidth(orig);
            if (origWidth <= maxWidth) {
                return orig;
            }
            for (i = orig.length() - 1; i >= 0 && origWidth > maxWidth; origWidth -= fm.charWidth(orig.charAt(i)), --i) {
            }
            if (i < 0) {
                return "";
            }
            return orig.substring(0, i + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            ListBox listBox = ListBox.this;
            synchronized (listBox) {
                Toolkit tlk;
                Map map;
                if (this.firstPaint) {
                    ListBox.this.setPrototypeCellValue(this.item);
                    this.firstPaint = false;
                }
                String[] tokens = ListBox.this.buildTokens(this.item);
                int x = 1;
                Font fontSave = g.getFont();
                Graphics2D g2 = (Graphics2D)g;
                if (AbstractGuiFactoryImpl.getFontHandlingProp() != 3 && (map = (Map)(tlk = Toolkit.getDefaultToolkit()).getDesktopProperty("awt.font.desktophints")) != null) {
                    g2.addRenderingHints(map);
                }
                g.setFont(ListBox.this.list.getFont());
                int buttonInset = ListBox.this.hasButtonsOrScrollBar() ? BUTTON_PANEL_WIDTH : 0;
                int numbermatch = 0;
                for (int i = 0; i < ListBox.this.column.length; ++i) {
                    String tk = "";
                    int sw = 0;
                    Column c = ListBox.this.column[i];
                    int colWidth = c.width;
                    if (i == ListBox.this.column.length - 1) {
                        colWidth -= buttonInset;
                    }
                    if (i == 0) {
                        --colWidth;
                    }
                    if (ListBox.this.list.isOpaque() || this.showBackground) {
                        g.setColor(this.getBackground());
                        g.fillRect(x, 0, colWidth, this.height);
                    }
                    if (i < tokens.length && tokens[i] != null) {
                        tk = c.alignment == 0 ? ScreenUtility.rightTrim(tokens[i]) : tokens[i].trim();
                        if (ListBox.this.isUpper()) {
                            tk = Factory.toUpperCase(tk, ListBox.this.upperLowerMethod);
                        } else if (ListBox.this.isLower()) {
                            tk = Factory.toLowerCase(tk, ListBox.this.upperLowerMethod);
                        }
                        sw = this.fcmp.computeScreenWidth(tk);
                        g.setColor(this.getForeground());
                        int pos = x;
                        int diff = colWidth - c.separator - sw;
                        if (diff > 0) {
                            if (c.alignment == 1) {
                                pos += diff / 2;
                            } else if (c.alignment == 2) {
                                pos += diff;
                            } else if (pos > 1) {
                                ++pos;
                            }
                        } else if (pos > 1) {
                            ++pos;
                        }
                        numbermatch = this.printMatcher(g, tk, c.width, pos, this.baseline, this.height, numbermatch);
                        if ((ListBox.this.list.isOpaque() || this.showBackground) && c.separator > 0) {
                            g.setColor(this.getBackground());
                            g.fillRect(x + colWidth - c.separator, 0, c.separator, this.height);
                        }
                    }
                    x += colWidth;
                }
                g.setFont(fontSave);
            }
        }

        private int printMatcher(Graphics g, String tk, int cwidth, int textX, int textY, int height, int numbermatch) {
            int Return2 = numbermatch;
            int ofsmatchstart = -1;
            int ofsmatchend = -1;
            String t = this.cutString(tk, cwidth);
            if (t != null && t.length() > 0) {
                boolean go = false;
                int matcherstart = -1;
                int matcherend = -1;
                String tmatcher = null;
                if (this.item.matcher != null) {
                    this.item.matcher.reset(t);
                    if (this.item.matcher.find()) {
                        int idx = 0;
                        while (this.item.matcher.find(idx)) {
                            matcherstart = this.item.matcher.start();
                            matcherend = this.item.matcher.end();
                            tmatcher = this.item.matcher.group();
                            this.printMatcherElem(g, t, textX, textY, height, matcherstart, matcherend, numbermatch++, tmatcher);
                            idx = matcherend;
                        }
                        go = true;
                    }
                } else if (this.item.getmatchercoordinate() != null && this.item.getmatchercoordinate().size() > 0) {
                    Point tmppoint = null;
                    for (int i = 0; i < this.item.matchercoordinate.size(); ++i) {
                        tmppoint = (Point)this.item.matchercoordinate.elementAt(i);
                        this.printMatcherElem(g, t, textX, textY, height, tmppoint.x, tmppoint.y, i, tk);
                    }
                    go = true;
                }
                if (!go) {
                    g.drawString(t, textX, textY);
                }
            } else {
                g.drawString(t, textX, textY);
            }
            return numbermatch;
        }

        private void printMatcherElem(Graphics g, String t, int textX, int textY, int height, int matcherstart, int matcherend, int idx, String tmatcher) {
            int ofsmatchstart = -1;
            int ofsmatchend = -1;
            if (matcherstart >= 0 && matcherend > 0 && matcherend > matcherstart && matcherend <= t.length() && matcherend - matcherstart > 0) {
                Color savec = g.getColor();
                String t0 = "";
                String t1 = "";
                String t2 = "";
                try {
                    t0 = t.substring(0, matcherstart);
                    t1 = t.substring(matcherstart, matcherend);
                    t2 = t.substring(matcherend, t.length());
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                FontMetrics fm = this.getFontMetrics(g.getFont());
                ofsmatchstart = SwingUtilities.computeStringWidth(fm, t0);
                ofsmatchend = SwingUtilities.computeStringWidth(fm, tmatcher);
                g.drawString(t0, textX, textY);
                boolean ismatchcurrent = ListBox.this.isCurrentMatchPoint(this.item, idx);
                if (ismatchcurrent) {
                    g.setColor(ListBox.this.matchingTextColor2Background);
                } else {
                    g.setColor(ListBox.this.matchingTextColorBackground);
                }
                g.fillRect(textX + ofsmatchstart, 0, ofsmatchend, height);
                if (ismatchcurrent) {
                    g.setColor(ListBox.this.matchingTextColor2Foreground);
                } else if (ListBox.this.matchingTextColorForeground != null) {
                    g.setColor(ListBox.this.matchingTextColorForeground);
                } else {
                    g.setColor(savec);
                }
                g.drawString(t1, textX + ofsmatchstart, textY);
                g.setColor(savec);
                g.drawString(t2, textX + ofsmatchstart + ofsmatchend, textY);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color fg;
            Color bg;
            if (isSelected) {
                bg = list.getSelectionBackground();
                fg = list.getSelectionForeground();
                this.showBackground = true;
            } else {
                bg = ListBox.this.getBackgroundColor((ListItem)ListBox.this.model.getElementAt(index), index);
                if (bg == null) {
                    bg = list.getBackground();
                    this.showBackground = false;
                } else {
                    this.showBackground = true;
                }
                fg = ListBox.this.getForegroundColor((ListItem)ListBox.this.model.getElementAt(index), index);
                if (fg == null) {
                    fg = list.getForeground();
                }
            }
            if (!list.isEnabled()) {
                bg = bg.darker();
                fg = fg.darker();
            }
            this.setBackground(bg);
            this.setForeground(fg);
            this.item = value instanceof ListItem ? (ListItem)value : new ListItem("");
            return this;
        }
    }

    private class FilteredListModel {
        private Vector<ListItem> delegate = new Vector();
        private final MyListModel model = new MyListModel();

        private FilteredListModel() {
        }

        public Object getElementAt(int index) {
            if (index >= 0 && index < this.delegate.size()) {
                return this.delegate.elementAt(index);
            }
            return null;
        }

        public int getSize() {
            return this.delegate.size();
        }

        public void addElement(ListItem item) {
            this.delegate.addElement(item);
            this.model.addElement(item);
            if (ListBox.this.findTimer != null && ListBox.this.findTimer.getFindText() != null) {
                ListBox.this.findTimer.restart();
            }
        }

        public void add(int idx, ListItem item) {
            int size = this.delegate.size();
            if (idx <= size) {
                this.delegate.add(idx, item);
                this.model.add(idx, item);
            } else {
                this.delegate.addElement(item);
                this.model.addElement(item);
            }
            if (ListBox.this.findTimer != null && ListBox.this.findTimer.getFindText() != null) {
                ListBox.this.findTimer.restart();
            }
        }

        public void removeElementAt(int idx) {
            if (idx >= 0 && idx < this.delegate.size()) {
                this.delegate.removeElementAt(idx);
                this.model.removeElementAt(idx);
                if (ListBox.this.findTimer != null && ListBox.this.findTimer.getFindText() != null) {
                    ListBox.this.findTimer.restart();
                }
            }
        }

        public void removeAllElements() {
            int size = this.delegate.size();
            if (size > 0) {
                this.delegate = new Vector();
                this.model.removeAllElements();
            }
        }

        public void intfindText(String regexptxt, boolean casesensitive, boolean isfilteritems) {
            ListBox.this.casesensitiveState = casesensitive;
            if (ListBox.this.matchRows == null) {
                ListBox.this.matchRows = new Vector();
            }
            ListBox.this.matchRows.removeAllElements();
            ListBox.this.currentmatchrowidx = -1;
            if (this.delegate != null && this.delegate.size() > 0) {
                ListBox.this.clearSelection();
                ListBox.this.panelfind.findfieldsetBorder(ListBox.this.syntaxborderok);
                if (regexptxt != null && regexptxt.length() > 0) {
                    if (ListBox.this.syntaxbordererr == null) {
                        ListBox.this.syntaxbordererr = BorderFactory.createLineBorder(Color.red);
                    }
                    if (!casesensitive) {
                        regexptxt = "(?i)" + regexptxt;
                    }
                    this.model.removeAllElements();
                    this.model.clear();
                    this.model.fireAdded = false;
                    boolean notfound = true;
                    Pattern regex = null;
                    try {
                        regex = Pattern.compile(regexptxt);
                    }
                    catch (PatternSyntaxException pse) {
                        ListBox.this.panelfind.findfieldsetBorder(ListBox.this.syntaxbordererr);
                        return;
                    }
                    ListBox.this.parentwindow.setCursor(BUSY_CURSOR);
                    ListBox.this.panelfind.findfieldsetBorder(ListBox.this.syntaxborderok);
                    Matcher matcher = regex.matcher("");
                    String matchertxt = "";
                    int i = 0;
                    int rowidx = 0;
                    for (ListItem it : this.delegate) {
                        matchertxt = it.toString();
                        if (matchertxt == null) {
                            it.setmatcheridx(null, -1, -1, "");
                            continue;
                        }
                        matcher.reset(matchertxt);
                        if (!isfilteritems || matcher.find()) {
                            this.model.addElement(it);
                        }
                        matcher.reset(matchertxt);
                        if (matcher.find()) {
                            int idx = 0;
                            int matchnumber = 0;
                            while (matcher.find(idx)) {
                                it.setmatcheridx(matcher, matcher.start(), matcher.end(), matcher.group(), idx);
                                ListBox.this.matchRows.add(new CoordinateMatchFind(it, rowidx, matchnumber++));
                                idx = matcher.end();
                            }
                        } else {
                            it.setmatcheridx(null, -1, -1, "");
                        }
                        ++rowidx;
                        ++i;
                    }
                    this.model.fireAdded = true;
                    this.model.update();
                    if (ListBox.this.listScrollPane != null) {
                        ListBox.this.listScrollPane.doLayout();
                    }
                    if (ListBox.this.checkScrollPane != null) {
                        ListBox.this.fireNtfChange = false;
                        ListBox.this.removeAllCheckItems();
                        for (int k = 0; k < this.model.getSize(); ++k) {
                            ListItem lItem = (ListItem)this.model.getElementAt(k);
                            ListBox.this.addCheckItem(lItem, k);
                        }
                        ListBox.this.fireNtfChange = true;
                        ListBox.this.checkScrollPane.doLayout();
                        ListBox.this.checkScrollPane.getViewport().repaint();
                    }
                    ListBox.this.setThumbPosition(ListBox.this.thumbPosition);
                    ListBox.this.parentwindow.setCursor(ListBox.this.lastCursor);
                } else {
                    this.findTextClear();
                }
            } else {
                this.findTextClear();
            }
        }

        public void findTextClear() {
            int[] selIdxs = ListBox.this.getSelectedIndices();
            if (selIdxs.length > 0) {
                Object li = null;
                for (int i = 0; i < selIdxs.length; ++i) {
                    li = (ListItem)this.model.getElementAt(this.convertRowIndexToModel(selIdxs[i]));
                    if (li == null) continue;
                    selIdxs[i] = this.delegate.indexOf(li);
                }
            }
            this.model.clear();
            this.model.fireAdded = false;
            for (ListItem it : this.delegate) {
                it.clearmatcher();
                this.model.addElement(it);
            }
            this.model.fireAdded = true;
            this.model.update();
            if (ListBox.this.listScrollPane != null) {
                ListBox.this.listScrollPane.doLayout();
            }
            if (ListBox.this.checkScrollPane != null) {
                ListBox.this.fireNtfChange = false;
                ListBox.this.removeAllCheckItems();
                for (int k = 0; k < this.model.getSize(); ++k) {
                    ListItem lItem = (ListItem)this.model.getElementAt(k);
                    ListBox.this.addCheckItem(lItem, k);
                }
                ListBox.this.fireNtfChange = true;
                ListBox.this.checkScrollPane.doLayout();
                ListBox.this.checkScrollPane.getViewport().repaint();
            }
            ListBox.this.setThumbPosition(ListBox.this.thumbPosition);
            if (selIdxs.length > 0) {
                ListBox.this.select(selIdxs);
            }
        }

        public int convertRowIndexToModel(int idx) {
            if (ListBox.this.isClosePanelFind()) {
                return idx;
            }
            ListItem item = null;
            item = (ListItem)this.model.elementAt(idx);
            if (item != null) {
                return this.delegate.indexOf(item);
            }
            return -1;
        }
    }

    public static class CoordinateMatchFind {
        ListItem li;
        int row;
        int offset;

        public CoordinateMatchFind(ListItem li, int row, int offset) {
            this.li = li;
            this.row = row;
            this.offset = offset;
        }

        public String toString() {
            return new String(" CMF li [" + this.li + "] row [" + this.row + "] ofs [" + this.offset + "]");
        }
    }

    private static class MyListModel
    extends DefaultListModel {
        private boolean fireAdded = true;

        private MyListModel() {
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            if (this.fireAdded) {
                super.fireIntervalAdded(source, index0, index1);
            }
        }

        void update() {
            int size = this.getSize();
            if (size > 0) {
                super.fireIntervalAdded(this, 0, size - 1);
            }
        }
    }

    private class MyScrollPane
    extends JScrollPane {
        MyScrollPane(Component view) {
            super(view);
        }

        MyScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
            super(view, vsbPolicy, hsbPolicy);
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public void paintComponent(Graphics g) {
                    if (ListBox.this.gradientMgr.isPaintGradient()) {
                        JScrollBar hs;
                        Dimension d = this.getSize();
                        JScrollBar vs = MyScrollPane.this.getVerticalScrollBar();
                        if (vs.isVisible()) {
                            d.width += vs.getSize().width;
                        }
                        if ((hs = MyScrollPane.this.getHorizontalScrollBar()).isVisible()) {
                            d.height += hs.getSize().height;
                        }
                        ListBox.this.gradientMgr.paint((Graphics2D)g, new Rectangle(new Point(0, 0), d));
                    }
                    super.paintComponent(g);
                }
            };
        }
    }

    private static class PagedEventDispatcher
    implements ActionListener {
        private Timer t;
        private Vector pblisteners;
        private PagedListBoxEvent pbe;

        PagedEventDispatcher(Vector listeners, PagedListBoxEvent e) {
            this.pblisteners = listeners;
            this.pbe = e;
            this.fireEvents();
            this.t = new Timer(75, this);
            this.t.setInitialDelay(300);
            this.t.setRepeats(true);
        }

        public void start() {
            this.t.start();
        }

        public void stop() {
            this.t.stop();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.fireEvents();
        }

        private void fireEvents() {
            Enumeration e = this.pblisteners.elements();
            while (e.hasMoreElements()) {
                PagedListBoxListener pbl = (PagedListBoxListener)e.nextElement();
                switch (this.pbe.getID()) {
                    case 2100: {
                        pbl.prevItem(this.pbe);
                        break;
                    }
                    case 2103: {
                        pbl.nextItem(this.pbe);
                        break;
                    }
                    case 2101: {
                        pbl.prevPage(this.pbe);
                        break;
                    }
                    case 2102: {
                        pbl.nextPage(this.pbe);
                        break;
                    }
                    case 2099: {
                        pbl.firstItem(this.pbe);
                        break;
                    }
                    case 2104: {
                        pbl.lastItem(this.pbe);
                    }
                }
            }
        }
    }
}

