/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.FilterableTreeViewModel;
import com.iscobol.gui.client.swing.MassUpdatePanel;
import com.iscobol.gui.client.swing.TreeTableViewModel;
import com.iscobol.gui.client.swing.TreeViewNode;
import com.iscobol.gui.client.swing.TreeViewRootNode;
import com.iscobol.gui.client.swing.treetable.TreeTableModelExt;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class IsTreeViewModel
extends FilterableTreeViewModel
implements TreeTableModelExt,
MassUpdatePanel.Listener {
    private TreeTableViewModel treeTableModel;
    private boolean massUpdate;
    private Vector<TreeViewNode> matchNodes;
    private String lastFilter;
    private boolean[] lastCaseSensitive;

    public IsTreeViewModel(TreeViewNode root) {
        super(root);
    }

    public Vector<TreeViewNode> getMatchNodes() {
        TreeViewRootNode root = (TreeViewRootNode)this.getRoot();
        String fs = root.getFilterString();
        boolean cs = root.isFilterCaseSensitive();
        if (fs != null && fs.length() > 0) {
            if (this.matchNodes == null || this.lastFilter != null && !this.lastFilter.equals(root.getFilterString()) || this.lastCaseSensitive != null && this.lastCaseSensitive[0] != cs) {
                this.matchNodes = new Vector();
                int cc = root.getChildCount(false);
                String fstmp = cs ? fs : fs.toLowerCase();
                for (int i = 0; i < cc; ++i) {
                    this.fillVector((TreeViewNode)root.getChildAt(i, false), fstmp, cs);
                }
                this.lastFilter = fs;
                this.lastCaseSensitive = new boolean[]{cs};
            }
            return this.matchNodes;
        }
        return null;
    }

    private void fillVector(TreeViewNode tvn, String fs, boolean cs) {
        if (tvn.accept(tvn, fs, cs)) {
            this.matchNodes.addElement(tvn);
        }
        int cc = tvn.getChildCount(false);
        for (int i = 0; i < cc; ++i) {
            this.fillVector((TreeViewNode)tvn.getChildAt(i, false), fs, cs);
        }
    }

    @Override
    public void nodeChanged(TreeNode n) {
        if (!this.massUpdate) {
            super.nodeChanged(n);
        }
        this.matchNodes = null;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object o;
        if (this.treeTableModel != null && (o = this.treeTableModel.getChild(parent, index)) != null) {
            return o;
        }
        return super.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        int c;
        if (this.treeTableModel != null && (c = this.treeTableModel.getChildCount(parent)) >= 0) {
            return c;
        }
        return super.getChildCount(parent);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int i;
        if (this.treeTableModel != null && (i = this.treeTableModel.getIndexOfChild(parent, child)) >= 0) {
            return i;
        }
        return super.getIndexOfChild(parent, child);
    }

    @Override
    public void nodesChanged(TreeNode n, int[] idxs) {
        if (!this.massUpdate) {
            int[] newIdxs;
            if (this.treeTableModel != null && (newIdxs = this.treeTableModel.nodesChanged(n, idxs)) != null) {
                idxs = newIdxs;
            }
            super.nodesChanged(n, idxs);
        }
        this.matchNodes = null;
    }

    @Override
    public void nodesWereInserted(TreeNode n, int[] idxs) {
        if (!this.massUpdate) {
            int[] newIdxs;
            if (this.treeTableModel != null && (newIdxs = this.treeTableModel.nodesWereInserted(n, idxs)) != null) {
                idxs = newIdxs;
            }
            super.nodesWereInserted(n, idxs);
        }
        this.matchNodes = null;
    }

    @Override
    public void nodesWereRemoved(TreeNode n, int[] idxs, Object[] childs) {
        if (!this.massUpdate) {
            int[] newIdxs;
            if (this.treeTableModel != null && (newIdxs = this.treeTableModel.nodesWereRemoved(n, idxs, childs)) != null) {
                Object[] newChilds = new Object[childs.length];
                idxs = newIdxs;
                for (int i = 0; i < newChilds.length; ++i) {
                    newChilds[i] = childs[idxs[i]];
                }
                childs = newChilds;
            }
            super.nodesWereRemoved(n, idxs, childs);
        }
        this.matchNodes = null;
    }

    @Override
    public void reload() {
        if (!this.massUpdate) {
            super.reload();
        }
    }

    @Override
    public void reload(TreeNode n) {
        if (!this.massUpdate) {
            super.reload(n);
        }
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel != null ? this.treeTableModel.getColumnCount() : 1;
    }

    @Override
    public String getColumnName(int column) {
        return "";
    }

    @Override
    public Class getColumnClass(int column) {
        return this.treeTableModel != null ? this.treeTableModel.getColumnClass(column) : String.class;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (this.treeTableModel != null) {
            return this.treeTableModel.getValueAt(node, column);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.treeTableModel != null ? this.treeTableModel.isCellEditable(node, column) : false;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }

    @Override
    public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        super.fireTreeStructureChanged(source, path, childIndices, children);
    }

    public TreeTableViewModel getTreeTableModel() {
        return this.treeTableModel;
    }

    public void setTreeTableModel(TreeTableViewModel treeTableModel) {
        this.treeTableModel = treeTableModel;
    }

    @Override
    public void massUpdateChanged(boolean newValue) {
        if (this.massUpdate && !newValue) {
            super.reload((TreeNode)this.getRoot());
        }
        this.massUpdate = newValue;
    }
}

