/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class GradientManager {
    public static final String ORIENTATION = "orientation";
    public static final String COLOR1 = "color1";
    public static final String COLOR2 = "color2";
    public static final String IMAGE = "image";
    public static final String IMAGE_SCALE = "imageScale";
    public static final int GRADIENT_NORTH_TO_SOUTH = 0;
    public static final int GRADIENT_NORTHEAST_TO_SOUTHWEST = 1;
    public static final int GRADIENT_EAST_TO_WEST = 2;
    public static final int GRADIENT_SOUTHEAST_TO_NORTHWEST = 3;
    public static final int GRADIENT_SOUTH_TO_NORTH = 4;
    public static final int GRADIENT_SOUTHWEST_TO_NORTHEAST = 5;
    public static final int GRADIENT_WEST_TO_EAST = 6;
    public static final int GRADIENT_NORTHWEST_TO_SOUTHEAST = 7;
    public static final int GRADIENT_MIN_VALUE = 0;
    public static final int GRADIENT_MAX_VALUE = 7;
    private int orientation = -1;
    private Color color1;
    private ColorCmp color1Cmp;
    private int color1Index = -1;
    private Color color2;
    private ColorCmp color2Cmp;
    private int color2Index = -1;
    private Image image;
    private int imageScale = 1;
    private Dimension scaledImageSize;
    private Image scaledImage;
    private PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcSupport.removePropertyChangeListener(pcl);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        int old = this.orientation;
        this.orientation = orientation;
        this.pcSupport.firePropertyChange(ORIENTATION, old, this.orientation);
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        Color old = this.color1;
        this.color1 = color1;
        this.pcSupport.firePropertyChange(COLOR1, old, this.color1);
    }

    public ColorCmp getColor1Cmp() {
        return this.color1Cmp;
    }

    public void setColor1Cmp(ColorCmp color1Cmp) {
        this.color1Cmp = color1Cmp;
    }

    public int getColor1Index() {
        return this.color1Index;
    }

    public String getColor1AsString() {
        if (this.color1 != null) {
            if (this.color1Index >= 0) {
                return Integer.toString(this.color1Index);
            }
            return Integer.toString(this.color1Cmp.getForeground());
        }
        return null;
    }

    public String getColor2AsString() {
        if (this.color2 != null) {
            if (this.color2Index >= 0) {
                return Integer.toString(this.color2Index);
            }
            return Integer.toString(this.color2Cmp.getForeground());
        }
        return null;
    }

    public void setColor1Index(int color1Index) {
        this.color1Index = color1Index;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        Color old = this.color2;
        this.color2 = color2;
        this.pcSupport.firePropertyChange(COLOR2, old, this.color2);
    }

    public ColorCmp getColor2Cmp() {
        return this.color2Cmp;
    }

    public void setColor2Cmp(ColorCmp color2Cmp) {
        this.color2Cmp = color2Cmp;
    }

    public int getColor2Index() {
        return this.color2Index;
    }

    public void setColor2Index(int color2Index) {
        this.color2Index = color2Index;
    }

    public void setColor1(int value, boolean rgb, GuiFactoryImpl gf) {
        this.setColor(1, value, rgb, gf);
    }

    public void setColor2(int value, boolean rgb, GuiFactoryImpl gf) {
        this.setColor(2, value, rgb, gf);
    }

    private void setColor(int t, int value, boolean rgb, GuiFactoryImpl gf) {
        Color c;
        int idx;
        ColorCmp cmp;
        if (value < 0 || rgb) {
            cmp = new ColorCmp(true);
            idx = -1;
            cmp.setForeRGB(value);
            c = gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
        } else {
            cmp = new ColorCmp(value);
            idx = value;
            c = gf.getRemotePalette().getDefaultColor(cmp.getForeground());
        }
        if (t == 1) {
            this.setColor1Cmp(cmp);
            this.setColor1Index(idx);
            this.setColor1(c);
        } else {
            this.setColor2Cmp(cmp);
            this.setColor2Index(idx);
            this.setColor2(c);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image old = this.image;
        this.image = image;
        this.scaledImage = null;
        this.scaledImageSize = null;
        this.pcSupport.firePropertyChange(IMAGE, old, this.image);
    }

    public int getImageScale() {
        return this.imageScale;
    }

    public void setImageScale(int scale) {
        int old = this.imageScale;
        this.imageScale = scale;
        this.scaledImage = null;
        this.scaledImageSize = null;
        this.pcSupport.firePropertyChange(IMAGE_SCALE, old, this.imageScale);
    }

    public boolean isPaintGradient() {
        return this.getImage() != null || this.getColor1() != null || this.getColor2() != null;
    }

    public void paint(Graphics2D g2d, Rectangle fill) {
        if (this.getImage() != null) {
            this.paintImage(g2d, fill);
        } else {
            this.paintGradient(g2d, fill);
        }
    }

    private void paintImage(Graphics2D g2d, Rectangle fill) {
        if (this.scaledImage == null || !fill.getSize().equals(this.scaledImageSize)) {
            int scaleAlign;
            int scaleType;
            switch (this.imageScale) {
                case 1: {
                    scaleType = 0;
                    scaleAlign = 5;
                    break;
                }
                case 2: {
                    scaleType = 1;
                    scaleAlign = 7;
                    break;
                }
                default: {
                    scaleType = -1;
                    scaleAlign = -1;
                }
            }
            this.scaledImage = scaleType >= 0 ? IsguiUtility.scale(this.image, fill.width, fill.height, scaleType, scaleAlign, false) : this.image;
            this.scaledImageSize = fill.getSize();
        }
        g2d.drawImage(this.scaledImage, fill.x, fill.y, null);
    }

    private void paintGradient(Graphics2D g2d, Rectangle fill) {
        int go = this.orientation;
        Color gc1 = this.color1;
        Color gc2 = this.color2;
        boolean paintGradient = false;
        if (gc1 != null || gc2 != null) {
            paintGradient = true;
            if (go < 0) {
                go = 0;
            }
            if (gc1 == null) {
                gc1 = Color.black;
            }
            if (gc2 == null) {
                gc2 = Color.black;
            }
        }
        if (paintGradient) {
            GradientPaint gp;
            switch (go) {
                case 1: {
                    gp = new GradientPaint(fill.width - 1, 0.0f, gc1, 0.0f, fill.height - 1, gc2);
                    break;
                }
                case 2: {
                    gp = new GradientPaint(fill.width - 1, 0.0f, gc1, 0.0f, 0.0f, gc2);
                    break;
                }
                case 3: {
                    gp = new GradientPaint(fill.width - 1, fill.height - 1, gc1, 0.0f, 0.0f, gc2);
                    break;
                }
                case 4: {
                    gp = new GradientPaint(0.0f, fill.height - 1, gc1, 0.0f, 0.0f, gc2);
                    break;
                }
                case 5: {
                    gp = new GradientPaint(0.0f, fill.height - 1, gc1, fill.width - 1, 0.0f, gc2);
                    break;
                }
                case 6: {
                    gp = new GradientPaint(0.0f, 0.0f, gc1, fill.width - 1, 0.0f, gc2);
                    break;
                }
                case 7: {
                    gp = new GradientPaint(0.0f, 0.0f, gc1, fill.width - 1, fill.height - 1, gc2);
                    break;
                }
                default: {
                    gp = new GradientPaint(0.0f, 0.0f, gc1, 0.0f, fill.height - 1, gc2);
                }
            }
            Paint p = g2d.getPaint();
            g2d.setPaint(gp);
            g2d.fill(fill);
            g2d.setPaint(p);
        }
    }
}

