/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.charva.MyKeyEvent;
import com.iscobol.rts.Config;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RemoteVirtualKeyboard
extends VirtualKeyboard {
    public static final int MOUSE_MOVED = 10001;
    public static final int LEFT_DOWN = 10002;
    public static final int LEFT_UP = 10003;
    public static final int LEFT_DOUBLE = 10004;
    public static final int MIDDLE_DOWN = 10005;
    public static final int MIDDLE_UP = 10006;
    public static final int MIDDLE_DOUBLE = 10007;
    public static final int RIGHT_DOWN = 10008;
    public static final int RIGHT_UP = 10009;
    public static final int RIGHT_DOUBLE = 10010;
    private VirtualKey vkEnter = new VirtualKey("enter", 18874381);
    private VirtualKey vkTab = new VirtualKey("tab", 35848201);
    private VirtualKey vkBcksp = new VirtualKey("backspace", 0x30C0000);
    private VirtualKey vkEnd = new VirtualKey("end", 0x4020000);
    private VirtualKey vkHome = new VirtualKey("home", 0x5010000);
    private VirtualKey vkInsert = new VirtualKey("insert", 0x60D0000);
    private VirtualKey vkDelete = new VirtualKey("delete", 0x70B0000);
    private VirtualKey vkClear = new VirtualKey("clear", 0x80E0000);
    private VirtualKey vkCl2End = new VirtualKey("cl2end", 890175488);
    private VirtualKey vkHelp = new VirtualKey("help", 152043610);
    private VirtualKey vkLeft = new VirtualKey("left", 0xA090000);
    private VirtualKey vkRight = new VirtualKey("right", 0xB0A0000);
    private VirtualKey vkUp = new VirtualKey("up", 202702900);
    private VirtualKey vkDown = new VirtualKey("down", 219545653);
    private VirtualKey vkPageUp = new VirtualKey("pageup", 236388419);
    private VirtualKey vkPageDown = new VirtualKey("pagedown", 253231172);
    private VirtualKey vkF1 = new VirtualKey("f1", 0x10100001);
    private VirtualKey vkF2 = new VirtualKey("f2", 0x11100002);
    private VirtualKey vkF3 = new VirtualKey("f3", 303038467);
    private VirtualKey vkF4 = new VirtualKey("f4", 319815684);
    private VirtualKey vkF5 = new VirtualKey("f5", 336592901);
    private VirtualKey vkF6 = new VirtualKey("f6", 353370118);
    private VirtualKey vkF7 = new VirtualKey("f7", 370147335);
    private VirtualKey vkF8 = new VirtualKey("f8", 386924552);
    private VirtualKey vkF9 = new VirtualKey("f9", 403701769);
    private VirtualKey vkF10 = new VirtualKey("f10", 0x19000000);
    private VirtualKey vkF11 = new VirtualKey("f11", 437256203);
    private VirtualKey vkF12 = new VirtualKey("f12", 454033420);
    private VirtualKey vkF13 = new VirtualKey("f13", 470810637);
    private VirtualKey vkF14 = new VirtualKey("f14", 487587854);
    private VirtualKey vkF15 = new VirtualKey("f15", 504365071);
    private VirtualKey vkF16 = new VirtualKey("f16", 0x1F100010);
    private VirtualKey vkF17 = new VirtualKey("f17", 0x20100011);
    private VirtualKey vkF18 = new VirtualKey("f18", 0x21100012);
    private VirtualKey vkF19 = new VirtualKey("f19", 571473939);
    private VirtualKey vkF20 = new VirtualKey("f20", 588251156);
    private VirtualKey vkEscape = new VirtualKey("escape", 605028379);
    private VirtualKey vkPause = new VirtualKey("pause", 621871103);
    private VirtualKey vkDivide = new VirtualKey("divide", 0x26000000);
    private VirtualKey vkMultiply = new VirtualKey("multiply", 0x27000000);
    private VirtualKey vkSubtract = new VirtualKey("subtract", 0x28000000);
    private VirtualKey vkAdd = new VirtualKey("add", 0x29000000);
    private VirtualKey vkDecimal = new VirtualKey("decimal", 0x2A000000);
    private VirtualKey vkNumpad0 = new VirtualKey("numpad0", 0x2B000000);
    private VirtualKey vkNumpad1 = new VirtualKey("numpad1", 0x2C000000);
    private VirtualKey vkNumpad2 = new VirtualKey("numpad2", 0x2D000000);
    private VirtualKey vkNumpad3 = new VirtualKey("numpad3", 0x2E000000);
    private VirtualKey vkNumpad4 = new VirtualKey("numpad4", 0x2F000000);
    private VirtualKey vkNumpad5 = new VirtualKey("numpad5", 0x30000000);
    private VirtualKey vkNumpad6 = new VirtualKey("numpad6", 0x31000000);
    private VirtualKey vkNumpad7 = new VirtualKey("numpad7", 0x32000000);
    private VirtualKey vkNumpad8 = new VirtualKey("numpad8", 0x33000000);
    private VirtualKey vkNumpad9 = new VirtualKey("numpad9", 0x34000000);
    private VirtualKey mMoved = new VirtualKey("mmov", 1058013264);
    private VirtualKey mLeftDown = new VirtualKey("mldw", 907018321);
    private VirtualKey mLeftUp = new VirtualKey("mlup", 923795538);
    private VirtualKey mLeftDouble = new VirtualKey("mldc", 940572755);
    private VirtualKey mMiddleDown = new VirtualKey("mmdw", 957349972);
    private VirtualKey mMiddleUp = new VirtualKey("mmup", 974127189);
    private VirtualKey mMiddleDouble = new VirtualKey("mmdc", 990904406);
    private VirtualKey mRightDown = new VirtualKey("mrdw", 1007681623);
    private VirtualKey mRightUp = new VirtualKey("mrup", 1024458840);
    private VirtualKey mRightDouble = new VirtualKey("mrdc", 1041236057);
    private VirtualKey[] mKeyArray = new VirtualKey[]{this.vkEnter, this.vkTab, this.vkBcksp, this.vkEnd, this.vkHome, this.vkInsert, this.vkDelete, this.vkClear, this.vkCl2End, this.vkHelp, this.vkLeft, this.vkRight, this.vkUp, this.vkDown, this.vkPageUp, this.vkPageDown, this.vkF1, this.vkF2, this.vkF3, this.vkF4, this.vkF5, this.vkF6, this.vkF7, this.vkF8, this.vkF9, this.vkF10, this.vkF11, this.vkF12, this.vkF13, this.vkF14, this.vkF15, this.vkF16, this.vkF17, this.vkF18, this.vkF19, this.vkF20, this.vkEscape, this.vkPause, this.vkDivide, this.vkMultiply, this.vkSubtract, this.vkAdd, this.vkDecimal, this.vkNumpad0, this.vkNumpad1, this.vkNumpad2, this.vkNumpad3, this.vkNumpad4, this.vkNumpad5, this.vkNumpad6, this.vkNumpad7, this.vkNumpad8, this.vkNumpad9, this.mMoved, this.mLeftDown, this.mLeftUp, this.mLeftDouble, this.mMiddleDown, this.mMiddleUp, this.mMiddleDouble, this.mRightDown, this.mRightUp, this.mRightDouble};
    private VirtualKey vkShTab = new VirtualKeyShift(this.vkTab, 262144);
    private Hashtable mKeyHash = new Hashtable(this.mKeyArray.length);
    private Hashtable hotKeys;
    private VirtualKey[] letters;
    private VirtualKey[] digits;
    private int autoterminatedvalue;

    public RemoteVirtualKeyboard() {
        int i;
        for (i = this.mKeyArray.length - 1; i >= 0; --i) {
            this.mKeyHash.put(this.mKeyArray[i].description, this.mKeyArray[i]);
        }
        this.modifyKey("decimal", "data=" + LOCALE_DECIMAL_SEPARATOR);
        this.hotKeys = new Hashtable();
        this.letters = new VirtualKey[26];
        for (i = 0; i < 26; ++i) {
            this.letters[i] = new VirtualKey((char)(65 + i));
        }
        this.digits = new VirtualKey[10];
        for (i = 0; i < 10; ++i) {
            this.digits[i] = new VirtualKey((char)(48 + i));
        }
    }

    private VirtualKey findKey(int keyCode) {
        return this.findKey(null, keyCode);
    }

    private VirtualKey findKey(MyKeyEvent ke, int keyCode) {
        switch (keyCode) {
            case 343: {
                return this.vkEnter;
            }
            case 9: {
                return this.vkTab;
            }
            case 353: {
                return this.vkShTab;
            }
            case 263: {
                return this.vkBcksp;
            }
            case 360: {
                return this.vkEnd;
            }
            case 262: {
                return this.vkHome;
            }
            case 331: {
                return this.vkInsert;
            }
            case 330: {
                return this.vkDelete;
            }
            case 260: {
                return this.vkLeft;
            }
            case 261: {
                return this.vkRight;
            }
            case 259: {
                return this.vkUp;
            }
            case 258: {
                return this.vkDown;
            }
            case 339: {
                return this.vkPageUp;
            }
            case 338: {
                return this.vkPageDown;
            }
            case 265: {
                return this.vkF1;
            }
            case 266: {
                return this.vkF2;
            }
            case 267: {
                return this.vkF3;
            }
            case 268: {
                return this.vkF4;
            }
            case 269: {
                return this.vkF5;
            }
            case 270: {
                return this.vkF6;
            }
            case 271: {
                return this.vkF7;
            }
            case 272: {
                return this.vkF8;
            }
            case 273: {
                return this.vkF9;
            }
            case 274: {
                return this.vkF10;
            }
            case 275: {
                return this.vkF11;
            }
            case 276: {
                return this.vkF12;
            }
            case 277: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF1;
            }
            case 278: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF2;
            }
            case 279: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF3;
            }
            case 280: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF4;
            }
            case 281: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF5;
            }
            case 282: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF6;
            }
            case 283: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF7;
            }
            case 284: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF8;
            }
            case 285: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF9;
            }
            case 286: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF10;
            }
            case 287: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF11;
            }
            case 288: {
                if (ke != null) {
                    ke.setShiftDown(true);
                }
                return this.vkF12;
            }
            case 289: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF1;
            }
            case 290: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF2;
            }
            case 291: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF3;
            }
            case 292: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF4;
            }
            case 293: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF5;
            }
            case 294: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF6;
            }
            case 295: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF7;
            }
            case 296: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF8;
            }
            case 297: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF9;
            }
            case 298: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF10;
            }
            case 299: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF11;
            }
            case 300: {
                if (ke != null) {
                    ke.setControlDown(true);
                }
                return this.vkF12;
            }
            case 301: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF1;
            }
            case 302: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF2;
            }
            case 303: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF3;
            }
            case 304: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF4;
            }
            case 305: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF5;
            }
            case 306: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF6;
            }
            case 307: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF7;
            }
            case 308: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF8;
            }
            case 309: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF9;
            }
            case 310: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF10;
            }
            case 311: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF11;
            }
            case 312: {
                if (ke != null) {
                    ke.setShiftDown(true);
                    ke.setControlDown(true);
                }
                return this.vkF12;
            }
            case 27: {
                return this.vkEscape;
            }
            case 10001: {
                return this.mMoved;
            }
            case 10002: {
                return this.mLeftDown;
            }
            case 10003: {
                return this.mLeftUp;
            }
            case 10004: {
                return this.mLeftDouble;
            }
            case 10005: {
                return this.mMiddleDown;
            }
            case 10006: {
                return this.mMiddleUp;
            }
            case 10007: {
                return this.mMiddleDouble;
            }
            case 10008: {
                return this.mRightDown;
            }
            case 10009: {
                return this.mRightUp;
            }
            case 10010: {
                return this.mRightDouble;
            }
        }
        return null;
    }

    public boolean modifyKey(String name, String values) {
        boolean Return2 = false;
        if (name.equals("kbd_auto_return")) {
            int kdbar = 0;
            try {
                kdbar = Integer.parseInt(values);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAutoTerminatedValue(kdbar);
            return true;
        }
        boolean ctrl = false;
        boolean shift = false;
        boolean alt = false;
        char c = name.charAt(0);
        if (c == '^' || c == '*' || c == '@') {
            if (c == '^') {
                shift = true;
            } else if (c == '*') {
                ctrl = true;
            } else {
                alt = true;
            }
            c = name.charAt(1);
            if (c == '^' || c == '*' || c == '@') {
                if (c == '^') {
                    shift = true;
                } else if (c == '*') {
                    ctrl = true;
                } else {
                    alt = true;
                }
                c = name.charAt(2);
                if (c == '^' || c == '*' || c == '@') {
                    if (c == '^') {
                        shift = true;
                    } else if (c == '*') {
                        ctrl = true;
                    } else {
                        alt = true;
                    }
                    name = name.substring(3);
                } else {
                    name = name.substring(2);
                }
            } else {
                name = name.substring(1);
            }
        }
        VirtualKey k = name.length() == 1 && ctrl ? ((c = Character.toUpperCase(name.charAt(0))) >= 'A' && c <= 'Z' ? this.letters[c - 65] : (c >= '0' && c <= '9' ? this.digits[c - 48] : (VirtualKey)this.mKeyHash.get(name))) : (VirtualKey)this.mKeyHash.get(name);
        if (k != null) {
            if (ctrl || shift || alt) {
                if (ctrl && shift && alt) {
                    if (k.altShiftCtrl == null) {
                        k.altShiftCtrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.altShiftCtrl;
                } else if (ctrl && shift) {
                    if (k.shiftCtrl == null) {
                        k.shiftCtrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.shiftCtrl;
                } else if (ctrl && alt) {
                    if (k.altCtrl == null) {
                        k.altCtrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.altCtrl;
                } else if (shift && alt) {
                    if (k.altShift == null) {
                        k.altShift = new VirtualKey(k.description, k.type);
                    }
                    k = k.altShift;
                } else if (ctrl) {
                    if (k.ctrl == null) {
                        k.ctrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.ctrl;
                } else if (alt) {
                    if (k.alt == null) {
                        k.alt = new VirtualKey(k.description, k.type);
                    }
                    k = k.alt;
                } else if (shift) {
                    if (k.shift == null) {
                        k.shift = new VirtualKey(k.description, k.type);
                    }
                    k = k.shift;
                }
            }
            VirtualKey virtualKey = k;
            virtualKey.type = virtualKey.type & 0xFF00FFFF;
            StringTokenizer stOc = new StringTokenizer(values);
            values = values.toLowerCase();
            StringTokenizer stLc = new StringTokenizer(values);
            while (stOc.hasMoreTokens()) {
                VirtualKey virtualKey2;
                String subLc;
                String sOc = stOc.nextToken();
                String sLc = stLc.nextToken();
                if (sLc.startsWith("edit=")) {
                    if (sLc.length() > 5) {
                        subLc = sLc.substring(5);
                        if (subLc.equals("first")) {
                            k.type = k.type & 0xFFF0FFFF | 0x10000;
                            continue;
                        }
                        if (subLc.equals("last")) {
                            k.type = k.type & 0xFFF0FFFF | 0x20000;
                            continue;
                        }
                        if (subLc.equals("next")) {
                            k.type = k.type & 0xFFF0FFFF | 0x30000;
                            continue;
                        }
                        if (subLc.equals("previous")) {
                            k.type = k.type & 0xFFF0FFFF | 0x40000;
                            continue;
                        }
                        if (subLc.equals("up")) {
                            k.type = k.type & 0xFFF0FFFF | 0x50000;
                            continue;
                        }
                        if (subLc.equals("down")) {
                            k.type = k.type & 0xFFF0FFFF | 0x60000;
                            continue;
                        }
                        if (subLc.equals("pageup")) {
                            k.type = k.type & 0xFFF0FFFF | 0x70000;
                            continue;
                        }
                        if (subLc.equals("pagedown")) {
                            k.type = k.type & 0xFFF0FFFF | 0x80000;
                            continue;
                        }
                        if (subLc.equals("left")) {
                            k.type = k.type & 0xFFF0FFFF | 0x90000;
                            continue;
                        }
                        if (subLc.equals("right")) {
                            k.type = k.type & 0xFFF0FFFF | 0xA0000;
                            continue;
                        }
                        if (subLc.equals("backspace")) {
                            k.type = k.type & 0xFFF0FFFF | 0xC0000;
                            continue;
                        }
                        if (subLc.equals("insert")) {
                            k.type = k.type & 0xFFF0FFFF | 0xD0000;
                            continue;
                        }
                        if (subLc.equals("delete")) {
                            k.type = k.type & 0xFFF0FFFF | 0xB0000;
                            continue;
                        }
                        if (subLc.equals("clear")) {
                            k.type = k.type & 0xFFF0FFFF | 0xE0000;
                            continue;
                        }
                        if (!subLc.equals("cl2end")) continue;
                        k.type = k.type & 0xFFF0FFFF | 0xF0000;
                        continue;
                    }
                    k.type = k.type & 0xFFF0FFFF;
                    continue;
                }
                if (sLc.startsWith("termination=")) {
                    if (sLc.length() <= 12) continue;
                    subLc = sLc.substring(12);
                    try {
                        int t = Integer.parseInt(subLc);
                        if (t < 0) continue;
                        virtualKey2 = k;
                        virtualKey2.type = virtualKey2.type | 0x200000;
                        k.type = k.type & 0xFFFF0000 | t;
                    }
                    catch (NumberFormatException t) {}
                    continue;
                }
                if (sLc.startsWith("exception=")) {
                    if (sLc.length() <= 10) continue;
                    subLc = sLc.substring(10);
                    try {
                        int t = Integer.parseInt(subLc);
                        if (t < 0) continue;
                        virtualKey2 = k;
                        virtualKey2.type = virtualKey2.type | 0x100000;
                        k.type = k.type & 0xFFFF0000 | t;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (sLc.startsWith("data=")) {
                    if (sOc.length() <= 5) continue;
                    k.value = sOc.charAt(5);
                    continue;
                }
                if (sLc.startsWith("invalid=")) {
                    if (sLc.length() <= 8) continue;
                    subLc = sLc.substring(8);
                    k.invalid = Config.isTrue(subLc);
                    continue;
                }
                if (!sLc.startsWith("hotkey=")) continue;
                if (sLc.length() > 7) {
                    k.type = k.type & 0xFF00FFFF | 0x400000;
                    this.hotKeys.put(this.getKey(k.type, shift, ctrl, alt), sOc.substring(7));
                    continue;
                }
                k.type = k.type & 0xFF0FFFFF;
                this.hotKeys.remove(this.getKey(k.type, shift, ctrl, alt));
            }
            Return2 = true;
        }
        return Return2;
    }

    private String getKey(int type, boolean shift, boolean ctrl, boolean alt) {
        StringBuffer key = new StringBuffer();
        if (shift) {
            key.append('^');
        }
        if (ctrl) {
            key.append('*');
        }
        if (alt) {
            key.append('@');
        }
        key.append(type);
        return key.toString();
    }

    private boolean modifyKey(int keyCode, int type, char value) {
        VirtualKey vk = this.findKey(keyCode);
        if (vk != null) {
            if (type != 0) {
                vk.type = type;
            }
            if (value != '\u0000') {
                vk.value = value;
            }
            return true;
        }
        return false;
    }

    private int mapKey(VirtualKey vk, MyKeyEvent ie) {
        if (vk.invalid) {
            return 0x300000;
        }
        if (vk.value != 0 && ie instanceof MyKeyEvent) {
            MyKeyEvent ke = ie;
            ke.setKeyChar((char)vk.value);
            ke.setKeyCode(vk.value);
        }
        return vk.type;
    }

    public int mapMouseEvent(MouseEvent me, int code) {
        return -1;
    }

    public int mapKey(MyKeyEvent ke) {
        int Return2 = this.mapKey(ke, ke.getKeyCode());
        block0 : switch (Return2 & 0xF00000) {
            case 0x100000: 
            case 0x400000: {
                switch (Return2 & 0xFF000000) {
                    case 0x10000000: 
                    case 0x11000000: 
                    case 0x12000000: 
                    case 0x13000000: 
                    case 0x14000000: 
                    case 0x15000000: 
                    case 0x16000000: 
                    case 0x17000000: 
                    case 0x18000000: 
                    case 0x19000000: 
                    case 0x1A000000: 
                    case 0x1B000000: 
                    case 0x1C000000: 
                    case 0x1D000000: 
                    case 0x1E000000: 
                    case 0x1F000000: 
                    case 0x20000000: 
                    case 0x21000000: 
                    case 0x22000000: 
                    case 0x23000000: {
                        break block0;
                    }
                }
                break;
            }
        }
        return Return2;
    }

    private boolean isControlDown(int keyCode) {
        return keyCode < 38;
    }

    public int mapKey(MyKeyEvent ke, int keyCode) {
        int code;
        VirtualKey vk = this.findKey(ke, keyCode);
        int Return2 = vk != null ? (ke.isShiftDown() || keyCode == 353 ? (this.isControlDown(keyCode) || ke.isControlDown() ? (ke.isAltDown() ? (vk.altShiftCtrl != null ? this.mapKey(vk.altShiftCtrl, ke) : this.mapKey(vk, ke)) : (vk.shiftCtrl != null ? this.mapKey(vk.shiftCtrl, ke) : this.mapKey(vk, ke))) : (ke.isAltDown() ? (vk.altShift != null ? this.mapKey(vk.altShift, ke) : this.mapKey(vk, ke)) : (vk.shift != null ? this.mapKey(vk.shift, ke) : this.mapKey(vk, ke)))) : (this.isControlDown(keyCode) || ke.isControlDown() ? (ke.isAltDown() ? (vk.altCtrl != null ? this.mapKey(vk.altCtrl, ke) : this.mapKey(vk, ke)) : (vk.ctrl != null ? this.mapKey(vk.ctrl, ke) : this.mapKey(vk, ke))) : (ke.isAltDown() ? (vk.alt != null ? this.mapKey(vk.alt, ke) : this.mapKey(vk, ke)) : this.mapKey(vk, ke)))) : ((this.isControlDown(keyCode) || ke.isControlDown()) && !ke.isAltDown() ? (ke instanceof MyKeyEvent ? ((code = ke.getKeyCode()) >= 1 && code <= 26 ? ((vk = this.letters[code - 1]).ctrl == null ? 0x100000 | code : this.mapKey(vk.ctrl, ke)) : (code >= 48 && code <= 57 ? ((vk = this.digits[code - 48]).ctrl == null ? 0 : this.mapKey(vk.ctrl, ke)) : 0)) : 0) : 0);
        return Return2;
    }

    public String toString(int type) {
        StringBuffer Return2 = new StringBuffer();
        switch (type & 0xF00000) {
            case 0: {
                Return2.append("data");
                break;
            }
            case 0x100000: {
                Return2.append("exception=" + (type & 0xFFFF));
                break;
            }
            case 0x200000: {
                Return2.append("termination=" + (type & 0xFFFF));
                break;
            }
            case 0x300000: {
                Return2.append("invalid");
                break;
            }
            default: {
                Return2.append("" + (type & 0xF00000) + "," + (type & 0xFFFF));
            }
        }
        Return2.append(", edit=");
        switch (type & 0xF0000) {
            case 0: {
                Return2.append("null");
                break;
            }
            case 65536: {
                Return2.append("first");
                break;
            }
            case 131072: {
                Return2.append("last");
                break;
            }
            case 196608: {
                Return2.append("next");
                break;
            }
            case 262144: {
                Return2.append("prev");
                break;
            }
            case 983040: {
                Return2.append("" + (type & 0xF0000));
            }
        }
        return Return2.toString();
    }

    public String getHotKey(int code, boolean shift, boolean ctrl, boolean alt) {
        return (String)this.hotKeys.get(this.getKey(code, shift, ctrl, alt));
    }

    public int getAutoTerminated() {
        return 0x230000 | this.autoterminatedvalue;
    }

    public void setAutoTerminatedValue(int i) {
        this.autoterminatedvalue = i;
    }

    private class VirtualKeyShift
    extends VirtualKey {
        VirtualKeyShift(VirtualKey sh, int t) {
            super(sh.description, t);
            sh.shift = (VirtualKey)this;
        }
    }

    public class VirtualKey {
        private String description;
        private int value;
        private int type;
        private boolean invalid;
        private VirtualKey shift;
        private VirtualKey ctrl;
        private VirtualKey shiftCtrl;
        private VirtualKey alt;
        private VirtualKey altShift;
        private VirtualKey altCtrl;
        private VirtualKey altShiftCtrl;

        private VirtualKey(String d, int t) {
            this.description = d;
            this.type = t;
        }

        private VirtualKey(char c) {
            this.description = "" + c;
            this.type = 0 | (c << 24 | Integer.MIN_VALUE) & 0xFF000000;
            this.value = c;
        }
    }
}

