/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.charva.GuiFactoryImpl;
import com.iscobol.gui.client.charva.PicobolWidget;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import java.awt.Rectangle;

public class RemoteTerminalDisplay
extends RemoteBaseGUIControl {
    protected boolean isNumeric;
    protected boolean isUnderline;
    protected boolean isBlink;
    protected boolean isBold;
    private boolean isAll;
    protected boolean isReverse;
    protected Justification just = Justification.None;
    private String value;

    public RemoteTerminalDisplay(GuiFactoryImpl gf) {
        super(gf);
        this.temporary = true;
    }

    @Override
    public void initialize() {
        if (this.getComponent() == null) {
            this.setComponent(new MyComponent());
        }
        this.intInitialize();
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public void displayProp() {
    }

    @Override
    public int getGUIControlHeight(float height) {
        return 1;
    }

    @Override
    public int getGUIControlWidth(float width) {
        return (int)width;
    }

    @Override
    public float getDefaultWidth() {
        return 1.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 1.0f;
    }

    @Override
    public String getTitle() {
        return this.getValue();
    }

    private static String fillAll(String v, int mlen) {
        StringBuffer Return2 = new StringBuffer();
        if (v != null) {
            do {
                Return2.append(v);
            } while (Return2.length() < mlen);
        }
        Return2.setLength(mlen);
        return Return2.toString();
    }

    @Override
    public String getValue() {
        if (this.isAll) {
            this.value = RemoteTerminalDisplay.fillAll(this.value, this.getLength());
            this.isAll = false;
        }
        return this.value;
    }

    @Override
    public void setTitle(String t) {
        this.setValue(t);
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public String setValue(String v) {
        this.value = v;
        return null;
    }

    @Override
    public void setRowsCols(float rows, float cols) {
    }

    @Override
    public void setRows(float rows) {
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
            String val = this.getNoecho() ? "" : this.getValue();
            int attr = this.isUnderline ? 0x2000000 : 0;
            attr |= this.isBold ? 0x1000000 : 0;
            attr |= this.isBlink ? 0x8000000 : 0;
            if (this.isReverse) {
                attr |= this.isReverse ? 0x4000000 : 0;
            }
            if (this.beep) {
                Toolkit.getDefaultToolkit().beep();
            }
            Rectangle repArea = rdw.mainWindow.display(this.getColumn(), this.getLine(), val, this.getLength(), this.getColorForeground(), attr, this.getColorBackground(), this.just);
            rdw.setDoRepaint(repArea);
        }
    }

    @Override
    public void setStyle(int s, boolean set) {
        if ((s & 0x100) == 256) {
            this.setIsNumeric(set);
        }
        if ((s & 0x1000) == 4096) {
            this.setUnderline(set);
        }
        if ((s & 8) == 8) {
            this.setBlink(set);
        }
        if ((s & 0x80000) == 524288) {
            this.setAll(set);
        }
        if ((s & 0x80) == 128) {
            this.setNoecho(set);
        }
        if ((s & 0x8000) == 32768) {
            this.setBold(set);
        }
        if ((s & 0x400) == 1024) {
            this.setJust(1024);
        }
        if ((s & 0x20) == 32) {
            this.setJust(32);
        }
        if ((s & 0x10) == 16) {
            this.setJust(16);
        }
        if ((s & 2) == 2) {
            this.setBeep(set);
        }
        if ((s & 0x400000) == 0x400000) {
            this.setReverse(set);
        }
    }

    public void setIsNumeric(boolean b) {
        this.isNumeric = b;
    }

    @Override
    public void setNoecho(boolean b) {
        super.setNoecho(b);
    }

    public void setUnderline(boolean b) {
        this.isUnderline = b;
    }

    public void setBold(boolean b) {
        this.isBold = b;
    }

    public void setBlink(boolean b) {
        this.isBlink = b;
    }

    @Override
    public void setReverse(boolean b) {
        this.isReverse = b;
    }

    public void setAll(boolean b) {
        this.isAll = b;
    }

    public void setJust(int j) {
        switch (j) {
            case 1024: {
                this.just = Justification.Right;
                break;
            }
            case 16: {
                this.just = Justification.Center;
                break;
            }
            case 32: {
                this.just = Justification.Left;
                break;
            }
            default: {
                this.just = Justification.None;
            }
        }
    }

    @Override
    public void focusGained(CobolFocusEvent cfe) {
        super.focusGained(cfe);
    }

    @Override
    public void focusLost(CobolFocusEvent cfe) {
        super.focusLost(cfe);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize ps, int origHeight) {
        return super.paramgetDefaultHeight(ps, origHeight);
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f || !ps.sizesInCells) {
            return ps.sizes;
        }
        if (ps.title != null) {
            return ps.title.length();
        }
        if (ps.ccPIClen != -1) {
            return ps.ccPIClen;
        }
        if (ps.ccOlen != -1) {
            return ps.ccOlen;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public java.awt.Dimension loadDimension0() {
        return null;
    }

    @Override
    protected void clear() {
        super.clear();
        this.isNumeric = false;
        this.isUnderline = false;
        this.isBlink = false;
        this.isBold = false;
        this.isReverse = false;
        this.isAll = false;
        this.just = Justification.None;
        this.value = null;
    }

    @Override
    protected int getLayoutData(IscobolLayout l) {
        return 0;
    }

    @Override
    public String getType() {
        return "terminaldisplay";
    }

    static class MyComponent
    extends Component
    implements PicobolWidget {
        MyComponent() {
        }

        @Override
        public void setActiveAccept(boolean b) {
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public boolean getActiveAccept() {
            return false;
        }

        @Override
        public void setSelfAct(boolean b) {
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        public void setSize(int w, int h) {
        }

        @Override
        public void setLocation(int x, int y) {
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
        }

        public void debug(int i) {
        }

        public Dimension minimumSize() {
            return new Dimension(0, 0);
        }

        public Dimension getSize() {
            return new Dimension(0, 0);
        }

        public int getHeight() {
            return 0;
        }

        public int getWidth() {
            return 0;
        }

        public void draw() {
        }

        @Override
        public void setSize(Dimension d) {
        }

        @Override
        public void setLocation(Point d) {
        }

        @Override
        public void setForeground(Color d) {
        }

        @Override
        public void setBackground(Color d) {
        }
    }
}

