/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.AppFactory;
import com.iscobol.gui.client.Client;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import java.io.IOException;
import java.util.prefs.Preferences;

public class MultitaskingClientHandler
extends AbstractServerRpcHandler {
    private String debugPort;
    private final MyServer server;

    public MultitaskingClientHandler(DualRpcServerDispatcher disp) {
        super(disp);
        this.server = (MyServer)disp.getDualRpcServer();
        this.getDispatcher().setCallbackHandler(this.server.cbh);
        RemoteRegistry.setClientCaller(new ClientCaller(this.getDispatcher()));
        Logger problemLog = LoggerFactory.get(64);
        Logger rpcCallLog = LoggerFactory.get(128);
        RemoteRegistry.setClientProblemLogger(problemLog);
        RemoteRegistry.setClientRpcCallLogger(rpcCallLog);
    }

    public AppFactory getAppFactory() throws IOException {
        return this.server.af;
    }

    public void setDebugArgs(String port) throws IOException {
        this.debugPort = port;
        if (this.server.debugHost != null) {
            if (this.server.startGraphDebugger) {
                new Thread(() -> {
                    try {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Client.startGraphDebugger(this.server.debugHost, this.debugPort, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                Preferences prefs = Preferences.userNodeForPackage(this.getClass()).node("debug");
                prefs.put("port", this.debugPort);
            }
        }
    }

    static class MyServer
    extends DualRpcServer {
        final String debugHost;
        final AppFactory af;
        final IServerCallbackHandler cbh;
        final boolean startGraphDebugger;

        MyServer(String host, int port, boolean reuseAddress, Object configurationObject, String debugHost, AppFactory af, IServerCallbackHandler cbh, boolean sgd) {
            super(host, port, reuseAddress, configurationObject);
            this.debugHost = debugHost;
            this.af = af;
            this.cbh = cbh;
            this.startGraphDebugger = sgd;
        }
    }
}

