/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.ClientCall;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Client;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.Memory;
import com.iscobol.rts.RuntimeEnvironmentType;
import com.iscobol.rts.RuntimeInfo;
import com.iscobol.rts_n.Factory;
import com.iscobol.types.CobolVar;
import com.iscobol.types_n.PicX;
import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class ClientCallImpl
extends UnicastRemoteObject
implements ClientCall {
    private static final long serialVersionUID = 22222222999999999L;
    static Thread mainThread;
    private AbstractGuiFactoryImpl clientContext;

    public ClientCallImpl() {
        this.setCallTimeout(0);
    }

    public ClientCallImpl(AbstractGuiFactoryImpl agf) throws IOException {
        this();
        this.clientContext = agf;
    }

    @Override
    public Object[] call(String name, Object[] arg, boolean isNew, boolean isCp) throws IOException {
        Message run = new Message(() -> {
            try {
                return isCp ? this.myCallCp(name, arg, isNew) : this.myCall(name, arg, isNew);
            }
            catch (IscobolRuntimeException ex) {
                return new Object[]{ex};
            }
            catch (Exception ex) {
                return new Object[]{new IscobolRuntimeException(ex)};
            }
        });
        this.clientContext.getCCMessageLoop().putMessage(run);
        run.waitFor();
        return (Object[])run.result;
    }

    private Object[] myCall(String name, Object[] arg, boolean isNew) {
        int argLen = arg == null ? 0 : arg.length;
        Object[] Return2 = new Object[argLen + 1];
        for (int i = 0; i < argLen; ++i) {
            if (arg[i] instanceof CobolVar && ((CobolVar)arg[i]).isByVal()) continue;
            Return2[i] = arg[i];
        }
        try {
            Return2[i] = com.iscobol.rts.Factory.call(name, null, arg, isNew);
        }
        catch (IscobolRuntimeException _ex) {
            Return2[argLen] = _ex;
        }
        return Return2;
    }

    private Object[] myCallCp(String name, Object[] arg, boolean isNew) {
        int i;
        int argLen = arg == null ? 0 : arg.length;
        Object[] rArgs = new Object[argLen];
        Object[] Return2 = new Object[argLen + 1];
        for (i = 0; i < argLen; ++i) {
            if (arg[i] instanceof CobolVar) {
                byte[] bval = ((CobolVar)arg[i]).getBytes();
                int blen = bval.length;
                Memory mem = Factory.getNotOptmzdMem(blen);
                rArgs[i] = new PicX(mem, 0, blen, null, null, null, false, false);
                ((PicX)rArgs[i]).set(bval, 0, blen, false);
                continue;
            }
            rArgs[i] = arg[i];
        }
        try {
            Return2[argLen] = Factory.call(name, null, rArgs, isNew);
            if (Return2[argLen] instanceof com.iscobol.types_n.CobolVar) {
                Return2[argLen] = com.iscobol.rts.Factory.getNumLiteral(((com.iscobol.types_n.CobolVar)Return2[argLen]).toint(), 18, 0, false);
            }
            for (i = 0; i < argLen; ++i) {
                if (!(rArgs[i] instanceof com.iscobol.types_n.CobolVar) || ((CobolVar)arg[i]).isByVal()) continue;
                com.iscobol.types_n.CobolVar cv = (com.iscobol.types_n.CobolVar)rArgs[i];
                CobolVar cn = (CobolVar)arg[i];
                int len = Math.min(cv.length(), cn.length());
                cn.set(cv.getBytes(), 0, len, true);
                Return2[i] = cn;
            }
        }
        catch (IscobolRuntimeException _ex) {
            Return2[argLen] = _ex;
        }
        return Return2;
    }

    @Override
    public void cancel(String name, boolean isCp) throws IOException {
        Message run = new Message(() -> {
            if (isCp) {
                Factory.cancel(name);
            } else {
                com.iscobol.rts.Factory.cancel(name);
            }
            return null;
        });
        this.clientContext.getCCMessageLoop().putMessage(run);
        run.waitFor();
    }

    @Override
    public void cancelAll(boolean isCp) throws IOException {
        Message run = new Message(() -> {
            if (isCp) {
                Factory.cancelAll();
            } else {
                com.iscobol.rts.Factory.cancelAll();
            }
            return null;
        });
        this.clientContext.getCCMessageLoop().putMessage(run);
        run.waitFor();
    }

    public static class MessageLoop
    extends Thread {
        LinkedList messageQueue = new LinkedList();

        MessageLoop() {
            this.setName(this.getClass().getName());
            this.setDaemon(true);
            if (mainThread != null) {
                IscobolSystem.duplicateEnv(mainThread, this);
                Config c = (Config)IscobolSystem.getIfExists(Config.class, mainThread);
                if (c != null) {
                    c.reloadSystemProperties();
                }
                mainThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeInfo.set(Client.isWebClient() ? RuntimeEnvironmentType.WEB_THIN_CLIENT_REMOTE : RuntimeEnvironmentType.THIN_CLIENT_REMOTE);
            while (true) {
                Runnable run = null;
                LinkedList linkedList = this.messageQueue;
                synchronized (linkedList) {
                    if (this.messageQueue.isEmpty()) {
                        try {
                            this.messageQueue.wait();
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                    try {
                        run = (Runnable)this.messageQueue.removeFirst();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                if (run == null) continue;
                run.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putMessage(Runnable run) {
            LinkedList linkedList = this.messageQueue;
            synchronized (linkedList) {
                this.messageQueue.addLast(run);
                this.messageQueue.notify();
            }
        }
    }

    public static class Message
    implements Runnable {
        private boolean done = false;
        private final Supplier c;
        private Object result;

        public Message(Supplier c) {
            this.c = c;
        }

        @Override
        public void run() {
            this.result = this.c.get();
            this.done();
        }

        public synchronized Object getResult() {
            this.waitFor();
            return this.result;
        }

        public synchronized void done() {
            this.done = true;
            this.notify();
        }

        public synchronized void waitFor() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

