/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.BarcodeCreator;
import com.iscobol.gui.ClientCall;
import com.iscobol.gui.Events;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.RemoteFile;
import com.iscobol.gui.RemoteIO;
import com.iscobol.gui.RemoteImage;
import com.iscobol.gui.RemoteProgressDialog;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.ClientCallImpl;
import com.iscobol.gui.client.CsProperty;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.Messages;
import com.iscobol.gui.client.RemoteImageImpl;
import com.iscobol.gui.client.RemotePalette;
import com.iscobol.gui.client.RemoteVirtualKeyboard;
import com.iscobol.gui.client.io.ClientCallRemoteIO;
import com.iscobol.gui.client.io.RemoteFileImpl;
import com.iscobol.io.InddHandler;
import com.iscobol.io.OutddHandler;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.File;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.print.MyPrintService;
import com.iscobol.rts.print.RemoteSpoolPrinter;
import com.iscobol.rts.print.RemoteSpoolPrinterImpl;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.ServiceUI;
import javax.print.attribute.PrintRequestAttributeSet;

public abstract class AbstractGuiFactoryImpl
extends UnicastRemoteObject
implements Remote,
GuiFactory {
    private static final Map<String, OutddHandler> outddFiles;
    private static final Map<String, InddHandler> inddFiles;
    private static final InddHandler sysinInddHandler;
    public static final int AA_DEFAULT = 0;
    public static final int AA_ON = 1;
    public static final int AA_OFF = 2;
    public static final int AA_MIXED = 3;
    private static Integer fontHandlingProp;
    private static final boolean dpifsDflt;
    protected Client client;
    private int menuManagerId;
    protected RemoteVirtualKeyboard remoteVirtualKeyboard;
    protected RemotePalette rp;
    protected Messages messages;
    protected CsProperty csProperty;
    private Integer upperLowerMethod;
    private Integer bitmapLoadMethod;
    private int screenResolution;
    private boolean roundFontSize;
    protected Hashtable<Hashtable, Font> allFonts;
    protected Hashtable<String, Font> createdFonts;
    private boolean kdbupper;
    private boolean kdblower;
    private boolean deficon = true;
    private static Image init_icon;
    private Image icon;
    private Image internalFrameIcon;
    private Image brokenImage;
    private int printPreviewIconImageId = -1;
    private boolean fieldsUnboxed;
    private int columnSeparation = 5;
    private boolean defKeyboardActionsEnabled = true;
    protected Vector enabledwindows = null;
    private InputStream sshin;
    private OutputStream sshout;
    private byte[] sshentercode;
    private int sshhandlecl;
    private int sshreturncmd = -1;
    private boolean colzerorm;
    protected Vector allLocalFonts;
    private static int guiFactoryIdProg;
    private final int guiFactoryId;
    private ClientCallImpl.MessageLoop ccMsgLoop;

    public AbstractGuiFactoryImpl() {
        this.icon = init_icon;
        this.guiFactoryId = ++guiFactoryIdProg;
    }

    public AbstractGuiFactoryImpl(InputStream sshin, OutputStream sshout, int sshhandlecl, byte[] sshentercode) {
        this.sshin = sshin;
        this.sshout = sshout;
        this.sshhandlecl = sshhandlecl;
        this.sshentercode = sshentercode;
        this.icon = init_icon;
        this.guiFactoryId = ++guiFactoryIdProg;
    }

    public ClientCallImpl.MessageLoop getCCMessageLoop() {
        if (this.ccMsgLoop == null) {
            this.ccMsgLoop = new ClientCallImpl.MessageLoop();
            this.ccMsgLoop.start();
        }
        return this.ccMsgLoop;
    }

    public int getId() {
        return this.guiFactoryId;
    }

    public Client getClient() {
        if (this.client == null) {
            this.client = new Client();
        }
        return this.client;
    }

    public int getMenuManagerId() {
        return this.menuManagerId;
    }

    public void setMenuManagerId(int m) {
        this.menuManagerId = m;
    }

    public RemoteVirtualKeyboard getRemoteVirtualKeyboard() {
        if (this.remoteVirtualKeyboard == null) {
            this.remoteVirtualKeyboard = new RemoteVirtualKeyboard(this);
        }
        return this.remoteVirtualKeyboard;
    }

    public RemotePalette getRemotePalette() {
        if (this.rp == null) {
            this.rp = new RemotePalette(this);
        }
        return this.rp;
    }

    public Messages getMessages() {
        if (this.messages == null) {
            this.messages = new Messages();
        }
        return this.messages;
    }

    @Override
    public final void modifyMessage(String name, String description) throws IOException {
        this.getMessages().modifyMessage(name, description);
    }

    public CsProperty getCsProperty() {
        if (this.csProperty == null) {
            this.csProperty = new CsProperty();
        }
        return this.csProperty;
    }

    @Override
    public ClientCall getClientCall() throws IOException {
        return new ClientCallImpl(this);
    }

    public int getScreenRes() {
        if (this.screenResolution == 0) {
            this.initScreenRes();
        }
        return this.screenResolution;
    }

    private void initScreenRes() {
        int screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
        this.roundFontSize = screenRes <= 96;
        this.screenResolution = Client.isWebClient() || !this.getCsProperty().get("iscobol.gui.dpifontscaling", dpifsDflt) ? 96 : screenRes;
    }

    public boolean shouldRoundFontSize() {
        if (this.screenResolution == 0) {
            this.initScreenRes();
        }
        return this.roundFontSize;
    }

    public Hashtable<Hashtable, Font> getAllFonts() {
        if (this.allFonts == null) {
            this.allFonts = new Hashtable();
        }
        return this.allFonts;
    }

    public Hashtable<String, Font> getCreatedFonts() {
        if (this.createdFonts == null) {
            this.createdFonts = new Hashtable();
        }
        return this.createdFonts;
    }

    public void addCreatedFont(Font f) {
        this.getCreatedFonts().put(f.getFamily(), f);
    }

    public Font getCreatedFont(String family) {
        return this.getCreatedFonts().get(family);
    }

    public void setKdbUpper(boolean b) {
        this.kdbupper = b;
    }

    public void setKdbLower(boolean b) {
        this.kdblower = b;
    }

    public boolean getKdbUpper() {
        return this.kdbupper;
    }

    public boolean getKdbLower() {
        return this.kdblower;
    }

    @Override
    public boolean modifyKey(String name, String values) throws IOException {
        if (name.equals("kbd_case")) {
            boolean Return2 = true;
            if (values.equalsIgnoreCase("upper")) {
                this.setKdbUpper(true);
            } else if (values.equalsIgnoreCase("lower")) {
                this.setKdbLower(true);
            } else if (values.equalsIgnoreCase("both")) {
                this.setKdbUpper(false);
                this.setKdbLower(false);
            } else {
                Return2 = false;
            }
            return Return2;
        }
        return this.getRemoteVirtualKeyboard().modifyKey(name, values);
    }

    @Override
    public void setDefaultIcon(boolean deficon) throws IOException {
        this.deficon = deficon;
    }

    public boolean haveDefaultIcon() {
        return this.deficon;
    }

    public Dimension _getScreenSize() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (HeadlessException he) {
            return null;
        }
    }

    private GraphicsConfiguration _getTargetConfiguration(Rectangle windowBounds) {
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsConfiguration Return2 = gds[0].getDefaultConfiguration();
        int maxIntersetctArea = 0;
        for (int i = 0; i < gds.length; ++i) {
            int area;
            if (gds[i].getType() != 0) continue;
            GraphicsConfiguration tmp = gds[i].getDefaultConfiguration();
            Rectangle r = tmp.getBounds();
            if (r.contains(windowBounds)) {
                Return2 = tmp;
                break;
            }
            Rectangle ints = r.intersection(windowBounds);
            if (ints.width <= 0 && ints.height <= 0 || (area = Math.max(1, ints.width) * Math.max(1, ints.height)) <= maxIntersetctArea) continue;
            maxIntersetctArea = area;
            Return2 = tmp;
        }
        return Return2;
    }

    @Override
    public Dimension getScreenSize() throws IOException {
        return this._getScreenSize();
    }

    public Insets _getScreenInsets() {
        try {
            return Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        }
        catch (HeadlessException ex) {
            return null;
        }
    }

    @Override
    public Insets getScreenInsets() throws IOException {
        return this._getScreenInsets();
    }

    @Override
    public Rectangle getScreenArea() throws IOException {
        return this._getScreenArea();
    }

    public Rectangle _getScreenArea() {
        Rectangle Return2 = new Rectangle();
        Dimension screenSize = this._getScreenSize();
        Insets screenInsets = this._getScreenInsets();
        if (screenSize != null) {
            Return2.y = screenSize.height;
            Return2.x = screenSize.width;
            if (screenInsets != null) {
                Return2.height = Return2.y - screenInsets.top - screenInsets.bottom;
                Return2.width = Return2.x - screenInsets.left - screenInsets.right;
            }
        }
        return Return2;
    }

    public Point adjustLocation(Point p, Dimension componentSize) {
        GraphicsConfiguration conf = this._getTargetConfiguration(new Rectangle(p, componentSize));
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(conf);
        Rectangle screenArea = conf.getBounds();
        screenArea.x += screenInsets.left;
        screenArea.y += screenInsets.top;
        screenArea.width -= screenInsets.left + screenInsets.right;
        screenArea.height -= screenInsets.top + screenInsets.bottom;
        Rectangle newComponentBounds = new Rectangle(p, componentSize);
        if (!screenArea.contains(newComponentBounds)) {
            int d;
            if (p.x < screenArea.x) {
                p.x = screenArea.x;
            } else {
                d = p.x + newComponentBounds.width - screenArea.x - screenArea.width;
                if (d > 0) {
                    p.x = Math.max(p.x - d, screenArea.x);
                }
            }
            if (p.y < screenArea.y) {
                p.y = screenArea.y;
            } else {
                d = p.y + newComponentBounds.height - screenArea.y - screenArea.height;
                if (d > 0) {
                    p.y = Math.max(p.y - d, screenArea.y);
                }
            }
        }
        return p;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
        init_icon = icon;
    }

    public Image getIcon() {
        return this.icon;
    }

    public Image getInternalFrameIcon() {
        return this.internalFrameIcon;
    }

    public void setInternalFrameIcon(Image internalFrameIcon) {
        this.internalFrameIcon = internalFrameIcon;
    }

    public void setBrokenImage(Image bi) {
        this.brokenImage = bi;
    }

    public Image getBrokenImage() {
        return this.brokenImage;
    }

    @Override
    public void setFieldsUnboxed(boolean b) throws IOException {
        this._setFieldsUnboxed(b);
    }

    public void _setFieldsUnboxed(boolean b) {
        this.fieldsUnboxed = b;
    }

    public boolean getFieldsUnboxed() {
        return this.fieldsUnboxed;
    }

    @Override
    public void setColumnSeparation(int val) throws IOException {
        this._setColumnSeparation(val);
    }

    public void _setColumnSeparation(int val) {
        this.columnSeparation = val;
    }

    public int getColumnSeparation() {
        return this.columnSeparation;
    }

    public void setDefaultKeyboardActionsEnabled(boolean b) {
        this.defKeyboardActionsEnabled = b;
    }

    public boolean getDefaultKeyboardActionsEnabled() {
        return this.defKeyboardActionsEnabled;
    }

    @Override
    public int execCmdFromServer(String cmd, String[] argv, String[][] env, boolean wait) throws IOException {
        int i;
        String[] env1;
        boolean cmdPort = false;
        if (env != null) {
            env1 = new String[env.length];
            for (i = 0; i < env.length && env[i][0] != null; ++i) {
                if (!"ISCOBOL_DISPLAY".equals(env[i][0])) continue;
                cmdPort = true;
            }
        } else {
            env1 = null;
        }
        if (cmdPort) {
            try {
                for (i = 0; i < env.length && env[i][0] != null; ++i) {
                    env1[i] = "export " + env[i][0] + "=";
                    if (env[i][1] == null) continue;
                    int n = i;
                    env1[n] = env1[n] + env[i][1];
                }
                for (i = 0; i < env1.length && env1[i] != null; ++i) {
                    this.sshout.write(env1[i].getBytes(), 0, env1[i].getBytes().length);
                    this.sshout.write(this.sshentercode, 0, this.sshentercode.length);
                    this.sshout.flush();
                }
                String cmdExec = cmd;
                if (argv != null) {
                    for (int i2 = 1; i2 < argv.length; ++i2) {
                        cmdExec = cmdExec + " \"" + argv[i2] + "\"";
                    }
                }
                this.sshout.write(cmdExec.getBytes(), 0, cmdExec.getBytes().length);
                this.sshout.flush();
                this.sshout.write(this.sshentercode, 0, this.sshentercode.length);
                this.sshout.flush();
                if (wait) {
                    int c;
                    this.enabledwindows = this.disableAllGUI();
                    String rc = "";
                    while ((c = this.sshin.read()) != this.sshentercode[0] && c > 0) {
                        rc = rc + (char)c;
                    }
                    this.sshreturncmd = Integer.parseInt(rc);
                    KeyboardBuffer.disable(null, -1);
                    this.enableAllGUI(this.enabledwindows);
                } else {
                    this.sshreturncmd = 0;
                }
                return this.sshreturncmd;
            }
            catch (IOException ee) {
                ee.printStackTrace();
                this.sshreturncmd = 255;
                return 255;
            }
        }
        for (i = 0; i < env.length && env[i][0] != null; ++i) {
            env1[i] = env[i][1] != null ? "export " + env[i][0] + "=\\\"" + env[i][1] + "\\\"" : "export " + env[i][0] + "=";
        }
        return this.execCmdFromServer(cmd, argv, env1, null, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execCmdFromServer(String cmd, String[] argv, String[] environ, String[] props, boolean wait) throws IOException {
        int i;
        if (this.sshout == null) {
            return -1;
        }
        int Return2 = 0;
        String cmdexec = "$ISCOBOL/native/shell/isexeccmd " + this.sshhandlecl;
        if (environ != null) {
            for (i = 0; i < environ.length; ++i) {
                if (environ[i] == null || environ[i].length() <= 0) continue;
                try {
                    this.sshout.write(environ[i].getBytes(), 0, environ[i].getBytes().length);
                    this.sshout.flush();
                    this.sshout.write(this.sshentercode, 0, this.sshentercode.length);
                    this.sshout.flush();
                    continue;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        cmdexec = cmdexec + " " + cmd;
        if (argv != null && argv.length > 0) {
            for (i = 0; i < argv.length; ++i) {
                cmdexec = cmdexec + " \"" + argv[i] + "\"";
            }
        }
        try {
            this.sshout.write(cmdexec.getBytes(), 0, cmdexec.getBytes().length);
            this.sshout.flush();
            this.sshout.write(this.sshentercode, 0, this.sshentercode.length);
            this.sshout.flush();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (wait) {
            this.enabledwindows = this.disableAllGUI();
            AbstractGuiFactoryImpl abstractGuiFactoryImpl = this;
            synchronized (abstractGuiFactoryImpl) {
                try {
                    KeyboardBuffer.enable(null);
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            KeyboardBuffer.disable(null, -1);
            this.enableAllGUI(this.enabledwindows);
        } else {
            this.sshreturncmd = 0;
        }
        Return2 = this.sshreturncmd;
        return Return2;
    }

    public Vector disableAllGUI() {
        return null;
    }

    public void enableAllGUI(Vector v) {
    }

    @Override
    public void exitGUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturnExecCMD(int ret) {
        this.sshreturncmd = ret;
        AbstractGuiFactoryImpl abstractGuiFactoryImpl = this;
        synchronized (abstractGuiFactoryImpl) {
            this.notify();
        }
    }

    @Override
    public final void setProperty(String key, String value) throws IOException {
        if ("iscobol.resource.language".equals(key) || "iscobol.resource.country".equals(key) || "iscobol.resource.variant".equals(key)) {
            System.setProperty(key, value);
            IscobolSystem.resetSystemResources(key, value);
        } else {
            this.getCsProperty().set(key, value);
        }
    }

    @Override
    public void setProperties(String cache) throws IOException {
        StringTokenizer st = new StringTokenizer(cache.toString(), "\u0000");
        while (st.hasMoreTokens()) {
            String type = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String key = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken();
            if ("K".equals(type)) {
                this.modifyKey(key, value);
                continue;
            }
            if ("M".equals(type)) {
                this.modifyMessage(key, value);
                continue;
            }
            if ("P".equals(type)) {
                if ("iscobol.font.handling".equals(key)) {
                    AbstractGuiFactoryImpl.setFontHandlingProp(value);
                    continue;
                }
                if ("iscobol.gui.screen_col_zero".equals(key)) {
                    if (!Config.isTrue(value)) continue;
                    this.colzerorm = true;
                    continue;
                }
                this.setProperty(key, value);
                continue;
            }
            if ("O".equals(type)) {
                if (key.equals("P_P_I")) {
                    this.setPrintPreviewIconImageId(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("D_I")) {
                    this.setDefaultIcon(Config.isTrue(value));
                    continue;
                }
                if (key.equals("D_L_W_P")) {
                    this.setDefaultLightWeightPopupEnabled(Config.isTrue(value));
                    continue;
                }
                if (key.equals("C_S")) {
                    this.setColumnSeparation(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("H_ON")) {
                    this.setHintsOn(Integer.parseInt(value) * 10);
                    continue;
                }
                if (key.equals("H_OFF")) {
                    this.setHintsOff(Integer.parseInt(value) * 10);
                    continue;
                }
                if (!key.equals("F_U")) continue;
                this.setFieldsUnboxed(Config.isTrue(value));
                continue;
            }
            System.err.println("Unknown type " + type);
        }
    }

    @Override
    public int getPrintPreviewIconImageId() {
        return this.printPreviewIconImageId;
    }

    @Override
    public void setPrintPreviewIconImageId(int printPreviewIconImageId) {
        this.printPreviewIconImageId = printPreviewIconImageId;
    }

    public LocalImage getPrintPreviewIconImage() {
        return (LocalImage)this.getClient().getId(this.printPreviewIconImageId);
    }

    @Override
    public Object callStaticMethod(String className, String methodName, String signature, Object[] parameters) {
        throw new UnsupportedOperationException();
    }

    public static int getFontHandlingProp() {
        return fontHandlingProp != null ? fontHandlingProp : 0;
    }

    private static void setFontHandlingProp(String value) {
        if (fontHandlingProp != null) {
            return;
        }
        try {
            fontHandlingProp = new Integer(value);
            switch (fontHandlingProp) {
                default: {
                    break;
                }
                case 1: {
                    System.setProperty("awt.useSystemAAFontSettings", "on");
                    break;
                }
                case 2: {
                    System.setProperty("awt.useSystemAAFontSettings", "off");
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getColZeroRm() {
        return this.colzerorm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteImage loadClientImage(String path) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);
        if (in == null) {
            path = File.get(path).getAbsolutePath();
            try {
                in = new FileInputStream(path);
            }
            catch (IOException ex) {
                return null;
            }
        }
        try {
            byte[] b = new byte[in.available()];
            in.read(b);
            RemoteImage remoteImage = this.loadImage(b);
            return remoteImage;
        }
        catch (IOException ex) {
            RemoteImage remoteImage = null;
            return remoteImage;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Object loadImage(String text, int width, int height, int barcodeType, int dpi, int orientation, int antialiasing, int textPosition, int background, int foreground, int logoId) throws IOException {
        BarcodeCreator bcc = null;
        try {
            bcc = (BarcodeCreator)Class.forName("com.iscobol.misc.image.Barcode4JCreator").newInstance();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Color bg = this.getRemotePalette().getDefaultColor(background);
        Color fg = this.getRemotePalette().getDefaultColor(foreground);
        Object id = this.getClient().getId(logoId);
        Image logo = id instanceof LocalImage ? ((LocalImage)id).getImage() : null;
        try {
            byte[] bytes = bcc.createImageAsStream(text, width, height, barcodeType, dpi, orientation, antialiasing, textPosition, bg, fg, logo);
            return this.loadImage(bytes);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @Override
    public RemoteImage loadImage(byte[] imgStream) throws IOException {
        LocalImage lim = new LocalImage(imgStream, 0, this.getCsProperty().get("iscobol.gui.light_gray_is_transparent", true), this.getBitmapLoadMethod());
        int theObject = this.getClient().setId(lim);
        return new RemoteImageImpl(this, theObject);
    }

    @Override
    public RemoteProgressDialog getRemoteProgressDialog(String title, String cancelMessage, int flags, int imageId, int activeWindowId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void showHint(String text, float x, float y, int timeout, int activeWindowId) throws IOException {
    }

    @Override
    public int desktop(String operation, String uri) throws IOException {
        return -1;
    }

    @Override
    public int desktop(String operation, String fileName, byte[] contents) throws IOException {
        return -1;
    }

    @Override
    public final RemoteFile getRemoteFile(String clazz) throws IOException {
        return new RemoteFileImpl(clazz);
    }

    @Override
    public final RemoteIO getRemoteIO() throws IOException {
        return new ClientCallRemoteIO(this.getCCMessageLoop());
    }

    @Override
    public RemoteSpoolPrinter getSpoolPrinter(int current) throws IOException {
        SpoolPrinter sp = SpoolPrinter.get(this);
        int theObject = this.getClient().setId(sp);
        SpoolPrinter curr = (SpoolPrinter)this.getClient().getId(current);
        if (curr != null) {
            sp.setAttrs(curr);
        }
        return new RemoteSpoolPrinterImpl(this, theObject);
    }

    @Override
    public RemoteSpoolPrinter getSpoolPrinter(boolean preview, boolean direct, boolean pdf, String fileName, boolean binary, Events events, int current) throws IOException {
        SpoolPrinter sp = SpoolPrinter.get(this, preview, direct, pdf, fileName, binary, events);
        int theObject = this.getClient().setId(sp);
        SpoolPrinter curr = (SpoolPrinter)this.getClient().getId(current);
        if (curr != null) {
            sp.setAttrs(curr);
        }
        return new RemoteSpoolPrinterImpl(this, theObject);
    }

    @Override
    public String keybuf(int opCode, String[] args) throws IOException {
        return String.valueOf(1);
    }

    @Override
    public Remote getFactoryExtension(String className) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayUponSysOut(boolean flush, String str) throws IOException {
        this.displayUponSysOut(flush, str, null, 0, true, true);
    }

    @Override
    public void displayUponSysOut(boolean flush, String str, boolean eol) throws IOException {
        this.displayUponSysOut(flush, str, null, 0, true, eol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayUponSysOut(boolean flush, String str, String filename, int recLen, boolean lineSeq, boolean advancing) throws IOException {
        if (filename != null) {
            if (lineSeq) {
                str = Factory.rightTrim(str);
            }
            Map<String, OutddHandler> map = outddFiles;
            synchronized (map) {
                OutddHandler out = outddFiles.get(filename);
                if (out == null) {
                    String handlerClassName = this.getCsProperty().get("iscobol.file.outdd", null);
                    if (handlerClassName != null) {
                        try {
                            out = (OutddHandler)Class.forName(handlerClassName).newInstance();
                            try {
                                out.open(filename, recLen, lineSeq);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                out = null;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (out == null) {
                        out = new MyOutddHandler();
                        try {
                            out.open(filename, recLen, lineSeq);
                        }
                        catch (IOException ex) {
                            System.err.println(ex);
                            System.err.println("Used System.out");
                            out = new SysoutOutddHandler(recLen, lineSeq);
                        }
                    }
                    outddFiles.put(filename, out);
                }
                out.write(str, advancing);
            }
        }
        System.out.print(str);
        if (advancing) {
            System.out.println();
        }
        if (flush) {
            System.out.flush();
        }
    }

    @Override
    public String acceptFromSysIn() throws IOException {
        return this.acceptFromSysIn((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String acceptFromSysIn(String filename) throws IOException {
        Map<String, InddHandler> map = inddFiles;
        synchronized (map) {
            if (filename != null) {
                return this.acceptFromSysIn(this.getIndd(filename));
            }
            return this.acceptFromSysIn(sysinInddHandler);
        }
    }

    @Override
    public void acceptOmitted() throws IOException {
        this.acceptOmitted((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptOmitted(String filename) throws IOException {
        Map<String, InddHandler> map = inddFiles;
        synchronized (map) {
            if (filename != null) {
                this.acceptOmitted(this.getIndd(filename));
            } else {
                this.acceptOmitted(sysinInddHandler);
            }
        }
    }

    private String acceptFromSysIn(InddHandler hdl) throws IOException {
        return hdl.readLine();
    }

    private void acceptOmitted(InddHandler in) throws IOException {
        try {
            in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InddHandler getIndd(String filename) {
        InddHandler in = inddFiles.get(filename);
        if (in == null) {
            String handlerClassName = this.getCsProperty().get("iscobol.file.indd", null);
            if (handlerClassName != null) {
                try {
                    in = (InddHandler)Class.forName(handlerClassName).newInstance();
                    try {
                        in.open(filename);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        in = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (in == null) {
                in = new MyInddHandler();
                try {
                    in.open(filename);
                }
                catch (IOException ex) {
                    System.err.println(ex);
                    System.err.println("Used System.in");
                    in = sysinInddHandler;
                }
            }
            inddFiles.put(filename, in);
        }
        return in;
    }

    public int getUpperLowerMethod() {
        if (this.upperLowerMethod == null) {
            this.upperLowerMethod = this.getCsProperty().get("iscobol.upper_lower_method", 1);
        }
        return this.upperLowerMethod;
    }

    public int getBitmapLoadMethod() {
        if (this.bitmapLoadMethod == null) {
            this.bitmapLoadMethod = this.getCsProperty().get("iscobol.bitmap.load_method", 1);
        }
        return this.bitmapLoadMethod;
    }

    public int getExceptionValue(String clazz) throws IOException {
        return 0;
    }

    public int getTerminationValue(String clazz) throws IOException {
        return 0;
    }

    public Vector getAllLocalFonts() {
        if (this.allLocalFonts == null) {
            this.allLocalFonts = new Vector();
        }
        return this.allLocalFonts;
    }

    @Override
    public PrintService serverPrintDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        PrintService Return2 = ServiceUI.printDialog(gc, x, y, services, defaultService, flavor, attributes);
        if (Return2 instanceof MyPrintService) {
            ((MyPrintService)Return2).setPrintAttributes(attributes);
        }
        return Return2;
    }

    @Override
    public RemoteImage rotate(int imageId, double theta) throws IOException {
        Object o = this.getClient().getId(imageId);
        if (o instanceof LocalImage) {
            Image src = ((LocalImage)o).getImage();
            BufferedImage rotatedImg = ScreenUtility.rotate(src, theta);
            LocalImage lim = new LocalImage(rotatedImg, 0, this.getBitmapLoadMethod());
            int theObject = this.getClient().setId(lim);
            return new RemoteImageImpl(this, theObject);
        }
        return null;
    }

    @Override
    public RemoteImage scale(int imageId, double width, double height, int scaleType, int align, boolean bestQuality) throws IOException {
        Object o = this.getClient().getId(imageId);
        if (o instanceof LocalImage) {
            Image src = ((LocalImage)o).getImage();
            BufferedImage scaledImg = ScreenUtility.scale(src, width, height, scaleType, align, bestQuality);
            LocalImage lim = new LocalImage(scaledImg, 0, this.getBitmapLoadMethod());
            int theObject = this.getClient().setId(lim);
            return new RemoteImageImpl(this, theObject);
        }
        return null;
    }

    @Override
    public RemoteImage align(int imageId, double width, double height, int align) throws IOException {
        Object o = this.getClient().getId(imageId);
        if (o instanceof LocalImage) {
            Image src = ((LocalImage)o).getImage();
            BufferedImage alignedImg = ScreenUtility.align(src, width, height, align);
            LocalImage lim = new LocalImage(alignedImg, 0, this.getBitmapLoadMethod());
            int theObject = this.getClient().setId(lim);
            return new RemoteImageImpl(this, theObject);
        }
        return null;
    }

    static {
        boolean b;
        try {
            Class.class.getMethod("getModule", new Class[0]);
            b = false;
        }
        catch (Throwable t) {
            b = true;
        }
        dpifsDflt = b;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Object hdl : outddFiles.values()) {
                    try {
                        hdl.close();
                    }
                    catch (IOException iOException) {}
                }
                for (Object hdl : inddFiles.values()) {
                    try {
                        hdl.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        outddFiles = new HashMap<String, OutddHandler>();
        inddFiles = new HashMap<String, InddHandler>();
        sysinInddHandler = new SysinInddHandler();
    }

    private static class MyOutddHandler
    implements OutddHandler {
        PrintStream out;
        int recordLen;
        boolean lineSequential;
        String lastRecord = "";

        private MyOutddHandler() {
        }

        @Override
        public void open(String fileName, int recordLen, boolean lineSequential) throws IOException {
            this.out = new PrintStream(fileName);
            this.recordLen = recordLen;
            this.lineSequential = lineSequential;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void write(String str, boolean advancing) throws IOException {
            if (this.recordLen > 0) {
                int recordLen0 = this.recordLen - this.lastRecord.length();
                if (str.length() > recordLen0) {
                    this.lastRecord = "";
                    this.out.print(str.substring(0, recordLen0));
                    if (this.lineSequential) {
                        this.out.println();
                    }
                    str = str.substring(recordLen0);
                }
                while (str.length() > this.recordLen) {
                    this.lastRecord = "";
                    this.out.print(str.substring(0, this.recordLen));
                    if (this.lineSequential) {
                        this.out.println();
                    }
                    str = str.substring(this.recordLen);
                }
            }
            this.out.print(str);
            if (advancing) {
                if (this.lineSequential) {
                    this.out.println();
                } else {
                    int d = this.recordLen - str.length();
                    for (int i = 0; i < d; ++i) {
                        this.out.print(" ");
                    }
                }
                this.lastRecord = "";
            } else {
                this.lastRecord = this.lastRecord + str;
            }
        }
    }

    private static class SysoutOutddHandler
    extends MyOutddHandler {
        SysoutOutddHandler(int recordLen, boolean lineSequential) {
            this.out = System.out;
            this.recordLen = recordLen;
            this.lineSequential = lineSequential;
        }

        @Override
        public void open(String fileName, int recordLen, boolean lineSequential) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class MyInddHandler
    implements InddHandler {
        InputStreamReader in;

        private MyInddHandler() {
        }

        @Override
        public void open(String fileName) throws IOException {
            this.in = new InputStreamReader(new FileInputStream(fileName));
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.in == null) {
                return 0;
            }
            return this.in.read();
        }

        @Override
        public String readLine() throws IOException {
            if (this.in == null) {
                return null;
            }
            StringBuilder Return2 = new StringBuilder();
            int c = 0;
            while ((c = this.in.read()) >= 0 && c != 10) {
                if (c == 13) continue;
                Return2.append((char)c);
            }
            return Return2.toString();
        }
    }

    private static final class SysinInddHandler
    extends MyInddHandler {
        SysinInddHandler() {
            this.in = new InputStreamReader(System.in);
        }

        @Override
        public void open(String fileName) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

