/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.AppFactory;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.LocLinkedList;
import com.iscobol.gui.Navigable;
import com.iscobol.gui.client.AppFactoryImpl;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.CommunicationException;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeEnvironmentType;
import com.iscobol.rts.RuntimeInfo;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScreenUtility
extends IsguiUtility {
    public static final char LOW_VALUE = '\u0000';
    private static Hashtable serverFonts;

    public static boolean canPaste(Object requestor) {
        return Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
    }

    public static String getAll(char c, int len) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    public static String rightTrim(String s) {
        return Factory.rightTrim(s);
    }

    public static void disableFocusTraversalKeys(Container container) {
        if (container != null) {
            try {
                container.setFocusTraversalKeys(1, Collections.EMPTY_SET);
                container.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String allSpaces(int len) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            ret.append(' ');
        }
        return ret.toString();
    }

    public static GuiFactory setGuiFactory() {
        AppFactory af = (AppFactory)IscobolSystem.get(AppFactory.class);
        if (af == null) {
            KeyboardBuffer.clinit();
            af = new AppFactoryImpl();
            IscobolSystem.set(AppFactory.class, af);
            String prop = Config.getProperty(".guifactory.class", "com.iscobol.gui.client.swing.GuiFactoryImpl");
            if ("com.iscobol.gui.client.zk.GuiFactoryImpl".equals(prop)) {
                RuntimeInfo.set(RuntimeEnvironmentType.WD2);
            } else if ("com.iscobol.gui.client.charva.GuiFactoryImpl".equals(prop)) {
                RuntimeInfo.set(RuntimeEnvironmentType.STANDALONE_CHARVA);
            } else {
                RuntimeInfo.set(RuntimeEnvironmentType.STANDALONE);
            }
        }
        GuiFactory gf = null;
        try {
            gf = af.newGuiFactory();
            IscobolSystem.set(GuiFactory.class, gf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return gf;
    }

    public static GuiFactory getGuiFactory() {
        GuiFactory gf = (GuiFactory)IscobolSystem.get(GuiFactory.class);
        if (gf == null) {
            gf = ScreenUtility.setGuiFactory();
        }
        return gf;
    }

    public static boolean isWD2() {
        return !IscobolSystem.isAS() && "com.iscobol.gui.client.zk.GuiFactoryImpl".equals(Config.getProperty("iscobol.guifactory.class", "com.iscobol.gui.client.swing.GuiFactoryImpl"));
    }

    public static void handleIOException(IOException _re) {
        throw new CommunicationException(_re);
    }

    public static String removeLowValues(String s) {
        int idx = 0;
        StringBuffer Return2 = new StringBuffer(s);
        while ((idx = Return2.toString().indexOf(0)) >= 0) {
            Return2.deleteCharAt(idx);
        }
        return Return2.toString();
    }

    public static String truncAtFirstLowValue(String s) {
        int idx = s.indexOf(0);
        if (idx >= 0) {
            return s.substring(0, idx);
        }
        return s;
    }

    public static boolean isPrintableChar(char c) {
        int hc = new Character(c).hashCode();
        return hc >= 32 && hc <= 126 || hc >= 160 && hc <= 255 || c == '\b' || hc == 127;
    }

    public static int getMnemonicChar(StringBuffer t) {
        int idx = ScreenUtility.getMnemonicIdx(t);
        return idx >= 0 ? (int)t.charAt(idx) : -1;
    }

    public static int getMnemonicIdx(StringBuffer t) {
        int Return2;
        block4: {
            int idx;
            block5: {
                Return2 = -1;
                idx = 0;
                if (t == null || t.toString() == null) break block4;
                if (!t.toString().toUpperCase().startsWith("<HTML")) break block5;
                idx = t.indexOf("<u");
                if (idx == -1) {
                    idx = t.indexOf("<U");
                }
                if (idx < 0) break block4;
                idx += 2;
                while (idx < t.length() && t.charAt(idx) == ' ') {
                    ++idx;
                }
                if (idx >= t.length() || idx + 1 >= t.length() || t.charAt(idx) != '>' || Return2 >= 0) break block4;
                Return2 = idx + 1;
                break block4;
            }
            while ((idx = ScreenUtility.indexOf(t, '&', idx)) >= 0) {
                char c;
                if (idx + 1 < t.length() && (c = t.charAt(idx + 1)) != '&' && Return2 < 0) {
                    Return2 = idx;
                }
                t.deleteCharAt(idx);
                ++idx;
            }
        }
        return Return2;
    }

    private static int calcDistance(int x, int y, Navigable n, boolean isup) {
        int distance = -1;
        int distanceY = -1;
        if (isup && n.getY() >= y || !isup && n.getY() <= y || !n.isValidRemoteControl() || !n.isInputField() || !n.controlPeerisEnabled() || !n.controlPeerisVisible() || !n.getActiveAccept() || n.isProtectedField()) {
            distanceY = Integer.MAX_VALUE;
        } else {
            int nx = n.getX() - x;
            distanceY = n.getY() - y;
            if (nx < 0) {
                nx *= -1;
            }
            if (distanceY < 0) {
                distanceY *= -1;
            }
            distance = (int)Math.sqrt(nx * nx + distanceY * distanceY);
        }
        n.setDistance(distance, distanceY);
        return distanceY;
    }

    public static Navigable getUp(ArrayList al, Navigable curr, int currX, int currY) {
        Navigable Return2 = null;
        Collections.sort(al, new NavigableComparator(curr, currX, currY, true));
        Return2 = ScreenUtility.getClosest(al);
        if (al != null && al.size() == 1 && (Navigable)al.get(0) == curr && Return2 == curr) {
            Return2 = null;
        }
        return Return2;
    }

    public static Navigable getDown(ArrayList al, Navigable curr, int currX, int currY) {
        Navigable Return2 = null;
        Collections.sort(al, new NavigableComparator(curr, currX, currY, false));
        Return2 = ScreenUtility.getClosest(al);
        if (al != null && al.size() == 1 && (Navigable)al.get(0) == curr && Return2 == curr) {
            Return2 = null;
        }
        return Return2;
    }

    private static Navigable getClosest(ArrayList al) {
        Navigable Return2 = null;
        Navigable closest = (Navigable)al.get(0);
        if (closest != null && closest.getDistanceY() < Integer.MAX_VALUE) {
            Navigable tmp = null;
            for (int i = 1; i < al.size() && (tmp = (Navigable)al.get(i)) != null && tmp.getY() == closest.getY(); ++i) {
                if (tmp.getDistance() >= closest.getDistance()) continue;
                closest = tmp;
            }
            Return2 = tmp != null && tmp.getY() == closest.getY() ? tmp : closest;
        }
        return Return2;
    }

    private static int indexOf(StringBuffer sb, char c, int fromIdx) {
        while (fromIdx < sb.length()) {
            if (sb.charAt(fromIdx) == c) {
                return fromIdx;
            }
            ++fromIdx;
        }
        return -1;
    }

    public static Navigable stgetTransferFocusForward(Navigable nv, boolean loop, boolean vk_tab, boolean forceActiveAccept) {
        return ScreenUtility.stgetTransferFocusForward(nv, null, null, loop, false, vk_tab, forceActiveAccept);
    }

    public static Navigable stgetTransferFocusForward(Navigable nv, boolean loop, boolean wrap, boolean vk_tab, boolean forceActiveAccept) {
        return ScreenUtility.stgetTransferFocusForward(nv, null, null, loop, wrap, vk_tab, forceActiveAccept);
    }

    public static Navigable stgetTransferFocusForward(Navigable nv, Navigable init, Navigable parent, boolean loop, boolean wrap, boolean vk_tab, boolean forceActiveAccept) {
        Navigable target;
        Navigable Return2 = null;
        Navigable control = null;
        int i = 0;
        if (vk_tab && nv.getParentControlNV() != null && (target = ScreenUtility.getNextInGroupNV(nv, nv.getParentControlNV().getChildGraphics(), !forceActiveAccept, vk_tab)) != nv) {
            return target;
        }
        if (!loop && nv.isValidRemoteControl()) {
            if (nv.isInputField() && nv.controlPeerisEnabled() && nv.controlPeerisVisible() && (forceActiveAccept || nv.getActiveAccept()) && !nv.isProtectedField() && (!vk_tab || !nv.getNoTab())) {
                Return2 = nv;
            }
        } else if (nv.getChildGraphics() != null && nv.getChildGraphics().size() > 0) {
            if (init != null) {
                for (i = 1; init != control && i <= nv.getChildGraphics().size(); ++i) {
                    control = (Navigable)nv.getChildGraphics().getIdxElement(i);
                }
            }
            while (Return2 == null && i <= nv.getChildGraphics().size()) {
                if (vk_tab && control != null) {
                    i = ScreenUtility.getNextChildNV(control, nv.getChildGraphics(), i);
                }
                if (i <= nv.getChildGraphics().size() && (control = (Navigable)nv.getChildGraphics().getIdxElement(i)) != null && (control.getControlPeerType() > 0 || control.getControlPeerType() == 0 && control.controlPeerisEnabledAttr() && control.getChildGraphics() != null && control.getChildGraphics().size() > 0 && (!nv.getContainsChildCTRL() || control.controlPeerisVisibleAttr()))) {
                    Return2 = ScreenUtility.stgetTransferFocusForward(control, false, vk_tab, forceActiveAccept);
                }
                ++i;
            }
            if (i >= nv.getChildGraphics().size() + 1 && Return2 == null) {
                if (nv.getParentControlNV() != null) {
                    if (parent != null && nv.getParentControlNV() != parent) {
                        Return2 = ScreenUtility.stgetTransferFocusForward(nv.getParentControlNV(), nv, nv.getParentControlNV(), false, wrap, vk_tab, forceActiveAccept);
                    }
                } else if (wrap && init != null) {
                    Return2 = ScreenUtility.stgetTransferFocusForward(nv, false, wrap, vk_tab, forceActiveAccept);
                } else if (wrap) {
                    // empty if block
                }
            }
        } else if (loop) {
            if (nv.getParentControlNV() != null) {
                Return2 = ScreenUtility.stgetTransferFocusForward(nv.getParentControlNV(), nv, nv.getParentControlNV(), false, wrap, vk_tab, forceActiveAccept);
            } else if (wrap) {
                Return2 = ScreenUtility.stgetTransferFocusForward(nv, false, vk_tab, forceActiveAccept);
            }
        }
        return Return2;
    }

    public static Navigable stgetTransferFocusBackward(Navigable nv, boolean loop, boolean wrap, boolean vk_tab, boolean forceActiveAccept) {
        return ScreenUtility.stgetTransferFocusBackward(nv, null, null, loop, wrap, vk_tab, forceActiveAccept);
    }

    public static Navigable stgetTransferFocusBackward(Navigable nv, boolean loop, boolean vk_tab, boolean forceActiveAccept) {
        return ScreenUtility.stgetTransferFocusBackward(nv, null, null, loop, false, vk_tab, forceActiveAccept);
    }

    public static Navigable stgetTransferFocusBackward(Navigable nv, Navigable init, Navigable parent, boolean loop, boolean wrap, boolean vk_tab, boolean forceActiveAccept) {
        Navigable target;
        Navigable Return2 = null;
        Navigable control = null;
        int i = 0;
        if (vk_tab && nv.getParentControlNV() != null && (target = ScreenUtility.getPrevInGroupNV(nv, nv.getParentControlNV().getChildGraphics(), !forceActiveAccept, vk_tab)) != nv) {
            return target;
        }
        if (!loop && nv.isValidRemoteControl()) {
            if (nv.isInputField() && nv.controlPeerisEnabled() && nv.controlPeerisVisible() && (forceActiveAccept || nv.getActiveAccept()) && !nv.isProtectedField() && (!vk_tab || !nv.getNoTab())) {
                Return2 = nv;
            }
        } else if (nv.getChildGraphics() != null && nv.getChildGraphics().size() > 0) {
            if (init != null) {
                for (i = nv.getChildGraphics().size(); init != control && i > 0; --i) {
                    control = (Navigable)nv.getChildGraphics().getIdxElement(i);
                }
            }
            while (Return2 == null && i > 0) {
                if (vk_tab && control != null) {
                    i = ScreenUtility.getPrevChildNV(control, nv.getChildGraphics(), i);
                }
                if (i > 0 && (control = (Navigable)nv.getChildGraphics().getIdxElement(i)) != null && (control.getControlPeerType() > 0 || control.getControlPeerType() == 0 && control.controlPeerisEnabledAttr() && (!nv.getContainsChildCTRL() || control.controlPeerisVisibleAttr()))) {
                    Return2 = ScreenUtility.stgetTransferFocusBackward(control, false, wrap, vk_tab, forceActiveAccept);
                }
                --i;
            }
            if (i <= 0 && Return2 == null) {
                if (nv.getParentControlNV() != null) {
                    if (parent != null && nv.getParentControlNV() != parent) {
                        Return2 = ScreenUtility.stgetTransferFocusBackward(nv.getParentControlNV(), nv, nv.getParentControlNV(), false, wrap, vk_tab, forceActiveAccept);
                    }
                } else if (wrap && init != null) {
                    Return2 = ScreenUtility.stgetTransferFocusBackward(nv, false, wrap, vk_tab, forceActiveAccept);
                } else if (wrap) {
                    // empty if block
                }
            }
        } else if (loop) {
            if (nv.getParentControlNV() != null) {
                Return2 = ScreenUtility.stgetTransferFocusBackward(nv.getParentControlNV(), nv, nv.getParentControlNV(), false, wrap, vk_tab, forceActiveAccept);
            } else if (wrap) {
                Return2 = ScreenUtility.stgetTransferFocusBackward(nv, false, wrap, vk_tab, forceActiveAccept);
            }
        }
        return Return2;
    }

    public static Navigable getNextInGroupNV(Navigable nv, LocLinkedList cG, boolean checkActiveAccept, boolean vk_tab) {
        if (!nv.hasNextInGroupNV()) {
            return nv;
        }
        Navigable[] childs = new Navigable[cG.size()];
        cG.toArray(childs);
        int thisgroup = Integer.parseInt(nv.getPropNV(103));
        int idxnv = cG.indexOf(nv);
        String valueNV = null;
        for (int i = 0; childs != null && i < childs.length; ++i) {
            if (!childs[i].hasNextInGroupNV() || !childs[i].controlPeerisEnabled() || !childs[i].controlPeerisVisible() || checkActiveAccept && !childs[i].getActiveAccept() || childs[i].getNoGroupTab() || childs[i].getNoTab() || Integer.parseInt(childs[i].getPropNV(103)) != thisgroup || (valueNV = childs[i].getValueNV()) == null || !childs[i].haveSameGroupValue(valueNV, childs[i].getControlValue())) continue;
            if (idxnv >= 0 && i < idxnv) {
                return null;
            }
            return childs[i];
        }
        return nv;
    }

    public static Navigable getPrevInGroupNV(Navigable nv, LocLinkedList cG, boolean checkActiveAccept, boolean vk_tab) {
        if (!nv.hasNextInGroupNV()) {
            return nv;
        }
        if (!vk_tab) {
            return ScreenUtility.getNextInGroupNV(nv, cG, checkActiveAccept, vk_tab);
        }
        Navigable[] childs = new Navigable[cG.size()];
        cG.toArray(childs);
        int thisgroup = Integer.parseInt(nv.getPropNV(103));
        int idxnv = cG.indexOf(nv);
        String valueNV = null;
        for (int i = childs.length - 1; childs != null && i >= 0; --i) {
            if (!childs[i].hasNextInGroupNV() || !childs[i].controlPeerisEnabled() || !childs[i].controlPeerisVisible() || checkActiveAccept && !childs[i].getActiveAccept() || childs[i].getNoGroupTab() || childs[i].getNoTab() || Integer.parseInt(childs[i].getPropNV(103)) != thisgroup || (valueNV = childs[i].getValueNV()) == null || !childs[i].haveSameGroupValue(valueNV, childs[i].getControlValue())) continue;
            if (idxnv >= 0 && idxnv < i) {
                return null;
            }
            return childs[i];
        }
        return nv;
    }

    public static int getNextChildNV(Navigable nv, LocLinkedList cG, int i) {
        int Return2;
        if (!nv.hasNextInGroupNV()) {
            return i;
        }
        if (nv.getNoGroupTab()) {
            return i;
        }
        Navigable bgc = null;
        int thisgroup = Integer.parseInt(nv.getPropNV(103));
        int bgcgroup = 1;
        for (Return2 = i; Return2 <= cG.size() && (bgc = (Navigable)cG.getIdxElement(Return2)) != null && bgc.hasNextInGroupNV() && (bgcgroup = Integer.parseInt(bgc.getPropNV(103))) == thisgroup; ++Return2) {
        }
        return Return2;
    }

    public static int getPrevChildNV(Navigable nv, LocLinkedList cG, int i) {
        int Return2;
        if (!nv.hasNextInGroupNV()) {
            return i;
        }
        if (nv.getNoGroupTab()) {
            return i;
        }
        Navigable bgc = null;
        int thisgroup = Integer.parseInt(nv.getPropNV(103));
        int bgcgroup = 1;
        for (Return2 = i; Return2 > 0 && (bgc = (Navigable)cG.getIdxElement(Return2)) != null && bgc.hasNextInGroupNV() && (bgcgroup = Integer.parseInt(bgc.getPropNV(103))) == thisgroup; --Return2) {
        }
        return Return2;
    }

    public static String strreplaceAll(String from, String to, String newstr) {
        StringTokenizer st;
        if (to == null || to.length() == 0) {
            return from;
        }
        int idx = from.lastIndexOf(to);
        if (idx != -1) {
            StringBuffer ret = new StringBuffer(from);
            ret.replace(idx, idx + to.length(), newstr);
            while ((idx = from.lastIndexOf(to, idx - 1)) != -1) {
                ret.replace(idx, idx + to.length(), newstr);
            }
            from = ret.toString();
        }
        if ((st = new StringTokenizer(to, to, true)) != null) {
            idx = 0;
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                if (!tk.equals("\n") && from.lastIndexOf(tk) > 0) {
                    from = ScreenUtility.strreplaceAll(from, tk, "");
                }
                ++idx;
            }
        }
        return from;
    }

    public static String createServerFont(int fontType, InputStream is) throws IOException {
        try {
            String Return2;
            Font f = Font.createFont(fontType, is);
            if (serverFonts == null) {
                serverFonts = new Hashtable();
            }
            if ((Return2 = f.getFamily()) != null) {
                serverFonts.put(Return2, f);
            }
            return Return2;
        }
        catch (IOException ioe) {}
        catch (IllegalArgumentException iae) {}
        catch (Exception fontFormatException) {}
        finally {
            return null;
        }
    }

    public static Font getServerFont(Map tattrs) {
        Font cf;
        Font Return2;
        String family;
        if (tattrs == null) {
            tattrs = Font.decode(null).getAttributes();
        }
        if ((family = (String)tattrs.get(TextAttribute.FAMILY)) == null) {
            family = "";
        }
        if (!(Return2 = Font.getFont(tattrs)).getFamily().equalsIgnoreCase(family) && serverFonts != null && (cf = (Font)serverFonts.get(family)) != null) {
            tattrs.remove(TextAttribute.FAMILY);
            Return2 = cf.deriveFont(tattrs);
        }
        return Return2;
    }

    public static <T> int getInsertionIndex(Vector<T> list, T element, Comparator<T> comparator) {
        int leftIndex = 0;
        int rightIndex = list.size() - 1;
        int index = leftIndex + (rightIndex - leftIndex) / 2;
        while (leftIndex <= rightIndex) {
            int c = comparator.compare(list.elementAt(index), element);
            if (c == 0) {
                return index;
            }
            if (c > 0) {
                rightIndex = index - 1;
            } else {
                leftIndex = index + 1;
            }
            index = leftIndex + (rightIndex - leftIndex) / 2;
        }
        return index;
    }

    public static Navigable stgetFirstInputField(Navigable nv) {
        Navigable ctl = null;
        Navigable Return2 = null;
        Enumeration ctlLI = nv.getParentControlNV().getChildGraphics().elements();
        while (Return2 == null && ctlLI.hasMoreElements()) {
            ctl = (Navigable)ctlLI.nextElement();
            if (ctl == null || !ctl.getActiveAccept() || !ctl.isInputField()) continue;
            Return2 = ctl;
        }
        if (Return2 == null) {
            Return2 = nv;
        }
        return Return2;
    }

    public static Navigable stgetLastInputField(Navigable nv) {
        int csize;
        Navigable ctl = null;
        Navigable Return2 = null;
        for (int i = csize = nv.getParentControlNV().getChildGraphics().size(); Return2 == null && i > 0; --i) {
            ctl = (Navigable)nv.getParentControlNV().getChildGraphics().getIdxElement(i);
            if (ctl == null || !ctl.getActiveAccept() || !ctl.isInputField()) continue;
            Return2 = ctl;
        }
        if (Return2 == null) {
            Return2 = nv;
        }
        return Return2;
    }

    public static int desktop(String operation, String uri) {
        Desktop.Action a;
        Desktop d;
        Logger log = LoggerFactory.get(8);
        if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(a = Desktop.Action.valueOf(operation))) {
            try {
                switch (a) {
                    case BROWSE: {
                        d.browse(new URI(uri));
                        break;
                    }
                    case EDIT: {
                        d.edit(new File(uri));
                        break;
                    }
                    case MAIL: {
                        d.mail(new URI(uri));
                        break;
                    }
                    case OPEN: {
                        d.open(new File(uri));
                        break;
                    }
                    case PRINT: {
                        d.print(new File(uri));
                        break;
                    }
                    default: {
                        if (log == null) break;
                        log.info("C$DESKTOP: errmsg=invalid operation!");
                    }
                }
                return 0;
            }
            catch (SecurityException e) {
                if (log != null) {
                    log.info("C$DESKTOP: errmsg=" + e.getMessage());
                }
                return -4;
            }
            catch (Exception e) {
                if (log != null) {
                    log.info("C$DESKTOP: errmsg=" + e.getMessage());
                }
                return -3;
            }
        }
        if (log != null) {
            log.info("C$DESKTOP: errmsg=desktop not supperted!");
        }
        return -1;
    }

    public static class NavigableComparator
    implements Comparator {
        Navigable current;
        boolean isup;
        int x;
        int y;

        public NavigableComparator(Navigable current, boolean isup) {
            this.current = current;
            this.isup = isup;
            if (current != null) {
                this.x = current.getX();
                this.y = current.getY();
            }
        }

        public NavigableComparator(Navigable current, int x, int y, boolean isup) {
            this.current = current;
            this.isup = isup;
            this.x = x;
            this.y = y;
        }

        public int compare(Object o1, Object o2) {
            Navigable n1 = (Navigable)o1;
            Navigable n2 = (Navigable)o2;
            int ipn1 = -1;
            int ipn2 = -1;
            ipn1 = ScreenUtility.calcDistance(this.x, this.y, n1, this.isup);
            ipn2 = ScreenUtility.calcDistance(this.x, this.y, n2, this.isup);
            return ipn1 - ipn2;
        }
    }
}

