/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.ImageLoader;
import com.iscobol.rts.BMPImage;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class IsguiUtility
implements ImageObserver {
    public static final int IMG_TYPE_UNKNOWN = 0;
    public static final int IMG_TYPE_BMP = 1;
    public static final int IMG_TYPE_JAVA = 2;
    public static final int S_FIT_FULL = 0;
    public static final int S_FIT_ASPECT = 1;
    public static final int S_FIT_WIDTH = 2;
    public static final int S_FIT_HEIGHT = 3;
    public static final int S_NO_FIT = 4;
    public static final int A_LEFT_BOTTOM = 1;
    public static final int A_CENTER_BOTTOM = 2;
    public static final int A_RIGHT_BOTTOM = 3;
    public static final int A_LEFT = 4;
    public static final int A_CENTER = 5;
    public static final int A_RIGHT = 6;
    public static final int A_LEFT_TOP = 7;
    public static final int A_CENTER_TOP = 8;
    public static final int A_RIGHT_TOP = 9;
    private transient boolean fullLoad;
    private transient boolean wrongFormat;
    private static final ImageLoader externalLoader;
    private static final int defaultFontSize = 12;

    public static Image createImage(byte[] imgStream, int[] type, boolean wait) {
        return IsguiUtility.createImage(imgStream, type, wait, true, 1);
    }

    public static Image createImage(byte[] imgStream, int[] type, boolean wait, boolean lightGrayIsTransparent) {
        return IsguiUtility.createImage(imgStream, type, wait, lightGrayIsTransparent, 1);
    }

    public static Image createImage(byte[] imgStream, int[] type, boolean wait, boolean lightGrayIsTransparent, int loadMethod) {
        Image Return2 = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (imgStream != null) {
            ByteArrayInputStream bais = null;
            switch (type[0]) {
                case 0: {
                    bais = new ByteArrayInputStream(imgStream);
                    Return2 = BMPImage.createImage(bais, lightGrayIsTransparent);
                    if (Return2 == null) {
                        type[0] = 2;
                        Return2 = tk.createImage(imgStream);
                        break;
                    }
                    type[0] = 1;
                    break;
                }
                case 1: {
                    bais = new ByteArrayInputStream(imgStream);
                    Return2 = BMPImage.createImage(bais, lightGrayIsTransparent);
                    break;
                }
                case 2: {
                    Return2 = tk.createImage(imgStream);
                }
            }
            if (Return2 != null && wait) {
                boolean error = IsguiUtility.prepareImage(Return2);
                if (error) {
                    if (loadMethod == 2) {
                        if (bais == null) {
                            bais = new ByteArrayInputStream(imgStream);
                        } else {
                            bais.reset();
                        }
                        try {
                            Return2 = BMPDecoder.readImage(bais);
                        }
                        catch (IOException e) {
                            Return2 = null;
                        }
                        if (Return2 != null) {
                            error = IsguiUtility.prepareImage(Return2);
                        }
                    }
                    if (error && externalLoader != null) {
                        if (bais == null) {
                            bais = new ByteArrayInputStream(imgStream);
                        } else {
                            bais.reset();
                        }
                        try {
                            Return2 = externalLoader.loadImage(bais);
                        }
                        catch (Exception e) {
                            Return2 = null;
                        }
                        if (Return2 == null) {
                            List icons;
                            bais.reset();
                            try {
                                icons = externalLoader.loadIcons(bais);
                            }
                            catch (Exception e) {
                                icons = null;
                            }
                            if (icons != null && !icons.isEmpty()) {
                                Return2 = (Image)icons.get(0);
                            }
                        }
                        if (Return2 != null) {
                            error = IsguiUtility.prepareImage(Return2);
                        }
                    }
                }
                if (error) {
                    Return2 = null;
                }
            }
        }
        return Return2;
    }

    public static Image getImage(int viewWidth, int viewHeight, Image src, int strip) {
        Image Return2;
        if (src != null) {
            int srcWidth = src.getWidth(null);
            int srcHeight = src.getHeight(null);
            if (viewWidth <= 0 || viewWidth > srcWidth) {
                viewWidth = srcWidth;
            }
            if (viewHeight <= 0 || viewHeight > srcHeight) {
                viewHeight = srcHeight;
            }
            if (viewWidth != srcWidth || viewHeight != srcHeight) {
                boolean error;
                int startoffs = (strip - 1) * viewWidth;
                if (startoffs >= srcWidth) {
                    return null;
                }
                Toolkit tk = Toolkit.getDefaultToolkit();
                CropImageFilter filter = new CropImageFilter(startoffs, 0, viewWidth, viewHeight);
                Return2 = tk.createImage(new FilteredImageSource(src.getSource(), filter));
                if (Return2 != null && (error = IsguiUtility.prepareImage(Return2))) {
                    Return2 = null;
                }
            } else {
                Return2 = src;
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    public static Image makeColorTransparent(Image im, final int colorRgb) {
        RGBImageFilter filter = new RGBImageFilter(){
            final boolean colorAt00;
            public int markerRGB;
            {
                this.colorAt00 = colorRgb == 0x1000000;
                this.markerRGB = colorRgb | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if (x == 0 && y == 0 && this.colorAt00) {
                    this.markerRGB = rgb;
                }
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareImage(Image img) {
        IsguiUtility observer;
        Toolkit tk = Toolkit.getDefaultToolkit();
        IsguiUtility isguiUtility = observer = new IsguiUtility();
        synchronized (isguiUtility) {
            while (!tk.prepareImage(img, -1, -1, observer) && !observer.fullLoad) {
                try {
                    observer.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return observer.wrongFormat;
    }

    public static BufferedImage rotate(Image img, double theta) {
        float maxy;
        float maxx;
        int iw = img.getWidth(null);
        int ih = img.getHeight(null);
        AffineTransform at = new AffineTransform();
        at.rotate(theta);
        Point2D.Float pnt = new Point2D.Float(0.0f, 0.0f);
        at.transform(pnt, pnt);
        float minx = maxx = pnt.x;
        float miny = maxy = pnt.x;
        pnt.setLocation(iw, 0.0f);
        at.transform(pnt, pnt);
        if (pnt.x < minx) {
            minx = pnt.x;
        }
        if (pnt.y < miny) {
            miny = pnt.y;
        }
        if (pnt.x > maxx) {
            maxx = pnt.x;
        }
        if (pnt.y > maxy) {
            maxy = pnt.y;
        }
        pnt.setLocation(0.0f, ih);
        at.transform(pnt, pnt);
        if (pnt.x < minx) {
            minx = pnt.x;
        }
        if (pnt.y < miny) {
            miny = pnt.y;
        }
        if (pnt.x > maxx) {
            maxx = pnt.x;
        }
        if (pnt.y > maxy) {
            maxy = pnt.y;
        }
        pnt.setLocation(iw, ih);
        at.transform(pnt, pnt);
        if (pnt.x < minx) {
            minx = pnt.x;
        }
        if (pnt.y < miny) {
            miny = pnt.y;
        }
        if (pnt.x > maxx) {
            maxx = pnt.x;
        }
        if (pnt.y > maxy) {
            maxy = pnt.y;
        }
        iw = (int)(maxx - minx + 1.0f);
        ih = (int)(maxy - miny + 1.0f);
        BufferedImage Return2 = new BufferedImage(iw, ih, 2);
        Graphics2D g2d = Return2.createGraphics();
        g2d.translate(-minx, -miny);
        g2d.rotate(theta);
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return Return2;
    }

    public static BufferedImage scale(Image img, double w, double h, int scaleType, int align) {
        return IsguiUtility.scale(img, w, h, scaleType, align, false);
    }

    public static BufferedImage scale(Image img, double targetWidth, double targetHeight, int scaleType, int align, boolean higherQuality) {
        double ratio = 0.5;
        if (higherQuality) {
            double w = img.getWidth(null);
            double h = img.getHeight(null);
            Image ret = img;
            do {
                if (w > targetWidth) {
                    if ((w *= ratio) < targetWidth) {
                        w = targetWidth;
                    }
                } else {
                    w = targetWidth;
                }
                if (h > targetHeight) {
                    if ((h *= ratio) < targetHeight) {
                        h = targetHeight;
                    }
                } else {
                    h = targetHeight;
                }
                ret = IsguiUtility.scaleImpl(ret, w, h, scaleType, align);
            } while (w != targetWidth || h != targetHeight);
            return (BufferedImage)ret;
        }
        return IsguiUtility.scaleImpl(img, targetWidth, targetHeight, scaleType, align);
    }

    private static BufferedImage scaleImpl(Image img, double w, double h, int scaleType, int align) {
        int y;
        int x;
        double iw = img.getWidth(null);
        double ih = img.getHeight(null);
        double sx = 1.0;
        double sy = 1.0;
        switch (scaleType) {
            default: {
                sx = w / iw;
                sy = h / ih;
                break;
            }
            case 1: {
                sx = w / iw;
                sy = h / ih;
                if (sx < sy) {
                    sy = sx;
                    break;
                }
                sx = sy;
                break;
            }
            case 2: {
                sy = sx = w / iw;
                break;
            }
            case 3: {
                sy = sx = h / ih;
            }
            case 4: 
        }
        int woo = sx != 1.0 ? (int)(sx * iw) : (int)iw;
        int hoo = sy != 1.0 ? (int)(sy * ih) : (int)ih;
        if (woo < 1) {
            woo = 1;
        }
        if (hoo < 1) {
            hoo = 1;
        }
        BufferedImage newImg = new BufferedImage(woo, hoo, 2);
        Graphics2D g2d = newImg.createGraphics();
        if (sx != 1.0 || sy != 1.0) {
            g2d.scale(sx, sy);
        }
        HashMap<RenderingHints.Key, Object> rh = new HashMap<RenderingHints.Key, Object>();
        rh.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHints(rh);
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        iw = newImg.getWidth(null);
        ih = newImg.getHeight(null);
        switch (align) {
            case 1: {
                x = 0;
                y = (int)(h - ih);
                break;
            }
            case 2: {
                x = (int)(w - iw) / 2;
                y = (int)(h - ih);
                break;
            }
            case 3: {
                x = (int)(w - iw);
                y = (int)(h - ih);
                break;
            }
            case 4: {
                x = 0;
                y = (int)(h - ih) / 2;
                break;
            }
            case 5: {
                x = (int)(w - iw) / 2;
                y = (int)(h - ih) / 2;
                break;
            }
            case 6: {
                x = (int)(w - iw);
                y = (int)(h - ih) / 2;
                break;
            }
            default: {
                x = 0;
                y = 0;
                break;
            }
            case 8: {
                x = (int)(w - iw) / 2;
                y = 0;
                break;
            }
            case 9: {
                x = (int)(w - iw);
                y = 0;
            }
        }
        BufferedImage Return2 = new BufferedImage((int)w, (int)h, 2);
        g2d = Return2.createGraphics();
        g2d.drawImage((Image)newImg, x, y, null);
        g2d.dispose();
        return Return2;
    }

    public static BufferedImage align(Image img, double width, double height, int align) {
        int y;
        int x;
        double iw = img.getWidth(null);
        double ih = img.getHeight(null);
        switch (align) {
            case 1: {
                x = 0;
                y = (int)(height - ih);
                break;
            }
            case 2: {
                x = (int)(width - iw) / 2;
                y = (int)(height - ih);
                break;
            }
            case 3: {
                x = (int)(width - iw);
                y = (int)(height - ih);
                break;
            }
            case 4: {
                x = 0;
                y = (int)(height - ih) / 2;
                break;
            }
            case 5: {
                x = (int)(width - iw) / 2;
                y = (int)(height - ih) / 2;
                break;
            }
            case 6: {
                x = (int)(width - iw);
                y = (int)(height - ih) / 2;
                break;
            }
            default: {
                x = 0;
                y = 0;
                break;
            }
            case 8: {
                x = (int)(width - iw) / 2;
                y = 0;
                break;
            }
            case 9: {
                x = (int)(width - iw);
                y = 0;
            }
        }
        BufferedImage bimg = new BufferedImage((int)width, (int)height, 2);
        Graphics2D g2d = bimg.createGraphics();
        g2d.drawImage(img, x, y, null);
        g2d.dispose();
        return bimg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        int rc = infoflags & 0xF0;
        if (rc != 0) {
            if (rc != 32 && rc != 16) {
                this.wrongFormat = true;
            }
            IsguiUtility isguiUtility = this;
            synchronized (isguiUtility) {
                this.fullLoad = true;
                this.notifyAll();
            }
        }
        return rc == 0;
    }

    public static String createMaskFromDatePattern(String datePattern, char maskChar, boolean escape) {
        String symbols = "GyMdkHmsSEDFwWahKzZ";
        StringBuffer mask = new StringBuffer();
        for (int i = 0; i < datePattern.length(); ++i) {
            char ch = datePattern.charAt(i);
            boolean symbolFound = false;
            for (int n = 0; n < symbols.length(); ++n) {
                if (symbols.charAt(n) != ch) continue;
                mask.append(maskChar);
                symbolFound = true;
                break;
            }
            if (symbolFound) continue;
            if (escape) {
                mask.append('\'');
            }
            mask.append(ch);
        }
        return mask.toString();
    }

    public static String getDefaultShortDateFormat() {
        DateFormat df = DateFormat.getDateInstance(3);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        return "dd/MM/yyyy";
    }

    public static String getDefaultLongDateFormat() {
        DateFormat df = DateFormat.getDateInstance(0);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        return "EEEE dd MMMM yyyy";
    }

    public static String getDefaultCenturyDateFormat() {
        DateFormat df = DateFormat.getDateInstance(3);
        if (df instanceof SimpleDateFormat) {
            String ptn = ((SimpleDateFormat)df).toPattern();
            return ptn.replaceAll("\\byy\\b", "yyyy").replaceAll("\\by\\b", "yyyy");
        }
        return "dd/MM/yyyy";
    }

    public static String getDefaultTimeDateFormat() {
        DateFormat df = DateFormat.getTimeInstance(3);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        return "HH:mm:ss";
    }

    public static Object[] parseFontString(String str) {
        String fontName = str;
        int fontStyle = 0;
        float fontSize = 12.0f;
        int i = str.indexOf(45);
        if (i >= 0) {
            fontName = str.substring(0, i);
            if (i < str.length()) {
                if ((str = str.substring(i + 1).toLowerCase()).startsWith("bolditalic")) {
                    fontStyle = 3;
                    if (str.length() > 11) {
                        str = str.substring(11);
                    }
                } else if (str.startsWith("bold")) {
                    fontStyle = 1;
                    if (str.length() > 5) {
                        str = str.substring(5);
                    }
                } else if (str.startsWith("italic")) {
                    fontStyle = 2;
                    if (str.length() > 7) {
                        str = str.substring(7);
                    }
                }
                if (str.length() > 0) {
                    try {
                        fontSize = Float.valueOf(str).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (fontSize == 0.0f) {
                    fontSize = 12.0f;
                }
            }
        }
        return new Object[]{fontName, fontStyle, Float.valueOf(fontSize)};
    }

    public static KeyListener keyPressedAdapter(final Consumer<KeyEvent> c) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                c.accept(e);
            }
        };
    }

    public static MouseListener mouseClickedAdapter(final Consumer<MouseEvent> c) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                c.accept(e);
            }
        };
    }

    public static MouseListener mousePressedAdapter(final Consumer<MouseEvent> c) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                c.accept(e);
            }
        };
    }

    public static MouseListener mouseAdapter(Consumer<MouseEvent> pressed, Consumer<MouseEvent> released, Consumer<MouseEvent> clicked) {
        return IsguiUtility.mouseAdapter(null, null, pressed, released, clicked);
    }

    public static MouseListener mouseAdapter(final Consumer<MouseEvent> entered, final Consumer<MouseEvent> exited, final Consumer<MouseEvent> pressed, final Consumer<MouseEvent> released, final Consumer<MouseEvent> clicked) {
        return new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (pressed != null) {
                    pressed.accept(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (clicked != null) {
                    clicked.accept(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (released != null) {
                    released.accept(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (entered != null) {
                    entered.accept(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (exited != null) {
                    exited.accept(e);
                }
            }
        };
    }

    public static ComponentListener componentResizedAdapter(final Consumer<ComponentEvent> c) {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                c.accept(e);
            }
        };
    }

    public static ComponentListener componentMovedAdapter(final Consumer<ComponentEvent> c) {
        return new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                c.accept(e);
            }
        };
    }

    public static WindowListener windowClosedAdapter(final Consumer<WindowEvent> c) {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                c.accept(e);
            }
        };
    }

    public static WindowListener windowClosingAdapter(final Consumer<WindowEvent> c) {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                c.accept(e);
            }
        };
    }

    public static FocusListener focusGainedAdapter(final Consumer<FocusEvent> c) {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                c.accept(e);
            }
        };
    }

    public static FocusListener focusLostAdapter(final Consumer<FocusEvent> c) {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                c.accept(e);
            }
        };
    }

    public static FocusListener focusAdapter(final Consumer<FocusEvent> gained, final Consumer<FocusEvent> lost) {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (lost != null) {
                    lost.accept(e);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (gained != null) {
                    gained.accept(e);
                }
            }
        };
    }

    public static BufferedImage takeScreenshot(JComponent component) {
        return IsguiUtility.takeScreenshot(component, false);
    }

    public static BufferedImage takeScreenshot(final JComponent component, boolean transparent) {
        JFrame f = new JFrame();
        f.setLayout(null);
        f.enableInputMethods(false);
        boolean opaqueValue = component.isOpaque();
        component.setOpaque(!transparent);
        Canvas comp = new Canvas(){

            @Override
            public void paint(Graphics g) {
                component.paint(g);
            }
        };
        comp.setSize(component.getSize());
        f.getContentPane().add(comp);
        f.pack();
        BufferedImage image = new BufferedImage(comp.getWidth(), comp.getHeight(), transparent ? 2 : 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setClip(comp.getBounds());
        comp.paint(g2d);
        g2d.dispose();
        component.setOpaque(opaqueValue);
        f.dispose();
        return image;
    }

    static {
        ImageLoader il;
        try {
            il = (ImageLoader)Class.forName("com.iscobol.misc.image.Image4JLoader").newInstance();
        }
        catch (Throwable t) {
            il = null;
        }
        externalLoader = il;
    }

    private static class BMPDecoder {
        private InputStream is;
        private int curPos;
        private int bitmapOffset;
        private int width;
        private int height;
        private short bitsPerPixel;
        private int compression;
        private int actualSizeOfBitmap;
        private int scanLineSize;
        private int actualColorsUsed;
        private byte[] r;
        private byte[] g;
        private byte[] b;
        private int noOfEntries;
        private byte[] byteData;
        private int[] intData;
        private boolean topDown;

        private BMPDecoder() {
        }

        private int readInt() throws IOException {
            int b1 = this.is.read();
            int b2 = this.is.read();
            int b3 = this.is.read();
            int b4 = this.is.read();
            this.curPos += 4;
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }

        private short readShort() throws IOException {
            int b1 = this.is.read();
            int b2 = this.is.read();
            this.curPos += 2;
            return (short)((b2 << 8) + b1);
        }

        private void getFileHeader() throws IOException {
            int fileType = 19778;
            fileType = this.readShort();
            if (fileType != 19778) {
                throw new IOException("Not a BMP file");
            }
            this.readInt();
            this.readShort();
            this.readShort();
            this.bitmapOffset = this.readInt();
        }

        private void getBitmapHeader() throws IOException {
            this.readInt();
            this.width = this.readInt();
            this.height = this.readInt();
            this.readShort();
            this.bitsPerPixel = this.readShort();
            this.compression = this.readInt();
            this.readInt();
            this.readInt();
            this.readInt();
            int colorsUsed = this.readInt();
            this.readInt();
            if (this.bitsPerPixel == 24) {
                colorsUsed = 0;
            }
            boolean bl = this.topDown = this.height < 0;
            if (this.topDown) {
                this.height = -this.height;
            }
            this.scanLineSize = (this.width * this.bitsPerPixel + 31) / 32 * 4;
            this.actualSizeOfBitmap = this.scanLineSize * this.height;
            this.actualColorsUsed = colorsUsed != 0 ? colorsUsed : (this.bitsPerPixel < 16 ? 1 << this.bitsPerPixel : 0);
        }

        private void getPalette() throws IOException {
            this.noOfEntries = this.actualColorsUsed;
            if (this.noOfEntries > 0) {
                this.r = new byte[this.noOfEntries];
                this.g = new byte[this.noOfEntries];
                this.b = new byte[this.noOfEntries];
                for (int i = 0; i < this.noOfEntries; ++i) {
                    this.b[i] = (byte)this.is.read();
                    this.g[i] = (byte)this.is.read();
                    this.r[i] = (byte)this.is.read();
                    this.is.read();
                    this.curPos += 4;
                }
            }
        }

        private void unpack(byte[] rawData, int rawOffset, int bpp, byte[] byteData, int byteOffset, int w) throws IOException {
            int pixPerByte;
            int mask;
            int j = byteOffset;
            int k = rawOffset;
            switch (bpp) {
                case 1: {
                    mask = 1;
                    pixPerByte = 8;
                    break;
                }
                case 4: {
                    mask = 15;
                    pixPerByte = 2;
                    break;
                }
                case 8: {
                    mask = -1;
                    pixPerByte = 1;
                    break;
                }
                default: {
                    throw new IOException("Unsupported bits-per-pixel value: " + bpp);
                }
            }
            int i = 0;
            while (true) {
                int shift = 8 - bpp;
                for (int ii = 0; ii < pixPerByte; ++ii) {
                    byte br = rawData[k];
                    br = (byte)(br >> shift);
                    byteData[j] = (byte)(br & mask);
                    ++j;
                    if (++i == w) {
                        return;
                    }
                    shift -= bpp;
                }
                ++k;
            }
        }

        private void unpack24(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
            int j = intOffset;
            int k = rawOffset;
            int mask = 255;
            for (int i = 0; i < w; ++i) {
                int b0 = rawData[k++] & mask;
                int b1 = (rawData[k++] & mask) << 8;
                int b2 = (rawData[k++] & mask) << 16;
                intData[j] = 0xFF000000 | b0 | b1 | b2;
                ++j;
            }
        }

        private void unpack32(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
            int j = intOffset;
            int k = rawOffset;
            int mask = 255;
            for (int i = 0; i < w; ++i) {
                int b0 = rawData[k++] & mask;
                int b1 = (rawData[k++] & mask) << 8;
                int b2 = (rawData[k++] & mask) << 16;
                ++k;
                intData[j] = 0xFF000000 | b0 | b1 | b2;
                ++j;
            }
        }

        private void getPixelData() throws IOException {
            long skip = this.bitmapOffset - this.curPos;
            if (skip > 0L) {
                this.is.skip(skip);
                this.curPos = (int)((long)this.curPos + skip);
            }
            int len = this.scanLineSize;
            if (this.bitsPerPixel > 8) {
                this.intData = new int[this.width * this.height];
            } else {
                this.byteData = new byte[this.width * this.height];
            }
            byte[] rawData = new byte[this.actualSizeOfBitmap];
            int rawOffset = 0;
            int offset = (this.height - 1) * this.width;
            for (int i = this.height - 1; i >= 0; --i) {
                int n = this.is.read(rawData, rawOffset, len);
                if (n < len) {
                    throw new IOException("Scan line ended prematurely after " + n + " bytes");
                }
                if (this.bitsPerPixel == 24) {
                    this.unpack24(rawData, rawOffset, this.intData, offset, this.width);
                } else if (this.bitsPerPixel == 32) {
                    this.unpack32(rawData, rawOffset, this.intData, offset, this.width);
                } else {
                    this.unpack(rawData, rawOffset, this.bitsPerPixel, this.byteData, offset, this.width);
                }
                rawOffset += len;
                offset -= this.width;
            }
        }

        void read(InputStream is) throws IOException {
            this.is = is;
            this.getFileHeader();
            this.getBitmapHeader();
            if (this.compression != 0) {
                throw new IOException("Compression not supported");
            }
            this.getPalette();
            this.getPixelData();
        }

        MemoryImageSource makeImageSource() {
            ColorModel cm = this.noOfEntries > 0 && this.bitsPerPixel != 24 ? new IndexColorModel((int)this.bitsPerPixel, this.noOfEntries, this.r, this.g, this.b) : ColorModel.getRGBdefault();
            MemoryImageSource mis = this.bitsPerPixel > 8 ? new MemoryImageSource(this.width, this.height, cm, this.intData, 0, this.width) : new MemoryImageSource(this.width, this.height, cm, this.byteData, 0, this.width);
            return mis;
        }

        static Image readImage(InputStream is) throws IOException {
            BMPDecoder dec = new BMPDecoder();
            dec.read(is);
            MemoryImageSource src = dec.makeImageSource();
            return Toolkit.getDefaultToolkit().createImage(src);
        }
    }
}

