/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.isdb;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.commandline.CommandLineDebugger;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;

public class Isdb
extends CommandLineDebugger {
    private static final String PROMPT = "isdb> ";

    public Isdb(DebuggerInvoker invoker) {
        super(invoker);
    }

    @Override
    public String getPrompt() {
        return PROMPT;
    }

    @Override
    public void version(PrintStream ps, ResourceBundle rb) {
        String infolic = Config.getProperty(".licinfo", "Missing license!");
        String exdate = infolic.substring(infolic.length() - 8).equals("99991231") ? "None" : infolic.substring(infolic.length() - 8);
        String[] licid = infolic.substring(0, infolic.length() - 8).split("(##)");
        String licenseId = licid.length > 1 ? licid[1] : rb.getString("message.fragment.missing.license.id");
        String javaInfo = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String s = MessageFormat.format(rb.getString("message.version"), RuntimeProperties.getProductDisplayName() + "_" + RuntimeProperties.getFullVersionNumber(), licid[0], licenseId, exdate, RuntimeProperties.getProductCopyright(), javaInfo, System.getProperty("java.home"));
        ps.println(s);
    }

    @Override
    public boolean isCobolProgram(String className, String[] argv) throws ClassNotFoundException {
        try {
            return this.isIsCobolClass(DebugUtilities.classForNameNoInitialize(className));
        }
        catch (ClassNotFoundException ex) {
            if (this.isIsCobolClass(Config.getProperty("iscobol.code_prefix", ""), className)) {
                return true;
            }
            String codePrefixProp = "-Discobol.code_prefix=";
            String confProp = "-Discobol.conf=";
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].startsWith("-Discobol.code_prefix=")) {
                    String codePrefix = argv[i].substring("-Discobol.code_prefix=".length());
                    return this.isIsCobolClass(codePrefix, className);
                }
                if (!argv[i].startsWith("-Discobol.conf=")) continue;
                Properties props = new Properties();
                try {
                    RtsUtil.loadPropertiesWithImport(props, argv[i].substring("-Discobol.conf=".length()));
                    String codePrefix = props.getProperty("iscobol.code_prefix");
                    if (codePrefix == null) continue;
                    return this.isIsCobolClass(codePrefix, className);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    private boolean isIsCobolClass(String codePrefix, String className) throws ClassNotFoundException {
        CallLoader callLoader = CallLoader.getInstance(codePrefix);
        if (callLoader != null) {
            return this.isIsCobolClass(callLoader.loadClass(className));
        }
        return false;
    }

    boolean isIsCobolClass(Class cls) {
        try {
            Class<?> iscobolClass = Class.forName("com.iscobol.rts.IscobolClass", false, Isdb.class.getClassLoader());
            return iscobolClass.isAssignableFrom(cls);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Override
    public int launchCobolProgram(String[] argv) {
        return this.invoker.launchIsCobolProgram(argv);
    }

    @Override
    public void setPrefix() {
    }

    @Override
    public boolean isDebuggable(String className) throws ClassNotFoundException {
        Class cls = DebugUtilities.classForNameNoInitialize(className);
        try {
            Class<?> debuggable = Class.forName("com.iscobol.debugger.IscobolDebugger", false, Isdb.class.getClassLoader());
            return debuggable.isAssignableFrom(cls);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Override
    public int processGetInfo(boolean remote) {
        DebugResponse resp = remote ? this.invoker.getResponse() : this.invoker.processCommand(new RunCommand());
        int rc = resp.getReturnCode();
        if (rc != 103) {
            ThreadObject currThread = resp.getThreads()[resp.getCurThreadIdx()];
            ParagraphObject[] parStack = currThread.getParStack();
            String className = parStack[parStack.length - 1].getProgName();
            LocalDebugInfo dInfo = this.invoker.getInfo(className, false, false);
            this.invoker.setInfo(dInfo);
            if (dInfo != null) {
                String currFile = dInfo.getSourcefile();
                this.invoker.setCurrFile(currFile);
            }
            this.printMessage(this.invoker.showLine(resp.getLine(), resp.getLastFile()), true);
        }
        return rc;
    }

    public static void main(String[] args) throws Exception {
        Isdb isdb = new Isdb(new DebuggerInvoker());
        isdb.init(args);
    }

    @Override
    public String getName() {
        return "isdb";
    }

    @Override
    public String getRemoteOptionName() {
        return "-r";
    }
}

