/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.gui.client.swing.treetable.AbstractTreeTableModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class VectorModel
extends AbstractTreeTableModel {
    protected Vector vector;
    protected Map cache = new HashMap();
    protected Class[] columnTypes;
    protected String[] columnNames;
    protected boolean[] editableColumn;
    protected GraphDebugger graphDebug;

    public VectorModel(Class[] columnTypes, String[] columnNames, GraphDebugger graphDebug) {
        this(columnTypes, columnNames, new int[0], graphDebug);
    }

    public VectorModel(Class[] columnTypes, String[] columnNames, int editableColumn, GraphDebugger graphDebug) {
        this(columnTypes, columnNames, new int[]{editableColumn}, graphDebug);
    }

    public VectorModel(Class[] columnTypes, String[] columnNames, int[] editableColumn, GraphDebugger graphDebug) {
        super(new Vector());
        this.vector = (Vector)this.getRoot();
        this.columnTypes = columnTypes;
        this.columnNames = columnNames;
        this.editableColumn = new boolean[columnTypes.length];
        for (int i = 0; i < editableColumn.length; ++i) {
            this.editableColumn[editableColumn[i]] = true;
        }
        this.graphDebug = graphDebug;
    }

    public void setItems(Object[] items) {
        this.vector.clear();
        this.cache.clear();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.vector.addElement(items[i]);
            }
        }
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return node != this.vector && column < this.editableColumn.length && this.editableColumn[column] && !this.graphDebug.isProcessing();
    }

    @Override
    public Class getColumnClass(int column) {
        if (column >= 0 && column < this.columnTypes.length) {
            return this.columnTypes[column];
        }
        return Object.class;
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getChildren(parent).length;
    }

    public Object[] getChildren(Object parent) {
        Object[] children = (Object[])this.cache.get(parent);
        if (children == null) {
            children = parent == this.vector ? this.vector.toArray() : new Object[]{};
            this.cache.put(parent, children);
        }
        return children;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getChildren(parent)[index];
    }

    @Override
    public String getColumnName(int column) {
        if (column >= 0 && column < this.columnNames.length) {
            return this.columnNames[column];
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    public Object elementAt(int index) {
        return this.vector.elementAt(index);
    }

    public int size() {
        return this.vector.size();
    }

    public int indexOf(Object elem) {
        return this.vector.indexOf(elem);
    }

    public Object[] toArray() {
        return this.vector.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.vector.toArray(array);
    }
}

