/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class VariableNode
implements TreeNode {
    private String name;
    private String hexDump;
    private String textValue;
    private int offset;
    private int length;
    private String className;
    private VariableNode parent;
    private boolean hasChildren;
    private Vector children = new Vector();

    public VariableNode(String name, String className, String hexDump, VariableNode parent) {
        this(name, className, hexDump, 0, 0, parent);
    }

    public VariableNode(String name, String className, String hexDump, int offset, int length, VariableNode parent) {
        this.name = name;
        this.className = className;
        this.init(hexDump, offset, length);
        this.parent = parent;
        if (this.parent != null) {
            this.parent.children.addElement(this);
        }
    }

    public void init(String hexDump, int offset, int length) {
        this.hexDump = hexDump;
        this.offset = offset;
        this.length = length;
        if (this.hexDump != null) {
            int idx = hexDump.indexOf("\u0001");
            if (idx >= 0) {
                if (idx == this.hexDump.length() - 1) {
                    this.textValue = "";
                } else {
                    StringBuffer sb = new StringBuffer();
                    char[] c = this.hexDump.substring(idx + 1).toCharArray();
                    for (int i = 0; i < c.length; ++i) {
                        char ci = c[i];
                        if (ci < ' ') {
                            sb.append(' ');
                            continue;
                        }
                        sb.append(c[i]);
                    }
                    this.textValue = sb.toString();
                }
                this.hexDump = this.hexDump.substring(0, idx);
            } else {
                this.textValue = this.hexDump;
                this.hexDump = "<n/a>";
            }
        }
    }

    public Object[] getPath() {
        ArrayList<VariableNode> list = new ArrayList<VariableNode>();
        VariableNode vn = this;
        while (vn != null) {
            list.add(0, vn);
            vn = vn.parent;
        }
        return list.toArray();
    }

    private int indexOf(VariableNode vn) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.elementAt(i) != vn) continue;
            return i;
        }
        return -1;
    }

    private String getPathStr() {
        StringBuffer buf = new StringBuffer();
        VariableNode vn = this;
        while (vn != null) {
            if (buf.length() > 0) {
                buf.insert(0, "/");
            }
            String name = vn.name;
            if (vn.parent != null) {
                name = name + "#" + vn.parent.indexOf(vn);
            }
            buf.insert(0, name);
            vn = vn.parent;
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableNode)) {
            return false;
        }
        return this.getPathStr().equals(((VariableNode)o).getPathStr());
    }

    public int hashCode() {
        return this.getPathStr().hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void addChild(TreeNode child) {
        this.children.add(child);
        ((VariableNode)child).parent = this;
    }

    public void removeAllChildren() {
        this.children.removeAllElements();
    }

    public void removeChildAt(int index) {
        this.children.removeElementAt(index);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (VariableNode)this.children.elementAt(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return !this.hasChildren && this.children.size() == 0;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHexDump() {
        return this.hexDump;
    }

    public void setHexDump(String hexDump) {
        this.hexDump = hexDump;
        this.textValue = null;
    }

    public String getTextValue() {
        if (this.textValue == null && this.hexDump != null) {
            this.textValue = VariableNode.getTextValue(this.hexDump);
        }
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setChildren(Vector children) {
        this.children = children;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    private static String getTextValue(String hexDump) {
        StringBuffer buf = new StringBuffer();
        if (hexDump != null && hexDump.length() > 0) {
            for (int i = 0; i < hexDump.length(); i += 2) {
                int c = Integer.parseInt(hexDump.substring(i, i + 2), 16);
                if (VariableNode.isPrintableChar(c)) {
                    buf.append((char)c);
                    continue;
                }
                buf.append('.');
            }
        }
        return buf.toString();
    }

    private static boolean isPrintableChar(int c) {
        return c >= 32 && c <= 126;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getClassName() {
        return this.className;
    }
}

