/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MonitorDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField variableTxt;
    private JTextField moduleTxt;
    private JTextField propertyTxt;
    private JComboBox conditionCmb;
    private JTextField valueTxt;
    private JCheckBox envChk;
    private JCheckBox hexChk;
    private JCheckBox enableChk;
    private JButton ok;
    private JButton close;

    public MonitorDialog(JFrame parent, String title, String defname, String modulename, String propname, boolean debugIsRunning, boolean dataAsHex, boolean defaultMonEnState) {
        this(parent, title, debugIsRunning, dataAsHex, defaultMonEnState, false);
        if (defname != null) {
            this.variableTxt.setText(defname);
            this.variableTxt.select(0, defname.length());
        }
        if (modulename != null) {
            this.moduleTxt.setText(modulename);
        }
        if (this.propertyTxt != null && propname != null) {
            this.propertyTxt.setText(propname);
        }
    }

    public MonitorDialog(JFrame parent, String title, Watch watch, boolean debugIsRunning, boolean dataAsHex, boolean defaultMonEnState) {
        this(parent, title, debugIsRunning, dataAsHex, defaultMonEnState, watch != null);
        if (watch != null) {
            Condition cond;
            String envProperty = watch.getEnvProperty();
            String name = envProperty != null ? envProperty : watch.getFullName();
            this.variableTxt.setText(name);
            this.variableTxt.setEnabled(false);
            this.enableChk.setSelected(watch.isEnabled());
            this.envChk.setEnabled(false);
            if (envProperty != null) {
                this.envChk.setSelected(true);
                this.hexChk.setSelected(false);
                this.hexChk.setEnabled(false);
            } else if (watch.isHexadecimal()) {
                this.envChk.setSelected(false);
                this.hexChk.setSelected(true);
            }
            if (watch != null && watch.getClassname() != null && watch.getClassname().length() > 0) {
                this.moduleTxt.setText(watch.getClassname());
            }
            if (this.propertyTxt != null) {
                if (watch.getPropName() != null) {
                    this.propertyTxt.setText(watch.getPropName());
                }
                this.propertyTxt.setEnabled(false);
            }
            if ((cond = watch.getCondition()) != null) {
                this.conditionCmb.setSelectedItem(cond.getTypeStr());
                if (!(cond.getValue() == null || cond.getTypeStr() != null && cond.getTypeStr().equals("always"))) {
                    this.valueTxt.setText(cond.getValueStr());
                    this.valueTxt.setEnabled(true);
                }
            }
        }
    }

    private MonitorDialog(JFrame parent, String title, boolean debugIsRunning, boolean dataAsHex, boolean defaultMonEnState, boolean hasWatch) {
        super(parent, title, true);
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.enableChk = new JCheckBox("Enabled");
        this.enableChk.setSelected(defaultMonEnState);
        Dimension d = layout.getPreferredSize(this.enableChk);
        this.enableChk.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(this.enableChk);
        this.envChk = new JCheckBox("Environment name");
        d = layout.getPreferredSize(this.envChk);
        this.envChk.setBounds(LMResize.getLeft(this.enableChk), LMResize.getBottom(this.enableChk) + 15, d.width, d.height);
        this.getContentPane().add(this.envChk);
        this.hexChk = new JCheckBox("Hexadecimal");
        this.hexChk.setSelected(dataAsHex);
        d = layout.getPreferredSize(this.hexChk);
        this.hexChk.setBounds(LMResize.getRight(this.envChk) + 15, LMResize.getTop(this.envChk), d.width, d.height);
        this.getContentPane().add(this.hexChk);
        if (!hasWatch) {
            this.envChk.addActionListener(e -> {
                if (this.propertyTxt != null) {
                    this.propertyTxt.setEnabled(!this.envChk.isSelected());
                }
                this.hexChk.setEnabled(!this.envChk.isSelected());
                if (this.envChk.isSelected()) {
                    this.hexChk.setSelected(false);
                }
            });
            this.hexChk.addActionListener(e -> {
                if (this.propertyTxt != null) {
                    this.propertyTxt.setEnabled(!this.hexChk.isSelected());
                }
                this.envChk.setEnabled(!this.hexChk.isSelected());
                if (this.hexChk.isSelected()) {
                    this.envChk.setSelected(false);
                }
            });
        }
        JLabel variableLbl = new JLabel("Variable name:");
        d = layout.getPreferredSize(variableLbl);
        variableLbl.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(this.envChk) + 15, d.width, d.height);
        this.getContentPane().add(variableLbl);
        JLabel moduleLbl = new JLabel("Method/Program:");
        d = layout.getPreferredSize(moduleLbl);
        moduleLbl.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(variableLbl) + 15, d.width, d.height);
        this.getContentPane().add(moduleLbl);
        JLabel propertyLbl = new JLabel("Property name:");
        d = layout.getPreferredSize(propertyLbl);
        propertyLbl.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(moduleLbl) + 15, d.width, d.height);
        this.getContentPane().add(propertyLbl);
        JLabel conditionLbl = new JLabel("Notify change when");
        d = layout.getPreferredSize(conditionLbl);
        conditionLbl.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(propertyLbl) + 15, d.width, d.height);
        this.getContentPane().add(conditionLbl);
        JLabel valueLbl = new JLabel("Value:");
        d = layout.getPreferredSize(valueLbl);
        valueLbl.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(conditionLbl) + 15, d.width, d.height);
        this.getContentPane().add(valueLbl);
        this.variableTxt = new JTextField(20);
        this.variableTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.variableTxt));
        this.variableTxt.setBounds(LMResize.getRight(conditionLbl) + 5, LMResize.getTop(variableLbl), 200, this.variableTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.variableTxt, new LMResizeData(1));
        this.moduleTxt = new JTextField();
        this.moduleTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleTxt));
        this.moduleTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(moduleLbl), 200, this.moduleTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.moduleTxt, new LMResizeData(1));
        this.propertyTxt = new JTextField();
        this.propertyTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyTxt));
        this.propertyTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(propertyLbl), 200, this.propertyTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.propertyTxt, new LMResizeData(1));
        this.conditionCmb = new JComboBox<String>(Condition.conditionStrings);
        this.conditionCmb.addItemListener(e -> {
            if (this.conditionCmb.getSelectedIndex() == 0) {
                this.valueTxt.setText("");
                this.valueTxt.setEnabled(false);
            } else {
                this.valueTxt.setEnabled(true);
            }
        });
        this.conditionCmb.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(conditionLbl), 200, this.conditionCmb.getPreferredSize().height);
        this.getContentPane().add((Component)this.conditionCmb, new LMResizeData(1));
        this.valueTxt = new JTextField();
        this.valueTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.valueTxt));
        this.valueTxt.setEnabled(false);
        this.valueTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(valueLbl), 200, this.valueTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.valueTxt, new LMResizeData(1));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(e -> {
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.addActionListener(e -> this.closeDialog());
        this.close.setMnemonic('c');
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.valueTxt) - d.width + 5, LMResize.getBottom(this.valueTxt) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        MonitorDialog.setFirstFocusedComponent(this.variableTxt);
        this.setDefaultButton(this.ok);
    }

    private void makeString() {
        String var = this.variableTxt.getText();
        if (var.length() > 0) {
            this.commandString = "monitor";
            this.commandString = this.enableChk.isSelected() ? this.commandString + " -e" : this.commandString + " -d";
            if (this.envChk.isSelected()) {
                this.commandString = this.commandString + " -env " + var;
            } else {
                String prop;
                if (this.moduleTxt.getText().length() > 0) {
                    this.commandString = this.commandString + " -c " + this.moduleTxt.getText();
                }
                if (this.hexChk.isSelected()) {
                    this.commandString = this.commandString + " -x";
                }
                this.commandString = this.commandString + " " + var;
                if (this.propertyTxt != null && (prop = this.propertyTxt.getText()).length() > 0) {
                    this.commandString = this.commandString + " property " + prop;
                }
            }
            this.commandString = this.commandString + " when " + this.conditionCmb.getSelectedItem() + " " + this.valueTxt.getText();
        } else {
            this.commandString = null;
        }
    }
}

