/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class InputDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JComponent[] valueCmp;
    private JLabel[] valueLbl;
    private JLabel helpLbl;
    private JCheckBox hexChk;
    private JCheckBox fullChk;
    private JButton ok;
    private JButton close;
    private String[] value;
    private boolean hex;
    private boolean full;

    public InputDialog(JFrame parent, String title, String label, String helpLabel, String initialValue, int valueLength, boolean showHexChk, boolean showFullChk) {
        this(parent, title, new String[]{label}, helpLabel, new String[]{initialValue}, new int[]{valueLength}, showHexChk, showFullChk);
    }

    public InputDialog(JFrame parent, String title, String[] label, String helpLabel, String[] initialValue, int[] valueLength, boolean showHexChk, boolean showFullChk) {
        super(parent, title, true);
        Dimension d;
        int i;
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.valueLbl = new JLabel[label.length];
        this.valueCmp = new JComponent[label.length];
        this.value = new String[label.length];
        int maxLabelWidth = 0;
        JLabel longestLabel = null;
        for (i = 0; i < label.length; ++i) {
            this.valueLbl[i] = new JLabel(label[i]);
            d = layout.getPreferredSize(this.valueLbl[i]);
            this.valueLbl[i].setBounds(10, i == 0 ? 10 : LMResize.getBottom(this.valueLbl[i - 1]) + 15, d.width, d.height);
            if (d.width > maxLabelWidth) {
                maxLabelWidth = d.width;
                longestLabel = this.valueLbl[i];
            }
            this.getContentPane().add(this.valueLbl[i]);
            String initValue = initialValue != null ? initialValue[i] : null;
            this.valueCmp[i] = this.createAndInitValueCmp(i, valueLength[i], initValue);
        }
        for (i = 0; i < label.length; ++i) {
            this.valueCmp[i].setBounds(LMResize.getRight(longestLabel) + 5, LMResize.getTop(this.valueLbl[i]), 250, this.valueCmp[i].getPreferredSize().height);
            this.getContentPane().add((Component)this.valueCmp[i], new LMResizeData(1));
        }
        JComponent cmp = null;
        if (showHexChk || showFullChk) {
            if (showHexChk) {
                this.hexChk = new JCheckBox("Hexadecimal");
                this.hexChk.setSelected(Settings.getHexOption());
                this.hexChk.setMnemonic('h');
                d = layout.getPreferredSize(this.hexChk);
                this.hexChk.setBounds(LMResize.getLeft(this.valueLbl[this.valueLbl.length - 1]) + 5, LMResize.getBottom(this.valueLbl[this.valueLbl.length - 1]) + 15, d.width + 5, d.height);
                this.getContentPane().add(this.hexChk);
                cmp = this.hexChk;
            }
            if (showFullChk) {
                this.fullChk = new JCheckBox("Show full value");
                this.fullChk.setSelected(Settings.getHexOption());
                this.fullChk.setMnemonic('f');
                d = layout.getPreferredSize(this.fullChk);
                if (showHexChk) {
                    this.fullChk.setBounds(LMResize.getRight(this.hexChk) + 15, LMResize.getTop(this.hexChk), d.width + 5, d.height);
                } else {
                    this.fullChk.setBounds(LMResize.getLeft(this.valueLbl[this.valueLbl.length - 1]) + 5, LMResize.getBottom(this.valueLbl[this.valueLbl.length - 1]) + 15, d.width + 5, d.height);
                }
                this.getContentPane().add(this.fullChk);
                cmp = this.fullChk;
            }
        } else if (helpLabel != null) {
            this.helpLbl = new JLabel(helpLabel);
            this.helpLbl.setFont(this.helpLbl.getFont().deriveFont(2));
            d = layout.getPreferredSize(this.helpLbl);
            this.helpLbl.setBounds(LMResize.getLeft(this.valueLbl[this.valueLbl.length - 1]) + 5, LMResize.getBottom(this.valueLbl[this.valueLbl.length - 1]) + 15, d.width + 5, d.height);
            this.getContentPane().add(this.helpLbl);
            cmp = this.helpLbl;
        }
        if (cmp == null) {
            cmp = this.valueCmp[this.valueCmp.length - 1];
        }
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(e -> {
            this.setValue();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(e -> this.closeDialog());
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.valueCmp[this.valueCmp.length - 1]) - d.width + 5, LMResize.getBottom(cmp) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.ok);
    }

    protected JComponent createAndInitValueCmp(int index, int len, String initValue) {
        JTextField tf = new JTextField(len);
        tf.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(tf));
        if (initValue != null) {
            tf.setText(initValue);
        }
        return tf;
    }

    public String getValue() {
        return this.value[0];
    }

    public String[] getValues() {
        return this.value;
    }

    public boolean isHexadecimal() {
        return this.hex;
    }

    public boolean isFull() {
        return this.full;
    }

    protected String getValue(int index, JComponent c) {
        JTextField tf = (JTextField)c;
        return tf.getText();
    }

    private void setValue() {
        for (int i = 0; i < this.valueCmp.length; ++i) {
            this.value[i] = this.getValue(i, this.valueCmp[i]);
        }
        if (this.hexChk != null) {
            this.hex = this.hexChk.isSelected();
        }
        if (this.fullChk != null) {
            this.full = this.fullChk.isSelected();
        }
    }
}

