/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.event.HyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HelpDialog
extends DebugFrame {
    private static final long serialVersionUID = 123L;
    private static Command[] commands = new Command[]{new Command("b0", "b0.html"), new Command("break", "break.html"), new Command("clear", "clear.html"), new Command("continue", "continue.html"), new Command("directory", "directory.html"), new Command("display", "display.html"), new Command("down", "down.html"), new Command("env", "env.html"), new Command("exit", "exit.html"), new Command("f", "f.html"), new Command("fb", "fb.html"), new Command("ff", "ff.html"), new Command("ft", "ft.html"), new Command("gc", "gc.html"), new Command("help", "help.html"), new Command("infostack", "infostack.html"), new Command("jump", "jump.html"), new Command("length", "length.html"), new Command("let", "let.html"), new Command("line", "line.html"), new Command("list", "list.html"), new Command("m0", "m0.html"), new Command("memory", "memory.html"), new Command("monitor", "monitor.html"), new Command("next", "next.html"), new Command("offset", "offset.html"), new Command("outpar", "outpar.html"), new Command("outprog", "outprog.html"), new Command("pause", "suspend.html"), new Command("prog", "prog.html"), new Command("quit", "quit.html"), new Command("readsession", "readsession.html"), new Command("restart", "restart.html"), new Command("run", "run.html"), new Command("step", "step.html"), new Command("stoff", "stoff.html"), new Command("ston", "ston.html"), new Command("thread", "thread.html"), new Command("to", "to.html"), new Command("troff", "troff.html"), new Command("tron", "tron.html"), new Command("unmonitor", "unmonitor.html"), new Command("up", "up.html"), new Command("w0", "w0.html"), new Command("w@", "w@.html"), new Command("wb", "wb.html"), new Command("writesession", "writesession.html"), new Command("wt", "wt.html")};
    private JEditorPane textArea;
    private JTree helpTree;
    private JButton close;
    private DefaultMutableTreeNode b0;
    private DefaultMutableTreeNode m0;

    public HelpDialog(JFrame parent, String title) {
        super(parent, title);
        this.setSize(800, 700);
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane sp = new JSplitPane(1);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.helpTree = new JTree(treeModel);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setFont(new Font("sansserif", 1, 12));
        this.helpTree.setCellRenderer(renderer);
        this.helpTree.setRootVisible(false);
        this.helpTree.setShowsRootHandles(true);
        this.helpTree.setScrollsOnExpand(true);
        this.helpTree.setExpandsSelectedPaths(true);
        for (int i = 0; i < commands.length; ++i) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(commands[i]);
            root.add(n);
            if (commands[i].name.equals("b0")) {
                this.b0 = n;
                continue;
            }
            if (!commands[i].name.equals("m0")) continue;
            this.m0 = n;
        }
        JPanel leftPanel = new JPanel(new BorderLayout());
        JLabel l = new JLabel("Debug commands");
        l.setOpaque(true);
        l.setBackground(Color.white);
        l.setPreferredSize(new Dimension(0, 30));
        l.setHorizontalAlignment(0);
        leftPanel.add((Component)l, "North");
        JScrollPane scroll = new JScrollPane(this.helpTree);
        leftPanel.add((Component)scroll, "Center");
        sp.setLeftComponent(leftPanel);
        this.textArea = new JEditorPane();
        this.textArea.setEditable(false);
        this.textArea.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.textArea));
        this.textArea.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = e.getURL().toString();
                if (url.endsWith("m0")) {
                    this.helpTree.setSelectionPath(new TreePath(this.m0.getPath()));
                } else if (url.endsWith("b0")) {
                    this.helpTree.setSelectionPath(new TreePath(this.b0.getPath()));
                }
            }
        });
        this.textArea.setContentType("text/html");
        this.helpTree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            this.helpTree.scrollPathToVisible(e.getPath());
            Object userObj = n.getUserObject();
            try {
                if (userObj instanceof Command) {
                    Command c = (Command)userObj;
                    String helpPage = c.helpPage;
                    this.textArea.setPage(HelpDialog.class.getResource(helpPage));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        scroll = new JScrollPane(this.textArea);
        sp.setRightComponent(scroll);
        sp.setDividerLocation(200);
        sp.setDividerSize(5);
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(e -> this.closeFrame());
        JPanel mainPanel = new JPanel(new GridLayout(1, 0));
        mainPanel.add(sp);
        SpringLayout buttonsLayout = new SpringLayout();
        JPanel buttonPanel = new JPanel(buttonsLayout);
        buttonPanel.add(this.close);
        buttonsLayout.putConstraint("East", (Component)this.close, -10, "East", (Component)buttonPanel);
        buttonsLayout.putConstraint("North", (Component)this.close, 10, "North", (Component)buttonPanel);
        buttonsLayout.putConstraint("South", (Component)buttonPanel, 10, "South", (Component)this.close);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        treeModel.reload();
        this.setDefaultButton(this.close);
    }

    public void selectCommand(String cmd) {
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].name.equalsIgnoreCase(cmd)) continue;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.helpTree.getModel().getRoot();
            DefaultMutableTreeNode nodeToSelect = (DefaultMutableTreeNode)root.getChildAt(i);
            this.helpTree.setSelectionPath(new TreePath(nodeToSelect.getPath()));
            break;
        }
    }

    private static class Command
    implements Comparable {
        private String name;
        private String helpPage;

        Command(String n, String h) {
            this.name = n;
            this.helpPage = h;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            if (o instanceof Command) {
                return this.name.compareToIgnoreCase(((Command)o).name);
            }
            throw new ClassCastException();
        }
    }
}

