/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RunCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 2;
    public static final String SHORT_DESCRIPTION = " : start execution";
    public static final String STRING_ID = "run";
    public static final String HELP_PAGE = "run.html";
    public static final String USAGE = "usage: run [arg1 ... argN]" + eol;
    private String[] args;

    public RunCommand() {
    }

    public RunCommand(String[] args) {
        this.args = args;
    }

    public String[] getArgs() {
        return this.args;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        if (this.args != null) {
            out.writeInt(this.args.length);
            for (String s : this.args) {
                RtsUtil.writeUTFOptmz(s, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.args = new String[in.readInt()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = RtsUtil.readUTFOptmz(in);
        }
    }
}

