/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commandline;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.commandline.VIStyleConsole;
import com.iscobol.debugger.commands.AutoOnCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.rts.Config;
import com.iscobol.rts.OSValidator;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class CommandLineDebugger {
    private static final int ATTEMPT_NUMBER = 10;
    private static ResourceBundle rb = ResourceBundle.getBundle("com.iscobol.debugger.commandline.resources");
    public static final String eol = System.getProperty("line.separator", "\n");
    private CommandProcessor processor;
    private AutostepThread autostepThread = new AutostepThread();
    private int port;
    private boolean suspended = true;
    private boolean running;
    private String hostname = "localhost";
    private String lastCommand;
    private String lastProgram;
    private int lastCommandId;
    private DebugTM tm;
    private AbstractConsole console;
    protected DebuggerInvoker invoker;

    public CommandLineDebugger(DebuggerInvoker invoker) {
        this.invoker = invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] argv) throws Exception {
        block22: {
            this.setPrefix();
            String usage = MessageFormat.format(rb.getString("message.usage"), this.getName(), this.getRemoteOptionName());
            boolean viStyleConsole = false;
            boolean viOption = false;
            PrintStream sysOut = System.out;
            PrintStream sysErr = System.err;
            try {
                AbstractConsole console;
                if (argv.length > 0 && argv[0].equalsIgnoreCase("-vi")) {
                    viOption = true;
                    String[] tmp = argv;
                    argv = new String[argv.length - 1];
                    System.arraycopy(tmp, 1, argv, 0, argv.length);
                }
                if (OSValidator.isWindows()) {
                    console = this.isSystemConsoleAvailable() ? new SystemConsole() : new SysInConsole();
                } else if (OSValidator.isUnix() && viOption) {
                    viStyleConsole = true;
                    System.setOut(new CRPrintStream(new FileOutputStream(FileDescriptor.out)));
                    System.setErr(new CRPrintStream(new FileOutputStream(FileDescriptor.err)));
                    console = new VIConsole(System.out);
                } else {
                    console = new SysInConsole();
                }
                if (argv.length == 0) {
                    System.err.println(usage);
                    System.exit(-1);
                }
                if (argv.length == 1 && argv[0].equalsIgnoreCase("-v")) {
                    this.version(System.out, rb);
                    System.exit(0);
                }
                this.console = console;
                if (argv[0].equalsIgnoreCase(this.getRemoteOptionName())) {
                    String hostname = null;
                    if (argv.length > 1) {
                        hostname = argv[1];
                    }
                    int port = 0;
                    if (argv.length > 2) {
                        try {
                            port = Integer.parseInt(argv[2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    try {
                        int rc = this.start(hostname, port);
                        System.exit(rc);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.exit(-1);
                    }
                    break block22;
                }
                int classNameIndex = CommandLineDebugger.getClassNameIndex(argv);
                String className = null;
                if (classNameIndex >= argv.length) {
                    System.err.println(usage);
                    System.exit(-1);
                } else {
                    className = argv[classNameIndex];
                }
                try {
                    int rc = this.start(className, argv);
                    System.exit(rc);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(-1);
                }
            }
            finally {
                if (viStyleConsole) {
                    System.setOut(sysOut);
                    System.setErr(sysErr);
                }
            }
        }
    }

    void processCommand(int cmdId) {
        this.suspended = false;
        this.processor.processCommand(cmdId, true);
    }

    private int start(String className, String[] argv) throws IOException {
        try {
            if (!this.isCobolProgram(className, argv)) {
                System.err.println(rb.getString("message.invalid.class") + " ' " + className + "'");
                return -1;
            }
            this.port = this.launchCobolProgram(argv);
            if (!this.isDebuggable(className)) {
                System.out.println(rb.getString("message.debugger.info.not.found"));
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println(rb.getString("message.cannot.load.class") + " '" + className + "'");
            return -1;
        }
        if (this.port <= 0) {
            System.err.println(rb.getString("message.cannot.load.class") + " '" + className + "'");
            return -1;
        }
        int rc = this.doRemoteDebugging("localhost", this.port, false);
        if (rc != 0 && rc != 203) {
            System.err.println(MessageFormat.format(rb.getString("message.debugger.not.respond"), this.getName()));
            return -1;
        }
        this.runDebugShell(false);
        this.invoker.exitDebug();
        return 0;
    }

    private int start(String hostname, int port) throws IOException {
        int rc;
        if (hostname == null || hostname.length() == 0) {
            hostname = Config.getProperty(".hostname", "localhost");
        }
        if (port <= 0) {
            port = Config.getProperty(".debug.port", 9999);
        }
        if ((rc = this.doRemoteDebugging(hostname, port, true)) != 0) {
            System.err.println(MessageFormat.format(rb.getString("message.debugger.not.respond"), this.getName()));
            return -1;
        }
        this.runDebugShell(true);
        this.invoker.exitDebug();
        return 0;
    }

    private int doRemoteDebugging(String hostname, int port, boolean remote) throws IOException {
        this.hostname = hostname;
        this.port = port;
        DebugResponse resp = this.invoker.invokeRemote(hostname, port, 10, false);
        int rc = resp.getReturnCode();
        switch (rc) {
            case 103: {
                this.exit(MessageFormat.format(rb.getString("message.program.finished"), this.getName()), 0);
                break;
            }
            case 106: {
                this.exit(rb.getString("message.connection.refused"), 0);
                break;
            }
        }
        return rc;
    }

    private static int getClassNameIndex(String[] argv) {
        int i;
        for (i = 0; i < argv.length && argv[i].startsWith("-"); ++i) {
        }
        return i;
    }

    private void handleResponse(DebugResponse resp) {
        String prg = resp.getLastProgram();
        if (prg != null && prg.length() > 0) {
            if (this.lastProgram == null || !prg.equals(this.lastProgram)) {
                this.invoker.setInfo(this.invoker.getInfo(prg, false, false));
            }
            this.lastProgram = prg;
        }
    }

    private boolean checkSuspend() {
        if (!this.suspended) {
            System.out.println(rb.getString("message.debugger.not.suspended"));
            return false;
        }
        return true;
    }

    private boolean checkNotSuspend() {
        if (this.suspended) {
            System.out.println(rb.getString("message.debugger.already.suspended"));
            return false;
        }
        return true;
    }

    protected void printMessage(String msg) {
        this.printMessage(msg, true, true);
    }

    protected void printMessage(String msg, boolean newLine) {
        this.printMessage(msg, newLine, true);
    }

    protected void printMessage(String msg, boolean newLine, boolean prompt) {
        System.out.println();
        System.out.print(msg);
        if (newLine) {
            System.out.println();
        }
        if (prompt) {
            System.out.print(this.getPrompt());
        }
    }

    protected void runDebugShell(boolean remote) throws IOException {
        this.processor = new CommandProcessor(this.invoker, remote);
        this.processor.start();
        this.processor.processCommand(30, false);
        block19: while (true) {
            System.out.print(this.getPrompt());
            String cmd = this.console.readLine();
            cmd = cmd.trim();
            this.autostepThread.goOn = false;
            this.autostepThread.interrupt();
            if (cmd.length() == 0) {
                if (this.lastCommand == null) continue;
                cmd = this.lastCommand;
            }
            if (cmd.startsWith(">>") && this.running && !this.suspended) {
                this.invoker.putInput(cmd.substring(2));
                continue;
            }
            int cmdId = this.lastCommandId;
            if (cmd.length() > 0) {
                this.lastCommand = cmd;
                this.tm = new DebugTM(this.lastCommand, " ,;(:=)+*\"<>", DebuggerInvoker.defCommands);
                try {
                    cmdId = this.tm.getCommand(this.tm.getToken());
                }
                catch (DebuggerException de) {
                    System.out.println(de.getMessage());
                    continue;
                }
            }
            switch (cmdId) {
                case -1: {
                    System.out.println(rb.getString("message.internal.error"));
                    break;
                }
                case 21: 
                case 27: 
                case 58: {
                    System.err.println(MessageFormat.format(rb.getString("message.debugger.exit"), this.getName()));
                    return;
                }
                case 39: {
                    if (this.running) {
                        if (!this.checkSuspend()) break;
                        try {
                            AutoOnCommand autoon = (AutoOnCommand)this.invoker.parseCommand(cmdId, this.tm);
                            if (autoon.isGet()) {
                                System.out.println(rb.getString("message.autostep.delay") + ": " + this.autostepThread.delay);
                                break;
                            }
                            if (autoon.isSet()) {
                                this.autostepThread.delay = autoon.getDelay();
                                System.out.println(rb.getString("message.autostep.delay") + ": " + this.autostepThread.delay);
                                break;
                            }
                            this.autostepThread.goOn = true;
                            this.autostepThread.start();
                        }
                        catch (IllegalArgumentException e) {
                            System.out.println(e.getMessage());
                        }
                        catch (DebuggerException e) {
                            System.out.println(e.getMessage());
                        }
                        continue block19;
                    }
                    System.out.println(rb.getString("message.debugger.waiting.for.thread"));
                    break;
                }
                case 40: {
                    this.autostepThread.goOn = false;
                    System.out.println(rb.getString("message.autostep.stop"));
                    break;
                }
                case 2: {
                    if (this.running) {
                        System.out.println(rb.getString("message.debugger.already.running"));
                        break;
                    }
                    System.out.println(rb.getString("message.debugger.waiting.for.thread"));
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 24: 
                case 25: 
                case 26: 
                case 29: 
                case 44: 
                case 45: 
                case 52: 
                case 56: {
                    if (this.running) {
                        if (!this.checkSuspend()) break;
                        this.processCommand(cmdId);
                        break;
                    }
                    System.out.println(rb.getString("message.debugger.waiting.for.thread"));
                    break;
                }
                case 28: {
                    if (!this.checkNotSuspend()) break;
                    this.invoker.suspend();
                    break;
                }
                case 7: 
                case 8: 
                case 20: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 46: {
                    try {
                        DebugResponse r = this.invoker.processCommand(cmdId, this.tm);
                        this.handleResponse(r);
                        System.out.print(r.getMessage());
                        if (cmdId != 20 || cmd.indexOf(32) >= 0) continue block19;
                        System.out.println(rb.getString("message.pushdata.help"));
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println(e.getMessage());
                    }
                    catch (DebuggerException e) {
                        System.out.println(e.getMessage());
                    }
                    continue block19;
                }
                case 22: 
                case 23: {
                    System.out.println(rb.getString("message.feature.not.supported"));
                }
            }
        }
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    private void exit(String msg, int code) {
        System.out.println(msg);
        System.exit(code);
    }

    public abstract void version(PrintStream var1, ResourceBundle var2);

    public abstract String getPrompt();

    public abstract boolean isCobolProgram(String var1, String[] var2) throws ClassNotFoundException;

    public abstract int launchCobolProgram(String[] var1);

    public abstract void setPrefix();

    public abstract boolean isDebuggable(String var1) throws ClassNotFoundException;

    public abstract int processGetInfo(boolean var1);

    public abstract String getName();

    public abstract String getRemoteOptionName();

    private boolean isSystemConsoleAvailable() {
        try {
            Method m = System.class.getMethod("console", new Class[0]);
            return m.invoke(null, new Object[0]) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Reader getSystemConsoleReader() {
        try {
            Method m = System.class.getMethod("console", new Class[0]);
            Object console = m.invoke(null, new Object[0]);
            return (Reader)console.getClass().getMethod("reader", new Class[0]).invoke(console, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DebuggerInvoker getInvoker() {
        return this.invoker;
    }

    private class AutostepThread
    implements Runnable {
        double delay = 1.0;
        volatile boolean goOn;
        Thread th;

        private AutostepThread() {
        }

        void start() {
            this.th = new Thread(this);
            this.th.start();
        }

        void interrupt() {
            if (this.th != null) {
                this.th.interrupt();
            }
        }

        @Override
        public void run() {
            while (this.goOn) {
                try {
                    Thread.sleep((int)(this.delay * 1000.0));
                    CommandLineDebugger.this.suspended = false;
                    CommandLineDebugger.this.processor.processCommand(3, false);
                }
                catch (InterruptedException e) {
                    this.goOn = false;
                }
            }
        }
    }

    private class CommandProcessor
    extends Thread {
        boolean prompt;
        int cmdId = -1;
        boolean remote;
        DebuggerInvoker invoker;

        CommandProcessor(DebuggerInvoker invoker, boolean remote) {
            this.setDaemon(true);
            this.remote = remote;
            this.invoker = invoker;
        }

        synchronized void processCommand(int cmdId, boolean prompt) {
            this.cmdId = cmdId;
            this.prompt = prompt;
            this.notify();
        }

        synchronized void waitForCommand() {
            while (this.cmdId < 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public void run() {
            while (true) {
                this.waitForCommand();
                try {
                    if (this.cmdId == 30) {
                        int rc = CommandLineDebugger.this.processGetInfo(this.remote);
                        if (rc == 103) {
                            CommandLineDebugger.this.exit(MessageFormat.format(rb.getString("message.program.finished"), CommandLineDebugger.this.getName()), 0);
                        } else {
                            CommandLineDebugger.this.running = true;
                        }
                    } else {
                        DebugResponse resp = this.invoker.processCommand(this.cmdId, CommandLineDebugger.this.tm);
                        if (resp != null) {
                            CommandLineDebugger.this.handleResponse(resp);
                            if (resp.getReturnCode() == 103) {
                                CommandLineDebugger.this.printMessage(resp.getMessage(), false, this.prompt);
                                CommandLineDebugger.this.exit(MessageFormat.format(rb.getString("message.program.finished"), CommandLineDebugger.this.getName()), 0);
                            } else if (resp.getLastCmd() == 5 && resp.getTree() != null) {
                                CommandLineDebugger.this.printMessage(resp.getMessage(), false, false);
                                Tree t = resp.getTree();
                                for (TreeNode tn : t.getRoot().getChildren()) {
                                    this.displayTreeNode(tn, "");
                                }
                                System.out.print(CommandLineDebugger.this.getPrompt());
                            } else {
                                CommandLineDebugger.this.printMessage(resp.getMessage(), false, this.prompt);
                            }
                        } else {
                            CommandLineDebugger.this.exit(MessageFormat.format(rb.getString("message.debugger.not.respond"), CommandLineDebugger.this.getName()), 1);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    CommandLineDebugger.this.printMessage(e.getMessage(), true);
                }
                catch (DebuggerException e) {
                    CommandLineDebugger.this.printMessage(e.getMessage(), true);
                }
                CommandLineDebugger.this.suspended = true;
                this.cmdId = -1;
            }
        }

        private void displayTreeNode(TreeNode tn, String indent) {
            String val = tn.getVarValue();
            System.out.println(indent + "+ " + tn.getVarName() + (val != null ? " = " + val : ""));
            String indent0 = indent + "   ";
            for (TreeNode tn0 : tn.getChildren()) {
                this.displayTreeNode(tn0, indent0);
            }
        }
    }

    private static class CRPrintStream
    extends PrintStream {
        CRPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public synchronized void print(String s) {
            char[] c = s.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                super.print(c[i]);
                if (c[i] != '\n') continue;
                super.print('\r');
            }
        }

        @Override
        public synchronized void println() {
            super.print("\n\r");
        }

        @Override
        public synchronized void println(String s) {
            this.print(s);
            super.print("\n\r");
        }
    }

    private class VIConsole
    extends AbstractConsole {
        VIStyleConsole vsc;

        VIConsole(PrintStream sysOut) {
            this.vsc = new VIStyleConsole(CommandLineDebugger.this.getPrompt(), sysOut, System.in);
        }

        @Override
        String readLine() throws IOException {
            return this.vsc.readLine();
        }
    }

    private class SysInConsole
    extends AbstractConsole {
        BufferedReader in;

        SysInConsole() {
            this.in = new BufferedReader(new InputStreamReader(System.in));
        }

        @Override
        String readLine() throws IOException {
            return this.in.readLine();
        }
    }

    private class SystemConsole
    extends AbstractConsole {
        BufferedReader in;

        SystemConsole() {
            this.in = new BufferedReader(CommandLineDebugger.this.getSystemConsoleReader());
        }

        @Override
        String readLine() throws IOException {
            return this.in.readLine();
        }
    }

    private static abstract class AbstractConsole {
        private AbstractConsole() {
        }

        abstract String readLine() throws IOException;
    }
}

