/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.Listing;
import com.iscobol.debugger.ListingException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextFile {
    private String[] lines;
    private int numLines;
    private int maxLineWidth;
    private String longestLine = "";
    private Filename filename;
    private long timestamp;
    private int currLine;
    private Listing listing;
    private String className;
    private DebugParagraph[] debugParagraphs;
    private DebugLine[] debugLines;
    private String[] filenames;
    private String fileNotFound;
    private boolean supportingJumpCommand;
    private char hyphenRepl = (char)95;

    public TextFile(String errorStr) {
        this.filename = new Filename("");
        String oneLine = errorStr != null ? errorStr : "                                                    ";
        this.lines = new String[]{oneLine};
        this.longestLine = oneLine;
        this.numLines = this.lines.length;
        this.maxLineWidth = this.longestLine.length();
    }

    public TextFile(FileLoader fileLoader, DebugResponse.DebugInfo dInfo, Filename fn, long timestamp, boolean isListing) {
        this.filename = fn;
        this.timestamp = timestamp;
        boolean bl = this.supportingJumpCommand = dInfo != null ? dInfo.isJumpCommandSupported() : false;
        if (isListing && dInfo != null) {
            String[] co;
            this.debugParagraphs = dInfo.getParagraphs();
            this.debugLines = dInfo.getLines();
            this.filenames = dInfo.getFilenames();
            this.className = dInfo.getClassName();
            this.hyphenRepl = dInfo.getHyphenReplacingChar();
            HashSet<String> opts = new HashSet<String>();
            for (String opt : co = dInfo.getCompilerOptions()) {
                String lwopt = opt.toLowerCase();
                if (lwopt.equals("-st") || lwopt.equals("-sa") || lwopt.equals("-sf") || lwopt.equals("-sv") || lwopt.equals("-sl") || lwopt.equals("-smat") || lwopt.equals("-xoldsmat")) {
                    opts.add(opt);
                    continue;
                }
                if (!lwopt.startsWith("-ce=")) continue;
                opt = TextFile.canonicalizePathList(opt, dInfo.getPathSeparator());
                opts.add(opt);
            }
            if (dInfo.getListingInfos() != null) {
                try {
                    DebugUtilities.setCompilerConsts(dInfo.getCompilerProps(), false);
                    this.listing = new Listing(dInfo.getListingInfos(), dInfo.getInfoFormat(), dInfo.getCopyfiles(), this.filename, fileLoader.getRemoteEncoding(), opts);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.listing = new Listing(fileLoader, dInfo.getCopyfiles(), this.filename, fileLoader.getRemoteEncoding(), opts);
                }
                catch (ListingException listingException) {
                    // empty catch block
                }
            }
        }
        if (this.listing != null) {
            this.lines = this.listing.getLines();
            this.longestLine = this.listing.getLongestLine();
        } else {
            try {
                this.lines = fileLoader.getLines(this.filename.getOrigName(), true);
                this.longestLine = fileLoader.getLongestLine(this.filename.getOrigName(), false);
            }
            catch (FileNotFoundException ex) {
                this.lines = new String[0];
                this.longestLine = "";
                this.fileNotFound = this.filename.getBaseName();
            }
        }
        this.numLines = this.lines.length;
        this.maxLineWidth = this.longestLine.length();
    }

    public boolean isSupportingJumpCommand() {
        return this.supportingJumpCommand;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public String[] getFilesNotFound() {
        String[] Return2;
        if (this.listing != null) {
            Return2 = new String[this.listing.fileNotFoundList.size()];
            this.listing.fileNotFoundList.toArray(Return2);
        } else {
            Return2 = this.fileNotFound != null ? new String[]{this.fileNotFound} : new String[]{};
        }
        return Return2;
    }

    public String getLine(int n, boolean upper) {
        return this.getLine(n, upper, true);
    }

    public String getLine(int n, boolean upper, boolean matchMinusUnderscore) {
        String Return2 = "";
        if (n >= 0 && n < this.numLines) {
            Return2 = upper ? this.lines[n].toUpperCase() : this.lines[n];
            if (!matchMinusUnderscore) {
                Return2 = Return2.replaceAll("_", "-");
            }
            Return2 = Return2.replaceAll("\t", "        ");
        } else {
            Return2 = "";
        }
        return Return2;
    }

    public int toListingLine(int cobolRowIndex, Filename f, int fileIndex) {
        if (this.listing != null) {
            return this.listing.toListingLine(cobolRowIndex, f, fileIndex);
        }
        return cobolRowIndex - 1;
    }

    public int toListingLine(int cobolRowIndex, int fileIndex) {
        if (this.listing != null) {
            return this.listing.toListingLine(cobolRowIndex, fileIndex);
        }
        return cobolRowIndex - 1;
    }

    public CobolRef toCobolLine(int listingRowIndex) {
        if (this.listing != null) {
            return this.listing.toCobolLine(listingRowIndex);
        }
        return new CobolRef(listingRowIndex + 1, this.filename.getOrigName(), -1, -1, null);
    }

    public boolean isCopyStatement(int listingRowIndex) {
        if (this.listing != null) {
            return this.listing.isCopyStatement(listingRowIndex);
        }
        return false;
    }

    public String getLongestLine() {
        return this.longestLine;
    }

    public String getFilename() {
        return this.filename.getOrigName();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long t) {
        this.timestamp = t;
    }

    public String getClassName() {
        return this.className;
    }

    public Filename[] getFilenames() {
        if (this.listing != null) {
            Vector files = this.listing.getFiles();
            Filename[] Return2 = new Filename[files.size()];
            files.toArray(Return2);
            return Return2;
        }
        return new Filename[]{this.filename};
    }

    public void setCurrLine(int l) {
        this.currLine = l;
    }

    public int getCurrLine() {
        return this.currLine;
    }

    public DebugParagraph[] getDebugParagraphs() {
        return this.debugParagraphs;
    }

    public DebugLine[] getDebugLines() {
        return this.debugLines;
    }

    public String[] getParagraphs() {
        if (this.debugParagraphs == null) {
            return null;
        }
        String[] Return2 = new String[this.debugParagraphs.length];
        for (int i = 0; i < this.debugParagraphs.length; ++i) {
            Return2[i] = this.debugParagraphs[i].getParagraphName();
        }
        return Return2;
    }

    public void getParagraphsNames(Set<String> result) {
        if (this.debugParagraphs == null) {
            return;
        }
        for (int i = 0; i < this.debugParagraphs.length; ++i) {
            result.add(this.debugParagraphs[i].getParagraphName());
        }
    }

    public CobolRef paragraphToLine(String par) {
        if (this.filenames == null) {
            return null;
        }
        try {
            for (int i = 0; i < this.debugParagraphs.length; ++i) {
                if (!this.debugParagraphs[i].getParagraphName().equalsIgnoreCase(par.replace(this.hyphenRepl, '-'))) continue;
                return new CobolRef(this.debugParagraphs[i].getLineNumber(), this.filenames[this.debugParagraphs[i].getFileIndex()], (short)this.debugParagraphs[i].getFileIndex(), -1, null);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasListing() {
        return this.listing != null;
    }

    protected CobolRef getBPArgs(int listingRowIndex) {
        CobolRef Return2 = this.toCobolLine(listingRowIndex);
        if (Return2 != null && this.hasListing()) {
            Return2.setProgname(this.className);
        }
        return Return2;
    }

    static String canonicalizePathList(String pl, String ps) {
        if (ps.equals(";")) {
            return pl;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer stn = new StringTokenizer(pl, ps);
        while (stn.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(stn.nextToken());
        }
        return sb.toString();
    }

    public boolean isFreeFormat() {
        return this.listing != null && this.listing.isFreeFormat();
    }
}

