/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolVar;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Level88
implements Serializable,
Handle {
    private static final long serialVersionUID = 1000007L;
    private String name;
    private ICobolVar parent;
    private Vector trueIntervals = new Vector();
    private ICobolVar falseValue;

    public Level88(String n, CobolVar par) {
        this(n, (ICobolVar)par);
    }

    public Level88(String n, ICobolVar par) {
        this.name = n;
        this.parent = par;
    }

    private Level88(String n, ICobolVar par, Vector ttVal, ICobolVar fVal) {
        this(n, par);
        this.trueIntervals = ttVal;
        this.falseValue = fVal;
    }

    public ICobolVar getParent() {
        return this.parent;
    }

    private int CompareTo(ICobolVar cv) {
        if (this.parent instanceof INumericVar && cv instanceof INumericVar) {
            return ((INumericVar)this.parent).num().compareTo(((INumericVar)cv).num());
        }
        return this.parent.compare(cv);
    }

    private void moveFrom(ICobolVar cv) {
        this.parent.setValue(cv);
    }

    public boolean getValue() {
        try {
            return this.intGetValue();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean intGetValue() throws Exception {
        Enumeration en = this.trueIntervals.elements();
        while (en.hasMoreElements()) {
            Interval i = (Interval)en.nextElement();
            if (!(i.to == null ? this.CompareTo(i.from) == 0 : this.CompareTo(i.from) >= 0 && this.CompareTo(i.to) <= 0)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getDimCount() {
        int[] dim = DebugUtilities.getDimensions(this.parent);
        return dim != null ? dim.length : 0;
    }

    public Level88 intAt(int[] idxs) {
        return new Level88(this.name, this.parent.intIAt(idxs), this.trueIntervals, this.falseValue);
    }

    public void setValue(boolean v) {
        if (v) {
            this.moveFrom(((Interval)this.trueIntervals.elementAt((int)0)).from);
        } else if (this.falseValue != null) {
            this.moveFrom(this.falseValue);
        }
    }

    public Level88 addInterval(CobolVar from, CobolVar to) {
        return this.addInterval((ICobolVar)from, (ICobolVar)to);
    }

    public Level88 addInterval(ICobolVar from, ICobolVar to) {
        this.trueIntervals.addElement(new Interval(from, to));
        return this;
    }

    public Level88 setFalseValue(CobolVar fv) {
        return this.setFalseValue((ICobolVar)fv);
    }

    public Level88 setFalseValue(ICobolVar fv) {
        this.falseValue = fv;
        return this;
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int maxLen) {
        boolean v = false;
        String str = DebuggerConstants.NULL_VALUE;
        try {
            v = this.intGetValue();
            str = DebugUtilities.toString(this.parent, maxLen);
        }
        catch (IscobolRuntimeException ex) {
            if (ex.getErrNum() == 31) {
                str = DebuggerConstants.NON_NUMERIC_VALUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "" + v + " [" + str + "]";
    }

    @Override
    public int type() {
        return 8;
    }

    private static class Interval {
        ICobolVar from;
        ICobolVar to;

        Interval(ICobolVar cv1, ICobolVar cv2) {
            this.from = cv1;
            this.to = cv2;
        }
    }
}

