/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Child;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.RawTextCommand;
import com.iscobol.rts.Config;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class InputChild
extends Child
implements Runnable {
    private DataOutputStream out;
    private DebugCommand command;

    private void init() {
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.t.start();
    }

    public InputChild(OutputStream out) {
        this.out = new DataOutputStream(out);
        this.init();
    }

    @Override
    public void run() {
        Config.markNoIscobolRuntimeThread();
        try {
            while (!this.isStopped()) {
                this.writeCommand();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeCommand() {
        if (this.command == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.command != null) {
            if (this.out != null) {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    DebugUtilities.writeCommand(this.command, this.out);
                }
            }
            this.command = null;
        }
    }

    public synchronized void setCommand(DebugCommand cmd) {
        if (cmd != null) {
            this.command = cmd;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInput(String s) throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            DebugUtilities.writeCommand(new RawTextCommand(s), this.out);
        }
    }
}

