/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.FileLoaderHelper;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.InputChild;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.OutputChild;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.AutoOffCommand;
import com.iscobol.debugger.commands.AutoOnCommand;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.ContinueCommand;
import com.iscobol.debugger.commands.CurrentLineCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DirectoryCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.DownCommand;
import com.iscobol.debugger.commands.EnvCommand;
import com.iscobol.debugger.commands.ExitCommand;
import com.iscobol.debugger.commands.FindBackwardsCommand;
import com.iscobol.debugger.commands.FindForwardsCommand;
import com.iscobol.debugger.commands.FindFromTopCommand;
import com.iscobol.debugger.commands.FirstExLineCommand;
import com.iscobol.debugger.commands.FirstLineCommand;
import com.iscobol.debugger.commands.GCCommand;
import com.iscobol.debugger.commands.GetFileCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.HelpCommand;
import com.iscobol.debugger.commands.JumpCommand;
import com.iscobol.debugger.commands.LastLineCommand;
import com.iscobol.debugger.commands.LengthCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.ListCommand;
import com.iscobol.debugger.commands.LoadCommand;
import com.iscobol.debugger.commands.MemoryCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.OffsetCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.QuitCommand;
import com.iscobol.debugger.commands.RepeatFindCommand;
import com.iscobol.debugger.commands.RestartCommand;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.debugger.commands.SaveCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetMonitorCommand;
import com.iscobol.debugger.commands.ShowLineCommand;
import com.iscobol.debugger.commands.StackInfoCommand;
import com.iscobol.debugger.commands.StepIntoCommand;
import com.iscobol.debugger.commands.StepOutParagraphCommand;
import com.iscobol.debugger.commands.StepOutProgramCommand;
import com.iscobol.debugger.commands.StepOverCommand;
import com.iscobol.debugger.commands.StepToCommand;
import com.iscobol.debugger.commands.StepToNextProgramCommand;
import com.iscobol.debugger.commands.SuspendCommand;
import com.iscobol.debugger.commands.ThreadCommand;
import com.iscobol.debugger.commands.TraceOffCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.debugger.commands.UpCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.interfaces.debugger.IDebugCommand;
import com.iscobol.interfaces.debugger.IDebugTM;
import com.iscobol.interfaces.debugger.IDebuggerInvokerExtension2;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class DebuggerInvoker
implements IDebuggerInvokerExtension2 {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final DebugCommand[] graphCommands = new DebugCommand[]{new AutoOffCommand(), new AutoOnCommand(), new CurrentLineCommand(), new DirectoryCommand(), new DownCommand(), new FindBackwardsCommand(), new FindForwardsCommand(), new FindFromTopCommand(), new FirstExLineCommand(), new FirstLineCommand(), new LastLineCommand(), new RepeatFindCommand(), new UpCommand()};
    public static final DebugCommand[] standardCommands = new DebugCommand[]{new ClearBreakpointCommand(), new ClearMonitorCommand(), new ContinueCommand(), new DisplayCommand(), new EnvCommand(), new ExitCommand(), new GCCommand(), new HelpCommand(), new JumpCommand(), new LengthCommand(), new LetCommand(), new ListCommand(), new LoadCommand(), new MemoryCommand(), new MethodBreakpointCommand(), new OffsetCommand(), new ProgramBreakpointCommand(), new QuitCommand(), new RestartCommand(), new RunCommand(), new SaveCommand(), new SetBreakpointCommand(), new SetMonitorCommand(), new ShowLineCommand(), new StackInfoCommand(), new StepIntoCommand(), new StepOutParagraphCommand(), new StepOutProgramCommand(), new StepOverCommand(), new StepToCommand(), new StepToNextProgramCommand(), new SuspendCommand(), new ThreadCommand(), new TraceOffCommand(), new TraceOnCommand()};
    public static final DebugCommand[] defCommands = new DebugCommand[graphCommands.length + standardCommands.length];
    private static final Vector activeProcesses;
    private static boolean defaultMonitorEnabledState;
    private static boolean defaultBreakpointEnabledState;
    private OutputChild outputThread;
    private InputChild inputThread;
    private Process process;
    private Socket dbgSocket;
    private String remoteHost;
    private int remotePort;
    private Hashtable<String, LocalDebugInfo> debugInfos = new Hashtable();
    private Set<File> loadedFilePaths = new HashSet<File>();
    private boolean checkFileOfBreakpoints = true;
    private FileLoader fileLoader = new FileLoader(this);
    private String mainClass;
    private String[] programArgs;
    private String lastCmdString;
    private int currLine = 1;
    private int selStackFrameIndex = -1;
    private ParagraphObject[] parStack;
    private int selLine = 1;
    private int startSelLine = 1;
    private String selFile = "";
    private int selPos;
    private String lastFind;
    private String currFile = "";
    private int currFileIndex;
    private FileLoaderHelper fileLoaderHelper;
    private LocalDebugInfo info;
    private int listSize = 5;

    @Override
    public void setCheckFileOfBreakpoints(boolean b) {
        this.checkFileOfBreakpoints = b;
    }

    public boolean isCheckFileOfBreakpoints() {
        return this.checkFileOfBreakpoints;
    }

    @Override
    public DebugResponse processCommand(String str) {
        if (str.equals("")) {
            str = this.lastCmdString;
        } else {
            this.lastCmdString = str;
        }
        DebugTM tm = new DebugTM(str, " ,;(:=)+*\"<>", defCommands);
        String commandString = tm.getToken();
        try {
            return this.processCommand(tm.getCommand(commandString), tm);
        }
        catch (DebuggerException de) {
            return new DebugResponse(de.getErrorId(), de.getMessage() + eol);
        }
        catch (IllegalArgumentException iae) {
            return new DebugResponse(1, "Internal error: " + commandString + eol);
        }
    }

    @Override
    public DebugResponse processCommand(int cmd, IDebugTM tm) throws Exception {
        if (!(tm instanceof DebugTM)) {
            throw new IllegalArgumentException("" + tm);
        }
        return this.processCommand(cmd, (DebugTM)tm);
    }

    public DebugResponse processCommand(int cmd, DebugTM tm) throws DebuggerException, IllegalArgumentException {
        DebugResponse Return2 = null;
        switch (cmd) {
            case -1: {
                Return2 = null;
                break;
            }
            case 20: {
                Return2 = this.help(tm);
                break;
            }
            case 2: {
                Return2 = this.run(tm);
                break;
            }
            case 0: {
                Return2 = this.setBreakpoint(tm);
                break;
            }
            case 9: {
                Return2 = this.clearBreakpoint(tm);
                break;
            }
            case 1: {
                Return2 = this.continue0();
                break;
            }
            case 3: {
                Return2 = this.stepInto(tm);
                break;
            }
            case 4: {
                Return2 = this.stepOver();
                break;
            }
            case 16: {
                Return2 = this.switchThread(tm);
                break;
            }
            case 24: {
                Return2 = this.gc();
                break;
            }
            case 25: {
                Return2 = this.memory();
                break;
            }
            case 26: {
                Return2 = this.env(tm);
                break;
            }
            case 17: {
                Return2 = this.traceOn(tm);
                break;
            }
            case 18: {
                Return2 = this.traceOff();
                break;
            }
            case 19: {
                Return2 = this.setProgramBreakpoint(tm);
                break;
            }
            case 52: {
                Return2 = this.setMethodBreakpoint(tm);
                break;
            }
            case 5: {
                Return2 = this.display(tm);
                break;
            }
            case 6: {
                Return2 = this.let(tm);
                break;
            }
            case 7: {
                Return2 = this.getLine();
                break;
            }
            case 8: {
                Return2 = this.list(tm);
                break;
            }
            case 10: {
                Return2 = this.stepOutOfParagraph();
                break;
            }
            case 11: {
                Return2 = this.stepOutOfProgram();
                break;
            }
            case 12: {
                Return2 = this.stepToLine(tm);
                break;
            }
            case 56: {
                Return2 = this.stepToNextProgram();
                break;
            }
            case 13: {
                Return2 = this.setMonitor(tm);
                break;
            }
            case 14: {
                Return2 = this.clearMonitor(tm);
                break;
            }
            case 15: {
                Return2 = this.getStackInfo(this.parseStackInfo(tm).isAllInfos());
                break;
            }
            case 21: {
                Return2 = this.quit();
                break;
            }
            case 22: {
                Return2 = this.load(tm);
                break;
            }
            case 23: {
                Return2 = this.save(tm);
                break;
            }
            case 27: {
                Return2 = this.exit();
                break;
            }
            case 30: {
                Return2 = this.getInfo(tm);
                break;
            }
            case 29: {
                Return2 = this.jump(tm);
                break;
            }
            case 31: {
                Return2 = this.find(tm, false, false, cmd);
                break;
            }
            case 32: {
                Return2 = this.find(tm, true, false, cmd);
                break;
            }
            case 33: {
                Return2 = this.find(tm, false, true, cmd);
                break;
            }
            case 34: {
                Return2 = this.find(false, false, cmd);
                break;
            }
            case 35: {
                Return2 = this.firstLine();
                break;
            }
            case 36: {
                Return2 = this.lastLine();
                break;
            }
            case 37: {
                Return2 = this.currLine();
                break;
            }
            case 38: {
                Return2 = this.firstExecLine();
                break;
            }
            case 44: {
                Return2 = this.up();
                break;
            }
            case 45: {
                Return2 = this.down();
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 46: {
                Return2 = this.directory(this.parseDirectory(tm));
                break;
            }
            case 55: {
                Return2 = this.offset(tm);
                break;
            }
            case 54: {
                Return2 = this.length(tm);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return Return2;
    }

    private DebugResponse update(DebugCommand cmd, DebugResponse resp) {
        if (resp == null) {
            return null;
        }
        switch (cmd.getId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 28: 
            case 29: 
            case 56: 
            case 1000: {
                this.update(resp);
                break;
            }
            case 16: {
                if (((ThreadCommand)cmd).isListing()) break;
                this.update(resp);
            }
        }
        return resp;
    }

    @Override
    public DebugCommand parseCommand(String cmd) throws DebuggerException, IllegalArgumentException {
        DebugTM tm = new DebugTM(cmd, " ,;(:=)+*\"<>", defCommands);
        return this.parseCommand(tm.getCommand(), tm);
    }

    @Override
    public DebugCommand parseCommand(int cmd, IDebugTM tm) throws Exception {
        if (!(tm instanceof DebugTM)) {
            throw new IllegalArgumentException("" + tm);
        }
        return this.parseCommand(cmd, (DebugTM)tm);
    }

    public DebugCommand parseCommand(int cmd, DebugTM tm) throws DebuggerException, IllegalArgumentException {
        DebugCommand Return2 = null;
        switch (cmd) {
            case -1: {
                Return2 = null;
                break;
            }
            case 20: {
                Return2 = this.parseHelp(tm);
                break;
            }
            case 2: {
                Return2 = this.parseRun(tm);
                break;
            }
            case 0: {
                Return2 = this.parseSetBreakpoint(tm);
                break;
            }
            case 9: {
                Return2 = this.parseClearBreakpoint(tm);
                break;
            }
            case 1: {
                Return2 = new ContinueCommand();
                break;
            }
            case 3: {
                Return2 = new StepIntoCommand();
                break;
            }
            case 4: {
                Return2 = new StepOverCommand();
                break;
            }
            case 16: {
                Return2 = this.parseSwitchThread(tm);
                break;
            }
            case 24: {
                Return2 = new GCCommand();
                break;
            }
            case 25: {
                Return2 = new MemoryCommand();
                break;
            }
            case 26: {
                Return2 = this.parseEnv(tm);
                break;
            }
            case 17: {
                Return2 = this.parseTraceOn(tm);
                break;
            }
            case 18: {
                Return2 = new TraceOffCommand();
                break;
            }
            case 19: {
                Return2 = this.parseSetProgramBreakpoint(tm);
                break;
            }
            case 52: {
                Return2 = this.parseSetMethodBreakpoint(tm);
                break;
            }
            case 5: {
                Return2 = this.parseDisplay(tm);
                break;
            }
            case 6: {
                Return2 = this.parseLet(tm);
                break;
            }
            case 7: {
                Return2 = new ShowLineCommand();
                break;
            }
            case 8: {
                Return2 = this.parseList(tm);
                break;
            }
            case 10: {
                Return2 = new StepOutParagraphCommand();
                break;
            }
            case 11: {
                Return2 = new StepOutProgramCommand();
                break;
            }
            case 12: {
                Return2 = this.parseStepToLine(tm);
                break;
            }
            case 56: {
                Return2 = new StepToNextProgramCommand();
                break;
            }
            case 13: {
                Return2 = this.parseSetMonitor(tm);
                break;
            }
            case 14: {
                Return2 = this.parseClearMonitor(tm);
                break;
            }
            case 15: {
                Return2 = this.parseStackInfo(tm);
                break;
            }
            case 21: {
                Return2 = new QuitCommand();
                break;
            }
            case 22: {
                Return2 = this.parseLoad(tm);
                break;
            }
            case 23: {
                Return2 = new SaveCommand();
                break;
            }
            case 27: {
                Return2 = new ExitCommand();
                break;
            }
            case 30: {
                Return2 = new GetInfoCommand();
                break;
            }
            case 29: {
                Return2 = this.parseJump(tm);
                break;
            }
            case 31: {
                Return2 = new FindForwardsCommand(this.parseFind(tm));
                break;
            }
            case 32: {
                Return2 = new FindBackwardsCommand(this.parseFind(tm));
                break;
            }
            case 33: {
                Return2 = new FindFromTopCommand(this.parseFind(tm));
                break;
            }
            case 34: {
                Return2 = new RepeatFindCommand();
                break;
            }
            case 35: {
                Return2 = new FirstLineCommand();
                break;
            }
            case 36: {
                Return2 = new LastLineCommand();
                break;
            }
            case 37: {
                Return2 = new CurrentLineCommand();
                break;
            }
            case 38: {
                Return2 = new FirstExLineCommand();
                break;
            }
            case 44: {
                Return2 = new UpCommand();
                break;
            }
            case 45: {
                Return2 = new DownCommand();
                break;
            }
            case 39: {
                Return2 = this.parseAutoOn(tm);
                break;
            }
            case 40: {
                Return2 = new AutoOffCommand();
                break;
            }
            case 46: {
                Return2 = this.parseDirectory(tm);
                break;
            }
            case 54: {
                Return2 = this.parseLength(tm);
                break;
            }
            case 55: {
                Return2 = this.parseOffset(tm);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return Return2;
    }

    public void setInfo(LocalDebugInfo i) {
        this.info = i;
    }

    private void update(DebugResponse resp) {
        int rc = resp.getReturnCode();
        if (rc == 0 || rc == 101 || rc == 102) {
            if (resp.getLine() > 0) {
                this.currLine = resp.getLine();
                this.setSelLine(this.currLine);
            }
            if (resp.getLastFile() != null && resp.getLastFile().length() > 0) {
                this.currFile = this.selFile = this.getRealPath(resp.getLastFile());
                this.currFileIndex = resp.getLastFileIndex();
            }
            if (resp.getParStack() != null) {
                this.parStack = resp.getParStack();
            }
            this.selPos = 0;
            if (resp.getMessage() != null) {
                StringBuffer msg = new StringBuffer(resp.getMessage());
                if (rc == 102) {
                    msg.insert(0, "+ at " + this.showLine(resp.getOldLine(), resp.getOldFile(), -1));
                }
                msg.append(this.showLine(this.currLine, this.currFile, this.currFileIndex));
                resp.setMessage(msg.toString());
            }
        }
    }

    void setSection(ParagraphObject po) {
        LocalDebugInfo info = this.getInfo(po.getProgName(), false, false, false);
        if (info == null) {
            return;
        }
        DebugParagraph[] dps = info.getParagraphs();
        int idx = DebugUtilities.indexOfParagraph(po.getParagraphNumber(), po.isDeclaratives(), dps);
        if (idx < 0 || dps[idx].isSection()) {
            return;
        }
        for (int i = idx - 1; i >= 0 && po.isDeclaratives() == dps[i].isInDeclaratives(); --i) {
            if (!dps[i].isSection()) continue;
            po.setParentSection(dps[i].getParagraphName());
            break;
        }
    }

    protected DebugResponse gc() {
        return this.processCommand(new GCCommand());
    }

    protected DebugResponse memory() {
        return this.processCommand(new MemoryCommand());
    }

    protected DebugCommand parseEnv(DebugTM tm) throws DebuggerException {
        String tk = tm.getToken();
        boolean full = "-full".equalsIgnoreCase(tk);
        if (full) {
            tk = tm.getToken();
        }
        if (tk == null) {
            throw new DebuggerException(EnvCommand.USAGE);
        }
        String key = tk;
        tk = tm.getAllToken();
        while (tk != null) {
            key = key + tk;
            tk = tm.getAllToken();
        }
        return new EnvCommand(key, full);
    }

    protected DebugResponse env(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseEnv(tm));
    }

    protected DebugCommand parseSwitchThread(DebugTM tm) throws DebuggerException {
        StringBuffer sb = new StringBuffer();
        String tk = tm.getAllToken();
        while (tk != null) {
            sb.append(tk);
            tk = tm.getAllToken();
        }
        String newThread = sb.toString().trim();
        if (newThread.length() == 0) {
            throw new DebuggerException(ThreadCommand.USAGE);
        }
        if (newThread.equalsIgnoreCase("-l")) {
            return new ThreadCommand(true);
        }
        return new ThreadCommand(newThread);
    }

    protected DebugResponse switchThread(DebugTM tm) throws DebuggerException {
        ThreadCommand tc = (ThreadCommand)this.parseSwitchThread(tm);
        return this.processCommand(tc);
    }

    protected DebugCommand parseLoad(DebugTM tm) {
        String filename = this.mainClass + ".isd";
        String tk = tm.getAllToken();
        if (tk != null) {
            StringBuffer sb = new StringBuffer(tk);
            while ((tk = tm.getAllToken()) != null) {
                sb.append(tk);
            }
            filename = sb.toString().trim();
        }
        return new LoadCommand(filename);
    }

    protected String getChainingString() {
        return null;
    }

    protected void setChainingString(String cs) {
    }

    protected DebugResponse load(DebugTM tm) {
        DebugResponse resp;
        boolean ok;
        LoadCommand lc = (LoadCommand)this.parseLoad(tm);
        Vector bps = new Vector();
        Vector ws = new Vector();
        Vector dsp = new Vector();
        String[] cs = new String[1];
        boolean bl = ok = this.load(lc.getFilename(), bps, ws, dsp, cs) != null;
        if (cs[0] != null) {
            this.setChainingString(cs[0]);
        }
        if (ok) {
            String msg = "+ loaded information from '" + lc.getFilename() + "'" + eol;
            resp = new DebugResponse(0, msg, 22);
            Breakpoint[] b = new Breakpoint[bps.size()];
            bps.toArray(b);
            resp.setBreakpoints(b);
            Watch[] w = new Watch[ws.size()];
            ws.toArray(w);
            resp.setMonitors(w);
            Tree[] tr = new Tree[dsp.size()];
            dsp.toArray(tr);
            resp.setTrees(tr);
        } else {
            resp = new DebugResponse(1, "-fail loading information from file '" + lc.getFilename() + "'" + eol);
        }
        return resp;
    }

    protected DebugCommand parseSave(DebugTM tm) {
        String filename = this.mainClass + ".isd";
        String tk = tm.getAllToken();
        if (tk != null) {
            StringBuffer sb = new StringBuffer(tk);
            while ((tk = tm.getAllToken()) != null) {
                sb.append(tk);
            }
            filename = sb.toString().trim();
        }
        return new SaveCommand(filename);
    }

    protected DebugResponse save(DebugTM tm) {
        SaveCommand cmd = (SaveCommand)this.parseSave(tm);
        Breakpoint[] bps = null;
        Watch[] wts = null;
        DebugResponse resp = this.processCommand(cmd);
        boolean ok = resp != null;
        if (ok) {
            bps = resp.getBreakpoints();
            wts = resp.getMonitors();
        }
        if (ok) {
            if (!DebuggerInvoker.save(cmd.getFilename(), bps, wts, null, this.getChainingString())) {
                return new DebugResponse(18, "- file '" + cmd.getFilename() + "' not found" + eol);
            }
        } else {
            return new DebugResponse(1, "");
        }
        return new DebugResponse(0, "+ saved information in '" + cmd.getFilename() + "'" + eol, 23);
    }

    protected DebugCommand parseStepToLine(DebugTM tm) throws DebuggerException {
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(StepToCommand.USAGE);
        }
        int lineNo = 0;
        try {
            lineNo = Integer.parseInt(tk);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String filename = this.currFile;
        tk = tm.getToken();
        if (tk != null) {
            filename = this.parseFilename(tk, tm);
        }
        tk = tm.getToken();
        int fileIndex = -1;
        if (tk != null && tk.equalsIgnoreCase("-fi")) {
            try {
                fileIndex = Integer.parseInt(tm.getToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new StepToCommand(lineNo, filename, fileIndex);
    }

    protected String parseFilename(String tk, DebugTM tm) {
        String file = tk;
        if (file.equals("\"")) {
            file = "";
            tk = tm.getAllToken();
            while (tk != null && !tk.equals("\"")) {
                file = file + tk;
                tk = tm.getAllToken();
            }
        } else {
            tk = tm.getToken();
            if (tk != null) {
                if (tk.equals(":")) {
                    file = file + tk;
                    tk = tm.getToken();
                    if (tk != null) {
                        file = file + tk;
                    } else {
                        tm.ungetToken();
                    }
                } else {
                    tm.ungetToken();
                }
            }
        }
        return file;
    }

    private void setSelLine(int l) {
        this.selLine = l;
    }

    private DebugResponse stepToLine(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseStepToLine(tm));
    }

    protected Object parseBreakpointCondition(DebugTM tm, boolean enabled) throws DebuggerException {
        Expression expr = null;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(SetMonitorCommand.USAGE);
        }
        boolean env = tk.equalsIgnoreCase("-env");
        boolean hex = tk.equalsIgnoreCase("-x");
        if (!env && !hex) {
            tm.ungetAllToken();
        }
        expr = new Expression(tm, true, env, hex);
        return expr;
    }

    private String parseParagraphName(String tk, DebugTM tm) throws DebuggerException {
        String paragraph = tk;
        tk = tm.getToken();
        if ("of".equalsIgnoreCase(tk)) {
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(5);
            }
            paragraph = paragraph + " of " + tk;
        } else if (tk != null) {
            tm.ungetToken();
        }
        return paragraph;
    }

    protected DebugCommand parseSetBreakpoint(DebugTM tm) throws DebuggerException {
        boolean enabled;
        int s = tm.countTokens();
        if (s < 1) {
            throw new DebuggerException(SetBreakpointCommand.USAGE);
        }
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(SetBreakpointCommand.USAGE);
        }
        if (tk.equalsIgnoreCase("-l")) {
            return new SetBreakpointCommand(true);
        }
        if (tk.equalsIgnoreCase("-d")) {
            enabled = false;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else if (tk.equalsIgnoreCase("-e")) {
            enabled = true;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else {
            enabled = defaultBreakpointEnabledState;
        }
        Object cond = null;
        int lineNo = 0;
        String paragraph = "";
        try {
            lineNo = Integer.parseInt(tk);
        }
        catch (NumberFormatException e) {
            paragraph = this.parseParagraphName(tk, tm);
        }
        int fileIndex = -1;
        String progName = null;
        String file = this.currFile;
        tk = tm.getToken();
        if (tk != null) {
            if (tk.equalsIgnoreCase("when")) {
                cond = this.parseBreakpointCondition(tm, enabled);
            } else {
                file = this.parseFilename(tk, tm);
                tk = tm.getToken();
                if (tk != null) {
                    if (tk.equalsIgnoreCase("-fi")) {
                        try {
                            fileIndex = Integer.parseInt(tm.getToken());
                        }
                        catch (Exception ex) {
                            throw new DebuggerException(5);
                        }
                        tk = tm.getToken();
                        if (tk != null) {
                            if (tk.equalsIgnoreCase("when")) {
                                cond = this.parseBreakpointCondition(tm, enabled);
                            } else {
                                progName = tk;
                            }
                        }
                    } else if (tk.equalsIgnoreCase("when")) {
                        cond = this.parseBreakpointCondition(tm, enabled);
                    } else {
                        progName = tk;
                    }
                }
            }
        }
        if (cond == null && (tk = tm.getToken()) != null && tk.equalsIgnoreCase("when")) {
            cond = this.parseBreakpointCondition(tm, enabled);
        }
        String path = "";
        if (this.checkFileOfBreakpoints && (path = this.fileLoader.getAbsolutePath(file)) == null) {
            throw new DebuggerException(4, "'" + file + "'");
        }
        if (lineNo != 0) {
            return new SetBreakpointCommand(lineNo, file, fileIndex, progName, enabled, path, (Expression)cond);
        }
        return new SetBreakpointCommand(paragraph, file, fileIndex, progName, enabled, path, (Expression)cond);
    }

    protected DebugCommand parseJump(DebugTM tm) throws DebuggerException {
        int s = tm.countTokens();
        if (s < 1) {
            throw new DebuggerException(JumpCommand.USAGE);
        }
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(JumpCommand.USAGE);
        }
        int lineNo = 0;
        String paragraph = "";
        try {
            lineNo = Integer.parseInt(tk);
            int fileIndex = -1;
            String file = this.currFile;
            tk = tm.getToken();
            if (tk != null) {
                file = this.parseFilename(tk, tm);
                tk = tm.getToken();
                if (tk != null && tk.equalsIgnoreCase("-fi")) {
                    try {
                        fileIndex = Integer.parseInt(tm.getToken());
                    }
                    catch (Exception ex) {
                        throw new DebuggerException(5);
                    }
                }
            }
            return new JumpCommand(lineNo, file, fileIndex);
        }
        catch (NumberFormatException e) {
            if (tk.equalsIgnoreCase("-outpar")) {
                return JumpCommand.getJumpOutParagraphInstance();
            }
            if (tk.equalsIgnoreCase("-outprog")) {
                return JumpCommand.getJumpOutProgramInstance();
            }
            if (tk.equalsIgnoreCase("-next")) {
                return JumpCommand.getJumpNextInstance();
            }
            paragraph = this.parseParagraphName(tk, tm);
            return new JumpCommand(paragraph);
        }
    }

    protected DebugResponse setBreakpoint(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseSetBreakpoint(tm));
    }

    protected DebugResponse jump(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseJump(tm));
    }

    protected DebugCommand parseClearBreakpoint(DebugTM tm) throws DebuggerException {
        int s = tm.countTokens();
        if (s < 1) {
            throw new DebuggerException(ClearBreakpointCommand.USAGE);
        }
        int lineNo = 0;
        String paragraph = "";
        String tk = tm.getToken();
        if (tk.equalsIgnoreCase("-a")) {
            return new ClearBreakpointCommand(true);
        }
        try {
            lineNo = Integer.parseInt(tk);
        }
        catch (NumberFormatException e) {
            paragraph = this.parseParagraphName(tk, tm);
        }
        String file = this.currFile;
        tk = tm.getToken();
        if (tk != null) {
            file = this.parseFilename(tk, tm);
        }
        String progName = null;
        int fileIndex = -1;
        tk = tm.getToken();
        if (tk != null) {
            if (tk.equalsIgnoreCase("-fi")) {
                try {
                    fileIndex = Integer.parseInt(tm.getToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                progName = tm.getToken();
            } else {
                progName = tk;
            }
        }
        if (lineNo == 0) {
            String path = "";
            if (this.checkFileOfBreakpoints && (path = this.fileLoader.getAbsolutePath(file)) == null) {
                throw new DebuggerException(4, "'" + file + "'");
            }
            return new ClearBreakpointCommand(paragraph, file, fileIndex, progName, path);
        }
        return new ClearBreakpointCommand(lineNo, file, fileIndex, progName, null);
    }

    protected DebugResponse clearBreakpoint(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseClearBreakpoint(tm));
    }

    private DebugResponse getInfo(DebugTM tm) {
        int code = 0;
        try {
            code = Integer.parseInt(tm.getToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String cls = tm.getToken();
        return this.processCommand(new GetInfoCommand(code, cls));
    }

    protected DebugCommand parseDisplay(DebugTM tm) throws DebuggerException {
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(DisplayCommand.USAGE);
        }
        if (tk.equalsIgnoreCase("-classinfo")) {
            return new DisplayCommand(true);
        }
        boolean hex = false;
        boolean tree = false;
        boolean full = false;
        while (true) {
            if (tk.equalsIgnoreCase("-tree")) {
                tree = true;
            } else if (tk.equalsIgnoreCase("-x")) {
                hex = true;
            } else if (tk.equalsIgnoreCase("-full")) {
                full = true;
            } else {
                if (!tk.equalsIgnoreCase("-env")) break;
                if (tree) {
                    throw new DebuggerException(DisplayCommand.USAGE);
                }
                String key = tm.getToken();
                if (key == null) {
                    throw new DebuggerException(DisplayCommand.USAGE);
                }
                if (!hex && key.equalsIgnoreCase("-x")) {
                    hex = true;
                    key = "";
                }
                tk = tm.getAllToken();
                while (tk != null) {
                    key = key + tk;
                    tk = tm.getAllToken();
                }
                DisplayCommand dc = new DisplayCommand(key.trim(), full);
                dc.setDisplayAsHex(hex);
                return dc;
            }
            tk = tm.getToken();
        }
        String cls = this.getModuleName(tm, tk);
        if (cls != null && (tk = tm.getToken()) == null) {
            throw new DebuggerException(5);
        }
        VarName varname = null;
        tm.ungetToken();
        varname = new VarName(tm);
        if (tree) {
            return new DisplayCommand(varname, cls, hex, full, true);
        }
        tk = tm.getToken();
        String propName = null;
        if (tk != null && (tk.equalsIgnoreCase("prop") || tk.equalsIgnoreCase("property")) && (propName = tm.getToken()) == null) {
            throw new DebuggerException(5);
        }
        if (propName != null) {
            DisplayCommand dc = new DisplayCommand(varname, cls, propName, full);
            dc.setDisplayAsHex(hex);
            return dc;
        }
        return new DisplayCommand(varname, cls, hex, full);
    }

    private String getModuleName(DebugTM tm, String tk) throws DebuggerException {
        String cls = null;
        if (tk.equalsIgnoreCase("-c")) {
            cls = tm.getToken();
            if (cls == null) {
                throw new DebuggerException(5);
            }
            if (cls.equals("\"")) {
                tk = tm.getAllToken();
                while (tk != null && !tk.equals("\"")) {
                    cls = cls + tk;
                    tk = tm.getAllToken();
                }
                tk = tm.getToken();
            } else {
                tk = tm.getAllToken();
                while (tk != null && !tk.equals(" ")) {
                    cls = cls + tk;
                    tk = tm.getAllToken();
                }
            }
        }
        return cls;
    }

    protected DebugCommand parseOffset(DebugTM tm) throws DebuggerException {
        String tk = tm.getToken();
        String cls = this.getModuleName(tm, tk);
        if (cls != null) {
            tk = tm.getToken();
        }
        if (tk == null) {
            throw new DebuggerException(OffsetCommand.USAGE);
        }
        VarName varname = null;
        tm.ungetToken();
        varname = new VarName(tm);
        tk = tm.getToken();
        return new OffsetCommand(varname, cls);
    }

    protected DebugCommand parseLength(DebugTM tm) throws DebuggerException {
        String tk = tm.getToken();
        String cls = this.getModuleName(tm, tk);
        if (cls != null) {
            tk = tm.getToken();
        }
        if (tk == null) {
            throw new DebuggerException(LengthCommand.USAGE);
        }
        VarName varname = null;
        tm.ungetToken();
        varname = new VarName(tm);
        tk = tm.getToken();
        return new LengthCommand(varname, cls);
    }

    protected DebugResponse display(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseDisplay(tm));
    }

    protected DebugResponse offset(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseOffset(tm));
    }

    protected DebugResponse length(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseLength(tm));
    }

    protected DebugCommand parseSetMonitor(DebugTM tm) throws DebuggerException {
        boolean enabled;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(SetMonitorCommand.USAGE);
        }
        String cls = null;
        if (tk.equalsIgnoreCase("-l")) {
            return new SetMonitorCommand(true);
        }
        if (tk.equalsIgnoreCase("-d")) {
            enabled = false;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetMonitorCommand.USAGE);
            }
        } else if (tk.equalsIgnoreCase("-e")) {
            enabled = true;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetMonitorCommand.USAGE);
            }
        } else {
            enabled = defaultMonitorEnabledState;
        }
        if (tk.equalsIgnoreCase("-env")) {
            String key = tm.getToken();
            if (key == null) {
                throw new DebuggerException(5);
            }
            tk = tm.getAllToken();
            while (tk != null && tk.equals("*")) {
                key = key + tk;
                tk = tm.getAllToken();
                if (tk != null) {
                    key = key + tk;
                }
                tk = tm.getAllToken();
            }
            Condition cond = this.getCondition(tm.getToken(), tm, false);
            return new SetMonitorCommand(key, cond, enabled);
        }
        boolean hex = false;
        if (tk.equalsIgnoreCase("-x")) {
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(5);
            }
            hex = true;
        }
        cls = this.getModuleName(tm, tk);
        VarName varname = null;
        if (cls == null) {
            tm.ungetToken();
        }
        varname = new VarName(tm);
        String propName = null;
        tk = tm.getToken();
        if (tk != null && (tk.equalsIgnoreCase("prop") || tk.equalsIgnoreCase("property"))) {
            if (hex) {
                throw new DebuggerException(5);
            }
            propName = tm.getToken();
            if (propName == null) {
                throw new DebuggerException(5);
            }
            tk = tm.getToken();
        }
        Condition cond = this.getCondition(tk, tm, hex);
        if (propName != null) {
            return new SetMonitorCommand(varname, cls, propName, cond, enabled);
        }
        return new SetMonitorCommand(varname, cls, hex, cond, enabled);
    }

    protected DebugResponse setMonitor(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseSetMonitor(tm));
    }

    private Condition getCondition(String tk, DebugTM tm, boolean hex) throws DebuggerException {
        Condition cond = null;
        if (tk != null) {
            if (tk.equalsIgnoreCase("when")) {
                cond = new Condition(tm, hex);
            } else {
                throw new DebuggerException(5);
            }
        }
        return cond;
    }

    protected DebugCommand parseClearMonitor(DebugTM tm) throws DebuggerException {
        String cls = null;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(ClearMonitorCommand.USAGE);
        }
        if (tk.equalsIgnoreCase("-a")) {
            return new ClearMonitorCommand(true);
        }
        if (tk.equalsIgnoreCase("-env")) {
            String key = tm.getToken();
            if (key == null) {
                throw new DebuggerException(5);
            }
            tk = tm.getAllToken();
            while (tk != null) {
                key = key + tk;
                tk = tm.getAllToken();
            }
            return new ClearMonitorCommand(key);
        }
        if (tk.equalsIgnoreCase("-c")) {
            cls = tm.getToken();
            if (cls == null) {
                throw new DebuggerException(5);
            }
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(5);
            }
        }
        VarName varname = null;
        tm.ungetToken();
        varname = new VarName(tm);
        tk = tm.getToken();
        String propName = null;
        if (tk != null && (tk.equalsIgnoreCase("prop") || tk.equalsIgnoreCase("property")) && (propName = tm.getToken()) == null) {
            throw new DebuggerException(5);
        }
        return new ClearMonitorCommand(varname, cls, propName);
    }

    protected DebugResponse clearMonitor(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseClearMonitor(tm));
    }

    private DebugCommand parseLetEnv(DebugTM tm, boolean allowNoValue) throws DebuggerException {
        String value;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(LetCommand.USAGE);
        }
        String key = tk;
        tk = tm.getAllToken();
        while (tk != null && !tk.equals("=")) {
            key = key + tk;
            tk = tm.getAllToken();
        }
        if (tk == null) {
            if (allowNoValue) {
                return new LetCommand(key, null);
            }
            throw new DebuggerException(LetCommand.USAGE);
        }
        tk = tm.getAllToken();
        if (tk == null) {
            value = " ";
        } else {
            StringBuffer sb = new StringBuffer(tk);
            while ((tk = tm.getAllToken()) != null) {
                sb.append(tk);
            }
            value = sb.toString();
        }
        return new LetCommand(key, value);
    }

    protected DebugCommand parseLet(DebugTM tm) throws DebuggerException {
        return this.parseLet(tm, false);
    }

    protected DebugCommand parseLet(DebugTM tm, boolean allowNoValue) throws DebuggerException {
        String value;
        String cls;
        boolean hex = false;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(LetCommand.USAGE);
        }
        if (tk.equalsIgnoreCase("-env")) {
            return this.parseLetEnv(tm, allowNoValue);
        }
        if (tk.equalsIgnoreCase("-x")) {
            hex = true;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(LetCommand.USAGE);
            }
        }
        if ((cls = this.getModuleName(tm, tk)) != null && (tk = tm.getToken()) == null) {
            throw new DebuggerException(5);
        }
        VarName varname = null;
        tm.ungetToken();
        varname = new VarName(tm);
        tk = tm.getToken();
        String propName = null;
        if (tk != null && (tk.equalsIgnoreCase("prop") || tk.equalsIgnoreCase("property"))) {
            if (hex) {
                throw new DebuggerException(5);
            }
            propName = tm.getToken();
            if (propName == null) {
                throw new DebuggerException(5);
            }
            tk = tm.getToken();
        }
        if (tk == null || !tk.equals("=")) {
            if (allowNoValue) {
                if (propName != null) {
                    return new LetCommand(varname, cls, propName, null);
                }
                return new LetCommand(varname, cls, hex, null);
            }
            throw new DebuggerException(LetCommand.USAGE);
        }
        tk = tm.getAllToken();
        if (tk == null) {
            value = " ";
        } else {
            StringBuffer sb = new StringBuffer(tk);
            while ((tk = tm.getAllToken()) != null) {
                sb.append(tk);
            }
            value = sb.toString();
        }
        if (propName != null) {
            return new LetCommand(varname, cls, propName, value);
        }
        return new LetCommand(varname, cls, hex, value);
    }

    protected DebugResponse let(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseLet(tm));
    }

    protected DebugResponse help(DebugTM tm) {
        HelpCommand cmd = this.parseHelp(tm);
        StringBuffer ret = new StringBuffer();
        DebugCommand[] commands = new DebugCommand[standardCommands.length + graphCommands.length];
        System.arraycopy(standardCommands, 0, commands, 0, standardCommands.length);
        System.arraycopy(graphCommands, 0, commands, standardCommands.length, graphCommands.length);
        if (cmd.getCommand() != null) {
            for (int i = 0; i < commands.length; ++i) {
                if (!commands[i].getStringId().equalsIgnoreCase(cmd.getCommand())) continue;
                ret.append(commands[i].getStringId());
                ret.append(commands[i].getShortDescription()).append(eol).append(eol);
                if (commands[i].getUsage() != null && commands[i].getUsage().length() > 0) {
                    ret.append(commands[i].getUsage()).append(eol);
                }
                return new DebugResponse(0, ret.toString());
            }
            return new DebugResponse(1, "Command '" + cmd.getCommand() + "' does not exist" + eol);
        }
        Arrays.sort(commands, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((DebugCommand)o1).getStringId().compareTo(((DebugCommand)o2).getStringId());
            }
        });
        for (int i = 0; i < commands.length; ++i) {
            ret.append(commands[i].getStringId()).append(commands[i].getShortDescription()).append(eol);
        }
        return new DebugResponse(0, ret.toString());
    }

    protected HelpCommand parseHelp(DebugTM tm) {
        return new HelpCommand(tm.getToken());
    }

    protected DebugCommand parseRun(DebugTM tm) {
        if (tm.countAllTokens() > 0) {
            StringBuffer buf = new StringBuffer();
            String tk = tm.getAllToken();
            while (tk != null) {
                buf.append(tk);
                tk = tm.getAllToken();
            }
            StringTokenizer stn = new StringTokenizer(buf.toString().trim(), " \"", true);
            ArrayList<String> args = new ArrayList<String>();
            buf = new StringBuffer();
            boolean openQuote = false;
            while (stn.hasMoreTokens()) {
                String tk2 = stn.nextToken();
                if (tk2.equals(" ")) {
                    if (openQuote) {
                        buf.append(tk2);
                        continue;
                    }
                    args.add(buf.toString());
                    buf = new StringBuffer();
                    continue;
                }
                if (tk2.equals("\"")) {
                    openQuote = !openQuote;
                    continue;
                }
                buf.append(tk2);
            }
            args.add(buf.toString());
            this.programArgs = new String[args.size()];
            args.toArray(this.programArgs);
        }
        return new RunCommand(this.programArgs);
    }

    protected DebugResponse run(DebugTM tm) {
        return this.processCommand(this.parseRun(tm));
    }

    protected DebugCommand parseSetProgramBreakpoint(DebugTM tm) throws DebuggerException {
        boolean enabled;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(ProgramBreakpointCommand.USAGE);
        }
        if (tk.equalsIgnoreCase("-d")) {
            enabled = false;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else if (tk.equalsIgnoreCase("-e")) {
            enabled = true;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else {
            enabled = defaultBreakpointEnabledState;
        }
        String prog = tk;
        tk = tm.getToken();
        Expression cond = null;
        if ("when".equalsIgnoreCase(tk)) {
            cond = (Expression)this.parseBreakpointCondition(tm, enabled);
        }
        return new ProgramBreakpointCommand(prog, enabled, cond);
    }

    protected DebugCommand parseSetMethodBreakpoint(DebugTM tm) throws DebuggerException {
        boolean enabled;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(MethodBreakpointCommand.USAGE);
        }
        if (tk.equalsIgnoreCase("-d")) {
            enabled = false;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else if (tk.equalsIgnoreCase("-e")) {
            enabled = true;
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else {
            enabled = defaultBreakpointEnabledState;
        }
        String methodName = tk;
        if (tk.equals("\"")) {
            tk = tm.getAllToken();
            while (tk != null && !tk.equals("\"")) {
                methodName = methodName + tk;
                tk = tm.getAllToken();
            }
            tk = tm.getToken();
        } else {
            tk = tm.getAllToken();
            while (tk != null && !tk.equalsIgnoreCase("when")) {
                methodName = methodName + tk;
                tk = tm.getAllToken();
            }
        }
        Expression cond = null;
        if (tk != null && "when".equalsIgnoreCase(tk)) {
            cond = (Expression)this.parseBreakpointCondition(tm, enabled);
        }
        return new MethodBreakpointCommand(methodName.trim(), enabled, cond);
    }

    protected DebugCommand parseStepInto(DebugTM tm) {
        String tk = tm.getToken();
        int stepNumber = 1;
        if (tk != null) {
            try {
                stepNumber = Integer.parseInt(tk);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new StepIntoCommand(stepNumber);
    }

    protected DebugResponse setProgramBreakpoint(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseSetProgramBreakpoint(tm));
    }

    protected DebugResponse setMethodBreakpoint(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseSetMethodBreakpoint(tm));
    }

    protected DebugResponse continue0() {
        return this.processCommand(new ContinueCommand());
    }

    protected DebugResponse stepToNextProgram() {
        return this.processCommand(new StepToNextProgramCommand());
    }

    protected DebugResponse stepInto(DebugTM tm) {
        return this.processCommand(this.parseStepInto(tm));
    }

    protected DebugResponse stepOver() {
        return this.processCommand(new StepOverCommand());
    }

    private String getStackInfo0(boolean a) {
        if (this.parStack != null && this.parStack.length > 0) {
            for (ParagraphObject po : this.parStack) {
                this.setSection(po);
            }
            String indent = "";
            StringBuffer ret = new StringBuffer();
            for (ParagraphObject po : this.parStack) {
                ret.append(indent);
                ret.append("+");
                ret.append(" ");
                ret.append(po.getName());
                if (po.getParentSection() != null) {
                    ret.append(" of ");
                    ret.append(po.getParentSection());
                }
                ret.append(" [");
                if (po.getEntryPointName() != null) {
                    ret.append(po.getEntryPointName());
                    ret.append(" of ");
                } else if (po.getMethodName() != null) {
                    ret.append(po.getMethodName());
                    ret.append(" of ");
                }
                ret.append(po.getProgName());
                ret.append("]");
                if (a) {
                    ret.append(" ");
                    String file = po.getFile();
                    if (file != null) {
                        ret.append(file);
                        ret.append(":");
                        ret.append(po.getLine());
                    } else {
                        ret.append(po.getLine());
                    }
                }
                ret.append(eol);
                indent = indent + "  ";
            }
            return ret.toString();
        }
        return null;
    }

    @Override
    public String showLine(int lineNo, String filename) {
        return this.showLine(lineNo, filename, -1);
    }

    @Override
    public String showLine(int lineNo, String filename, int fileIndex) {
        StringBuffer ret = new StringBuffer();
        ret.append(" line=");
        ret.append(lineNo);
        ret.append(" file=");
        ret.append(filename);
        ret.append(eol);
        String line = null;
        if (this.fileLoaderHelper != null) {
            line = this.fileLoaderHelper.getLine(lineNo, filename, fileIndex);
        }
        if (line == null) {
            try {
                line = this.fileLoader.getLine(lineNo, filename, false);
            }
            catch (FileNotFoundException ex) {
                line = "";
            }
        }
        ret.append("   ");
        ret.append(line);
        ret.append(eol);
        return ret.toString();
    }

    protected DebugResponse getLine() {
        return new DebugResponse(0, "+ " + this.showLine(this.currLine, this.currFile, this.currFileIndex), 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DebugCommand parseList(DebugTM tm) throws DebuggerException {
        int endLine;
        int startLine;
        String tk = tm.getTokenAndComma();
        if (tk == null) {
            return new ListCommand(this.selLine + 1, this.selLine + this.listSize);
        }
        if (tk.equalsIgnoreCase("-get")) {
            return ListCommand.Get();
        }
        if (tk.equalsIgnoreCase("-set")) {
            tk = tm.getToken();
            try {
                return ListCommand.Set(Integer.parseInt(tk));
            }
            catch (NumberFormatException e) {
                throw new DebuggerException(5);
            }
        }
        if (tk.equalsIgnoreCase("-f")) {
            return ListCommand.FileList();
        }
        String fileName = null;
        if (tk.equals(",")) {
            LineSpec ls2 = new LineSpec(tm);
            if (ls2.lineNumber <= 0 || ls2.up || ls2.down) {
                throw new DebuggerException(5);
            }
            startLine = 1;
            endLine = ls2.lineNumber;
            return new ListCommand(startLine, endLine, fileName);
        } else {
            tm.ungetToken();
            LineSpec ls1 = new LineSpec(tm);
            if (ls1.up) {
                startLine = ls1.lineNumber == 0 ? this.startSelLine - this.listSize : this.startSelLine - ls1.lineNumber;
                endLine = this.startSelLine - 1;
                return new ListCommand(startLine, endLine, fileName);
            } else if (ls1.down) {
                endLine = ls1.lineNumber == 0 ? this.selLine + this.listSize : this.selLine + ls1.lineNumber;
                startLine = this.selLine + 1;
                return new ListCommand(startLine, endLine, fileName);
            } else if (ls1.lineNumber > 0) {
                fileName = ls1.fileName;
                tk = tm.getTokenAndComma();
                if (tk != null && tk.equals(",")) {
                    startLine = ls1.lineNumber;
                    LineSpec ls2 = new LineSpec(tm);
                    if (ls2.up) {
                        startLine = ls2.lineNumber == 0 ? ls1.lineNumber - this.listSize : ls1.lineNumber - ls2.lineNumber;
                        endLine = ls1.lineNumber - 1;
                        return new ListCommand(startLine, endLine, fileName);
                    } else if (ls2.down) {
                        startLine = ls1.lineNumber + 1;
                        endLine = ls2.lineNumber == 0 ? ls1.lineNumber + this.listSize : ls1.lineNumber + ls2.lineNumber;
                        return new ListCommand(startLine, endLine, fileName);
                    } else {
                        endLine = ls2.isNull ? this.getLineCount(fileName != null ? fileName : this.selFile, false) : ls2.lineNumber;
                    }
                    return new ListCommand(startLine, endLine, fileName);
                } else {
                    startLine = ls1.lineNumber - Math.round((float)this.listSize / 2.0f) + 1;
                    endLine = ls1.lineNumber + this.listSize / 2;
                }
                return new ListCommand(startLine, endLine, fileName);
            } else {
                fileName = ls1.fileName;
                if (ls1.parName != null) {
                    if (this.info == null) throw new DebuggerException("Paragraph '" + ls1.parName + "' not found");
                    String[] filenames = this.info.getFilenames();
                    DebugParagraph[] dps = this.info.getParagraphs();
                    boolean ok = false;
                    Filename fn = fileName != null ? new Filename(fileName) : null;
                    startLine = 0;
                    for (int i = 0; i < dps.length && !ok; ++i) {
                        Filename fn2 = new Filename(filenames[dps[i].getFileIndex()]);
                        if (!dps[i].getParagraphName().equalsIgnoreCase(ls1.parName) || fileName != null && !fn2.equals(fn)) continue;
                        startLine = dps[i].getLineNumber();
                        fileName = fn2.getOrigName();
                        ok = true;
                    }
                    if (!ok) throw new DebuggerException("Paragraph '" + ls1.parName + "' not found");
                    tk = tm.getTokenAndComma();
                    if (tk != null && tk.equals(",")) {
                        LineSpec ls2 = new LineSpec(tm);
                        if (ls2.lineNumber <= 0 || ls2.up || ls2.down) {
                            throw new DebuggerException(5);
                        }
                        endLine = ls2.lineNumber;
                        return new ListCommand(startLine, endLine, fileName);
                    } else {
                        endLine = startLine + this.listSize;
                    }
                    return new ListCommand(startLine, endLine, fileName);
                } else {
                    startLine = ls1.lineNumber - Math.round((float)this.listSize / 2.0f) + 1;
                    endLine = ls1.lineNumber + this.listSize / 2;
                }
            }
        }
        return new ListCommand(startLine, endLine, fileName);
    }

    protected DebugResponse list(DebugTM tm) throws DebuggerException {
        ListCommand lc = (ListCommand)this.parseList(tm);
        return this.list(lc, this.currLine, this.currFile);
    }

    protected DebugResponse list(ListCommand lc, int currLine, String currFile) throws DebuggerException {
        if (lc.isGet()) {
            return new DebugResponse(0, "ListSize: " + this.listSize + eol);
        }
        if (lc.isSet()) {
            this.listSize = lc.getListSize();
            return new DebugResponse(0, "ListSize: " + this.listSize + eol);
        }
        if (lc.isFileList()) {
            if (this.info != null) {
                String[] filenames = this.info.getFilenames();
                StringBuffer msg = new StringBuffer();
                if (filenames.length > 0) {
                    msg.append(filenames[0]);
                    for (int i = 1; i < filenames.length; ++i) {
                        msg.append(eol).append(filenames[i]);
                    }
                }
                msg.append(eol);
                return new DebugResponse(0, msg.toString());
            }
            return new DebugResponse(1, "File List unavailable" + eol);
        }
        String fileName = lc.getFileName();
        if (fileName == null) {
            fileName = this.selFile;
        }
        int[] beginIdx = new int[1];
        String[] listLines = new String[]{};
        int currLineNumber = new Filename(fileName).equals(new Filename(currFile)) ? currLine : -1;
        int fromLine = lc.getFromLine();
        int toLine = lc.getToLine();
        try {
            int lineCount = this.fileLoader.getLineCount(fileName, false);
            int diff = 1 - fromLine;
            if (diff > 0) {
                fromLine = 1;
                toLine += diff;
            } else {
                diff = toLine - lineCount;
                if (diff > 0) {
                    toLine = lineCount;
                    fromLine -= diff;
                }
            }
            if (toLine > lineCount) {
                toLine = lineCount;
            }
            if (fromLine < 1) {
                fromLine = 1;
            }
            listLines = this.fileLoader.list(fileName, fromLine, toLine, beginIdx, false);
            this.startSelLine = fromLine;
            this.selLine = toLine;
            this.selFile = fileName;
        }
        catch (FileNotFoundException ex) {
            StringBuffer err = new StringBuffer();
            err.append("File '").append(fileName).append("' not found").append(eol);
            err.append("Make sure the directory containing this file is listed in CLASSPATH or in ");
            err.append("iscobol.debug.code_prefix");
            err.append(eol);
            return new DebugResponse(1, err.toString());
        }
        return new DebugResponse(0, DebuggerInvoker.formatLines(listLines, fromLine, currLineNumber, this.selFile), 8);
    }

    private static String normalizeString(String str) {
        return str.replace('_', '-').toUpperCase();
    }

    private String getLine(int lineNumber, String fileName, boolean reload) throws FileNotFoundException {
        return this.fileLoader.getLine(lineNumber, fileName, reload);
    }

    private int getLineCount(String fileName, boolean reload) {
        try {
            return this.fileLoader.getLineCount(fileName, false);
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    protected DebugResponse directory(DirectoryCommand cmd) {
        String dirname = cmd.getDirectory();
        String codePrefix = Config.getProperty(".debug.code_prefix", null);
        if (dirname != null) {
            if (codePrefix != null) {
                codePrefix = dirname + ";" + codePrefix;
                Config.setProperty(".debug.code_prefix", codePrefix);
            } else {
                codePrefix = dirname;
                Config.setProperty(".debug.code_prefix", codePrefix);
            }
            this.fileLoader = new FileLoader(this);
        }
        return new DebugResponse(0, "debug.code_prefix = " + codePrefix + eol);
    }

    private int find(boolean back, boolean top) throws FileNotFoundException {
        int i;
        String text = DebuggerInvoker.normalizeString(this.lastFind);
        int len = text.length();
        int lineIndex = this.selLine;
        int position = this.selPos;
        if (top) {
            lineIndex = 1;
            position = 0;
        }
        if (back) {
            int rc;
            String s = this.getLine(lineIndex, this.selFile, false);
            if (position < s.length()) {
                s = s.substring(0, position);
            }
            if ((rc = (s = DebuggerInvoker.normalizeString(s)).lastIndexOf(text)) >= 0 && rc + text.length() == s.length()) {
                s = s.substring(0, s.length() - text.length());
                rc = s.lastIndexOf(text);
            }
            if (rc >= 0) {
                this.selPos = rc + len;
                this.setSelLine(lineIndex);
                return this.selLine;
            }
            for (int i2 = lineIndex - 1; i2 > 0; --i2) {
                s = DebuggerInvoker.normalizeString(this.getLine(i2, this.selFile, false));
                rc = s.lastIndexOf(text);
                if (rc < 0) continue;
                this.setSelLine(i2);
                this.selPos = rc + len;
                return this.selLine;
            }
            int numLines = this.getLineCount(this.selFile, false);
            position = 0;
            for (int i3 = numLines; i3 >= lineIndex; --i3) {
                s = DebuggerInvoker.normalizeString(this.getLine(i3, this.selFile, false));
                rc = s.lastIndexOf(text);
                if (rc < 0) continue;
                this.setSelLine(i3);
                this.selPos = rc + len;
                return this.selLine;
            }
            return -1;
        }
        String s = DebuggerInvoker.normalizeString(this.getLine(lineIndex, this.selFile, false));
        int rc = s.indexOf(text, position);
        if (rc >= 0) {
            this.setSelLine(lineIndex);
            this.selPos = rc + len;
            return this.selLine;
        }
        int numLines = this.getLineCount(this.selFile, false);
        for (i = lineIndex + 1; i <= numLines; ++i) {
            s = DebuggerInvoker.normalizeString(this.getLine(i, this.selFile, false));
            rc = s.indexOf(text);
            if (rc < 0) continue;
            this.setSelLine(i);
            this.selPos = rc + len;
            return this.selLine;
        }
        position = 0;
        for (i = 1; i <= lineIndex; ++i) {
            s = DebuggerInvoker.normalizeString(this.getLine(i, this.selFile, false));
            rc = s.indexOf(text);
            if (rc < 0) continue;
            this.setSelLine(i);
            this.selPos = rc + len;
            return this.selLine;
        }
        return -1;
    }

    protected DebugCommand parseAutoOn(DebugTM tm) throws DebuggerException {
        String tk = tm.getToken();
        if (tk == null) {
            return new AutoOnCommand();
        }
        if (tk.equalsIgnoreCase("-get")) {
            return AutoOnCommand.Get();
        }
        if (tk.equalsIgnoreCase("-set")) {
            tk = tm.getToken();
            try {
                return AutoOnCommand.Set(Double.parseDouble(tk));
            }
            catch (NumberFormatException e) {
                throw new DebuggerException(5);
            }
        }
        try {
            return new AutoOnCommand(Double.parseDouble(tk));
        }
        catch (NumberFormatException e) {
            throw new DebuggerException(5);
        }
    }

    protected DirectoryCommand parseDirectory(DebugTM tm) throws DebuggerException {
        String dirname = "";
        tm.getAllToken();
        String tk = tm.getAllToken();
        while (tk != null) {
            dirname = dirname + tk;
            tk = tm.getAllToken();
        }
        if (dirname.trim().length() == 0) {
            return new DirectoryCommand();
        }
        File f = new File(dirname);
        if (!f.exists() || !f.isDirectory()) {
            throw new DebuggerException(1, ": invalid directory name");
        }
        return new DirectoryCommand(dirname);
    }

    protected StackInfoCommand parseStackInfo(DebugTM tm) throws DebuggerException {
        boolean a = "-a".equalsIgnoreCase(tm.getToken());
        return new StackInfoCommand(a);
    }

    protected String parseFind(DebugTM tm) {
        String text = "";
        tm.getAllToken();
        String tk = tm.getAllToken();
        while (tk != null) {
            text = text + tk;
            tk = tm.getAllToken();
        }
        return text;
    }

    protected DebugResponse find(DebugTM tm, boolean back, boolean top, int cmdId) {
        this.lastFind = this.parseFind(tm);
        return this.find(back, top, cmdId);
    }

    protected DebugResponse find(boolean back, boolean top, int cmdId) {
        if (this.lastFind != null && this.lastFind.length() > 0) {
            try {
                int idx = this.find(back, top);
                if (idx > 0) {
                    int i;
                    int pad = Integer.toString(idx).length();
                    StringBuffer line = new StringBuffer(DebuggerInvoker.formatLine(this.getLine(idx, this.selFile, false), idx, false, this.selFile));
                    if (this.selFile != null) {
                        pad += this.selFile.length();
                    }
                    int startPos = this.selPos - this.lastFind.length() + pad + 3;
                    for (i = 0; i < startPos; ++i) {
                        line.append(' ');
                    }
                    for (i = startPos; i < startPos + this.lastFind.length(); ++i) {
                        line.append('^');
                    }
                    return new DebugResponse(0, line.toString() + eol, cmdId);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return new DebugResponse(1, "'" + this.lastFind + "' not found" + eol);
        }
        return new DebugResponse(1, "");
    }

    protected DebugResponse firstLine() {
        int lineNumber = 1;
        String fileName = this.selFile;
        if (this.info != null && this.info.getFilenames() != null && this.info.getFilenames().length > 0) {
            fileName = this.info.getFilenames()[0];
        }
        try {
            String firstLine = this.getLine(lineNumber, fileName, false);
            this.setSelLine(lineNumber);
            this.selFile = fileName;
            this.selPos = 0;
            return new DebugResponse(0, DebuggerInvoker.formatLine(firstLine, 1, false, this.selFile));
        }
        catch (FileNotFoundException e) {
            return new DebugResponse(1, "");
        }
    }

    protected DebugResponse firstExecLine() {
        DebugParagraph p;
        DebugParagraph[] pars;
        if (this.info != null && (pars = this.info.getParagraphs()) != null && (p = DebuggerInvoker.getFirstParagraphNoDecl(pars)) != null) {
            try {
                int lineNumber = p.getLineNumber();
                String fileName = this.info.getFilenames()[p.getFileIndex()];
                String firstExLine = this.getLine(lineNumber, fileName, false);
                this.setSelLine(lineNumber);
                this.selFile = fileName;
                this.selPos = 0;
                return new DebugResponse(0, DebuggerInvoker.formatLine(firstExLine, p.getLineNumber(), false, this.selFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return new DebugResponse(1, "");
    }

    protected DebugResponse down() throws DebuggerException {
        ParagraphObject po;
        if (this.parStack != null && this.parStack.length > 0) {
            if (this.selStackFrameIndex == -1) {
                po = this.parStack[this.parStack.length - 1];
                this.selStackFrameIndex = this.parStack.length - 1;
            } else if (this.selStackFrameIndex > 0) {
                po = this.parStack[this.selStackFrameIndex - 1];
                --this.selStackFrameIndex;
            } else {
                po = this.parStack[this.selStackFrameIndex];
            }
        } else {
            po = null;
        }
        if (po != null) {
            ListCommand lc = new ListCommand(po.getLine(), po.getLine() + this.listSize, po.getFile());
            return this.list(lc, po.getLine(), po.getFile());
        }
        return new DebugResponse(1, "lower stack frame unavailable" + eol);
    }

    protected DebugResponse up() throws DebuggerException {
        ParagraphObject po;
        if (this.parStack != null && this.parStack.length > 0) {
            if (this.selStackFrameIndex == -1) {
                po = this.parStack[this.parStack.length - 1];
                this.selStackFrameIndex = this.parStack.length - 1;
            } else if (this.selStackFrameIndex < this.parStack.length - 1) {
                po = this.parStack[this.selStackFrameIndex + 1];
                ++this.selStackFrameIndex;
            } else {
                po = this.parStack[this.selStackFrameIndex];
            }
        } else {
            po = null;
        }
        if (po != null) {
            ListCommand lc = new ListCommand(po.getLine(), po.getLine() + this.listSize, po.getFile());
            return this.list(lc, po.getLine(), po.getFile());
        }
        return new DebugResponse(1, "higher stack frame unavailable" + eol);
    }

    protected DebugResponse currLine() {
        int lineNumber = this.currLine;
        String fileName = this.currFile;
        try {
            String line = this.getLine(lineNumber, fileName, false);
            this.setSelLine(lineNumber);
            this.selFile = fileName;
            this.selPos = 0;
            return new DebugResponse(0, DebuggerInvoker.formatLine(line, this.selLine, false, this.selFile));
        }
        catch (FileNotFoundException e) {
            return new DebugResponse(1, "");
        }
    }

    protected DebugResponse lastLine() {
        try {
            String fileName;
            if (this.info != null) {
                fileName = this.info.getFilenames()[0];
                if (this.info.getCopyfiles() != null && this.info.getCopyfiles().length > 0) {
                    DebugCopyFile[] dcfs = this.info.getCopyfiles();
                    Filename fn = new Filename(fileName);
                    int lineCount = this.fileLoader.getLineCount(fileName, false);
                    for (int i = dcfs.length - 1; i >= 0; --i) {
                        if (!new Filename(dcfs[i].getParentFileName()).equals(fn)) continue;
                        if (dcfs[i].getCopyStatementLineNumber() >= lineCount) {
                            fileName = dcfs[i].getCopyFileName();
                            fn = new Filename(fileName);
                            lineCount = this.fileLoader.getLineCount(fileName, false);
                            i = dcfs.length;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                fileName = this.currFile;
            }
            int lineNumber = this.getLineCount(fileName, false);
            String lastLine = this.getLine(lineNumber, fileName, false);
            this.setSelLine(lineNumber);
            this.selPos = 0;
            this.selFile = fileName;
            return new DebugResponse(0, DebuggerInvoker.formatLine(lastLine, lineNumber, false, this.selFile));
        }
        catch (FileNotFoundException e) {
            return new DebugResponse(1, "");
        }
    }

    private static String formatLine(String line, int lineNumber, boolean isCurrent, String fileName) {
        return DebuggerInvoker.formatLines(new String[]{line}, lineNumber, isCurrent ? lineNumber : -1, fileName);
    }

    private static String formatLines(String[] lines, int startLineNumber, int currentLineNumber, String fileName) {
        StringBuffer buf = new StringBuffer();
        int pad = Integer.toString(startLineNumber + lines.length - 1).length();
        int i = 0;
        int lineNumber = startLineNumber;
        while (i < lines.length) {
            String lineNumberStr = Integer.toString(lineNumber);
            for (int j = 0; j < pad - lineNumberStr.length(); ++j) {
                buf.append('0');
            }
            buf.append(lineNumberStr);
            if (fileName != null) {
                buf.append(':');
                buf.append(fileName);
            }
            if (lineNumber == currentLineNumber) {
                buf.append('<');
            } else {
                buf.append(' ');
            }
            buf.append(' ');
            buf.append(lines[i]);
            buf.append(eol);
            ++i;
            ++lineNumber;
        }
        return buf.toString();
    }

    protected DebugResponse stepOutOfParagraph() {
        return this.processCommand(new StepOutParagraphCommand());
    }

    protected DebugResponse stepOutOfProgram() {
        return this.processCommand(new StepOutProgramCommand());
    }

    protected DebugResponse getStackInfo(boolean a) {
        String stackInfo = this.getStackInfo0(a);
        if (stackInfo != null) {
            return new DebugResponse(0, stackInfo);
        }
        return new DebugResponse(1, "stack info unavailable" + eol);
    }

    protected DebugResponse quit() {
        return this.processCommand(new QuitCommand());
    }

    protected DebugCommand parseTraceOn(DebugTM tm) throws DebuggerException {
        String logfile = null;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(TraceOnCommand.USAGE);
        }
        int tracelevel = 0;
        try {
            tracelevel = Integer.parseInt(tk);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        tk = tm.getToken();
        if (tk != null) {
            logfile = this.parseFilename(tk, tm);
        }
        return new TraceOnCommand(tracelevel, logfile);
    }

    protected DebugResponse traceOn(DebugTM tm) throws DebuggerException {
        return this.processCommand(this.parseTraceOn(tm));
    }

    protected DebugResponse traceOff() {
        return this.processCommand(new TraceOffCommand());
    }

    @Override
    public DebugResponse exit() {
        return this.processCommand(new ExitCommand());
    }

    public static void main(String[] argv) {
        int portNumber = Integer.parseInt(argv[0]);
        Config.startDebugListener(2, portNumber, true, false, 0);
        Debugger.activeRemoteDebugging();
        String className = argv[1];
        String[] classArguments = new String[argv.length - 2];
        if (classArguments.length > 0) {
            System.arraycopy(argv, 2, classArguments, 0, classArguments.length);
        }
        Debugger.init(className, classArguments);
    }

    public void setCurrFile(String cf) {
        this.currFile = this.selFile = this.getRealPath(cf);
        this.currFileIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFreePort() {
        while (true) {
            ServerSocket ss = null;
            try {
                int Return2;
                ss = new ServerSocket(0);
                int n = Return2 = ss.getLocalPort();
                return n;
            }
            catch (IOException iOException) {}
            continue;
            finally {
                if (ss == null) continue;
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    @Override
    public int launchIsCobolProgram(String[] argv) {
        try {
            int i;
            String CS_TIMEOUT_PROP = "-Discobol.gui.cstimeout=";
            Vector<String> myargs = new Vector<String>();
            String javaHome = System.getProperty("java.home");
            String javaCmd = javaHome != null ? javaHome + "/bin/java" : "java";
            myargs.addElement(javaCmd);
            for (i = 0; i < argv.length && argv[i].startsWith("-"); ++i) {
                myargs.addElement(argv[i]);
            }
            myargs.addElement("-Discobol.gui.cstimeout=0");
            myargs.addElement("-cp");
            myargs.addElement(System.getProperty("java.class.path"));
            myargs.addElement(DebuggerInvoker.class.getName());
            int freePort = DebuggerInvoker.getFreePort();
            myargs.addElement(Integer.toString(freePort));
            while (i < argv.length) {
                myargs.addElement(argv[i]);
                ++i;
            }
            argv = new String[myargs.size()];
            myargs.toArray(argv);
            this.process = Runtime.getRuntime().exec(argv);
            activeProcesses.add(this.process);
            new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader r = new BufferedReader(new InputStreamReader(DebuggerInvoker.this.process.getInputStream()));
                        String s = r.readLine();
                        while (s != null) {
                            System.out.println(s);
                            s = r.readLine();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader r = new BufferedReader(new InputStreamReader(DebuggerInvoker.this.process.getErrorStream()));
                        String s = r.readLine();
                        while (s != null) {
                            System.err.println(s);
                            s = r.readLine();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
            return freePort;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public DebugResponse invokeRemote(String host, int port, int attemptNumber, boolean loadMetadata) {
        return this.invokeRemote(host, port, attemptNumber, loadMetadata, null);
    }

    public DebugResponse invokeRemote(String host, int port) {
        return this.invokeRemote(host, port, 1, false, null);
    }

    @Override
    public DebugResponse invokeRemote(String host, int port, int attemptNumber, boolean loadMetadata, PrintStream out) {
        for (int i = 0; i < attemptNumber; ++i) {
            try {
                this.dbgSocket = new Socket(host, port);
                break;
            }
            catch (UnknownHostException e1) {
                return new DebugResponse(106, "");
            }
            catch (IOException e1) {
                if (i >= attemptNumber - 1) continue;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (this.dbgSocket == null) {
            return new DebugResponse(106, "");
        }
        try {
            OutputStream dbgOut = this.dbgSocket.getOutputStream();
            InputStream dbgIn = this.dbgSocket.getInputStream();
            this.outputThread = new OutputChild(dbgIn, out);
            this.inputThread = new InputChild(dbgOut);
            DebugResponse resp = this.outputThread.getResponse(-1);
            if (!resp.isErrorCode()) {
                if (resp.getInfo() != null) {
                    this.putLocalDebugInfo(resp.getInfo().getClassName(), 991, this.createLocalDebugInfo(resp), loadMetadata);
                }
            } else {
                this.exitDebug();
            }
            this.remoteHost = host;
            this.remotePort = port;
            return resp;
        }
        catch (IOException ioe) {
            return new DebugResponse(106, "");
        }
    }

    public void putLocalDebugInfo(String className, int code, LocalDebugInfo info, boolean loadMetadata) {
        String[] fns;
        this.debugInfos.put(className + "$" + code, info);
        if (info.getListingInfos() != null && (fns = info.getFilenames()) != null && fns != null) {
            for (String s : fns) {
                File f = new File(s);
                this.loadedFilePaths.add(f);
                if (f.getParent() == null) continue;
                this.loadedFilePaths.add(new File(f.getName()));
            }
        }
        if (loadMetadata) {
            info.loadMetadata(true);
        }
    }

    public LocalDebugInfo getLocalDebugInfo(String className, int code) {
        return this.debugInfos.get(className + "$" + code);
    }

    public boolean isPathLoaded(File path) {
        return this.loadedFilePaths.contains(path);
    }

    public LocalDebugInfo createLocalDebugInfo(DebugResponse resp) {
        if (resp != null && resp.getInfo() != null) {
            if (resp.getInfo().getErrorString() != null) {
                return new LocalDebugInfo(resp.getInfo().getErrorString());
            }
            return new LocalDebugInfo(this, resp.getInfo());
        }
        return null;
    }

    @Override
    public DebugResponse processCommand(IDebugCommand cmd) {
        if (!(cmd instanceof DebugCommand)) {
            throw new IllegalArgumentException("" + cmd);
        }
        return this.processCommand((DebugCommand)cmd);
    }

    public DebugResponse processCommand(DebugCommand cmd) {
        this.inputThread.setCommand(cmd);
        return this.update(cmd, this.outputThread.getResponse(0));
    }

    @Override
    public DebugResponse getResponse() {
        return this.getResponse(0);
    }

    @Override
    public DebugResponse getResponse(int blockingMode) {
        if (this.outputThread != null) {
            DebugResponse resp = this.outputThread.getResponse(blockingMode);
            this.update(resp);
            return resp;
        }
        return new DebugResponse(103, "");
    }

    @Override
    public void putInput(String s) {
        try {
            this.inputThread.putInput(s);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    @Override
    public void suspend() {
        if (this.inputThread != null) {
            this.inputThread.setCommand(new SuspendCommand());
        }
    }

    @Override
    public void exitDebug() {
        this.exitDebug(false);
    }

    public void exitDebug(boolean forceStopRun) {
        if (forceStopRun && this.inputThread != null && this.outputThread != null) {
            this.inputThread.setCommand(new ExitCommand(true));
            this.outputThread.getResponse(0);
        }
        if (this.outputThread != null) {
            this.outputThread.stop();
            this.outputThread = null;
        }
        if (this.inputThread != null) {
            this.inputThread.stop();
            this.inputThread = null;
        }
        if (this.dbgSocket != null) {
            try {
                this.dbgSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dbgSocket = null;
            this.remoteHost = null;
            this.remotePort = 0;
        }
        if (this.process != null) {
            this.process.destroy();
            activeProcesses.remove(this.process);
            this.process = null;
        }
    }

    @Override
    public boolean isRemoteDebug() {
        return this.process == null && this.dbgSocket != null;
    }

    @Override
    public String getRemoteFileContents(String path) {
        DebugResponse resp;
        if (this.isRemoteDebug() && (resp = this.processCommand(new GetFileCommand(path))) != null && resp.getReturnCode() == 0) {
            return resp.getMessage();
        }
        return null;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    public LocalDebugInfo getInfo(String className, boolean processing, boolean loadMetadata) {
        return this.getInfo(className, processing, loadMetadata, true);
    }

    public LocalDebugInfo getInfo(String className, boolean processing, boolean loadMetadata, boolean checkTimestamp) {
        boolean canGetInfo = this.isRunning() && !processing;
        DebugResponse resp = null;
        LocalDebugInfo Return2 = null;
        int code = 991;
        if (className != null) {
            GetInfoCommand cmd;
            DebugResponse.DebugInfo tmstInfo;
            Return2 = this.getLocalDebugInfo(className, code);
            if (Return2 == null) {
                GetInfoCommand cmd2;
                if (canGetInfo && (Return2 = this.createLocalDebugInfo(resp = this.processCommand(cmd2 = new GetInfoCommand(code, className)))) != null) {
                    this.putLocalDebugInfo(className, code, Return2, loadMetadata);
                }
            } else if (canGetInfo && checkTimestamp && (tmstInfo = this.processCommand(cmd = new GetInfoCommand(64, className)).getInfo()) != null && tmstInfo.getTimestamp() > Return2.getTimestamp() && (Return2 = this.createLocalDebugInfo(resp = this.processCommand(cmd = new GetInfoCommand(code, className)))) != null) {
                this.putLocalDebugInfo(className, code, Return2, loadMetadata);
            }
        } else if (canGetInfo) {
            GetInfoCommand cmd = new GetInfoCommand(code, className);
            resp = this.processCommand(cmd);
            Return2 = this.createLocalDebugInfo(resp);
        }
        return Return2;
    }

    @Override
    public boolean isRunning() {
        return this.process != null || this.dbgSocket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeCommand load(String filename, Vector breakpoints, Vector watches, Vector vars, String[] chainingString) {
        boolean cfb = this.checkFileOfBreakpoints;
        this.checkFileOfBreakpoints = false;
        FileInputStream is = null;
        Breakpoint[] bps = null;
        Watch[] ws = null;
        Tree[] tree = null;
        CompositeCommand cmd = null;
        try {
            String cmdStr;
            is = new FileInputStream(filename);
            DebugResponse r = null;
            SessionProperties props = new SessionProperties();
            RtsUtil.loadProperties((Properties)props, is);
            if (chainingString != null && chainingString.length > 0) {
                chainingString[0] = props.getChainingString();
            }
            Vector<DebugCommand> cmdList = new Vector<DebugCommand>();
            Iterator keys = props.breakpointKeys();
            while (keys.hasNext()) {
                cmdStr = props.getProperty((String)keys.next());
                try {
                    cmdList.addElement(this.parseCommand(cmdStr));
                }
                catch (DebuggerException debuggerException) {}
            }
            keys = props.monitorKeys();
            while (keys.hasNext()) {
                cmdStr = props.getProperty((String)keys.next());
                try {
                    cmdList.addElement(this.parseCommand(cmdStr));
                }
                catch (DebuggerException debuggerException) {}
            }
            keys = props.displayKeys();
            while (keys.hasNext()) {
                cmdStr = props.getProperty((String)keys.next());
                try {
                    DisplayCommand dc = (DisplayCommand)this.parseCommand(cmdStr);
                    dc.setDeferredIfNotRunning(true);
                    cmdList.addElement(dc);
                }
                catch (DebuggerException debuggerException) {}
            }
            cmd = new CompositeCommand(cmdList);
            if (!cmdList.isEmpty() && (r = this.processCommand(cmd)) != null) {
                if (r.getBreakpoints() != null) {
                    bps = r.getBreakpoints();
                }
                if (r.getMonitors() != null) {
                    ws = r.getMonitors();
                }
                if (r.getTrees() != null) {
                    tree = r.getTrees();
                }
            }
        }
        catch (IOException e) {
            CompositeCommand compositeCommand = null;
            return compositeCommand;
        }
        finally {
            this.checkFileOfBreakpoints = cfb;
        }
        if (bps != null && breakpoints != null) {
            breakpoints.addAll(Arrays.asList(bps));
        }
        if (ws != null && watches != null) {
            watches.addAll(Arrays.asList(ws));
        }
        if (vars != null && tree != null) {
            vars.addAll(Arrays.asList(tree));
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(String filename, Breakpoint[] bps, Watch[] ws, String[] vars, String chainingString) {
        try (PrintStream os = null;){
            int i;
            os = new PrintStream(new FileOutputStream(filename));
            SessionProperties props = new SessionProperties();
            if (bps != null) {
                for (i = 0; i < bps.length; ++i) {
                    props.storeBreakpoint(bps[i]);
                }
            }
            if (ws != null) {
                for (i = 0; i < ws.length; ++i) {
                    props.storeMonitor(ws[i]);
                }
            }
            if (vars != null) {
                for (i = 0; i < vars.length; ++i) {
                    props.storeDisplay(vars[i]);
                }
            }
            if (chainingString != null) {
                props.storeChainingString(chainingString);
            }
            props.store(os, "isCOBOL Debugger Session");
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean isAlive() {
        if (this.outputThread != null) {
            return this.outputThread.isAlive();
        }
        return false;
    }

    public static boolean isDefaultMonitorEnabledState() {
        return defaultMonitorEnabledState;
    }

    public static void setDefaultMonitorEnabledState(boolean defaultMonitorEnabledState) {
        DebuggerInvoker.defaultMonitorEnabledState = defaultMonitorEnabledState;
    }

    public static boolean isDefaultBreakpointEnabledState() {
        return defaultBreakpointEnabledState;
    }

    public static void setDefaultBreakpointEnabledState(boolean defaultBreakpointEnabledState) {
        DebuggerInvoker.defaultBreakpointEnabledState = defaultBreakpointEnabledState;
    }

    public FileLoaderHelper getFileLoaderHelper() {
        return this.fileLoaderHelper;
    }

    public void setFileLoaderHelper(FileLoaderHelper fileLoaderHelper) {
        this.fileLoaderHelper = fileLoaderHelper;
    }

    @Override
    public FileLoader getFileLoader() {
        return this.fileLoader;
    }

    @Override
    public String getRealPath(String fn) {
        if (fn == null || fn.length() == 0) {
            return fn;
        }
        File f = new File(fn);
        if (this.isPathLoaded(f)) {
            return fn;
        }
        if (this.isPathLoaded(new File(f.getName()))) {
            return f.getName();
        }
        String Return2 = fn;
        if (!f.exists() && this.getFileLoader() != null && (fn = this.getFileLoader().getAbsolutePath(f.getName())) != null) {
            Return2 = fn;
        }
        return Return2;
    }

    @Override
    public String getRemoteEncoding() {
        return this.outputThread != null ? this.outputThread.getRemoteEncoding() : null;
    }

    static DebugParagraph getFirstParagraphNoDecl(DebugParagraph[] pars) {
        if (pars != null) {
            for (DebugParagraph p : pars) {
                if (p.isInDeclaratives()) continue;
                return p;
            }
        }
        return null;
    }

    static {
        System.arraycopy(graphCommands, 0, defCommands, 0, graphCommands.length);
        System.arraycopy(standardCommands, 0, defCommands, graphCommands.length, standardCommands.length);
        activeProcesses = new Vector();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < activeProcesses.size(); ++i) {
                    ((Process)activeProcesses.elementAt(i)).destroy();
                }
            }
        });
        defaultMonitorEnabledState = false;
        defaultBreakpointEnabledState = true;
    }

    private static class LineSpec {
        String fileName;
        String parName;
        boolean down;
        boolean up;
        int lineNumber;
        boolean isNull;

        LineSpec(DebugTM tm) throws DebuggerException {
            String tk = tm.getToken();
            this.isNull = tk == null;
            if (this.isNull) {
                return;
            }
            if (tk.equals("+")) {
                this.down = true;
                tk = tm.getToken();
                if (tk != null) {
                    try {
                        this.lineNumber = Integer.parseInt(tk);
                    }
                    catch (NumberFormatException e) {
                        tm.ungetToken();
                    }
                } else {
                    tm.ungetToken();
                }
            } else if (tk.equals("-")) {
                this.up = true;
            } else {
                if (tk.startsWith("-")) {
                    this.up = true;
                    try {
                        this.lineNumber = Integer.parseInt(tk.substring(1));
                    }
                    catch (NumberFormatException e) {
                        throw new DebuggerException(5);
                    }
                }
                try {
                    this.lineNumber = Integer.parseInt(tk);
                }
                catch (NumberFormatException e) {
                    String tk0 = tk;
                    DebugTM.Marker mk = tm.setMarker();
                    StringBuffer fileName = new StringBuffer(tk);
                    tk = tm.getAllToken();
                    while (tk != null && !tk.equals(":") && !tk.equals(",")) {
                        fileName.append(tk);
                        tk = tm.getToken();
                    }
                    if (tk != null && tk.equals(":")) {
                        this.fileName = fileName.toString();
                        tk = tm.getToken();
                        if (tk == null) {
                            this.lineNumber = 1;
                        } else {
                            try {
                                this.lineNumber = Integer.parseInt(tk);
                            }
                            catch (NumberFormatException e0) {
                                this.parName = tk;
                            }
                        }
                    }
                    this.parName = tk0;
                    tm.rewindToMarker(mk);
                }
            }
        }
    }

    private static class SessionProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        static final String BREAKPOINT_PREFIX = "breakpoint";
        static final String MONITOR_PREFIX = "monitor";
        static final String DISPLAY_PREFIX = "display";
        int prog;

        private SessionProperties() {
        }

        Iterator breakpointKeys() {
            return this.keys(BREAKPOINT_PREFIX);
        }

        Iterator monitorKeys() {
            return this.keys(MONITOR_PREFIX);
        }

        Iterator displayKeys() {
            return this.keys(DISPLAY_PREFIX);
        }

        Iterator keys(String prefix) {
            TreeSet<String> v = new TreeSet<String>();
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement().toString();
                if (!key.startsWith(prefix)) continue;
                v.add(key);
            }
            return v.iterator();
        }

        String getChainingString() {
            return this.getProperty("chaining");
        }

        String createKey(String pfx) {
            StringBuffer sb = new StringBuffer(pfx);
            String p = Integer.toString(++this.prog);
            for (int i = 0; i < 4 - p.length(); ++i) {
                sb.append('0');
            }
            sb.append(p);
            return sb.toString();
        }

        void storeBreakpoint(Breakpoint bp) {
            this.setProperty(this.createKey(BREAKPOINT_PREFIX), bp.getDebugCommand());
        }

        void storeMonitor(Watch w) {
            this.setProperty(this.createKey(MONITOR_PREFIX), w.getDebugCommand());
        }

        void storeDisplay(String vn) {
            this.setProperty(this.createKey(DISPLAY_PREFIX), vn);
        }

        void storeChainingString(String cs) {
            this.setProperty("chaining", cs);
        }
    }
}

