/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IDebugLine;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DebugLine
implements IDebugLine,
DataExternalizable {
    private static final long serialVersionUID = 1000007L;
    private int lineNumber;
    private int fileIndex;
    private int paragraphId;
    private boolean isInDeclaratives;

    public DebugLine() {
    }

    public DebugLine(String s) {
        StringTokenizer stn = new StringTokenizer(s);
        if (stn.hasMoreTokens()) {
            this.lineNumber = Integer.parseInt(stn.nextToken());
            if (stn.hasMoreTokens()) {
                this.fileIndex = Integer.parseInt(stn.nextToken());
            }
        }
    }

    public DebugLine(int lineNumber, int fileIndex) {
        this.lineNumber = lineNumber;
        this.fileIndex = fileIndex;
    }

    public DebugLine(int lineNumber, int fileIndex, int paragraphId) {
        this.lineNumber = lineNumber;
        this.fileIndex = fileIndex;
        this.paragraphId = paragraphId;
    }

    public DebugLine(int lineNumber, int fileIndex, int paragraphId, boolean isInDeclaratives) {
        this.lineNumber = lineNumber;
        this.fileIndex = fileIndex;
        this.paragraphId = paragraphId;
        this.isInDeclaratives = isInDeclaratives;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    @Override
    public int getParagraphId() {
        return this.paragraphId;
    }

    @Override
    public boolean isInDeclaratives() {
        return this.isInDeclaratives;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.lineNumber);
        out.writeInt(this.fileIndex);
        out.writeInt(this.paragraphId);
        out.writeBoolean(this.isInDeclaratives);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.lineNumber = in.readInt();
        this.fileIndex = in.readInt();
        this.paragraphId = in.readInt();
        this.isInDeclaratives = in.readBoolean();
    }

    public String toString() {
        return "DebugLine(" + this.lineNumber + "," + this.fileIndex + "," + this.paragraphId + "," + this.isInDeclaratives + ")";
    }
}

