/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Debugger;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class ConnectionListener
implements Runnable {
    private Thread t;
    private int port;
    private boolean remote;
    private volatile boolean stopRun;
    private Socket clientSocket;
    private ServerSocket serverSocket;
    private final Logger log;

    public ConnectionListener(int port, boolean remote) {
        this.port = port;
        this.remote = remote;
        this.log = LoggerFactory.getCurrLog();
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        this.t = new Thread(threadGroup, this);
        this.t.setDaemon(true);
        this.t.setName(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Config.markNoIscobolRuntimeThread();
        try {
            this.serverSocket = new ServerSocket(this.port);
            if (this.remote) {
                System.err.println("Debugger listening on port " + this.port + " ...");
            }
            if (this.log != null) {
                this.log.info("Execution waiting Debugger connection on port " + this.port);
            }
            while (!this.stopRun) {
                Socket s = null;
                try {
                    s = this.serverSocket.accept();
                }
                catch (SocketException ex) {
                    return;
                }
                if (this.clientSocket == null) {
                    this.clientSocket = s;
                    Debugger.attach(this.clientSocket.getInputStream(), this.clientSocket.getOutputStream(), this.remote);
                    continue;
                }
                InputStream inputStream = Debugger.getDebugIn();
                synchronized (inputStream) {
                    int soTimeoutSave = this.clientSocket.getSoTimeout();
                    this.clientSocket.setSoTimeout(100);
                    try {
                        if (Debugger.getDebugIn().read() >= 0) {
                            s.close();
                        } else {
                            this.clientSocket.close();
                            this.clientSocket = s;
                            Debugger.attach(this.clientSocket.getInputStream(), this.clientSocket.getOutputStream(), this.remote);
                        }
                    }
                    catch (SocketTimeoutException ste) {
                        s.close();
                    }
                    catch (IOException ioe) {
                        this.clientSocket.close();
                        this.clientSocket = s;
                        Debugger.attach(this.clientSocket.getInputStream(), this.clientSocket.getOutputStream(), this.remote);
                    }
                    finally {
                        this.clientSocket.setSoTimeout(soTimeoutSave);
                    }
                }
            }
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void start() {
        this.t.start();
    }

    public synchronized void endConnection() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.clientSocket = null;
        }
        if (this.stopRun) {
            this.closeServer();
        }
    }

    public synchronized void stop(boolean closeCurrentConnection) {
        this.stopRun = true;
        if (this.clientSocket == null) {
            this.closeServer();
        } else if (closeCurrentConnection) {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeServer();
        }
    }

    private void closeServer() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.err.println("Debugger Listener closed");
    }
}

