/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageCopyStatement;
import com.iscobol.coverage.CoverageParagraph;
import com.iscobol.coverage.CoverageProgram;
import com.iscobol.coverage.CoverageSession;
import com.iscobol.coverage.CoverageStatement;
import com.iscobol.coverage.Transformer;
import com.iscobol.profiler.Profiler;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICoverage;
import com.iscobol.rts.ICoverageClassLoader;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolModule;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.SMAPReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.IRuntime;
import org.jacoco.core.runtime.LoggerRuntime;
import org.jacoco.core.runtime.RuntimeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Coverage
implements ICoverage {
    private static Coverage sharedInstance;
    private static final String EP_PREFIX = "_entry_Point$";
    private static final NumberFormat percFormat;
    private static final NumberFormat intFormat;
    private static final DateFormat dateFormat;
    private static final Calendar calendar;
    private static final String[] resources;
    private static final Class iscobolCall;
    private static final Class iscobolClass;
    private static final Class iscobolModule;
    private static final Class iscobolDebugger;
    private static final Set<String> invalidPackageNames;
    private IRuntime runtime;
    private RuntimeData runtimeData;
    private Instrumenter instrumenter;
    private CoverageSession session;
    private File[] classPaths;
    private File[] sourcePaths;
    private File htmlDir;
    private File xmlFile;
    private File[] xmlAppend;
    private Pattern[] includes;
    private Pattern[] excludes;
    private String sessionTitle;
    private Map<String, ClassLocation> classLocations = new HashMap<String, ClassLocation>();
    private String loadingClassName;
    private boolean coverage;
    private boolean profile;
    private Profiler profiler;
    private Transformer transformer;
    private List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private Map<String, byte[]> resourcesStream;

    public Coverage(String defaultSessionName, int flags) {
        this.coverage = Coverage.isCoverage(flags);
        this.profile = Coverage.isProfile(flags);
        if (!this.coverage && !this.profile) {
            throw new IllegalArgumentException("" + flags);
        }
        this.sessionTitle = defaultSessionName;
    }

    public Coverage(String sessionTitle, File htmlDir, File xmlFile, String incl, String excl, String append, String sourceFiles, String classFiles) {
        this.coverage = true;
        this.sessionTitle = sessionTitle;
        if (this.sessionTitle == null) {
            this.sessionTitle = "coverage";
        }
        this.htmlDir = htmlDir;
        this.xmlFile = xmlFile;
        if (incl != null) {
            this.setIncludes(incl);
        }
        if (excl != null) {
            this.setExcludes(excl);
        }
        if (append != null) {
            this.setAppend(append);
        }
        if (sourceFiles != null) {
            this.setSourcefiles(sourceFiles);
        }
        if (classFiles != null) {
            this.setClassfiles(classFiles);
        }
        this.runtime = new LoggerRuntime();
        this.instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)this.runtime);
    }

    @Override
    public void startSession() {
        try {
            if (this.coverage) {
                this.startCoverageSession();
            }
            if (this.profile) {
                this.startProfileSession();
            }
            this.intStartSession();
        }
        catch (Throwable t) {
            throw new IscobolRuntimeException(38, t);
        }
    }

    private void startProfileSession() throws Exception {
        this.startProfileSession(Config.getProperty("iscobol.profiler.includes", null), Config.getProperty("iscobol.profiler.excludes", null), Config.getProperty("iscobol.profiler.html", null), Config.getProperty("iscobol.profiler.xml", null));
    }

    private void startProfileSession(String incl, String excl, String htmlDir, String xmlFile) throws Exception {
        File profHtmlDir = null;
        if (htmlDir != null) {
            profHtmlDir = new File(htmlDir);
        }
        File profXmlFile = null;
        if (xmlFile != null) {
            profXmlFile = new File(xmlFile);
        }
        if (htmlDir == null && xmlFile == null) {
            profHtmlDir = new File("./hprofHtmlReport");
        }
        this.profiler = Profiler.getSharedInstance(profHtmlDir, profXmlFile, null, incl, excl);
    }

    private void startCoverageSession() throws Exception {
        int i;
        StringTokenizer stn;
        String p;
        this.sessionTitle = p = Config.getProperty("iscobol.coverage.sessionname", this.sessionTitle);
        p = Config.getProperty("iscobol.coverage.classfiles", null);
        if (p != null) {
            stn = new StringTokenizer(p, "\n" + File.pathSeparatorChar);
            this.classPaths = new File[stn.countTokens()];
            i = 0;
            while (stn.hasMoreTokens()) {
                this.classPaths[i++] = new File(stn.nextToken());
            }
        }
        if ((p = Config.getProperty("iscobol.coverage.sourcefiles", ".")) != null) {
            stn = new StringTokenizer(p, "\n" + File.pathSeparatorChar);
            this.sourcePaths = new File[stn.countTokens()];
            i = 0;
            while (stn.hasMoreTokens()) {
                this.sourcePaths[i++] = new File(stn.nextToken());
            }
        }
        if ((p = Config.getProperty("iscobol.coverage.html", null)) != null) {
            this.htmlDir = new File(p);
        }
        if ((p = Config.getProperty("iscobol.coverage.xml", null)) != null) {
            this.xmlFile = new File(p);
        }
        this.checkOutputs();
        p = Config.getProperty("iscobol.coverage.append", null);
        if (p != null) {
            this.setAppend(p);
        }
        if ((p = Config.getProperty("iscobol.coverage.analysis.includes", null)) != null) {
            this.setIncludes(p);
        }
        if ((p = Config.getProperty("iscobol.coverage.analysis.excludes", null)) != null) {
            this.setExcludes(p);
        }
    }

    private void setIncludes(String inc) {
        StringTokenizer stn = new StringTokenizer(inc, ",");
        this.includes = new Pattern[stn.countTokens()];
        int i = 0;
        while (stn.hasMoreTokens()) {
            this.includes[i++] = Pattern.compile(stn.nextToken());
        }
    }

    private void setExcludes(String exc) {
        StringTokenizer stn = new StringTokenizer(exc, ",");
        this.excludes = new Pattern[stn.countTokens()];
        int i = 0;
        while (stn.hasMoreTokens()) {
            this.excludes[i++] = Pattern.compile(stn.nextToken());
        }
    }

    private void setAppend(String append) {
        if ("0".equals(append)) {
            this.xmlAppend = null;
        } else if ("1".equals(append)) {
            this.xmlAppend = this.xmlFile != null ? new File[]{this.xmlFile} : null;
        } else {
            StringTokenizer stn = new StringTokenizer(append, ",");
            this.xmlAppend = new File[stn.countTokens()];
            int i = 0;
            while (stn.hasMoreTokens()) {
                this.xmlAppend[i++] = new File(stn.nextToken());
            }
        }
    }

    private void setClassfiles(String cfs) {
        StringTokenizer stn = new StringTokenizer(cfs, "" + File.pathSeparatorChar);
        this.classPaths = new File[stn.countTokens()];
        int j = 0;
        while (stn.hasMoreTokens()) {
            this.classPaths[j++] = new File(stn.nextToken());
        }
    }

    private void setSourcefiles(String sfs) {
        StringTokenizer stn = new StringTokenizer(sfs, "" + File.pathSeparatorChar);
        this.sourcePaths = new File[stn.countTokens()];
        int j = 0;
        while (stn.hasMoreTokens()) {
            this.sourcePaths[j++] = new File(stn.nextToken());
        }
    }

    private void checkOutputs() {
        if (this.htmlDir == null && this.xmlFile == null) {
            this.htmlDir = new File("./htmlReport");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(boolean reset) throws Exception {
        this.session = new CoverageSession();
        this.session.name.timestamp = System.currentTimeMillis();
        this.session.name.name = this.sessionTitle;
        if (reset) {
            Coverage coverage = this;
            synchronized (coverage) {
                for (ClassLocation loc : this.classLocations.values()) {
                    for (ClassDef def : loc.originals.values()) {
                        def.program = null;
                    }
                    for (ClassDef def : loc.definitions.values()) {
                        def.reset = true;
                    }
                }
            }
            this.runtimeData.reset();
            this.xmlFile = null;
            this.htmlDir = null;
        } else {
            this.runtimeData = new RuntimeData();
        }
        this.runtime.startup(this.runtimeData);
    }

    private void intStartSession() throws Exception {
        ClassLocation loc = new ClassLocation("");
        loc.memoryCL = new MemoryClassLoader("");
        this.classLocations.put(loc.location, loc);
        Thread.currentThread().setContextClassLoader(loc.memoryCL);
        if (this.coverage) {
            this.runtime = new LoggerRuntime();
            this.instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)this.runtime);
            this.startup(false);
            this.shutdownHooks.add(() -> this.shutdownAndPrintReports());
        }
        if (this.profile) {
            this.shutdownHooks.add(() -> this.profiler.shutdownAndPrintReports());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Runnable r : this.shutdownHooks) {
                r.run();
            }
        }));
    }

    private void loadClasses(File dir, String packageName, ClassLocation loc) {
        FileFilter fileFilter = pathname -> pathname.isDirectory() || pathname.getName().endsWith(".class") && pathname.getName().indexOf(36) < 0;
        for (File file : dir.listFiles(fileFilter)) {
            ClassDef def;
            if (file.isDirectory()) {
                this.loadClasses(file, packageName + file.getName() + ".", loc);
                continue;
            }
            String baseName = file.getName().substring(0, file.getName().length() - 6);
            String fullName = packageName + baseName;
            if (loc.originals.containsKey(fullName) || (def = this.loadClass(fullName, file, loc.memoryCL)) == null || this.mustBeAnalyzed(def.cl, false) == 0) continue;
            loc.originals.put(fullName, def);
            FilenameFilter filenameFilter = (dir0, n) -> n.startsWith(baseName + "$") && n.endsWith(".class");
            for (File fs : dir.listFiles(filenameFilter)) {
                String className = packageName + fs.getName().substring(0, fs.getName().length() - 6);
                def = this.loadClass(className, fs, loc.memoryCL);
                if (def == null) continue;
                loc.originals.put(className, def);
            }
        }
    }

    private ClassDef loadClass(String className, File f, MemoryClassLoader memoryCL) {
        try {
            FileInputStream is = new FileInputStream(f);
            return this.loadClass(className, is, memoryCL);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private ClassDef loadClass(String className, InputStream is, MemoryClassLoader memoryCL) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int r = is.read(buf);
            while (r >= 0) {
                baos.write(buf, 0, r);
                r = is.read(buf);
            }
            is.close();
            baos.close();
            byte[] b = baos.toByteArray();
            Class c0 = memoryCL.DefineClass(className, b, 0, b.length);
            return new ClassDef(new MyClass(c0), b);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void loadClassesFromJar(File dir, ClassLocation loc) {
        try {
            JarFile jf = new JarFile(dir);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                ClassDef def;
                JarEntry je = e.nextElement();
                String fullName = je.getName();
                if (!fullName.endsWith(".class") || fullName.indexOf(36) >= 0) continue;
                fullName = fullName.replace('/', '.');
                if (loc.originals.containsKey(fullName = fullName.substring(0, fullName.length() - 6)) || (def = this.loadClass(fullName, jf.getInputStream(je), loc.memoryCL)) == null || this.mustBeAnalyzed(def.cl, false) == 0) continue;
                loc.originals.put(fullName, def);
                Enumeration<JarEntry> e2 = jf.entries();
                while (e2.hasMoreElements()) {
                    JarEntry je2 = e2.nextElement();
                    String innerName = je2.getName();
                    if (!innerName.endsWith(".class")) continue;
                    innerName = innerName.replace('/', '.');
                    if (!(innerName = innerName.substring(0, innerName.length() - 6)).startsWith(fullName + "$") || (def = this.loadClass(innerName, jf.getInputStream(je2), loc.memoryCL)) == null) continue;
                    loc.originals.put(innerName, def);
                }
            }
            jf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean shutdownAndPrintReports() {
        String parName;
        boolean Return2 = true;
        ExecutionDataStore executionData = new ExecutionDataStore();
        SessionInfoStore sessionInfos = new SessionInfoStore();
        this.runtimeData.collect((IExecutionDataVisitor)executionData, (ISessionInfoVisitor)sessionInfos, false);
        this.runtime.shutdown();
        if (this.classPaths != null) {
            ClassLocation loc = new ClassLocation("(classes)");
            loc.memoryCL = new MemoryClassLoader(loc.location);
            for (ClassLocation l : this.classLocations.values()) {
                loc.originals.putAll(l.originals);
            }
            for (File dir : this.classPaths) {
                if (!dir.exists()) continue;
                if (dir.isDirectory()) {
                    this.loadClasses(dir, "", loc);
                    continue;
                }
                if (!dir.getName().endsWith(".jar")) continue;
                this.loadClassesFromJar(dir, loc);
            }
            for (ClassLocation l : this.classLocations.values()) {
                for (String k : l.originals.keySet()) {
                    loc.originals.remove(k);
                }
            }
            this.classLocations.put(loc.location, loc);
        }
        String[] keys = this.classLocations.keySet().toArray(new String[this.classLocations.size()]);
        for (String path : keys) {
            CoverageBuilder coverageBuilder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(executionData, (ICoverageVisitor)coverageBuilder);
            ClassLocation loc = this.classLocations.get(path);
            for (String n : loc.originals.keySet()) {
                ClassDef def = loc.originals.get(n);
                if (def.bytes == null) continue;
                ByteArrayInputStream original = new ByteArrayInputStream(def.bytes);
                try {
                    analyzer.analyzeClass((InputStream)original, n);
                    ((InputStream)original).close();
                }
                catch (IOException ex) {
                    Return2 = false;
                    ex.printStackTrace();
                }
            }
            for (IClassCoverage cc : coverageBuilder.getClasses()) {
                boolean iscall;
                boolean inner;
                boolean ism;
                String ccName = cc.getName().replace('/', '.');
                ClassDef def = loc.originals.get(ccName);
                MyClass ec = def.cl.getEnclosingClass();
                if (ec != null) {
                    ism = def.cl.isAssignableTo(iscobolModule);
                    inner = !ism && def.cl.getName().matches(".+\\$\\d*inner_\\d+");
                    iscall = ec.isAssignableTo(iscobolCall);
                } else {
                    ism = false;
                    inner = false;
                    iscall = def.cl.isAssignableTo(iscobolCall);
                }
                if (!ism && !inner && (ec != null || def.cl.getName().startsWith("com.iscobol.lib") || def.cl.getName().endsWith("_CONST") || def.cl.getName().matches(".+_CONST_\\d+"))) continue;
                String parPfx = "";
                if (ism) {
                    parPfx = Coverage.getMethodName(def.cl.getName());
                    ccName = ec.getName();
                    def = loc.originals.get(ccName);
                } else if (inner) {
                    if (ec.getEnclosingClass() != null && ec.isAssignableTo(iscobolModule)) {
                        parPfx = Coverage.getMethodName(def.cl.getName());
                        ccName = ec.getEnclosingClass().getName();
                        def = loc.originals.get(ccName);
                    } else {
                        ccName = ec.getName();
                        def = loc.originals.get(ccName);
                    }
                }
                if (def.program == null) {
                    this.newProgram(def, ccName, loc.location, this.session);
                }
                if (def.sr == null || !def.sr.isOk()) continue;
                TreeMap<SMAPReader.CobolInfo, String> linesMap = new TreeMap<SMAPReader.CobolInfo, String>((o1, o2) -> {
                    int r = o1.fileNum - o2.fileNum;
                    if (r == 0) {
                        r = o1.fileName.compareTo(o2.fileName);
                    }
                    if (r == 0) {
                        r = o1.line - o2.line;
                    }
                    return r;
                });
                LinkedHashMap<IMethodCoverage, String> methodMap = new LinkedHashMap<IMethodCoverage, String>();
                CoverageParagraph paragraph = null;
                for (IMethodCoverage method : cc.getMethods()) {
                    int idx;
                    parName = method.getName();
                    if (parName.indexOf(60) >= 0 || iscall && (parName.equals("call") || parName.equals("finalize") || parName.equals("perform"))) continue;
                    if (parName.startsWith("_dm$") && (idx = parName.substring(4).lastIndexOf(36)) >= 0) {
                        parName = parName.substring(4, idx + 4);
                    }
                    if ((idx = parName.indexOf("$$")) >= 0) {
                        String secName = parName.substring(idx + 2);
                        parName = parName.substring(0, idx);
                        idx = secName.indexOf(36);
                        if (idx >= 0) {
                            secName = secName.substring(0, idx);
                        }
                        parName = parName.equals(secName) ? parName + " section" : parName + " of " + secName;
                    }
                    if (parName.startsWith(EP_PREFIX)) {
                        parName = "(ENTRY) " + parName.substring(EP_PREFIX.length()).toUpperCase();
                    }
                    parName = parPfx + parName;
                    for (int i = method.getFirstLine(); i <= method.getLastLine(); ++i) {
                        String color;
                        SMAPReader.CobolInfo info = null;
                        if (def.sr != null && def.sr.isOk()) {
                            info = def.sr.getLineInfo(i, true);
                        }
                        if (info == null || linesMap.containsKey(info) || (color = Coverage.getColor(cc.getLine(i).getStatus())) == null) continue;
                        String methColor = (String)methodMap.get(method);
                        if (methColor == null) {
                            methodMap.put(method, color);
                            if (paragraph == null || !parName.equals(paragraph.name)) {
                                paragraph = new CoverageParagraph();
                                paragraph.name = parName;
                                if (paragraph.color == null) {
                                    paragraph.color = "red";
                                }
                                def.program.addParagraph(paragraph);
                            }
                        }
                        linesMap.put(info, color);
                        CoverageStatement stmt = new CoverageStatement();
                        stmt.color = color;
                        stmt.lineNumber = info.line;
                        stmt.fileName = info.fileName;
                        stmt.fileIndex = info.fileIndex;
                        paragraph.addStatement(stmt);
                        paragraph.setMaxColor(color);
                    }
                }
            }
        }
        if (this.xmlAppend != null) {
            for (File f : this.xmlAppend) {
                try {
                    DocumentBuilderFactory factory = RtsUtil.newDocumentBuilderFactory();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    InputStreamReader reader = new InputStreamReader(new FileInputStream(f));
                    Document document = builder.parse(new InputSource(reader));
                    Element sessionElement = document.getDocumentElement();
                    CoverageSession.Name append = new CoverageSession.Name();
                    append.name = sessionElement.getAttribute("name");
                    append.timestamp = Long.parseLong(sessionElement.getAttribute("timestamp"));
                    this.session.addAppend(append);
                    NodeList nl1 = sessionElement.getChildNodes();
                    for (int i1 = 0; i1 < nl1.getLength(); ++i1) {
                        boolean newPgm;
                        Node n1 = nl1.item(i1);
                        if (!(n1 instanceof Element)) continue;
                        Element e1 = (Element)n1;
                        if (e1.getTagName().equals("append")) {
                            append = new CoverageSession.Name();
                            append.name = e1.getAttribute("name");
                            append.timestamp = Long.parseLong(e1.getAttribute("timestamp"));
                            this.session.addAppend(append);
                            continue;
                        }
                        if (!e1.getTagName().equals("program")) continue;
                        String pgmName = e1.getAttribute("name");
                        CoverageProgram program = this.session.getProgram(pgmName);
                        boolean bl = newPgm = program == null;
                        if (newPgm) {
                            program = new CoverageProgram();
                            program.name = pgmName;
                            program.fileName = e1.getAttribute("fileName");
                            program.location = e1.getAttribute("location");
                            program.color = e1.getAttribute("color");
                            this.session.addProgram(program);
                        } else {
                            program.setMaxColor(e1.getAttribute("color"));
                        }
                        NodeList nl2 = e1.getChildNodes();
                        for (int i2 = 0; i2 < nl2.getLength(); ++i2) {
                            Node n2 = nl2.item(i2);
                            if (!(n2 instanceof Element)) continue;
                            Element e2 = (Element)n2;
                            if (e2.getTagName().equals("paragraph")) {
                                parName = e2.getAttribute("name");
                                CoverageParagraph paragraph = program.getParagraph(parName);
                                if (paragraph == null) {
                                    paragraph = new CoverageParagraph();
                                    paragraph.name = parName;
                                    paragraph.color = e2.getAttribute("color");
                                    program.addParagraph(paragraph);
                                } else {
                                    paragraph.setMaxColor(e2.getAttribute("color"));
                                }
                                NodeList nl3 = e2.getChildNodes();
                                for (int i3 = 0; i3 < nl3.getLength(); ++i3) {
                                    Node n3 = nl3.item(i3);
                                    if (!(n3 instanceof Element)) continue;
                                    Element e3 = (Element)n3;
                                    CoverageStatement tmp = new CoverageStatement();
                                    tmp.lineNumber = Integer.parseInt(e3.getAttribute("lineNumber"));
                                    tmp.fileIndex = Integer.parseInt(e3.getAttribute("fileIndex"));
                                    tmp.fileName = e3.getAttribute("fileName");
                                    CoverageStatement stmt = paragraph.getStatement(tmp);
                                    if (stmt == null) {
                                        stmt = tmp;
                                        stmt.color = e3.getAttribute("color");
                                        paragraph.addStatement(stmt);
                                        continue;
                                    }
                                    stmt.setMaxColor(e3.getAttribute("color"));
                                }
                                continue;
                            }
                            if (!e2.getTagName().equals("copyStatement") || !newPgm) continue;
                            CoverageCopyStatement cstmt = new CoverageCopyStatement();
                            cstmt.copyIndex = Integer.parseInt(e2.getAttribute("copyFileIndex"));
                            cstmt.fileIndex = Integer.parseInt(e2.getAttribute("fileIndex"));
                            cstmt.copyName = e2.getAttribute("copyFileName");
                            cstmt.fileName = e2.getAttribute("fileName");
                            cstmt.lineNumber = Integer.parseInt(e2.getAttribute("lineNumber"));
                            program.addCopyStatement(cstmt);
                        }
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Return2 = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Return2 = false;
                }
            }
        }
        if (this.xmlFile != null) {
            try {
                this.createXmlReport(this.session);
            }
            catch (Exception e) {
                e.printStackTrace();
                Return2 = false;
            }
        }
        if (this.htmlDir != null && !this.htmlDir.exists() && !this.htmlDir.mkdirs()) {
            System.err.println("Cannot create '" + this.htmlDir + "'");
            this.htmlDir = null;
        }
        if (this.htmlDir != null) {
            try {
                this.createHtmlReport(this.session);
            }
            catch (IOException e) {
                e.printStackTrace();
                Return2 = false;
            }
        }
        return Return2;
    }

    private static String getMethodName(String ccName) {
        String parPfx = ccName;
        int start = parPfx.indexOf("$class$") + 7;
        int end = parPfx.indexOf(36, start);
        return parPfx.substring(start, end) + "::";
    }

    private void newProgram(ClassDef def, String ccName, String loc, CoverageSession session) {
        CoverageProgram program = new CoverageProgram();
        program.name = ccName;
        program.color = "green";
        program.location = loc;
        session.addProgram(program);
        ByteArrayInputStream original = new ByteArrayInputStream(def.bytes);
        SMAPReader sr = null;
        try {
            sr = new SMAPReader(original);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        if (sr != null && sr.isOk()) {
            program.fileName = sr.getFileName();
            Vector<String[]> copyStmts = sr.getCopyStatements();
            int fileIndex = 0;
            for (String[] cs : copyStmts) {
                String fn;
                CoverageCopyStatement stmt = new CoverageCopyStatement();
                stmt.fileName = fn = cs[0];
                stmt.lineNumber = Integer.parseInt(cs[1]);
                stmt.copyName = fn = cs[2];
                if (cs.length > 3) {
                    stmt.fileIndex = Integer.parseInt(cs[3]);
                    if (cs.length > 4) {
                        stmt.copyIndex = Integer.parseInt(cs[4]);
                    }
                } else {
                    stmt.copyIndex = ++fileIndex;
                }
                program.addCopyStatement(stmt);
            }
        }
        def.program = program;
        def.sr = sr;
    }

    private int mustBeAnalyzed(MyClass cls, boolean filter) {
        String pkg;
        boolean ok;
        int Return2 = 0;
        boolean bl = ok = !cls.isInterface() && cls.isAssignableTo(iscobolClass) && ((pkg = cls.getPackageName()) == null || !invalidPackageNames.contains(pkg));
        if (!ok) {
            return Return2;
        }
        if (!filter) {
            return ++Return2;
        }
        if (this.coverage) {
            if (this.includes != null && this.includes.length > 0) {
                ok = false;
                for (Pattern p : this.includes) {
                    if (!p.matcher(cls.getName()).matches()) continue;
                    ok = true;
                    break;
                }
            }
            if (ok && this.excludes != null && this.excludes.length > 0) {
                for (Pattern p : this.excludes) {
                    if (!p.matcher(cls.getName()).matches()) continue;
                    ok = false;
                    break;
                }
            }
            if (ok) {
                ++Return2;
            }
        }
        if (this.profile && this.profiler.getTransformer().matches(cls.getName())) {
            Return2 += 2;
        }
        return Return2;
    }

    @Override
    public Class loadClass(String location, String name, boolean resolve, ClassLoader ext) throws ClassNotFoundException {
        return this.loadClass(location, name, resolve, new CLWrapper(ext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(String location, String name, boolean resolve, CLWrapper ext) throws ClassNotFoundException {
        if (name.equals(this.loadingClassName)) {
            throw new ClassNotFoundException(name);
        }
        String s = this.loadingClassName;
        this.loadingClassName = name;
        try {
            Class clazz = this.loadClass0(location, name, resolve, ext);
            return clazz;
        }
        finally {
            this.loadingClassName = s;
        }
    }

    @Override
    public byte[] transformBytes(String location, String name, byte[] originalBytes) {
        ClassLocation loc = this.getClassLocation(location);
        ClassDef def = null;
        try {
            def = this.getClassDef(loc, name, originalBytes, true, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (def != null && def.bytes != null) {
            return def.bytes;
        }
        return originalBytes;
    }

    private synchronized ClassLocation getClassLocation(String location) {
        ClassLocation loc = this.classLocations.get(location);
        if (loc == null) {
            loc = new ClassLocation(location);
            loc.memoryCL = new MemoryClassLoader(loc.location);
            this.classLocations.put(location, loc);
        }
        return loc;
    }

    private Class loadClass0(String location, String name, boolean resolve, CLWrapper ext) throws ClassNotFoundException {
        ClassDef def;
        ClassLocation loc = this.getClassLocation(location);
        try {
            def = this.getClassDef(loc, name, null, resolve, ext);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            def = null;
        }
        if (def != null && def.bytes != null) {
            return loc.memoryCL.DefineClass(name, def.bytes, 0, def.bytes.length);
        }
        return ext.LoadClass(name, resolve);
    }

    private ClassDef getClassDef(ClassLocation loc, String name, byte[] originalBytes, boolean resolve, CLWrapper ext) throws Exception {
        ClassDef def = loc.definitions.get(name);
        if (def != null && !def.reset) {
            if (def.bytes != null) {
                return def;
            }
            return null;
        }
        MyClass c = ext != null ? new MyClass(ext.LoadClass(name, resolve)) : new MyClass(originalBytes);
        int flags = this.mustBeAnalyzed(c, true);
        if (flags > 0) {
            String baseName;
            String packageName;
            File f = c.getLocation();
            if (f == null) {
                f = new File(loc.location);
            }
            String classFile = f.getPath();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                packageName = name.substring(0, idx + 1);
                baseName = name.substring(idx + 1);
            } else {
                packageName = "";
                baseName = name;
            }
            FilenameFilter filter = (dir, n) -> n.equals(baseName + ".class") || n.endsWith(".class") && (n.startsWith(baseName + "$") || n.startsWith(baseName + "_CONST"));
            if (f.isDirectory()) {
                File f0 = packageName.length() > 0 ? new File(classFile + packageName.replace('.', '/')) : f;
                for (File fs : f0.listFiles(filter)) {
                    byte[] b;
                    MyClass c0;
                    String className;
                    byte[] orig = null;
                    if (fs.getName().equals(baseName + ".class")) {
                        className = name;
                        c0 = c;
                        if (originalBytes != null) {
                            orig = originalBytes;
                        }
                    } else {
                        className = packageName + fs.getName().substring(0, fs.getName().length() - 6);
                        if (ext == null) {
                            FileInputStream is = new FileInputStream(fs);
                            orig = Coverage.readBytes(is);
                            is.close();
                            c0 = new MyClass(orig);
                        } else {
                            c0 = new MyClass(ext.LoadClass(className, resolve));
                        }
                    }
                    try {
                        if (orig == null) {
                            FileInputStream is = new FileInputStream(fs);
                            orig = Coverage.readBytes(is);
                            is.close();
                        }
                        b = this.instrumentClass(c0, orig, className, flags, ext);
                        loc.originals.put(className, new ClassDef(c0, orig));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        b = new byte[]{};
                    }
                    loc.definitions.put(className, new ClassDef(c0, b));
                    c0.detach();
                }
            } else {
                try {
                    ZipEntry ze;
                    String path;
                    ZipInputStream zis = f.getName().endsWith(".jar") ? new JarInputStream(new FileInputStream(f)) : new ZipInputStream(new FileInputStream(f));
                    String string = path = packageName.length() > 0 ? packageName.replace('.', '/') : null;
                    while ((ze = zis.getNextEntry()) != null) {
                        byte[] b;
                        MyClass c0;
                        String className;
                        String zeName = new File(ze.getName()).getName();
                        if (path != null && !ze.getName().startsWith(path) || !filter.accept(null, zeName)) continue;
                        byte[] orig = null;
                        if (zeName.equals(baseName + ".class")) {
                            className = name;
                            c0 = c;
                            if (originalBytes != null) {
                                orig = originalBytes;
                            }
                        } else {
                            className = packageName + zeName.substring(0, zeName.length() - 6);
                            if (ext != null) {
                                c0 = new MyClass(ext.LoadClass(className, resolve));
                            } else {
                                orig = Coverage.readBytes(zis);
                                c0 = new MyClass(orig);
                            }
                        }
                        if (orig == null) {
                            orig = Coverage.readBytes(zis);
                        }
                        try {
                            b = this.instrumentClass(c0, orig, className, flags, ext);
                            loc.originals.put(className, new ClassDef(c0, orig));
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                            b = new byte[]{};
                        }
                        loc.definitions.put(className, new ClassDef(c0, b));
                        c0.detach();
                    }
                    zis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    loc.definitions.put(name, new ClassDef(c, null));
                }
            }
            def = loc.definitions.get(name);
            if (def != null && def.bytes != null) {
                return def;
            }
            return null;
        }
        return null;
    }

    private static String getColor(int status) {
        switch (status) {
            case 1: {
                return "red";
            }
            case 3: {
                return "yellow";
            }
            case 2: {
                return "green";
            }
        }
        return null;
    }

    private void createXmlReport(CoverageSession session) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element sessionElem = document.createElement("session");
        sessionElem.setAttribute("name", session.name.name);
        sessionElem.setAttribute("timestamp", Long.toString(session.name.timestamp));
        document.appendChild(sessionElem);
        Collection<CoverageSession.Name> appended = session.getAppended();
        for (CoverageSession.Name name : appended) {
            Element appendElem = document.createElement("append");
            appendElem.setAttribute("name", name.name);
            appendElem.setAttribute("timestamp", Long.toString(name.timestamp));
            sessionElem.appendChild(appendElem);
        }
        Collection<CoverageProgram> programs = session.getPrograms();
        for (CoverageProgram pgm : programs) {
            Element programElem = document.createElement("program");
            programElem.setAttribute("name", pgm.name);
            programElem.setAttribute("color", pgm.color);
            programElem.setAttribute("fileName", pgm.fileName);
            if (pgm.location != null && pgm.location.length() > 0) {
                programElem.setAttribute("location", pgm.location);
            }
            sessionElem.appendChild(programElem);
            Collection<CoverageParagraph> paragraphs = pgm.getParagraphs();
            for (CoverageParagraph par : paragraphs) {
                Element paragraphElem = document.createElement("paragraph");
                paragraphElem.setAttribute("name", Coverage.removePrefix(par.name));
                paragraphElem.setAttribute("color", par.color);
                programElem.appendChild(paragraphElem);
                Collection<CoverageStatement> statements = par.getStatements();
                for (CoverageStatement stmt : statements) {
                    Element stmtElem = document.createElement("statement");
                    stmtElem.setAttribute("color", stmt.color);
                    stmtElem.setAttribute("lineNumber", Integer.toString(stmt.lineNumber));
                    stmtElem.setAttribute("fileIndex", Integer.toString(stmt.fileIndex));
                    stmtElem.setAttribute("fileName", stmt.fileName);
                    paragraphElem.appendChild(stmtElem);
                }
            }
            for (CoverageCopyStatement cstmt : pgm.getCopyStatements()) {
                Element copyStmtElem = document.createElement("copyStatement");
                copyStmtElem.setAttribute("lineNumber", Integer.toString(cstmt.lineNumber));
                copyStmtElem.setAttribute("fileIndex", Integer.toString(cstmt.fileIndex));
                copyStmtElem.setAttribute("fileName", cstmt.fileName);
                copyStmtElem.setAttribute("copyFileIndex", Integer.toString(cstmt.copyIndex));
                copyStmtElem.setAttribute("copyFileName", cstmt.copyName);
                programElem.appendChild(copyStmtElem);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(3));
        }
        catch (Exception pgm) {
            // empty catch block
        }
        javax.xml.transform.Transformer transformer = transformerFactory.newTransformer();
        Properties outProps = transformer.getOutputProperties();
        outProps.setProperty("indent", "yes");
        transformer.setOutputProperties(outProps);
        DOMSource source = new DOMSource(document);
        FileOutputStream out = new FileOutputStream(this.xmlFile);
        StreamResult result = new StreamResult(new OutputStreamWriter(out));
        transformer.transform(source, result);
        out.close();
    }

    private void createHtmlReport(CoverageSession session) throws IOException {
        int imgWidth = 120;
        int imgHeight = 10;
        ArrayList<CoverageProgram> programs = new ArrayList<CoverageProgram>(session.getPrograms());
        Collections.sort(programs, new ProgramComparator(0));
        ArrayList<CoverageProgram> tmp = new ArrayList<CoverageProgram>(programs);
        int[][] sortPos = new int[tmp.size()][9];
        for (int i = 0; i < sortPos.length; ++i) {
            sortPos[i][0] = i;
        }
        for (int colIdx = 1; colIdx < 9; ++colIdx) {
            Collections.sort(tmp, new ProgramComparator(colIdx));
            block2: for (int i1 = 0; i1 < programs.size(); ++i1) {
                for (int i2 = 0; i2 < tmp.size(); ++i2) {
                    if (programs.get(i1) != tmp.get(i2)) continue;
                    sortPos[i1][colIdx] = i2;
                    continue block2;
                }
            }
        }
        this.createResources();
        String reportTitle = "isCOBOL Coverage Report";
        PrintStream out = new PrintStream(new File(this.htmlDir.getAbsolutePath() + "/index.html"));
        out.println("<html>");
        out.println("  <head>");
        out.println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        out.println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
        out.println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
        out.println("    <title>isCOBOL Coverage Report</title>");
        out.println("    <script type=\"text/javascript\" src=\"resources/sort.js\"></script>");
        out.println("   </head>");
        out.println("   <body onload=\"sortColumn(a, false)\">");
        out.println("      <h1>isCOBOL Coverage Report</h1>");
        out.println("      <h4>Sessions</h4>");
        out.println("      <p>This coverage report is based on execution data from the following\r\n      sessions:</p>");
        out.println("      <table class=\"coverage\" cellspacing=\"0\">");
        out.println("        <thead>");
        out.println("          <tr>");
        out.println("            <td>Session</td>");
        out.println("            <td>Executed</td>");
        out.println("          </tr>");
        out.println("        </thead>");
        out.println("        <tbody>");
        ArrayList<CoverageSession.Name> appended = new ArrayList<CoverageSession.Name>(session.getAppended());
        Collections.sort(appended, (o1, o2) -> {
            long d = o1.timestamp - o2.timestamp;
            if (d > 0L) {
                return 1;
            }
            if (d < 0L) {
                return -1;
            }
            return 0;
        });
        for (CoverageSession.Name n : appended) {
            this.writeHtml(out, n);
        }
        this.writeHtml(out, session.name);
        out.println("        </tbody>");
        out.println("      </table>");
        out.println("      <br><br>");
        out.println("      <table class=\"coverage\" cellspacing=\"0\" id=\"coveragetable\">");
        out.println("        <thead>");
        out.println("          <tr>");
        out.println("            <td class=\"sortable\" id=\"a\" onclick=\"toggleSort(this)\">Program</td>");
        out.println("            <td class=\"down sortable bar\" id=\"b\" onclick=\"toggleSort(this)\">Statements Coverage</td>");
        out.println("            <td class=\"sortable ctr2\" id=\"c\" onclick=\"toggleSort(this)\">Covered Stmts</td>");
        out.println("            <td class=\"sortable ctr1\" id=\"d\" onclick=\"toggleSort(this)\">Missed Stmts</td>");
        out.println("            <td class=\"sortable ctr2\" id=\"e\" onclick=\"toggleSort(this)\">Total Stmts</td>");
        out.println("            <td class=\"down sortable bar\" id=\"f\" onclick=\"toggleSort(this)\">Paragraphs Coverage</td>");
        out.println("            <td class=\"sortable ctr2\" id=\"g\" onclick=\"toggleSort(this)\">Covered Pars</td>");
        out.println("            <td class=\"sortable ctr1\" id=\"h\" onclick=\"toggleSort(this)\">Missed Pars</td>");
        out.println("            <td class=\"sortable ctr2\" id=\"i\" onclick=\"toggleSort(this)\">Total Pars</td>");
        out.println("          </tr>");
        out.println("        </thead>");
        out.println("        <tfoot>");
        out.println("          <tr>");
        out.println("            <td>Total</td>");
        int missed = session.getMissedStatements();
        int total = session.getTotalStatements();
        double covRatio = session.getStatementCoverageRatio();
        int covW = (int)Math.round(covRatio * 120.0);
        String s = null;
        if (total > 0) {
            if (missed > 0) {
                s = "<img src=\"resources/redbar.gif\" width=\"" + (120 - covW) + "\" height=\"" + 10 + "\" title=\"" + missed + "\" alt=\"" + missed + "\" />";
            }
            if (missed < total) {
                if (s == null) {
                    s = "";
                }
                s = s + "<img src=\"resources/greenbar.gif\" width=\"" + covW + "\" height=\"" + 10 + "\" title=\"" + (total - missed) + "\" alt=\"" + (total - missed) + "\" />";
            }
        }
        String nbspTot = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        out.println("            <td class=\"bar\">" + (s != null ? s : "") + nbspTot + Coverage.percFormat(covRatio) + "</td>");
        out.println("            <td class=\"ctr2\">" + intFormat.format(total - missed) + "</td>");
        out.println("            <td class=\"ctr1\">" + intFormat.format(missed) + "</td>");
        out.println("            <td class=\"ctr2\">" + intFormat.format(total) + "</td>");
        missed = session.getMissedParagraphs();
        total = session.getTotalParagraphs();
        covRatio = session.getParagraphCoverageRatio();
        covW = (int)Math.round(covRatio * 120.0);
        s = null;
        if (total > 0) {
            if (missed > 0) {
                s = "<img src=\"resources/redbar.gif\" width=\"" + (120 - covW) + "\" height=\"" + 10 + "\" title=\"" + missed + "\" alt=\"" + missed + "\" />";
            }
            if (missed < total) {
                if (s == null) {
                    s = "";
                }
                s = s + "<img src=\"resources/greenbar.gif\" width=\"" + covW + "\" height=\"" + 10 + "\" title=\"" + (total - missed) + "\" alt=\"" + (total - missed) + "\" />";
            }
        }
        out.println("            <td class=\"bar\">" + (s != null ? s : "") + nbspTot + Coverage.percFormat(covRatio) + "</td>");
        out.println("            <td class=\"ctr2\">" + intFormat.format(total - missed) + "</td>");
        out.println("            <td class=\"ctr1\">" + intFormat.format(missed) + "</td>");
        out.println("            <td class=\"ctr2\">" + intFormat.format(total) + "</td>");
        out.println("          </tr>");
        out.println("        </tfoot>");
        out.println("        <tbody>");
        String nbsp = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        int pgmIdx = 0;
        HashSet<String> pgmFileNames = new HashSet<String>();
        HashMap<String, Boolean> showLoc = new HashMap<String, Boolean>();
        for (CoverageProgram program : programs) {
            Boolean b = (Boolean)showLoc.get(program.name);
            showLoc.put(program.name, b != null);
        }
        for (CoverageProgram program : programs) {
            missed = program.getMissedStatements();
            total = program.getTotalStatements();
            covRatio = 0.0;
            if (total > 0) {
                covRatio = 1.0 - (double)missed / (double)total;
            }
            covW = (int)Math.round(covRatio * 120.0);
            String pfn = Coverage.getUnivoqueName(pgmFileNames, program.name, ".html");
            out.println("          <tr>");
            String descr = program.name;
            if (((Boolean)showLoc.get(program.name)).booleanValue() && program.location.length() > 0) {
                File loc = new File(program.location);
                File wrkDir = new File(System.getProperty("user.dir"));
                StringBuilder relPath = new StringBuilder();
                if (loc.isAbsolute()) {
                    File f;
                    for (f = loc; f != null && !f.equals(wrkDir); f = f.getParentFile()) {
                        if (relPath.length() > 0) {
                            relPath.insert(0, f.getName() + "/");
                            continue;
                        }
                        relPath.append(f.getName());
                    }
                    if (f == null) {
                        relPath = new StringBuilder(program.location);
                    }
                } else {
                    relPath.append(program.location);
                }
                descr = descr + " (" + relPath + ")";
            }
            out.println("            <td id=\"a" + sortPos[pgmIdx][0] + "\"> <a href=\"" + pfn + "\" class=\"el_program\">" + descr + "</a> </td>");
            out.println("            <td class=\"bar\" id=\"b" + sortPos[pgmIdx][1] + "\">");
            if (total > 0) {
                s = null;
                if (missed > 0) {
                    s = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - covW) + "\" height=\"" + 10 + "\" title=\"" + missed + "\" alt=\"" + missed + "\" />";
                }
                if (missed < total) {
                    if (s == null) {
                        s = "               ";
                    }
                    s = s + "<img src=\"resources/greenbar.gif\" width=\"" + covW + "\" height=\"" + 10 + "\" title=\"" + (total - missed) + "\" alt=\"" + (total - missed) + "\" />";
                }
                out.println(s);
            }
            out.println("            " + nbsp + (total > 0 ? Coverage.percFormat(covRatio) : "n/a") + "</td>");
            out.println("            <td class=\"ctr2\" id=\"c" + sortPos[pgmIdx][2] + "\">" + (total > 0 ? intFormat.format(total - missed) : "n/a") + "</td>");
            out.println("            <td class=\"ctr1\" id=\"d" + sortPos[pgmIdx][3] + "\">" + (total > 0 ? intFormat.format(missed) : "n/a") + "</td>");
            out.println("            <td class=\"ctr2\" id=\"e" + sortPos[pgmIdx][4] + "\">" + (total > 0 ? intFormat.format(total) : "n/a") + "</td>");
            missed = program.getMissedParagraphs();
            total = program.getTotalParagraphs();
            covRatio = 0.0;
            if (total > 0) {
                covRatio = 1.0 - (double)missed / (double)total;
            }
            covW = (int)Math.round(covRatio * 120.0);
            out.println("            <td class=\"bar\" id=\"f" + sortPos[pgmIdx][5] + "\">");
            if (total > 0) {
                s = null;
                if (missed > 0) {
                    s = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - covW) + "\" height=\"" + 10 + "\" title=\"" + missed + "\" alt=\"" + missed + "\" />";
                }
                if (missed < total) {
                    if (s == null) {
                        s = "               ";
                    }
                    s = s + "<img src=\"resources/greenbar.gif\" width=\"" + covW + "\" height=\"" + 10 + "\" title=\"" + (total - missed) + "\" alt=\"" + (total - missed) + "\" />";
                }
                out.println(s);
            }
            out.println("            " + nbsp + (total > 0 ? Coverage.percFormat(covRatio) : "n/a") + "</td>");
            out.println("            <td class=\"ctr2\" id=\"g" + sortPos[pgmIdx][6] + "\">" + (total > 0 ? intFormat.format(total - missed) : "n/a") + "</td>");
            out.println("            <td class=\"ctr1\" id=\"h" + sortPos[pgmIdx][7] + "\">" + (total > 0 ? intFormat.format(missed) : "n/a") + "</td>");
            out.println("            <td class=\"ctr2\" id=\"i" + sortPos[pgmIdx][8] + "\">" + (total > 0 ? intFormat.format(total) : "n/a") + "</td>");
            PrintStream pgmOut = new PrintStream(new File(this.htmlDir.getAbsolutePath() + "/" + pfn));
            pgmOut.println("<html>");
            pgmOut.println("  <head>");
            pgmOut.println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
            pgmOut.println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
            pgmOut.println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
            pgmOut.println("    <title>" + program.name + "</title>");
            pgmOut.println("    <script type=\"text/javascript\" src=\"resources/sort.js\"></script>");
            pgmOut.println("   </head>");
            pgmOut.println("   <body onload=\"initialSort(['breadcrumb'])\">");
            pgmOut.println("       <div class=\"breadcrumb\" id=\"breadcrumb\">");
            pgmOut.println("         <a href=\"index.html\" class=\"el_report\">isCOBOL Coverage Report</a> &gt; " + program.name);
            pgmOut.println("       </div>");
            pgmOut.println("      <h1>" + program.name + "</h1>");
            File sf = this.findSourceFile(program.fileName);
            if (sf != null) {
                String fn = Coverage.getUnivoqueName(pgmFileNames, new File(program.fileName).getName(), ".html");
                pgmOut.println("      <div class=\"el_source_lnk\">Source file: <a href=\"" + fn + "\">" + sf.getName() + "</a></div><br>");
                File hf = new File(this.htmlDir.getAbsolutePath() + "/" + fn);
                String[][] href = new String[][]{{"index.html", "isCOBOL Coverage Report"}, {fn, program.name}};
                TreeMap<CoverageStatement, CoverageStatement> map = new TreeMap<CoverageStatement, CoverageStatement>();
                Collection<CoverageParagraph> paragraphs = program.getParagraphs();
                for (CoverageParagraph paragraph : paragraphs) {
                    Collection<CoverageStatement> statements = paragraph.getStatements();
                    for (CoverageStatement stmt : statements) {
                        map.put(stmt, stmt);
                    }
                }
                this.createSourceHtmlFile(sf, 0, hf, program, map, href, pgmFileNames);
            } else {
                pgmOut.println("      <div class=\"el_source_lnk\">Source file not found</div><br>");
            }
            pgmOut.println("      <table class=\"coverage\" cellspacing=\"0\" id=\"coveragetable\">");
            pgmOut.println("        <thead>");
            pgmOut.println("          <tr>");
            pgmOut.println("            <td class=\"sortable\" id=\"a\" onclick=\"toggleSort(this)\">Paragraph</td>");
            pgmOut.println("            <td class=\"down sortable bar\" id=\"b\" onclick=\"toggleSort(this)\">Statements Coverage</td>");
            pgmOut.println("            <td class=\"sortable ctr2\" id=\"c\" onclick=\"toggleSort(this)\">Covered Stmts</td>");
            pgmOut.println("            <td class=\"sortable ctr1\" id=\"d\" onclick=\"toggleSort(this)\">Missed Stmts</td>");
            pgmOut.println("              <td class=\"sortable ctr2\" id=\"e\" onclick=\"toggleSort(this)\">Total Stmts</td>");
            pgmOut.println("          </tr>");
            pgmOut.println("        </thead>");
            pgmOut.println("        <tfoot>");
            pgmOut.println("          <tr>");
            pgmOut.println("            <td>Total</td>");
            missed = program.getMissedStatements();
            total = program.getTotalStatements();
            covRatio = 0.0;
            if (total > 0) {
                covRatio = 1.0 - (double)missed / (double)total;
            }
            covW = (int)Math.round(covRatio * 120.0);
            s = null;
            if (total > 0) {
                if (missed > 0) {
                    s = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - covW) + "\" height=\"" + 10 + "\" title=\"" + missed + "\" alt=\"" + missed + "\" />";
                }
                if (missed < total) {
                    if (s == null) {
                        s = "               ";
                    }
                    s = s + "<img src=\"resources/greenbar.gif\" width=\"" + covW + "\" height=\"" + 10 + "\" title=\"" + (total - missed) + "\" alt=\"" + (total - missed) + "\" />";
                }
            }
            pgmOut.println("            <td class=\"bar\">" + (s != null ? s : "") + nbspTot + Coverage.percFormat(covRatio) + "</td>");
            pgmOut.println("            <td class=\"ctr2\">" + intFormat.format(total - missed) + "</td>");
            pgmOut.println("            <td class=\"ctr1\">" + intFormat.format(missed) + "</td>");
            pgmOut.println("            <td class=\"ctr2\">" + intFormat.format(total) + "</td>");
            pgmOut.println("          </tr>");
            pgmOut.println("        </tfoot>");
            pgmOut.println("        <tbody>");
            ArrayList<CoverageParagraph> paragraphs = new ArrayList<CoverageParagraph>(program.getParagraphs());
            Collections.sort(paragraphs, new ParagraphComparator(0));
            ArrayList<CoverageParagraph> tmp1 = new ArrayList<CoverageParagraph>(paragraphs);
            int[][] sortPos1 = new int[tmp1.size()][9];
            for (int i = 0; i < sortPos1.length; ++i) {
                sortPos1[i][0] = i;
            }
            for (int colIdx = 1; colIdx < 5; ++colIdx) {
                Collections.sort(tmp1, new ParagraphComparator(colIdx));
                block12: for (int i1 = 0; i1 < paragraphs.size(); ++i1) {
                    for (int i2 = 0; i2 < tmp1.size(); ++i2) {
                        if (paragraphs.get(i1) != tmp1.get(i2)) continue;
                        sortPos1[i1][colIdx] = i2;
                        continue block12;
                    }
                }
            }
            int parIdx = 0;
            for (CoverageParagraph paragraph : paragraphs) {
                missed = paragraph.getMissedStatements();
                total = paragraph.getTotalStatements();
                covRatio = paragraph.getStatementCoverageRatio();
                covW = (int)Math.round(covRatio * 120.0);
                pgmOut.println("          <tr>");
                pgmOut.println("            <td id=\"a" + sortPos1[parIdx][0] + "\"> <span class=\"el_paragraph\">" + Coverage.removePrefix(paragraph.name) + "</span> </td>");
                pgmOut.println("            <td class=\"bar\" id=\"b" + sortPos1[parIdx][1] + "\">");
                if (total > 0) {
                    s = null;
                    if (missed > 0) {
                        s = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - covW) + "\" height=\"" + 10 + "\" title=\"" + missed + "\" alt=\"" + missed + "\" />";
                    }
                    if (missed < total) {
                        if (s == null) {
                            s = "                 ";
                        }
                        s = s + "<img src=\"resources/greenbar.gif\" width=\"" + covW + "\" height=\"" + 10 + "\" title=\"" + (total - missed) + "\" alt=\"" + (total - missed) + "\" />";
                    }
                    pgmOut.println(s);
                }
                pgmOut.println("            " + nbsp + (total > 0 ? Coverage.percFormat(covRatio) : "n/a") + "</td>");
                pgmOut.println("            <td class=\"ctr2\" id=\"c" + sortPos1[parIdx][2] + "\">" + (total > 0 ? intFormat.format(total - missed) : "n/a") + "</td>");
                pgmOut.println("            <td class=\"ctr1\" id=\"d" + sortPos1[parIdx][3] + "\">" + (total > 0 ? intFormat.format(missed) : "n/a") + "</td>");
                pgmOut.println("            <td class=\"ctr2\" id=\"e" + sortPos1[parIdx][4] + "\">" + (total > 0 ? intFormat.format(total) : "n/a") + "</td>");
                pgmOut.println("          </tr>");
                ++parIdx;
            }
            pgmOut.println("      </tbody>");
            pgmOut.println("    </table>");
            pgmOut.println("  </body>");
            pgmOut.println("</html>");
            pgmOut.close();
            ++pgmIdx;
        }
        out.println("        </tbody>");
        out.println("      </table>");
        out.println("   </body>");
        out.println("</html>");
        out.close();
    }

    private void writeHtml(PrintStream out, CoverageSession.Name n) {
        out.println("          <tr>");
        out.println("            <td>");
        out.println("              <span class=\"el_session\">" + n.name + "</span>");
        out.println("            </td>");
        calendar.setTimeInMillis(n.timestamp);
        out.println("            <td>" + dateFormat.format(calendar.getTime()) + "</td>");
        out.println("          </tr>");
    }

    private static String removePrefix(String parName) {
        if (parName.startsWith("declarative$")) {
            parName = parName.substring(12);
        }
        return parName;
    }

    private void createSourceHtmlFile(File sf, int fileIndex, File hf, CoverageProgram program, Map<CoverageStatement, CoverageStatement> map, String[][] href, Set<String> names) throws IOException {
        PrintStream out = new PrintStream(hf);
        out.println("<html>");
        out.println("  <head>");
        out.println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        out.println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
        out.println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
        out.println("    <link rel=\"stylesheet\" href=\"resources/prettify.css\" type=\"text/css\"/>");
        out.println("    <title>" + sf.getName() + "</title>");
        out.println("    <script type=\"text/javascript\" src=\"resources/prettify.js\"></script>");
        out.println("   </head>");
        out.println("   <body onload=\"window['PR_TAB_WIDTH']=3;prettyPrint()\">");
        out.println("      <div class=\"breadcrumb\" id=\"breadcrumb\">");
        out.print("         ");
        for (int i = 0; i < href.length; ++i) {
            if (i > 0) {
                out.print(" &gt; ");
            }
            out.print("<a href=\"" + href[i][0] + "\"");
            if (i == 0) {
                out.print(" class=\"el_report\"");
            }
            out.print(">" + href[i][1] + "</a>");
        }
        out.println();
        out.println("      </div>");
        out.println("      <h1>" + sf.getName() + "</h1>");
        out.println("      <pre class=\"source lang-cbl linenums\">");
        BufferedReader rdr = new BufferedReader(new InputStreamReader(new FileInputStream(sf)));
        int lineNumber = 1;
        String line = rdr.readLine();
        while (line != null) {
            CoverageStatement stmt = new CoverageStatement();
            stmt.lineNumber = lineNumber;
            stmt.fileName = sf.getPath();
            stmt.fileIndex = fileIndex;
            CoverageStatement stmt0 = map.get(stmt);
            String color = stmt0 != null ? stmt0.color : null;
            String c = null;
            if ("green".equals(color)) {
                c = "fc";
            } else if ("red".equals(color)) {
                c = "nc";
            } else if ("yellow".equals(color)) {
                c = "pc";
            }
            if (c != null) {
                out.println("<span class=\"" + c + "\" id=\"L" + lineNumber + "\">" + Coverage.escapeText(line) + "</span>");
            } else {
                CoverageCopyStatement cstmt = program.getCopyStatement(stmt);
                File cfn = null;
                if (cstmt != null) {
                    cfn = this.findSourceFile(cstmt.copyName);
                }
                if (cfn != null) {
                    int noSpIdx;
                    for (noSpIdx = 0; noSpIdx < line.length() && (line.charAt(noSpIdx) == ' ' || line.charAt(noSpIdx) == '\t'); ++noSpIdx) {
                    }
                    if (noSpIdx > 0) {
                        out.print(Coverage.escapeText(line.substring(0, noSpIdx)));
                    }
                    String htmlCopyName = Coverage.getUnivoqueName(names, program.name + "-" + cstmt.lineNumber + "-" + new File(cstmt.copyName).getName(), ".html");
                    out.println("<a href=\"" + htmlCopyName + "\">" + Coverage.escapeText(line.trim()) + "</a>");
                    File chf = new File(hf.getParent() + "/" + htmlCopyName);
                    String[][] newHref = new String[href.length + 1][2];
                    System.arraycopy(href, 0, newHref, 0, href.length);
                    newHref[href.length][0] = hf.getName();
                    newHref[href.length][1] = sf.getName();
                    this.createSourceHtmlFile(cfn, cstmt.copyIndex, chf, program, map, newHref, names);
                } else {
                    out.println(Coverage.escapeText(line));
                }
            }
            ++lineNumber;
            line = rdr.readLine();
        }
        rdr.close();
        out.println("      </pre>");
        out.println("   </body>");
        out.println("</html>");
        out.close();
    }

    private static String escapeText(String text) {
        StringBuffer sb = new StringBuffer();
        char[] c = text.toCharArray();
        block9: for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    continue block9;
                }
                case '\u00a0': {
                    sb.append("&nbsp;");
                    continue block9;
                }
                case ' ': {
                    sb.append(c[i]);
                    continue block9;
                }
                default: {
                    sb.append(c[i]);
                }
            }
        }
        return sb.toString();
    }

    private File findSourceFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        File sf = new File(fileName);
        if (sf.exists() && sf.isFile()) {
            return sf;
        }
        if (sf.isAbsolute()) {
            return this.findSourceFile0(sf.getName());
        }
        File sf0 = this.findSourceFile0(fileName);
        if (sf0 != null) {
            return sf0;
        }
        return this.findSourceFile0(sf.getName());
    }

    private File findSourceFile0(String fileName) {
        if (this.sourcePaths != null) {
            for (File f : this.sourcePaths) {
                File sf = new File(f.getAbsolutePath() + "/" + fileName);
                if (!sf.exists() || !sf.isFile()) continue;
                return sf;
            }
        }
        return null;
    }

    public static void main(String[] argv) throws Exception {
        int i;
        Coverage coverage = Coverage.getSharedInstance("coverage", 1);
        String profHtmlDir = null;
        String profXmlFile = null;
        String profIncludes = null;
        String profExcludes = null;
        boolean profileFlag = false;
        boolean coverageFlag = false;
        for (i = 0; i < argv.length && !argv[i].equals("--runargs"); ++i) {
            if ("--classfiles".equals(argv[i])) {
                coverage.setClassfiles(argv[++i]);
                continue;
            }
            if ("--sourcefiles".equals(argv[i])) {
                coverage.setSourcefiles(argv[++i]);
                continue;
            }
            if ("--html".equals(argv[i])) {
                coverage.htmlDir = new File(argv[++i]);
                continue;
            }
            if ("--xml".equals(argv[i])) {
                coverage.xmlFile = new File(argv[++i]);
                continue;
            }
            if ("--includes".equals(argv[i])) {
                coverage.setIncludes(argv[++i]);
                continue;
            }
            if ("--excludes".equals(argv[i])) {
                coverage.setExcludes(argv[++i]);
                continue;
            }
            if ("--append".equals(argv[i])) {
                coverage.setAppend(argv[++i]);
                continue;
            }
            if ("--sessionname".equals(argv[i])) {
                coverage.sessionTitle = argv[++i];
                continue;
            }
            if ("--profiler".equals(argv[i])) {
                profileFlag = true;
                continue;
            }
            if ("--coverage".equals(argv[i])) {
                coverageFlag = true;
                continue;
            }
            if ("--profilerincludes".equals(argv[i])) {
                profIncludes = argv[++i];
                continue;
            }
            if ("--profilerexcludes".equals(argv[i])) {
                profExcludes = argv[++i];
                continue;
            }
            if ("--profilerxml".equals(argv[i])) {
                profXmlFile = argv[++i];
                continue;
            }
            if (!"--profilerhtml".equals(argv[i])) continue;
            profHtmlDir = argv[++i];
        }
        if (!coverageFlag && !profileFlag) {
            coverage.coverage = true;
        } else {
            coverage.coverage = coverageFlag;
            coverage.profile = profileFlag;
        }
        if (coverage.profile) {
            coverage.startProfileSession(profIncludes, profExcludes, profHtmlDir, profXmlFile);
        }
        coverage.intStartSession();
        String[] isrunArgv = new String[argv.length - ++i];
        System.arraycopy(argv, i, isrunArgv, 0, isrunArgv.length);
        Class.forName("com.iscobol.invoke.Isrun").getMethod("main", String[].class).invoke(null, new Object[]{isrunArgv});
    }

    private static String getUnivoqueName(Set<String> names, String n, String sfx) {
        String Return2 = n + sfx;
        int prog = 0;
        while (names.contains(Return2)) {
            Return2 = n + "_" + ++prog + sfx;
        }
        names.add(Return2);
        return Return2;
    }

    private byte[] instrumentClass(MyClass c, byte[] classfileBuffer, String className, int flags, ClassLoader ext) throws Throwable {
        if (Coverage.isCoverage(flags)) {
            classfileBuffer = this.instrumenter.instrument(classfileBuffer, className);
        }
        if (Coverage.isProfile(flags)) {
            MyClass ec = null;
            if (c.isAssignableTo(iscobolModule) || (ec = c.getEnclosingClass()) != null && c.getName().matches(".+\\$\\d*inner_\\d+")) {
                boolean debug = (ec != null ? ec : c).isAssignableTo(iscobolDebugger);
                classfileBuffer = this.profiler.getTransformer().transformBytes(classfileBuffer, ext, debug);
            }
        }
        return classfileBuffer;
    }

    private static boolean isCoverage(int flags) {
        return (flags & 1) == 1;
    }

    private static boolean isProfile(int flags) {
        return (flags & 2) == 2;
    }

    private static String percFormat(double d) {
        String Return2 = percFormat.format(d);
        int n = 7 - Return2.length();
        if (n > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                sb.append("&nbsp;");
                sb.append("&nbsp;");
            }
            sb.append(Return2);
            Return2 = sb.toString();
        }
        return Return2;
    }

    public void loadResources() {
        this.resourcesStream = new HashMap<String, byte[]>();
        for (String resourceName : resources) {
            try {
                InputStream in = this.getClass().getClassLoader().getResourceAsStream("com/iscobol/coverage/resources/" + resourceName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buff = new byte[4096];
                int r = in.read(buff);
                while (r >= 0) {
                    out.write(buff, 0, r);
                    r = in.read(buff);
                }
                in.close();
                out.close();
                this.resourcesStream.put(resourceName, out.toByteArray());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void createResources() throws IOException {
        this.createResources(null);
    }

    @Override
    public void createResources(String htm) throws IOException {
        if (htm != null) {
            this.htmlDir = new File(htm);
            if (this.htmlDir == null) {
                return;
            }
        }
        File res = new File(this.htmlDir.getAbsolutePath() + "/resources");
        res.mkdir();
        if (this.resourcesStream == null) {
            this.loadResources();
        }
        for (String rn : this.resourcesStream.keySet()) {
            try {
                FileOutputStream out = new FileOutputStream(new File(res.getAbsolutePath() + "/" + rn));
                ((OutputStream)out).write(this.resourcesStream.get(rn));
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static byte[] readBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int r = is.read(buf);
        while (r >= 0) {
            baos.write(buf, 0, r);
            r = is.read(buf);
        }
        is.close();
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public void set(String[] type, File[] outputPath) {
        ArrayList<File> append = new ArrayList<File>();
        for (int i = 0; i < type.length; ++i) {
            if ("xml".equalsIgnoreCase(type[i])) {
                this.xmlFile = outputPath[i];
                continue;
            }
            if ("html".equalsIgnoreCase(type[i])) {
                this.htmlDir = outputPath[i];
                continue;
            }
            if (!"append".equalsIgnoreCase(type[i]) || outputPath[i] == null) continue;
            append.add(outputPath[i]);
        }
        if (!append.isEmpty()) {
            this.xmlAppend = append.toArray(new File[append.size()]);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.coverage;
    }

    public static int coverageFlush() {
        Coverage c = Coverage.getCoverage();
        if (c != null) {
            if (c.shutdownAndPrintReports()) {
                try {
                    c.startup(true);
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 2;
                }
            }
            return 2;
        }
        return 1;
    }

    public static int coverageSet(String[] type, File[] outputPath) {
        Coverage c = Coverage.getCoverage();
        if (c != null) {
            c.set(type, outputPath);
            return 0;
        }
        return 1;
    }

    public static Coverage getCoverage() {
        return sharedInstance;
    }

    public static Coverage getSharedInstance(String sessionName, File htmlDir, File xmlFile, String includes, String excludes, String append, String sourceFiles, String classFiles) {
        if (sharedInstance == null) {
            Coverage c = new Coverage(sessionName, htmlDir, xmlFile, includes, excludes, append, sourceFiles, classFiles);
            try {
                c.startup(false);
                c.setTransformer(new Transformer(c));
                sharedInstance = c;
                IscobolSystem.setCoverage(sharedInstance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sharedInstance;
    }

    public static Coverage getSharedInstance(String sessionName, int flags) {
        if (sharedInstance == null) {
            Coverage c;
            sharedInstance = c = new Coverage(sessionName, flags);
            IscobolSystem.setCoverage(sharedInstance);
        }
        return sharedInstance;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    static {
        Class<Object> d;
        dateFormat = DateFormat.getDateTimeInstance(1, 2);
        calendar = Calendar.getInstance();
        resources = new String[]{"down.gif", "greenbar.gif", "paragraph.gif", "prettify.css", "prettify.js", "program.gif", "redbar.gif", "report.css", "report.gif", "sort.gif", "sort.js", "up.gif"};
        iscobolCall = IscobolCall.class;
        iscobolClass = IscobolClass.class;
        iscobolModule = IscobolModule.class;
        percFormat = NumberFormat.getPercentInstance();
        percFormat.setMinimumFractionDigits(2);
        intFormat = NumberFormat.getIntegerInstance();
        try {
            d = Class.forName("com.iscobol.debugger.IscobolDebugger");
        }
        catch (ClassNotFoundException e) {
            d = Object.class;
        }
        iscobolDebugger = d;
        HashSet<String> s = new HashSet<String>();
        s.add("com.iscobol.lib");
        s.add("com.iscobol.lib_n");
        s.add("com.iscobol.so");
        s.add("com.iscobol.son");
        invalidPackageNames = Collections.unmodifiableSet(s);
    }

    private static class ClassLocation {
        final String location;
        final Map<String, ClassDef> definitions = new HashMap<String, ClassDef>();
        final Map<String, ClassDef> originals = new HashMap<String, ClassDef>();
        MemoryClassLoader memoryCL;

        ClassLocation(String loc) {
            this.location = loc;
        }
    }

    private static class ProgramComparator
    implements Comparator<CoverageProgram> {
        int colIdx;

        ProgramComparator(int c) {
            this.colIdx = c;
        }

        @Override
        public int compare(CoverageProgram o1, CoverageProgram o2) {
            switch (this.colIdx) {
                default: {
                    return o1.name.compareTo(o2.name);
                }
                case 1: {
                    double d = o1.getStatementCoverageRatio() - o2.getStatementCoverageRatio();
                    return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
                }
                case 2: {
                    return o1.getTotalStatements() - o1.getMissedStatements() - o2.getTotalStatements() + o2.getMissedStatements();
                }
                case 3: {
                    return o1.getMissedStatements() - o2.getMissedStatements();
                }
                case 4: {
                    return o1.getTotalStatements() - o2.getTotalStatements();
                }
                case 5: {
                    double d = o1.getParagraphCoverageRatio() - o2.getParagraphCoverageRatio();
                    return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
                }
                case 6: {
                    return o1.getTotalParagraphs() - o1.getMissedParagraphs() - o2.getTotalParagraphs() + o2.getMissedParagraphs();
                }
                case 7: {
                    return o1.getMissedParagraphs() - o2.getMissedParagraphs();
                }
                case 8: 
            }
            return o1.getTotalParagraphs() - o2.getTotalParagraphs();
        }
    }

    private static class ParagraphComparator
    implements Comparator<CoverageParagraph> {
        int colIdx;

        ParagraphComparator(int c) {
            this.colIdx = c;
        }

        @Override
        public int compare(CoverageParagraph o1, CoverageParagraph o2) {
            switch (this.colIdx) {
                default: {
                    return o1.name.compareTo(o2.name);
                }
                case 1: {
                    double d = o1.getStatementCoverageRatio() - o2.getStatementCoverageRatio();
                    return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
                }
                case 2: {
                    return o1.getTotalStatements() - o1.getMissedStatements() - o2.getTotalStatements() + o2.getMissedStatements();
                }
                case 3: {
                    return o1.getMissedStatements() - o2.getMissedStatements();
                }
                case 4: 
            }
            return o1.getTotalStatements() - o2.getTotalStatements();
        }
    }

    private static class MyClass {
        private static ClassPool classPool;
        CtClass ctc;
        Class cl;

        static ClassPool getClassPool() {
            if (classPool == null) {
                classPool = ClassPool.getDefault();
                try {
                    classPool.get(Coverage.class.getName());
                }
                catch (Exception ex) {
                    ClassLoader cl = classPool.getClassLoader();
                    classPool = new ClassPool(classPool);
                    classPool.appendClassPath((ClassPath)new LoaderClassPath(cl));
                }
            }
            return classPool;
        }

        MyClass(Class cl) {
            this.cl = cl;
        }

        MyClass(byte[] b) throws IOException {
            this(MyClass.getClassPool().makeClass((InputStream)new ByteArrayInputStream(b)));
        }

        MyClass(CtClass ctc) {
            this.ctc = ctc;
        }

        String getName() {
            return this.cl != null ? this.cl.getName() : this.ctc.getName();
        }

        boolean isInterface() {
            return this.cl != null ? this.cl.isInterface() : this.ctc.isInterface();
        }

        String getPackageName() {
            if (this.cl != null) {
                Package pkg = this.cl.getPackage();
                return pkg != null ? pkg.getName() : null;
            }
            return this.ctc.getPackageName();
        }

        boolean isAssignableTo(Class intf) {
            return this.cl != null ? intf.isAssignableFrom(this.cl) : this.Implements(intf.getName());
        }

        boolean Implements(String intfName) {
            try {
                for (CtClass intf : this.ctc.getInterfaces()) {
                    if (!intfName.equals(intf.getName())) continue;
                    return true;
                }
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            return false;
        }

        File getLocation() {
            if (this.cl == null) {
                return null;
            }
            URL url = this.cl.getProtectionDomain().getCodeSource().getLocation();
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e1) {
                return new File(url.getPath());
            }
        }

        MyClass getEnclosingClass() {
            if (this.cl != null) {
                Class<?> ec = this.cl.getEnclosingClass();
                return ec != null ? new MyClass(ec) : null;
            }
            try {
                CtClass dc = this.ctc.getDeclaringClass();
                return dc != null ? new MyClass(dc) : null;
            }
            catch (NotFoundException e) {
                return null;
            }
        }

        void detach() {
            if (this.ctc != null) {
                this.ctc.detach();
            }
        }
    }

    private static class ClassDef {
        final MyClass cl;
        final byte[] bytes;
        boolean reset;
        CoverageProgram program;
        SMAPReader sr;

        ClassDef(MyClass cl, byte[] bytes) {
            this.cl = cl;
            this.bytes = bytes;
        }

        public String toString() {
            return this.cl.getName();
        }
    }

    private class MemoryClassLoader
    extends ClassLoader
    implements ICoverageClassLoader {
        private final CLWrapper wrapper;
        private final String location;

        MemoryClassLoader(String location) {
            super(null);
            this.wrapper = new CLWrapper(Coverage.class.getClassLoader());
            this.location = location;
            if (IscobolSystem.isUnitTest()) {
                this.setDefaultAssertionStatus(true);
            }
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return Coverage.this.loadClass(this.location, name, resolve, this.wrapper);
        }

        public Class DefineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
            return super.defineClass(name, b, off, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getOriginalBytes(String className) {
            ClassDef cd;
            ClassLocation cl;
            MemoryClassLoader memoryClassLoader = this;
            synchronized (memoryClassLoader) {
                cl = (ClassLocation)Coverage.this.classLocations.get(this.location);
            }
            if (cl != null && (cd = cl.originals.get(className)) != null) {
                return cd.bytes;
            }
            return null;
        }
    }

    private static class CLWrapper
    extends ClassLoader {
        CLWrapper(ClassLoader p) {
            super(p);
        }

        public Class LoadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

