/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.as.ClientThread;
import com.iscobol.as.Login;
import com.iscobol.compiler.remote.client.ICallback;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.compiler.remote.server.RemoteCompilerHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import java.io.File;

public class IDERemoteCompilerHandler
extends RemoteCompilerHandler {
    private final DualRpcServerDispatcher caller;
    private final byte[] challenge;
    private final int auth;

    public IDERemoteCompilerHandler(DualRpcServerDispatcher d) {
        super(d);
        d.setDefaultCallTimeoutInSeconds(0);
        this.auth = Config.getProperty("iscobol.as.authentication", 1);
        this.challenge = this.auth == 0 ? Auth.nullChallenge() : Auth.newChallenge();
        this.caller = d;
        RemoteCompiler.getInstance().setIde(true);
    }

    public String clean(String[] files) {
        if (this.checkLogin(null)) {
            for (String fs : files) {
                File f = new File(fs);
                if (!f.isFile() || !f.exists()) continue;
                f.delete();
            }
            return null;
        }
        return "login failed";
    }

    public boolean[] needsToBeCompiled(String[] files, long[] timestamps) {
        boolean[] Return2 = new boolean[files.length];
        int i = 0;
        for (String fs : files) {
            File f = new File(fs);
            Return2[i] = !f.exists() || f.lastModified() < timestamps[i];
            ++i;
        }
        return Return2;
    }

    @Override
    protected boolean checkLogin(ICallback cb) {
        if (this.auth != 2) {
            return true;
        }
        try {
            boolean retry = false;
            while (true) {
                Object[] u;
                if ((u = (Object[])this.caller.call("com.iscobol.gui.client.IDEClientHandler", "login", this.challenge, (Object)retry)) == null || u.length < 2 || u[0] == null || u[1] == null) {
                    return false;
                }
                Login login = new Login();
                String user = (String)u[0];
                byte[] pwd = (byte[])u[1];
                if (login.checkLogin(user, pwd, this.challenge, ClientThread.AUTH_FILE) == null) {
                    retry = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

