/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.compiler.remote.PPFileOutput;
import com.iscobol.interfaces.compiler.ClassFileFinder;
import com.iscobol.interfaces.compiler.FileFinder;
import java.io.File;

public class RemoteFileFinder
implements FileFinder,
ClassFileFinder {
    private final File srcDir;
    private PPFileOutput compileUnit;

    public RemoteFileFinder(File srcDir) {
        this.srcDir = srcDir;
    }

    @Override
    public File findClassFile(String classFileName) {
        return this._findFile(classFileName, true);
    }

    @Override
    public File findFile(String name) {
        return this._findFile(name, false);
    }

    private File _findFile(String name, boolean cls) {
        File file = new File(name);
        if (file.exists() && file.isFile()) {
            return file;
        }
        if (!file.isAbsolute()) {
            file = new File(this.srcDir.getAbsolutePath() + "/" + name);
            if (file.exists() && file.isFile()) {
                return file;
            }
            if (cls) {
                return null;
            }
        }
        if ((file = new File(this.srcDir.getAbsolutePath() + "/" + file.getName())).exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    public void setCompileUnit(PPFileOutput cu) {
        this.compileUnit = cu;
    }

    public PPFileOutput getCompileUnit() {
        return this.compileUnit;
    }

    public String getSourceDir() {
        return this.srcDir.getAbsolutePath();
    }
}

