/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.phases;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.phases.Phases;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class PhasesFactory {
    private static final String STANDARD_VERSION_PHASES = "com.iscobol.compiler.StandardPhases";

    private PhasesFactory() {
    }

    public static Phases create(OptionList ol) {
        String phasesClassName = STANDARD_VERSION_PHASES;
        try {
            try {
                return PhasesFactory.createPhases(STANDARD_VERSION_PHASES, PhasesFactory.class.getClassLoader(), ol);
            }
            catch (ClassNotFoundException e) {
                ClassLoader ctxCl = Thread.currentThread().getContextClassLoader();
                if (ctxCl != null) {
                    return PhasesFactory.createPhases(STANDARD_VERSION_PHASES, ctxCl, ol);
                }
                throw e;
            }
        }
        catch (InvocationTargetException e1) {
            throw new Error("Internal Logic error - could not load class com.iscobol.compiler.StandardPhases", e1.getCause());
        }
        catch (Exception e1) {
            throw new Error("Internal Logic error - could not load class com.iscobol.compiler.StandardPhases", e1);
        }
    }

    private static Phases createPhases(String phasesClassName, ClassLoader cl, OptionList options) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = cl.loadClass(phasesClassName);
        if (!Phases.class.isAssignableFrom(clazz)) {
            throw new InstantiationException("Not a valid class");
        }
        try {
            Class[] consArgClasses = new Class[]{OptionList.class};
            Constructor<?> cons = clazz.getConstructor(consArgClasses);
            Object[] consArgs = new Object[]{options};
            return (Phases)cons.newInstance(consArgs);
        }
        catch (NoSuchMethodException e) {
            Class[] consArgClasses = new Class[]{};
            Constructor<?> cons = clazz.getConstructor(consArgClasses);
            Object[] consArgs = new Object[]{};
            return (Phases)cons.newInstance(consArgs);
        }
    }
}

