/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Move;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.Config;

public class Write
extends Verb
implements CobolToken,
ErrorsNumbers {
    private static final int XML_WRITE_DEFAULT = 0;
    private static final int XML_WRITE_ALL = 1;
    private static final int XML_WRITE_PROCESSING_INSTRUCTION = 2;
    private static final int XML_WRITE_PLAIN_TEXT = 3;
    private VariableDeclaration record;
    private FileDescriptor fd;
    private VariableName fromVar;
    private Token fromToken;
    private VariableName sizeVar;
    private Token sizeToken;
    private Token advancing;
    private boolean page;
    private int chnl;
    private Token nLinesToken;
    private VariableName nLinesVar;
    private VariableName positioningVar;
    private Block eopBlock;
    private Block notEopBlock;
    private InvalidKey invKey;
    private boolean lock;
    private boolean noStrip;
    private boolean noCr;
    private Token keyNameTk;
    private VariableName keyNameVn;
    private int xmlWrite;
    private static boolean m27333 = Config.getProperty(".compiler.m27333", true);

    /*
     * Enabled aggressive block sorting
     */
    public Write(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            VariableName vn = VariableName.get(this.tm, this.error, null, this.pc, true, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
            this.record = vn.getVarDecl();
            this.fd = this.pc.getFdByRecord(this.record);
            if (this.fd != null && !this.fd.isXml()) {
                VariableName.checkDynGroup(vn, false, this.error);
            }
        } else {
            if (tk.getToknum() != 483) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            this.fd = this.pc.data.fileSec.getFD(tk.getWord());
            if (this.fd != null) {
                this.record = this.fd.recordDesc.getFirst();
            }
        }
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (this.fd.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, this.fd.sel.fileName.getWord(), this.error);
        }
        if (this.fd.isXml()) {
            boolean pi;
            tk = this.tm.getToken();
            if (tk.getToknum() != 552) {
                this.tm.ungetToken();
                return;
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 546) {
                tk = this.tm.getToken();
            }
            if ((pi = "PROCESSING-INSTRUCTION".equals(tk.getWord())) || "PLAIN-TEXT".equals(tk.getWord())) {
                tk = this.tm.getToken();
                switch (tk.getToknum()) {
                    case 10009: {
                        this.tm.ungetToken();
                        this.keyNameVn = VariableName.get(this.tm, this.error, this.pc);
                        if (this.keyNameVn.isNumeric()) throw new GeneralErrorException(21, 4, this.keyWord, tk.getWord(), this.error);
                        if (!this.keyNameVn.isObjectReference()) break;
                        throw new GeneralErrorException(21, 4, this.keyWord, tk.getWord(), this.error);
                    }
                    case 10001: {
                        this.keyNameTk = tk;
                        break;
                    }
                    default: {
                        throw new GeneralErrorException(21, 4, this.keyWord, tk.getWord(), this.error);
                    }
                }
                this.xmlWrite = pi ? 2 : 3;
                return;
            }
            if (tk.getToknum() != 10009) return;
            this.xmlWrite = tk.isAll() ? 1 : 0;
            this.tm.ungetToken();
            this.keyNameVn = VariableName.get(this.tm, this.error, this.pc);
            if (this.keyNameVn.isNumeric()) throw new GeneralErrorException(66, 4, this.keyWord, tk.getWord(), this.error);
            if (!this.keyNameVn.isObjectReference()) return;
            throw new GeneralErrorException(66, 4, this.keyWord, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 499) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.fromVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (tk.getToknum() != 10001 && tk.getToknum() != 10002) {
                    if (tk.getToknum() != 10017) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                }
                this.fromToken = tk;
            }
        } else {
            this.tm.ungetToken();
        }
        if (this.fd.sel.organization == 718) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 814 || tk.getToknum() == 597) {
                this.seqWithNo(tk);
            } else {
                this.sequential(tk);
            }
        } else {
            this.random();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 455) {
            this.tm.ungetToken();
            return;
        }
        this.endStmt = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void seqWithNo(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (tk.getToknum() == 814) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 597) {
            throw new ExpectedFoundException(tk, this.error, "NO");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 373) {
            this.noCr = true;
        } else {
            if (tk.getToknum() != 376) throw new ExpectedFoundException(tk, this.error, "CONVERSION|CONTROL");
            this.noCr = true;
            this.noStrip = true;
        }
        this.fd.sel.isPrinter = true;
        this.fd.sel.isPrinterTok = tk;
        tk = this.tm.getToken();
        if (tk.getToknum() == 729) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.sizeVar = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                if (!Token.isNumLit(tk)) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                this.sizeToken = tk;
            }
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sequential(Token tk) throws GeneralErrorException, EndOfProgramException {
        boolean cvFlag;
        boolean not = false;
        boolean bl = cvFlag = this.pc.getOption("-cv") != null;
        if (!this.fd.sel.writeSimple && this.fd.sel.isPrinterTok != null && this.fd.sel.isPrinterTok.getToknum() == 373 && tk.getToknum() != 299 && tk.getToknum() != 261 && tk.getToknum() != 599 && tk.getToknum() != 729 && tk.getToknum() != 284 && tk.getToknum() != 461 && tk.getToknum() != 440) {
            this.fd.sel.writeSimple = true;
        }
        if (tk.getToknum() == 299 || tk.getToknum() == 261) {
            if (tk.getToknum() == 299) {
                this.fd.sel.hasBefore = true;
            }
            this.fd.sel.isPrinter = true;
            this.advancing = tk;
            tk = this.tm.getToken();
            if (cvFlag && "POSITIONING".equals(tk.getWord())) {
                tk = this.tm.getToken();
                if (Token.isIntLit(tk)) {
                    switch (Integer.parseInt(tk.getWord())) {
                        case 0: {
                            this.page = true;
                            break;
                        }
                        default: {
                            tk.setWord("1");
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.nLinesToken = tk;
                            break;
                        }
                    }
                } else {
                    if (tk.getToknum() != 10009) throw new UnexpectedTokenException(tk, this.error);
                    this.tm.ungetToken();
                    this.positioningVar = VariableName.get(this.tm, this.error, this.pc);
                }
                tk = this.tm.getToken();
                if (tk.getToknum() == 566 || tk.getToknum() == 567) {
                    tk = this.tm.getToken();
                }
            } else {
                if (tk.getToknum() == 260) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 630) {
                    this.page = true;
                    tk = this.tm.getToken();
                } else {
                    if (tk.getToknum() != 10009 && !Token.isIntLit(tk)) throw new UnexpectedTokenException(tk, this.error);
                    if (tk.getToknum() == 10002) {
                        this.nLinesToken = tk;
                    } else {
                        String c = this.pc.getSNFunc(tk.getWord());
                        if (c != null && cvFlag && ("CSP".equals(c) || "C01".equals(c) || "C02".equals(c) || "C03".equals(c) || "C04".equals(c) || "C05".equals(c) || "C06".equals(c) || "C07".equals(c) || "C08".equals(c) || "C09".equals(c) || "C10".equals(c) || "C11".equals(c) || "C12".equals(c) || "AFP-5A".equals(c))) {
                            if ("AFP-5A".equals(c)) {
                                this.chnl = 13;
                            } else if ("CSP".equals(c)) {
                                tk.setToknum(10002);
                                tk.setWord("0");
                                this.nLinesToken = tk;
                            } else {
                                this.chnl = Integer.parseInt(c.substring(1));
                            }
                        } else {
                            this.tm.ungetToken();
                            this.nLinesVar = VariableName.get(this.tm, this.error, this.pc);
                            if (!this.nLinesVar.getVarDecl().isNumeric()) {
                                throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                            }
                        }
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 566 || tk.getToknum() == 567) {
                        tk = this.tm.getToken();
                    }
                }
            }
        }
        if (tk.getToknum() == 729) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.sizeVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (!Token.isNumLit(tk)) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                this.sizeToken = tk;
            }
            tk = this.tm.getToken();
        }
        TokenManager.Marker mk = this.tm.getMarker();
        this.tm.setMarker(mk);
        if (tk.getToknum() == 599) {
            not = true;
            tk = this.tm.getToken();
            if (tk.getToknum() != 284 && tk.getToknum() != 461 && tk.getToknum() != 440) {
                this.tm.rewindToMarker(mk);
            }
        }
        if (tk.getToknum() == 284 && (tk = this.tm.getToken()).getToknum() != 461 && tk.getToknum() != 440) {
            this.tm.rewindToMarker(mk);
        }
        if (tk.getToknum() == 461 || tk.getToknum() == 440) {
            if (not) {
                this.notEopBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 12);
            } else {
                this.eopBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 11);
            }
            tk = this.tm.getToken();
            if (!not && tk.getToknum() == 599) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 284) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 461 && tk.getToknum() != 440) throw new ExpectedFoundException(tk, this.error, "END-OF-PAGE");
                this.notEopBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        } else if (cvFlag) {
            this.tm.ungetToken();
            this.invKey = new InvalidKey(this.keyWord, this.fd.sel, this.parent, this, this.pc, this.tm, this.error);
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    private void random() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 814 || tk.getToknum() == 571) {
            if (tk.getToknum() == 814) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 571) {
                throw new ExpectedFoundException(tk, this.error, "LOCK");
            }
            this.lock = true;
        } else {
            this.tm.ungetToken();
        }
        this.invKey = new InvalidKey(this.keyWord, this.fd.sel, this.parent, this, this.pc, this.tm, this.error);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private void putAdvancingLines(StringBuffer buff) {
        if (this.page) {
            buff.append("0");
        } else if (this.chnl > 0) {
            buff.append(this.chnl);
        } else if (this.nLinesToken != null) {
            int i;
            String tmp = this.nLinesToken.getCode();
            for (i = 0; i < tmp.length() - 1 && tmp.charAt(i) == '0'; ++i) {
            }
            buff.append(tmp.substring(i));
        } else {
            buff.append(this.nLinesVar.getCode() + ".integer()");
        }
    }

    private String putOpts() {
        if (this.noCr) {
            if (this.noStrip) {
                return "3";
            }
            return "1";
        }
        if (this.noStrip) {
            return "2";
        }
        return "0";
    }

    @Override
    public String getCode() {
        boolean hasEopBlocks;
        StringBuffer Return2 = new StringBuffer();
        boolean hasDeclaratives = this.pc.getDeclarative(this.fd.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        boolean bl = hasEopBlocks = this.eopBlock != null || this.notEopBlock != null;
        if (this.fromVar != null || this.fromToken != null) {
            Return2.append(this.parent.getIndent());
            if (this.fromVar != null) {
                Return2.append(this.fromVar.getCode());
            } else {
                Return2.append(this.getCodeLiteral(this.fromToken));
            }
            Return2.append(".moveTo");
            if (Move.isDepOnGroupItem(this.record)) {
                Return2.append("DepOnGroupItem");
            }
            Return2.append("(");
            Return2.append(this.record.getUnivoqueName());
            Return2.append(");");
            Return2.append(eol);
        }
        Return2.append(this.parent.getIndent());
        Return2.append("try {");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        if (this.fd.sel.isXml()) {
            Return2.append(this.fd.sel.getName());
            Return2.append(".writeXml(");
            Return2.append(this.record.getUnivoqueName());
            Return2.append(",");
            if (this.keyNameVn != null) {
                Return2.append(this.keyNameVn.getCode());
            } else if (this.keyNameTk != null) {
                Return2.append(this.tm.getCodeLiteral(this.keyNameTk));
            } else {
                Return2.append("null");
            }
            Return2.append(",");
            Return2.append(this.xmlWrite);
            Return2.append(");");
            Use.putFileStatus(Return2, this.fd.sel, this.parent.getIndent());
            Use.putDeclaratives(Return2, this.pc, this.fd.sel, this.parent.getIndent(), hasDeclaratives);
        } else {
            if (this.fd.sel.organization == 718) {
                if (!this.fd.sel.isPrinter) {
                    this.advancing = null;
                }
                if (hasEopBlocks) {
                    if (this.eopBlock != null) {
                        Return2.append("if (");
                    } else {
                        Return2.append("if (!");
                    }
                }
            } else {
                Return2.append(this.invKey.getCodeBefore());
            }
            Return2.append(this.fd.sel.getName());
            if (this.fd.sel.isPrinter) {
                Return2.append(".writeAdvancing (");
                if (this.positioningVar != null) {
                    Return2.append("Factory.vsPositioningType (");
                    Return2.append(this.positioningVar.getCode());
                    Return2.append("),");
                    Return2.append("Factory.vsPositioningLines (");
                    Return2.append(this.positioningVar.getCode());
                    Return2.append("),");
                } else if (this.advancing != null) {
                    if (this.advancing.getToknum() == 261) {
                        if (this.chnl > 0) {
                            Return2.append("IOConstants.ADVANCING_AFTER_CHNL,");
                        } else if (this.page) {
                            Return2.append("IOConstants.ADVANCING_AFTER_PAGE,");
                        } else {
                            Return2.append("IOConstants.ADVANCING_AFTER,");
                        }
                    } else if (this.chnl > 0) {
                        Return2.append("IOConstants.ADVANCING_BEFORE_CHNL,");
                    } else if (this.page) {
                        Return2.append("IOConstants.ADVANCING_BEFORE_PAGE,");
                    } else {
                        Return2.append("IOConstants.ADVANCING_BEFORE,");
                    }
                    this.putAdvancingLines(Return2);
                    Return2.append(",");
                } else if (this.noCr) {
                    Return2.append("IOConstants.ADVANCING_AFTER, 0,");
                } else if (m27333 && this.fd.sel.isLine() && this.pc.options.getOption("-cm") != null) {
                    Return2.append("IOConstants.ADVANCING_BEFORE, 1,");
                } else if (this.fd.sel.writeSimple) {
                    Return2.append("IOConstants.ADVANCING_BEFORE, 1,");
                } else {
                    Return2.append("IOConstants.ADVANCING_AFTER, 1,");
                }
            } else {
                Return2.append(".write(");
            }
            Return2.append(this.lock);
            Return2.append(",");
            if (this.fd.sel.organization != 678) {
                if (this.sizeVar != null) {
                    Return2.append(this.sizeVar.getCode());
                    Return2.append(".toint()");
                } else if (this.sizeToken != null) {
                    Return2.append(this.getCodeLiteral(this.sizeToken));
                    Return2.append(".toint()");
                } else if (this.record.getRecDepending() != null && this.tm.getOptionList().getOption("-crv") != null) {
                    Return2.append(this.record.getUnivoqueName() + ".length()");
                } else if (this.fd.getDepending() != null) {
                    if (this.fd.getDependingOffs() > 0) {
                        Return2.append(this.fd.getDependingOffs() + " + ");
                    }
                    Return2.append(this.fd.getDepending().getCode());
                    Return2.append(".toint()");
                } else {
                    Return2.append(this.fd.recordMin > this.record.globalLen() ? this.fd.recordMin : this.record.globalLen());
                }
            } else {
                Return2.append(this.fd.recordMin > this.record.globalLen() ? this.fd.recordMin : this.record.globalLen());
            }
            if (this.fd.sel.isPrinter) {
                Return2.append(",");
                Return2.append(this.putOpts());
            }
            Return2.append(")");
            if (this.fd.sel.organization == 718) {
                if (hasEopBlocks) {
                    Return2.append(")");
                    if (this.eopBlock != null) {
                        Return2.append(this.eopBlock.getCode());
                        if (this.notEopBlock != null) {
                            Return2.append(" else ");
                            Return2.append(this.notEopBlock.getCode());
                        }
                    } else if (this.notEopBlock != null) {
                        Return2.append(this.notEopBlock.getCode());
                    }
                } else {
                    Return2.append(";");
                }
                Use.putFileStatus(Return2, this.fd.sel, this.parent.getIndent());
            } else {
                Return2.append(";");
                Use.putFileStatus(Return2, this.fd.sel, this.parent.getIndent());
                Return2.append(this.invKey.getCode());
            }
            Use.putDeclaratives(Return2, this.pc, this.fd.sel, this.parent.getIndent(), hasDeclaratives);
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public Block getEopBlock() {
        return this.eopBlock;
    }

    public Block getNotEopBlock() {
        return this.notEopBlock;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }

    public Token getSizeToken() {
        return this.sizeToken;
    }

    public VariableName getSizeVar() {
        return this.sizeVar;
    }

    public VariableDeclaration getRecord() {
        return this.record;
    }

    public VariableName getPositioningVar() {
        return this.positioningVar;
    }

    public boolean isLock() {
        return this.lock;
    }

    public boolean isPage() {
        return this.page;
    }

    public Token getAdvancing() {
        return this.advancing;
    }

    public boolean isNoCr() {
        return this.noCr;
    }

    public boolean isNoStrip() {
        return this.noStrip;
    }

    public VariableName getNLinesVar() {
        return this.nLinesVar;
    }

    public Token getNLinesToken() {
        return this.nLinesToken;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }
}

