/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.TokenManager;
import com.iscobol.interfaces.compiler.IToken;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Hashtable;
import java.util.Locale;

public class Token
implements CobolToken,
IToken {
    static final int CPP_ADDED = -100000000;
    private static final String encoding = System.getProperty("file.encoding");
    static Hashtable reservedWords = new Hashtable();
    static Hashtable reservedWordsOrig;
    private String _word;
    private boolean upperCase;
    private boolean isAll;
    private boolean national;
    private boolean resource;
    private boolean figurative;
    private boolean hexdecimal;
    private boolean isDouble;
    private boolean isNull;
    private boolean lineRepl;
    private int token;
    private String fileName;
    private int fileLineNumber;
    private int fileIndex;
    private int offset;
    private int nativeSize;
    private int decimals;
    private int bitLen;
    private String constName;
    String doc;

    public static String version() {
        return "$Id: Token.java 39335 2025-02-14 15:39:40Z gianni_578 $";
    }

    public Token assign(Token t) {
        this._word = t._word;
        this.upperCase = t.upperCase;
        this.token = t.token;
        this.setFLN(t.fileLineNumber);
        this.offset = t.offset;
        this.fileName = t.fileName;
        this.fileIndex = t.fileIndex;
        this.hexdecimal = t.hexdecimal;
        this.isAll = t.isAll;
        this.national = t.national;
        this.bitLen = t.bitLen;
        return this;
    }

    public Token(int tok, char[] s, int start, int len, int fln, int offs, String fn) {
        StringBuffer t = new StringBuffer(len);
        len += start;
        for (int i = start; i < len && i < s.length; ++i) {
            t.append(s[i]);
        }
        this.token = tok;
        this._word = t.toString();
        this.setFLN(fln);
        this.offset = offs;
        this.fileName = fn;
    }

    public Token(char c, int fln, int offs, String fn) {
        this.token = c;
        this._word = new StringBuffer().append(c).toString();
        this.setFLN(fln);
        this.offset = offs;
        this.fileName = fn;
    }

    public Token(int tok, String s, int fln, int offs, String fn) {
        this.token = tok;
        this._word = s;
        this.setFLN(fln);
        this.offset = offs;
        this.fileName = fn;
    }

    public Token(Token t) {
        this.assign(t);
    }

    public Token combine(char op, Token other) {
        int eq = 0;
        String word = this.getWord();
        String other_word = other.getWord();
        eq = word.indexOf(44);
        BigDecimal o1 = eq > 0 ? new BigDecimal(word.substring(0, eq) + "." + word.substring(eq + 1)) : new BigDecimal(word);
        eq = 0;
        eq = other_word.indexOf(44);
        BigDecimal o2 = eq > 0 ? new BigDecimal(other_word.substring(0, eq) + "." + other_word.substring(eq + 1)) : new BigDecimal(other_word);
        switch (op) {
            case '+': {
                o1 = o1.add(o2);
                break;
            }
            case '-': {
                o1 = o1.subtract(o2);
                break;
            }
            case '*': {
                o1 = o1.multiply(o2);
                break;
            }
            case '/': {
                o1 = o1.divide(o2, RoundingMode.HALF_UP);
                break;
            }
            case '^': {
                boolean inv;
                if (o2.scale() != 0) {
                    int sc1 = o1.scale();
                    o1 = new BigDecimal(Math.pow(o1.doubleValue(), o2.doubleValue()));
                    o1 = o1.setScale(sc1, RoundingMode.HALF_UP);
                    break;
                }
                int exp = o2.intValue();
                if (exp == 0) {
                    o1 = new BigDecimal(1);
                    break;
                }
                if (exp < 0) {
                    inv = true;
                    exp = -exp;
                } else {
                    inv = false;
                }
                BigDecimal r = o1;
                for (int i = 1; i < exp; ++i) {
                    r = r.multiply(o1);
                }
                if (inv) {
                    o1 = new BigDecimal(1).divide(r, o1.scale(), RoundingMode.HALF_UP);
                    break;
                }
                o1 = r.setScale(o1.scale(), RoundingMode.HALF_UP);
                break;
            }
            default: {
                throw new IllegalArgumentException("OP=" + op);
            }
        }
        Token Return2 = new Token(this);
        Return2.setWord(o1.toString());
        return Return2;
    }

    @Override
    public int getToknum() {
        return this.token;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    int getLength() {
        return this._word.length();
    }

    @Override
    public int getFLN() {
        return this.fileLineNumber;
    }

    @Override
    public void setFLN(int fln) {
        if (fln >= 0) {
            this.fileLineNumber = fln;
            this.lineRepl = false;
        } else if (fln > -100000000) {
            this.fileLineNumber = -fln;
            this.lineRepl = true;
        } else {
            this.fileLineNumber = fln - -100000000;
        }
    }

    public boolean isLineRepl() {
        return this.lineRepl;
    }

    static final String getUpperCaseWord(String _word) {
        return _word.replace(Pcc.hyphenRepl, '-').toUpperCase(Locale.US);
    }

    private final String getUpperCaseWord() {
        return Token.getUpperCaseWord(this._word);
    }

    @Override
    public final String getOriginalWord() {
        return this._word;
    }

    @Override
    public final String getWord() {
        return this.upperCase ? Token.getUpperCaseWord(this._word) : this._word;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setWord(String s) {
        this.upperCase = false;
        this._word = s;
    }

    void setToknum(int t) {
        this.token = t;
    }

    void setOffset(int t) {
        this.offset = t;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    @Override
    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public void setAll(boolean all) {
        this.isAll = all;
    }

    void setNational(boolean n) {
        this.national = n;
    }

    void setResource(boolean n) {
        this.resource = n;
    }

    @Override
    public boolean isAll() {
        return this.isAll;
    }

    @Override
    public boolean isNational() {
        return this.national;
    }

    @Override
    public boolean isResource() {
        return this.resource;
    }

    void setFigurative(boolean f) {
        this.figurative = f;
    }

    @Override
    public boolean isFigurative() {
        return this.figurative;
    }

    void setHexdecimal(boolean f) {
        this.hexdecimal = f;
    }

    @Override
    public boolean isHexdecimal() {
        return this.hexdecimal;
    }

    public boolean isFigurativeZero() {
        return this.getFigurativeChar() == 48;
    }

    public boolean isFigurativeSpace() {
        return this.getFigurativeChar() == 32;
    }

    public boolean isFigurativeQuote() {
        return this.getFigurativeChar() == 34;
    }

    public boolean isFigurativeHighValue() {
        return this.getFigurativeChar() == 255;
    }

    void setDouble(boolean t) {
        this.isDouble = t;
    }

    boolean isDouble() {
        return this.isDouble;
    }

    void setNativeSize(int s) {
        this.nativeSize = s;
    }

    int getNativeSize() {
        return this.nativeSize;
    }

    public int getFigurativeChar() {
        if (this.figurative) {
            String word = this.getWord();
            if (this.token == 10001) {
                return word.charAt(1);
            }
            return word.charAt(0);
        }
        return -1;
    }

    @Override
    public void putKeyword(Hashtable nrw) {
        this.token = this.findResKey(nrw);
    }

    private int findResKey(Hashtable nrw) {
        String word = this.getUpperCaseWord();
        if (nrw != null && nrw.get(word) != null) {
            this.upperCase = true;
            return 10009;
        }
        Integer tok = (Integer)reservedWords.get(word);
        if (tok != null) {
            this.upperCase = true;
            return tok;
        }
        int len = word.length();
        char[] w = new char[len];
        int i = 0;
        word.getChars(0, len, w, 0);
        char c = w[0];
        if (c >= '0' && c <= '9' || c == '-' || c == '+') {
            for (i = 1; i < len && (c = w[i]) >= '0' && c <= '9'; ++i) {
            }
        }
        if (i == len) {
            return 10002;
        }
        this.upperCase = true;
        return 10009;
    }

    public static boolean changeKeyword(String oldKWord, String newKWord) {
        oldKWord = oldKWord.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        newKWord = newKWord.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        Integer tknum = (Integer)reservedWords.get(oldKWord);
        if (tknum != null && reservedWords.get(newKWord) == null) {
            reservedWords.remove(oldKWord);
            reservedWords.put(newKWord, tknum);
            return true;
        }
        return false;
    }

    public static boolean replaceMeaning(String kWord2Keep, String KWord2Chng) {
        kWord2Keep = kWord2Keep.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        KWord2Chng = KWord2Chng.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        Integer tknum1 = (Integer)reservedWords.get(kWord2Keep);
        if (tknum1 != null && reservedWords.get(KWord2Chng) != null) {
            reservedWords.put(KWord2Chng, tknum1);
            return true;
        }
        return false;
    }

    public static void restoreKeywords() {
        reservedWords.clear();
        reservedWords.putAll(reservedWordsOrig);
    }

    @Override
    public boolean isZero() {
        int size;
        String word = this.getWord();
        if (this.token == 10002 && (size = word.length()) > 0) {
            --size;
            while (size >= 0) {
                if (word.charAt(size) != '0') {
                    return false;
                }
                --size;
            }
            return true;
        }
        return false;
    }

    Token constToUsername() {
        Token Return2 = this;
        if (this.constName != null) {
            Return2 = new Token(10009, this.constName, this.fileLineNumber, this.offset, this.fileName);
            Return2.fileIndex = this.fileIndex;
        }
        return Return2;
    }

    public String toString() {
        String word = this.getWord();
        return "[" + word + "]";
    }

    @Override
    public int getRealLength() {
        int Return2 = 0;
        String word = this.getWord();
        if (this.token == 10001) {
            char[] ca = word.toCharArray();
            char quote = ca[0];
            int end = ca.length - 1;
            block3: for (int i = 1; i < end; ++i) {
                char c = ca[i];
                switch (c) {
                    case '\"': 
                    case '\'': {
                        if (quote == c && !this.hexdecimal) {
                            ++i;
                        }
                        ++Return2;
                        continue block3;
                    }
                    default: {
                        ++Return2;
                    }
                }
            }
        } else {
            Return2 = word.length();
        }
        return Return2;
    }

    public String getCode() {
        String Return2;
        String word = this.getWord();
        if (this.token == 10001) {
            char[] ca = word.toCharArray();
            StringBuffer newString = new StringBuffer();
            char quote = ca[0];
            int end = ca.length - 1;
            block7: for (int i = 1; i < end; ++i) {
                char c = ca[i];
                switch (c) {
                    case '\n': {
                        newString.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        newString.append("\\r");
                        continue block7;
                    }
                    case '\"': {
                        newString.append("\\\"");
                        if (quote != c) continue block7;
                        ++i;
                        continue block7;
                    }
                    case '\'': {
                        newString.append("'");
                        if (quote != c) continue block7;
                        ++i;
                        continue block7;
                    }
                    case '\\': {
                        newString.append("\\\\");
                        continue block7;
                    }
                    default: {
                        newString.append(c);
                    }
                }
            }
            Return2 = newString.toString();
        } else if (this.token == 10009) {
            Return2 = word.replace('-', Pcc.hyphenRepl);
            if (Character.isDigit(Return2.charAt(0))) {
                Return2 = '_' + Return2;
            }
        } else {
            Return2 = word;
        }
        return Return2;
    }

    public String getPlain() {
        String Return2;
        String word = this.getWord();
        if (this.token == 10001) {
            char[] ca = word.toCharArray();
            StringBuffer newString = new StringBuffer();
            char quote = ca[0];
            int end = ca.length - 1;
            block4: for (int i = 1; i < end; ++i) {
                char c = ca[i];
                switch (c) {
                    case '\"': {
                        newString.append("\"");
                        if (quote != c) continue block4;
                        ++i;
                        continue block4;
                    }
                    case '\'': {
                        newString.append("'");
                        if (quote != c) continue block4;
                        ++i;
                        continue block4;
                    }
                    default: {
                        newString.append(c);
                    }
                }
            }
            Return2 = newString.toString();
        } else {
            Return2 = word;
        }
        return Return2;
    }

    public String getLitArg() {
        return this.getLitArg(false);
    }

    public String getLitArg(boolean compact) {
        String Return2;
        String word = this.getWord();
        if (word.length() == 0) {
            Return2 = "";
        } else if (this.token == 10001) {
            if (this.hexdecimal) {
                if (compact) {
                    Return2 = this.national && this.isFigurativeHighValue() ? "\"FFFF\"" : "\"" + TokenManager.stringToHex(word.substring(1, word.length() - 1), this.national, false) + "\"";
                } else {
                    char[] c = word.substring(1, word.length() - 1).toCharArray();
                    Return2 = "new byte[] {";
                    if (this.national && this.isFigurativeHighValue()) {
                        Return2 = Return2 + "-1,-1";
                    } else {
                        int i = 0;
                        while (true) {
                            if (this.national) {
                                Return2 = Return2 + (byte)(c[i] >>> 8);
                                Return2 = Return2 + ',';
                                Return2 = Return2 + (byte)(c[i] & 0xFF);
                            } else {
                                Return2 = Return2 + (byte)(c[i] & 0xFF);
                            }
                            if (++i >= c.length) break;
                            Return2 = Return2 + ',';
                        }
                    }
                    Return2 = Return2 + "}";
                }
            } else {
                Return2 = "\"" + this.getCode() + "\"";
            }
        } else if (this.isDouble) {
            Return2 = word;
        } else {
            char sign = word.charAt(0);
            int start = sign == '-' || sign == '+' ? 1 : 0;
            if (Token.countDigit(word) > 18) {
                return "\"" + word + "\"";
            }
            int comma = word.indexOf(46);
            if (comma >= 0 || (comma = word.indexOf(44)) >= 0) {
                Return2 = word.substring(0, comma) + word.substring(comma + 1) + "L,";
                Return2 = Return2 + (comma - start) + "," + (word.length() - comma - 1);
            } else {
                Return2 = word + "L," + (word.length() - start) + "," + 0;
            }
            int len = Return2.length();
            for (comma = start; comma < len && Return2.charAt(comma) == '0'; ++comma) {
            }
            if (comma > start) {
                Return2 = Return2.charAt(comma) == 'L' ? Return2.substring(comma - 1, Return2.length()) : Return2.substring(comma, Return2.length());
                if (start > 0) {
                    Return2 = sign + Return2;
                }
            }
        }
        return Return2;
    }

    @Override
    public String getAsLong() {
        String Return2;
        switch (this.getToknum()) {
            case 10002: {
                Return2 = this.getLitArg();
                int comma = Return2.indexOf(44);
                if (comma < 0) break;
                Return2 = Return2.substring(0, comma);
                break;
            }
            default: {
                Return2 = null;
            }
        }
        return Return2;
    }

    @Override
    public String getAsInt() {
        String Return2;
        switch (this.getToknum()) {
            case 10002: {
                Return2 = this.getAsLong();
                int el = Return2.indexOf(76);
                if (el < 0) break;
                Return2 = Return2.substring(0, el);
                break;
            }
            default: {
                Return2 = null;
            }
        }
        return Return2;
    }

    public int longValue() {
        try {
            return Integer.parseInt(this.getAsInt());
        }
        catch (NumberFormatException _ex) {
            return 0;
        }
        catch (NullPointerException _ex) {
            return 0;
        }
    }

    public String getLiteralFactory(String decimalPointIsComma, boolean compact, boolean optionMs) {
        if (optionMs) {
            if (this.isFigurative() && !this.hexdecimal && !this.national) {
                switch (this.getFigurativeChar()) {
                    case 34: {
                        return "Str.QUOTES()";
                    }
                    case 32: {
                        if (this.isAll) {
                            return "Str.SPACES()";
                        }
                        return "Str.SPACE()";
                    }
                    case 255: {
                        return "Str.HIGH_VALUES()";
                    }
                    case 0: {
                        return "Str.LOW_VALUES()";
                    }
                    case 48: {
                        return "Num.ZERO()";
                    }
                }
                return "Str.get(\"" + this.getCode() + "\")";
            }
            String digits = "";
            switch (this.getToknum()) {
                case 10001: {
                    if (this.resource) {
                        if (this.national) {
                            return "Str.getResNat(\"" + this.getCode() + "\")";
                        }
                        return "Str.getRes(\"" + this.getCode() + "\")";
                    }
                    if (this.national) {
                        if (this.hexdecimal) {
                            if (this.isAll) {
                                return "Str.getAllNatHex(" + this.getLitArg(true) + ")";
                            }
                            return "Str.getNatHex(" + this.getLitArg(true) + ")";
                        }
                        if (this.isAll) {
                            return "Str.getAllNat(\"" + this.getCode() + "\")";
                        }
                        return "Str.getNat(\"" + this.getCode() + "\")";
                    }
                    if (this.hexdecimal) {
                        if (this.isAll) {
                            return "Str.getAllHex(" + this.getLitArg(true) + ")";
                        }
                        return "Str.getHex(" + this.getLitArg(true) + ")";
                    }
                    if (this.isAll) {
                        return "Str.getAll(\"" + this.getCode() + "\")";
                    }
                    return "Str.get(\"" + this.getCode() + "\")";
                }
                case 10002: {
                    if (this._word.startsWith("0") && this._word.length() > 1) {
                        digits = ", " + this._word.length();
                    }
                    if (this.isAll) {
                        return "Num.getAll(" + this.getAsLong() + digits + ")";
                    }
                    if (this.bitLen > 0) {
                        return "Num.getBoolean(\"" + this.getWord().substring(2, this.getWord().length() - 1) + "\")";
                    }
                    return "Num.get(" + this.getAsLong() + digits + ")";
                }
                case 10017: {
                    if (this.isAll) {
                        return "Num.getAll(\"" + this.getCode() + "\")";
                    }
                    return "Num.get(\"" + this.getCode() + "\")";
                }
            }
            return "Str.get(\"" + this.getCode() + "\")";
        }
        switch (this.getToknum()) {
            case 10001: {
                if (this.resource) {
                    if (this.national) {
                        return "Factory.getResource(" + this.getLitArg() + ")";
                    }
                    return "Factory.getResourceX(" + this.getLitArg() + ")";
                }
                if (this.national) {
                    if (this.hexdecimal && compact) {
                        if (this.isAll) {
                            return "Factory.getAllLiteralNH(" + this.getLitArg(true) + ")";
                        }
                        return "Factory.getStrLiteralNH(" + this.getLitArg(true) + ")";
                    }
                    if (this.isAll) {
                        return "Factory.getAllLiteralN(" + this.getLitArg() + ")";
                    }
                    return "Factory.getStrLiteralN(" + this.getLitArg() + ")";
                }
                if (this.isAll) {
                    if (this.isFigurativeSpace()) {
                        return "Factory.getFigurativeAllSpace()";
                    }
                    if (this.isFigurativeQuote()) {
                        return "Factory.getFigurativeQuote()";
                    }
                    if (this.hexdecimal && compact) {
                        return "Factory.getAllLiteralH(" + this.getLitArg(true) + ")";
                    }
                    return "Factory.getAllLiteral(" + this.getLitArg() + ")";
                }
                if (this.isFigurativeSpace()) {
                    return "Factory.getFigurativeSpace()";
                }
                if (this.isFigurativeQuote()) {
                    return "Factory.getFigurativeQuote()";
                }
                if (this.hexdecimal && compact) {
                    return "Factory.getStrLiteralH(" + this.getLitArg(true) + ")";
                }
                return "Factory.getStrLiteral(" + this.getLitArg() + ")";
            }
            case 10002: 
            case 10017: {
                if (this.getWord().length() == 0) {
                    return "null";
                }
                if (this.isAll) {
                    if (this.isFigurativeZero()) {
                        return "Factory.getFigurativeZero(" + decimalPointIsComma + ")";
                    }
                    return "Factory.getAllNumLiteral(" + this.getLitArg() + "," + decimalPointIsComma + ")";
                }
                if (this.nativeSize > 0) {
                    return "Factory.getNativeInt(" + this.getLitArg() + "," + this.nativeSize + "," + decimalPointIsComma + ")";
                }
                if (this.bitLen > 0) {
                    return "Factory.getBooleanLiteral(\"" + this.getWord().substring(2, this.getWord().length() - 1) + "\")";
                }
                return "Factory.getNumLiteral(" + this.getLitArg() + "," + decimalPointIsComma + ")";
            }
            case 613: {
                return "null";
            }
        }
        return "??getLiteralFactory??";
    }

    String getLiteralDeclaration(String name, String pComma, boolean optionMs, boolean compact) {
        switch (this.getToknum()) {
            case 10001: {
                if (this.national) {
                    if (this.isAll) {
                        return "   LiteralAllN " + name + "=" + this.getLiteralFactory(pComma, compact, optionMs) + ";";
                    }
                    return "   PicN " + name + "=" + this.getLiteralFactory(pComma, compact, optionMs) + ";";
                }
                if (this.isAll) {
                    return "   LiteralAll " + name + "=" + this.getLiteralFactory(pComma, compact, optionMs) + ";";
                }
                return "   PicX " + name + "=" + this.getLiteralFactory(pComma, compact, optionMs) + ";";
            }
            case 10002: 
            case 10017: {
                if (this.isAll) {
                    return "   NumericLiteralAll " + name + "=" + this.getLiteralFactory(pComma, compact, optionMs) + ";";
                }
                if (this.bitLen > 0) {
                    return "   Pic1 " + name + "=" + this.getLiteralFactory(pComma, compact, optionMs) + ";";
                }
                return "   NumericVar " + name + "=" + this.getLiteralFactory(pComma, compact, optionMs) + ";";
            }
        }
        return "??getLiteralDeclaration??";
    }

    String getCodeFltLiteral(String decimalPointIsComma) {
        String word = this.getWord();
        switch (this.getToknum()) {
            case 10002: 
            case 10017: {
                if (this.isDouble) {
                    return word;
                }
                int comma = word.indexOf(46);
                if (comma >= 0 || (comma = word.indexOf(44)) >= 0) {
                    return word.substring(0, comma) + "." + word.substring(comma + 1) + "F";
                }
                return "" + this.getWord() + ".0F";
            }
        }
        return "????";
    }

    @Override
    public boolean isWord() {
        return this.token == 10009 || this.token > 255 && this.token < 10000;
    }

    boolean isSeparator() {
        return this.token == 44 || this.token == 59;
    }

    boolean isLength() {
        return this.token == 559;
    }

    private static int countDigit(String s) {
        int Return2 = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            ++Return2;
        }
        return Return2;
    }

    int length() {
        int i;
        if (this.token == 10001) {
            if (this.hexdecimal && this.national) {
                return (this._word.length() - 2) / 2;
            }
            return this._word.length() - 2;
        }
        if (this.token == 10002 || this.token == 10017) {
            for (i = 0; i < this._word.length() - 1 && this._word.charAt(i) == '0'; ++i) {
            }
        }
        return this._word.length() - i;
    }

    void makeConst(Token con) {
        String word;
        this.constName = word = this.getWord();
        this.setToknum(con.getToknum());
        this.setWord(con.getWord());
        this.setAll(this.isAll() || con.isAll());
        this.setNational(con.isNational());
        this.setHexdecimal(con.isHexdecimal());
        this.setBitLen(con.getBitLen());
    }

    @Override
    public boolean isConst() {
        return this.constName != null;
    }

    String getConstName() {
        return this.constName;
    }

    void setDecimals(int d) {
        this.decimals = d;
    }

    int getDecimals() {
        return this.decimals;
    }

    void setHexAll(char lowValue) {
        this.setToknum(10001);
        this.setWord("'" + lowValue + "'");
        this.isAll = true;
        this.setFigurative(true);
        this.setHexdecimal(true);
    }

    void setNullFlag() {
        this.isNull = true;
    }

    void setNull(char lowValue) {
        this.isNull = true;
        this.setHexAll(lowValue);
    }

    void setZero() {
        this.setToknum(10002);
        this.setWord("0");
        this.isAll = true;
        this.setFigurative(true);
        this.setHexdecimal(false);
    }

    void setNumZero() {
        this.setToknum(10002);
        this.setWord("0");
        this.isAll = false;
        this.isNull = false;
        this.setFigurative(false);
        this.setHexdecimal(false);
    }

    boolean isNull() {
        return this.isNull;
    }

    public static byte getEncByte(char c) {
        try {
            return String.valueOf(c).getBytes(encoding)[0];
        }
        catch (UnsupportedEncodingException _ex) {
            return (byte)c;
        }
    }

    static boolean isZero(Token tk) {
        if (tk.isZero()) {
            return true;
        }
        if (tk.isNull()) {
            tk.setZero();
            return true;
        }
        return false;
    }

    static boolean isNumLit(Token tk) {
        if (tk.getToknum() == 10002 || tk.getToknum() == 10017) {
            return true;
        }
        if (tk.isNull()) {
            tk.setZero();
            return true;
        }
        return false;
    }

    static boolean isIntLit(Token tk) {
        if (tk.getToknum() == 10002) {
            return true;
        }
        if (tk.isNull()) {
            tk.setZero();
            return true;
        }
        return false;
    }

    public int getBitLen() {
        return this.bitLen;
    }

    public void setBitLen(int bitLen) {
        this.bitLen = bitLen;
    }

    public String getCodeLiteralOptmz() {
        if (!(this.getToknum() != 10001 || this.isAll() || this.isFigurative() || this.isNational() || this.isResource() || this.isHexdecimal())) {
            return "\"" + this.getCode() + "\"";
        }
        return null;
    }

    static {
        for (int i = 0; i < tokDesc.length; ++i) {
            reservedWords.put(tokDesc[i], tokNum[i]);
        }
        reservedWordsOrig = new Hashtable(reservedWords);
    }
}

