/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlFetch
extends SqlStatement {
    public static final int SQL_FETCH_NEXT = 1;
    public static final int SQL_FETCH_FIRST = 2;
    public static final int SQL_FETCH_LAST = 3;
    public static final int SQL_FETCH_PRIOR = 4;
    public static final int SQL_FETCH_ABSOLUTE = 5;
    public static final int SQL_FETCH_RELATIVE = 6;
    private int fetchType = 1;
    private Vector bindVars;
    private Vector bindInds;
    private VariableName descriptorVar = null;
    private boolean rowset = false;
    private boolean rowsetStartingType = false;
    private VariableName rowsetHostVar = null;
    private int rowsetVal = 0;
    private VariableName rowsetStartingHostVar = null;
    private int rowsetStartingVal = -1;
    private SqlDeclareCursor c;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlFetch(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, VariableName forVar, int forVal, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, forVar, forVal, err);
        Token tk = this.getSqlToken();
        switch (tk.getToknum()) {
            case 596: {
                this.fetchType = 1;
                break;
            }
            case 490: {
                this.fetchType = 2;
                break;
            }
            case 555: {
                this.fetchType = 3;
                break;
            }
            case 644: {
                this.fetchType = 4;
                break;
            }
            case 678: {
                throw new GeneralErrorException(95, 4, tk, tk.getWord(), this.error);
            }
            default: {
                if (tk.getWord().equals("PRIOR")) {
                    this.fetchType = 4;
                    break;
                }
                if (tk.getWord().equals("ABSOLUTE")) {
                    throw new GeneralErrorException(95, 4, tk, tk.getWord(), this.error);
                }
                if (tk.getWord().equals("ROWSET")) {
                    this.rowset = true;
                    tk = this.getSqlToken();
                    if (!tk.getWord().equals("STARTING")) throw new ExpectedFoundException(tk, this.error, "'STARTING'");
                    tk = this.getSqlToken();
                    if (tk.getToknum() != 284) {
                        throw new ExpectedFoundException(tk, this.error, "'AT'");
                    }
                    tk = this.getSqlToken();
                    if (tk.getWord().equals("ABSOLUTE")) {
                        this.rowsetStartingType = true;
                    }
                    if (!tk.getWord().equals("ABSOLUTE") && !tk.getWord().equals("RELATIVE")) throw new ExpectedFoundException(tk, this.error, "'ABSOLUTE/RELATIVE'");
                    tk = this.getSqlToken();
                    if (tk.getToknum() == 58) {
                        this.rowsetStartingHostVar = this.getHostVariable();
                        break;
                    }
                    if (tk.getToknum() != 10002) throw new ExpectedFoundException(tk, this.error, "SQL HOST VARIABLE or Int literal");
                    this.rowsetStartingVal = new Integer(tk.getWord());
                    break;
                }
                this.ungetAllSqlToken();
            }
        }
        tk = this.getSqlToken();
        if (tk.getWord().equals("ROWSET")) {
            if (this.rowset) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            this.rowset = true;
            tk = this.getSqlToken();
        }
        if (tk.getToknum() == 499) {
            tk = this.getSqlToken();
        }
        if (tk.getToknum() == 58) {
            this.cursHndl = this.getHostVariable();
            if (!this.cursHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.cursHndl.getNameToken(), this.cursHndl.getName(), this.error);
            }
        } else {
            this.curName = tk.getWord();
            this.c = this.pc.getCursor(this.curName);
            if (this.c == null) {
                throw new GeneralErrorException(93, 4, tk, this.curName, this.error);
            }
            this.cursHndl = this.c.cursHndl;
        }
        tk = this.getSqlToken();
        if (this.rowset && tk.getToknum() == 495) {
            tk = this.getSqlToken();
            if (tk.getToknum() == 58) {
                this.rowsetHostVar = this.getHostVariable();
            } else {
                if (tk.getToknum() != 10002) throw new ExpectedFoundException(tk, this.error, "SQL HOST VARIABLE or Int literal");
                this.rowsetVal = new Integer(tk.getWord());
            }
            this.forVar = this.rowsetHostVar;
            this.forVal = this.rowsetVal;
            tk = this.getSqlToken();
            if (tk.getWord().equals("ROWS")) {
                tk = this.getSqlToken();
            }
        }
        if (tk.getToknum() == 543) {
            this.bindVars = new Vector();
            this.bindInds = new Vector();
            this.into(this.bindVars, this.bindInds);
        } else if (tk.getToknum() == 803) {
            tk = this.getSqlToken();
            if (!tk.getWord().equals("DESCRIPTOR")) throw new ExpectedFoundException(tk, this.error, " Variable-Name ");
            if (this.db2Esql && (tk = this.getSqlToken()).getToknum() != 58) {
                throw new GeneralErrorException(196, 4, tk, tk.getWord(), this.error);
            }
            this.descriptorVar = VariableName.get(this.tm, this.error, this.pc);
        } else {
            this.ungetAllSqlToken();
        }
        if (this.forVar != null || this.forVal != 0) {
            this.c.changeBind = false;
        }
        if (this.bindVars == null || this.c == null || !this.c.changeBind) return;
        if (this.c.bindVars == null) {
            for (int i = 0; i < this.bindVars.size(); ++i) {
                Object obj = this.bindVars.elementAt(i);
                if (!(obj instanceof VariableName) || !((VariableName)obj).hasIndexes() && !((VariableName)obj).hasSubValue()) continue;
                this.c.changeBind = false;
            }
            if (!this.c.changeBind) return;
            this.c.bindVars = this.bindVars;
            this.c.bindInds = this.bindInds;
            return;
        } else if (!this.c.bindVars.toString().equals(this.bindVars.toString())) {
            this.c.changeBind = false;
            return;
        } else {
            if (!this.c.bindVars.toString().equals(this.bindVars.toString())) return;
            if (this.c.bindInds != null && !this.c.bindInds.toString().equals(this.bindInds.toString())) {
                this.c.changeBind = false;
                return;
            } else {
                if (this.c.bindInds != null || this.bindInds == null || this.bindInds.size() <= 0) return;
                this.c.changeBind = false;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        int i;
        if (this.bindVars != null) {
            for (i = 0; i < this.bindVars.size(); ++i) {
                ((VariableName)this.bindVars.elementAt(i)).check(this.pc);
            }
        }
        if (this.sqlj) {
            VariableName vn;
            if (this.bindInds != null) {
                for (i = 0; i < this.bindInds.size(); ++i) {
                    vn = (VariableName)this.bindInds.elementAt(i);
                    if (vn == null) continue;
                    vn.check();
                    vn.getVarDecl().setEsqlIndicator();
                }
            }
            if (this.c.getPrepStat() != null || this.c.getPrepHndl() != null || !this.c.isSqljStat) {
                this.isSqljStat = false;
            } else {
                this.iterator = this.c.getIterName();
                String iter = "#sql iterator " + this.iterator.substring(1) + "(";
                if (this.bindVars != null) {
                    for (i = 0; i < this.bindVars.size(); ++i) {
                        vn = (VariableName)this.bindVars.elementAt(i);
                        if (i > 0) {
                            iter = iter + ", ";
                        }
                        iter = vn != null && vn.isNumeric() ? iter + "long" : iter + "String";
                    }
                } else {
                    iter = iter + "String";
                }
                iter = iter + ");";
                if (!this.iterator.substring(1).equals("qljIter$")) {
                    this.pc.addIterator(iter);
                }
            }
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        SqlDeclareCursor c = this.pc.getCursor(this.curName);
        if (this.sqlj && this.isSqljStat && this.descriptorVar == null) {
            if (this.bindVars != null) {
                this.bindSqljVars(Return2, this.bindVars, this.bindInds);
            } else {
                Return2.append(this.parent.getIndent());
                Return2.append("clearSqlca(" + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("try {" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("   setSqljConnection();" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("if (" + c.getIterName() + " != null)" + eol);
                Return2.append(this.parent.getIndent());
                if (this.db2Esql) {
                    Return2.append("   rs = (DB2ResultSet)");
                } else {
                    Return2.append("   rs = (ResultSet)");
                }
                Return2.append(c.getIterName());
                Return2.append(".getResultSet();");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                Return2.append("if (rs == null || rs.next() == false)");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                Return2.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                Return2.append("}" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("catch (SQLException e) {" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("   fillSqlcaSqlj(e, " + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("}" + eol);
            }
            Return2.append(this.parent.getIndent());
            Return2.append("Esql.LOG_SQLJ(\"SQLJStat: FETCH " + this.curName + " SQLCODE=\" + " + this.sqlcapfx + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.sqlcapfx + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
        } else if (this.descriptorVar == null) {
            if (this.rowset && (this.rowsetStartingHostVar != null || this.rowsetStartingVal != -1)) {
                Return2.append(this.parent.getIndent() + this.getReturnCode() + ".set(Esql.ROWSET_STARTING(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", " + this.cursHndl.getCode());
                Return2.append(", Factory.getNumLiteral( ");
                if (this.rowsetStartingHostVar != null) {
                    Return2.append(this.rowsetStartingHostVar.getCode() + ".toint()");
                } else {
                    Return2.append(this.rowsetStartingVal);
                }
                Return2.append(", 4, 0, false), " + this.rowsetStartingType);
                Return2.append("}));");
                Return2.append(eol);
            }
            this.startForClause(Return2);
            Return2.append(this.parent.getIndent());
            if (!(this.bindVars == null || c != null && (c == null || c.changeBind && c.bindVars != null))) {
                this.bindCols(this.pc, Return2, this.bindVars, this.bindInds);
                Return2.append(this.getReturnCode());
                Return2.append(".set(Esql.FETCH_INTO(");
            } else if (this.db2Esql) {
                Return2.append(this.getReturnCode());
                Return2.append(".set(Esql.FETCH_DB2(");
            } else {
                Return2.append(this.getReturnCode());
                Return2.append(".set(Esql.FETCH(");
            }
            Return2.append("new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", ");
            Return2.append(this.cursHndl.getCode());
            Return2.append(",Factory.getNumLiteral(");
            Return2.append(this.fetchType);
            Return2.append(", 4, 0, false)");
            if (this.pc.getOption("-xcsqc") != null) {
                Return2.append(", " + this.getInstanceName());
            }
            Return2.append("}));");
            Return2.append(eol);
            if (this.rowset) {
                this.endForClause(Return2, false);
            } else {
                this.endForClause(Return2, true);
            }
        } else {
            Return2.append(this.parent.getIndent());
            Return2.append(this.getReturnCode());
            if (this.db2Esql) {
                Return2.append(".set(Esql.FETCH_DESCRIPTOR_DB2(");
            } else {
                Return2.append(".set(Esql.FETCH_DESCRIPTOR(");
            }
            Return2.append("new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", ");
            Return2.append(this.cursHndl.getCode());
            Return2.append(", ");
            Return2.append(this.descriptorVar.getCode());
            Return2.append(",Factory.getNumLiteral(");
            Return2.append(this.fetchType);
            Return2.append(", 4, 0, false)");
            if (this.optionCP && this.db2Esql) {
                Return2.append(", ");
                Return2.append("" + this.optionD64);
            }
            Return2.append("}));");
            Return2.append(eol);
        }
        this.addWhenever(Return2);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public Vector getBindVars() {
        return this.bindVars;
    }

    public Vector getBindInds() {
        return this.bindInds;
    }

    public int getFetchType() {
        return this.fetchType;
    }

    public SqlDeclareCursor getCursor() {
        return this.pc.getCursor(this.curName);
    }
}

