/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportVariable;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IReportGroup;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportGroup
implements CobolToken,
ErrorsNumbers,
IReportGroup {
    public static final int TYPE_REPORT_HEADING = 1;
    public static final int TYPE_PAGE_HEADING = 2;
    public static final int TYPE_CONTROL_HEADING = 3;
    public static final int TYPE_DETAIL = 4;
    public static final int TYPE_CONTROL_FOOTING = 5;
    public static final int TYPE_PAGE_FOOTING = 6;
    public static final int TYPE_REPORT_FOOTING = 7;
    public static final int LINE_MASK = 0xFFFFFFF;
    public static final int LINE_PLUS = 0x10000000;
    public static final int LINE_PAGE = 0x20000000;
    public final ReportDescriptor rd;
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private int currColumn = 1;
    private int currLine = 1;
    private Token name;
    final int prog;
    final int type;
    private VariableName control;
    private int line;
    private int nextGroup;
    private Vector<ReportVariable> children = new Vector();
    Use use;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReportGroup(ReportDescriptor r, Token tk, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        int ltype = 0;
        this.rd = r;
        this.pc = p;
        this.error = err;
        this.tm = t;
        tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.name = tk;
            this.prog = this.rd.repoSec.checkGroupName(this.name.getWord());
        } else {
            this.name = null;
            this.prog = 0;
            this.tm.ungetToken();
        }
        block11: while ((tk = this.tm.getToken()).getToknum() != 10006) {
            switch (tk.getToknum()) {
                case 566: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 603) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 596) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 630) throw new ExpectedFoundException(tk, this.error, "PAGE");
                        this.line = 0x20000001;
                        continue block11;
                    }
                    boolean plus = false;
                    if (tk.getToknum() == 638) {
                        plus = true;
                        tk = this.tm.getToken();
                    }
                    if (!Token.isIntLit(tk)) {
                        throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                    }
                    this.line = tk.longValue();
                    if (plus) {
                        this.line |= 0x10000000;
                        continue block11;
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 614 || tk.getToknum() == 596) {
                        if (tk.getToknum() == 614 && (tk = this.tm.getToken()).getToknum() != 596) {
                            throw new ExpectedFoundException(tk, this.error, "NEXT");
                        }
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 630) {
                            throw new ExpectedFoundException(tk, this.error, "PAGE");
                        }
                        this.line |= 0x20000000;
                        continue block11;
                    }
                    this.tm.ungetToken();
                    continue block11;
                }
                case 596: {
                    tk = this.tm.getToken();
                    if (!tk.getWord().equals("GROUP")) {
                        throw new ExpectedFoundException(tk, this.error, "GROUP");
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 596) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 630) throw new ExpectedFoundException(tk, this.error, "PAGE");
                        if ((this.line & 0x10000000) != 0) {
                            this.nextGroup = this.line | 0x20000000;
                            continue block11;
                        }
                        this.nextGroup = 0x20000001;
                        continue block11;
                    }
                    boolean plus = false;
                    if (tk.getToknum() == 638) {
                        plus = true;
                        tk = this.tm.getToken();
                    }
                    if (!Token.isIntLit(tk)) {
                        throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                    }
                    this.nextGroup = tk.longValue();
                    if (plus) {
                        this.nextGroup |= 0x10000000;
                        continue block11;
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 614 || tk.getToknum() == 596) {
                        if (tk.getToknum() == 614 && (tk = this.tm.getToken()).getToknum() != 596) {
                            throw new ExpectedFoundException(tk, this.error, "NEXT");
                        }
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 630) {
                            throw new ExpectedFoundException(tk, this.error, "PAGE");
                        }
                        this.nextGroup |= 0x20000000;
                        continue block11;
                    }
                    this.tm.ungetToken();
                    continue block11;
                }
                case 782: {
                    String w;
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if ((w = tk.getWord()).length() == 2) {
                        if (w.equals("RH")) {
                            ltype = 1;
                        } else if (w.equals("RF")) {
                            ltype = 7;
                        } else if (w.equals("PH")) {
                            ltype = 2;
                        } else if (w.equals("PF")) {
                            ltype = 6;
                        } else if (w.equals("CH")) {
                            ltype = 3;
                        } else if (w.equals("CF")) {
                            ltype = 5;
                        } else {
                            if (!w.equals("DE")) throw new UnexpectedTokenException(tk, err);
                            ltype = 4;
                        }
                    } else {
                        switch (tk.getToknum()) {
                            case 685: {
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 512) {
                                    ltype = 1;
                                    break;
                                }
                                if (tk.getToknum() != 494) throw new UnexpectedTokenException(tk, err);
                                ltype = 7;
                                break;
                            }
                            case 630: {
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 512) {
                                    ltype = 2;
                                    break;
                                }
                                if (tk.getToknum() != 494) throw new UnexpectedTokenException(tk, err);
                                ltype = 6;
                                break;
                            }
                            case 373: {
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 512) {
                                    ltype = 3;
                                    break;
                                }
                                if (tk.getToknum() != 494) throw new UnexpectedTokenException(tk, err);
                                ltype = 5;
                                break;
                            }
                            case 405: {
                                ltype = 4;
                                break;
                            }
                            default: {
                                throw new UnexpectedTokenException(tk, err);
                            }
                        }
                    }
                    if (this.rd.pageLimit == 0 && (ltype == 2 || ltype == 6)) {
                        throw new GeneralErrorException(187, 4, tk, tk.getWord(), this.error);
                    }
                    if (this.rd.footing == 0 && ltype == 6) {
                        throw new GeneralErrorException(187, 4, tk, tk.getWord(), this.error);
                    }
                    if (ltype != 3 && ltype != 5 || (tk = this.tm.getToken()).getToknum() == 488) continue block11;
                    if (tk.getToknum() != 10009) throw new UnexpectedTokenException(tk, err);
                    this.tm.ungetToken();
                    this.control = VariableName.get(this.tm, this.error);
                    if (this.control != null) continue block11;
                    throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                }
            }
            throw new GeneralErrorException(15, 4, tk, tk.getWord(), this.error);
        }
        this.type = ltype;
        while ((tk = this.tm.getToken()).getToknum() == 10002 && tk.longValue() > 1) {
            this.tm.ungetToken();
            this.children.add(new ReportVariable(this.rd, this, this.pc, this.tm, this.error));
        }
        this.tm.ungetToken();
    }

    int getDataMapSize() {
        int len = 0;
        for (ReportVariable rv : this.children) {
            VariableDeclaration vd = rv.getCobVar();
            if (vd == null) continue;
            len += vd.getPhisicLen();
        }
        return len;
    }

    StringBuffer getLineDatamap(String pfx) {
        VariableDeclaration vd;
        String indent = " ";
        StringBuffer Return2 = new StringBuffer("*>");
        String num = "" + this.name.getFLN();
        VariableDeclaration.fillNum(Return2, 9 - num.length());
        Return2.append(num + " " + this.name.getWord());
        if (Return2.length() > 72) {
            Return2.delete(72, Return2.length());
        }
        VariableDeclaration.fillSpace(Return2, 73 - Return2.length());
        num = "";
        VariableDeclaration.fillNum(Return2, 9 - num.length());
        Return2.append(num + " ");
        int physicLen = 0;
        String type = "E";
        for (ReportVariable rv : this.children) {
            vd = rv.getCobVar();
            if (vd == null) continue;
            physicLen += vd.getPhisicLen();
            type = "G";
        }
        num = "" + physicLen;
        VariableDeclaration.fillNum(Return2, 9 - num.length());
        Return2.append(num + " RD " + type + "   ");
        VariableDeclaration.fillSpace(Return2, 119 - Return2.length());
        Return2.append("      ");
        Return2.append(eol);
        for (ReportVariable rv : this.children) {
            vd = rv.getCobVar();
            if (vd == null) continue;
            vd.getLineDatamap(Return2, "RD", "  ", pfx);
        }
        return Return2;
    }

    void writeExtDatamap(Element elem) {
        Document doc = elem.getOwnerDocument();
        Element field = VariableDeclaration.appendFieldElement(doc, elem);
        VariableDeclaration.appendElement(doc, field, "name", this.name.getWord());
        int physicLen = 0;
        boolean elementary = true;
        for (ReportVariable rv : this.children) {
            VariableDeclaration vd = rv.getCobVar();
            if (vd == null) continue;
            physicLen += vd.getPhisicLen();
            elementary = false;
        }
        VariableDeclaration.appendElement(doc, field, "physicalLength", String.valueOf(physicLen));
        VariableDeclaration.appendElement(doc, field, "location", "RD");
        if (!elementary) {
            VariableDeclaration.appendElement(doc, field, "group", "yes");
        } else {
            VariableDeclaration.appendElement(doc, field, "elementary", "yes");
        }
        if (this.name.getFileIndex() > 0) {
            VariableDeclaration.appendElement(doc, field, "copyFile", this.name.getFileName());
            String repl = ((PreProcessor)this.tm.getAllPreProcessors().elementAt(this.name.getFileIndex())).getReplacingString();
            if (repl != null) {
                VariableDeclaration.appendElement(doc, field, "copyReplacing", repl);
            }
        }
        boolean m1 = this.pc.getOption("-m1") != null;
        for (ReportVariable rv : this.children) {
            VariableDeclaration vd = rv.getCobVar();
            if (vd == null) continue;
            vd.writeExtDatamap(elem, "RD", m1);
        }
    }

    public void check() throws GeneralErrorException {
        if (this.control != null) {
            this.control.check(this.pc);
            if (!this.rd.isControl(this.control)) {
                throw new GeneralErrorException(185, 4, this.control.name, this.control.name.getWord(), this.error);
            }
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.children.elementAt(i).check();
        }
    }

    private void newCode(StringBuffer dynPart) {
        dynPart.append("new ReportGroup (");
        if (this.use != null) {
            dynPart.append("this,");
            dynPart.append(this.use.parag.getIdNumber());
            dynPart.append(",");
            dynPart.append(this.use.parag.getLastParagraphInSameSection().getIdNumber());
        }
        dynPart.append(")");
    }

    private void stdargs(StringBuffer dynPart) {
        if (this.name != null) {
            dynPart.append(this.getUnivoqueName());
        } else {
            this.newCode(dynPart);
        }
        dynPart.append(",");
        dynPart.append(this.line);
        dynPart.append(",0x");
        dynPart.append(Integer.toHexString(this.nextGroup));
    }

    @Override
    public Token getName() {
        return this.name;
    }

    public String getUnivoqueName() {
        String Return2;
        if (this.name == null) {
            Return2 = null;
        } else {
            Return2 = this.name.getCode();
            if (this.prog != 0) {
                Return2 = Return2 + (Pcc.identifierSep + this.prog);
            }
        }
        return Return2;
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        if (this.name != null) {
            Return2.append("   ReportGroup ");
            Return2.append(this.getUnivoqueName());
            Return2.append(" = ");
            this.newCode(Return2);
            Return2.append(";");
            Return2.append(eol);
        }
        dynPart.append(this.rd.getName());
        switch (this.type) {
            case 1: {
                dynPart.append(".setReportHeading(");
                this.stdargs(dynPart);
                break;
            }
            case 7: {
                dynPart.append(".setReportFooting(");
                this.stdargs(dynPart);
                break;
            }
            case 2: {
                dynPart.append(".setPageHeading(");
                this.stdargs(dynPart);
                break;
            }
            case 6: {
                dynPart.append(".setPageFooting(");
                this.stdargs(dynPart);
                break;
            }
            case 3: {
                dynPart.append(".setControlHeading(");
                this.stdargs(dynPart);
                dynPart.append(",");
                if (this.control != null) {
                    dynPart.append(this.control.getCode());
                    break;
                }
                dynPart.append("null");
                break;
            }
            case 5: {
                dynPart.append(".setControlFooting(");
                this.stdargs(dynPart);
                dynPart.append(",");
                if (this.control != null) {
                    dynPart.append(this.control.getCode());
                    break;
                }
                dynPart.append("null");
                break;
            }
            case 4: {
                dynPart.append(".setDetail(");
                this.stdargs(dynPart);
                break;
            }
            default: {
                throw new InternalErrorException("REPORT VAR TYPE UNKNOWN " + this.type);
            }
        }
        dynPart.append(");");
        dynPart.append(eol);
        for (int i = 0; i < this.children.size(); ++i) {
            Return2.append(this.children.elementAt(i).getCode(dynPart));
        }
        return Return2.toString();
    }

    boolean setColumn(int o) {
        if (o > 0) {
            if (o > this.currColumn) {
                this.currColumn = o;
            }
            this.rd.setLen(this.currColumn - 1);
            return false;
        }
        return true;
    }

    @Override
    public int getColumn() {
        return this.currColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean setLine(int l) {
        if (l < 0) {
            return true;
        }
        if ((l & 0x10000000) > 0) {
            if ((l & 0xFFFFFFF) <= 0) return false;
            this.currLine += l & 0xFFFFFFF;
            this.currColumn = 1;
            return false;
        } else if ((l & 0x20000000) > 0) {
            this.currColumn = 1;
            if ((l & 0xFFFFFFF) <= 0) return true;
            this.currLine = l & 0xFFFFFFF;
            return false;
        } else {
            if (l <= 0) return true;
            if (l <= this.currLine) return false;
            this.currLine = l;
            this.currColumn = 1;
        }
        return false;
    }

    @Override
    public List<ReportVariable> getChildren() {
        return this.children;
    }

    @Override
    public ReportDescriptor getReportDescriptor() {
        return this.rd;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getNextGroup() {
        return this.nextGroup;
    }

    public Use getUse() {
        return this.use;
    }

    @Override
    public VariableName getControl() {
        return this.control;
    }
}

