/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;

class Replace
implements CobolToken {
    static final int WHOLE_WORD = 1;
    static final int LEADING_SUBWORD = 2;
    static final int TRAILING_SUBWORD = 3;
    TokenList before = new TokenList();
    TokenList after = new TokenList();
    boolean isReplacing = false;
    boolean lineCont = false;
    int mode = 1;
    int progr = 0;
    Token lastAdded = null;

    Replace(boolean isRep) {
        this.isReplacing = isRep;
    }

    Token join(Token ntLit, Token conLit) {
        String s1 = ntLit.getWord();
        String s2 = conLit.getWord();
        int size1 = s1.length();
        int size2 = s2.length();
        String fileName = conLit.getFileName();
        if (conLit.getToknum() == 10001) {
            return new Token(10001, "\"" + s1.substring(1, size1 - 2) + s2.substring(1, size2 - 1) + "\"", size1 + size2 - 3, 0, fileName);
        }
        return new Token(10014, "\"" + s1.substring(1, size1 - 2) + s2.substring(1, size2 - 2) + "\"-", size1 + size2 - 3, 0, fileName);
    }

    private void addTo(TokenList tl, Token t) {
        Token last = tl.getLast();
        if (this.lineCont) {
            if (t.getToknum() != 10016) {
                if (last.getToknum() == 10024 && (t.getToknum() == 10024 || t.getToknum() == 10001)) {
                    last.setWord(last.getOriginalWord() + t.getOriginalWord().substring(1));
                    if (t.getToknum() == 10001) {
                        last.setToknum(10001);
                    }
                } else {
                    last.setWord(last.getOriginalWord() + t.getOriginalWord());
                }
                this.lineCont = false;
            }
        } else if (t.getToknum() == 1) {
            this.lineCont = true;
        } else {
            if ((t.getToknum() == 10001 || t.getToknum() == 10014) && last != null && last.getToknum() == 10014) {
                tl.deleteCurrent();
                t = this.join(last, t);
            }
            tl.addItem(t);
        }
    }

    void addToBefore(Token t) {
        this.addTo(this.before, t);
    }

    void endBefore() {
        Token last;
        while ((last = this.before.getLastWithSep()) != null && last.getToknum() == 10016) {
            this.before.deleteCurrentWithSep();
        }
    }

    void addToAfter(Token t) {
        if (this.lastAdded != null && this.lastAdded.getFLN() != t.getFLN()) {
            this.addTo(this.after, new Token(10016, eol, this.lastAdded.getOffset() + this.lastAdded.getWord().length(), this.lastAdded.getFLN(), this.lastAdded.getFileName()));
        }
        this.addTo(this.after, t);
        this.lastAdded = t;
    }

    void endAfter() {
        Token last;
        while ((last = this.after.getLastWithSep()) != null && last.getToknum() == 10016) {
            this.after.deleteCurrentWithSep();
        }
    }

    void setMode(int m) {
        this.mode = m;
    }

    void setProgr(int p) {
        this.progr = p;
    }

    Token getFirstFromBefore() {
        return this.before.getFirstWithSep();
    }

    Token getNextFromBefore() {
        return this.before.getNextWithSep();
    }

    Token getAtFromBefore(int at) {
        return this.before.getAt(at);
    }

    int getBeforeItemNum() {
        return this.before.getItemNum();
    }

    Token getFirstFromAfter() {
        return this.after.getFirstWithSep();
    }

    Token getNextFromAfter() {
        return this.after.getNextWithSep();
    }

    int getMode() {
        return this.mode;
    }

    int getProgr() {
        return this.progr;
    }

    public String toString() {
        return this.before.toString();
    }
}

