/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.AtEnd;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Read
extends Verb
implements CobolToken,
ErrorsNumbers {
    private static final int L_NO_LOCK = 0;
    private static final int L_IGNORE_LOCK = 1;
    private static final int L_LOCK = 2;
    private static final int L_KEPT_LOCK = 3;
    private static final int L_WAIT_LOCK = 4;
    private Select sel;
    private InvalidKey invKey;
    private AtEnd atEnd;
    private VariableName keyName;
    private VariableDeclaration[] key;
    private VariableName into;
    private VariableName size;
    private int type = 0;
    private int lock = 0;
    private final boolean optionCRLK = this.pc.getOption("-crlk") != null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Read(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(tk.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (this.sel.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (this.sel.isXml()) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 596) {
                this.type = 596;
                tk = this.tm.getToken();
                if (tk.getToknum() == 671) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 552) {
                    throw new ExpectedFoundException(tk, this.error, "KEY");
                }
                tk = this.tm.getToken();
                if (tk.getToknum() == 546) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 10009) {
                    throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                this.keyName = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 644 || tk.getToknum() == 297) {
            this.type = 644;
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 596) {
            this.type = 596;
            tk = this.tm.getToken();
        } else if (this.sel.accessMode == 718) {
            this.type = 596;
        }
        if (tk.getToknum() == 671 || tk.getToknum() == 673) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 543) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 814 || tk.getToknum() == 571 || tk.getToknum() == 597 || tk.getWord().equals("IGNORE") || tk.getToknum() == 551 || tk.getWord().equals("WAIT")) {
            if (tk.getToknum() == 814) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 551) {
                this.lock = 3;
                tk = this.tm.getToken();
            } else if (tk.getToknum() == 597) {
                this.lock = 0;
                tk = this.tm.getToken();
            } else if (tk.getWord().equals("IGNORE")) {
                this.lock = 1;
                tk = this.tm.getToken();
            } else if (tk.getWord().equals("WAIT")) {
                this.lock = 4;
                tk = this.tm.getToken();
            } else {
                this.lock = 2;
            }
            if (tk.getToknum() != 571) {
                if (this.lock != 4) {
                    throw new ExpectedFoundException(tk, this.error, "LOCK");
                }
            } else {
                tk = this.tm.getToken();
            }
        } else if (tk.getToknum() == 264) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 795) throw new ExpectedFoundException(tk, this.error, "UPDATERS");
            tk = this.tm.getToken();
            this.lock = 0;
        } else if (this.sel.getLockMode(0) == 290) {
            this.lock = 2;
        }
        if (tk.getToknum() == 543) {
            if (this.into != null) {
                throw new GeneralErrorException(91, 4, tk, "INTO", this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 552) {
            if (this.type == 596 || this.type == 644) {
                throw new ClauseClashException(tk, this.error, tk.getWord());
            }
            if (this.sel.organization != 530) {
                throw new ClauseClashException(tk, this.error, tk.getWord());
            }
            this.type = 552;
            tk = this.tm.getToken();
            if (tk.getToknum() == 546) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            this.tm.ungetToken();
            this.keyName = VariableName.get(this.tm, this.error);
            this.key = this.sel.getKeyByName(this.keyName.getName());
            if (this.key == null) {
                this.keyName.check(this.pc);
                VariableDeclaration grandPa = this.keyName.getVarDecl().getGrandPa();
                FileDescriptor fd = this.pc.getFdByRecord(this.keyName.getVarDecl().getGrandPa());
                if (fd != null) {
                    this.key = this.sel.getKeyByOffset(this.keyName.getVarDecl().getOffset());
                }
            }
            if (this.key == null) {
                throw new GeneralErrorException(56, 4, this.keyWord, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 543) {
            if (this.into != null) {
                throw new GeneralErrorException(91, 4, tk, "INTO", this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 729) {
            if (this.sel.organization != 718) {
                throw new ClauseClashException(this.keyWord, this.error, tk.getWord());
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.size = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            tk = this.tm.getToken();
        } else {
            try {
                this.size = this.sel.getFD().getDepending();
            }
            catch (NullPointerException _ex) {
                this.size = null;
            }
        }
        if (tk.getToknum() == 599) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 284 || tk.getToknum() == 423) {
                if (this.type == 552) {
                    throw new ClauseClashException(tk, this.error, tk.getWord());
                }
                if (this.type != 644) {
                    this.type = 596;
                }
                this.tm.ungetToken();
                this.tm.ungetToken();
                this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            } else {
                if (tk.getToknum() != 544) throw new UnexpectedTokenException(tk, this.error);
                if (this.type == 644 || this.type == 596) {
                    throw new ClauseClashException(tk, this.error, tk.getWord());
                }
                this.type = 552;
                this.tm.ungetToken();
                this.tm.ungetToken();
                this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            }
        } else if (tk.getToknum() == 284 || tk.getToknum() == 423) {
            this.tm.ungetToken();
            if (this.type == 552) {
                throw new ClauseClashException(tk, this.error, tk.getWord());
            }
            if (this.type != 644) {
                this.type = 596;
            }
            this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
        } else if (tk.getToknum() == 544) {
            if (this.type == 644 || this.type == 596) {
                throw new ClauseClashException(tk, this.error, tk.getWord());
            }
            this.type = 552;
            this.tm.ungetToken();
            this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
        } else {
            this.tm.ungetToken();
        }
        if (this.type == 552 && this.sel.accessMode == 718 || (this.type == 596 || this.type == 644) && this.sel.accessMode == 665) {
            throw new ClauseClashException(this.keyWord, this.error, tk.getWord());
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 442) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
        if (this.type != 0) return;
        if (this.sel.accessMode == 718) {
            this.type = 596;
            return;
        } else {
            if (this.sel.accessMode != 665 && this.sel.accessMode != 415) return;
            this.type = 552;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getLock(boolean hasDeclaratives) {
        switch (this.lock) {
            case 0: {
                return "CobolFile.READ_NO_LOCK";
            }
            case 1: {
                return "CobolFile.READ_IGNORE";
            }
            case 2: {
                if (this.optionCRLK && !hasDeclaratives) {
                    return "CobolFile.READ_WAIT";
                }
                return "CobolFile.READ_LOCK";
            }
            case 3: {
                return "CobolFile.READ_KEPT";
            }
            case 4: {
                return "CobolFile.READ_WAIT";
            }
        }
        throw new InternalErrorException("Unknown lock mode:" + this.lock);
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        boolean hasDeclaratives = this.pc.getDeclarative(this.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append("try {");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        if (this.invKey != null) {
            Return2.append(this.invKey.getCodeBefore());
        } else if (this.atEnd != null) {
            Return2.append(this.atEnd.getCodeBefore());
        }
        if (this.size != null) {
            Return2.append(this.size.getCode());
            Return2.append(".set(");
        }
        Return2.append(this.sel.getName());
        if (this.sel.isXml()) {
            Return2.append(".readXml(");
            if (this.keyName != null) {
                Return2.append(this.keyName.getCode());
            } else {
                Return2.append("null");
            }
            Return2.append(");");
            Use.putFileStatus(Return2, this.sel, this.parent.getIndent());
            Use.putDeclaratives(Return2, this.pc, this.sel, this.parent.getIndent(), hasDeclaratives);
        } else {
            if (this.type == 552) {
                Return2.append(".readKey(");
                if (this.key == null && this.sel.organization == 530) {
                    this.key = this.sel.getPrimaryKey();
                }
                if (this.key != null) {
                    Return2.append("new CobolVar[] {");
                    int i = 0;
                    while (true) {
                        Return2.append(this.key[i].getQualUnivoqueName());
                        if (++i >= this.key.length) break;
                        Return2.append(",");
                    }
                    Return2.append("},");
                } else {
                    Return2.append("null,");
                }
            } else if (this.type == 644) {
                Return2.append(".readPrev(");
            } else {
                Return2.append(".readNext(");
            }
            Return2.append(this.getLock(hasDeclaratives));
            Return2.append(",");
            if (this.into != null) {
                Return2.append(this.into.getCode());
            } else {
                Return2.append("null");
            }
            Return2.append(")");
            if (this.size != null) {
                Return2.append(")");
            }
            Return2.append(";");
            Use.putFileStatus(Return2, this.sel, this.parent.getIndent());
            if (this.invKey != null) {
                Return2.append(this.invKey.getCode());
            } else if (this.atEnd != null) {
                Return2.append(this.atEnd.getCode());
            }
            Use.putDeclaratives(Return2, this.pc, this.sel, this.parent.getIndent(), hasDeclaratives);
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public Select getSelect() {
        return this.sel;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }

    public AtEnd getAtEnd() {
        return this.atEnd;
    }

    public VariableName getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public VariableDeclaration[] getKey() {
        return this.key;
    }

    public int getLockRaw() {
        return this.lock;
    }

    public VariableName getInto() {
        return this.into;
    }
}

