/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Expression;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import java.util.Enumeration;
import java.util.Vector;

public class OffsetHelper {
    private final VariableDeclaration target;
    private final Vector[] dimensions;
    private final Vector finalFormula = new Vector();

    private static VariableDeclaration getRealTarget(VariableDeclaration tgt) {
        if (tgt.getRename() != null) {
            tgt = tgt.getRename();
        }
        while (tgt.isRedefines()) {
            if (tgt.getRedefinesVar() != null) {
                tgt = tgt.getRedefinesVar();
                continue;
            }
            tgt = tgt.parent;
        }
        return tgt;
    }

    public OffsetHelper(VariableDeclaration tgt, Object[] indexes) {
        int ndim;
        this.target = OffsetHelper.getRealTarget(tgt);
        VariableDeclaration root = this.target.getGrandPa();
        if (indexes != null && (ndim = indexes.length) > 0) {
            this.dimensions = new Vector[ndim];
            VariableDeclaration vd = this.target;
            int i = ndim - 1;
            while (i >= 0 && vd != null) {
                if (vd.getOccurs() > 0) {
                    this.dimensions[i] = new Vector();
                    this.dimensions[i].addElement(vd.getPhisicLen());
                    --i;
                }
                vd = vd.parent;
            }
        } else {
            this.dimensions = null;
        }
        this.findOffset0(root, this.finalFormula, new boolean[]{false});
        if (this.dimensions != null) {
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (this.dimensions[i] == null) continue;
                Object oIndex = indexes[i];
                if (oIndex instanceof Subscript) {
                    Subscript index = (Subscript)oIndex;
                    Expression exp = index.getExpression();
                    if (index.isLiteral()) {
                        int val = 0;
                        if (exp != null) {
                            Token tk = exp.getAsToken();
                            val = "1".equals(tk.getWord()) ? 1 : tk.longValue();
                        } else {
                            String idx = index.getIndex();
                            try {
                                val = Integer.parseInt(idx);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (val == 1) continue;
                        OffsetHelper.multiply(this.dimensions[i], val - 1);
                        this.finalFormula.addElement("+");
                        this.finalFormula.addElement(this.toString(this.dimensions[i]));
                        continue;
                    }
                    OffsetHelper.multiply(this.dimensions[i], "(" + exp.getCode() + ".intValue()-1)");
                    this.finalFormula.addElement("+");
                    this.finalFormula.addElement(this.toString(this.dimensions[i]));
                    continue;
                }
                OffsetHelper.multiply(this.dimensions[i], oIndex);
                this.finalFormula.addElement("+");
                this.finalFormula.addElement(this.toString(this.dimensions[i]));
            }
        }
    }

    public OffsetHelper(VariableDeclaration tgt, SubscriptList indexes) {
        int i;
        int ndim;
        this.target = OffsetHelper.getRealTarget(tgt);
        if (this.target != tgt) {
            int offsDispl = tgt.getOffset();
            if (this.target.hasVariableOffset()) {
                offsDispl -= this.target.getOffset();
            }
            if (offsDispl > 0) {
                OffsetHelper.add(this.finalFormula, offsDispl);
            }
        }
        VariableDeclaration root = this.target.getGrandPa();
        if (indexes != null && (ndim = indexes.getItemNum()) > 0) {
            this.dimensions = new Vector[ndim];
            VariableDeclaration vd = tgt;
            i = ndim - 1;
            while (i >= 0 && vd != null) {
                if (vd.getOccurs() > 0) {
                    this.dimensions[i] = new Vector();
                    this.calcDimension(vd, this.dimensions[i]);
                    --i;
                }
                vd = vd.parent;
            }
        } else {
            this.dimensions = null;
        }
        this.findOffset0(root, this.finalFormula, new boolean[]{false});
        if (this.dimensions != null) {
            Subscript index = indexes.getFirst();
            for (i = 0; i < this.dimensions.length; ++i) {
                Expression exp = index.getExpression();
                if (index.isLiteral()) {
                    int val = 0;
                    if (exp != null) {
                        Token tk = exp.getAsToken();
                        val = "1".equals(tk.getWord()) ? 1 : tk.longValue();
                    } else {
                        String idx = index.getIndex();
                        try {
                            val = Integer.parseInt(idx);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (val != 1) {
                        OffsetHelper.multiply(this.dimensions[i], val - 1);
                        this.finalFormula.addElement("+");
                        this.finalFormula.addElement(this.toString(this.dimensions[i]));
                    }
                } else {
                    OffsetHelper.multiply(this.dimensions[i], "(" + exp.getCode() + ".intValue()-1)");
                    this.finalFormula.addElement("+");
                    this.finalFormula.addElement(this.toString(this.dimensions[i]));
                }
                index = indexes.getNext();
            }
        }
    }

    private static void multiply(Vector formula, Object multiplier) {
        int fSize = formula.size();
        Object fItem = formula.elementAt(0);
        if (multiplier instanceof Integer && fSize == 1 && fItem instanceof Integer) {
            int r = (Integer)multiplier;
            formula.setElementAt(r *= ((Integer)formula.elementAt(0)).intValue(), 0);
        } else if (fSize == 1 && fItem instanceof Integer && (Integer)fItem == 1) {
            formula.setElementAt(multiplier, 0);
        } else {
            if (formula.size() > 1) {
                formula.insertElementAt("(", 0);
                formula.addElement(")");
            }
            formula.addElement("*");
            formula.addElement(multiplier.toString());
        }
    }

    private static void add(Vector formula, Object obj) {
        int lastItemIdx = formula.size() - 1;
        if (lastItemIdx >= 0) {
            Object lastItem = formula.elementAt(lastItemIdx);
            if (obj instanceof Integer && lastItem instanceof Integer) {
                formula.setElementAt((Integer)obj + (Integer)lastItem, lastItemIdx);
            } else {
                if (!lastItem.equals("(")) {
                    formula.addElement("+");
                }
                formula.addElement(obj);
            }
        } else {
            formula.addElement(obj);
        }
    }

    private void calcDimensionChildren(VariableDeclarationList children, Vector formula) {
        Enumeration echld = children.elements();
        while (echld.hasMoreElements()) {
            VariableDeclaration chld = (VariableDeclaration)echld.nextElement();
            if (chld.getRedefines() != null) continue;
            if (chld.getOccurs() > 0) {
                Vector<String> subFormula = new Vector<String>();
                this.calcDimension(chld, subFormula);
                if (subFormula.size() > 1) {
                    subFormula.insertElementAt("(", 0);
                    subFormula.addElement(")");
                }
                OffsetHelper.add(formula, this.toString(subFormula));
                formula.addElement("*");
                VariableName depending = chld.getDepending();
                if (depending != null) {
                    formula.addElement(depending.getCode() + ".toint()");
                    continue;
                }
                formula.addElement("" + chld.getOccurs());
                continue;
            }
            this.calcDimension(chld, formula);
        }
    }

    private void calcDimension(VariableDeclaration vd, Vector formula) {
        if (vd.children == null || vd.children.getItemNum() == 0) {
            OffsetHelper.add(formula, vd.getPhisicLen());
        } else {
            this.calcDimensionChildren(vd.children, formula);
        }
    }

    public String toString() {
        return this.toString(this.finalFormula);
    }

    private String toString(Vector formula) {
        StringBuffer Return2 = new StringBuffer();
        for (int i = 0; i < formula.size(); ++i) {
            Return2.append(formula.elementAt(i));
        }
        return Return2.toString();
    }

    private boolean findOffset0(VariableDeclaration vd, Vector formula, boolean[] firstDep) {
        boolean Return2;
        if (!firstDep[0] && vd.hasVariableOffset()) {
            OffsetHelper.add(this.finalFormula, vd.getOffset());
            firstDep[0] = true;
        }
        if (vd == this.target) {
            if (!firstDep[0]) {
                OffsetHelper.add(this.finalFormula, 0);
            }
            Return2 = false;
        } else {
            Return2 = true;
            if (firstDep[0]) {
                int subSize;
                VariableName depending = vd.getDepending();
                Object multiplier = vd.getOccurs() > 0 ? (depending != null ? depending.getCode() + ".toint()" : Integer.valueOf(vd.getOccurs())) : null;
                Vector subFormula = new Vector();
                if (vd.children == null || vd.children.getItemNum() == 0) {
                    if (!vd.isRedefines()) {
                        OffsetHelper.add(subFormula, vd.getPhisicLen());
                    }
                } else {
                    Enumeration echld = vd.children.elements();
                    while (echld.hasMoreElements() && Return2) {
                        VariableDeclaration chld = (VariableDeclaration)echld.nextElement();
                        Return2 = this.findOffset0(chld, subFormula, firstDep);
                    }
                }
                if ((subSize = subFormula.size()) > 0) {
                    if (Return2 && multiplier != null) {
                        OffsetHelper.multiply(subFormula, multiplier);
                    }
                    if (subFormula.size() == 1 && subFormula.elementAt(0) instanceof Integer) {
                        OffsetHelper.add(formula, subFormula.elementAt(0));
                    } else {
                        OffsetHelper.add(formula, this.toString(subFormula));
                    }
                }
            } else if (vd.children != null) {
                Enumeration echld = vd.children.elements();
                while (echld.hasMoreElements() && Return2) {
                    VariableDeclaration chld = (VariableDeclaration)echld.nextElement();
                    Return2 = this.findOffset0(chld, formula, firstDep);
                }
            }
        }
        return Return2;
    }
}

