/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.rts.IscobolClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class MyMethod
implements Comparable {
    static final Method isVarArgsMthd;
    static final Method isVarArgsCtor;
    static final Method isDefaultMthd;
    private Method method;
    private Constructor ctor;
    private String name;
    private Integer modifiers;
    private MyClass retType;
    private MyClass[] params;
    private MyClass[] exTypes;
    private final boolean varArgs;
    private final boolean isDefault;
    private final MyClass declaringClass;
    private final boolean interfaceMethod;

    static boolean isDefault(Method m) {
        boolean Return2;
        boolean bl = Return2 = (m.getModifiers() & 8) != 0;
        if (!Return2 && isDefaultMthd != null) {
            try {
                Return2 |= ((Boolean)isDefaultMthd.invoke((Object)m, new Object[0])).booleanValue();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return Return2;
    }

    private static boolean isVarArgs(Method m) {
        if (isVarArgsMthd != null && m != null) {
            try {
                Object rc = isVarArgsMthd.invoke((Object)m, null);
                if (rc instanceof Boolean) {
                    return (Boolean)rc;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isVarArgs(Constructor c) {
        if (isVarArgsCtor != null && c != null) {
            try {
                Object rc = isVarArgsCtor.invoke((Object)c, null);
                if (rc instanceof Boolean) {
                    return (Boolean)rc;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public MyMethod(Method m, MyClass declaringClass) {
        this.method = m;
        this.varArgs = MyMethod.isVarArgs(m);
        if (this.method == null) {
            throw new NullPointerException();
        }
        this.name = m.getName();
        this.isDefault = MyMethod.isDefault(m);
        this.declaringClass = declaringClass;
        this.interfaceMethod = m.getDeclaringClass().isInterface();
    }

    public MyMethod(Constructor c, MyClass declaringClass) {
        this.ctor = c;
        this.varArgs = MyMethod.isVarArgs(c);
        if (this.ctor == null) {
            throw new NullPointerException();
        }
        this.name = "new";
        this.isDefault = false;
        this.declaringClass = declaringClass;
        this.interfaceMethod = false;
    }

    public MyMethod(MyClass declaringClass, boolean interfaceMethod, String name, MyClass retType, MyClass[] params, int modifiers, VariableNameList raising) {
        this(declaringClass, interfaceMethod, name, retType, params, modifiers, raising, false, false);
    }

    public MyMethod(MyClass declaringClass, boolean interfaceMethod, String name, MyClass retType, MyClass[] params, int modifiers, VariableNameList raising, boolean isDefault, boolean varargs) {
        this.varArgs = varargs;
        this.name = name;
        this.retType = retType;
        this.params = params;
        this.modifiers = new Integer(modifiers);
        if (raising == null) {
            this.exTypes = new MyClass[0];
        } else {
            this.exTypes = new MyClass[raising.getItemNum()];
            int i = 0;
            VariableName vn = raising.getFirst();
            while (vn != null) {
                this.exTypes[i] = vn.getType();
                ++i;
                vn = raising.getNext();
            }
        }
        this.isDefault = isDefault;
        this.declaringClass = declaringClass;
        this.interfaceMethod = interfaceMethod;
        if (name == null || retType == null || params == null) {
            throw new NullPointerException();
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        if (this.name == null) {
            if (this.method != null) {
                this.name = this.method.getName();
            } else if (this.ctor != null) {
                this.name = this.ctor.getName();
            }
        }
        return this.name;
    }

    public MyClass getReturnType() {
        if (this.retType == null && (this.method != null || this.ctor != null)) {
            if (this.method != null) {
                Type mType = this.method.getGenericReturnType();
                if (mType instanceof Class) {
                    this.retType = MyClass.getInstance((Class)mType);
                } else {
                    this.retType = this.declaringClass.getParameter(mType.getTypeName());
                    if (this.retType == null) {
                        this.retType = MyClass.getInstance(this.method.getReturnType());
                    }
                }
            } else {
                return this.declaringClass;
            }
        }
        return this.retType;
    }

    public boolean isInterfaceMethod() {
        return this.interfaceMethod;
    }

    public MyClass getDeclaringClass() {
        return this.declaringClass;
    }

    public MyClass[] getParameterTypes() {
        if (this.params == null && (this.method != null || this.ctor != null)) {
            Class<?>[] mParams;
            Type[] mTypes;
            if (this.method != null) {
                mTypes = this.method.getGenericParameterTypes();
                mParams = this.method.getParameterTypes();
            } else {
                mTypes = this.ctor.getGenericParameterTypes();
                mParams = this.ctor.getParameterTypes();
            }
            this.params = new MyClass[mTypes.length];
            for (int j = 0; j < this.params.length; ++j) {
                if (mTypes[j] instanceof Class) {
                    this.params[j] = MyClass.getInstance((Class)mTypes[j]);
                    continue;
                }
                this.params[j] = this.declaringClass.getParameter(mTypes[j].getTypeName());
                if (this.params[j] != null) continue;
                this.params[j] = MyClass.getInstance(mParams[j]);
            }
        }
        return this.params;
    }

    public MyClass[] getExceptionTypes() {
        if (this.exTypes == null && (this.method != null || this.ctor != null)) {
            Class<?>[] mParams;
            Type[] mTypes;
            if (this.method != null) {
                mTypes = this.method.getGenericExceptionTypes();
                mParams = this.method.getExceptionTypes();
            } else {
                mTypes = this.ctor.getGenericExceptionTypes();
                mParams = this.ctor.getExceptionTypes();
            }
            this.exTypes = new MyClass[mTypes.length];
            for (int j = 0; j < this.exTypes.length; ++j) {
                if (mTypes[j] instanceof Class) {
                    this.exTypes[j] = MyClass.getInstance((Class)mTypes[j]);
                    continue;
                }
                this.exTypes[j] = this.declaringClass.getParameter(mTypes[j].getTypeName());
                if (this.exTypes[j] != null) continue;
                this.exTypes[j] = MyClass.getInstance(mParams[j]);
            }
        }
        return this.exTypes;
    }

    public int getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = this.method != null ? new Integer(this.method.getModifiers()) : (this.ctor != null ? new Integer(this.ctor.getModifiers()) : new Integer(0));
        }
        return this.modifiers;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public boolean isStatic() {
        return this.modifiers != null && (this.modifiers & 8) != 0;
    }

    public boolean same(Method m) {
        if (this.name.equals(m.getName())) {
            Class<?>[] argParams;
            MyClass[] thisParams = this.getParameterTypes();
            if (thisParams.length == (argParams = m.getParameterTypes()).length) {
                Class<?> argReturn;
                for (int i = 0; i < thisParams.length; ++i) {
                    if (thisParams[i].isAssignableFrom(argParams[i]) && thisParams[i].isAssignableTo(argParams[i])) continue;
                    return false;
                }
                MyClass thisReturn = this.getReturnType();
                return thisReturn.isAssignableFrom(argReturn = m.getReturnType()) && thisReturn.isAssignableTo(argReturn);
            }
            return false;
        }
        return false;
    }

    public boolean equals(Object m) {
        return this.compareTo((MyMethod)m) == 0;
    }

    public int compareTo(Object o) {
        MyClass[] argParams;
        MyClass[] thisParams;
        if (!(o instanceof MyMethod)) {
            return -1;
        }
        MyMethod m = (MyMethod)o;
        int r = this.name.compareTo(m.name);
        if (r == 0 && (r = (thisParams = this.getParameterTypes()).length - (argParams = m.getParameterTypes()).length) == 0) {
            MyClass argReturn;
            for (int i = 0; i < thisParams.length; ++i) {
                if (thisParams[i].isAssignableFrom(argParams[i]) && thisParams[i].isAssignableTo(argParams[i])) continue;
                return thisParams[i].getName().compareTo(argParams[i].getName());
            }
            MyClass thisReturn = this.getReturnType();
            if (!thisReturn.isAssignableFrom(argReturn = m.getReturnType()) || !thisReturn.isAssignableTo(argReturn)) {
                return thisReturn.getName().compareTo(argReturn.getName());
            }
        }
        return r;
    }

    public boolean isIscobolClassMethod() {
        return this.method != null && this.method.getDeclaringClass() == IscobolClass.class;
    }

    public boolean same(MyMethod m) {
        return this.compareTo(m) == 0;
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.getReturnType().toString());
        Return2.append(" ");
        Return2.append(" " + this.getName());
        Return2.append("(");
        MyClass[] params = this.getParameterTypes();
        if (params != null && params.length > 0) {
            int i;
            for (i = 0; i < params.length - 1; ++i) {
                Return2.append(params[i].toString());
                Return2.append(",");
            }
            Return2.append(params[i].toString());
        }
        Return2.append(")");
        return Return2.toString();
    }

    static {
        Method m;
        try {
            m = Method.class.getDeclaredMethod("isVarArgs", null);
        }
        catch (NoSuchMethodException _ex) {
            m = null;
        }
        isVarArgsMthd = m;
        try {
            m = Constructor.class.getDeclaredMethod("isVarArgs", null);
        }
        catch (NoSuchMethodException _ex) {
            m = null;
        }
        isVarArgsCtor = m;
        try {
            m = Method.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException _ex) {
            m = null;
        }
        isDefaultMthd = m;
    }
}

