/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.StorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;

public class LocalStorageSection
extends StorageSection {
    VariableDeclarationList tlVars = new VariableDeclarationList();

    public LocalStorageSection(Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
        super(p, t, err, tk);
        if (t == null) {
            return;
        }
        tk = t.getToken();
        if (tk.getToknum() != 710) {
            throw new UnexpectedTokenException(tk, err);
        }
        if (this.tm.getToken().getToknum() != 10006) {
            this.error.print(188, 3, tk, "'.'");
            this.tm.ungetToken();
        }
        boolean isInterface = this.pc.isInterfaceChild();
        block6: while (true) {
            tk = this.tm.getToken();
            switch (tk.getToknum()) {
                case 10002: {
                    this.tm.ungetToken();
                    try {
                        this.memoryOffset += LocalStorageSection.calcAlign(this.memoryOffset, this.align);
                        VariableDeclaration vd = new VariableDeclaration(this, this.memoryOffset);
                        if (isInterface) {
                            throw new GeneralErrorException(249, 4, vd.getNameToken(), vd.getName(), this.error);
                        }
                        if (vd.threadLocal) {
                            this.tlVars.addItem(vd);
                            continue block6;
                        }
                        this.loadVariable(vd);
                        continue block6;
                    }
                    catch (GeneralErrorException e) {
                        while (true) {
                            if ((tk = this.tm.getToken()).getToknum() == 10006 || tk.getWord().length() < 1) continue block6;
                        }
                    }
                }
                case 475: {
                    this.exec(tk);
                    continue block6;
                }
            }
            break;
        }
        this.lastToken = tk;
        this.tm.ungetToken();
    }

    protected void loadVariable(VariableDeclaration vd) throws GeneralErrorException {
        this.vars.addItem(vd);
        this.pc.loadVariable(vd);
        int so = this.memoryOffset;
        if (vd.isExternal()) {
            vd.calcOffset(this.pc, 0);
        } else {
            vd.calcOffset(this.pc, this.memoryOffset);
            if (this.memIn1block) {
                if (vd.getRedefinesVar() != null) {
                    if ((so = vd.globalLen(so) + vd.getOffset()) > this.memoryOffset) {
                        this.memoryOffset = so;
                    }
                } else {
                    this.memoryOffset += vd.globalLen(so);
                }
            }
        }
    }
}

