/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;

public class If
extends Verb
implements CobolToken,
ErrorsNumbers {
    Condition cond;
    boolean hasElse;
    Block ifBlock;
    Block elseBlock;
    NextSentence ns;

    public If(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token nextSentence = null;
        this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
        if (!this.cond.isFullCondition()) {
            throw new IllegalConditionException(this.keyWord, this.error);
        }
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 763) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 596) {
            nextSentence = tk;
            tk = this.tm.getToken();
            if (tk.getToknum() != 715) {
                throw new ExpectedFoundException(tk, this.error, "SENTENCE");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10006 && tk.getToknum() != 418 && tk.getToknum() != 623 && tk.getToknum() != 434) {
                throw new ExpectedFoundException(tk, this.error, "ELSE|.");
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
            this.ifBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 418 || tk.getToknum() == 623) {
            this.hasElse = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 596) {
                nextSentence = tk;
                tk = this.tm.getToken();
                if (tk.getToknum() != 715) {
                    throw new ExpectedFoundException(tk, this.error, "SENTENCE");
                }
                tk = this.tm.getToken();
                if (tk.getToknum() != 10006 && tk.getToknum() != 418 && tk.getToknum() != 623 && tk.getToknum() != 434) {
                    throw new ExpectedFoundException(tk, this.error, "ELSE|.");
                }
            } else {
                this.tm.ungetToken();
                this.elseBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                tk = this.tm.getToken();
            }
        }
        if (tk.getToknum() != 434) {
            if (tk.getToknum() != 10006 && tk.getToknum() != 418) {
                this.error.print(154, 3, tk, "END-IF");
            }
            this.tm.ungetToken();
        } else if (nextSentence != null) {
            this.ns = new NextSentence(nextSentence, par, this.pc, this.tm, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        this.cond.check();
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append("if (");
        Return2.append(this.cond.getCode());
        Return2.append(")");
        if (this.ifBlock != null) {
            Return2.append(this.ifBlock.getCode());
        } else if (this.ns != null) {
            Return2.append("{");
            Return2.append(this.ns.getCode());
            Return2.append("}");
        } else {
            Return2.append("{ // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
        }
        if (this.hasElse) {
            if (this.elseBlock != null) {
                Return2.append(" else ");
                Return2.append(this.elseBlock.getCode());
            } else if (this.ns != null) {
                Return2.append(" else {" + this.ns.getCode());
                Return2.append("}");
            } else {
                Return2.append(" else { // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
            }
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public Block getIfBlock() {
        return this.ifBlock;
    }

    public Block getElseBlock() {
        return this.elseBlock;
    }

    public Condition getCondition() {
        return this.cond;
    }

    public NextSentence getNextSentence() {
        return this.ns;
    }

    public boolean hasElse() {
        return this.hasElse;
    }
}

